import { BAlert } from 'bootstrap-vue-next/components/BAlert';
import { defineComponent, useAttrs, computed, mergeProps, unref, withCtx, renderSlot, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderSlot } from 'vue/server-renderer';
import { d as defineBlock, a as additionalFields } from './block.definition.mjs';

const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "AlertBlock",
  __ssrInlineRender: true,
  setup(__props) {
    defineBlock({
      fields: {
        ...additionalFields("classes", "styles")
      }
    });
    const attrs = useAttrs();
    const blockProps = computed(() => {
      const { variant, dismissible, customClasses, customStyles } = attrs;
      return {
        variant: variant || void 0,
        dismissible: dismissible || void 0,
        class: customClasses || void 0,
        style: customStyles || void 0
      };
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_BAlert = BAlert;
      _push(ssrRenderComponent(_component_BAlert, mergeProps(unref(blockProps), _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            ssrRenderSlot(_ctx.$slots, "default", {}, null, _push2, _parent2, _scopeId);
          } else {
            return [
              renderSlot(_ctx.$slots, "default")
            ];
          }
        }),
        _: 3
      }, _parent));
    };
  }
});

const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("blocks/AlertBlock.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=AlertBlock.vue.mjs.map
