import { Carousel, Navigation, Pagination } from 'vue3-carousel/dist/carousel';
import { defineComponent, useAttrs, computed, mergeProps, unref, createSlots, withCtx, renderSlot, createBlock, createCommentVNode, openBlock, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderSlot } from 'vue/server-renderer';
import { d as defineBlock, a as additionalFields } from './block.definition.mjs';
import { e as _export_sfc } from './server.mjs';
import '../nitro/nitro.mjs';
import 'nodemailer';
import 'zod/v4';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'crypto';
import 'fs-extra';
import 'path';
import 'node:url';
import 'fs';
import 'mime-types';
import '@antfu/utils';
import 'dot-prop';
import 'redis';
import 'consola';
import 'pg';
import 'sequelize';
import 'pg-connection-string';
import 'colorette';
import '@aws-sdk/client-s3';
import 'jsonwebtoken';
import 'nanoid';
import 'pluralize-esm';
import 'argon2';
import 'sharp';
import 'accept-language-parser';
import 'vue-router';
import 'bootstrap-vue-next/directives';
import 'bootstrap-vue-next/plugins/createBootstrap';
import 'bootstrap-vue-next/components/BContainer';
import 'bootstrap-vue-next/components/BImg';
import 'bootstrap-vue-next/components/BLink';

const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "CarouselBlock",
  __ssrInlineRender: true,
  setup(__props) {
    defineBlock({
      fields: {
        ...additionalFields("classes", "styles", "responsive_control")
      }
    });
    const attrs = useAttrs();
    const blockProps = computed(() => {
      const {
        navigation,
        pagination,
        height,
        itemsToShow,
        itemsToScroll,
        gap,
        snapAlign,
        dir,
        autoplay,
        autoplayDelay,
        wrapAround,
        pauseAutoplayOnHover,
        mouseWheel,
        mouseDrag,
        mouseDragThreshold,
        touchDrag,
        touchDragThreshold,
        preventExcessiveDragging,
        slideEffect,
        transition,
        customClasses,
        customStyles
      } = attrs;
      return {
        carousel: {
          height,
          itemsToShow,
          itemsToScroll,
          gap: gap || void 0,
          snapAlign: itemsToShow > 1 ? snapAlign : void 0,
          dir,
          autoplay: autoplay ? autoplayDelay : void 0,
          wrapAround,
          pauseAutoplayOnHover,
          mouseWheel,
          mouseDrag: mouseDrag ? { threshold: mouseDragThreshold } : false,
          touchDrag: touchDrag ? { threshold: touchDragThreshold } : false,
          preventExcessiveDragging,
          clamp: true,
          // will clamp itemsToShow to the number of available slides
          slideEffect,
          transition: transition || void 0,
          class: customClasses || void 0,
          style: customStyles || void 0
        },
        addons: {
          navigation,
          pagination
        }
      };
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Carousel = Carousel;
      const _component_Navigation = Navigation;
      const _component_Pagination = Pagination;
      _push(ssrRenderComponent(_component_Carousel, mergeProps(unref(blockProps).carousel, _attrs), createSlots({
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            ssrRenderSlot(_ctx.$slots, "default", {}, null, _push2, _parent2, _scopeId);
          } else {
            return [
              renderSlot(_ctx.$slots, "default", {}, void 0, true)
            ];
          }
        }),
        _: 2
      }, [
        unref(blockProps).addons.navigation || unref(blockProps).addons.pagination ? {
          name: "addons",
          fn: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (unref(blockProps).addons.navigation) {
                _push2(ssrRenderComponent(_component_Navigation, null, null, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
              if (unref(blockProps).addons.pagination) {
                _push2(ssrRenderComponent(_component_Pagination, null, null, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                unref(blockProps).addons.navigation ? (openBlock(), createBlock(_component_Navigation, { key: 0 })) : createCommentVNode("", true),
                unref(blockProps).addons.pagination ? (openBlock(), createBlock(_component_Pagination, { key: 1 })) : createCommentVNode("", true)
              ];
            }
          }),
          key: "0"
        } : void 0
      ]), _parent));
    };
  }
});

const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("blocks/CarouselBlock.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const CarouselBlock = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-7339834b"]]);

export { CarouselBlock as default };
//# sourceMappingURL=CarouselBlock.vue.mjs.map
