import { defineComponent, useAttrs, computed, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderSlot } from 'vue/server-renderer';
import { d as defineBlock, a as additionalFields, p as parseAdditionalFields } from './block.definition.mjs';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "CarouselSlideContentBlock",
  __ssrInlineRender: true,
  setup(__props) {
    defineBlock({
      fields: {
        ...additionalFields("responsive_control")
      }
    });
    const attrs = useAttrs();
    const blockProps = computed(() => {
      const { img, imgPosition, imgRepeat, imgSize } = attrs;
      return {
        img: {
          style: {
            backgroundImage: img ? `url(${img.src})` : void 0,
            backgroundSize: imgSize || void 0,
            backgroundPosition: imgPosition || void 0,
            backgroundRepeat: imgRepeat || void 0
          },
          ...parseAdditionalFields(attrs)
        }
      };
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "w-100 h-100 d-flex flex-column justify-content-center align-items-center" }, unref(blockProps).img, _attrs))}>`);
      ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
      _push(`</div>`);
    };
  }
});

const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("blocks/CarouselSlideContentBlock.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=CarouselSlideContentBlock.vue.mjs.map
