import { BContainer } from 'bootstrap-vue-next/components/BContainer';
import { defineComponent, useAttrs, computed, mergeProps, unref, withCtx, renderSlot, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderSlot } from 'vue/server-renderer';
import { d as defineBlock, a as additionalFields, g as gutterSelectField } from './block.definition.mjs';

const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "ContainerBlock",
  __ssrInlineRender: true,
  setup(__props) {
    defineBlock({
      fields: {
        gutterX: gutterSelectField(),
        gutterY: gutterSelectField(),
        ...additionalFields("classes", "styles", "responsive_control")
      }
    });
    const attrs = useAttrs();
    const blockProps = computed(() => {
      const fields = attrs;
      return {
        fluid: fields.fluid === "*" || fields.fluid || void 0,
        gutterX: fields.gutterX || void 0,
        gutterY: fields.gutterY || void 0,
        class: fields.customClasses || void 0,
        style: fields.customStyles || void 0
      };
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_BContainer = BContainer;
      _push(ssrRenderComponent(_component_BContainer, mergeProps(unref(blockProps), _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            ssrRenderSlot(_ctx.$slots, "default", {}, null, _push2, _parent2, _scopeId);
          } else {
            return [
              renderSlot(_ctx.$slots, "default")
            ];
          }
        }),
        _: 3
      }, _parent));
    };
  }
});

const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("blocks/ContainerBlock.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=ContainerBlock.vue.mjs.map
