import { BRow } from 'bootstrap-vue-next/components/BContainer';
import { defineComponent, useAttrs, computed, mergeProps, unref, withCtx, renderSlot, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderSlot } from 'vue/server-renderer';
import { d as defineBlock, a as additionalFields, b as alignmentVerticalSelectField, c as alignmentJustifyContentSelectField, e as alignmentContentSelectField, f as colsNumbersSelectField, g as gutterSelectField } from './block.definition.mjs';

const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "ContainerRowBlock",
  __ssrInlineRender: true,
  setup(__props) {
    defineBlock({
      fields: {
        gutterX: gutterSelectField({
          additional: {
            conditionalLogic: {
              noGutters: { ne: true }
            }
          }
        }),
        gutterY: gutterSelectField({
          additional: {
            conditionalLogic: {
              noGutters: { ne: true }
            }
          }
        }),
        cols: colsNumbersSelectField(),
        colsSm: colsNumbersSelectField(),
        colsMd: colsNumbersSelectField(),
        colsLg: colsNumbersSelectField(),
        colsXl: colsNumbersSelectField(),
        colsXxl: colsNumbersSelectField(),
        alignContent: alignmentContentSelectField(),
        alignH: alignmentJustifyContentSelectField(),
        alignV: alignmentVerticalSelectField(),
        ...additionalFields("classes", "styles", "responsive_control")
      }
    });
    const attrs = useAttrs();
    const blockProps = computed(() => {
      const {
        noGutters,
        gutterX,
        gutterY,
        customClasses,
        customStyles,
        cols,
        colsLg,
        colsMd,
        colsSm,
        colsXl,
        colsXxl,
        alignContent,
        alignH,
        alignV
      } = attrs;
      return {
        noGutters: noGutters || void 0,
        gutterX: !noGutters && gutterX || void 0,
        gutterY: !noGutters && gutterY || void 0,
        class: customClasses || void 0,
        style: customStyles || void 0,
        cols: cols || void 0,
        colsLg: colsLg || void 0,
        colsSm: colsSm || void 0,
        colsMd: colsMd || void 0,
        colsXl: colsXl || void 0,
        colsXxl: colsXxl || void 0,
        alignContent: alignContent || void 0,
        alignH: alignH || void 0,
        alignV: alignV || void 0
      };
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_BRow = BRow;
      _push(ssrRenderComponent(_component_BRow, mergeProps(unref(blockProps), _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            ssrRenderSlot(_ctx.$slots, "default", {}, null, _push2, _parent2, _scopeId);
          } else {
            return [
              renderSlot(_ctx.$slots, "default")
            ];
          }
        }),
        _: 3
      }, _parent));
    };
  }
});

const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("blocks/ContainerRowBlock.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=ContainerRowBlock.vue.mjs.map
