import { mergeProps, useSSRContext, defineComponent, withAsyncContext, unref } from 'vue';
import { ssrRenderAttrs, ssrRenderTeleport, ssrRenderAttr, ssrRenderComponent } from 'vue/server-renderer';
import { e as _export_sfc, a as useRuntimeConfig } from './server.mjs';
import { c as useState, l as loadTranslatableStrings, p as pruviousFetch, _ as __ } from './_...slug_.vue.mjs';
import { u as useUser } from './EditLink.vue.mjs';
import '../nitro/nitro.mjs';
import 'nodemailer';
import 'zod/v4';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'crypto';
import 'fs-extra';
import 'path';
import 'node:url';
import 'fs';
import 'mime-types';
import '@antfu/utils';
import 'dot-prop';
import 'redis';
import 'consola';
import 'pg';
import 'sequelize';
import 'pg-connection-string';
import 'colorette';
import '@aws-sdk/client-s3';
import 'jsonwebtoken';
import 'nanoid';
import 'pluralize-esm';
import 'argon2';
import 'sharp';
import 'accept-language-parser';
import 'vue-router';
import 'bootstrap-vue-next/directives';
import 'bootstrap-vue-next/plugins/createBootstrap';
import 'bootstrap-vue-next/components/BContainer';
import 'bootstrap-vue-next/components/BImg';
import 'bootstrap-vue-next/components/BLink';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'unhead/plugins';

const usePruviousDashboard = () => useState("pruvious-dashboard", () => ({
  blocks: {},
  collection: null,
  collections: {},
  initialized: false,
  installed: false,
  isCacheActive: false,
  legalLinks: [],
  loaded: false,
  menu: [],
  routeParams: [],
  refresh: false
}));

function getCapabilities(user) {
  var _a;
  return user ? Object.fromEntries(
    [...user.capabilities, ...((_a = user.role) == null ? void 0 : _a.capabilities) ?? []].map((capability) => [capability, true])
  ) : {};
}

const _sfc_main$2 = {};
function _sfc_ssrRender$1(_ctx, _push, _parent, _attrs) {
  _push(`<svg${ssrRenderAttrs(mergeProps({
    fill: "none",
    height: "24",
    stroke: "currentColor",
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    "stroke-width": "2",
    viewBox: "0 0 24 24",
    width: "24",
    xmlns: "http://www.w3.org/2000/svg",
    class: "icon icon-tabler icon-tabler-pencil"
  }, _attrs))}><path d="M0 0h24v24H0z" fill="none" stroke="none"></path><path d="M4 20h4l10.5 -10.5a1.5 1.5 0 0 0 -4 -4l-10.5 10.5v4"></path><line x1="13.5" x2="17.5" y1="6.5" y2="10.5"></line></svg>`);
}
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/icons/Pencil.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const __nuxt_component_1 = /* @__PURE__ */ _export_sfc(_sfc_main$2, [["ssrRender", _sfc_ssrRender$1]]);

const _sfc_main$1 = {};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs) {
  _push(`<svg${ssrRenderAttrs(mergeProps({
    fill: "none",
    height: "24",
    stroke: "currentColor",
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    "stroke-width": "2",
    viewBox: "0 0 24 24",
    width: "24",
    xmlns: "http://www.w3.org/2000/svg",
    class: "icon icon-tabler icon-tabler-adjustments-horizontal"
  }, _attrs))}><path d="M0 0h24v24H0z" fill="none" stroke="none"></path><circle cx="14" cy="6" r="2"></circle><line x1="4" x2="12" y1="6" y2="6"></line><line x1="16" x2="20" y1="6" y2="6"></line><circle cx="8" cy="12" r="2"></circle><line x1="4" x2="6" y1="12" y2="12"></line><line x1="10" x2="20" y1="12" y2="12"></line><circle cx="17" cy="18" r="2"></circle><line x1="4" x2="15" y1="18" y2="18"></line><line x1="19" x2="20" y1="18" y2="18"></line></svg>`);
}
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/icons/AdjustmentsHorizontal.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const __nuxt_component_0 = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["ssrRender", _sfc_ssrRender]]);

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "EditLinkContent",
  __ssrInlineRender: true,
  props: {
    collection: {
      type: String,
      required: true
    },
    recordId: {
      type: Number
    }
  },
  async setup(__props) {
    var _a;
    let __temp, __restore;
    const props = __props;
    const dashboard = usePruviousDashboard();
    const runtimeConfig = useRuntimeConfig();
    const user = useUser();
    const capabilities = getCapabilities(user.value);
    const canUpdate = ((_a = user.value) == null ? void 0 : _a.isAdmin) || !!(capabilities[`collection-${props.collection}-read`] && capabilities[`collection-${props.collection}-update`] && capabilities["collection-previews-create"] && capabilities["collection-previews-read"] && capabilities["collection-previews-update"]);
    [__temp, __restore] = withAsyncContext(() => loadTranslatableStrings("pruvious-dashboard")), await __temp, __restore();
    if (!dashboard.value.loaded) {
      const dashboardOptions = ([__temp, __restore] = withAsyncContext(() => pruviousFetch("dashboard.get")), __temp = await __temp, __restore(), __temp);
      dashboard.value = { ...dashboard.value, ...dashboardOptions.success ? dashboardOptions.data : {} };
      dashboard.value.loaded = true;
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_PruviousIconAdjustmentsHorizontal = __nuxt_component_0;
      const _component_PruviousIconPencil = __nuxt_component_1;
      ssrRenderTeleport(_push, (_push2) => {
        _push2(`<div class="pruvious-floater"><a${ssrRenderAttr("href", `/${unref(runtimeConfig).public.pruvious.dashboardPrefix}`)}${ssrRenderAttr("title", unref(__)("pruvious-dashboard", "Dashboard"))}>`);
        _push2(ssrRenderComponent(_component_PruviousIconAdjustmentsHorizontal, { class: "icon" }, null, _parent));
        _push2(`</a>`);
        if (unref(canUpdate)) {
          _push2(`<a${ssrRenderAttr("href", `/${unref(runtimeConfig).public.pruvious.dashboardPrefix}/collections/${__props.collection}/${__props.recordId}`)}${ssrRenderAttr("title", unref(__)("pruvious-dashboard", "Edit"))}>`);
          _push2(ssrRenderComponent(_component_PruviousIconPencil, { class: "icon" }, null, _parent));
          _push2(`</a>`);
        } else {
          _push2(`<!---->`);
        }
        _push2(`</div>`);
      }, "body", false, _parent);
    };
  }
});

const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/EditLinkContent.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=EditLinkContent.vue.mjs.map
