import { BForm } from 'bootstrap-vue-next/components/BForm';
import { BRow, BCol } from 'bootstrap-vue-next/components/BContainer';
import { BFormGroup } from 'bootstrap-vue-next/components/BFormGroup';
import { BFormCheckbox } from 'bootstrap-vue-next/components/BFormCheckbox';
import { BFormSelect } from 'bootstrap-vue-next/components/BFormSelect';
import { BFormRadioGroup } from 'bootstrap-vue-next/components/BFormRadio';
import { BFormTextarea } from 'bootstrap-vue-next/components/BFormTextarea';
import { BFormInput } from 'bootstrap-vue-next/components/BFormInput';
import { BAlert } from 'bootstrap-vue-next/components/BAlert';
import { BButton } from 'bootstrap-vue-next/components/BButton';
import { defineComponent, useAttrs, computed, ref, unref, mergeProps, withCtx, createBlock, createCommentVNode, createVNode, openBlock, toDisplayString, Fragment, renderList, createTextVNode, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderStyle, ssrRenderClass } from 'vue/server-renderer';
import { d as defineBlock, a as additionalFields } from './block.definition.mjs';
import { n as navigateTo } from './server.mjs';
import { K as FetchError } from '../nitro/nitro.mjs';
import 'vue-router';
import 'bootstrap-vue-next/directives';
import 'bootstrap-vue-next/plugins/createBootstrap';
import 'bootstrap-vue-next/components/BImg';
import 'bootstrap-vue-next/components/BLink';
import 'nodemailer';
import 'zod/v4';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'crypto';
import 'fs-extra';
import 'path';
import 'node:url';
import 'fs';
import 'mime-types';
import '@antfu/utils';
import 'dot-prop';
import 'redis';
import 'consola';
import 'pg';
import 'sequelize';
import 'pg-connection-string';
import 'colorette';
import '@aws-sdk/client-s3';
import 'jsonwebtoken';
import 'nanoid';
import 'pluralize-esm';
import 'argon2';
import 'sharp';
import 'accept-language-parser';

const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "FormBlock",
  __ssrInlineRender: true,
  setup(__props) {
    defineBlock({
      fields: {
        ...additionalFields("classes", "styles")
      }
    });
    const attrs = useAttrs();
    const blockProps = computed(() => {
      const {
        form,
        showTitle,
        showDescription,
        onSubmit,
        redirectTo,
        btnLabel,
        btnClass,
        btnStyle,
        showAlert,
        alertContent,
        alertClass,
        alertStyle,
        alertPreview
      } = attrs;
      return {
        form,
        showTitle,
        showDescription,
        onSubmit,
        redirectTo,
        btnLabel,
        btnClass,
        btnStyle,
        showAlert,
        alertContent,
        alertClass,
        alertStyle,
        alertPreview
      };
    });
    const formStatus = ref("idle");
    const disabled = computed(() => formStatus.value !== "idle");
    const alertError = ref({
      title: "",
      body: "",
      show: false
    });
    const formErrors = ref();
    const submitForm = async () => {
      if (!formData.value) {
        return;
      }
      formErrors.value = void 0;
      formStatus.value = "submitting";
      const body = new FormData();
      for (const f of formData.value.fields) {
        if (f.value ?? false) {
          body.append(f.name, String(f.value));
        }
      }
      const res = await $fetch(`/api/forms/${blockProps.value.form.id}`, {
        method: "POST",
        body
      }).then(() => ({
        success: true
      })).catch((error) => {
        formStatus.value = "idle";
        return {
          success: false,
          error
        };
      });
      if (!res.success) {
        if (res.error instanceof FetchError && res.error.statusCode && res.error.statusCode < 500) {
          formErrors.value = {};
          for (const key in res.error.data.data) {
            formErrors.value[key] = res.error.data.data[key].join("\n");
          }
        } else if (res.error === void 0) {
          alertError.value = {
            title: "Неизвестная ошибка",
            body: "Не удалось отправить форму",
            show: true
          };
        } else if (res.error.statusCode === 400) {
          alertError.value = {
            title: "Ошибка в форме",
            body: res.error.data.message,
            show: true
          };
        }
        return;
      }
      if (blockProps.value.onSubmit === "redirect" && blockProps.value.redirectTo) {
        await navigateTo(blockProps.value.redirectTo);
      } else {
        formStatus.value = "success";
        if (blockProps.value.onSubmit === "reset") {
          formData.value = resetFormData();
        }
      }
    };
    const resetFormData = () => {
      const form = blockProps.value.form;
      if (!form) return void 0;
      return {
        id: form.id,
        title: form.title,
        description: form.description,
        fields: form.fields.map((f) => {
          var _a;
          const field = {
            type: f.type,
            label: f.label,
            name: f.name,
            description: f.description,
            placeholder: f.placeholder,
            required: f.required,
            labelClass: f.labelClass,
            labelStyle: f.labelStyle,
            colsXs: f.colsXs,
            colsSm: f.colsSm,
            colsMd: f.colsMd,
            colsLg: f.colsLg,
            colsXl: f.colsXl,
            colsXxl: f.colsXxl
          };
          switch (field.type) {
            case "text":
            case "email":
            case "url":
            case "textarea":
            case "password":
            case "tel":
              field.minLength = f.minLength || void 0;
              field.maxLength = f.maxLength || void 0;
              field.value = f.defaultString || void 0;
              break;
            case "checkbox":
              field.value = f.defaultBoolean || void 0;
              break;
            case "date":
              field.value = f.defaultDate ? new Date(f.defaultDate).toISOString().split("T")[0] : void 0;
              break;
            case "time":
              field.value = f.defaultTime ? new Date(f.defaultTime).toISOString().split("T")[1].slice(0, 5) : void 0;
              break;
            case "number":
            case "range":
              field.min = f.min ?? void 0;
              field.max = f.max ?? void 0;
              field.value = ((_a = f.defaultNumber) == null ? void 0 : _a.toString()) || void 0;
              break;
            case "select":
            case "radio":
              field.items = f.items ? f.items.map((item) => ({
                label: item.label ?? "",
                value: item.value
              })) : void 0;
              field.value = f.defaultString || void 0;
              break;
            default: {
              const fieldType = field;
              throw new Error(`Unsupported field type: ${fieldType}`);
            }
          }
          return field;
        })
      };
    };
    const formData = ref(resetFormData());
    return (_ctx, _push, _parent, _attrs) => {
      const _component_BForm = BForm;
      const _component_BRow = BRow;
      const _component_BCol = BCol;
      const _component_BFormGroup = BFormGroup;
      const _component_BFormCheckbox = BFormCheckbox;
      const _component_BFormSelect = BFormSelect;
      const _component_BFormRadioGroup = BFormRadioGroup;
      const _component_BFormTextarea = BFormTextarea;
      const _component_BFormInput = BFormInput;
      const _component_BAlert = BAlert;
      const _component_BButton = BButton;
      if (unref(formData)) {
        _push(ssrRenderComponent(_component_BForm, mergeProps({
          class: "container-fluid",
          onSubmit: submitForm,
          onReset: resetFormData
        }, _attrs), {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (unref(blockProps).showDescription || unref(blockProps).showTitle) {
                _push2(`<div class="mb-4"${_scopeId}>`);
                if (unref(blockProps).showTitle) {
                  _push2(`<h2${_scopeId}>${ssrInterpolate(unref(formData).title)}</h2>`);
                } else {
                  _push2(`<!---->`);
                }
                if (unref(blockProps).showDescription && unref(formData).description) {
                  _push2(`<p${_scopeId}>${ssrInterpolate(unref(formData).description)}</p>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(`</div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(ssrRenderComponent(_component_BRow, null, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  var _a, _b;
                  if (_push3) {
                    _push3(`<!--[-->`);
                    ssrRenderList((_a = unref(formData)) == null ? void 0 : _a.fields, (field, idx) => {
                      _push3(ssrRenderComponent(_component_BCol, {
                        key: idx,
                        cols: field.colsXs || void 0,
                        sm: field.colsSm || void 0,
                        md: field.colsMd || void 0,
                        lg: field.colsLg || void 0,
                        xl: field.colsXl || void 0,
                        xxl: field.colsXxl || void 0
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          var _a2, _b2, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t;
                          if (_push4) {
                            if (field.type === "checkbox") {
                              _push4(ssrRenderComponent(_component_BFormGroup, {
                                description: field.description || void 0,
                                "invalid-feedback": (_a2 = unref(formErrors)) == null ? void 0 : _a2[field.name],
                                state: !((_b2 = unref(formErrors)) == null ? void 0 : _b2[field.name]) && null,
                                class: "mb-4"
                              }, {
                                default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                                  if (_push5) {
                                    _push5(ssrRenderComponent(_component_BFormCheckbox, {
                                      modelValue: field.value,
                                      "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                        var _a3;
                                        return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                      }],
                                      disabled: unref(disabled),
                                      required: field.required,
                                      name: field.name
                                    }, {
                                      default: withCtx((_5, _push6, _parent6, _scopeId5) => {
                                        if (_push6) {
                                          if (field.required) {
                                            _push6(`<span style="${ssrRenderStyle({ "color": "red" })}"${_scopeId5}>* </span>`);
                                          } else {
                                            _push6(`<!---->`);
                                          }
                                          _push6(`<span class="${ssrRenderClass(field.labelClass)}" style="${ssrRenderStyle(field.labelStyle)}"${_scopeId5}>${ssrInterpolate(field.label)}</span>`);
                                        } else {
                                          return [
                                            field.required ? (openBlock(), createBlock("span", {
                                              key: 0,
                                              style: { "color": "red" }
                                            }, "* ")) : createCommentVNode("", true),
                                            createVNode("span", {
                                              class: field.labelClass,
                                              style: field.labelStyle
                                            }, toDisplayString(field.label), 7)
                                          ];
                                        }
                                      }),
                                      _: 2
                                    }, _parent5, _scopeId4));
                                  } else {
                                    return [
                                      createVNode(_component_BFormCheckbox, {
                                        modelValue: field.value,
                                        "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                          var _a3;
                                          return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                        }],
                                        disabled: unref(disabled),
                                        required: field.required,
                                        name: field.name
                                      }, {
                                        default: withCtx(() => [
                                          field.required ? (openBlock(), createBlock("span", {
                                            key: 0,
                                            style: { "color": "red" }
                                          }, "* ")) : createCommentVNode("", true),
                                          createVNode("span", {
                                            class: field.labelClass,
                                            style: field.labelStyle
                                          }, toDisplayString(field.label), 7)
                                        ]),
                                        _: 2
                                      }, 1032, ["modelValue", "onUpdate:modelValue", "disabled", "required", "name"])
                                    ];
                                  }
                                }),
                                _: 2
                              }, _parent4, _scopeId3));
                            } else if (field.type === "select") {
                              _push4(ssrRenderComponent(_component_BFormGroup, {
                                description: field.description || void 0,
                                "invalid-feedback": (_c = unref(formErrors)) == null ? void 0 : _c[field.name],
                                state: !((_d = unref(formErrors)) == null ? void 0 : _d[field.name]) && null,
                                class: "mb-4"
                              }, {
                                label: withCtx((_4, _push5, _parent5, _scopeId4) => {
                                  if (_push5) {
                                    if (field.required) {
                                      _push5(`<span style="${ssrRenderStyle({ "color": "red" })}"${_scopeId4}>* </span>`);
                                    } else {
                                      _push5(`<!---->`);
                                    }
                                    _push5(`<span class="${ssrRenderClass(field.labelClass)}" style="${ssrRenderStyle(field.labelStyle)}"${_scopeId4}>${ssrInterpolate(field.label)}</span>`);
                                  } else {
                                    return [
                                      field.required ? (openBlock(), createBlock("span", {
                                        key: 0,
                                        style: { "color": "red" }
                                      }, "* ")) : createCommentVNode("", true),
                                      createVNode("span", {
                                        class: field.labelClass,
                                        style: field.labelStyle
                                      }, toDisplayString(field.label), 7)
                                    ];
                                  }
                                }),
                                default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                                  if (_push5) {
                                    _push5(ssrRenderComponent(_component_BFormSelect, {
                                      modelValue: field.value,
                                      "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                        var _a3;
                                        return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                      }],
                                      disabled: unref(disabled),
                                      required: field.required,
                                      name: field.name,
                                      options: field.items || void 0,
                                      "text-field": "label"
                                    }, {
                                      default: withCtx((_5, _push6, _parent6, _scopeId5) => {
                                        if (_push6) {
                                          _push6(`<span class="${ssrRenderClass(field.labelClass)}" style="${ssrRenderStyle(field.labelStyle)}"${_scopeId5}>${ssrInterpolate(field.label)}</span>`);
                                        } else {
                                          return [
                                            createVNode("span", {
                                              class: field.labelClass,
                                              style: field.labelStyle
                                            }, toDisplayString(field.label), 7)
                                          ];
                                        }
                                      }),
                                      _: 2
                                    }, _parent5, _scopeId4));
                                  } else {
                                    return [
                                      createVNode(_component_BFormSelect, {
                                        modelValue: field.value,
                                        "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                          var _a3;
                                          return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                        }],
                                        disabled: unref(disabled),
                                        required: field.required,
                                        name: field.name,
                                        options: field.items || void 0,
                                        "text-field": "label"
                                      }, {
                                        default: withCtx(() => [
                                          createVNode("span", {
                                            class: field.labelClass,
                                            style: field.labelStyle
                                          }, toDisplayString(field.label), 7)
                                        ]),
                                        _: 2
                                      }, 1032, ["modelValue", "onUpdate:modelValue", "disabled", "required", "name", "options"])
                                    ];
                                  }
                                }),
                                _: 2
                              }, _parent4, _scopeId3));
                            } else if (field.type === "radio") {
                              _push4(ssrRenderComponent(_component_BFormGroup, {
                                description: field.description || void 0,
                                "invalid-feedback": (_e = unref(formErrors)) == null ? void 0 : _e[field.name],
                                state: !((_f = unref(formErrors)) == null ? void 0 : _f[field.name]) && null,
                                class: "mb-4"
                              }, {
                                label: withCtx((_4, _push5, _parent5, _scopeId4) => {
                                  if (_push5) {
                                    if (field.required) {
                                      _push5(`<span style="${ssrRenderStyle({ "color": "red" })}"${_scopeId4}>* </span>`);
                                    } else {
                                      _push5(`<!---->`);
                                    }
                                    _push5(`<span class="${ssrRenderClass(field.labelClass)}" style="${ssrRenderStyle(field.labelStyle)}"${_scopeId4}>${ssrInterpolate(field.label)}</span>`);
                                  } else {
                                    return [
                                      field.required ? (openBlock(), createBlock("span", {
                                        key: 0,
                                        style: { "color": "red" }
                                      }, "* ")) : createCommentVNode("", true),
                                      createVNode("span", {
                                        class: field.labelClass,
                                        style: field.labelStyle
                                      }, toDisplayString(field.label), 7)
                                    ];
                                  }
                                }),
                                default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                                  if (_push5) {
                                    _push5(ssrRenderComponent(_component_BFormRadioGroup, {
                                      modelValue: field.value,
                                      "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                        var _a3;
                                        return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                      }],
                                      disabled: unref(disabled),
                                      required: field.required,
                                      name: field.name,
                                      options: field.items || void 0,
                                      "text-field": "label"
                                    }, null, _parent5, _scopeId4));
                                  } else {
                                    return [
                                      createVNode(_component_BFormRadioGroup, {
                                        modelValue: field.value,
                                        "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                          var _a3;
                                          return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                        }],
                                        disabled: unref(disabled),
                                        required: field.required,
                                        name: field.name,
                                        options: field.items || void 0,
                                        "text-field": "label"
                                      }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "required", "name", "options"])
                                    ];
                                  }
                                }),
                                _: 2
                              }, _parent4, _scopeId3));
                            } else if (field.type === "textarea") {
                              _push4(ssrRenderComponent(_component_BFormGroup, {
                                description: field.description || void 0,
                                "invalid-feedback": (_g = unref(formErrors)) == null ? void 0 : _g[field.name],
                                state: !((_h = unref(formErrors)) == null ? void 0 : _h[field.name]) && null,
                                class: "mb-4"
                              }, {
                                label: withCtx((_4, _push5, _parent5, _scopeId4) => {
                                  if (_push5) {
                                    if (field.required) {
                                      _push5(`<span style="${ssrRenderStyle({ "color": "red" })}"${_scopeId4}>* </span>`);
                                    } else {
                                      _push5(`<!---->`);
                                    }
                                    _push5(`<span class="${ssrRenderClass(field.labelClass)}" style="${ssrRenderStyle(field.labelStyle)}"${_scopeId4}>${ssrInterpolate(field.label)}</span>`);
                                  } else {
                                    return [
                                      field.required ? (openBlock(), createBlock("span", {
                                        key: 0,
                                        style: { "color": "red" }
                                      }, "* ")) : createCommentVNode("", true),
                                      createVNode("span", {
                                        class: field.labelClass,
                                        style: field.labelStyle
                                      }, toDisplayString(field.label), 7)
                                    ];
                                  }
                                }),
                                default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                                  if (_push5) {
                                    _push5(ssrRenderComponent(_component_BFormTextarea, {
                                      modelValue: field.value,
                                      "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                        var _a3;
                                        return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                      }],
                                      disabled: unref(disabled),
                                      placeholder: field.placeholder || void 0,
                                      required: field.required,
                                      name: field.name
                                    }, null, _parent5, _scopeId4));
                                  } else {
                                    return [
                                      createVNode(_component_BFormTextarea, {
                                        modelValue: field.value,
                                        "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                          var _a3;
                                          return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                        }],
                                        disabled: unref(disabled),
                                        placeholder: field.placeholder || void 0,
                                        required: field.required,
                                        name: field.name
                                      }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "placeholder", "required", "name"])
                                    ];
                                  }
                                }),
                                _: 2
                              }, _parent4, _scopeId3));
                            } else {
                              _push4(ssrRenderComponent(_component_BFormGroup, {
                                description: field.description || void 0,
                                "invalid-feedback": (_i = unref(formErrors)) == null ? void 0 : _i[field.name],
                                state: !((_j = unref(formErrors)) == null ? void 0 : _j[field.name]) && null,
                                class: "mb-4"
                              }, {
                                label: withCtx((_4, _push5, _parent5, _scopeId4) => {
                                  if (_push5) {
                                    if (field.required) {
                                      _push5(`<span style="${ssrRenderStyle({ "color": "red" })}"${_scopeId4}>* </span>`);
                                    } else {
                                      _push5(`<!---->`);
                                    }
                                    _push5(`<span class="${ssrRenderClass(field.labelClass)}" style="${ssrRenderStyle(field.labelStyle)}"${_scopeId4}>${ssrInterpolate(field.label)}</span>`);
                                  } else {
                                    return [
                                      field.required ? (openBlock(), createBlock("span", {
                                        key: 0,
                                        style: { "color": "red" }
                                      }, "* ")) : createCommentVNode("", true),
                                      createVNode("span", {
                                        class: field.labelClass,
                                        style: field.labelStyle
                                      }, toDisplayString(field.label), 7)
                                    ];
                                  }
                                }),
                                default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                                  if (_push5) {
                                    _push5(ssrRenderComponent(_component_BFormInput, {
                                      modelValue: field.value,
                                      "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                        var _a3;
                                        return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                      }],
                                      disabled: unref(disabled),
                                      type: field.type,
                                      min: field.type === "number" || field.type === "range" ? field.min : void 0,
                                      max: field.type === "number" || field.type === "range" ? field.max : void 0,
                                      placeholder: field.placeholder || void 0,
                                      required: field.required
                                    }, null, _parent5, _scopeId4));
                                  } else {
                                    return [
                                      createVNode(_component_BFormInput, {
                                        modelValue: field.value,
                                        "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                          var _a3;
                                          return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                        }],
                                        disabled: unref(disabled),
                                        type: field.type,
                                        min: field.type === "number" || field.type === "range" ? field.min : void 0,
                                        max: field.type === "number" || field.type === "range" ? field.max : void 0,
                                        placeholder: field.placeholder || void 0,
                                        required: field.required
                                      }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "type", "min", "max", "placeholder", "required"])
                                    ];
                                  }
                                }),
                                _: 2
                              }, _parent4, _scopeId3));
                            }
                          } else {
                            return [
                              field.type === "checkbox" ? (openBlock(), createBlock(_component_BFormGroup, {
                                key: 0,
                                description: field.description || void 0,
                                "invalid-feedback": (_k = unref(formErrors)) == null ? void 0 : _k[field.name],
                                state: !((_l = unref(formErrors)) == null ? void 0 : _l[field.name]) && null,
                                class: "mb-4"
                              }, {
                                default: withCtx(() => [
                                  createVNode(_component_BFormCheckbox, {
                                    modelValue: field.value,
                                    "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                      var _a3;
                                      return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                    }],
                                    disabled: unref(disabled),
                                    required: field.required,
                                    name: field.name
                                  }, {
                                    default: withCtx(() => [
                                      field.required ? (openBlock(), createBlock("span", {
                                        key: 0,
                                        style: { "color": "red" }
                                      }, "* ")) : createCommentVNode("", true),
                                      createVNode("span", {
                                        class: field.labelClass,
                                        style: field.labelStyle
                                      }, toDisplayString(field.label), 7)
                                    ]),
                                    _: 2
                                  }, 1032, ["modelValue", "onUpdate:modelValue", "disabled", "required", "name"])
                                ]),
                                _: 2
                              }, 1032, ["description", "invalid-feedback", "state"])) : field.type === "select" ? (openBlock(), createBlock(_component_BFormGroup, {
                                key: 1,
                                description: field.description || void 0,
                                "invalid-feedback": (_m = unref(formErrors)) == null ? void 0 : _m[field.name],
                                state: !((_n = unref(formErrors)) == null ? void 0 : _n[field.name]) && null,
                                class: "mb-4"
                              }, {
                                label: withCtx(() => [
                                  field.required ? (openBlock(), createBlock("span", {
                                    key: 0,
                                    style: { "color": "red" }
                                  }, "* ")) : createCommentVNode("", true),
                                  createVNode("span", {
                                    class: field.labelClass,
                                    style: field.labelStyle
                                  }, toDisplayString(field.label), 7)
                                ]),
                                default: withCtx(() => [
                                  createVNode(_component_BFormSelect, {
                                    modelValue: field.value,
                                    "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                      var _a3;
                                      return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                    }],
                                    disabled: unref(disabled),
                                    required: field.required,
                                    name: field.name,
                                    options: field.items || void 0,
                                    "text-field": "label"
                                  }, {
                                    default: withCtx(() => [
                                      createVNode("span", {
                                        class: field.labelClass,
                                        style: field.labelStyle
                                      }, toDisplayString(field.label), 7)
                                    ]),
                                    _: 2
                                  }, 1032, ["modelValue", "onUpdate:modelValue", "disabled", "required", "name", "options"])
                                ]),
                                _: 2
                              }, 1032, ["description", "invalid-feedback", "state"])) : field.type === "radio" ? (openBlock(), createBlock(_component_BFormGroup, {
                                key: 2,
                                description: field.description || void 0,
                                "invalid-feedback": (_o = unref(formErrors)) == null ? void 0 : _o[field.name],
                                state: !((_p = unref(formErrors)) == null ? void 0 : _p[field.name]) && null,
                                class: "mb-4"
                              }, {
                                label: withCtx(() => [
                                  field.required ? (openBlock(), createBlock("span", {
                                    key: 0,
                                    style: { "color": "red" }
                                  }, "* ")) : createCommentVNode("", true),
                                  createVNode("span", {
                                    class: field.labelClass,
                                    style: field.labelStyle
                                  }, toDisplayString(field.label), 7)
                                ]),
                                default: withCtx(() => [
                                  createVNode(_component_BFormRadioGroup, {
                                    modelValue: field.value,
                                    "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                      var _a3;
                                      return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                    }],
                                    disabled: unref(disabled),
                                    required: field.required,
                                    name: field.name,
                                    options: field.items || void 0,
                                    "text-field": "label"
                                  }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "required", "name", "options"])
                                ]),
                                _: 2
                              }, 1032, ["description", "invalid-feedback", "state"])) : field.type === "textarea" ? (openBlock(), createBlock(_component_BFormGroup, {
                                key: 3,
                                description: field.description || void 0,
                                "invalid-feedback": (_q = unref(formErrors)) == null ? void 0 : _q[field.name],
                                state: !((_r = unref(formErrors)) == null ? void 0 : _r[field.name]) && null,
                                class: "mb-4"
                              }, {
                                label: withCtx(() => [
                                  field.required ? (openBlock(), createBlock("span", {
                                    key: 0,
                                    style: { "color": "red" }
                                  }, "* ")) : createCommentVNode("", true),
                                  createVNode("span", {
                                    class: field.labelClass,
                                    style: field.labelStyle
                                  }, toDisplayString(field.label), 7)
                                ]),
                                default: withCtx(() => [
                                  createVNode(_component_BFormTextarea, {
                                    modelValue: field.value,
                                    "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                      var _a3;
                                      return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                    }],
                                    disabled: unref(disabled),
                                    placeholder: field.placeholder || void 0,
                                    required: field.required,
                                    name: field.name
                                  }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "placeholder", "required", "name"])
                                ]),
                                _: 2
                              }, 1032, ["description", "invalid-feedback", "state"])) : (openBlock(), createBlock(_component_BFormGroup, {
                                key: 4,
                                description: field.description || void 0,
                                "invalid-feedback": (_s = unref(formErrors)) == null ? void 0 : _s[field.name],
                                state: !((_t = unref(formErrors)) == null ? void 0 : _t[field.name]) && null,
                                class: "mb-4"
                              }, {
                                label: withCtx(() => [
                                  field.required ? (openBlock(), createBlock("span", {
                                    key: 0,
                                    style: { "color": "red" }
                                  }, "* ")) : createCommentVNode("", true),
                                  createVNode("span", {
                                    class: field.labelClass,
                                    style: field.labelStyle
                                  }, toDisplayString(field.label), 7)
                                ]),
                                default: withCtx(() => [
                                  createVNode(_component_BFormInput, {
                                    modelValue: field.value,
                                    "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                      var _a3;
                                      return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                    }],
                                    disabled: unref(disabled),
                                    type: field.type,
                                    min: field.type === "number" || field.type === "range" ? field.min : void 0,
                                    max: field.type === "number" || field.type === "range" ? field.max : void 0,
                                    placeholder: field.placeholder || void 0,
                                    required: field.required
                                  }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "type", "min", "max", "placeholder", "required"])
                                ]),
                                _: 2
                              }, 1032, ["description", "invalid-feedback", "state"]))
                            ];
                          }
                        }),
                        _: 2
                      }, _parent3, _scopeId2));
                    });
                    _push3(`<!--]-->`);
                  } else {
                    return [
                      (openBlock(true), createBlock(Fragment, null, renderList((_b = unref(formData)) == null ? void 0 : _b.fields, (field, idx) => {
                        return openBlock(), createBlock(_component_BCol, {
                          key: idx,
                          cols: field.colsXs || void 0,
                          sm: field.colsSm || void 0,
                          md: field.colsMd || void 0,
                          lg: field.colsLg || void 0,
                          xl: field.colsXl || void 0,
                          xxl: field.colsXxl || void 0
                        }, {
                          default: withCtx(() => {
                            var _a2, _b2, _c, _d, _e, _f, _g, _h, _i, _j;
                            return [
                              field.type === "checkbox" ? (openBlock(), createBlock(_component_BFormGroup, {
                                key: 0,
                                description: field.description || void 0,
                                "invalid-feedback": (_a2 = unref(formErrors)) == null ? void 0 : _a2[field.name],
                                state: !((_b2 = unref(formErrors)) == null ? void 0 : _b2[field.name]) && null,
                                class: "mb-4"
                              }, {
                                default: withCtx(() => [
                                  createVNode(_component_BFormCheckbox, {
                                    modelValue: field.value,
                                    "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                      var _a3;
                                      return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                    }],
                                    disabled: unref(disabled),
                                    required: field.required,
                                    name: field.name
                                  }, {
                                    default: withCtx(() => [
                                      field.required ? (openBlock(), createBlock("span", {
                                        key: 0,
                                        style: { "color": "red" }
                                      }, "* ")) : createCommentVNode("", true),
                                      createVNode("span", {
                                        class: field.labelClass,
                                        style: field.labelStyle
                                      }, toDisplayString(field.label), 7)
                                    ]),
                                    _: 2
                                  }, 1032, ["modelValue", "onUpdate:modelValue", "disabled", "required", "name"])
                                ]),
                                _: 2
                              }, 1032, ["description", "invalid-feedback", "state"])) : field.type === "select" ? (openBlock(), createBlock(_component_BFormGroup, {
                                key: 1,
                                description: field.description || void 0,
                                "invalid-feedback": (_c = unref(formErrors)) == null ? void 0 : _c[field.name],
                                state: !((_d = unref(formErrors)) == null ? void 0 : _d[field.name]) && null,
                                class: "mb-4"
                              }, {
                                label: withCtx(() => [
                                  field.required ? (openBlock(), createBlock("span", {
                                    key: 0,
                                    style: { "color": "red" }
                                  }, "* ")) : createCommentVNode("", true),
                                  createVNode("span", {
                                    class: field.labelClass,
                                    style: field.labelStyle
                                  }, toDisplayString(field.label), 7)
                                ]),
                                default: withCtx(() => [
                                  createVNode(_component_BFormSelect, {
                                    modelValue: field.value,
                                    "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                      var _a3;
                                      return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                    }],
                                    disabled: unref(disabled),
                                    required: field.required,
                                    name: field.name,
                                    options: field.items || void 0,
                                    "text-field": "label"
                                  }, {
                                    default: withCtx(() => [
                                      createVNode("span", {
                                        class: field.labelClass,
                                        style: field.labelStyle
                                      }, toDisplayString(field.label), 7)
                                    ]),
                                    _: 2
                                  }, 1032, ["modelValue", "onUpdate:modelValue", "disabled", "required", "name", "options"])
                                ]),
                                _: 2
                              }, 1032, ["description", "invalid-feedback", "state"])) : field.type === "radio" ? (openBlock(), createBlock(_component_BFormGroup, {
                                key: 2,
                                description: field.description || void 0,
                                "invalid-feedback": (_e = unref(formErrors)) == null ? void 0 : _e[field.name],
                                state: !((_f = unref(formErrors)) == null ? void 0 : _f[field.name]) && null,
                                class: "mb-4"
                              }, {
                                label: withCtx(() => [
                                  field.required ? (openBlock(), createBlock("span", {
                                    key: 0,
                                    style: { "color": "red" }
                                  }, "* ")) : createCommentVNode("", true),
                                  createVNode("span", {
                                    class: field.labelClass,
                                    style: field.labelStyle
                                  }, toDisplayString(field.label), 7)
                                ]),
                                default: withCtx(() => [
                                  createVNode(_component_BFormRadioGroup, {
                                    modelValue: field.value,
                                    "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                      var _a3;
                                      return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                    }],
                                    disabled: unref(disabled),
                                    required: field.required,
                                    name: field.name,
                                    options: field.items || void 0,
                                    "text-field": "label"
                                  }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "required", "name", "options"])
                                ]),
                                _: 2
                              }, 1032, ["description", "invalid-feedback", "state"])) : field.type === "textarea" ? (openBlock(), createBlock(_component_BFormGroup, {
                                key: 3,
                                description: field.description || void 0,
                                "invalid-feedback": (_g = unref(formErrors)) == null ? void 0 : _g[field.name],
                                state: !((_h = unref(formErrors)) == null ? void 0 : _h[field.name]) && null,
                                class: "mb-4"
                              }, {
                                label: withCtx(() => [
                                  field.required ? (openBlock(), createBlock("span", {
                                    key: 0,
                                    style: { "color": "red" }
                                  }, "* ")) : createCommentVNode("", true),
                                  createVNode("span", {
                                    class: field.labelClass,
                                    style: field.labelStyle
                                  }, toDisplayString(field.label), 7)
                                ]),
                                default: withCtx(() => [
                                  createVNode(_component_BFormTextarea, {
                                    modelValue: field.value,
                                    "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                      var _a3;
                                      return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                    }],
                                    disabled: unref(disabled),
                                    placeholder: field.placeholder || void 0,
                                    required: field.required,
                                    name: field.name
                                  }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "placeholder", "required", "name"])
                                ]),
                                _: 2
                              }, 1032, ["description", "invalid-feedback", "state"])) : (openBlock(), createBlock(_component_BFormGroup, {
                                key: 4,
                                description: field.description || void 0,
                                "invalid-feedback": (_i = unref(formErrors)) == null ? void 0 : _i[field.name],
                                state: !((_j = unref(formErrors)) == null ? void 0 : _j[field.name]) && null,
                                class: "mb-4"
                              }, {
                                label: withCtx(() => [
                                  field.required ? (openBlock(), createBlock("span", {
                                    key: 0,
                                    style: { "color": "red" }
                                  }, "* ")) : createCommentVNode("", true),
                                  createVNode("span", {
                                    class: field.labelClass,
                                    style: field.labelStyle
                                  }, toDisplayString(field.label), 7)
                                ]),
                                default: withCtx(() => [
                                  createVNode(_component_BFormInput, {
                                    modelValue: field.value,
                                    "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                      var _a3;
                                      return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                    }],
                                    disabled: unref(disabled),
                                    type: field.type,
                                    min: field.type === "number" || field.type === "range" ? field.min : void 0,
                                    max: field.type === "number" || field.type === "range" ? field.max : void 0,
                                    placeholder: field.placeholder || void 0,
                                    required: field.required
                                  }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "type", "min", "max", "placeholder", "required"])
                                ]),
                                _: 2
                              }, 1032, ["description", "invalid-feedback", "state"]))
                            ];
                          }),
                          _: 2
                        }, 1032, ["cols", "sm", "md", "lg", "xl", "xxl"]);
                      }), 128))
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_BAlert, {
                show: unref(alertError).show,
                dismissible: true,
                title: unref(alertError).title,
                variant: "danger"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(unref(alertError).body)}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(unref(alertError).body), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_BButton, {
                disabled: unref(disabled),
                hidden: unref(blockProps).showAlert && (unref(formStatus) === "success" || unref(blockProps).alertPreview),
                type: "submit",
                variant: null,
                loading: unref(formStatus) === "submitting",
                class: unref(blockProps).btnClass,
                style: unref(blockProps).btnStyle
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(unref(blockProps).btnLabel)}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(unref(blockProps).btnLabel), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              if (unref(blockProps).showAlert && (unref(formStatus) === "success" || unref(blockProps).alertPreview)) {
                _push2(ssrRenderComponent(_component_BAlert, {
                  show: "",
                  variant: null,
                  class: unref(blockProps).alertClass,
                  style: unref(blockProps).alertStyle
                }, null, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                unref(blockProps).showDescription || unref(blockProps).showTitle ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "mb-4"
                }, [
                  unref(blockProps).showTitle ? (openBlock(), createBlock("h2", { key: 0 }, toDisplayString(unref(formData).title), 1)) : createCommentVNode("", true),
                  unref(blockProps).showDescription && unref(formData).description ? (openBlock(), createBlock("p", { key: 1 }, toDisplayString(unref(formData).description), 1)) : createCommentVNode("", true)
                ])) : createCommentVNode("", true),
                createVNode(_component_BRow, null, {
                  default: withCtx(() => {
                    var _a;
                    return [
                      (openBlock(true), createBlock(Fragment, null, renderList((_a = unref(formData)) == null ? void 0 : _a.fields, (field, idx) => {
                        return openBlock(), createBlock(_component_BCol, {
                          key: idx,
                          cols: field.colsXs || void 0,
                          sm: field.colsSm || void 0,
                          md: field.colsMd || void 0,
                          lg: field.colsLg || void 0,
                          xl: field.colsXl || void 0,
                          xxl: field.colsXxl || void 0
                        }, {
                          default: withCtx(() => {
                            var _a2, _b, _c, _d, _e, _f, _g, _h, _i, _j;
                            return [
                              field.type === "checkbox" ? (openBlock(), createBlock(_component_BFormGroup, {
                                key: 0,
                                description: field.description || void 0,
                                "invalid-feedback": (_a2 = unref(formErrors)) == null ? void 0 : _a2[field.name],
                                state: !((_b = unref(formErrors)) == null ? void 0 : _b[field.name]) && null,
                                class: "mb-4"
                              }, {
                                default: withCtx(() => [
                                  createVNode(_component_BFormCheckbox, {
                                    modelValue: field.value,
                                    "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                      var _a3;
                                      return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                    }],
                                    disabled: unref(disabled),
                                    required: field.required,
                                    name: field.name
                                  }, {
                                    default: withCtx(() => [
                                      field.required ? (openBlock(), createBlock("span", {
                                        key: 0,
                                        style: { "color": "red" }
                                      }, "* ")) : createCommentVNode("", true),
                                      createVNode("span", {
                                        class: field.labelClass,
                                        style: field.labelStyle
                                      }, toDisplayString(field.label), 7)
                                    ]),
                                    _: 2
                                  }, 1032, ["modelValue", "onUpdate:modelValue", "disabled", "required", "name"])
                                ]),
                                _: 2
                              }, 1032, ["description", "invalid-feedback", "state"])) : field.type === "select" ? (openBlock(), createBlock(_component_BFormGroup, {
                                key: 1,
                                description: field.description || void 0,
                                "invalid-feedback": (_c = unref(formErrors)) == null ? void 0 : _c[field.name],
                                state: !((_d = unref(formErrors)) == null ? void 0 : _d[field.name]) && null,
                                class: "mb-4"
                              }, {
                                label: withCtx(() => [
                                  field.required ? (openBlock(), createBlock("span", {
                                    key: 0,
                                    style: { "color": "red" }
                                  }, "* ")) : createCommentVNode("", true),
                                  createVNode("span", {
                                    class: field.labelClass,
                                    style: field.labelStyle
                                  }, toDisplayString(field.label), 7)
                                ]),
                                default: withCtx(() => [
                                  createVNode(_component_BFormSelect, {
                                    modelValue: field.value,
                                    "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                      var _a3;
                                      return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                    }],
                                    disabled: unref(disabled),
                                    required: field.required,
                                    name: field.name,
                                    options: field.items || void 0,
                                    "text-field": "label"
                                  }, {
                                    default: withCtx(() => [
                                      createVNode("span", {
                                        class: field.labelClass,
                                        style: field.labelStyle
                                      }, toDisplayString(field.label), 7)
                                    ]),
                                    _: 2
                                  }, 1032, ["modelValue", "onUpdate:modelValue", "disabled", "required", "name", "options"])
                                ]),
                                _: 2
                              }, 1032, ["description", "invalid-feedback", "state"])) : field.type === "radio" ? (openBlock(), createBlock(_component_BFormGroup, {
                                key: 2,
                                description: field.description || void 0,
                                "invalid-feedback": (_e = unref(formErrors)) == null ? void 0 : _e[field.name],
                                state: !((_f = unref(formErrors)) == null ? void 0 : _f[field.name]) && null,
                                class: "mb-4"
                              }, {
                                label: withCtx(() => [
                                  field.required ? (openBlock(), createBlock("span", {
                                    key: 0,
                                    style: { "color": "red" }
                                  }, "* ")) : createCommentVNode("", true),
                                  createVNode("span", {
                                    class: field.labelClass,
                                    style: field.labelStyle
                                  }, toDisplayString(field.label), 7)
                                ]),
                                default: withCtx(() => [
                                  createVNode(_component_BFormRadioGroup, {
                                    modelValue: field.value,
                                    "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                      var _a3;
                                      return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                    }],
                                    disabled: unref(disabled),
                                    required: field.required,
                                    name: field.name,
                                    options: field.items || void 0,
                                    "text-field": "label"
                                  }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "required", "name", "options"])
                                ]),
                                _: 2
                              }, 1032, ["description", "invalid-feedback", "state"])) : field.type === "textarea" ? (openBlock(), createBlock(_component_BFormGroup, {
                                key: 3,
                                description: field.description || void 0,
                                "invalid-feedback": (_g = unref(formErrors)) == null ? void 0 : _g[field.name],
                                state: !((_h = unref(formErrors)) == null ? void 0 : _h[field.name]) && null,
                                class: "mb-4"
                              }, {
                                label: withCtx(() => [
                                  field.required ? (openBlock(), createBlock("span", {
                                    key: 0,
                                    style: { "color": "red" }
                                  }, "* ")) : createCommentVNode("", true),
                                  createVNode("span", {
                                    class: field.labelClass,
                                    style: field.labelStyle
                                  }, toDisplayString(field.label), 7)
                                ]),
                                default: withCtx(() => [
                                  createVNode(_component_BFormTextarea, {
                                    modelValue: field.value,
                                    "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                      var _a3;
                                      return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                    }],
                                    disabled: unref(disabled),
                                    placeholder: field.placeholder || void 0,
                                    required: field.required,
                                    name: field.name
                                  }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "placeholder", "required", "name"])
                                ]),
                                _: 2
                              }, 1032, ["description", "invalid-feedback", "state"])) : (openBlock(), createBlock(_component_BFormGroup, {
                                key: 4,
                                description: field.description || void 0,
                                "invalid-feedback": (_i = unref(formErrors)) == null ? void 0 : _i[field.name],
                                state: !((_j = unref(formErrors)) == null ? void 0 : _j[field.name]) && null,
                                class: "mb-4"
                              }, {
                                label: withCtx(() => [
                                  field.required ? (openBlock(), createBlock("span", {
                                    key: 0,
                                    style: { "color": "red" }
                                  }, "* ")) : createCommentVNode("", true),
                                  createVNode("span", {
                                    class: field.labelClass,
                                    style: field.labelStyle
                                  }, toDisplayString(field.label), 7)
                                ]),
                                default: withCtx(() => [
                                  createVNode(_component_BFormInput, {
                                    modelValue: field.value,
                                    "onUpdate:modelValue": [($event) => field.value = $event, ($event) => {
                                      var _a3;
                                      return (_a3 = unref(formErrors)) == null ? true : delete _a3[field.name];
                                    }],
                                    disabled: unref(disabled),
                                    type: field.type,
                                    min: field.type === "number" || field.type === "range" ? field.min : void 0,
                                    max: field.type === "number" || field.type === "range" ? field.max : void 0,
                                    placeholder: field.placeholder || void 0,
                                    required: field.required
                                  }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "type", "min", "max", "placeholder", "required"])
                                ]),
                                _: 2
                              }, 1032, ["description", "invalid-feedback", "state"]))
                            ];
                          }),
                          _: 2
                        }, 1032, ["cols", "sm", "md", "lg", "xl", "xxl"]);
                      }), 128))
                    ];
                  }),
                  _: 1
                }),
                createVNode(_component_BAlert, {
                  show: unref(alertError).show,
                  dismissible: true,
                  title: unref(alertError).title,
                  variant: "danger"
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(unref(alertError).body), 1)
                  ]),
                  _: 1
                }, 8, ["show", "title"]),
                createVNode(_component_BButton, {
                  disabled: unref(disabled),
                  hidden: unref(blockProps).showAlert && (unref(formStatus) === "success" || unref(blockProps).alertPreview),
                  type: "submit",
                  variant: null,
                  loading: unref(formStatus) === "submitting",
                  class: unref(blockProps).btnClass,
                  style: unref(blockProps).btnStyle
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(unref(blockProps).btnLabel), 1)
                  ]),
                  _: 1
                }, 8, ["disabled", "hidden", "loading", "class", "style"]),
                unref(blockProps).showAlert && (unref(formStatus) === "success" || unref(blockProps).alertPreview) ? (openBlock(), createBlock(_component_BAlert, {
                  key: 1,
                  show: "",
                  variant: null,
                  class: unref(blockProps).alertClass,
                  style: unref(blockProps).alertStyle,
                  innerHTML: unref(blockProps).alertContent
                }, null, 8, ["class", "style", "innerHTML"])) : createCommentVNode("", true)
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
    };
  }
});

const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("blocks/FormBlock.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=FormBlock.vue.mjs.map
