import { _ as __nuxt_component_0 } from './HTMLContent.mjs';
import { defineComponent, useAttrs, computed, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderComponent } from 'vue/server-renderer';

const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "HTMLBlock",
  __ssrInlineRender: true,
  setup(__props) {
    const attrs = useAttrs();
    const blockProps = computed(() => {
      const { tag, html, attributes } = attrs;
      const parsedAttributes = {};
      if (Array.isArray(attributes)) {
        for (const attr of attributes) {
          parsedAttributes[attr.name] = attr.value;
        }
      }
      return {
        tag: tag || "span",
        html: html || void 0,
        attributes: parsedAttributes
      };
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_HTMLContent = __nuxt_component_0;
      _push(ssrRenderComponent(_component_HTMLContent, mergeProps(unref(blockProps), _attrs), null, _parent));
    };
  }
});

const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("blocks/HTMLBlock.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=HTMLBlock.vue.mjs.map
