import { createVNode, createTextVNode, mergeProps } from 'vue';

const __nuxt_component_0 = ({
  tag,
  html,
  attributes
}) => {
  if (typeof tag !== "string" || !/^[a-z]+(?:\d)*(?:-[a-z0-9])*$/i.test(tag)) {
    return createVNode("span", {
      "style": "color: red"
    }, [createTextVNode("INVALID_HTML_TAG")]);
  }
  const Tag = tag.toLowerCase();
  return createVNode(Tag, mergeProps(attributes, {
    "innerHTML": html
  }), null);
};

export { __nuxt_component_0 as _ };
//# sourceMappingURL=HTMLContent.mjs.map
