import { defineComponent, useAttrs, computed, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs } from 'vue/server-renderer';
import { d as defineBlock, a as additionalFields } from './block.definition.mjs';

const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "IconBlock",
  __ssrInlineRender: true,
  setup(__props) {
    defineBlock({
      fields: {
        ...additionalFields("classes", "styles")
      }
    });
    const attrs = useAttrs();
    const blockProps = computed(() => {
      const { name, customClasses, customStyles } = attrs;
      const parsedClass = ["bi", "bi-" + name].concat(
        (customClasses == null ? void 0 : customClasses.replace(/\s+/gm, " ").split(" ")) || []
      );
      return {
        class: parsedClass || void 0,
        style: customStyles || void 0
      };
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<i${ssrRenderAttrs(mergeProps(unref(blockProps), _attrs))}></i>`);
    };
  }
});

const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("blocks/IconBlock.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=IconBlock.vue.mjs.map
