import { defineComponent, mergeProps, useAttrs, computed, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderList, ssrRenderAttr, ssrRenderSlot, ssrRenderComponent } from 'vue/server-renderer';
import { d as defineBlock, a as additionalFields } from './block.definition.mjs';

const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "Image",
  __ssrInlineRender: true,
  props: {
    /**
     * The image to render.
     */
    image: {
      type: Object
    },
    /**
     * Specifies whether the image should be lazy loaded.
     *
     * @default false
     */
    lazy: {
      type: Boolean,
      default: false
    }
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      if (__props.image) {
        _push(`<img${ssrRenderAttrs(mergeProps({
          alt: __props.image.alt,
          height: __props.image.height,
          loading: __props.lazy ? "lazy" : "eager",
          src: __props.image.src,
          width: __props.image.width
        }, _attrs))}>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});

const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "Picture",
  __ssrInlineRender: true,
  props: {
    /**
     * The image to render.
     */
    image: {
      type: Object
    },
    /**
     * Specifies whether the image should be lazy loaded.
     *
     * @default false
     */
    lazy: {
      type: Boolean,
      default: false
    },
    /**
     * Additional attributes to apply to the `<img>` element.
     */
    imgAttrs: {
      type: Object,
      default: () => ({})
    }
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_PruviousImage = _sfc_main$2;
      if (__props.image) {
        _push(`<picture${ssrRenderAttrs(_attrs)}><!--[-->`);
        ssrRenderList(__props.image.sources, (source, i) => {
          _push(`<source${ssrRenderAttr("height", source.height)}${ssrRenderAttr("media", source.media ?? void 0)}${ssrRenderAttr("srcset", source.srcset)}${ssrRenderAttr("type", source.type)}${ssrRenderAttr("width", source.width)}>`);
        });
        _push(`<!--]-->`);
        ssrRenderSlot(_ctx.$slots, "default", {}, () => {
          _push(ssrRenderComponent(_component_PruviousImage, mergeProps(__props.imgAttrs, {
            image: __props.image,
            lazy: __props.lazy
          }), null, _parent));
        }, _push, _parent);
        _push(`</picture>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});

const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "ImageBlock",
  __ssrInlineRender: true,
  setup(__props) {
    defineBlock({
      fields: {
        ...additionalFields("classes", "styles")
      }
    });
    const attrs = useAttrs();
    const blockProps = computed(() => {
      const { image, isLazy, imgAttrs, customClasses, customStyles } = attrs;
      return {
        image: image || void 0,
        isLazy: isLazy || void 0,
        imgAttrs: imgAttrs.reduce(
          (obj, x) => {
            obj[x.name] = x.value;
            return obj;
          },
          {}
        ),
        class: customClasses || void 0,
        style: customStyles || void 0
      };
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_PruviousPicture = _sfc_main$1;
      _push(ssrRenderComponent(_component_PruviousPicture, mergeProps(unref(blockProps), _attrs), null, _parent));
    };
  }
});

const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("blocks/ImageBlock.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=ImageBlock.vue.mjs.map
