import { BLink } from 'bootstrap-vue-next/components/BLink';
import { defineComponent, useAttrs, computed, mergeProps, unref, withCtx, renderSlot, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderSlot } from 'vue/server-renderer';
import { g as getPublicFilePath, i as isInternalLink } from './index.mjs';
import { d as defineBlock, a as additionalFields } from './block.definition.mjs';
import { a as useRuntimeConfig } from './server.mjs';
import '../nitro/nitro.mjs';
import 'nodemailer';
import 'zod/v4';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'crypto';
import 'fs-extra';
import 'path';
import 'node:url';
import 'fs';
import 'mime-types';
import '@antfu/utils';
import 'dot-prop';
import 'redis';
import 'consola';
import 'pg';
import 'sequelize';
import 'pg-connection-string';
import 'colorette';
import '@aws-sdk/client-s3';
import 'jsonwebtoken';
import 'nanoid';
import 'pluralize-esm';
import 'argon2';
import 'sharp';
import 'accept-language-parser';
import 'vue-router';
import 'bootstrap-vue-next/directives';
import 'bootstrap-vue-next/plugins/createBootstrap';
import 'bootstrap-vue-next/components/BContainer';
import 'bootstrap-vue-next/components/BImg';

const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "LinkBlock",
  __ssrInlineRender: true,
  setup(__props) {
    defineBlock({
      fields: {
        ...additionalFields("classes", "styles")
      }
    });
    const runtimeConfig = useRuntimeConfig();
    const attrs = useAttrs();
    const blockProps = computed(() => {
      const { type, link, file, target, isStretched, customClasses, customStyles } = attrs;
      const href = type === "link" ? link : getPublicFilePath(file, runtimeConfig);
      const isInternal = type === "link" && isInternalLink(href || "");
      const classes = [];
      if (customClasses) {
        classes.push(customClasses);
      }
      if (isStretched) {
        classes.push("stretched-link");
      }
      return {
        [isInternal ? "to" : "href"]: href,
        target,
        class: classes.length ? classes : void 0,
        style: customStyles || void 0,
        download: type === "file" ? "" : void 0
      };
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_BLink = BLink;
      _push(ssrRenderComponent(_component_BLink, mergeProps(unref(blockProps), _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            ssrRenderSlot(_ctx.$slots, "default", {}, null, _push2, _parent2, _scopeId);
          } else {
            return [
              renderSlot(_ctx.$slots, "default")
            ];
          }
        }),
        _: 3
      }, _parent));
    };
  }
});

const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("blocks/LinkBlock.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=LinkBlock.vue.mjs.map
