import { BContainer, BRow, BCol } from 'bootstrap-vue-next/components/BContainer';
import { BAlert } from 'bootstrap-vue-next/components/BAlert';
import { BLink } from 'bootstrap-vue-next/components/BLink';
import { BImg } from 'bootstrap-vue-next/components/BImg';
import { BPagination } from 'bootstrap-vue-next/components/BPagination';
import { getCurrentScope, onScopeDispose, customRef, toValue, nextTick, watch, defineComponent, useAttrs, computed, withAsyncContext, mergeProps, unref, withCtx, createVNode, createBlock, createCommentVNode, openBlock, toDisplayString, isRef, Fragment, renderList, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderList, ssrInterpolate, ssrRenderStyle } from 'vue/server-renderer';
import { d as defineBlock, a as additionalFields } from './block.definition.mjs';
import { useRoute, useRouter } from 'vue-router';
import { u as useFetch } from './fetch.mjs';
import { e as _export_sfc } from './server.mjs';
import '../nitro/nitro.mjs';
import 'nodemailer';
import 'zod/v4';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'crypto';
import 'fs-extra';
import 'path';
import 'node:url';
import 'fs';
import 'mime-types';
import '@antfu/utils';
import 'dot-prop';
import 'redis';
import 'consola';
import 'pg';
import 'sequelize';
import 'pg-connection-string';
import 'colorette';
import '@aws-sdk/client-s3';
import 'jsonwebtoken';
import 'nanoid';
import 'pluralize-esm';
import 'argon2';
import 'sharp';
import 'accept-language-parser';
import '@vue/shared';
import 'perfect-debounce';
import 'bootstrap-vue-next/directives';
import 'bootstrap-vue-next/plugins/createBootstrap';

function tryOnScopeDispose(fn) {
  if (getCurrentScope()) {
    onScopeDispose(fn);
    return true;
  }
  return false;
}
typeof WorkerGlobalScope !== "undefined" && globalThis instanceof WorkerGlobalScope;

const _queue = /* @__PURE__ */ new WeakMap();
function useRouteQuery(name, defaultValue, options = {}) {
  const {
    mode = "replace",
    route = useRoute(),
    router = useRouter(),
    transform
  } = options;
  let transformGet = (value) => value;
  let transformSet = (value) => value;
  if (typeof transform === "function") {
    transformGet = transform;
  } else if (transform) {
    if (transform.get)
      transformGet = transform.get;
    if (transform.set)
      transformSet = transform.set;
  }
  if (!_queue.has(router))
    _queue.set(router, /* @__PURE__ */ new Map());
  const _queriesQueue = _queue.get(router);
  let query = route.query[name];
  tryOnScopeDispose(() => {
    query = void 0;
  });
  let _trigger;
  const proxy = customRef((track, trigger) => {
    _trigger = trigger;
    return {
      get() {
        track();
        return transformGet(query !== void 0 ? query : toValue(defaultValue));
      },
      set(v) {
        v = transformSet(v);
        if (query === v)
          return;
        query = v === toValue(defaultValue) ? void 0 : v;
        _queriesQueue.set(name, v === toValue(defaultValue) ? void 0 : v);
        trigger();
        nextTick(() => {
          if (_queriesQueue.size === 0)
            return;
          const newQueries = Object.fromEntries(_queriesQueue.entries());
          _queriesQueue.clear();
          const { params, query: query2, hash } = route;
          router[toValue(mode)]({
            params,
            query: { ...query2, ...newQueries },
            hash
          });
        });
      }
    };
  });
  watch(
    () => route.query[name],
    (v) => {
      if (query === transformGet(v))
        return;
      query = v;
      _trigger();
    },
    { flush: "sync" }
  );
  return proxy;
}

const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "NewsBlock",
  __ssrInlineRender: true,
  async setup(__props) {
    let __temp, __restore;
    defineBlock({
      fields: {
        ...additionalFields("classes", "styles", "responsive_control")
      }
    });
    const attrs = useAttrs();
    const blockProps = computed(() => {
      const {
        itemsPerPage,
        pagination,
        queryPageParam,
        lazy,
        customClasses,
        customStyles
      } = attrs;
      return {
        itemsPerPage,
        pagination,
        queryPageParam,
        lazy,
        customClasses,
        customStyles
      };
    });
    const page = useRouteQuery(
      blockProps.value.queryPageParam,
      void 0,
      {
        transform: (val) => {
          const parsed = parseInt(val);
          return isNaN(parsed) ? 1 : Math.max(1, Math.floor(parsed));
        }
      }
    );
    const { data, status } = ([__temp, __restore] = withAsyncContext(() => useFetch(
      () => `/api/news?page=${page.value}&limit=${blockProps.value.itemsPerPage}`,
      {
        key: () => `/api/news?page=${page.value}&limit=${blockProps.value.itemsPerPage}`,
        server: !blockProps.value.lazy,
        lazy: blockProps.value.lazy
      },
      "$WWE9To99k2"
    )), __temp = await __temp, __restore(), __temp);
    const scrollToTop = () => {
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_BContainer = BContainer;
      const _component_BRow = BRow;
      const _component_BAlert = BAlert;
      const _component_BCol = BCol;
      const _component_BLink = BLink;
      const _component_BImg = BImg;
      const _component_BPagination = BPagination;
      _push(ssrRenderComponent(_component_BContainer, mergeProps({
        fluid: "",
        class: unref(blockProps).customClasses,
        style: unref(blockProps).customStyles
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_BRow, null, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                var _a, _b, _c, _d;
                if (_push3) {
                  if (unref(status) === "error") {
                    _push3(ssrRenderComponent(_component_BAlert, {
                      show: "",
                      variant: "danger"
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`<div data-v-857135ba${_scopeId3}>Произошла ошибка при загрузке новостей</div>`);
                        } else {
                          return [
                            createVNode("div", null, "Произошла ошибка при загрузке новостей")
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else if (unref(status) === "success") {
                    _push3(`<!--[--><!--[-->`);
                    ssrRenderList((_a = unref(data)) == null ? void 0 : _a.records, (item, idx) => {
                      _push3(ssrRenderComponent(_component_BCol, {
                        key: idx,
                        class: "d-flex justify-content-center text-center mb-4 px-0"
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(`<div class="item-card" data-v-857135ba${_scopeId3}>`);
                            _push4(ssrRenderComponent(_component_BLink, {
                              to: `/news${item.path}`,
                              class: "d-flex justify-content-center link-dark link-underline-opacity-0 link-underline-opacity-100-hover",
                              style: { "color": "inherit", "width": "160px", "display": "flex" }
                            }, {
                              default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                                var _a2, _b2;
                                if (_push5) {
                                  _push5(`<div data-v-857135ba${_scopeId4}>`);
                                  if (item.previewImg || item.sharingImage) {
                                    _push5(ssrRenderComponent(_component_BImg, {
                                      src: (_a2 = item.previewImg || item.sharingImage) == null ? void 0 : _a2.src,
                                      width: "134",
                                      height: "134",
                                      rounded: "circle",
                                      class: "mb-3 mx-auto",
                                      style: { "object-fit": "cover" }
                                    }, null, _parent5, _scopeId4));
                                  } else {
                                    _push5(`<!---->`);
                                  }
                                  _push5(`<div class="px-2 px-md-0" data-v-857135ba${_scopeId4}>${ssrInterpolate(item.title)}</div></div>`);
                                } else {
                                  return [
                                    createVNode("div", null, [
                                      item.previewImg || item.sharingImage ? (openBlock(), createBlock(_component_BImg, {
                                        key: 0,
                                        src: (_b2 = item.previewImg || item.sharingImage) == null ? void 0 : _b2.src,
                                        width: "134",
                                        height: "134",
                                        rounded: "circle",
                                        class: "mb-3 mx-auto",
                                        style: { "object-fit": "cover" }
                                      }, null, 8, ["src"])) : createCommentVNode("", true),
                                      createVNode("div", { class: "px-2 px-md-0" }, toDisplayString(item.title), 1)
                                    ])
                                  ];
                                }
                              }),
                              _: 2
                            }, _parent4, _scopeId3));
                            _push4(`<div class="publish-date" data-v-857135ba${_scopeId3}>${ssrInterpolate(new Date(item.displayDate).toLocaleDateString("ru"))}</div></div>`);
                          } else {
                            return [
                              createVNode("div", { class: "item-card" }, [
                                createVNode(_component_BLink, {
                                  to: `/news${item.path}`,
                                  class: "d-flex justify-content-center link-dark link-underline-opacity-0 link-underline-opacity-100-hover",
                                  style: { "color": "inherit", "width": "160px", "display": "flex" }
                                }, {
                                  default: withCtx(() => {
                                    var _a2;
                                    return [
                                      createVNode("div", null, [
                                        item.previewImg || item.sharingImage ? (openBlock(), createBlock(_component_BImg, {
                                          key: 0,
                                          src: (_a2 = item.previewImg || item.sharingImage) == null ? void 0 : _a2.src,
                                          width: "134",
                                          height: "134",
                                          rounded: "circle",
                                          class: "mb-3 mx-auto",
                                          style: { "object-fit": "cover" }
                                        }, null, 8, ["src"])) : createCommentVNode("", true),
                                        createVNode("div", { class: "px-2 px-md-0" }, toDisplayString(item.title), 1)
                                      ])
                                    ];
                                  }),
                                  _: 2
                                }, 1032, ["to"]),
                                createVNode("div", { class: "publish-date" }, toDisplayString(new Date(item.displayDate).toLocaleDateString("ru")), 1)
                              ])
                            ];
                          }
                        }),
                        _: 2
                      }, _parent3, _scopeId2));
                    });
                    _push3(`<!--]-->`);
                    if (unref(blockProps).pagination) {
                      _push3(ssrRenderComponent(_component_BPagination, {
                        modelValue: unref(page),
                        "onUpdate:modelValue": [($event) => isRef(page) ? page.value = $event : null, scrollToTop],
                        "total-rows": (_b = unref(data)) == null ? void 0 : _b.total,
                        "per-page": unref(blockProps).itemsPerPage,
                        align: "center",
                        class: "mt-5"
                      }, null, _parent3, _scopeId2));
                    } else {
                      _push3(`<!---->`);
                    }
                    _push3(`<!--]-->`);
                  } else {
                    _push3(`<!--[-->`);
                    ssrRenderList(unref(blockProps).itemsPerPage, (item, idx) => {
                      _push3(ssrRenderComponent(_component_BCol, {
                        key: idx,
                        class: "text-center mb-4"
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(`<div class="mx-auto" style="${ssrRenderStyle({ "width": "160px" })}" data-v-857135ba${_scopeId3}>`);
                            _push4(ssrRenderComponent(_component_BImg, {
                              src: void 0,
                              width: "134",
                              height: "134",
                              rounded: "circle",
                              class: "mb-3 mx-auto placeholder",
                              style: { "object-fit": "cover" }
                            }, null, _parent4, _scopeId3));
                            _push4(`<div class="placeholder-glow" data-v-857135ba${_scopeId3}><span class="placeholder col-7" data-v-857135ba${_scopeId3}></span><span class="placeholder col-12" data-v-857135ba${_scopeId3}></span><span class="placeholder col-10" data-v-857135ba${_scopeId3}></span></div></div>`);
                          } else {
                            return [
                              createVNode("div", {
                                class: "mx-auto",
                                style: { "width": "160px" }
                              }, [
                                createVNode(_component_BImg, {
                                  src: void 0,
                                  width: "134",
                                  height: "134",
                                  rounded: "circle",
                                  class: "mb-3 mx-auto placeholder",
                                  style: { "object-fit": "cover" }
                                }),
                                createVNode("div", { class: "placeholder-glow" }, [
                                  createVNode("span", { class: "placeholder col-7" }),
                                  createVNode("span", { class: "placeholder col-12" }),
                                  createVNode("span", { class: "placeholder col-10" })
                                ])
                              ])
                            ];
                          }
                        }),
                        _: 2
                      }, _parent3, _scopeId2));
                    });
                    _push3(`<!--]-->`);
                  }
                } else {
                  return [
                    unref(status) === "error" ? (openBlock(), createBlock(_component_BAlert, {
                      key: 0,
                      show: "",
                      variant: "danger"
                    }, {
                      default: withCtx(() => [
                        createVNode("div", null, "Произошла ошибка при загрузке новостей")
                      ]),
                      _: 1
                    })) : unref(status) === "success" ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                      (openBlock(true), createBlock(Fragment, null, renderList((_c = unref(data)) == null ? void 0 : _c.records, (item, idx) => {
                        return openBlock(), createBlock(_component_BCol, {
                          key: idx,
                          class: "d-flex justify-content-center text-center mb-4 px-0"
                        }, {
                          default: withCtx(() => [
                            createVNode("div", { class: "item-card" }, [
                              createVNode(_component_BLink, {
                                to: `/news${item.path}`,
                                class: "d-flex justify-content-center link-dark link-underline-opacity-0 link-underline-opacity-100-hover",
                                style: { "color": "inherit", "width": "160px", "display": "flex" }
                              }, {
                                default: withCtx(() => {
                                  var _a2;
                                  return [
                                    createVNode("div", null, [
                                      item.previewImg || item.sharingImage ? (openBlock(), createBlock(_component_BImg, {
                                        key: 0,
                                        src: (_a2 = item.previewImg || item.sharingImage) == null ? void 0 : _a2.src,
                                        width: "134",
                                        height: "134",
                                        rounded: "circle",
                                        class: "mb-3 mx-auto",
                                        style: { "object-fit": "cover" }
                                      }, null, 8, ["src"])) : createCommentVNode("", true),
                                      createVNode("div", { class: "px-2 px-md-0" }, toDisplayString(item.title), 1)
                                    ])
                                  ];
                                }),
                                _: 2
                              }, 1032, ["to"]),
                              createVNode("div", { class: "publish-date" }, toDisplayString(new Date(item.displayDate).toLocaleDateString("ru")), 1)
                            ])
                          ]),
                          _: 2
                        }, 1024);
                      }), 128)),
                      unref(blockProps).pagination ? (openBlock(), createBlock(_component_BPagination, {
                        key: 0,
                        modelValue: unref(page),
                        "onUpdate:modelValue": [($event) => isRef(page) ? page.value = $event : null, scrollToTop],
                        "total-rows": (_d = unref(data)) == null ? void 0 : _d.total,
                        "per-page": unref(blockProps).itemsPerPage,
                        align: "center",
                        class: "mt-5"
                      }, null, 8, ["modelValue", "onUpdate:modelValue", "total-rows", "per-page"])) : createCommentVNode("", true)
                    ], 64)) : (openBlock(true), createBlock(Fragment, { key: 2 }, renderList(unref(blockProps).itemsPerPage, (item, idx) => {
                      return openBlock(), createBlock(_component_BCol, {
                        key: idx,
                        class: "text-center mb-4"
                      }, {
                        default: withCtx(() => [
                          createVNode("div", {
                            class: "mx-auto",
                            style: { "width": "160px" }
                          }, [
                            createVNode(_component_BImg, {
                              src: void 0,
                              width: "134",
                              height: "134",
                              rounded: "circle",
                              class: "mb-3 mx-auto placeholder",
                              style: { "object-fit": "cover" }
                            }),
                            createVNode("div", { class: "placeholder-glow" }, [
                              createVNode("span", { class: "placeholder col-7" }),
                              createVNode("span", { class: "placeholder col-12" }),
                              createVNode("span", { class: "placeholder col-10" })
                            ])
                          ])
                        ]),
                        _: 2
                      }, 1024);
                    }), 128))
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_BRow, null, {
                default: withCtx(() => {
                  var _a, _b;
                  return [
                    unref(status) === "error" ? (openBlock(), createBlock(_component_BAlert, {
                      key: 0,
                      show: "",
                      variant: "danger"
                    }, {
                      default: withCtx(() => [
                        createVNode("div", null, "Произошла ошибка при загрузке новостей")
                      ]),
                      _: 1
                    })) : unref(status) === "success" ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                      (openBlock(true), createBlock(Fragment, null, renderList((_a = unref(data)) == null ? void 0 : _a.records, (item, idx) => {
                        return openBlock(), createBlock(_component_BCol, {
                          key: idx,
                          class: "d-flex justify-content-center text-center mb-4 px-0"
                        }, {
                          default: withCtx(() => [
                            createVNode("div", { class: "item-card" }, [
                              createVNode(_component_BLink, {
                                to: `/news${item.path}`,
                                class: "d-flex justify-content-center link-dark link-underline-opacity-0 link-underline-opacity-100-hover",
                                style: { "color": "inherit", "width": "160px", "display": "flex" }
                              }, {
                                default: withCtx(() => {
                                  var _a2;
                                  return [
                                    createVNode("div", null, [
                                      item.previewImg || item.sharingImage ? (openBlock(), createBlock(_component_BImg, {
                                        key: 0,
                                        src: (_a2 = item.previewImg || item.sharingImage) == null ? void 0 : _a2.src,
                                        width: "134",
                                        height: "134",
                                        rounded: "circle",
                                        class: "mb-3 mx-auto",
                                        style: { "object-fit": "cover" }
                                      }, null, 8, ["src"])) : createCommentVNode("", true),
                                      createVNode("div", { class: "px-2 px-md-0" }, toDisplayString(item.title), 1)
                                    ])
                                  ];
                                }),
                                _: 2
                              }, 1032, ["to"]),
                              createVNode("div", { class: "publish-date" }, toDisplayString(new Date(item.displayDate).toLocaleDateString("ru")), 1)
                            ])
                          ]),
                          _: 2
                        }, 1024);
                      }), 128)),
                      unref(blockProps).pagination ? (openBlock(), createBlock(_component_BPagination, {
                        key: 0,
                        modelValue: unref(page),
                        "onUpdate:modelValue": [($event) => isRef(page) ? page.value = $event : null, scrollToTop],
                        "total-rows": (_b = unref(data)) == null ? void 0 : _b.total,
                        "per-page": unref(blockProps).itemsPerPage,
                        align: "center",
                        class: "mt-5"
                      }, null, 8, ["modelValue", "onUpdate:modelValue", "total-rows", "per-page"])) : createCommentVNode("", true)
                    ], 64)) : (openBlock(true), createBlock(Fragment, { key: 2 }, renderList(unref(blockProps).itemsPerPage, (item, idx) => {
                      return openBlock(), createBlock(_component_BCol, {
                        key: idx,
                        class: "text-center mb-4"
                      }, {
                        default: withCtx(() => [
                          createVNode("div", {
                            class: "mx-auto",
                            style: { "width": "160px" }
                          }, [
                            createVNode(_component_BImg, {
                              src: void 0,
                              width: "134",
                              height: "134",
                              rounded: "circle",
                              class: "mb-3 mx-auto placeholder",
                              style: { "object-fit": "cover" }
                            }),
                            createVNode("div", { class: "placeholder-glow" }, [
                              createVNode("span", { class: "placeholder col-7" }),
                              createVNode("span", { class: "placeholder col-12" }),
                              createVNode("span", { class: "placeholder col-10" })
                            ])
                          ])
                        ]),
                        _: 2
                      }, 1024);
                    }), 128))
                  ];
                }),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
});

const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("blocks/NewsBlock.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const NewsBlock = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-857135ba"]]);

export { NewsBlock as default };
//# sourceMappingURL=NewsBlock.vue.mjs.map
