import { defineComponent, useSSRContext } from 'vue';
import { h as isUndefined, k as isNull, b as isArray, m as getProperty, a as isObject, e as isString, s as setProperty, t as titleCase } from './_...slug_.vue.mjs';
import 'vue/server-renderer';
import './server.mjs';
import '../nitro/nitro.mjs';
import 'nodemailer';
import 'zod/v4';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'crypto';
import 'fs-extra';
import 'path';
import 'node:url';
import 'fs';
import 'mime-types';
import '@antfu/utils';
import 'dot-prop';
import 'redis';
import 'consola';
import 'pg';
import 'sequelize';
import 'pg-connection-string';
import 'colorette';
import '@aws-sdk/client-s3';
import 'jsonwebtoken';
import 'nanoid';
import 'pluralize-esm';
import 'argon2';
import 'sharp';
import 'accept-language-parser';
import 'vue-router';
import 'bootstrap-vue-next/directives';
import 'bootstrap-vue-next/plugins/createBootstrap';
import 'bootstrap-vue-next/components/BContainer';
import 'bootstrap-vue-next/components/BImg';
import 'bootstrap-vue-next/components/BLink';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'unhead/plugins';

function isInteger(value) {
  return isRealNumber(value) && Number.isInteger(value);
}
function isPositiveInteger(value) {
  return isRealNumber(value) && isInteger(value) && value > 0;
}
function isRealNumber(value) {
  return typeof value === "number" && Number.isFinite(value);
}

const resolvedCollectionFieldOptions = {};
function resolveCollectionFieldOptions(cacheKey, field, name, options, fields) {
  if (!resolvedCollectionFieldOptions[cacheKey]) {
    resolvedCollectionFieldOptions[cacheKey] = {};
  }
  if (!resolvedCollectionFieldOptions[cacheKey][name]) {
    resolvedCollectionFieldOptions[cacheKey][name] = resolveFieldOptions(field, name, options, fields);
  }
  return resolvedCollectionFieldOptions[cacheKey][name];
}
function resolveFieldOptions(field, name, options, fields) {
  const resolvedOptions = {};
  for (const [optionName, optionDefinition] of Object.entries(fields[field].options)) {
    resolvedOptions[optionName] = options[optionName] ?? (optionDefinition.default ? optionDefinition.default({ definition: fields[field], options, name }) : void 0);
  }
  if (field === "repeater") {
    resolvedOptions.subfields = {};
    for (const [subfieldName, subfieldDefinition] of Object.entries(options.subfields)) {
      resolvedOptions.subfields[subfieldName] = {
        ...subfieldDefinition,
        options: resolveFieldOptions(subfieldDefinition.type, subfieldName, subfieldDefinition.options, fields)
      };
    }
  }
  return resolvedOptions;
}

function defaultSanitizer(context) {
  return isUndefined(context.value) ? context.definition.default(context) : context.value;
}

function requiredValidator(context, customErrorMessage) {
  if (isNull(context.value) || isUndefined(context.value) || isArray(context.value) && !context.value.length || typeof context.value === "boolean" && context.value !== true || typeof context.value === "number" && !isRealNumber(context.value) || typeof context.value === "string" && !context.value) {
    throw new Error(context.__(context.language, "pruvious-server", "This field is required"));
  }
}

function matchesConditionalLogic(input, fieldPath, conditionalLogic) {
  for (const [key, condition] of Object.entries(conditionalLogic)) {
    if (key === "$every") {
      if (!condition.every((rule) => matchesConditionalLogic(input, fieldPath, rule))) {
        return false;
      }
    } else if (key === "$some") {
      if (!condition.some((rule) => matchesConditionalLogic(input, fieldPath, rule))) {
        return false;
      }
    } else {
      const dependencyPath = new URL(
        key.replace(new RegExp("(?<!^|\\.)\\.", "gim"), "/"),
        `http://_/${fieldPath.replaceAll(".", "/")}`
      ).pathname.slice(1).replaceAll("/", ".").replace(/\.$/, "");
      const dependencyValue = getProperty(input, dependencyPath);
      if (isUndefined(dependencyValue)) {
        throw new Error(`The field '${dependencyPath}' is required in the input`);
      }
      if (isObject(condition)) {
        for (const [operator, value] of Object.entries(condition)) {
          let preparedValue = dependencyValue;
          if (operator === "gt" || operator === "gte" || operator === "lt" || operator === "lte") {
            if (isArray(dependencyValue)) {
              preparedValue = dependencyValue.length;
            } else if (typeof dependencyValue !== typeof value) {
              return false;
            }
          } else if (operator === "regexp" && !isString(dependencyValue)) {
            return false;
          }
          if (operator === "eq" && preparedValue !== value || operator === "ne" && preparedValue === value || operator === "gt" && preparedValue <= value || operator === "gte" && preparedValue < value || operator === "lt" && preparedValue >= value || operator === "lte" && preparedValue > value || operator === "regexp" && !new RegExp(value.toString()).test(preparedValue)) {
            return false;
          }
        }
      } else if (dependencyValue !== condition) {
        return false;
      }
    }
  }
  return true;
}

function resolveFieldPopulation(population) {
  return population ? {
    type: isString(population.type) ? { js: population.type, ts: population.type } : {
      js: population.type.js,
      ts: population.type.ts || population.type.js
    },
    populator: population.populator
  } : false;
}
function defineField(definition) {
  var _a, _b, _c;
  return {
    name: definition.name,
    type: isString(definition.type) ? {
      js: definition.type,
      ts: definition.type,
      db: definition.type === "boolean" ? "BOOLEAN" : definition.type === "number" ? "DECIMAL" : "TEXT"
    } : {
      js: definition.type.js,
      ts: definition.type.ts || definition.type.js,
      db: definition.type.db || (definition.type.js === "boolean" ? "BOOLEAN" : definition.type.js === "number" ? "DECIMAL" : "TEXT")
    },
    default: definition.default || (() => null),
    vueComponent: definition.vueComponent,
    vuePreviewComponent: definition.vuePreviewComponent ?? "",
    options: definition.options,
    sanitizers: definition.sanitizers || [],
    conditionalLogicMatcher: definition.conditionalLogicMatcher || (({ conditionalLogic, definition: definition2, input, name, options }) => {
      if (!matchesConditionalLogic(input, name, conditionalLogic)) {
        setProperty(input, name, definition2.default({ definition: definition2, name, options }));
        return false;
      }
      return true;
    }),
    validators: definition.validators || [],
    population: resolveFieldPopulation(definition.population),
    extractKeywords: definition.extractKeywords || (({ value }) => isObject(value) ? JSON.stringify(value) : isNull(value) ? "" : String(value)),
    serialize: definition.serialize ?? null,
    deserialize: definition.deserialize ?? null,
    inputMeta: {
      type: ((_a = definition.inputMeta) == null ? void 0 : _a.type) || ((context) => isString(context.definition.type) ? context.definition.type : (isString(context.definition.type.ts) ? context.definition.type.ts : context.definition.type.ts(context)) || context.definition.type.js),
      required: ((_b = definition.inputMeta) == null ? void 0 : _b.required) || (() => false),
      codeComment: ((_c = definition.inputMeta) == null ? void 0 : _c.codeComment) || (() => "")
    }
  };
}

function unifyLiteralStrings(...values) {
  return values.length ? values.sort().map((v) => `'${v.replaceAll("'", "\\'")}'`).join(" | ") : "never";
}

function numericSanitizer(context) {
  const casted = isString(context.value) ? +context.value : null;
  return isRealNumber(casted) ? casted : context.value;
}

function positiveIntegerOrNullValidator(context, customErrorMessage) {
  if (!isPositiveInteger(context.value) && !isNull(context.value)) {
    if (context.__ && context.language) {
      throw new Error(
        context.__(context.language, "pruvious-server", customErrorMessage ?? "Invalid input type")
      );
    } else {
      throw new Error(customErrorMessage ?? "Invalid input type");
    }
  }
}

defineField({
  name: "record",
  type: { js: "number", ts: "number | null", db: "BIGINT" },
  default: ({ options }) => options.default ?? null,
  vueComponent: void 0,
  options: {
    collection: {
      type: "MultiCollectionName",
      description: "The name of the multi-entry collection from which to retrieve a record.",
      required: true
    },
    fields: {
      type: "Record<string, true> | string[]",
      description: [
        "The fields of the selected collection to be returned when this field's value is populated.",
        "",
        "@default { id: true }"
      ],
      default: () => ({ id: true })
    },
    populate: {
      type: "boolean",
      description: [
        "Specifies whether to populate the fields of the selected collection.",
        "Exercise **caution** when using this option, as it may trigger infinite loops during population if the related collection fields depend on additional population loops.",
        "",
        "@default false"
      ],
      default: () => false
    },
    required: {
      type: "boolean",
      description: ["Specifies whether the field input is required during creation.", "", "@default false"],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'parentPage' => 'Parent page'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "number | null",
      description: ["The default field value.", "", "@default null"]
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input control.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    placeholder: {
      type: "string",
      description: ["Text that appears in the input element when it has no value set."]
    },
    clearable: {
      type: "boolean",
      description: [
        "A boolean indicating whether to display a clear button that removes the current input value.",
        "",
        "@default true"
      ],
      default: () => true
    },
    visibleChoices: {
      type: "number",
      description: ["The number of visible choices in the dropdown list (must be less than 30)."],
      default: () => 6
    },
    recordLabel: {
      type: "string | [string, string]",
      description: [
        "The collection field or fields used as the record label.",
        "When using multiple fields, the first field is used as the main label, and the second field is displayed only in search results.",
        "",
        "By default, the fields from the `dashboard.primaryField` and `dashboard.overviewTable.searchLabel` options of the selected collection are used."
      ]
    },
    details: {
      type: "string[]",
      description: [
        "An array of field names from the selected collection to display below the select input for the selected record.",
        "",
        "@default []"
      ],
      default: () => []
    }
  },
  population: {
    type: {
      js: "object",
      ts: ({ options }) => {
        const fields = options.fields ? isObject(options.fields) ? Object.keys(options.fields) : options.fields : ["id"];
        return (options.populate ? `Pick<PopulatedFieldType['${options.collection}'], ${unifyLiteralStrings(...fields)}>` : `Pick<CastedFieldType['${options.collection}'], ${unifyLiteralStrings(...fields)}>`) + " | null";
      }
    },
    populator: async ({ currentQuery, name, options, query, value }) => {
      var _a;
      const q = query(options.collection);
      q.maxPopulationDepth = currentQuery.maxPopulationDepth ?? {};
      (_a = q.maxPopulationDepth)[name] ?? (_a[name] = 30);
      q.maxPopulationDepth[name]--;
      if (options.populate && q.maxPopulationDepth[name] <= 0) {
        return null;
      }
      try {
        return isPositiveInteger(value) ? await q.select(options.fields).where("id", value).setFieldValueType(options.populate ? "populated" : "casted").first() : null;
      } catch {
        return null;
      }
    }
  },
  sanitizers: [(context) => context.options.required ? context.value : defaultSanitizer(context), numericSanitizer],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    positiveIntegerOrNullValidator,
    async ({ __, collections, language, value, options, query }) => {
      if (value && await query(options.collection).where("id", value).notExists()) {
        throw new Error(
          __(language, "pruvious-server", "The $item does not exist", {
            item: __(
              language,
              "pruvious-server",
              collections[options.collection].label.collection.singular
            )
          })
        );
      }
    }
  ],
  extractKeywords: async ({ collections, fields, fieldValueType, options, record, value }) => {
    if (fieldValueType === "populated") {
      try {
        const collection = collections[options.collection];
        const keywords = [];
        const fieldNames = isObject(options.fields) ? Object.keys(options.fields) : options.fields;
        for (const fieldName of fieldNames) {
          const declaration = collection.fields[fieldName];
          const definition = fields[declaration.type];
          keywords.push(
            (await definition.extractKeywords({
              collection,
              collections,
              definition,
              fields,
              fieldValueType,
              options: resolveCollectionFieldOptions(
                `record:${collection.name}.${fieldName}.${JSON.stringify(declaration)}`,
                declaration.type,
                fieldName,
                declaration.options,
                fields
              ),
              record,
              value: value[fieldName]
            })).trim()
          );
        }
        return keywords.join(" ");
      } catch {
      }
    }
    return isObject(value) ? JSON.stringify(value) : isNull(value) ? "" : String(value);
  },
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});
function vueField(options, additional) {
  return Object;
}

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Preset",
  __ssrInlineRender: true,
  props: {
    preset: vueField()
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
    };
  }
});

const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/blocks/standard/Preset.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=Preset.vue.mjs.map
