import { defineComponent, ref, withAsyncContext, unref, useSSRContext } from 'vue';
import { ssrRenderTeleport, ssrRenderStyle, ssrInterpolate } from 'vue/server-renderer';
import { debounce } from 'perfect-debounce';
import { u as usePage, l as loadTranslatableStrings, p as pruviousFetch, i as isKeyOf, a as isObject, b as isArray, _ as __ } from './_...slug_.vue.mjs';
import { b as useRoute, e as _export_sfc } from './server.mjs';
import 'vue-router';
import '@antfu/utils';
import 'dot-prop';
import '../nitro/nitro.mjs';
import 'nodemailer';
import 'zod/v4';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'crypto';
import 'fs-extra';
import 'path';
import 'node:url';
import 'fs';
import 'mime-types';
import 'redis';
import 'consola';
import 'pg';
import 'sequelize';
import 'pg-connection-string';
import 'colorette';
import '@aws-sdk/client-s3';
import 'jsonwebtoken';
import 'nanoid';
import 'pluralize-esm';
import 'argon2';
import 'sharp';
import 'accept-language-parser';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'unhead/plugins';
import 'bootstrap-vue-next/directives';
import 'bootstrap-vue-next/plugins/createBootstrap';
import 'bootstrap-vue-next/components/BContainer';
import 'bootstrap-vue-next/components/BImg';
import 'bootstrap-vue-next/components/BLink';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Preview",
  __ssrInlineRender: true,
  async setup(__props) {
    let __temp, __restore;
    const page = usePage();
    const route = useRoute();
    const blockLabels = ref({});
    const highlightedBlock = ref(null);
    const isMoving = ref(false);
    const visible = ref(false);
    [__temp, __restore] = withAsyncContext(() => loadTranslatableStrings("pruvious-dashboard")), await __temp, __restore();
    debounce(async () => {
      const response = await pruviousFetch("previews.get", { subpath: route.fullPath });
      if (response.success) {
        const top = (void 0).scrollY;
        mergePageProps(response.data);
        highlightedBlock.value = null;
        for (let i = 0; i < 25; i++) {
          await new Promise(
            (resolve) => setTimeout(() => {
              (void 0).scrollTo({ top, behavior: "instant" });
              setTimeout(resolve);
            })
          );
          if ((void 0).scrollY === top) {
            break;
          }
        }
      }
    }, 25);
    function mergePageProps(source, target) {
      target ?? (target = page.value);
      for (const key in source) {
        if (isKeyOf(target, key)) {
          if (isObject(source[key]) && isObject(target[key])) {
            mergePageProps(source[key], target[key]);
          } else if (isArray(source[key]) && isArray(target[key])) {
            target[key].splice(source[key].length);
            for (const [i, item] of source[key].entries()) {
              if (isObject(item) && isObject(target[key][i])) {
                mergePageProps(item, target[key][i]);
              } else if (item !== target[key][i]) {
                target[key][i] = item;
              }
            }
          } else if (source[key] !== target[key]) {
            target[key] = source[key];
          }
        } else {
          target[key] = source[key];
        }
      }
      for (const key in target) {
        if (!source.hasOwnProperty(key)) {
          delete target[key];
        }
      }
      return target;
    }
    return (_ctx, _push, _parent, _attrs) => {
      ssrRenderTeleport(_push, (_push2) => {
        if (unref(visible) && unref(highlightedBlock) && !unref(isMoving)) {
          _push2(`<div class="rect" style="${ssrRenderStyle({
            top: unref(highlightedBlock).top + "px",
            left: unref(highlightedBlock).left + "px",
            width: unref(highlightedBlock).width + "px",
            height: unref(highlightedBlock).height + "px"
          })}" data-v-74a1b9d8><span class="label" data-v-74a1b9d8>${ssrInterpolate(unref(__)("pruvious-dashboard", unref(blockLabels)[unref(highlightedBlock).name]))}</span></div>`);
        } else {
          _push2(`<!---->`);
        }
      }, "body", false, _parent);
    };
  }
});

const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/Preview.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const Preview = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-74a1b9d8"]]);

export { Preview as default };
//# sourceMappingURL=Preview.vue.mjs.map
