import { defineComponent, ref, watch, mergeProps, useAttrs, computed, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent } from 'vue/server-renderer';
import { d as defineBlock, a as additionalFields } from './block.definition.mjs';
import { n as navigateTo } from './server.mjs';
import '../nitro/nitro.mjs';
import 'nodemailer';
import 'zod/v4';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'crypto';
import 'fs-extra';
import 'path';
import 'node:url';
import 'fs';
import 'mime-types';
import '@antfu/utils';
import 'dot-prop';
import 'redis';
import 'consola';
import 'pg';
import 'sequelize';
import 'pg-connection-string';
import 'colorette';
import '@aws-sdk/client-s3';
import 'jsonwebtoken';
import 'nanoid';
import 'pluralize-esm';
import 'argon2';
import 'sharp';
import 'accept-language-parser';
import 'vue-router';
import 'bootstrap-vue-next/directives';
import 'bootstrap-vue-next/plugins/createBootstrap';
import 'bootstrap-vue-next/components/BContainer';
import 'bootstrap-vue-next/components/BImg';
import 'bootstrap-vue-next/components/BLink';

const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "HTML",
  __ssrInlineRender: true,
  props: {
    /**
     * The HTML content to render.
     */
    html: String
  },
  setup(__props) {
    const props = __props;
    const el = ref();
    watch(
      () => props.html,
      () => {
        setTimeout(() => {
          var _a;
          (_a = el.value) == null ? void 0 : _a.querySelectorAll("a").forEach((a) => {
            const href = a.getAttribute("href");
            if (href && !href.startsWith("http") && (a.target === "_self" || !a.target)) {
              a.addEventListener("click", (event) => {
                if (!event.defaultPrevented) {
                  event.preventDefault();
                  if (event.metaKey || event.ctrlKey) {
                    (void 0).open(href, "_blank");
                  } else {
                    navigateTo(href);
                  }
                }
              });
            }
          });
        });
      },
      { immediate: true }
    );
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        ref_key: "el",
        ref: el
      }, _attrs))}>${__props.html ?? ""}</div>`);
    };
  }
});

const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "RichTextBlock",
  __ssrInlineRender: true,
  setup(__props) {
    defineBlock({
      fields: {
        ...additionalFields("classes", "styles")
      }
    });
    const attrs = useAttrs();
    const blockProps = computed(() => {
      const { html, customClasses, customStyles } = attrs;
      return {
        html: html || void 0,
        class: customClasses || void 0,
        style: customStyles || void 0
      };
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_PruviousHTML = _sfc_main$1;
      _push(ssrRenderComponent(_component_PruviousHTML, mergeProps(unref(blockProps), _attrs), null, _parent));
    };
  }
});

const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("blocks/RichTextBlock.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=RichTextBlock.vue.mjs.map
