import { BCol } from 'bootstrap-vue-next/components/BContainer';
import { defineComponent, useAttrs, computed, mergeProps, unref, withCtx, renderSlot, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderSlot } from 'vue/server-renderer';
import { d as defineBlock, a as additionalFields, b as alignmentVerticalSelectField, f as colsNumbersSelectField, h as parseColsNumbersValue } from './block.definition.mjs';

const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "RowColBlock",
  __ssrInlineRender: true,
  setup(__props) {
    defineBlock({
      fields: {
        cols: colsNumbersSelectField({ options: { auto: true } }),
        sm: colsNumbersSelectField({ options: { auto: true, boolean: true } }),
        md: colsNumbersSelectField({ options: { auto: true, boolean: true } }),
        lg: colsNumbersSelectField({ options: { auto: true, boolean: true } }),
        xl: colsNumbersSelectField({ options: { auto: true, boolean: true } }),
        xxl: colsNumbersSelectField({ options: { auto: true, boolean: true } }),
        alignSelf: alignmentVerticalSelectField({
          options: {
            auto: true
          }
        }),
        ...additionalFields("classes", "styles", "responsive_control")
      }
    });
    const attrs = useAttrs();
    const blockProps = computed(() => {
      const fields = attrs;
      return {
        col: fields.col ?? void 0,
        cols: parseColsNumbersValue(fields.cols),
        sm: parseColsNumbersValue(fields.sm),
        md: parseColsNumbersValue(fields.md),
        lg: parseColsNumbersValue(fields.lg),
        xl: parseColsNumbersValue(fields.xl),
        xxl: parseColsNumbersValue(fields.xxl),
        class: fields.customClasses || void 0,
        style: fields.customStyles || void 0
      };
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_BCol = BCol;
      _push(ssrRenderComponent(_component_BCol, mergeProps(unref(blockProps), _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            ssrRenderSlot(_ctx.$slots, "default", {}, null, _push2, _parent2, _scopeId);
          } else {
            return [
              renderSlot(_ctx.$slots, "default")
            ];
          }
        }),
        _: 3
      }, _parent));
    };
  }
});

const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("blocks/RowColBlock.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=RowColBlock.vue.mjs.map
