import { defineComponent, shallowRef, getCurrentInstance, provide, cloneVNode, h, createElementBlock, toRef, isRef, defineAsyncComponent, inject, computed, unref, Suspense, nextTick, mergeProps, shallowReactive, watch, createVNode, resolveDynamicComponent, createSlots, renderList, withCtx, createBlock, openBlock, hasInjectionContext, ref, withAsyncContext, renderSlot, createCommentVNode, useSSRContext } from 'vue';
import { ssrRenderList, ssrRenderComponent, ssrRenderVNode, ssrRenderAttrs, ssrRenderSlot } from 'vue/server-renderer';
import { u as useNuxtApp, a as useRuntimeConfig, P as PageRouteSymbol, b as useRoute, c as appLayoutTransition, _ as _wrapInTransition, L as LayoutMetaSymbol, d as createError, t as tryUseNuxtApp, n as navigateTo, e as _export_sfc } from './server.mjs';
import { useRoute as useRoute$1 } from 'vue-router';
import { isDef, isNull as isNull$1, isUndefined as isUndefined$1, isString as isString$1, toArray as toArray$1, isObject as isObject$1, isKeyOf as isKeyOf$1 } from '@antfu/utils';
import { setProperty as setProperty$1, getProperty as getProperty$1 } from 'dot-prop';
import { G as withoutTrailingSlash, H as cleanDoubleSlashes, z as joinURL, I as kebabCase$1 } from '../nitro/nitro.mjs';
import { u as useHead$1, h as headSymbol } from '../routes/renderer.mjs';

const isDefined = isDef;
const isNull = isNull$1;
const isUndefined = isUndefined$1;

function capitalize(value, lowercaseRest = true) {
  var _a, _b;
  return (((_a = value[0]) == null ? void 0 : _a.toUpperCase()) ?? "") + (lowercaseRest ? ((_b = value.slice(1)) == null ? void 0 : _b.toLowerCase()) ?? "" : value.slice(1));
}
function isAlphanumeric(character) {
  const code = character.charCodeAt(0);
  return code >= 65 && code <= 90 || // A-Z
  code >= 97 && code <= 122 || // a-z
  code >= 48 && code <= 57;
}
const isString = isString$1;
function joinRouteParts(...parts) {
  var _a;
  const parsedParts = parts.filter(Boolean).map((part) => part.replaceAll("\\", "/"));
  if ((_a = parsedParts[0]) == null ? void 0 : _a.includes(":")) {
    parsedParts[0] = parsedParts[0].replace(/^[a-z]:[\\\/]/i, "");
  }
  return withoutTrailingSlash(cleanDoubleSlashes(joinURL("/", ...parsedParts)));
}
function kebabCase(value) {
  return kebabCase$1(value);
}
function titleCase(value, capitalizeAll = true) {
  if (!isString(value)) {
    return "";
  }
  return kebabCase(value).split("-").map((word) => word.trim()).filter(Boolean).map((word, i) => i === 0 || capitalizeAll ? capitalize(word) : word).join(" ");
}

function isArray(array) {
  return Array.isArray(array);
}
const toArray = toArray$1;

function getProperty(object, path) {
  return getProperty$1(object, path.replace(/\.([0-9]+)(\.|$)/gm, "[$1]$2"));
}
function isKeyOf(object, key) {
  return isKeyOf$1(object, key);
}
const isObject = isObject$1;
function setProperty(object, path, value) {
  return setProperty$1(object, path.replace(/\.([0-9]+)(\.|$)/gm, "[$1]$2"), value);
}

const clientOnlySymbol = Symbol.for("nuxt:client-only");
const __nuxt_component_2 = defineComponent({
  name: "ClientOnly",
  inheritAttrs: false,
  props: ["fallback", "placeholder", "placeholderTag", "fallbackTag"],
  setup(props, { slots, attrs }) {
    const mounted = shallowRef(false);
    const vm = getCurrentInstance();
    if (vm) {
      vm._nuxtClientOnly = true;
    }
    provide(clientOnlySymbol, true);
    return () => {
      var _a;
      if (mounted.value) {
        const vnodes = (_a = slots.default) == null ? void 0 : _a.call(slots);
        if (vnodes && vnodes.length === 1) {
          return [cloneVNode(vnodes[0], attrs)];
        }
        return vnodes;
      }
      const slot = slots.fallback || slots.placeholder;
      if (slot) {
        return h(slot);
      }
      const fallbackStr = props.fallback || props.placeholder || "";
      const fallbackTag = props.fallbackTag || props.placeholderTag || "span";
      return createElementBlock(fallbackTag, attrs, fallbackStr);
    };
  }
});

const useStateKeyPrefix = "$s";
function useState(...args) {
  const autoKey = typeof args[args.length - 1] === "string" ? args.pop() : void 0;
  if (typeof args[0] !== "string") {
    args.unshift(autoKey);
  }
  const [_key, init] = args;
  if (!_key || typeof _key !== "string") {
    throw new TypeError("[nuxt] [useState] key must be a string: " + _key);
  }
  if (init !== void 0 && typeof init !== "function") {
    throw new Error("[nuxt] [useState] init must be a function: " + init);
  }
  const key = useStateKeyPrefix + _key;
  const nuxtApp = useNuxtApp();
  const state = toRef(nuxtApp.payload.state, key);
  if (state.value === void 0 && init) {
    const initialValue = init();
    if (isRef(initialValue)) {
      nuxtApp.payload.state[key] = initialValue;
      return initialValue;
    }
    state.value = initialValue;
  }
  return state;
}

const useAuth = () => useState("pruvious-auth", () => ({
  isLoggedIn: false,
  userId: null
}));

const useLanguage = () => useState("pruvious-language", () => null);
function getLanguage() {
  const language = useLanguage();
  if (!language.value) {
    language.value = resolveLanguage();
  }
  return language.value;
}
function resolveLanguage() {
  const nuxtApp = useNuxtApp();
  const runtimeConfig = useRuntimeConfig();
  const options = runtimeConfig.public.pruvious.language;
  options.primary;
  {
    return nuxtApp.ssrContext.event.context.language || runtimeConfig.public.pruvious.language.primary;
  }
}

function getRawToken() {
  return null;
}

async function pruviousFetch(path, options) {
  const defaultOptions = {};
  (options == null ? void 0 : options.dispatchEvents) !== false;
  let resolvedPath = "/";
  let error;
  let code;
  defaultOptions.method = path.split(".").pop().toUpperCase();
  defaultOptions.method = defaultOptions.method && ["GET", "POST", "PATCH", "DELETE"].includes(defaultOptions.method) ? defaultOptions.method : "GET";
  resolvedPath = pruviousApiPath(path);
  if (options == null ? void 0 : options.subpath) {
    resolvedPath = joinRouteParts(resolvedPath, options.subpath);
  }
  if (options && isObject(options.body)) {
    options.body = Object.fromEntries(
      Object.entries(options.body).map(([key, value]) => [key, isRef(value) ? value.value : value])
    );
  }
  const token = getRawToken();
  const headers = (options == null ? void 0 : options.headers) ?? {};
  if (!headers["Accept-Language"]) {
    headers["Accept-Language"] = getLanguage();
  }
  if (!headers["Authorization"] && token) ;
  const data = await $fetch(resolvedPath, {
    headers,
    onRequest() {
    },
    onResponse: ({ response }) => {
      code = response.status;
    },
    onResponseError: ({ response }) => {
      if (response.status === 401) ;
    },
    ...defaultOptions,
    ...options ?? {}
  }).catch((e) => error = e).finally(() => {
  });
  return error ? { success: false, code, error: error.data || error.message || "" } : { success: true, code, data };
}
function pruviousApiPath(base, ...path) {
  const runtimeConfig = useRuntimeConfig();
  return joinRouteParts(
    runtimeConfig.app.baseURL,
    // The subdirectory
    runtimeConfig.public.pruvious.api.prefix,
    runtimeConfig.public.pruvious.api.routes[base] || base.split(".")[0],
    ...path.map(String)
  );
}

function replacePlaceholders(text, strings, input = {}) {
  var _a, _b, _c;
  const string = strings[String(text)];
  if (isString(string)) {
    return string;
  } else if (string) {
    const tokens = tokenizePlaceholders(string.pattern);
    for (const token of tokens) {
      if (token.type === "placeholder") {
        const replacements = (_a = string.replacements) == null ? void 0 : _a[token.value];
        if (isString(replacements)) {
          token.value = replacements;
        } else if (replacements) {
          token.value = "";
          for (const replacement of replacements) {
            if (isString(replacement)) {
              token.value = replacement;
              break;
            } else {
              let pass = true;
              for (const conditionObject of replacement.conditions) {
                if (!pass) break;
                for (const [inputKey, condition] of Object.entries(conditionObject)) {
                  if (!pass) break;
                  const inputValue = input[inputKey] ?? (((_b = string.input) == null ? void 0 : _b[inputKey]) === "boolean" ? false : ((_c = string.input) == null ? void 0 : _c[inputKey]) === "number" ? 0 : "");
                  if (isObject(condition)) {
                    for (const [operator, value] of Object.entries(condition)) {
                      if (operator === "eq" && inputValue !== value || operator === "ne" && inputValue === value || operator === "gt" && inputValue <= value || operator === "gte" && inputValue < value || operator === "lt" && inputValue >= value || operator === "lte" && inputValue > value || operator === "regexp" && !new RegExp(value.toString()).test(inputValue.toString())) {
                        pass = false;
                        break;
                      }
                    }
                  } else if (inputValue !== condition) {
                    pass = false;
                    break;
                  }
                }
              }
              if (pass) {
                token.value = replacement.output;
                break;
              }
            }
          }
        } else if (isDefined(input[token.value])) {
          token.value = input[token.value].toString();
        } else {
          token.value = "";
        }
      }
    }
    return tokens.map(({ value }) => value).join("");
  }
  return "";
}
function tokenizePlaceholders(pattern) {
  const tokens = [];
  let i = 0;
  let literal = "";
  while (i < pattern.length) {
    if (pattern[i] === "$") {
      i++;
      if (pattern[i] !== "$") {
        let placeholder = "";
        while (i < pattern.length && isAlphanumeric(pattern[i])) {
          placeholder += pattern[i];
          i++;
        }
        if (placeholder) {
          if (literal) {
            tokens.push({ value: literal, type: "literal" });
            literal = "";
          }
          tokens.push({ value: placeholder, type: "placeholder" });
        }
      } else {
        literal += "$";
        i++;
      }
    } else {
      literal += pattern[i];
      i++;
    }
  }
  if (literal) {
    tokens.push({ value: literal, type: "literal" });
  }
  return tokens;
}

const useTranslatableStrings = () => useState("pruvious-translatable-strings", () => ({}));
function __(domain, text, input) {
  var _a, _b, _c, _d, _e, _f;
  const ts = useTranslatableStrings();
  const language = useLanguage().value ?? "";
  const cacheKey = text + (input ? `|${JSON.stringify(input)}` : "");
  if (((_b = (_a = ts.value[domain]) == null ? void 0 : _a[language]) == null ? void 0 : _b.strings) && ((_c = ts.value[domain]) == null ? void 0 : _c[language].strings) !== "pending" && !isKeyOf(ts.value[domain][language].cache, cacheKey)) {
    ts.value[domain][language].cache[cacheKey] = replacePlaceholders(
      text,
      (_d = ts.value[domain]) == null ? void 0 : _d[language].strings,
      input
    );
  }
  return ((_f = (_e = ts.value[domain]) == null ? void 0 : _e[language]) == null ? void 0 : _f.cache[cacheKey]) || text;
}
async function loadTranslatableStrings(domain, language) {
  var _a, _b;
  const ts = useTranslatableStrings();
  const promises = [];
  domain || (domain = "default");
  language || (language = getLanguage());
  for (const d of toArray(domain)) {
    if (!((_a = ts.value[d]) == null ? void 0 : _a[language])) {
      (_b = ts.value)[d] || (_b[d] = {});
      ts.value[d][language] = { strings: "pending", cache: {} };
      promises.push(
        pruviousFetch("translatable-strings.get", { subpath: d, query: { language } }).then((response) => {
          ts.value[d][language].strings = response.success ? response.data : {};
        })
      );
    }
  }
  await Promise.all(promises);
}

const layouts = {
  default: defineAsyncComponent(() => import('./default.vue.mjs').then((m) => m.default || m))
};

const LayoutLoader = defineComponent({
  name: "LayoutLoader",
  inheritAttrs: false,
  props: {
    name: String,
    layoutProps: Object
  },
  setup(props, context) {
    return () => h(layouts[props.name], props.layoutProps, context.slots);
  }
});
const nuxtLayoutProps = {
  name: {
    type: [String, Boolean, Object],
    default: null
  },
  fallback: {
    type: [String, Object],
    default: null
  }
};
const __nuxt_component_0 = defineComponent({
  name: "NuxtLayout",
  inheritAttrs: false,
  props: nuxtLayoutProps,
  setup(props, context) {
    const nuxtApp = useNuxtApp();
    const injectedRoute = inject(PageRouteSymbol);
    const shouldUseEagerRoute = !injectedRoute || injectedRoute === useRoute();
    const route = shouldUseEagerRoute ? useRoute$1() : injectedRoute;
    const layout = computed(() => {
      let layout2 = unref(props.name) ?? (route == null ? void 0 : route.meta.layout) ?? "default";
      if (layout2 && !(layout2 in layouts)) {
        if (props.fallback) {
          layout2 = unref(props.fallback);
        }
      }
      return layout2;
    });
    const layoutRef = shallowRef();
    context.expose({ layoutRef });
    const done = nuxtApp.deferHydration();
    let lastLayout;
    return () => {
      const hasLayout = layout.value && layout.value in layouts;
      const transitionProps = (route == null ? void 0 : route.meta.layoutTransition) ?? appLayoutTransition;
      const previouslyRenderedLayout = lastLayout;
      lastLayout = layout.value;
      return _wrapInTransition(hasLayout && transitionProps, {
        default: () => h(Suspense, { suspensible: true, onResolve: () => {
          nextTick(done);
        } }, {
          default: () => h(
            LayoutProvider,
            {
              layoutProps: mergeProps(context.attrs, { ref: layoutRef }),
              key: layout.value || void 0,
              name: layout.value,
              shouldProvide: !props.name,
              isRenderingNewLayout: (name) => {
                return name !== previouslyRenderedLayout && name === layout.value;
              },
              hasTransition: !!transitionProps
            },
            context.slots
          )
        })
      }).default();
    };
  }
});
const LayoutProvider = defineComponent({
  name: "NuxtLayoutProvider",
  inheritAttrs: false,
  props: {
    name: {
      type: [String, Boolean]
    },
    layoutProps: {
      type: Object
    },
    hasTransition: {
      type: Boolean
    },
    shouldProvide: {
      type: Boolean
    },
    isRenderingNewLayout: {
      type: Function,
      required: true
    }
  },
  setup(props, context) {
    const name = props.name;
    if (props.shouldProvide) {
      provide(LayoutMetaSymbol, {
        isCurrent: (route) => name === (route.meta.layout ?? "default")
      });
    }
    const injectedRoute = inject(PageRouteSymbol);
    const isNotWithinNuxtPage = injectedRoute && injectedRoute === useRoute();
    if (isNotWithinNuxtPage) {
      const vueRouterRoute = useRoute$1();
      const reactiveChildRoute = {};
      for (const _key in vueRouterRoute) {
        const key = _key;
        Object.defineProperty(reactiveChildRoute, key, {
          enumerable: true,
          get: () => {
            return props.isRenderingNewLayout(props.name) ? vueRouterRoute[key] : injectedRoute[key];
          }
        });
      }
      provide(PageRouteSymbol, shallowReactive(reactiveChildRoute));
    }
    return () => {
      var _a, _b;
      if (!name || typeof name === "string" && !(name in layouts)) {
        return (_b = (_a = context.slots).default) == null ? void 0 : _b.call(_a);
      }
      return h(
        LayoutLoader,
        { key: name, layoutProps: props.layoutProps, name },
        context.slots
      );
    };
  }
});

const blocks = {
  AccordionBlock: () => defineAsyncComponent(() => import('./AccordionBlock.vue.mjs')),
  AccordionItemBlock: () => defineAsyncComponent(() => import('./AccordionItemBlock.vue.mjs')),
  AlertBlock: () => defineAsyncComponent(() => import('./AlertBlock.vue.mjs')),
  BadgeBlock: () => defineAsyncComponent(() => import('./BadgeBlock.vue.mjs')),
  CarouselBlock: () => defineAsyncComponent(() => import('./CarouselBlock.vue.mjs')),
  CarouselSlideBlock: () => defineAsyncComponent(() => import('./CarouselSlideBlock.vue.mjs')),
  CarouselSlideContentBlock: () => defineAsyncComponent(() => import('./CarouselSlideContentBlock.vue.mjs')),
  ContainerBlock: () => defineAsyncComponent(() => import('./ContainerBlock.vue.mjs')),
  ContainerRowBlock: () => defineAsyncComponent(() => import('./ContainerRowBlock.vue.mjs')),
  FormBlock: () => defineAsyncComponent(() => import('./FormBlock.vue.mjs')),
  HTMLBlock: () => defineAsyncComponent(() => import('./HTMLBlock.vue.mjs')),
  IconBlock: () => defineAsyncComponent(() => import('./IconBlock.vue.mjs')),
  ImageBlock: () => defineAsyncComponent(() => import('./ImageBlock.vue.mjs')),
  LinkBlock: () => defineAsyncComponent(() => import('./LinkBlock.vue.mjs')),
  ListGroupBlock: () => defineAsyncComponent(() => import('./ListGroupBlock.vue.mjs')),
  ListGroupItemBlock: () => defineAsyncComponent(() => import('./ListGroupItemBlock.vue.mjs')),
  NewsBlock: () => defineAsyncComponent(() => import('./NewsBlock.vue.mjs')),
  PageElementBlock: () => defineAsyncComponent(() => import('./PageElementBlock.vue.mjs')),
  RichTextBlock: () => defineAsyncComponent(() => import('./RichTextBlock.vue.mjs')),
  RowColBlock: () => defineAsyncComponent(() => import('./RowColBlock.vue.mjs')),
  Preset: () => defineAsyncComponent(() => import('./Preset.vue.mjs'))
};

const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "Blocks",
  __ssrInlineRender: true,
  props: {
    blocks: {
      type: Array,
      required: true
    },
    keyPrefix: {
      type: String,
      default: "blocks"
    },
    isPreset: {
      type: Boolean,
      default: false
    },
    fixedKey: {
      type: String
    },
    parents: {
      type: Array,
      default: () => []
    }
  },
  setup(__props) {
    const props = __props;
    const route = useRoute();
    const components = {};
    watch(
      () => props.blocks,
      (blocks$1) => {
        blocks$1.forEach(({ block }) => {
          if (block.name !== "Preset") {
            components[block.name] = blocks[block.name]();
          }
        });
      },
      { immediate: true, deep: !!route.query.__p }
    );
    return (_ctx, _push, _parent, _attrs) => {
      const _component_PruviousBlocks = _sfc_main$2;
      _push(`<!--[-->`);
      ssrRenderList(__props.blocks, ({ block }, i) => {
        var _a;
        _push(`<!--[-->`);
        if (block.name === "Preset" && ((_a = block.fields.preset) == null ? void 0 : _a.blocks)) {
          _push(ssrRenderComponent(_component_PruviousBlocks, {
            blocks: block.fields.preset.blocks,
            fixedKey: __props.fixedKey || __props.keyPrefix && unref(route).query.__p ? `${__props.keyPrefix}.${i}` : void 0,
            isPreset: true,
            parents: __props.parents
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        if (block.name !== "Preset") {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(components[block.name]), mergeProps({ ref_for: true }, block.fields, {
            __block: block,
            __index: i,
            __list: __props.blocks,
            __parents: __props.parents,
            "data-pruvious-block-key": __props.fixedKey || (__props.keyPrefix && !__props.isPreset && unref(route).query.__p ? `${__props.keyPrefix}.${i}` : void 0),
            "data-pruvious-block-name": unref(route).query.__p ? block.name : void 0,
            fixedKey: __props.fixedKey,
            isPreset: __props.isPreset
          }), createSlots({ _: 2 }, [
            renderList(Object.entries(block.slots ?? {}).filter(([_slot, blocks2]) => Boolean(blocks2 == null ? void 0 : blocks2.length)), ([slotName, childBlocks]) => {
              return {
                name: slotName,
                fn: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(ssrRenderComponent(_component_PruviousBlocks, {
                      blocks: childBlocks,
                      fixedKey: __props.fixedKey,
                      isPreset: __props.isPreset,
                      keyPrefix: `${__props.keyPrefix}.${i}.block.slots.${slotName}`,
                      parents: [...__props.parents, block]
                    }, null, _parent2, _scopeId));
                  } else {
                    return [
                      (openBlock(), createBlock(_component_PruviousBlocks, {
                        blocks: childBlocks,
                        fixedKey: __props.fixedKey,
                        isPreset: __props.isPreset,
                        keyPrefix: `${__props.keyPrefix}.${i}.block.slots.${slotName}`,
                        parents: [...__props.parents, block]
                      }, null, 8, ["blocks", "fixedKey", "isPreset", "keyPrefix", "parents"]))
                    ];
                  }
                })
              };
            })
          ])), _parent);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]-->`);
    };
  }
});

const usePage = () => useState("pruvious-page", () => null);
async function getPage(path) {
  const language = useLanguage();
  const page = usePage();
  const route = useRoute();
  const subpath = path ?? route.fullPath;
  const response = subpath.includes("__p=") ? await pruviousFetch("previews.get", { subpath }) : await pruviousFetch("pages.get", { subpath });
  if (response.success) {
    if (response.code === 301 || response.code === 302) {
      page.value = null;
      return { to: response.data, code: response.code };
    } else {
      page.value = response.data;
      language.value = response.data.language;
    }
  } else {
    page.value = null;
    {
      throw createError({ statusCode: 404 });
    }
  }
  return null;
}

function injectHead(nuxtApp) {
  var _a;
  const nuxt = nuxtApp || tryUseNuxtApp();
  return ((_a = nuxt == null ? void 0 : nuxt.ssrContext) == null ? void 0 : _a.head) || (nuxt == null ? void 0 : nuxt.runWithContext(() => {
    if (hasInjectionContext()) {
      return inject(headSymbol);
    }
  }));
}
function useHead(input, options = {}) {
  const head = injectHead(options.nuxt);
  if (head) {
    return useHead$1(input, { head, ...options });
  }
}

const __nuxt_component_3_lazy = defineAsyncComponent(() => import('./Preview.vue.mjs').then((c) => c.default || c));
const __nuxt_component_4_lazy = defineAsyncComponent(() => import('./EditLink.vue.mjs').then(function (n) { return n.E; }).then((c) => c.default || c));
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "Page",
  __ssrInlineRender: true,
  async setup(__props) {
    let __temp, __restore;
    const auth = useAuth();
    const nuxtApp = useNuxtApp();
    const page = ref(null);
    const pruviousPage = usePage();
    const route = useRoute();
    if (!nuxtApp.isHydrating) {
      [__temp, __restore] = withAsyncContext(() => loadTranslatableStrings("default")), await __temp, __restore();
      const redirect = ([__temp, __restore] = withAsyncContext(() => getPage()), __temp = await __temp, __restore(), __temp);
      if (pruviousPage.value) {
        useHead({
          title: pruviousPage.value.title,
          htmlAttrs: pruviousPage.value.htmlAttrs,
          meta: pruviousPage.value.meta,
          script: pruviousPage.value.script,
          link: pruviousPage.value.link
        });
      } else if (redirect) {
        [__temp, __restore] = withAsyncContext(() => navigateTo(redirect.to, {
          redirectCode: redirect.code,
          replace: true,
          external: redirect.to.startsWith("http")
        })), await __temp, __restore();
      }
    }
    page.value = pruviousPage.value;
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      const _component_NuxtLayout = __nuxt_component_0;
      const _component_PruviousBlocks = _sfc_main$2;
      const _component_ClientOnly = __nuxt_component_2;
      const _component_LazyPruviousPreview = __nuxt_component_3_lazy;
      const _component_LazyPruviousEditLink = __nuxt_component_4_lazy;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      _push(ssrRenderComponent(_component_NuxtLayout, {
        name: (_a = unref(page)) == null ? void 0 : _a.layout
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            ssrRenderSlot(_ctx.$slots, "default", {}, () => {
              var _a2;
              if ((_a2 = unref(page)) == null ? void 0 : _a2.blocks) {
                _push2(ssrRenderComponent(_component_PruviousBlocks, {
                  blocks: unref(page).blocks
                }, null, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
            }, _push2, _parent2, _scopeId);
            _push2(ssrRenderComponent(_component_ClientOnly, null, {}, _parent2, _scopeId));
          } else {
            return [
              renderSlot(_ctx.$slots, "default", {}, () => {
                var _a2;
                return [
                  ((_a2 = unref(page)) == null ? void 0 : _a2.blocks) ? (openBlock(), createBlock(_component_PruviousBlocks, {
                    key: 0,
                    blocks: unref(page).blocks
                  }, null, 8, ["blocks"])) : createCommentVNode("", true)
                ];
              }),
              createVNode(_component_ClientOnly, null, {
                default: withCtx(() => [
                  unref(page) && unref(route).query.__p ? (openBlock(), createBlock(_component_LazyPruviousPreview, { key: 0 })) : createCommentVNode("", true),
                  unref(page) && unref(auth).isLoggedIn ? (openBlock(), createBlock(_component_LazyPruviousEditLink, { key: 1 })) : createCommentVNode("", true)
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 3
      }, _parent));
      _push(`</div>`);
    };
  }
});

const _sfc_main = {};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs) {
  const _component_PruviousPage = _sfc_main$1;
  _push(ssrRenderComponent(_component_PruviousPage, _attrs, null, _parent));
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/pages/[...slug].vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const ____slug_ = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender]]);

const ____slug__vue = /*#__PURE__*/Object.freeze(/*#__PURE__*/Object.defineProperty({
  __proto__: null,
  default: ____slug_
}, Symbol.toStringTag, { value: 'Module' }));

export { __ as _, isObject as a, isArray as b, useState as c, useAuth as d, isString as e, useHead as f, getLanguage as g, isUndefined as h, isKeyOf as i, joinRouteParts as j, isNull as k, loadTranslatableStrings as l, getProperty as m, ____slug__vue as n, pruviousFetch as p, setProperty as s, titleCase as t, usePage as u };
//# sourceMappingURL=_...slug_.vue.mjs.map
