const additionalFields = (...fields) => {
  if (fields.length === 0) {
    throw new Error("No additional fields provided");
  }
  const res = {};
  if (fields.includes("classes")) {
    Object.assign(res, {
      addCustomClasses: {
        type: "switch",
        options: {
          label: "Кастомные классы",
          description: "Позволяет добавлять кастомные классы к блоку",
          default: false,
          trueLabel: "Вкл.",
          falseLabel: "Выкл."
        }
      },
      customClasses: {
        type: "text",
        options: {
          label: "Классы",
          trim: true,
          required: false
        },
        additional: {
          conditionalLogic: {
            addCustomClasses: true
          }
        }
      }
    });
  }
  if (fields.includes("styles")) {
    Object.assign(res, {
      addCustomStyles: {
        type: "switch",
        options: {
          label: "Кастомные стили",
          description: "Позволяет добавлять кастомные стили к блоку",
          default: false,
          trueLabel: "Вкл.",
          falseLabel: "Выкл."
        }
      },
      customStyles: {
        type: "text",
        options: {
          trim: true,
          required: false,
          label: "Стили"
        },
        additional: {
          conditionalLogic: {
            addCustomStyles: true
          }
        }
      }
    });
  }
  if (fields.includes("responsive_control")) {
    Object.assign(res, {
      isResponsive: {
        type: "switch",
        options: {
          label: "Адаптивность",
          description: "Позволяет управлять видимостью блока на разных устройствах",
          required: false,
          default: false,
          trueLabel: "Вкл",
          falseLabel: "Выкл"
        }
      },
      bpMode: {
        type: "select",
        additional: {
          conditionalLogic: { isResponsive: true }
        },
        options: {
          label: "Режим отображения",
          required: true,
          choices: {
            [
              "d-sm-none $D_VALUE"
              /* HIDDEN_ON_SM */
            ]: "Скрыть на sm+ | Показать только на xs",
            [
              "d-md-none $D_VALUE"
              /* HIDDEN_ON_MD */
            ]: "Скрыть на md+",
            [
              "d-lg-none $D_VALUE"
              /* HIDDEN_ON_LG */
            ]: "Скрыть на lg+",
            [
              "d-xl-none $D_VALUE"
              /* HIDDEN_ON_XL */
            ]: "Скрыть на xl+",
            [
              "d-none d-sm-$D_VALUE"
              /* HIDDEN_ONLY_ON_XS */
            ]: "Скрыть только на xs | Показать на sm+",
            [
              "d-sm-none d-md-$D_VALUE"
              /* HIDDEN_ONLY_ON_SM */
            ]: "Скрыть только на sm",
            [
              "d-md-none d-lg-$D_VALUE"
              /* HIDDEN_ONLY_ON_MD */
            ]: "Скрыть только на md",
            [
              "d-lg-none d-xl-$D_VALUE"
              /* HIDDEN_ONLY_ON_LG */
            ]: "Скрыть только на lg",
            [
              "d-xl-none d-xxl-$D_VALUE"
              /* HIDDEN_ONLY_ON_XL */
            ]: "Скрыть только на xl",
            [
              "d-xxl-none d-$D_VALUE"
              /* HIDDEN_ONLY_ON_XXL */
            ]: "Скрыть только на xxl",
            [
              "d-none"
              /* HIDDEN_ON_ALL */
            ]: "Скрыть на всех",
            [
              "d-$D_VALUE"
              /* VISIBLE_ON_ALL */
            ]: "Показать на всех",
            [
              "d-none d-md-$D_VALUE"
              /* VISIBLE_ON_MD */
            ]: "Показать на md+",
            [
              "d-none d-lg-$D_VALUE"
              /* VISIBLE_ON_LG */
            ]: "Показать на lg+",
            [
              "d-none d-xl-$D_VALUE"
              /* VISIBLE_ON_XL */
            ]: "Показать на xl+",
            [
              "d-none d-sm-$D_VALUE d-md-none"
              /* VISIBLE_ONLY_ON_SM */
            ]: "Показать только на sm",
            [
              "d-none d-md-$D_VALUE d-lg-none"
              /* VISIBLE_ONLY_ON_MD */
            ]: "Показать только на md",
            [
              "d-none d-lg-$D_VALUE d-xl-none"
              /* VISIBLE_ONLY_ON_LG */
            ]: "Показать только на lg",
            [
              "d-none d-xl-$D_VALUE d-xxl-none"
              /* VISIBLE_ONLY_ON_XL */
            ]: "Показать только на xl",
            [
              "d-none d-xxl-$D_VALUE"
              /* VISIBLE_ONLY_ON_XXL */
            ]: "Показать только на xxl"
          },
          default: "d-$D_VALUE"
          /* VISIBLE_ON_ALL */
        }
      },
      displayValue: {
        type: "select",
        additional: {
          conditionalLogic: {
            isResponsive: true,
            bpMode: {
              ne: "d-none"
              /* HIDDEN_ON_ALL */
            }
          }
        },
        options: {
          label: "Отображение",
          required: true,
          choices: {
            "inline": "inline",
            "inline-block": "inline-block",
            "block": "block",
            "grid": "grid",
            "table": "table",
            "table-cell": "table-cell",
            "table-row": "table-row",
            "flex": "flex",
            "inline-flex": "inline-flex"
          },
          default: "block"
        }
      }
    });
  }
  return res;
};
const parseAdditionalFields = (attrs) => {
  const {
    addCustomClasses,
    customClasses,
    addCustomStyles,
    customStyles,
    isResponsive,
    bpMode,
    displayValue
  } = attrs;
  const props = {};
  if (addCustomClasses) {
    props.class = customClasses || void 0;
  }
  if (addCustomStyles) {
    props.style = customStyles || void 0;
  }
  if (isResponsive && bpMode && displayValue) {
    const classes = bpMode.replace("$D_VALUE", displayValue);
    props.class = props.class ? `${classes} ${props.class}` : classes;
  }
  return props;
};
const gutterSelectField = (field) => ({
  ...field,
  type: "select",
  options: {
    required: false,
    clearable: true,
    default: void 0,
    ...field == null ? void 0 : field.options,
    choices: {
      "0": "0",
      "1": "1",
      "2": "2",
      "3": "3",
      "4": "4",
      "5": "5"
    }
  }
});
const colsNumbersSelectField = (field) => {
  var _a, _b;
  return {
    ...field,
    type: "select",
    options: {
      required: false,
      clearable: true,
      default: void 0,
      ...field == null ? void 0 : field.options,
      choices: {
        ...((_a = field == null ? void 0 : field.options) == null ? void 0 : _a.auto) ? { auto: "auto" } : void 0,
        ...((_b = field == null ? void 0 : field.options) == null ? void 0 : _b.boolean) ? { true: "true", false: "false" } : void 0,
        "1": "1",
        "2": "2",
        "3": "3",
        "4": "4",
        "5": "5",
        "6": "6",
        "7": "7",
        "8": "8",
        "9": "9",
        "10": "10",
        "11": "11",
        "12": "12"
      }
    }
  };
};
const alignmentContentSelectField = (field) => ({
  ...field,
  type: "select",
  options: {
    required: false,
    clearable: true,
    default: void 0,
    ...void 0 ,
    choices: {
      start: "start",
      center: "center",
      end: "end",
      around: "around",
      between: "between",
      fill: "fill",
      stretch: "stretch"
    }
  }
});
const alignmentJustifyContentSelectField = (field) => ({
  ...field,
  type: "select",
  options: {
    required: false,
    clearable: true,
    default: void 0,
    ...void 0 ,
    choices: {
      start: "start",
      center: "center",
      end: "end",
      around: "around",
      between: "between",
      evenly: "evenly"
    }
  }
});
const alignmentVerticalSelectField = (field) => {
  var _a;
  return {
    ...field,
    type: "select",
    options: {
      required: false,
      clearable: true,
      default: void 0,
      ...field == null ? void 0 : field.options,
      choices: {
        ...((_a = field == null ? void 0 : field.options) == null ? void 0 : _a.auto) ? { auto: "auto" } : void 0,
        start: "start",
        center: "center",
        end: "end",
        baseline: "baseline",
        fill: "fill",
        stretch: "stretch"
      }
    }
  };
};
const parseColsNumbersValue = (val) => {
  if (!val) {
    return void 0;
  }
  if (val === "true") {
    return true;
  }
  if (val === "false") {
    return false;
  }
  return val;
};

function defineBlock(options) {
}

export { additionalFields as a, alignmentVerticalSelectField as b, alignmentJustifyContentSelectField as c, defineBlock as d, alignmentContentSelectField as e, colsNumbersSelectField as f, gutterSelectField as g, parseColsNumbersValue as h, parseAdditionalFields as p };
//# sourceMappingURL=block.definition.mjs.map
