import { shallowRef, computed, defineComponent, h, withAsyncContext, ref, resolveDirective, mergeProps, unref, withCtx, createVNode, isRef, createBlock, openBlock, Fragment, createTextVNode, toDisplayString, renderList, createCommentVNode, useSSRContext } from 'vue';
import { u as useNuxtApp, a as useRuntimeConfig } from './server.mjs';
import { ssrRenderComponent, ssrGetDirectiveProps, ssrRenderAttr, ssrRenderList, ssrInterpolate, ssrRenderAttrs, ssrRenderClass, ssrRenderStyle, ssrRenderSlot } from 'vue/server-renderer';
import { e as isString, u as usePage, g as getLanguage, j as joinRouteParts, f as useHead } from './_...slug_.vue.mjs';
import { u as useFetch } from './fetch.mjs';
import { BNavbar, BNavbarBrand, BNavbarToggle, BNavbarNav } from 'bootstrap-vue-next/components/BNavbar';
import { BCollapse } from 'bootstrap-vue-next/components/BCollapse';
import { BNavItem, BNavItemDropdown } from 'bootstrap-vue-next/components/BNav';
import { _ as __nuxt_component_0$1 } from './HTMLContent.mjs';
import { BDropdownItem } from 'bootstrap-vue-next/components/BDropdown';
import { g as getPublicFilePath, i as isInternalLink } from './index.mjs';
import { BRow, BCol } from 'bootstrap-vue-next/components/BContainer';
import { BLink } from 'bootstrap-vue-next/components/BLink';
import '../nitro/nitro.mjs';
import 'nodemailer';
import 'zod/v4';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'crypto';
import 'fs-extra';
import 'path';
import 'node:url';
import 'fs';
import 'mime-types';
import '@antfu/utils';
import 'dot-prop';
import 'redis';
import 'consola';
import 'pg';
import 'sequelize';
import 'pg-connection-string';
import 'colorette';
import '@aws-sdk/client-s3';
import 'jsonwebtoken';
import 'nanoid';
import 'pluralize-esm';
import 'argon2';
import 'sharp';
import 'accept-language-parser';
import 'vue-router';
import 'bootstrap-vue-next/directives';
import 'bootstrap-vue-next/plugins/createBootstrap';
import 'bootstrap-vue-next/components/BImg';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'unhead/plugins';
import '@vue/shared';
import 'perfect-debounce';

function defaultEstimatedProgress(duration, elapsed) {
  const completionPercentage = elapsed / duration * 100;
  return 2 / Math.PI * 100 * Math.atan(completionPercentage / 50);
}
function createLoadingIndicator(opts = {}) {
  const { duration = 2e3, throttle = 200, hideDelay = 500, resetDelay = 400 } = opts;
  opts.estimatedProgress || defaultEstimatedProgress;
  const nuxtApp = useNuxtApp();
  const progress = shallowRef(0);
  const isLoading = shallowRef(false);
  const error = shallowRef(false);
  const start = (opts2 = {}) => {
    error.value = false;
    set(0, opts2);
  };
  function set(at = 0, opts2 = {}) {
    if (nuxtApp.isHydrating) {
      return;
    }
    if (at >= 100) {
      return finish({ force: opts2.force });
    }
    progress.value = at < 0 ? 0 : at;
    opts2.force ? 0 : throttle;
    {
      isLoading.value = true;
    }
  }
  function finish(opts2 = {}) {
    progress.value = 100;
    if (opts2.error) {
      error.value = true;
    }
    if (opts2.force) {
      progress.value = 0;
      isLoading.value = false;
    }
  }
  function clear() {
  }
  let _cleanup = () => {
  };
  return {
    _cleanup,
    progress: computed(() => progress.value),
    isLoading: computed(() => isLoading.value),
    error: computed(() => error.value),
    start,
    set,
    finish,
    clear
  };
}
function useLoadingIndicator(opts = {}) {
  const nuxtApp = useNuxtApp();
  const indicator = nuxtApp._loadingIndicator || (nuxtApp._loadingIndicator = createLoadingIndicator(opts));
  return indicator;
}

const __nuxt_component_0 = defineComponent({
  name: "NuxtLoadingIndicator",
  props: {
    throttle: {
      type: Number,
      default: 200
    },
    duration: {
      type: Number,
      default: 2e3
    },
    hideDelay: {
      type: Number,
      default: 500
    },
    resetDelay: {
      type: Number,
      default: 400
    },
    height: {
      type: Number,
      default: 3
    },
    color: {
      type: [String, Boolean],
      default: "repeating-linear-gradient(to right,#00dc82 0%,#34cdfe 50%,#0047e1 100%)"
    },
    errorColor: {
      type: String,
      default: "repeating-linear-gradient(to right,#f87171 0%,#ef4444 100%)"
    },
    estimatedProgress: {
      type: Function,
      required: false
    }
  },
  setup(props, { slots, expose }) {
    const { progress, isLoading, error, start, finish, clear } = useLoadingIndicator({
      duration: props.duration,
      throttle: props.throttle,
      hideDelay: props.hideDelay,
      resetDelay: props.resetDelay,
      estimatedProgress: props.estimatedProgress
    });
    expose({
      progress,
      isLoading,
      error,
      start,
      finish,
      clear
    });
    return () => h("div", {
      class: "nuxt-loading-indicator",
      style: {
        position: "fixed",
        top: 0,
        right: 0,
        left: 0,
        pointerEvents: "none",
        width: "auto",
        height: `${props.height}px`,
        opacity: isLoading.value ? 1 : 0,
        background: error.value ? props.errorColor : props.color || void 0,
        backgroundSize: `${100 / progress.value * 100}% auto`,
        transform: `scaleX(${progress.value}%)`,
        transformOrigin: "left",
        transition: "transform 0.1s, height 0.4s, opacity 0.4s",
        zIndex: 999999
      }
    }, slots);
  }
});

async function getCollectionData(collection, fields = "*", cache = true) {
  var _a;
  const nuxtApp = useNuxtApp();
  const runtimeConfig = useRuntimeConfig();
  const { data } = await useFetch(
    joinRouteParts(
      runtimeConfig.app.baseURL,
      // The subdirectory
      runtimeConfig.public.pruvious.api.prefix,
      "collections",
      collection
    ),
    {
      query: {
        select: fields === "*" ? void 0 : Object.keys(fields).join(","),
        language: ((_a = usePage().value) == null ? void 0 : _a.language) ?? getLanguage(),
        populate: true
      },
      key: `${collection}.read.` + (isString(fields) ? fields : Object.keys(fields).join(",")),
      transform: (input) => ({
        ...input,
        fetchedAt: /* @__PURE__ */ new Date()
      }),
      getCachedData: (key) => {
        if (!cache) {
          return;
        }
        const data2 = nuxtApp.payload.data[key] || nuxtApp.static.data[key];
        if (!data2) {
          return;
        } else if (cache === true) {
          return data2;
        }
        const expirationDate = new Date(data2.fetchedAt);
        expirationDate.setSeconds(expirationDate.getTime() + cache * 1e3);
        if (expirationDate.getTime() < Date.now()) {
          return;
        }
        return data2;
      }
    },
    "$Sq5KoNBtXf"
  );
  return data.value;
}

const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "AppNavbar",
  __ssrInlineRender: true,
  async setup(__props) {
    let __temp, __restore;
    const config = ([__temp, __restore] = withAsyncContext(() => getCollectionData("settings")), __temp = await __temp, __restore(), __temp);
    const runtimeConfig = useRuntimeConfig();
    const navbarCollapsed = ref(false);
    const navbar = computed(() => {
      let toggleable = void 0;
      switch (config.nbToggleable) {
        case "all":
          toggleable = true;
          break;
        case "none":
          toggleable = false;
          break;
        default:
          toggleable = config.nbToggleable || void 0;
          break;
      }
      let container = void 0;
      switch (config.nbContainer) {
        case "fluid":
          container = "fluid";
          break;
        case "on":
          container = true;
          break;
        case "off":
          container = false;
          break;
        default:
          container = config.nbContainer || void 0;
          break;
      }
      return {
        variant: config.nbVariant || void 0,
        toggleable,
        container
      };
    });
    const linkAttrs = (linkItem) => {
      return {
        [linkItem.type === "link" && isInternalLink(linkItem.link) ? "to" : "href"]: linkItem.type === "link" ? linkItem.link : linkItem.file ? getPublicFilePath(linkItem.file, runtimeConfig) : void 0,
        class: linkItem.class,
        style: linkItem.style,
        linkClass: linkItem.linkClass,
        linkAttrs: {
          style: linkItem.style,
          download: linkItem.type === "file" ? "" : void 0
        }
      };
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_BNavbar = BNavbar;
      const _component_BNavbarBrand = BNavbarBrand;
      const _component_BNavbarToggle = BNavbarToggle;
      const _component_BCollapse = BCollapse;
      const _component_BNavbarNav = BNavbarNav;
      const _component_BNavItem = BNavItem;
      const _component_HTMLContent = __nuxt_component_0$1;
      const _component_BNavItemDropdown = BNavItemDropdown;
      const _component_BDropdownItem = BDropdownItem;
      const _directive_b_color_mode = resolveDirective("b-color-mode");
      _push(ssrRenderComponent(_component_BNavbar, mergeProps({
        sticky: "top",
        class: "py-0"
      }, unref(navbar), _attrs, ssrGetDirectiveProps(_ctx, _directive_b_color_mode, unref(config).nbColorMode)), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_BNavbarBrand, {
              to: "/",
              style: { "height": "62px" }
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                var _a, _b;
                if (_push3) {
                  _push3(`<img${ssrRenderAttr("src", ((_a = unref(config).logo) == null ? void 0 : _a.src) || "/images/logo.svg")} class="h-100" alt="Al-Style"${_scopeId2}>`);
                } else {
                  return [
                    createVNode("img", {
                      src: ((_b = unref(config).logo) == null ? void 0 : _b.src) || "/images/logo.svg",
                      class: "h-100",
                      alt: "Al-Style"
                    }, null, 8, ["src"])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_BNavbarToggle, {
              onClick: () => {
                navbarCollapsed.value = !unref(navbarCollapsed);
              }
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_BCollapse, {
              id: "navbar-items",
              modelValue: unref(navbarCollapsed),
              "onUpdate:modelValue": ($event) => isRef(navbarCollapsed) ? navbarCollapsed.value = $event : null,
              "is-nav": "",
              class: "align-self-stretch"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_BNavbarNav, {
                    class: ["h-100 w-100 justify-content-start", {
                      "pb-3": !!unref(navbar).toggleable,
                      "pb-sm-0": unref(navbar).toggleable === "sm",
                      "pb-md-0": unref(navbar).toggleable === "md",
                      "pb-lg-0": unref(navbar).toggleable === "lg",
                      "pb-xl-0": unref(navbar).toggleable === "xl",
                      "align-items-center": !unref(navbar).toggleable,
                      "align-items-sm-center": unref(navbar).toggleable === "sm",
                      "align-items-md-center": unref(navbar).toggleable === "md",
                      "align-items-lg-center": unref(navbar).toggleable === "lg",
                      "align-items-xl-center": unref(navbar).toggleable === "xl"
                    }]
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`<!--[-->`);
                        ssrRenderList(unref(config).nbItems, (item, idx) => {
                          _push4(`<!--[-->`);
                          if (item.type === "file" || item.type === "link") {
                            _push4(ssrRenderComponent(_component_BNavItem, mergeProps({ ref_for: true }, linkAttrs(item)), {
                              default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                                var _a, _b;
                                if (_push5) {
                                  if (item.allowHtml) {
                                    _push5(ssrRenderComponent(_component_HTMLContent, {
                                      tag: item.labelTag,
                                      html: item.labelContent,
                                      attributes: (_a = item.labelAttributes) == null ? void 0 : _a.reduce(
                                        (obj, x) => {
                                          obj[x.name] = x.value;
                                          return obj;
                                        },
                                        {}
                                      )
                                    }, null, _parent5, _scopeId4));
                                  } else {
                                    _push5(`<!--[-->${ssrInterpolate(item.labelContent)}<!--]-->`);
                                  }
                                } else {
                                  return [
                                    item.allowHtml ? (openBlock(), createBlock(_component_HTMLContent, {
                                      key: 0,
                                      tag: item.labelTag,
                                      html: item.labelContent,
                                      attributes: (_b = item.labelAttributes) == null ? void 0 : _b.reduce(
                                        (obj, x) => {
                                          obj[x.name] = x.value;
                                          return obj;
                                        },
                                        {}
                                      )
                                    }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                                      createTextVNode(toDisplayString(item.labelContent), 1)
                                    ], 64))
                                  ];
                                }
                              }),
                              _: 2
                            }, _parent4, _scopeId3));
                          } else if (item.type === "menu") {
                            _push4(ssrRenderComponent(_component_BNavItemDropdown, {
                              "is-nav": "",
                              strategy: "fixed",
                              class: item.class,
                              style: item.style,
                              "link-class": item.linkClass,
                              "link-attrs": { style: item.style }
                            }, {
                              "button-content": withCtx((_4, _push5, _parent5, _scopeId4) => {
                                var _a, _b;
                                if (_push5) {
                                  if (item.allowHtml) {
                                    _push5(ssrRenderComponent(_component_HTMLContent, {
                                      tag: item.labelTag,
                                      html: item.labelContent,
                                      attributes: (_a = item.labelAttributes) == null ? void 0 : _a.reduce(
                                        (obj, x) => {
                                          obj[x.name] = x.value;
                                          return obj;
                                        },
                                        {}
                                      )
                                    }, null, _parent5, _scopeId4));
                                  } else {
                                    _push5(`<!--[-->${ssrInterpolate(item.labelContent)}<!--]-->`);
                                  }
                                } else {
                                  return [
                                    item.allowHtml ? (openBlock(), createBlock(_component_HTMLContent, {
                                      key: 0,
                                      tag: item.labelTag,
                                      html: item.labelContent,
                                      attributes: (_b = item.labelAttributes) == null ? void 0 : _b.reduce(
                                        (obj, x) => {
                                          obj[x.name] = x.value;
                                          return obj;
                                        },
                                        {}
                                      )
                                    }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                                      createTextVNode(toDisplayString(item.labelContent), 1)
                                    ], 64))
                                  ];
                                }
                              }),
                              default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                                if (_push5) {
                                  _push5(`<!--[-->`);
                                  ssrRenderList(item.menuItems, (subItem, _idx) => {
                                    _push5(ssrRenderComponent(_component_BDropdownItem, mergeProps(
                                      { key: _idx },
                                      { ref_for: true },
                                      linkAttrs(subItem)
                                    ), {
                                      default: withCtx((_5, _push6, _parent6, _scopeId5) => {
                                        var _a, _b;
                                        if (_push6) {
                                          if (subItem.allowHtml) {
                                            _push6(ssrRenderComponent(_component_HTMLContent, {
                                              tag: subItem.labelTag,
                                              html: subItem.labelContent,
                                              attributes: (_a = subItem.labelAttributes) == null ? void 0 : _a.reduce(
                                                (obj, x) => {
                                                  obj[x.name] = x.value;
                                                  return obj;
                                                },
                                                {}
                                              )
                                            }, null, _parent6, _scopeId5));
                                          } else {
                                            _push6(`<!--[-->${ssrInterpolate(subItem.labelContent)}<!--]-->`);
                                          }
                                        } else {
                                          return [
                                            subItem.allowHtml ? (openBlock(), createBlock(_component_HTMLContent, {
                                              key: 0,
                                              tag: subItem.labelTag,
                                              html: subItem.labelContent,
                                              attributes: (_b = subItem.labelAttributes) == null ? void 0 : _b.reduce(
                                                (obj, x) => {
                                                  obj[x.name] = x.value;
                                                  return obj;
                                                },
                                                {}
                                              )
                                            }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                                              createTextVNode(toDisplayString(subItem.labelContent), 1)
                                            ], 64))
                                          ];
                                        }
                                      }),
                                      _: 2
                                    }, _parent5, _scopeId4));
                                  });
                                  _push5(`<!--]-->`);
                                } else {
                                  return [
                                    (openBlock(true), createBlock(Fragment, null, renderList(item.menuItems, (subItem, _idx) => {
                                      return openBlock(), createBlock(_component_BDropdownItem, mergeProps(
                                        { key: _idx },
                                        { ref_for: true },
                                        linkAttrs(subItem)
                                      ), {
                                        default: withCtx(() => {
                                          var _a;
                                          return [
                                            subItem.allowHtml ? (openBlock(), createBlock(_component_HTMLContent, {
                                              key: 0,
                                              tag: subItem.labelTag,
                                              html: subItem.labelContent,
                                              attributes: (_a = subItem.labelAttributes) == null ? void 0 : _a.reduce(
                                                (obj, x) => {
                                                  obj[x.name] = x.value;
                                                  return obj;
                                                },
                                                {}
                                              )
                                            }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                                              createTextVNode(toDisplayString(subItem.labelContent), 1)
                                            ], 64))
                                          ];
                                        }),
                                        _: 2
                                      }, 1040);
                                    }), 128))
                                  ];
                                }
                              }),
                              _: 2
                            }, _parent4, _scopeId3));
                          } else if (item.type === "spacer") {
                            _push4(`<div class="flex-grow-1"${_scopeId3}></div>`);
                          } else {
                            _push4(`<!---->`);
                          }
                          _push4(`<!--]-->`);
                        });
                        _push4(`<!--]-->`);
                      } else {
                        return [
                          (openBlock(true), createBlock(Fragment, null, renderList(unref(config).nbItems, (item, idx) => {
                            return openBlock(), createBlock(Fragment, { key: idx }, [
                              item.type === "file" || item.type === "link" ? (openBlock(), createBlock(_component_BNavItem, mergeProps({
                                key: 0,
                                ref_for: true
                              }, linkAttrs(item)), {
                                default: withCtx(() => {
                                  var _a;
                                  return [
                                    item.allowHtml ? (openBlock(), createBlock(_component_HTMLContent, {
                                      key: 0,
                                      tag: item.labelTag,
                                      html: item.labelContent,
                                      attributes: (_a = item.labelAttributes) == null ? void 0 : _a.reduce(
                                        (obj, x) => {
                                          obj[x.name] = x.value;
                                          return obj;
                                        },
                                        {}
                                      )
                                    }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                                      createTextVNode(toDisplayString(item.labelContent), 1)
                                    ], 64))
                                  ];
                                }),
                                _: 2
                              }, 1040)) : item.type === "menu" ? (openBlock(), createBlock(_component_BNavItemDropdown, {
                                key: 1,
                                "is-nav": "",
                                strategy: "fixed",
                                class: item.class,
                                style: item.style,
                                "link-class": item.linkClass,
                                "link-attrs": { style: item.style }
                              }, {
                                "button-content": withCtx(() => {
                                  var _a;
                                  return [
                                    item.allowHtml ? (openBlock(), createBlock(_component_HTMLContent, {
                                      key: 0,
                                      tag: item.labelTag,
                                      html: item.labelContent,
                                      attributes: (_a = item.labelAttributes) == null ? void 0 : _a.reduce(
                                        (obj, x) => {
                                          obj[x.name] = x.value;
                                          return obj;
                                        },
                                        {}
                                      )
                                    }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                                      createTextVNode(toDisplayString(item.labelContent), 1)
                                    ], 64))
                                  ];
                                }),
                                default: withCtx(() => [
                                  (openBlock(true), createBlock(Fragment, null, renderList(item.menuItems, (subItem, _idx) => {
                                    return openBlock(), createBlock(_component_BDropdownItem, mergeProps(
                                      { key: _idx },
                                      { ref_for: true },
                                      linkAttrs(subItem)
                                    ), {
                                      default: withCtx(() => {
                                        var _a;
                                        return [
                                          subItem.allowHtml ? (openBlock(), createBlock(_component_HTMLContent, {
                                            key: 0,
                                            tag: subItem.labelTag,
                                            html: subItem.labelContent,
                                            attributes: (_a = subItem.labelAttributes) == null ? void 0 : _a.reduce(
                                              (obj, x) => {
                                                obj[x.name] = x.value;
                                                return obj;
                                              },
                                              {}
                                            )
                                          }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                                            createTextVNode(toDisplayString(subItem.labelContent), 1)
                                          ], 64))
                                        ];
                                      }),
                                      _: 2
                                    }, 1040);
                                  }), 128))
                                ]),
                                _: 2
                              }, 1032, ["class", "style", "link-class", "link-attrs"])) : item.type === "spacer" ? (openBlock(), createBlock("div", {
                                key: 2,
                                class: "flex-grow-1"
                              })) : createCommentVNode("", true)
                            ], 64);
                          }), 128))
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode(_component_BNavbarNav, {
                      class: ["h-100 w-100 justify-content-start", {
                        "pb-3": !!unref(navbar).toggleable,
                        "pb-sm-0": unref(navbar).toggleable === "sm",
                        "pb-md-0": unref(navbar).toggleable === "md",
                        "pb-lg-0": unref(navbar).toggleable === "lg",
                        "pb-xl-0": unref(navbar).toggleable === "xl",
                        "align-items-center": !unref(navbar).toggleable,
                        "align-items-sm-center": unref(navbar).toggleable === "sm",
                        "align-items-md-center": unref(navbar).toggleable === "md",
                        "align-items-lg-center": unref(navbar).toggleable === "lg",
                        "align-items-xl-center": unref(navbar).toggleable === "xl"
                      }]
                    }, {
                      default: withCtx(() => [
                        (openBlock(true), createBlock(Fragment, null, renderList(unref(config).nbItems, (item, idx) => {
                          return openBlock(), createBlock(Fragment, { key: idx }, [
                            item.type === "file" || item.type === "link" ? (openBlock(), createBlock(_component_BNavItem, mergeProps({
                              key: 0,
                              ref_for: true
                            }, linkAttrs(item)), {
                              default: withCtx(() => {
                                var _a;
                                return [
                                  item.allowHtml ? (openBlock(), createBlock(_component_HTMLContent, {
                                    key: 0,
                                    tag: item.labelTag,
                                    html: item.labelContent,
                                    attributes: (_a = item.labelAttributes) == null ? void 0 : _a.reduce(
                                      (obj, x) => {
                                        obj[x.name] = x.value;
                                        return obj;
                                      },
                                      {}
                                    )
                                  }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                                    createTextVNode(toDisplayString(item.labelContent), 1)
                                  ], 64))
                                ];
                              }),
                              _: 2
                            }, 1040)) : item.type === "menu" ? (openBlock(), createBlock(_component_BNavItemDropdown, {
                              key: 1,
                              "is-nav": "",
                              strategy: "fixed",
                              class: item.class,
                              style: item.style,
                              "link-class": item.linkClass,
                              "link-attrs": { style: item.style }
                            }, {
                              "button-content": withCtx(() => {
                                var _a;
                                return [
                                  item.allowHtml ? (openBlock(), createBlock(_component_HTMLContent, {
                                    key: 0,
                                    tag: item.labelTag,
                                    html: item.labelContent,
                                    attributes: (_a = item.labelAttributes) == null ? void 0 : _a.reduce(
                                      (obj, x) => {
                                        obj[x.name] = x.value;
                                        return obj;
                                      },
                                      {}
                                    )
                                  }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                                    createTextVNode(toDisplayString(item.labelContent), 1)
                                  ], 64))
                                ];
                              }),
                              default: withCtx(() => [
                                (openBlock(true), createBlock(Fragment, null, renderList(item.menuItems, (subItem, _idx) => {
                                  return openBlock(), createBlock(_component_BDropdownItem, mergeProps(
                                    { key: _idx },
                                    { ref_for: true },
                                    linkAttrs(subItem)
                                  ), {
                                    default: withCtx(() => {
                                      var _a;
                                      return [
                                        subItem.allowHtml ? (openBlock(), createBlock(_component_HTMLContent, {
                                          key: 0,
                                          tag: subItem.labelTag,
                                          html: subItem.labelContent,
                                          attributes: (_a = subItem.labelAttributes) == null ? void 0 : _a.reduce(
                                            (obj, x) => {
                                              obj[x.name] = x.value;
                                              return obj;
                                            },
                                            {}
                                          )
                                        }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                                          createTextVNode(toDisplayString(subItem.labelContent), 1)
                                        ], 64))
                                      ];
                                    }),
                                    _: 2
                                  }, 1040);
                                }), 128))
                              ]),
                              _: 2
                            }, 1032, ["class", "style", "link-class", "link-attrs"])) : item.type === "spacer" ? (openBlock(), createBlock("div", {
                              key: 2,
                              class: "flex-grow-1"
                            })) : createCommentVNode("", true)
                          ], 64);
                        }), 128))
                      ]),
                      _: 1
                    }, 8, ["class"])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_BNavbarBrand, {
                to: "/",
                style: { "height": "62px" }
              }, {
                default: withCtx(() => {
                  var _a;
                  return [
                    createVNode("img", {
                      src: ((_a = unref(config).logo) == null ? void 0 : _a.src) || "/images/logo.svg",
                      class: "h-100",
                      alt: "Al-Style"
                    }, null, 8, ["src"])
                  ];
                }),
                _: 1
              }),
              createVNode(_component_BNavbarToggle, {
                onClick: () => {
                  navbarCollapsed.value = !unref(navbarCollapsed);
                }
              }, null, 8, ["onClick"]),
              createVNode(_component_BCollapse, {
                id: "navbar-items",
                modelValue: unref(navbarCollapsed),
                "onUpdate:modelValue": ($event) => isRef(navbarCollapsed) ? navbarCollapsed.value = $event : null,
                "is-nav": "",
                class: "align-self-stretch"
              }, {
                default: withCtx(() => [
                  createVNode(_component_BNavbarNav, {
                    class: ["h-100 w-100 justify-content-start", {
                      "pb-3": !!unref(navbar).toggleable,
                      "pb-sm-0": unref(navbar).toggleable === "sm",
                      "pb-md-0": unref(navbar).toggleable === "md",
                      "pb-lg-0": unref(navbar).toggleable === "lg",
                      "pb-xl-0": unref(navbar).toggleable === "xl",
                      "align-items-center": !unref(navbar).toggleable,
                      "align-items-sm-center": unref(navbar).toggleable === "sm",
                      "align-items-md-center": unref(navbar).toggleable === "md",
                      "align-items-lg-center": unref(navbar).toggleable === "lg",
                      "align-items-xl-center": unref(navbar).toggleable === "xl"
                    }]
                  }, {
                    default: withCtx(() => [
                      (openBlock(true), createBlock(Fragment, null, renderList(unref(config).nbItems, (item, idx) => {
                        return openBlock(), createBlock(Fragment, { key: idx }, [
                          item.type === "file" || item.type === "link" ? (openBlock(), createBlock(_component_BNavItem, mergeProps({
                            key: 0,
                            ref_for: true
                          }, linkAttrs(item)), {
                            default: withCtx(() => {
                              var _a;
                              return [
                                item.allowHtml ? (openBlock(), createBlock(_component_HTMLContent, {
                                  key: 0,
                                  tag: item.labelTag,
                                  html: item.labelContent,
                                  attributes: (_a = item.labelAttributes) == null ? void 0 : _a.reduce(
                                    (obj, x) => {
                                      obj[x.name] = x.value;
                                      return obj;
                                    },
                                    {}
                                  )
                                }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                                  createTextVNode(toDisplayString(item.labelContent), 1)
                                ], 64))
                              ];
                            }),
                            _: 2
                          }, 1040)) : item.type === "menu" ? (openBlock(), createBlock(_component_BNavItemDropdown, {
                            key: 1,
                            "is-nav": "",
                            strategy: "fixed",
                            class: item.class,
                            style: item.style,
                            "link-class": item.linkClass,
                            "link-attrs": { style: item.style }
                          }, {
                            "button-content": withCtx(() => {
                              var _a;
                              return [
                                item.allowHtml ? (openBlock(), createBlock(_component_HTMLContent, {
                                  key: 0,
                                  tag: item.labelTag,
                                  html: item.labelContent,
                                  attributes: (_a = item.labelAttributes) == null ? void 0 : _a.reduce(
                                    (obj, x) => {
                                      obj[x.name] = x.value;
                                      return obj;
                                    },
                                    {}
                                  )
                                }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                                  createTextVNode(toDisplayString(item.labelContent), 1)
                                ], 64))
                              ];
                            }),
                            default: withCtx(() => [
                              (openBlock(true), createBlock(Fragment, null, renderList(item.menuItems, (subItem, _idx) => {
                                return openBlock(), createBlock(_component_BDropdownItem, mergeProps(
                                  { key: _idx },
                                  { ref_for: true },
                                  linkAttrs(subItem)
                                ), {
                                  default: withCtx(() => {
                                    var _a;
                                    return [
                                      subItem.allowHtml ? (openBlock(), createBlock(_component_HTMLContent, {
                                        key: 0,
                                        tag: subItem.labelTag,
                                        html: subItem.labelContent,
                                        attributes: (_a = subItem.labelAttributes) == null ? void 0 : _a.reduce(
                                          (obj, x) => {
                                            obj[x.name] = x.value;
                                            return obj;
                                          },
                                          {}
                                        )
                                      }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                                        createTextVNode(toDisplayString(subItem.labelContent), 1)
                                      ], 64))
                                    ];
                                  }),
                                  _: 2
                                }, 1040);
                              }), 128))
                            ]),
                            _: 2
                          }, 1032, ["class", "style", "link-class", "link-attrs"])) : item.type === "spacer" ? (openBlock(), createBlock("div", {
                            key: 2,
                            class: "flex-grow-1"
                          })) : createCommentVNode("", true)
                        ], 64);
                      }), 128))
                    ]),
                    _: 1
                  }, 8, ["class"])
                ]),
                _: 1
              }, 8, ["modelValue", "onUpdate:modelValue"])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
});

const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "AppFooter",
  __ssrInlineRender: true,
  async setup(__props) {
    let __temp, __restore;
    const runtimeConfig = useRuntimeConfig();
    const config = ([__temp, __restore] = withAsyncContext(() => getCollectionData("settings")), __temp = await __temp, __restore(), __temp);
    const container = computed(() => (config == null ? void 0 : config.ftrContainer) || "on");
    const footer = computed(() => (config == null ? void 0 : config.ftrCols) || []);
    const linkAttrs = (linkItem) => {
      return {
        ...!linkItem.isHTMLLabel && Array.isArray(linkItem.attributes) ? Object.fromEntries(
          linkItem.attributes.map((attr) => [attr.name, attr.value])
        ) : void 0,
        [linkItem.type === "link" && isInternalLink(linkItem.link) ? "to" : "href"]: linkItem.type === "link" ? linkItem.link : linkItem.file ? getPublicFilePath(linkItem.file, runtimeConfig) : void 0,
        download: linkItem.type === "file" ? "" : void 0
      };
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_BRow = BRow;
      const _component_BCol = BCol;
      const _component_BLink = BLink;
      const _component_HTMLContent = __nuxt_component_0$1;
      _push(`<footer${ssrRenderAttrs(mergeProps({
        class: unref(config).ftrClass,
        style: unref(config).ftrStyle
      }, _attrs))}><div class="${ssrRenderClass({
        "container": unref(container) === "on",
        "px-3": unref(container) === "off",
        "container-fluid": unref(container) === "fluid",
        "container-xxl": unref(container) === "xxl",
        "container-xl": unref(container) === "xl",
        "container-lg": unref(container) === "lg",
        "container-md": unref(container) === "md",
        "container-sm": unref(container) === "sm"
      })}">`);
      _push(ssrRenderComponent(_component_BRow, { "gutter-y": "4" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<!--[-->`);
            ssrRenderList(unref(footer), (col, idx) => {
              _push2(ssrRenderComponent(_component_BCol, {
                key: idx,
                cols: col.colsXs || void 0,
                sm: col.colsSm || void 0,
                md: col.colsMd || void 0,
                lg: col.colsLg || void 0,
                xl: col.colsXl || void 0,
                xxl: col.colsXxl || void 0,
                class: col.colClass,
                style: col.colStyle
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    if (col.withTitle) {
                      _push3(`<div class="${ssrRenderClass(col.titleClass)}" style="${ssrRenderStyle(col.titleStyle)}"${_scopeId2}>${ssrInterpolate(col.title)}</div>`);
                    } else {
                      _push3(`<!---->`);
                    }
                    _push3(`<!--[-->`);
                    ssrRenderList(col.items, (item, itemIdx) => {
                      _push3(`<!--[-->`);
                      if (item.type === "link" || item.type === "file") {
                        _push3(ssrRenderComponent(_component_BLink, mergeProps(
                          { ref_for: true },
                          linkAttrs(item)
                        ), {
                          default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                            if (_push4) {
                              if (item.isHTMLLabel) {
                                _push4(ssrRenderComponent(_component_HTMLContent, {
                                  tag: item.htmlTag,
                                  html: item.content,
                                  attributes: Array.isArray(item.attributes) ? Object.fromEntries(
                                    item.attributes.map((attr) => [attr.name, attr.value])
                                  ) : void 0
                                }, null, _parent4, _scopeId3));
                              } else {
                                _push4(`<!--[-->${ssrInterpolate(item.content)}<!--]-->`);
                              }
                            } else {
                              return [
                                item.isHTMLLabel ? (openBlock(), createBlock(_component_HTMLContent, {
                                  key: 0,
                                  tag: item.htmlTag,
                                  html: item.content,
                                  attributes: Array.isArray(item.attributes) ? Object.fromEntries(
                                    item.attributes.map((attr) => [attr.name, attr.value])
                                  ) : void 0
                                }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                                  createTextVNode(toDisplayString(item.content), 1)
                                ], 64))
                              ];
                            }
                          }),
                          _: 2
                        }, _parent3, _scopeId2));
                      } else if (item.type === "html") {
                        _push3(ssrRenderComponent(_component_HTMLContent, {
                          tag: item.htmlTag,
                          html: item.content,
                          attributes: Array.isArray(item.attributes) ? Object.fromEntries(
                            item.attributes.map((attr) => [attr.name, attr.value])
                          ) : void 0
                        }, null, _parent3, _scopeId2));
                      } else {
                        _push3(`<div${ssrRenderAttrs(mergeProps(
                          { ref_for: true },
                          Array.isArray(item.attributes) ? Object.fromEntries(
                            item.attributes.map((attr) => [attr.name, attr.value])
                          ) : void 0
                        ))}${_scopeId2}>${ssrInterpolate(item.content)}</div>`);
                      }
                      _push3(`<!--]-->`);
                    });
                    _push3(`<!--]-->`);
                  } else {
                    return [
                      col.withTitle ? (openBlock(), createBlock("div", {
                        key: 0,
                        class: col.titleClass,
                        style: col.titleStyle
                      }, toDisplayString(col.title), 7)) : createCommentVNode("", true),
                      (openBlock(true), createBlock(Fragment, null, renderList(col.items, (item, itemIdx) => {
                        return openBlock(), createBlock(Fragment, { key: itemIdx }, [
                          item.type === "link" || item.type === "file" ? (openBlock(), createBlock(_component_BLink, mergeProps(
                            {
                              key: 0,
                              ref_for: true
                            },
                            linkAttrs(item)
                          ), {
                            default: withCtx(() => [
                              item.isHTMLLabel ? (openBlock(), createBlock(_component_HTMLContent, {
                                key: 0,
                                tag: item.htmlTag,
                                html: item.content,
                                attributes: Array.isArray(item.attributes) ? Object.fromEntries(
                                  item.attributes.map((attr) => [attr.name, attr.value])
                                ) : void 0
                              }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                                createTextVNode(toDisplayString(item.content), 1)
                              ], 64))
                            ]),
                            _: 2
                          }, 1040)) : item.type === "html" ? (openBlock(), createBlock(_component_HTMLContent, {
                            key: 1,
                            tag: item.htmlTag,
                            html: item.content,
                            attributes: Array.isArray(item.attributes) ? Object.fromEntries(
                              item.attributes.map((attr) => [attr.name, attr.value])
                            ) : void 0
                          }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock("div", mergeProps(
                            {
                              key: 2,
                              ref_for: true
                            },
                            Array.isArray(item.attributes) ? Object.fromEntries(
                              item.attributes.map((attr) => [attr.name, attr.value])
                            ) : void 0
                          ), toDisplayString(item.content), 17))
                        ], 64);
                      }), 128))
                    ];
                  }
                }),
                _: 2
              }, _parent2, _scopeId));
            });
            _push2(`<!--]-->`);
          } else {
            return [
              (openBlock(true), createBlock(Fragment, null, renderList(unref(footer), (col, idx) => {
                return openBlock(), createBlock(_component_BCol, {
                  key: idx,
                  cols: col.colsXs || void 0,
                  sm: col.colsSm || void 0,
                  md: col.colsMd || void 0,
                  lg: col.colsLg || void 0,
                  xl: col.colsXl || void 0,
                  xxl: col.colsXxl || void 0,
                  class: col.colClass,
                  style: col.colStyle
                }, {
                  default: withCtx(() => [
                    col.withTitle ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: col.titleClass,
                      style: col.titleStyle
                    }, toDisplayString(col.title), 7)) : createCommentVNode("", true),
                    (openBlock(true), createBlock(Fragment, null, renderList(col.items, (item, itemIdx) => {
                      return openBlock(), createBlock(Fragment, { key: itemIdx }, [
                        item.type === "link" || item.type === "file" ? (openBlock(), createBlock(_component_BLink, mergeProps(
                          {
                            key: 0,
                            ref_for: true
                          },
                          linkAttrs(item)
                        ), {
                          default: withCtx(() => [
                            item.isHTMLLabel ? (openBlock(), createBlock(_component_HTMLContent, {
                              key: 0,
                              tag: item.htmlTag,
                              html: item.content,
                              attributes: Array.isArray(item.attributes) ? Object.fromEntries(
                                item.attributes.map((attr) => [attr.name, attr.value])
                              ) : void 0
                            }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                              createTextVNode(toDisplayString(item.content), 1)
                            ], 64))
                          ]),
                          _: 2
                        }, 1040)) : item.type === "html" ? (openBlock(), createBlock(_component_HTMLContent, {
                          key: 1,
                          tag: item.htmlTag,
                          html: item.content,
                          attributes: Array.isArray(item.attributes) ? Object.fromEntries(
                            item.attributes.map((attr) => [attr.name, attr.value])
                          ) : void 0
                        }, null, 8, ["tag", "html", "attributes"])) : (openBlock(), createBlock("div", mergeProps(
                          {
                            key: 2,
                            ref_for: true
                          },
                          Array.isArray(item.attributes) ? Object.fromEntries(
                            item.attributes.map((attr) => [attr.name, attr.value])
                          ) : void 0
                        ), toDisplayString(item.content), 17))
                      ], 64);
                    }), 128))
                  ]),
                  _: 2
                }, 1032, ["cols", "sm", "md", "lg", "xl", "xxl", "class", "style"]);
              }), 128))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></footer>`);
    };
  }
});

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "default",
  __ssrInlineRender: true,
  async setup(__props) {
    var _a;
    let __temp, __restore;
    const config = ([__temp, __restore] = withAsyncContext(() => getCollectionData("settings")), __temp = await __temp, __restore(), __temp);
    if ((_a = config.customStylesheets) == null ? void 0 : _a.length) {
      useHead(
        config.customStylesheets.reduce(
          (data, item) => {
            if (item.type === "external") {
              (data.link ?? (data.link = [])).push({
                ...Object.fromEntries(
                  item.externalAttrs.map((x) => [x.name, x.value])
                ),
                rel: item.externalRel,
                href: item.externalLink
              });
            } else if (item.type === "internal") {
              (data.style ?? (data.style = [])).push(item.internalCss);
            }
            return data;
          },
          {}
        )
      );
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_NuxtLoadingIndicator = __nuxt_component_0;
      const _component_AppNavbar = _sfc_main$2;
      const _component_AppFooter = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "min-vh-100 d-flex flex-column" }, _attrs))}>`);
      _push(ssrRenderComponent(_component_NuxtLoadingIndicator, null, null, _parent));
      _push(ssrRenderComponent(_component_AppNavbar, null, null, _parent));
      _push(`<main class="flex-grow-1 d-flex flex-column">`);
      ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
      _push(`</main>`);
      _push(ssrRenderComponent(_component_AppFooter, null, null, _parent));
      _push(`</div>`);
    };
  }
});

const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layouts/default.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=default.vue.mjs.map
