import process from 'node:process';globalThis._importMeta_=globalThis._importMeta_||{url:"file:///_entry.js",env:process.env};import { createTransport } from 'nodemailer';
import { z } from 'zod/v4';
import http, { Server as Server$1 } from 'node:http';
import https, { Server } from 'node:https';
import { EventEmitter } from 'node:events';
import { Buffer as Buffer$1 } from 'node:buffer';
import { promises, existsSync } from 'node:fs';
import { resolve as resolve$1, dirname as dirname$1, join } from 'node:path';
import { createHash } from 'node:crypto';
import require$$1 from 'crypto';
import fs from 'fs-extra';
import path$1, { resolve as resolve$2, join as join$1 } from 'path';
import { fileURLToPath } from 'node:url';
import { existsSync as existsSync$1, statSync, createReadStream } from 'fs';
import mime from 'mime-types';
import { isFunction as isFunction$1, isNumber as isNumber$1, isDef, isNull as isNull$1, isUndefined as isUndefined$1, isBoolean as isBoolean$1, isString as isString$1, uniq, toArray as toArray$1, objectPick as objectPick$1, isObject as isObject$1, deepMerge as deepMerge$1, isKeyOf as isKeyOf$1, clamp } from '@antfu/utils';
import { setProperty as setProperty$1, getProperty as getProperty$1, deleteProperty as deleteProperty$1 } from 'dot-prop';
import { createClient } from 'redis';
import { consola } from 'consola';
import pg from 'pg';
import { Op, Sequelize, DataTypes } from 'sequelize';
import pgConnectionString from 'pg-connection-string';
import { cyan, green, red, underline, yellow } from 'colorette';
import { PutObjectCommand, CopyObjectCommand, DeleteObjectCommand, S3Client, GetObjectCommand } from '@aws-sdk/client-s3';
import jwt from 'jsonwebtoken';
import { nanoid } from 'nanoid';
import pluralize from 'pluralize-esm';
import argon2 from 'argon2';
import sharp from 'sharp';
import parser from 'accept-language-parser';

const suspectProtoRx = /"(?:_|\\u0{2}5[Ff]){2}(?:p|\\u0{2}70)(?:r|\\u0{2}72)(?:o|\\u0{2}6[Ff])(?:t|\\u0{2}74)(?:o|\\u0{2}6[Ff])(?:_|\\u0{2}5[Ff]){2}"\s*:/;
const suspectConstructorRx = /"(?:c|\\u0063)(?:o|\\u006[Ff])(?:n|\\u006[Ee])(?:s|\\u0073)(?:t|\\u0074)(?:r|\\u0072)(?:u|\\u0075)(?:c|\\u0063)(?:t|\\u0074)(?:o|\\u006[Ff])(?:r|\\u0072)"\s*:/;
const JsonSigRx = /^\s*["[{]|^\s*-?\d{1,16}(\.\d{1,17})?([Ee][+-]?\d+)?\s*$/;
function jsonParseTransform(key, value) {
  if (key === "__proto__" || key === "constructor" && value && typeof value === "object" && "prototype" in value) {
    warnKeyDropped(key);
    return;
  }
  return value;
}
function warnKeyDropped(key) {
  console.warn(`[destr] Dropping "${key}" key to prevent prototype pollution.`);
}
function destr(value, options = {}) {
  if (typeof value !== "string") {
    return value;
  }
  if (value[0] === '"' && value[value.length - 1] === '"' && value.indexOf("\\") === -1) {
    return value.slice(1, -1);
  }
  const _value = value.trim();
  if (_value.length <= 9) {
    switch (_value.toLowerCase()) {
      case "true": {
        return true;
      }
      case "false": {
        return false;
      }
      case "undefined": {
        return void 0;
      }
      case "null": {
        return null;
      }
      case "nan": {
        return Number.NaN;
      }
      case "infinity": {
        return Number.POSITIVE_INFINITY;
      }
      case "-infinity": {
        return Number.NEGATIVE_INFINITY;
      }
    }
  }
  if (!JsonSigRx.test(value)) {
    if (options.strict) {
      throw new SyntaxError("[destr] Invalid JSON");
    }
    return value;
  }
  try {
    if (suspectProtoRx.test(value) || suspectConstructorRx.test(value)) {
      if (options.strict) {
        throw new Error("[destr] Possible prototype pollution");
      }
      return JSON.parse(value, jsonParseTransform);
    }
    return JSON.parse(value);
  } catch (error) {
    if (options.strict) {
      throw error;
    }
    return value;
  }
}

const HASH_RE = /#/g;
const AMPERSAND_RE = /&/g;
const SLASH_RE = /\//g;
const EQUAL_RE = /=/g;
const PLUS_RE = /\+/g;
const ENC_CARET_RE = /%5e/gi;
const ENC_BACKTICK_RE = /%60/gi;
const ENC_PIPE_RE = /%7c/gi;
const ENC_SPACE_RE = /%20/gi;
const ENC_SLASH_RE = /%2f/gi;
function encode(text) {
  return encodeURI("" + text).replace(ENC_PIPE_RE, "|");
}
function encodeQueryValue(input) {
  return encode(typeof input === "string" ? input : JSON.stringify(input)).replace(PLUS_RE, "%2B").replace(ENC_SPACE_RE, "+").replace(HASH_RE, "%23").replace(AMPERSAND_RE, "%26").replace(ENC_BACKTICK_RE, "`").replace(ENC_CARET_RE, "^").replace(SLASH_RE, "%2F");
}
function encodeQueryKey(text) {
  return encodeQueryValue(text).replace(EQUAL_RE, "%3D");
}
function decode(text = "") {
  try {
    return decodeURIComponent("" + text);
  } catch {
    return "" + text;
  }
}
function decodePath(text) {
  return decode(text.replace(ENC_SLASH_RE, "%252F"));
}
function decodeQueryKey(text) {
  return decode(text.replace(PLUS_RE, " "));
}
function decodeQueryValue(text) {
  return decode(text.replace(PLUS_RE, " "));
}

function parseQuery(parametersString = "") {
  const object = /* @__PURE__ */ Object.create(null);
  if (parametersString[0] === "?") {
    parametersString = parametersString.slice(1);
  }
  for (const parameter of parametersString.split("&")) {
    const s = parameter.match(/([^=]+)=?(.*)/) || [];
    if (s.length < 2) {
      continue;
    }
    const key = decodeQueryKey(s[1]);
    if (key === "__proto__" || key === "constructor") {
      continue;
    }
    const value = decodeQueryValue(s[2] || "");
    if (object[key] === void 0) {
      object[key] = value;
    } else if (Array.isArray(object[key])) {
      object[key].push(value);
    } else {
      object[key] = [object[key], value];
    }
  }
  return object;
}
function encodeQueryItem(key, value) {
  if (typeof value === "number" || typeof value === "boolean") {
    value = String(value);
  }
  if (!value) {
    return encodeQueryKey(key);
  }
  if (Array.isArray(value)) {
    return value.map(
      (_value) => `${encodeQueryKey(key)}=${encodeQueryValue(_value)}`
    ).join("&");
  }
  return `${encodeQueryKey(key)}=${encodeQueryValue(value)}`;
}
function stringifyQuery(query) {
  return Object.keys(query).filter((k) => query[k] !== void 0).map((k) => encodeQueryItem(k, query[k])).filter(Boolean).join("&");
}

const PROTOCOL_STRICT_REGEX = /^[\s\w\0+.-]{2,}:([/\\]{1,2})/;
const PROTOCOL_REGEX = /^[\s\w\0+.-]{2,}:([/\\]{2})?/;
const PROTOCOL_RELATIVE_REGEX = /^([/\\]\s*){2,}[^/\\]/;
const PROTOCOL_SCRIPT_RE = /^[\s\0]*(blob|data|javascript|vbscript):$/i;
const TRAILING_SLASH_RE = /\/$|\/\?|\/#/;
const JOIN_LEADING_SLASH_RE = /^\.?\//;
function hasProtocol(inputString, opts = {}) {
  if (typeof opts === "boolean") {
    opts = { acceptRelative: opts };
  }
  if (opts.strict) {
    return PROTOCOL_STRICT_REGEX.test(inputString);
  }
  return PROTOCOL_REGEX.test(inputString) || (opts.acceptRelative ? PROTOCOL_RELATIVE_REGEX.test(inputString) : false);
}
function isScriptProtocol(protocol) {
  return !!protocol && PROTOCOL_SCRIPT_RE.test(protocol);
}
function hasTrailingSlash(input = "", respectQueryAndFragment) {
  if (!respectQueryAndFragment) {
    return input.endsWith("/");
  }
  return TRAILING_SLASH_RE.test(input);
}
function withoutTrailingSlash(input = "", respectQueryAndFragment) {
  if (!respectQueryAndFragment) {
    return (hasTrailingSlash(input) ? input.slice(0, -1) : input) || "/";
  }
  if (!hasTrailingSlash(input, true)) {
    return input || "/";
  }
  let path = input;
  let fragment = "";
  const fragmentIndex = input.indexOf("#");
  if (fragmentIndex !== -1) {
    path = input.slice(0, fragmentIndex);
    fragment = input.slice(fragmentIndex);
  }
  const [s0, ...s] = path.split("?");
  const cleanPath = s0.endsWith("/") ? s0.slice(0, -1) : s0;
  return (cleanPath || "/") + (s.length > 0 ? `?${s.join("?")}` : "") + fragment;
}
function withTrailingSlash(input = "", respectQueryAndFragment) {
  if (!respectQueryAndFragment) {
    return input.endsWith("/") ? input : input + "/";
  }
  if (hasTrailingSlash(input, true)) {
    return input || "/";
  }
  let path = input;
  let fragment = "";
  const fragmentIndex = input.indexOf("#");
  if (fragmentIndex !== -1) {
    path = input.slice(0, fragmentIndex);
    fragment = input.slice(fragmentIndex);
    if (!path) {
      return fragment;
    }
  }
  const [s0, ...s] = path.split("?");
  return s0 + "/" + (s.length > 0 ? `?${s.join("?")}` : "") + fragment;
}
function hasLeadingSlash(input = "") {
  return input.startsWith("/");
}
function withLeadingSlash(input = "") {
  return hasLeadingSlash(input) ? input : "/" + input;
}
function cleanDoubleSlashes(input = "") {
  return input.split("://").map((string_) => string_.replace(/\/{2,}/g, "/")).join("://");
}
function withBase(input, base) {
  if (isEmptyURL(base) || hasProtocol(input)) {
    return input;
  }
  const _base = withoutTrailingSlash(base);
  if (input.startsWith(_base)) {
    return input;
  }
  return joinURL(_base, input);
}
function withoutBase(input, base) {
  if (isEmptyURL(base)) {
    return input;
  }
  const _base = withoutTrailingSlash(base);
  if (!input.startsWith(_base)) {
    return input;
  }
  const trimmed = input.slice(_base.length);
  return trimmed[0] === "/" ? trimmed : "/" + trimmed;
}
function withQuery(input, query) {
  const parsed = parseURL(input);
  const mergedQuery = { ...parseQuery(parsed.search), ...query };
  parsed.search = stringifyQuery(mergedQuery);
  return stringifyParsedURL(parsed);
}
function getQuery$1(input) {
  return parseQuery(parseURL(input).search);
}
function isEmptyURL(url) {
  return !url || url === "/";
}
function isNonEmptyURL(url) {
  return url && url !== "/";
}
function joinURL(base, ...input) {
  let url = base || "";
  for (const segment of input.filter((url2) => isNonEmptyURL(url2))) {
    if (url) {
      const _segment = segment.replace(JOIN_LEADING_SLASH_RE, "");
      url = withTrailingSlash(url) + _segment;
    } else {
      url = segment;
    }
  }
  return url;
}
function joinRelativeURL(..._input) {
  const JOIN_SEGMENT_SPLIT_RE = /\/(?!\/)/;
  const input = _input.filter(Boolean);
  const segments = [];
  let segmentsDepth = 0;
  for (const i of input) {
    if (!i || i === "/") {
      continue;
    }
    for (const [sindex, s] of i.split(JOIN_SEGMENT_SPLIT_RE).entries()) {
      if (!s || s === ".") {
        continue;
      }
      if (s === "..") {
        if (segments.length === 1 && hasProtocol(segments[0])) {
          continue;
        }
        segments.pop();
        segmentsDepth--;
        continue;
      }
      if (sindex === 1 && segments[segments.length - 1]?.endsWith(":/")) {
        segments[segments.length - 1] += "/" + s;
        continue;
      }
      segments.push(s);
      segmentsDepth++;
    }
  }
  let url = segments.join("/");
  if (segmentsDepth >= 0) {
    if (input[0]?.startsWith("/") && !url.startsWith("/")) {
      url = "/" + url;
    } else if (input[0]?.startsWith("./") && !url.startsWith("./")) {
      url = "./" + url;
    }
  } else {
    url = "../".repeat(-1 * segmentsDepth) + url;
  }
  if (input[input.length - 1]?.endsWith("/") && !url.endsWith("/")) {
    url += "/";
  }
  return url;
}

const protocolRelative = Symbol.for("ufo:protocolRelative");
function parseURL(input = "", defaultProto) {
  const _specialProtoMatch = input.match(
    /^[\s\0]*(blob:|data:|javascript:|vbscript:)(.*)/i
  );
  if (_specialProtoMatch) {
    const [, _proto, _pathname = ""] = _specialProtoMatch;
    return {
      protocol: _proto.toLowerCase(),
      pathname: _pathname,
      href: _proto + _pathname,
      auth: "",
      host: "",
      search: "",
      hash: ""
    };
  }
  if (!hasProtocol(input, { acceptRelative: true })) {
    return parsePath(input);
  }
  const [, protocol = "", auth, hostAndPath = ""] = input.replace(/\\/g, "/").match(/^[\s\0]*([\w+.-]{2,}:)?\/\/([^/@]+@)?(.*)/) || [];
  let [, host = "", path = ""] = hostAndPath.match(/([^#/?]*)(.*)?/) || [];
  if (protocol === "file:") {
    path = path.replace(/\/(?=[A-Za-z]:)/, "");
  }
  const { pathname, search, hash } = parsePath(path);
  return {
    protocol: protocol.toLowerCase(),
    auth: auth ? auth.slice(0, Math.max(0, auth.length - 1)) : "",
    host,
    pathname,
    search,
    hash,
    [protocolRelative]: !protocol
  };
}
function parsePath(input = "") {
  const [pathname = "", search = "", hash = ""] = (input.match(/([^#?]*)(\?[^#]*)?(#.*)?/) || []).splice(1);
  return {
    pathname,
    search,
    hash
  };
}
function stringifyParsedURL(parsed) {
  const pathname = parsed.pathname || "";
  const search = parsed.search ? (parsed.search.startsWith("?") ? "" : "?") + parsed.search : "";
  const hash = parsed.hash || "";
  const auth = parsed.auth ? parsed.auth + "@" : "";
  const host = parsed.host || "";
  const proto = parsed.protocol || parsed[protocolRelative] ? (parsed.protocol || "") + "//" : "";
  return proto + auth + host + pathname + search + hash;
}

const NODE_TYPES = {
  NORMAL: 0,
  WILDCARD: 1,
  PLACEHOLDER: 2
};

function createRouter$1(options = {}) {
  const ctx = {
    options,
    rootNode: createRadixNode(),
    staticRoutesMap: {}
  };
  const normalizeTrailingSlash = (p) => options.strictTrailingSlash ? p : p.replace(/\/$/, "") || "/";
  if (options.routes) {
    for (const path in options.routes) {
      insert(ctx, normalizeTrailingSlash(path), options.routes[path]);
    }
  }
  return {
    ctx,
    lookup: (path) => lookup(ctx, normalizeTrailingSlash(path)),
    insert: (path, data) => insert(ctx, normalizeTrailingSlash(path), data),
    remove: (path) => remove(ctx, normalizeTrailingSlash(path))
  };
}
function lookup(ctx, path) {
  const staticPathNode = ctx.staticRoutesMap[path];
  if (staticPathNode) {
    return staticPathNode.data;
  }
  const sections = path.split("/");
  const params = {};
  let paramsFound = false;
  let wildcardNode = null;
  let node = ctx.rootNode;
  let wildCardParam = null;
  for (let i = 0; i < sections.length; i++) {
    const section = sections[i];
    if (node.wildcardChildNode !== null) {
      wildcardNode = node.wildcardChildNode;
      wildCardParam = sections.slice(i).join("/");
    }
    const nextNode = node.children.get(section);
    if (nextNode === void 0) {
      if (node && node.placeholderChildren.length > 1) {
        const remaining = sections.length - i;
        node = node.placeholderChildren.find((c) => c.maxDepth === remaining) || null;
      } else {
        node = node.placeholderChildren[0] || null;
      }
      if (!node) {
        break;
      }
      if (node.paramName) {
        params[node.paramName] = section;
      }
      paramsFound = true;
    } else {
      node = nextNode;
    }
  }
  if ((node === null || node.data === null) && wildcardNode !== null) {
    node = wildcardNode;
    params[node.paramName || "_"] = wildCardParam;
    paramsFound = true;
  }
  if (!node) {
    return null;
  }
  if (paramsFound) {
    return {
      ...node.data,
      params: paramsFound ? params : void 0
    };
  }
  return node.data;
}
function insert(ctx, path, data) {
  let isStaticRoute = true;
  const sections = path.split("/");
  let node = ctx.rootNode;
  let _unnamedPlaceholderCtr = 0;
  const matchedNodes = [node];
  for (const section of sections) {
    let childNode;
    if (childNode = node.children.get(section)) {
      node = childNode;
    } else {
      const type = getNodeType(section);
      childNode = createRadixNode({ type, parent: node });
      node.children.set(section, childNode);
      if (type === NODE_TYPES.PLACEHOLDER) {
        childNode.paramName = section === "*" ? `_${_unnamedPlaceholderCtr++}` : section.slice(1);
        node.placeholderChildren.push(childNode);
        isStaticRoute = false;
      } else if (type === NODE_TYPES.WILDCARD) {
        node.wildcardChildNode = childNode;
        childNode.paramName = section.slice(
          3
          /* "**:" */
        ) || "_";
        isStaticRoute = false;
      }
      matchedNodes.push(childNode);
      node = childNode;
    }
  }
  for (const [depth, node2] of matchedNodes.entries()) {
    node2.maxDepth = Math.max(matchedNodes.length - depth, node2.maxDepth || 0);
  }
  node.data = data;
  if (isStaticRoute === true) {
    ctx.staticRoutesMap[path] = node;
  }
  return node;
}
function remove(ctx, path) {
  let success = false;
  const sections = path.split("/");
  let node = ctx.rootNode;
  for (const section of sections) {
    node = node.children.get(section);
    if (!node) {
      return success;
    }
  }
  if (node.data) {
    const lastSection = sections.at(-1) || "";
    node.data = null;
    if (Object.keys(node.children).length === 0 && node.parent) {
      node.parent.children.delete(lastSection);
      node.parent.wildcardChildNode = null;
      node.parent.placeholderChildren = [];
    }
    success = true;
  }
  return success;
}
function createRadixNode(options = {}) {
  return {
    type: options.type || NODE_TYPES.NORMAL,
    maxDepth: 0,
    parent: options.parent || null,
    children: /* @__PURE__ */ new Map(),
    data: options.data || null,
    paramName: options.paramName || null,
    wildcardChildNode: null,
    placeholderChildren: []
  };
}
function getNodeType(str) {
  if (str.startsWith("**")) {
    return NODE_TYPES.WILDCARD;
  }
  if (str[0] === ":" || str === "*") {
    return NODE_TYPES.PLACEHOLDER;
  }
  return NODE_TYPES.NORMAL;
}

function toRouteMatcher(router) {
  const table = _routerNodeToTable("", router.ctx.rootNode);
  return _createMatcher(table, router.ctx.options.strictTrailingSlash);
}
function _createMatcher(table, strictTrailingSlash) {
  return {
    ctx: { table },
    matchAll: (path) => _matchRoutes(path, table, strictTrailingSlash)
  };
}
function _createRouteTable() {
  return {
    static: /* @__PURE__ */ new Map(),
    wildcard: /* @__PURE__ */ new Map(),
    dynamic: /* @__PURE__ */ new Map()
  };
}
function _matchRoutes(path, table, strictTrailingSlash) {
  if (strictTrailingSlash !== true && path.endsWith("/")) {
    path = path.slice(0, -1) || "/";
  }
  const matches = [];
  for (const [key, value] of _sortRoutesMap(table.wildcard)) {
    if (path === key || path.startsWith(key + "/")) {
      matches.push(value);
    }
  }
  for (const [key, value] of _sortRoutesMap(table.dynamic)) {
    if (path.startsWith(key + "/")) {
      const subPath = "/" + path.slice(key.length).split("/").splice(2).join("/");
      matches.push(..._matchRoutes(subPath, value));
    }
  }
  const staticMatch = table.static.get(path);
  if (staticMatch) {
    matches.push(staticMatch);
  }
  return matches.filter(Boolean);
}
function _sortRoutesMap(m) {
  return [...m.entries()].sort((a, b) => a[0].length - b[0].length);
}
function _routerNodeToTable(initialPath, initialNode) {
  const table = _createRouteTable();
  function _addNode(path, node) {
    if (path) {
      if (node.type === NODE_TYPES.NORMAL && !(path.includes("*") || path.includes(":"))) {
        if (node.data) {
          table.static.set(path, node.data);
        }
      } else if (node.type === NODE_TYPES.WILDCARD) {
        table.wildcard.set(path.replace("/**", ""), node.data);
      } else if (node.type === NODE_TYPES.PLACEHOLDER) {
        const subTable = _routerNodeToTable("", node);
        if (node.data) {
          subTable.static.set("/", node.data);
        }
        table.dynamic.set(path.replace(/\/\*|\/:\w+/, ""), subTable);
        return;
      }
    }
    for (const [childPath, child] of node.children.entries()) {
      _addNode(`${path}/${childPath}`.replace("//", "/"), child);
    }
  }
  _addNode(initialPath, initialNode);
  return table;
}

function isPlainObject(value) {
  if (value === null || typeof value !== "object") {
    return false;
  }
  const prototype = Object.getPrototypeOf(value);
  if (prototype !== null && prototype !== Object.prototype && Object.getPrototypeOf(prototype) !== null) {
    return false;
  }
  if (Symbol.iterator in value) {
    return false;
  }
  if (Symbol.toStringTag in value) {
    return Object.prototype.toString.call(value) === "[object Module]";
  }
  return true;
}

function _defu(baseObject, defaults, namespace = ".", merger) {
  if (!isPlainObject(defaults)) {
    return _defu(baseObject, {}, namespace, merger);
  }
  const object = Object.assign({}, defaults);
  for (const key in baseObject) {
    if (key === "__proto__" || key === "constructor") {
      continue;
    }
    const value = baseObject[key];
    if (value === null || value === void 0) {
      continue;
    }
    if (merger && merger(object, key, value, namespace)) {
      continue;
    }
    if (Array.isArray(value) && Array.isArray(object[key])) {
      object[key] = [...value, ...object[key]];
    } else if (isPlainObject(value) && isPlainObject(object[key])) {
      object[key] = _defu(
        value,
        object[key],
        (namespace ? `${namespace}.` : "") + key.toString(),
        merger
      );
    } else {
      object[key] = value;
    }
  }
  return object;
}
function createDefu(merger) {
  return (...arguments_) => (
    // eslint-disable-next-line unicorn/no-array-reduce
    arguments_.reduce((p, c) => _defu(p, c, "", merger), {})
  );
}
const defu = createDefu();
const defuFn = createDefu((object, key, currentValue) => {
  if (object[key] !== void 0 && typeof currentValue === "function") {
    object[key] = currentValue(object[key]);
    return true;
  }
});

function o$1(n){throw new Error(`${n} is not implemented yet!`)}let i$2 = class i extends EventEmitter{__unenv__={};readableEncoding=null;readableEnded=true;readableFlowing=false;readableHighWaterMark=0;readableLength=0;readableObjectMode=false;readableAborted=false;readableDidRead=false;closed=false;errored=null;readable=false;destroyed=false;static from(e,t){return new i(t)}constructor(e){super();}_read(e){}read(e){}setEncoding(e){return this}pause(){return this}resume(){return this}isPaused(){return  true}unpipe(e){return this}unshift(e,t){}wrap(e){return this}push(e,t){return  false}_destroy(e,t){this.removeAllListeners();}destroy(e){return this.destroyed=true,this._destroy(e),this}pipe(e,t){return {}}compose(e,t){throw new Error("Method not implemented.")}[Symbol.asyncDispose](){return this.destroy(),Promise.resolve()}async*[Symbol.asyncIterator](){throw o$1("Readable.asyncIterator")}iterator(e){throw o$1("Readable.iterator")}map(e,t){throw o$1("Readable.map")}filter(e,t){throw o$1("Readable.filter")}forEach(e,t){throw o$1("Readable.forEach")}reduce(e,t,r){throw o$1("Readable.reduce")}find(e,t){throw o$1("Readable.find")}findIndex(e,t){throw o$1("Readable.findIndex")}some(e,t){throw o$1("Readable.some")}toArray(e){throw o$1("Readable.toArray")}every(e,t){throw o$1("Readable.every")}flatMap(e,t){throw o$1("Readable.flatMap")}drop(e,t){throw o$1("Readable.drop")}take(e,t){throw o$1("Readable.take")}asIndexedPairs(e){throw o$1("Readable.asIndexedPairs")}};let l$2 = class l extends EventEmitter{__unenv__={};writable=true;writableEnded=false;writableFinished=false;writableHighWaterMark=0;writableLength=0;writableObjectMode=false;writableCorked=0;closed=false;errored=null;writableNeedDrain=false;writableAborted=false;destroyed=false;_data;_encoding="utf8";constructor(e){super();}pipe(e,t){return {}}_write(e,t,r){if(this.writableEnded){r&&r();return}if(this._data===void 0)this._data=e;else {const s=typeof this._data=="string"?Buffer$1.from(this._data,this._encoding||t||"utf8"):this._data,a=typeof e=="string"?Buffer$1.from(e,t||this._encoding||"utf8"):e;this._data=Buffer$1.concat([s,a]);}this._encoding=t,r&&r();}_writev(e,t){}_destroy(e,t){}_final(e){}write(e,t,r){const s=typeof t=="string"?this._encoding:"utf8",a=typeof t=="function"?t:typeof r=="function"?r:void 0;return this._write(e,s,a),true}setDefaultEncoding(e){return this}end(e,t,r){const s=typeof e=="function"?e:typeof t=="function"?t:typeof r=="function"?r:void 0;if(this.writableEnded)return s&&s(),this;const a=e===s?void 0:e;if(a){const u=t===s?void 0:t;this.write(a,u,s);}return this.writableEnded=true,this.writableFinished=true,this.emit("close"),this.emit("finish"),this}cork(){}uncork(){}destroy(e){return this.destroyed=true,delete this._data,this.removeAllListeners(),this}compose(e,t){throw new Error("Method not implemented.")}};const c$2=class c{allowHalfOpen=true;_destroy;constructor(e=new i$2,t=new l$2){Object.assign(this,e),Object.assign(this,t),this._destroy=g$1(e._destroy,t._destroy);}};function _$2(){return Object.assign(c$2.prototype,i$2.prototype),Object.assign(c$2.prototype,l$2.prototype),c$2}function g$1(...n){return function(...e){for(const t of n)t(...e);}}const m=_$2();let A$1 = class A extends m{__unenv__={};bufferSize=0;bytesRead=0;bytesWritten=0;connecting=false;destroyed=false;pending=false;localAddress="";localPort=0;remoteAddress="";remoteFamily="";remotePort=0;autoSelectFamilyAttemptedAddresses=[];readyState="readOnly";constructor(e){super();}write(e,t,r){return  false}connect(e,t,r){return this}end(e,t,r){return this}setEncoding(e){return this}pause(){return this}resume(){return this}setTimeout(e,t){return this}setNoDelay(e){return this}setKeepAlive(e,t){return this}address(){return {}}unref(){return this}ref(){return this}destroySoon(){this.destroy();}resetAndDestroy(){const e=new Error("ERR_SOCKET_CLOSED");return e.code="ERR_SOCKET_CLOSED",this.destroy(e),this}};class y extends i$2{aborted=false;httpVersion="1.1";httpVersionMajor=1;httpVersionMinor=1;complete=true;connection;socket;headers={};trailers={};method="GET";url="/";statusCode=200;statusMessage="";closed=false;errored=null;readable=false;constructor(e){super(),this.socket=this.connection=e||new A$1;}get rawHeaders(){const e=this.headers,t=[];for(const r in e)if(Array.isArray(e[r]))for(const s of e[r])t.push(r,s);else t.push(r,e[r]);return t}get rawTrailers(){return []}setTimeout(e,t){return this}get headersDistinct(){return p(this.headers)}get trailersDistinct(){return p(this.trailers)}}function p(n){const e={};for(const[t,r]of Object.entries(n))t&&(e[t]=(Array.isArray(r)?r:[r]).filter(Boolean));return e}class w extends l$2{statusCode=200;statusMessage="";upgrading=false;chunkedEncoding=false;shouldKeepAlive=false;useChunkedEncodingByDefault=false;sendDate=false;finished=false;headersSent=false;strictContentLength=false;connection=null;socket=null;req;_headers={};constructor(e){super(),this.req=e;}assignSocket(e){e._httpMessage=this,this.socket=e,this.connection=e,this.emit("socket",e),this._flush();}_flush(){this.flushHeaders();}detachSocket(e){}writeContinue(e){}writeHead(e,t,r){e&&(this.statusCode=e),typeof t=="string"&&(this.statusMessage=t,t=void 0);const s=r||t;if(s&&!Array.isArray(s))for(const a in s)this.setHeader(a,s[a]);return this.headersSent=true,this}writeProcessing(){}setTimeout(e,t){return this}appendHeader(e,t){e=e.toLowerCase();const r=this._headers[e],s=[...Array.isArray(r)?r:[r],...Array.isArray(t)?t:[t]].filter(Boolean);return this._headers[e]=s.length>1?s:s[0],this}setHeader(e,t){return this._headers[e.toLowerCase()]=t,this}setHeaders(e){for(const[t,r]of Object.entries(e))this.setHeader(t,r);return this}getHeader(e){return this._headers[e.toLowerCase()]}getHeaders(){return this._headers}getHeaderNames(){return Object.keys(this._headers)}hasHeader(e){return e.toLowerCase()in this._headers}removeHeader(e){delete this._headers[e.toLowerCase()];}addTrailers(e){}flushHeaders(){}writeEarlyHints(e,t){typeof t=="function"&&t();}}const E=(()=>{const n=function(){};return n.prototype=Object.create(null),n})();function R$1(n={}){const e=new E,t=Array.isArray(n)||H$1(n)?n:Object.entries(n);for(const[r,s]of t)if(s){if(e[r]===void 0){e[r]=s;continue}e[r]=[...Array.isArray(e[r])?e[r]:[e[r]],...Array.isArray(s)?s:[s]];}return e}function H$1(n){return typeof n?.entries=="function"}function v(n={}){if(n instanceof Headers)return n;const e=new Headers;for(const[t,r]of Object.entries(n))if(r!==void 0){if(Array.isArray(r)){for(const s of r)e.append(t,String(s));continue}e.set(t,String(r));}return e}const S$1=new Set([101,204,205,304]);async function b$1(n,e){const t=new y,r=new w(t);t.url=e.url?.toString()||"/";let s;if(!t.url.startsWith("/")){const d=new URL(t.url);s=d.host,t.url=d.pathname+d.search+d.hash;}t.method=e.method||"GET",t.headers=R$1(e.headers||{}),t.headers.host||(t.headers.host=e.host||s||"localhost"),t.connection.encrypted=t.connection.encrypted||e.protocol==="https",t.body=e.body||null,t.__unenv__=e.context,await n(t,r);let a=r._data;(S$1.has(r.statusCode)||t.method.toUpperCase()==="HEAD")&&(a=null,delete r._headers["content-length"]);const u={status:r.statusCode,statusText:r.statusMessage,headers:r._headers,body:a};return t.destroy(),r.destroy(),u}async function C$1(n,e,t={}){try{const r=await b$1(n,{url:e,...t});return new Response(r.body,{status:r.status,statusText:r.statusText,headers:v(r.headers)})}catch(r){return new Response(r.toString(),{status:Number.parseInt(r.statusCode||r.code)||500,statusText:r.statusText})}}

function hasProp(obj, prop) {
  try {
    return prop in obj;
  } catch {
    return false;
  }
}

class H3Error extends Error {
  static __h3_error__ = true;
  statusCode = 500;
  fatal = false;
  unhandled = false;
  statusMessage;
  data;
  cause;
  constructor(message, opts = {}) {
    super(message, opts);
    if (opts.cause && !this.cause) {
      this.cause = opts.cause;
    }
  }
  toJSON() {
    const obj = {
      message: this.message,
      statusCode: sanitizeStatusCode(this.statusCode, 500)
    };
    if (this.statusMessage) {
      obj.statusMessage = sanitizeStatusMessage(this.statusMessage);
    }
    if (this.data !== void 0) {
      obj.data = this.data;
    }
    return obj;
  }
}
function createError$1(input) {
  if (typeof input === "string") {
    return new H3Error(input);
  }
  if (isError(input)) {
    return input;
  }
  const err = new H3Error(input.message ?? input.statusMessage ?? "", {
    cause: input.cause || input
  });
  if (hasProp(input, "stack")) {
    try {
      Object.defineProperty(err, "stack", {
        get() {
          return input.stack;
        }
      });
    } catch {
      try {
        err.stack = input.stack;
      } catch {
      }
    }
  }
  if (input.data) {
    err.data = input.data;
  }
  if (input.statusCode) {
    err.statusCode = sanitizeStatusCode(input.statusCode, err.statusCode);
  } else if (input.status) {
    err.statusCode = sanitizeStatusCode(input.status, err.statusCode);
  }
  if (input.statusMessage) {
    err.statusMessage = input.statusMessage;
  } else if (input.statusText) {
    err.statusMessage = input.statusText;
  }
  if (err.statusMessage) {
    const originalMessage = err.statusMessage;
    const sanitizedMessage = sanitizeStatusMessage(err.statusMessage);
    if (sanitizedMessage !== originalMessage) {
      console.warn(
        "[h3] Please prefer using `message` for longer error messages instead of `statusMessage`. In the future, `statusMessage` will be sanitized by default."
      );
    }
  }
  if (input.fatal !== void 0) {
    err.fatal = input.fatal;
  }
  if (input.unhandled !== void 0) {
    err.unhandled = input.unhandled;
  }
  return err;
}
function sendError(event, error, debug) {
  if (event.handled) {
    return;
  }
  const h3Error = isError(error) ? error : createError$1(error);
  const responseBody = {
    statusCode: h3Error.statusCode,
    statusMessage: h3Error.statusMessage,
    stack: [],
    data: h3Error.data
  };
  if (debug) {
    responseBody.stack = (h3Error.stack || "").split("\n").map((l) => l.trim());
  }
  if (event.handled) {
    return;
  }
  const _code = Number.parseInt(h3Error.statusCode);
  setResponseStatus(event, _code, h3Error.statusMessage);
  event.node.res.setHeader("content-type", MIMES.json);
  event.node.res.end(JSON.stringify(responseBody, void 0, 2));
}
function isError(input) {
  return input?.constructor?.__h3_error__ === true;
}

function getQuery(event) {
  return getQuery$1(event.path || "");
}
function getRouterParams(event, opts = {}) {
  let params = event.context.params || {};
  if (opts.decode) {
    params = { ...params };
    for (const key in params) {
      params[key] = decode(params[key]);
    }
  }
  return params;
}
function getRouterParam(event, name, opts = {}) {
  const params = getRouterParams(event, opts);
  return params[name];
}
function isMethod(event, expected, allowHead) {
  if (typeof expected === "string") {
    if (event.method === expected) {
      return true;
    }
  } else if (expected.includes(event.method)) {
    return true;
  }
  return false;
}
function assertMethod(event, expected, allowHead) {
  if (!isMethod(event, expected)) {
    throw createError$1({
      statusCode: 405,
      statusMessage: "HTTP method is not allowed."
    });
  }
}
function getRequestHeaders(event) {
  const _headers = {};
  for (const key in event.node.req.headers) {
    const val = event.node.req.headers[key];
    _headers[key] = Array.isArray(val) ? val.filter(Boolean).join(", ") : val;
  }
  return _headers;
}
function getRequestHeader(event, name) {
  const headers = getRequestHeaders(event);
  const value = headers[name.toLowerCase()];
  return value;
}
const getHeader = getRequestHeader;
function getRequestHost(event, opts = {}) {
  if (opts.xForwardedHost) {
    const xForwardedHost = event.node.req.headers["x-forwarded-host"];
    if (xForwardedHost) {
      return xForwardedHost;
    }
  }
  return event.node.req.headers.host || "localhost";
}
function getRequestProtocol(event, opts = {}) {
  if (opts.xForwardedProto !== false && event.node.req.headers["x-forwarded-proto"] === "https") {
    return "https";
  }
  return event.node.req.connection?.encrypted ? "https" : "http";
}
function getRequestURL(event, opts = {}) {
  const host = getRequestHost(event, opts);
  const protocol = getRequestProtocol(event, opts);
  const path = (event.node.req.originalUrl || event.path).replace(
    /^[/\\]+/g,
    "/"
  );
  return new URL(path, `${protocol}://${host}`);
}
function toWebRequest(event) {
  return event.web?.request || new Request(getRequestURL(event), {
    // @ts-ignore Undici option
    duplex: "half",
    method: event.method,
    headers: event.headers,
    body: getRequestWebStream(event)
  });
}
function getRequestIP(event, opts = {}) {
  if (event.context.clientAddress) {
    return event.context.clientAddress;
  }
  if (opts.xForwardedFor) {
    const xForwardedFor = getRequestHeader(event, "x-forwarded-for")?.split(",").shift()?.trim();
    if (xForwardedFor) {
      return xForwardedFor;
    }
  }
  if (event.node.req.socket.remoteAddress) {
    return event.node.req.socket.remoteAddress;
  }
}

const RawBodySymbol = Symbol.for("h3RawBody");
const ParsedBodySymbol = Symbol.for("h3ParsedBody");
const PayloadMethods$1 = ["PATCH", "POST", "PUT", "DELETE"];
function readRawBody(event, encoding = "utf8") {
  assertMethod(event, PayloadMethods$1);
  const _rawBody = event._requestBody || event.web?.request?.body || event.node.req[RawBodySymbol] || event.node.req.rawBody || event.node.req.body;
  if (_rawBody) {
    const promise2 = Promise.resolve(_rawBody).then((_resolved) => {
      if (Buffer.isBuffer(_resolved)) {
        return _resolved;
      }
      if (typeof _resolved.pipeTo === "function") {
        return new Promise((resolve, reject) => {
          const chunks = [];
          _resolved.pipeTo(
            new WritableStream({
              write(chunk) {
                chunks.push(chunk);
              },
              close() {
                resolve(Buffer.concat(chunks));
              },
              abort(reason) {
                reject(reason);
              }
            })
          ).catch(reject);
        });
      } else if (typeof _resolved.pipe === "function") {
        return new Promise((resolve, reject) => {
          const chunks = [];
          _resolved.on("data", (chunk) => {
            chunks.push(chunk);
          }).on("end", () => {
            resolve(Buffer.concat(chunks));
          }).on("error", reject);
        });
      }
      if (_resolved.constructor === Object) {
        return Buffer.from(JSON.stringify(_resolved));
      }
      if (_resolved instanceof URLSearchParams) {
        return Buffer.from(_resolved.toString());
      }
      if (_resolved instanceof FormData) {
        return new Response(_resolved).bytes().then((uint8arr) => Buffer.from(uint8arr));
      }
      return Buffer.from(_resolved);
    });
    return encoding ? promise2.then((buff) => buff.toString(encoding)) : promise2;
  }
  if (!Number.parseInt(event.node.req.headers["content-length"] || "") && !String(event.node.req.headers["transfer-encoding"] ?? "").split(",").map((e) => e.trim()).filter(Boolean).includes("chunked")) {
    return Promise.resolve(void 0);
  }
  const promise = event.node.req[RawBodySymbol] = new Promise(
    (resolve, reject) => {
      const bodyData = [];
      event.node.req.on("error", (err) => {
        reject(err);
      }).on("data", (chunk) => {
        bodyData.push(chunk);
      }).on("end", () => {
        resolve(Buffer.concat(bodyData));
      });
    }
  );
  const result = encoding ? promise.then((buff) => buff.toString(encoding)) : promise;
  return result;
}
async function readBody(event, options = {}) {
  const request = event.node.req;
  if (hasProp(request, ParsedBodySymbol)) {
    return request[ParsedBodySymbol];
  }
  const contentType = request.headers["content-type"] || "";
  const body = await readRawBody(event);
  let parsed;
  if (contentType === "application/json") {
    parsed = _parseJSON(body, options.strict ?? true);
  } else if (contentType.startsWith("application/x-www-form-urlencoded")) {
    parsed = _parseURLEncodedBody(body);
  } else if (contentType.startsWith("text/")) {
    parsed = body;
  } else {
    parsed = _parseJSON(body, options.strict ?? false);
  }
  request[ParsedBodySymbol] = parsed;
  return parsed;
}
async function readFormData(event) {
  return await toWebRequest(event).formData();
}
function getRequestWebStream(event) {
  if (!PayloadMethods$1.includes(event.method)) {
    return;
  }
  const bodyStream = event.web?.request?.body || event._requestBody;
  if (bodyStream) {
    return bodyStream;
  }
  const _hasRawBody = RawBodySymbol in event.node.req || "rawBody" in event.node.req || "body" in event.node.req || "__unenv__" in event.node.req;
  if (_hasRawBody) {
    return new ReadableStream({
      async start(controller) {
        const _rawBody = await readRawBody(event, false);
        if (_rawBody) {
          controller.enqueue(_rawBody);
        }
        controller.close();
      }
    });
  }
  return new ReadableStream({
    start: (controller) => {
      event.node.req.on("data", (chunk) => {
        controller.enqueue(chunk);
      });
      event.node.req.on("end", () => {
        controller.close();
      });
      event.node.req.on("error", (err) => {
        controller.error(err);
      });
    }
  });
}
function _parseJSON(body = "", strict) {
  if (!body) {
    return void 0;
  }
  try {
    return destr(body, { strict });
  } catch {
    throw createError$1({
      statusCode: 400,
      statusMessage: "Bad Request",
      message: "Invalid JSON body"
    });
  }
}
function _parseURLEncodedBody(body) {
  const form = new URLSearchParams(body);
  const parsedForm = /* @__PURE__ */ Object.create(null);
  for (const [key, value] of form.entries()) {
    if (hasProp(parsedForm, key)) {
      if (!Array.isArray(parsedForm[key])) {
        parsedForm[key] = [parsedForm[key]];
      }
      parsedForm[key].push(value);
    } else {
      parsedForm[key] = value;
    }
  }
  return parsedForm;
}

function handleCacheHeaders(event, opts) {
  const cacheControls = ["public", ...opts.cacheControls || []];
  let cacheMatched = false;
  if (opts.maxAge !== void 0) {
    cacheControls.push(`max-age=${+opts.maxAge}`, `s-maxage=${+opts.maxAge}`);
  }
  if (opts.modifiedTime) {
    const modifiedTime = new Date(opts.modifiedTime);
    const ifModifiedSince = event.node.req.headers["if-modified-since"];
    event.node.res.setHeader("last-modified", modifiedTime.toUTCString());
    if (ifModifiedSince && new Date(ifModifiedSince) >= modifiedTime) {
      cacheMatched = true;
    }
  }
  if (opts.etag) {
    event.node.res.setHeader("etag", opts.etag);
    const ifNonMatch = event.node.req.headers["if-none-match"];
    if (ifNonMatch === opts.etag) {
      cacheMatched = true;
    }
  }
  event.node.res.setHeader("cache-control", cacheControls.join(", "));
  if (cacheMatched) {
    event.node.res.statusCode = 304;
    if (!event.handled) {
      event.node.res.end();
    }
    return true;
  }
  return false;
}

const MIMES = {
  html: "text/html",
  json: "application/json"
};

const DISALLOWED_STATUS_CHARS = /[^\u0009\u0020-\u007E]/g;
function sanitizeStatusMessage(statusMessage = "") {
  return statusMessage.replace(DISALLOWED_STATUS_CHARS, "");
}
function sanitizeStatusCode(statusCode, defaultStatusCode = 200) {
  if (!statusCode) {
    return defaultStatusCode;
  }
  if (typeof statusCode === "string") {
    statusCode = Number.parseInt(statusCode, 10);
  }
  if (statusCode < 100 || statusCode > 999) {
    return defaultStatusCode;
  }
  return statusCode;
}
function splitCookiesString(cookiesString) {
  if (Array.isArray(cookiesString)) {
    return cookiesString.flatMap((c) => splitCookiesString(c));
  }
  if (typeof cookiesString !== "string") {
    return [];
  }
  const cookiesStrings = [];
  let pos = 0;
  let start;
  let ch;
  let lastComma;
  let nextStart;
  let cookiesSeparatorFound;
  const skipWhitespace = () => {
    while (pos < cookiesString.length && /\s/.test(cookiesString.charAt(pos))) {
      pos += 1;
    }
    return pos < cookiesString.length;
  };
  const notSpecialChar = () => {
    ch = cookiesString.charAt(pos);
    return ch !== "=" && ch !== ";" && ch !== ",";
  };
  while (pos < cookiesString.length) {
    start = pos;
    cookiesSeparatorFound = false;
    while (skipWhitespace()) {
      ch = cookiesString.charAt(pos);
      if (ch === ",") {
        lastComma = pos;
        pos += 1;
        skipWhitespace();
        nextStart = pos;
        while (pos < cookiesString.length && notSpecialChar()) {
          pos += 1;
        }
        if (pos < cookiesString.length && cookiesString.charAt(pos) === "=") {
          cookiesSeparatorFound = true;
          pos = nextStart;
          cookiesStrings.push(cookiesString.slice(start, lastComma));
          start = pos;
        } else {
          pos = lastComma + 1;
        }
      } else {
        pos += 1;
      }
    }
    if (!cookiesSeparatorFound || pos >= cookiesString.length) {
      cookiesStrings.push(cookiesString.slice(start));
    }
  }
  return cookiesStrings;
}

const defer = typeof setImmediate === "undefined" ? (fn) => fn() : setImmediate;
function send(event, data, type) {
  if (type) {
    defaultContentType(event, type);
  }
  return new Promise((resolve) => {
    defer(() => {
      if (!event.handled) {
        event.node.res.end(data);
      }
      resolve();
    });
  });
}
function sendNoContent(event, code) {
  if (event.handled) {
    return;
  }
  if (!code && event.node.res.statusCode !== 200) {
    code = event.node.res.statusCode;
  }
  const _code = sanitizeStatusCode(code, 204);
  if (_code === 204) {
    event.node.res.removeHeader("content-length");
  }
  event.node.res.writeHead(_code);
  event.node.res.end();
}
function setResponseStatus(event, code, text) {
  if (code) {
    event.node.res.statusCode = sanitizeStatusCode(
      code,
      event.node.res.statusCode
    );
  }
  if (text) {
    event.node.res.statusMessage = sanitizeStatusMessage(text);
  }
}
function getResponseStatus(event) {
  return event.node.res.statusCode;
}
function getResponseStatusText(event) {
  return event.node.res.statusMessage;
}
function defaultContentType(event, type) {
  if (type && event.node.res.statusCode !== 304 && !event.node.res.getHeader("content-type")) {
    event.node.res.setHeader("content-type", type);
  }
}
function sendRedirect(event, location, code = 302) {
  event.node.res.statusCode = sanitizeStatusCode(
    code,
    event.node.res.statusCode
  );
  event.node.res.setHeader("location", location);
  const encodedLoc = location.replace(/"/g, "%22");
  const html = `<!DOCTYPE html><html><head><meta http-equiv="refresh" content="0; url=${encodedLoc}"></head></html>`;
  return send(event, html, MIMES.html);
}
function getResponseHeader(event, name) {
  return event.node.res.getHeader(name);
}
function setResponseHeaders(event, headers) {
  for (const [name, value] of Object.entries(headers)) {
    event.node.res.setHeader(
      name,
      value
    );
  }
}
const setHeaders = setResponseHeaders;
function setResponseHeader(event, name, value) {
  event.node.res.setHeader(name, value);
}
function appendResponseHeader(event, name, value) {
  let current = event.node.res.getHeader(name);
  if (!current) {
    event.node.res.setHeader(name, value);
    return;
  }
  if (!Array.isArray(current)) {
    current = [current.toString()];
  }
  event.node.res.setHeader(name, [...current, value]);
}
function removeResponseHeader(event, name) {
  return event.node.res.removeHeader(name);
}
function isStream(data) {
  if (!data || typeof data !== "object") {
    return false;
  }
  if (typeof data.pipe === "function") {
    if (typeof data._read === "function") {
      return true;
    }
    if (typeof data.abort === "function") {
      return true;
    }
  }
  if (typeof data.pipeTo === "function") {
    return true;
  }
  return false;
}
function isWebResponse(data) {
  return typeof Response !== "undefined" && data instanceof Response;
}
function sendStream(event, stream) {
  if (!stream || typeof stream !== "object") {
    throw new Error("[h3] Invalid stream provided.");
  }
  event.node.res._data = stream;
  if (!event.node.res.socket) {
    event._handled = true;
    return Promise.resolve();
  }
  if (hasProp(stream, "pipeTo") && typeof stream.pipeTo === "function") {
    return stream.pipeTo(
      new WritableStream({
        write(chunk) {
          event.node.res.write(chunk);
        }
      })
    ).then(() => {
      event.node.res.end();
    });
  }
  if (hasProp(stream, "pipe") && typeof stream.pipe === "function") {
    return new Promise((resolve, reject) => {
      stream.pipe(event.node.res);
      if (stream.on) {
        stream.on("end", () => {
          event.node.res.end();
          resolve();
        });
        stream.on("error", (error) => {
          reject(error);
        });
      }
      event.node.res.on("close", () => {
        if (stream.abort) {
          stream.abort();
        }
      });
    });
  }
  throw new Error("[h3] Invalid or incompatible stream provided.");
}
function sendWebResponse(event, response) {
  for (const [key, value] of response.headers) {
    if (key === "set-cookie") {
      event.node.res.appendHeader(key, splitCookiesString(value));
    } else {
      event.node.res.setHeader(key, value);
    }
  }
  if (response.status) {
    event.node.res.statusCode = sanitizeStatusCode(
      response.status,
      event.node.res.statusCode
    );
  }
  if (response.statusText) {
    event.node.res.statusMessage = sanitizeStatusMessage(response.statusText);
  }
  if (response.redirected) {
    event.node.res.setHeader("location", response.url);
  }
  if (!response.body) {
    event.node.res.end();
    return;
  }
  return sendStream(event, response.body);
}

const PayloadMethods = /* @__PURE__ */ new Set(["PATCH", "POST", "PUT", "DELETE"]);
const ignoredHeaders = /* @__PURE__ */ new Set([
  "transfer-encoding",
  "accept-encoding",
  "connection",
  "keep-alive",
  "upgrade",
  "expect",
  "host",
  "accept"
]);
async function proxyRequest(event, target, opts = {}) {
  let body;
  let duplex;
  if (PayloadMethods.has(event.method)) {
    if (opts.streamRequest) {
      body = getRequestWebStream(event);
      duplex = "half";
    } else {
      body = await readRawBody(event, false).catch(() => void 0);
    }
  }
  const method = opts.fetchOptions?.method || event.method;
  const fetchHeaders = mergeHeaders$1(
    getProxyRequestHeaders(event, { host: target.startsWith("/") }),
    opts.fetchOptions?.headers,
    opts.headers
  );
  return sendProxy(event, target, {
    ...opts,
    fetchOptions: {
      method,
      body,
      duplex,
      ...opts.fetchOptions,
      headers: fetchHeaders
    }
  });
}
async function sendProxy(event, target, opts = {}) {
  let response;
  try {
    response = await _getFetch(opts.fetch)(target, {
      headers: opts.headers,
      ignoreResponseError: true,
      // make $ofetch.raw transparent
      ...opts.fetchOptions
    });
  } catch (error) {
    throw createError$1({
      status: 502,
      statusMessage: "Bad Gateway",
      cause: error
    });
  }
  event.node.res.statusCode = sanitizeStatusCode(
    response.status,
    event.node.res.statusCode
  );
  event.node.res.statusMessage = sanitizeStatusMessage(response.statusText);
  const cookies = [];
  for (const [key, value] of response.headers.entries()) {
    if (key === "content-encoding") {
      continue;
    }
    if (key === "content-length") {
      continue;
    }
    if (key === "set-cookie") {
      cookies.push(...splitCookiesString(value));
      continue;
    }
    event.node.res.setHeader(key, value);
  }
  if (cookies.length > 0) {
    event.node.res.setHeader(
      "set-cookie",
      cookies.map((cookie) => {
        if (opts.cookieDomainRewrite) {
          cookie = rewriteCookieProperty(
            cookie,
            opts.cookieDomainRewrite,
            "domain"
          );
        }
        if (opts.cookiePathRewrite) {
          cookie = rewriteCookieProperty(
            cookie,
            opts.cookiePathRewrite,
            "path"
          );
        }
        return cookie;
      })
    );
  }
  if (opts.onResponse) {
    await opts.onResponse(event, response);
  }
  if (response._data !== void 0) {
    return response._data;
  }
  if (event.handled) {
    return;
  }
  if (opts.sendStream === false) {
    const data = new Uint8Array(await response.arrayBuffer());
    return event.node.res.end(data);
  }
  if (response.body) {
    for await (const chunk of response.body) {
      event.node.res.write(chunk);
    }
  }
  return event.node.res.end();
}
function getProxyRequestHeaders(event, opts) {
  const headers = /* @__PURE__ */ Object.create(null);
  const reqHeaders = getRequestHeaders(event);
  for (const name in reqHeaders) {
    if (!ignoredHeaders.has(name) || name === "host" && opts?.host) {
      headers[name] = reqHeaders[name];
    }
  }
  return headers;
}
function fetchWithEvent(event, req, init, options) {
  return _getFetch(options?.fetch)(req, {
    ...init,
    context: init?.context || event.context,
    headers: {
      ...getProxyRequestHeaders(event, {
        host: typeof req === "string" && req.startsWith("/")
      }),
      ...init?.headers
    }
  });
}
function _getFetch(_fetch) {
  if (_fetch) {
    return _fetch;
  }
  if (globalThis.fetch) {
    return globalThis.fetch;
  }
  throw new Error(
    "fetch is not available. Try importing `node-fetch-native/polyfill` for Node.js."
  );
}
function rewriteCookieProperty(header, map, property) {
  const _map = typeof map === "string" ? { "*": map } : map;
  return header.replace(
    new RegExp(`(;\\s*${property}=)([^;]+)`, "gi"),
    (match, prefix, previousValue) => {
      let newValue;
      if (previousValue in _map) {
        newValue = _map[previousValue];
      } else if ("*" in _map) {
        newValue = _map["*"];
      } else {
        return match;
      }
      return newValue ? prefix + newValue : "";
    }
  );
}
function mergeHeaders$1(defaults, ...inputs) {
  const _inputs = inputs.filter(Boolean);
  if (_inputs.length === 0) {
    return defaults;
  }
  const merged = new Headers(defaults);
  for (const input of _inputs) {
    const entries = Array.isArray(input) ? input : typeof input.entries === "function" ? input.entries() : Object.entries(input);
    for (const [key, value] of entries) {
      if (value !== void 0) {
        merged.set(key, value);
      }
    }
  }
  return merged;
}

class H3Event {
  "__is_event__" = true;
  // Context
  node;
  // Node
  web;
  // Web
  context = {};
  // Shared
  // Request
  _method;
  _path;
  _headers;
  _requestBody;
  // Response
  _handled = false;
  // Hooks
  _onBeforeResponseCalled;
  _onAfterResponseCalled;
  constructor(req, res) {
    this.node = { req, res };
  }
  // --- Request ---
  get method() {
    if (!this._method) {
      this._method = (this.node.req.method || "GET").toUpperCase();
    }
    return this._method;
  }
  get path() {
    return this._path || this.node.req.url || "/";
  }
  get headers() {
    if (!this._headers) {
      this._headers = _normalizeNodeHeaders(this.node.req.headers);
    }
    return this._headers;
  }
  // --- Respoonse ---
  get handled() {
    return this._handled || this.node.res.writableEnded || this.node.res.headersSent;
  }
  respondWith(response) {
    return Promise.resolve(response).then(
      (_response) => sendWebResponse(this, _response)
    );
  }
  // --- Utils ---
  toString() {
    return `[${this.method}] ${this.path}`;
  }
  toJSON() {
    return this.toString();
  }
  // --- Deprecated ---
  /** @deprecated Please use `event.node.req` instead. */
  get req() {
    return this.node.req;
  }
  /** @deprecated Please use `event.node.res` instead. */
  get res() {
    return this.node.res;
  }
}
function isEvent(input) {
  return hasProp(input, "__is_event__");
}
function createEvent(req, res) {
  return new H3Event(req, res);
}
function _normalizeNodeHeaders(nodeHeaders) {
  const headers = new Headers();
  for (const [name, value] of Object.entries(nodeHeaders)) {
    if (Array.isArray(value)) {
      for (const item of value) {
        headers.append(name, item);
      }
    } else if (value) {
      headers.set(name, value);
    }
  }
  return headers;
}

function defineEventHandler(handler) {
  if (typeof handler === "function") {
    handler.__is_handler__ = true;
    return handler;
  }
  const _hooks = {
    onRequest: _normalizeArray(handler.onRequest),
    onBeforeResponse: _normalizeArray(handler.onBeforeResponse)
  };
  const _handler = (event) => {
    return _callHandler(event, handler.handler, _hooks);
  };
  _handler.__is_handler__ = true;
  _handler.__resolve__ = handler.handler.__resolve__;
  _handler.__websocket__ = handler.websocket;
  return _handler;
}
function _normalizeArray(input) {
  return input ? Array.isArray(input) ? input : [input] : void 0;
}
async function _callHandler(event, handler, hooks) {
  if (hooks.onRequest) {
    for (const hook of hooks.onRequest) {
      await hook(event);
      if (event.handled) {
        return;
      }
    }
  }
  const body = await handler(event);
  const response = { body };
  if (hooks.onBeforeResponse) {
    for (const hook of hooks.onBeforeResponse) {
      await hook(event, response);
    }
  }
  return response.body;
}
const eventHandler = defineEventHandler;
function isEventHandler(input) {
  return hasProp(input, "__is_handler__");
}
function toEventHandler(input, _, _route) {
  if (!isEventHandler(input)) {
    console.warn(
      "[h3] Implicit event handler conversion is deprecated. Use `eventHandler()` or `fromNodeMiddleware()` to define event handlers.",
      _route && _route !== "/" ? `
     Route: ${_route}` : "",
      `
     Handler: ${input}`
    );
  }
  return input;
}
function defineLazyEventHandler(factory) {
  let _promise;
  let _resolved;
  const resolveHandler = () => {
    if (_resolved) {
      return Promise.resolve(_resolved);
    }
    if (!_promise) {
      _promise = Promise.resolve(factory()).then((r) => {
        const handler2 = r.default || r;
        if (typeof handler2 !== "function") {
          throw new TypeError(
            "Invalid lazy handler result. It should be a function:",
            handler2
          );
        }
        _resolved = { handler: toEventHandler(r.default || r) };
        return _resolved;
      });
    }
    return _promise;
  };
  const handler = eventHandler((event) => {
    if (_resolved) {
      return _resolved.handler(event);
    }
    return resolveHandler().then((r) => r.handler(event));
  });
  handler.__resolve__ = resolveHandler;
  return handler;
}
const lazyEventHandler = defineLazyEventHandler;

function createApp(options = {}) {
  const stack = [];
  const handler = createAppEventHandler(stack, options);
  const resolve = createResolver(stack);
  handler.__resolve__ = resolve;
  const getWebsocket = cachedFn(() => websocketOptions(resolve, options));
  const app = {
    // @ts-expect-error
    use: (arg1, arg2, arg3) => use(app, arg1, arg2, arg3),
    resolve,
    handler,
    stack,
    options,
    get websocket() {
      return getWebsocket();
    }
  };
  return app;
}
function use(app, arg1, arg2, arg3) {
  if (Array.isArray(arg1)) {
    for (const i of arg1) {
      use(app, i, arg2, arg3);
    }
  } else if (Array.isArray(arg2)) {
    for (const i of arg2) {
      use(app, arg1, i, arg3);
    }
  } else if (typeof arg1 === "string") {
    app.stack.push(
      normalizeLayer({ ...arg3, route: arg1, handler: arg2 })
    );
  } else if (typeof arg1 === "function") {
    app.stack.push(normalizeLayer({ ...arg2, handler: arg1 }));
  } else {
    app.stack.push(normalizeLayer({ ...arg1 }));
  }
  return app;
}
function createAppEventHandler(stack, options) {
  const spacing = options.debug ? 2 : void 0;
  return eventHandler(async (event) => {
    event.node.req.originalUrl = event.node.req.originalUrl || event.node.req.url || "/";
    const _reqPath = event._path || event.node.req.url || "/";
    let _layerPath;
    if (options.onRequest) {
      await options.onRequest(event);
    }
    for (const layer of stack) {
      if (layer.route.length > 1) {
        if (!_reqPath.startsWith(layer.route)) {
          continue;
        }
        _layerPath = _reqPath.slice(layer.route.length) || "/";
      } else {
        _layerPath = _reqPath;
      }
      if (layer.match && !layer.match(_layerPath, event)) {
        continue;
      }
      event._path = _layerPath;
      event.node.req.url = _layerPath;
      const val = await layer.handler(event);
      const _body = val === void 0 ? void 0 : await val;
      if (_body !== void 0) {
        const _response = { body: _body };
        if (options.onBeforeResponse) {
          event._onBeforeResponseCalled = true;
          await options.onBeforeResponse(event, _response);
        }
        await handleHandlerResponse(event, _response.body, spacing);
        if (options.onAfterResponse) {
          event._onAfterResponseCalled = true;
          await options.onAfterResponse(event, _response);
        }
        return;
      }
      if (event.handled) {
        if (options.onAfterResponse) {
          event._onAfterResponseCalled = true;
          await options.onAfterResponse(event, void 0);
        }
        return;
      }
    }
    if (!event.handled) {
      throw createError$1({
        statusCode: 404,
        statusMessage: `Cannot find any path matching ${event.path || "/"}.`
      });
    }
    if (options.onAfterResponse) {
      event._onAfterResponseCalled = true;
      await options.onAfterResponse(event, void 0);
    }
  });
}
function createResolver(stack) {
  return async (path) => {
    let _layerPath;
    for (const layer of stack) {
      if (layer.route === "/" && !layer.handler.__resolve__) {
        continue;
      }
      if (!path.startsWith(layer.route)) {
        continue;
      }
      _layerPath = path.slice(layer.route.length) || "/";
      if (layer.match && !layer.match(_layerPath, void 0)) {
        continue;
      }
      let res = { route: layer.route, handler: layer.handler };
      if (res.handler.__resolve__) {
        const _res = await res.handler.__resolve__(_layerPath);
        if (!_res) {
          continue;
        }
        res = {
          ...res,
          ..._res,
          route: joinURL(res.route || "/", _res.route || "/")
        };
      }
      return res;
    }
  };
}
function normalizeLayer(input) {
  let handler = input.handler;
  if (handler.handler) {
    handler = handler.handler;
  }
  if (input.lazy) {
    handler = lazyEventHandler(handler);
  } else if (!isEventHandler(handler)) {
    handler = toEventHandler(handler, void 0, input.route);
  }
  return {
    route: withoutTrailingSlash(input.route),
    match: input.match,
    handler
  };
}
function handleHandlerResponse(event, val, jsonSpace) {
  if (val === null) {
    return sendNoContent(event);
  }
  if (val) {
    if (isWebResponse(val)) {
      return sendWebResponse(event, val);
    }
    if (isStream(val)) {
      return sendStream(event, val);
    }
    if (val.buffer) {
      return send(event, val);
    }
    if (val.arrayBuffer && typeof val.arrayBuffer === "function") {
      return val.arrayBuffer().then((arrayBuffer) => {
        return send(event, Buffer.from(arrayBuffer), val.type);
      });
    }
    if (val instanceof Error) {
      throw createError$1(val);
    }
    if (typeof val.end === "function") {
      return true;
    }
  }
  const valType = typeof val;
  if (valType === "string") {
    return send(event, val, MIMES.html);
  }
  if (valType === "object" || valType === "boolean" || valType === "number") {
    return send(event, JSON.stringify(val, void 0, jsonSpace), MIMES.json);
  }
  if (valType === "bigint") {
    return send(event, val.toString(), MIMES.json);
  }
  throw createError$1({
    statusCode: 500,
    statusMessage: `[h3] Cannot send ${valType} as response.`
  });
}
function cachedFn(fn) {
  let cache;
  return () => {
    if (!cache) {
      cache = fn();
    }
    return cache;
  };
}
function websocketOptions(evResolver, appOptions) {
  return {
    ...appOptions.websocket,
    async resolve(info) {
      const url = info.request?.url || info.url || "/";
      const { pathname } = typeof url === "string" ? parseURL(url) : url;
      const resolved = await evResolver(pathname);
      return resolved?.handler?.__websocket__ || {};
    }
  };
}

const RouterMethods = [
  "connect",
  "delete",
  "get",
  "head",
  "options",
  "post",
  "put",
  "trace",
  "patch"
];
function createRouter(opts = {}) {
  const _router = createRouter$1({});
  const routes = {};
  let _matcher;
  const router = {};
  const addRoute = (path, handler, method) => {
    let route = routes[path];
    if (!route) {
      routes[path] = route = { path, handlers: {} };
      _router.insert(path, route);
    }
    if (Array.isArray(method)) {
      for (const m of method) {
        addRoute(path, handler, m);
      }
    } else {
      route.handlers[method] = toEventHandler(handler, void 0, path);
    }
    return router;
  };
  router.use = router.add = (path, handler, method) => addRoute(path, handler, method || "all");
  for (const method of RouterMethods) {
    router[method] = (path, handle) => router.add(path, handle, method);
  }
  const matchHandler = (path = "/", method = "get") => {
    const qIndex = path.indexOf("?");
    if (qIndex !== -1) {
      path = path.slice(0, Math.max(0, qIndex));
    }
    const matched = _router.lookup(path);
    if (!matched || !matched.handlers) {
      return {
        error: createError$1({
          statusCode: 404,
          name: "Not Found",
          statusMessage: `Cannot find any route matching ${path || "/"}.`
        })
      };
    }
    let handler = matched.handlers[method] || matched.handlers.all;
    if (!handler) {
      if (!_matcher) {
        _matcher = toRouteMatcher(_router);
      }
      const _matches = _matcher.matchAll(path).reverse();
      for (const _match of _matches) {
        if (_match.handlers[method]) {
          handler = _match.handlers[method];
          matched.handlers[method] = matched.handlers[method] || handler;
          break;
        }
        if (_match.handlers.all) {
          handler = _match.handlers.all;
          matched.handlers.all = matched.handlers.all || handler;
          break;
        }
      }
    }
    if (!handler) {
      return {
        error: createError$1({
          statusCode: 405,
          name: "Method Not Allowed",
          statusMessage: `Method ${method} is not allowed on this route.`
        })
      };
    }
    return { matched, handler };
  };
  const isPreemptive = opts.preemptive || opts.preemtive;
  router.handler = eventHandler((event) => {
    const match = matchHandler(
      event.path,
      event.method.toLowerCase()
    );
    if ("error" in match) {
      if (isPreemptive) {
        throw match.error;
      } else {
        return;
      }
    }
    event.context.matchedRoute = match.matched;
    const params = match.matched.params || {};
    event.context.params = params;
    return Promise.resolve(match.handler(event)).then((res) => {
      if (res === void 0 && isPreemptive) {
        return null;
      }
      return res;
    });
  });
  router.handler.__resolve__ = async (path) => {
    path = withLeadingSlash(path);
    const match = matchHandler(path);
    if ("error" in match) {
      return;
    }
    let res = {
      route: match.matched.path,
      handler: match.handler
    };
    if (match.handler.__resolve__) {
      const _res = await match.handler.__resolve__(path);
      if (!_res) {
        return;
      }
      res = { ...res, ..._res };
    }
    return res;
  };
  return router;
}
function toNodeListener(app) {
  const toNodeHandle = async function(req, res) {
    const event = createEvent(req, res);
    try {
      await app.handler(event);
    } catch (_error) {
      const error = createError$1(_error);
      if (!isError(_error)) {
        error.unhandled = true;
      }
      setResponseStatus(event, error.statusCode, error.statusMessage);
      if (app.options.onError) {
        await app.options.onError(error, event);
      }
      if (event.handled) {
        return;
      }
      if (error.unhandled || error.fatal) {
        console.error("[h3]", error.fatal ? "[fatal]" : "[unhandled]", error);
      }
      if (app.options.onBeforeResponse && !event._onBeforeResponseCalled) {
        await app.options.onBeforeResponse(event, { body: error });
      }
      await sendError(event, error, !!app.options.debug);
      if (app.options.onAfterResponse && !event._onAfterResponseCalled) {
        await app.options.onAfterResponse(event, { body: error });
      }
    }
  };
  return toNodeHandle;
}

function flatHooks(configHooks, hooks = {}, parentName) {
  for (const key in configHooks) {
    const subHook = configHooks[key];
    const name = parentName ? `${parentName}:${key}` : key;
    if (typeof subHook === "object" && subHook !== null) {
      flatHooks(subHook, hooks, name);
    } else if (typeof subHook === "function") {
      hooks[name] = subHook;
    }
  }
  return hooks;
}
const defaultTask = { run: (function_) => function_() };
const _createTask = () => defaultTask;
const createTask = typeof console.createTask !== "undefined" ? console.createTask : _createTask;
function serialTaskCaller(hooks, args) {
  const name = args.shift();
  const task = createTask(name);
  return hooks.reduce(
    (promise, hookFunction) => promise.then(() => task.run(() => hookFunction(...args))),
    Promise.resolve()
  );
}
function parallelTaskCaller(hooks, args) {
  const name = args.shift();
  const task = createTask(name);
  return Promise.all(hooks.map((hook) => task.run(() => hook(...args))));
}
function callEachWith(callbacks, arg0) {
  for (const callback of [...callbacks]) {
    callback(arg0);
  }
}

class Hookable {
  constructor() {
    this._hooks = {};
    this._before = void 0;
    this._after = void 0;
    this._deprecatedMessages = void 0;
    this._deprecatedHooks = {};
    this.hook = this.hook.bind(this);
    this.callHook = this.callHook.bind(this);
    this.callHookWith = this.callHookWith.bind(this);
  }
  hook(name, function_, options = {}) {
    if (!name || typeof function_ !== "function") {
      return () => {
      };
    }
    const originalName = name;
    let dep;
    while (this._deprecatedHooks[name]) {
      dep = this._deprecatedHooks[name];
      name = dep.to;
    }
    if (dep && !options.allowDeprecated) {
      let message = dep.message;
      if (!message) {
        message = `${originalName} hook has been deprecated` + (dep.to ? `, please use ${dep.to}` : "");
      }
      if (!this._deprecatedMessages) {
        this._deprecatedMessages = /* @__PURE__ */ new Set();
      }
      if (!this._deprecatedMessages.has(message)) {
        console.warn(message);
        this._deprecatedMessages.add(message);
      }
    }
    if (!function_.name) {
      try {
        Object.defineProperty(function_, "name", {
          get: () => "_" + name.replace(/\W+/g, "_") + "_hook_cb",
          configurable: true
        });
      } catch {
      }
    }
    this._hooks[name] = this._hooks[name] || [];
    this._hooks[name].push(function_);
    return () => {
      if (function_) {
        this.removeHook(name, function_);
        function_ = void 0;
      }
    };
  }
  hookOnce(name, function_) {
    let _unreg;
    let _function = (...arguments_) => {
      if (typeof _unreg === "function") {
        _unreg();
      }
      _unreg = void 0;
      _function = void 0;
      return function_(...arguments_);
    };
    _unreg = this.hook(name, _function);
    return _unreg;
  }
  removeHook(name, function_) {
    if (this._hooks[name]) {
      const index = this._hooks[name].indexOf(function_);
      if (index !== -1) {
        this._hooks[name].splice(index, 1);
      }
      if (this._hooks[name].length === 0) {
        delete this._hooks[name];
      }
    }
  }
  deprecateHook(name, deprecated) {
    this._deprecatedHooks[name] = typeof deprecated === "string" ? { to: deprecated } : deprecated;
    const _hooks = this._hooks[name] || [];
    delete this._hooks[name];
    for (const hook of _hooks) {
      this.hook(name, hook);
    }
  }
  deprecateHooks(deprecatedHooks) {
    Object.assign(this._deprecatedHooks, deprecatedHooks);
    for (const name in deprecatedHooks) {
      this.deprecateHook(name, deprecatedHooks[name]);
    }
  }
  addHooks(configHooks) {
    const hooks = flatHooks(configHooks);
    const removeFns = Object.keys(hooks).map(
      (key) => this.hook(key, hooks[key])
    );
    return () => {
      for (const unreg of removeFns.splice(0, removeFns.length)) {
        unreg();
      }
    };
  }
  removeHooks(configHooks) {
    const hooks = flatHooks(configHooks);
    for (const key in hooks) {
      this.removeHook(key, hooks[key]);
    }
  }
  removeAllHooks() {
    for (const key in this._hooks) {
      delete this._hooks[key];
    }
  }
  callHook(name, ...arguments_) {
    arguments_.unshift(name);
    return this.callHookWith(serialTaskCaller, name, ...arguments_);
  }
  callHookParallel(name, ...arguments_) {
    arguments_.unshift(name);
    return this.callHookWith(parallelTaskCaller, name, ...arguments_);
  }
  callHookWith(caller, name, ...arguments_) {
    const event = this._before || this._after ? { name, args: arguments_, context: {} } : void 0;
    if (this._before) {
      callEachWith(this._before, event);
    }
    const result = caller(
      name in this._hooks ? [...this._hooks[name]] : [],
      arguments_
    );
    if (result instanceof Promise) {
      return result.finally(() => {
        if (this._after && event) {
          callEachWith(this._after, event);
        }
      });
    }
    if (this._after && event) {
      callEachWith(this._after, event);
    }
    return result;
  }
  beforeEach(function_) {
    this._before = this._before || [];
    this._before.push(function_);
    return () => {
      if (this._before !== void 0) {
        const index = this._before.indexOf(function_);
        if (index !== -1) {
          this._before.splice(index, 1);
        }
      }
    };
  }
  afterEach(function_) {
    this._after = this._after || [];
    this._after.push(function_);
    return () => {
      if (this._after !== void 0) {
        const index = this._after.indexOf(function_);
        if (index !== -1) {
          this._after.splice(index, 1);
        }
      }
    };
  }
}
function createHooks() {
  return new Hookable();
}

const s$1=globalThis.Headers,i$1=globalThis.AbortController,l$1=globalThis.fetch||(()=>{throw new Error("[node-fetch-native] Failed to fetch: `globalThis.fetch` is not available!")});

class FetchError extends Error {
  constructor(message, opts) {
    super(message, opts);
    this.name = "FetchError";
    if (opts?.cause && !this.cause) {
      this.cause = opts.cause;
    }
  }
}
function createFetchError(ctx) {
  const errorMessage = ctx.error?.message || ctx.error?.toString() || "";
  const method = ctx.request?.method || ctx.options?.method || "GET";
  const url = ctx.request?.url || String(ctx.request) || "/";
  const requestStr = `[${method}] ${JSON.stringify(url)}`;
  const statusStr = ctx.response ? `${ctx.response.status} ${ctx.response.statusText}` : "<no response>";
  const message = `${requestStr}: ${statusStr}${errorMessage ? ` ${errorMessage}` : ""}`;
  const fetchError = new FetchError(
    message,
    ctx.error ? { cause: ctx.error } : void 0
  );
  for (const key of ["request", "options", "response"]) {
    Object.defineProperty(fetchError, key, {
      get() {
        return ctx[key];
      }
    });
  }
  for (const [key, refKey] of [
    ["data", "_data"],
    ["status", "status"],
    ["statusCode", "status"],
    ["statusText", "statusText"],
    ["statusMessage", "statusText"]
  ]) {
    Object.defineProperty(fetchError, key, {
      get() {
        return ctx.response && ctx.response[refKey];
      }
    });
  }
  return fetchError;
}

const payloadMethods = new Set(
  Object.freeze(["PATCH", "POST", "PUT", "DELETE"])
);
function isPayloadMethod(method = "GET") {
  return payloadMethods.has(method.toUpperCase());
}
function isJSONSerializable(value) {
  if (value === void 0) {
    return false;
  }
  const t = typeof value;
  if (t === "string" || t === "number" || t === "boolean" || t === null) {
    return true;
  }
  if (t !== "object") {
    return false;
  }
  if (Array.isArray(value)) {
    return true;
  }
  if (value.buffer) {
    return false;
  }
  return value.constructor && value.constructor.name === "Object" || typeof value.toJSON === "function";
}
const textTypes = /* @__PURE__ */ new Set([
  "image/svg",
  "application/xml",
  "application/xhtml",
  "application/html"
]);
const JSON_RE = /^application\/(?:[\w!#$%&*.^`~-]*\+)?json(;.+)?$/i;
function detectResponseType(_contentType = "") {
  if (!_contentType) {
    return "json";
  }
  const contentType = _contentType.split(";").shift() || "";
  if (JSON_RE.test(contentType)) {
    return "json";
  }
  if (textTypes.has(contentType) || contentType.startsWith("text/")) {
    return "text";
  }
  return "blob";
}
function resolveFetchOptions(request, input, defaults, Headers) {
  const headers = mergeHeaders(
    input?.headers ?? request?.headers,
    defaults?.headers,
    Headers
  );
  let query;
  if (defaults?.query || defaults?.params || input?.params || input?.query) {
    query = {
      ...defaults?.params,
      ...defaults?.query,
      ...input?.params,
      ...input?.query
    };
  }
  return {
    ...defaults,
    ...input,
    query,
    params: query,
    headers
  };
}
function mergeHeaders(input, defaults, Headers) {
  if (!defaults) {
    return new Headers(input);
  }
  const headers = new Headers(defaults);
  if (input) {
    for (const [key, value] of Symbol.iterator in input || Array.isArray(input) ? input : new Headers(input)) {
      headers.set(key, value);
    }
  }
  return headers;
}
async function callHooks(context, hooks) {
  if (hooks) {
    if (Array.isArray(hooks)) {
      for (const hook of hooks) {
        await hook(context);
      }
    } else {
      await hooks(context);
    }
  }
}

const retryStatusCodes = /* @__PURE__ */ new Set([
  408,
  // Request Timeout
  409,
  // Conflict
  425,
  // Too Early (Experimental)
  429,
  // Too Many Requests
  500,
  // Internal Server Error
  502,
  // Bad Gateway
  503,
  // Service Unavailable
  504
  // Gateway Timeout
]);
const nullBodyResponses = /* @__PURE__ */ new Set([101, 204, 205, 304]);
function createFetch(globalOptions = {}) {
  const {
    fetch = globalThis.fetch,
    Headers = globalThis.Headers,
    AbortController = globalThis.AbortController
  } = globalOptions;
  async function onError(context) {
    const isAbort = context.error && context.error.name === "AbortError" && !context.options.timeout || false;
    if (context.options.retry !== false && !isAbort) {
      let retries;
      if (typeof context.options.retry === "number") {
        retries = context.options.retry;
      } else {
        retries = isPayloadMethod(context.options.method) ? 0 : 1;
      }
      const responseCode = context.response && context.response.status || 500;
      if (retries > 0 && (Array.isArray(context.options.retryStatusCodes) ? context.options.retryStatusCodes.includes(responseCode) : retryStatusCodes.has(responseCode))) {
        const retryDelay = typeof context.options.retryDelay === "function" ? context.options.retryDelay(context) : context.options.retryDelay || 0;
        if (retryDelay > 0) {
          await new Promise((resolve) => setTimeout(resolve, retryDelay));
        }
        return $fetchRaw(context.request, {
          ...context.options,
          retry: retries - 1
        });
      }
    }
    const error = createFetchError(context);
    if (Error.captureStackTrace) {
      Error.captureStackTrace(error, $fetchRaw);
    }
    throw error;
  }
  const $fetchRaw = async function $fetchRaw2(_request, _options = {}) {
    const context = {
      request: _request,
      options: resolveFetchOptions(
        _request,
        _options,
        globalOptions.defaults,
        Headers
      ),
      response: void 0,
      error: void 0
    };
    if (context.options.method) {
      context.options.method = context.options.method.toUpperCase();
    }
    if (context.options.onRequest) {
      await callHooks(context, context.options.onRequest);
    }
    if (typeof context.request === "string") {
      if (context.options.baseURL) {
        context.request = withBase(context.request, context.options.baseURL);
      }
      if (context.options.query) {
        context.request = withQuery(context.request, context.options.query);
        delete context.options.query;
      }
      if ("query" in context.options) {
        delete context.options.query;
      }
      if ("params" in context.options) {
        delete context.options.params;
      }
    }
    if (context.options.body && isPayloadMethod(context.options.method)) {
      if (isJSONSerializable(context.options.body)) {
        context.options.body = typeof context.options.body === "string" ? context.options.body : JSON.stringify(context.options.body);
        context.options.headers = new Headers(context.options.headers || {});
        if (!context.options.headers.has("content-type")) {
          context.options.headers.set("content-type", "application/json");
        }
        if (!context.options.headers.has("accept")) {
          context.options.headers.set("accept", "application/json");
        }
      } else if (
        // ReadableStream Body
        "pipeTo" in context.options.body && typeof context.options.body.pipeTo === "function" || // Node.js Stream Body
        typeof context.options.body.pipe === "function"
      ) {
        if (!("duplex" in context.options)) {
          context.options.duplex = "half";
        }
      }
    }
    let abortTimeout;
    if (!context.options.signal && context.options.timeout) {
      const controller = new AbortController();
      abortTimeout = setTimeout(() => {
        const error = new Error(
          "[TimeoutError]: The operation was aborted due to timeout"
        );
        error.name = "TimeoutError";
        error.code = 23;
        controller.abort(error);
      }, context.options.timeout);
      context.options.signal = controller.signal;
    }
    try {
      context.response = await fetch(
        context.request,
        context.options
      );
    } catch (error) {
      context.error = error;
      if (context.options.onRequestError) {
        await callHooks(
          context,
          context.options.onRequestError
        );
      }
      return await onError(context);
    } finally {
      if (abortTimeout) {
        clearTimeout(abortTimeout);
      }
    }
    const hasBody = (context.response.body || // https://github.com/unjs/ofetch/issues/324
    // https://github.com/unjs/ofetch/issues/294
    // https://github.com/JakeChampion/fetch/issues/1454
    context.response._bodyInit) && !nullBodyResponses.has(context.response.status) && context.options.method !== "HEAD";
    if (hasBody) {
      const responseType = (context.options.parseResponse ? "json" : context.options.responseType) || detectResponseType(context.response.headers.get("content-type") || "");
      switch (responseType) {
        case "json": {
          const data = await context.response.text();
          const parseFunction = context.options.parseResponse || destr;
          context.response._data = parseFunction(data);
          break;
        }
        case "stream": {
          context.response._data = context.response.body || context.response._bodyInit;
          break;
        }
        default: {
          context.response._data = await context.response[responseType]();
        }
      }
    }
    if (context.options.onResponse) {
      await callHooks(
        context,
        context.options.onResponse
      );
    }
    if (!context.options.ignoreResponseError && context.response.status >= 400 && context.response.status < 600) {
      if (context.options.onResponseError) {
        await callHooks(
          context,
          context.options.onResponseError
        );
      }
      return await onError(context);
    }
    return context.response;
  };
  const $fetch = async function $fetch2(request, options) {
    const r = await $fetchRaw(request, options);
    return r._data;
  };
  $fetch.raw = $fetchRaw;
  $fetch.native = (...args) => fetch(...args);
  $fetch.create = (defaultOptions = {}, customGlobalOptions = {}) => createFetch({
    ...globalOptions,
    ...customGlobalOptions,
    defaults: {
      ...globalOptions.defaults,
      ...customGlobalOptions.defaults,
      ...defaultOptions
    }
  });
  return $fetch;
}

function createNodeFetch() {
  const useKeepAlive = JSON.parse(process.env.FETCH_KEEP_ALIVE || "false");
  if (!useKeepAlive) {
    return l$1;
  }
  const agentOptions = { keepAlive: true };
  const httpAgent = new http.Agent(agentOptions);
  const httpsAgent = new https.Agent(agentOptions);
  const nodeFetchOptions = {
    agent(parsedURL) {
      return parsedURL.protocol === "http:" ? httpAgent : httpsAgent;
    }
  };
  return function nodeFetchWithKeepAlive(input, init) {
    return l$1(input, { ...nodeFetchOptions, ...init });
  };
}
const fetch = globalThis.fetch ? (...args) => globalThis.fetch(...args) : createNodeFetch();
const Headers$1 = globalThis.Headers || s$1;
const AbortController = globalThis.AbortController || i$1;
createFetch({ fetch, Headers: Headers$1, AbortController });

function wrapToPromise(value) {
  if (!value || typeof value.then !== "function") {
    return Promise.resolve(value);
  }
  return value;
}
function asyncCall(function_, ...arguments_) {
  try {
    return wrapToPromise(function_(...arguments_));
  } catch (error) {
    return Promise.reject(error);
  }
}
function isPrimitive(value) {
  const type = typeof value;
  return value === null || type !== "object" && type !== "function";
}
function isPureObject(value) {
  const proto = Object.getPrototypeOf(value);
  return !proto || proto.isPrototypeOf(Object);
}
function stringify(value) {
  if (isPrimitive(value)) {
    return String(value);
  }
  if (isPureObject(value) || Array.isArray(value)) {
    return JSON.stringify(value);
  }
  if (typeof value.toJSON === "function") {
    return stringify(value.toJSON());
  }
  throw new Error("[unstorage] Cannot stringify value!");
}
const BASE64_PREFIX = "base64:";
function serializeRaw(value) {
  if (typeof value === "string") {
    return value;
  }
  return BASE64_PREFIX + base64Encode(value);
}
function deserializeRaw(value) {
  if (typeof value !== "string") {
    return value;
  }
  if (!value.startsWith(BASE64_PREFIX)) {
    return value;
  }
  return base64Decode(value.slice(BASE64_PREFIX.length));
}
function base64Decode(input) {
  if (globalThis.Buffer) {
    return Buffer.from(input, "base64");
  }
  return Uint8Array.from(
    globalThis.atob(input),
    (c) => c.codePointAt(0)
  );
}
function base64Encode(input) {
  if (globalThis.Buffer) {
    return Buffer.from(input).toString("base64");
  }
  return globalThis.btoa(String.fromCodePoint(...input));
}

const storageKeyProperties = [
  "has",
  "hasItem",
  "get",
  "getItem",
  "getItemRaw",
  "set",
  "setItem",
  "setItemRaw",
  "del",
  "remove",
  "removeItem",
  "getMeta",
  "setMeta",
  "removeMeta",
  "getKeys",
  "clear",
  "mount",
  "unmount"
];
function prefixStorage(storage, base) {
  base = normalizeBaseKey(base);
  if (!base) {
    return storage;
  }
  const nsStorage = { ...storage };
  for (const property of storageKeyProperties) {
    nsStorage[property] = (key = "", ...args) => (
      // @ts-ignore
      storage[property](base + key, ...args)
    );
  }
  nsStorage.getKeys = (key = "", ...arguments_) => storage.getKeys(base + key, ...arguments_).then((keys) => keys.map((key2) => key2.slice(base.length)));
  nsStorage.getItems = async (items, commonOptions) => {
    const prefixedItems = items.map(
      (item) => typeof item === "string" ? base + item : { ...item, key: base + item.key }
    );
    const results = await storage.getItems(prefixedItems, commonOptions);
    return results.map((entry) => ({
      key: entry.key.slice(base.length),
      value: entry.value
    }));
  };
  nsStorage.setItems = async (items, commonOptions) => {
    const prefixedItems = items.map((item) => ({
      key: base + item.key,
      value: item.value,
      options: item.options
    }));
    return storage.setItems(prefixedItems, commonOptions);
  };
  return nsStorage;
}
function normalizeKey$1(key) {
  if (!key) {
    return "";
  }
  return key.split("?")[0]?.replace(/[/\\]/g, ":").replace(/:+/g, ":").replace(/^:|:$/g, "") || "";
}
function joinKeys(...keys) {
  return normalizeKey$1(keys.join(":"));
}
function normalizeBaseKey(base) {
  base = normalizeKey$1(base);
  return base ? base + ":" : "";
}
function filterKeyByDepth(key, depth) {
  if (depth === void 0) {
    return true;
  }
  let substrCount = 0;
  let index = key.indexOf(":");
  while (index > -1) {
    substrCount++;
    index = key.indexOf(":", index + 1);
  }
  return substrCount <= depth;
}
function filterKeyByBase(key, base) {
  if (base) {
    return key.startsWith(base) && key[key.length - 1] !== "$";
  }
  return key[key.length - 1] !== "$";
}

function defineDriver$1(factory) {
  return factory;
}

const DRIVER_NAME$1 = "memory";
const memory = defineDriver$1(() => {
  const data = /* @__PURE__ */ new Map();
  return {
    name: DRIVER_NAME$1,
    getInstance: () => data,
    hasItem(key) {
      return data.has(key);
    },
    getItem(key) {
      return data.get(key) ?? null;
    },
    getItemRaw(key) {
      return data.get(key) ?? null;
    },
    setItem(key, value) {
      data.set(key, value);
    },
    setItemRaw(key, value) {
      data.set(key, value);
    },
    removeItem(key) {
      data.delete(key);
    },
    getKeys() {
      return [...data.keys()];
    },
    clear() {
      data.clear();
    },
    dispose() {
      data.clear();
    }
  };
});

function createStorage(options = {}) {
  const context = {
    mounts: { "": options.driver || memory() },
    mountpoints: [""],
    watching: false,
    watchListeners: [],
    unwatch: {}
  };
  const getMount = (key) => {
    for (const base of context.mountpoints) {
      if (key.startsWith(base)) {
        return {
          base,
          relativeKey: key.slice(base.length),
          driver: context.mounts[base]
        };
      }
    }
    return {
      base: "",
      relativeKey: key,
      driver: context.mounts[""]
    };
  };
  const getMounts = (base, includeParent) => {
    return context.mountpoints.filter(
      (mountpoint) => mountpoint.startsWith(base) || includeParent && base.startsWith(mountpoint)
    ).map((mountpoint) => ({
      relativeBase: base.length > mountpoint.length ? base.slice(mountpoint.length) : void 0,
      mountpoint,
      driver: context.mounts[mountpoint]
    }));
  };
  const onChange = (event, key) => {
    if (!context.watching) {
      return;
    }
    key = normalizeKey$1(key);
    for (const listener of context.watchListeners) {
      listener(event, key);
    }
  };
  const startWatch = async () => {
    if (context.watching) {
      return;
    }
    context.watching = true;
    for (const mountpoint in context.mounts) {
      context.unwatch[mountpoint] = await watch(
        context.mounts[mountpoint],
        onChange,
        mountpoint
      );
    }
  };
  const stopWatch = async () => {
    if (!context.watching) {
      return;
    }
    for (const mountpoint in context.unwatch) {
      await context.unwatch[mountpoint]();
    }
    context.unwatch = {};
    context.watching = false;
  };
  const runBatch = (items, commonOptions, cb) => {
    const batches = /* @__PURE__ */ new Map();
    const getBatch = (mount) => {
      let batch = batches.get(mount.base);
      if (!batch) {
        batch = {
          driver: mount.driver,
          base: mount.base,
          items: []
        };
        batches.set(mount.base, batch);
      }
      return batch;
    };
    for (const item of items) {
      const isStringItem = typeof item === "string";
      const key = normalizeKey$1(isStringItem ? item : item.key);
      const value = isStringItem ? void 0 : item.value;
      const options2 = isStringItem || !item.options ? commonOptions : { ...commonOptions, ...item.options };
      const mount = getMount(key);
      getBatch(mount).items.push({
        key,
        value,
        relativeKey: mount.relativeKey,
        options: options2
      });
    }
    return Promise.all([...batches.values()].map((batch) => cb(batch))).then(
      (r) => r.flat()
    );
  };
  const storage = {
    // Item
    hasItem(key, opts = {}) {
      key = normalizeKey$1(key);
      const { relativeKey, driver } = getMount(key);
      return asyncCall(driver.hasItem, relativeKey, opts);
    },
    getItem(key, opts = {}) {
      key = normalizeKey$1(key);
      const { relativeKey, driver } = getMount(key);
      return asyncCall(driver.getItem, relativeKey, opts).then(
        (value) => destr(value)
      );
    },
    getItems(items, commonOptions = {}) {
      return runBatch(items, commonOptions, (batch) => {
        if (batch.driver.getItems) {
          return asyncCall(
            batch.driver.getItems,
            batch.items.map((item) => ({
              key: item.relativeKey,
              options: item.options
            })),
            commonOptions
          ).then(
            (r) => r.map((item) => ({
              key: joinKeys(batch.base, item.key),
              value: destr(item.value)
            }))
          );
        }
        return Promise.all(
          batch.items.map((item) => {
            return asyncCall(
              batch.driver.getItem,
              item.relativeKey,
              item.options
            ).then((value) => ({
              key: item.key,
              value: destr(value)
            }));
          })
        );
      });
    },
    getItemRaw(key, opts = {}) {
      key = normalizeKey$1(key);
      const { relativeKey, driver } = getMount(key);
      if (driver.getItemRaw) {
        return asyncCall(driver.getItemRaw, relativeKey, opts);
      }
      return asyncCall(driver.getItem, relativeKey, opts).then(
        (value) => deserializeRaw(value)
      );
    },
    async setItem(key, value, opts = {}) {
      if (value === void 0) {
        return storage.removeItem(key);
      }
      key = normalizeKey$1(key);
      const { relativeKey, driver } = getMount(key);
      if (!driver.setItem) {
        return;
      }
      await asyncCall(driver.setItem, relativeKey, stringify(value), opts);
      if (!driver.watch) {
        onChange("update", key);
      }
    },
    async setItems(items, commonOptions) {
      await runBatch(items, commonOptions, async (batch) => {
        if (batch.driver.setItems) {
          return asyncCall(
            batch.driver.setItems,
            batch.items.map((item) => ({
              key: item.relativeKey,
              value: stringify(item.value),
              options: item.options
            })),
            commonOptions
          );
        }
        if (!batch.driver.setItem) {
          return;
        }
        await Promise.all(
          batch.items.map((item) => {
            return asyncCall(
              batch.driver.setItem,
              item.relativeKey,
              stringify(item.value),
              item.options
            );
          })
        );
      });
    },
    async setItemRaw(key, value, opts = {}) {
      if (value === void 0) {
        return storage.removeItem(key, opts);
      }
      key = normalizeKey$1(key);
      const { relativeKey, driver } = getMount(key);
      if (driver.setItemRaw) {
        await asyncCall(driver.setItemRaw, relativeKey, value, opts);
      } else if (driver.setItem) {
        await asyncCall(driver.setItem, relativeKey, serializeRaw(value), opts);
      } else {
        return;
      }
      if (!driver.watch) {
        onChange("update", key);
      }
    },
    async removeItem(key, opts = {}) {
      if (typeof opts === "boolean") {
        opts = { removeMeta: opts };
      }
      key = normalizeKey$1(key);
      const { relativeKey, driver } = getMount(key);
      if (!driver.removeItem) {
        return;
      }
      await asyncCall(driver.removeItem, relativeKey, opts);
      if (opts.removeMeta || opts.removeMata) {
        await asyncCall(driver.removeItem, relativeKey + "$", opts);
      }
      if (!driver.watch) {
        onChange("remove", key);
      }
    },
    // Meta
    async getMeta(key, opts = {}) {
      if (typeof opts === "boolean") {
        opts = { nativeOnly: opts };
      }
      key = normalizeKey$1(key);
      const { relativeKey, driver } = getMount(key);
      const meta = /* @__PURE__ */ Object.create(null);
      if (driver.getMeta) {
        Object.assign(meta, await asyncCall(driver.getMeta, relativeKey, opts));
      }
      if (!opts.nativeOnly) {
        const value = await asyncCall(
          driver.getItem,
          relativeKey + "$",
          opts
        ).then((value_) => destr(value_));
        if (value && typeof value === "object") {
          if (typeof value.atime === "string") {
            value.atime = new Date(value.atime);
          }
          if (typeof value.mtime === "string") {
            value.mtime = new Date(value.mtime);
          }
          Object.assign(meta, value);
        }
      }
      return meta;
    },
    setMeta(key, value, opts = {}) {
      return this.setItem(key + "$", value, opts);
    },
    removeMeta(key, opts = {}) {
      return this.removeItem(key + "$", opts);
    },
    // Keys
    async getKeys(base, opts = {}) {
      base = normalizeBaseKey(base);
      const mounts = getMounts(base, true);
      let maskedMounts = [];
      const allKeys = [];
      let allMountsSupportMaxDepth = true;
      for (const mount of mounts) {
        if (!mount.driver.flags?.maxDepth) {
          allMountsSupportMaxDepth = false;
        }
        const rawKeys = await asyncCall(
          mount.driver.getKeys,
          mount.relativeBase,
          opts
        );
        for (const key of rawKeys) {
          const fullKey = mount.mountpoint + normalizeKey$1(key);
          if (!maskedMounts.some((p) => fullKey.startsWith(p))) {
            allKeys.push(fullKey);
          }
        }
        maskedMounts = [
          mount.mountpoint,
          ...maskedMounts.filter((p) => !p.startsWith(mount.mountpoint))
        ];
      }
      const shouldFilterByDepth = opts.maxDepth !== void 0 && !allMountsSupportMaxDepth;
      return allKeys.filter(
        (key) => (!shouldFilterByDepth || filterKeyByDepth(key, opts.maxDepth)) && filterKeyByBase(key, base)
      );
    },
    // Utils
    async clear(base, opts = {}) {
      base = normalizeBaseKey(base);
      await Promise.all(
        getMounts(base, false).map(async (m) => {
          if (m.driver.clear) {
            return asyncCall(m.driver.clear, m.relativeBase, opts);
          }
          if (m.driver.removeItem) {
            const keys = await m.driver.getKeys(m.relativeBase || "", opts);
            return Promise.all(
              keys.map((key) => m.driver.removeItem(key, opts))
            );
          }
        })
      );
    },
    async dispose() {
      await Promise.all(
        Object.values(context.mounts).map((driver) => dispose(driver))
      );
    },
    async watch(callback) {
      await startWatch();
      context.watchListeners.push(callback);
      return async () => {
        context.watchListeners = context.watchListeners.filter(
          (listener) => listener !== callback
        );
        if (context.watchListeners.length === 0) {
          await stopWatch();
        }
      };
    },
    async unwatch() {
      context.watchListeners = [];
      await stopWatch();
    },
    // Mount
    mount(base, driver) {
      base = normalizeBaseKey(base);
      if (base && context.mounts[base]) {
        throw new Error(`already mounted at ${base}`);
      }
      if (base) {
        context.mountpoints.push(base);
        context.mountpoints.sort((a, b) => b.length - a.length);
      }
      context.mounts[base] = driver;
      if (context.watching) {
        Promise.resolve(watch(driver, onChange, base)).then((unwatcher) => {
          context.unwatch[base] = unwatcher;
        }).catch(console.error);
      }
      return storage;
    },
    async unmount(base, _dispose = true) {
      base = normalizeBaseKey(base);
      if (!base || !context.mounts[base]) {
        return;
      }
      if (context.watching && base in context.unwatch) {
        context.unwatch[base]?.();
        delete context.unwatch[base];
      }
      if (_dispose) {
        await dispose(context.mounts[base]);
      }
      context.mountpoints = context.mountpoints.filter((key) => key !== base);
      delete context.mounts[base];
    },
    getMount(key = "") {
      key = normalizeKey$1(key) + ":";
      const m = getMount(key);
      return {
        driver: m.driver,
        base: m.base
      };
    },
    getMounts(base = "", opts = {}) {
      base = normalizeKey$1(base);
      const mounts = getMounts(base, opts.parents);
      return mounts.map((m) => ({
        driver: m.driver,
        base: m.mountpoint
      }));
    },
    // Aliases
    keys: (base, opts = {}) => storage.getKeys(base, opts),
    get: (key, opts = {}) => storage.getItem(key, opts),
    set: (key, value, opts = {}) => storage.setItem(key, value, opts),
    has: (key, opts = {}) => storage.hasItem(key, opts),
    del: (key, opts = {}) => storage.removeItem(key, opts),
    remove: (key, opts = {}) => storage.removeItem(key, opts)
  };
  return storage;
}
function watch(driver, onChange, base) {
  return driver.watch ? driver.watch((event, key) => onChange(event, base + key)) : () => {
  };
}
async function dispose(driver) {
  if (typeof driver.dispose === "function") {
    await asyncCall(driver.dispose);
  }
}

const _assets = {

};

const normalizeKey = function normalizeKey(key) {
  if (!key) {
    return "";
  }
  return key.split("?")[0]?.replace(/[/\\]/g, ":").replace(/:+/g, ":").replace(/^:|:$/g, "") || "";
};

const assets$1 = {
  getKeys() {
    return Promise.resolve(Object.keys(_assets))
  },
  hasItem (id) {
    id = normalizeKey(id);
    return Promise.resolve(id in _assets)
  },
  getItem (id) {
    id = normalizeKey(id);
    return Promise.resolve(_assets[id] ? _assets[id].import() : null)
  },
  getMeta (id) {
    id = normalizeKey(id);
    return Promise.resolve(_assets[id] ? _assets[id].meta : {})
  }
};

function defineDriver(factory) {
  return factory;
}
function createError(driver, message, opts) {
  const err = new Error(`[unstorage] [${driver}] ${message}`, opts);
  if (Error.captureStackTrace) {
    Error.captureStackTrace(err, createError);
  }
  return err;
}
function createRequiredError(driver, name) {
  if (Array.isArray(name)) {
    return createError(
      driver,
      `Missing some of the required options ${name.map((n) => "`" + n + "`").join(", ")}`
    );
  }
  return createError(driver, `Missing required option \`${name}\`.`);
}

function ignoreNotfound(err) {
  return err.code === "ENOENT" || err.code === "EISDIR" ? null : err;
}
function ignoreExists(err) {
  return err.code === "EEXIST" ? null : err;
}
async function writeFile(path, data, encoding) {
  await ensuredir(dirname$1(path));
  return promises.writeFile(path, data, encoding);
}
function readFile(path, encoding) {
  return promises.readFile(path, encoding).catch(ignoreNotfound);
}
function unlink(path) {
  return promises.unlink(path).catch(ignoreNotfound);
}
function readdir(dir) {
  return promises.readdir(dir, { withFileTypes: true }).catch(ignoreNotfound).then((r) => r || []);
}
async function ensuredir(dir) {
  if (existsSync(dir)) {
    return;
  }
  await ensuredir(dirname$1(dir)).catch(ignoreExists);
  await promises.mkdir(dir).catch(ignoreExists);
}
async function readdirRecursive(dir, ignore, maxDepth) {
  if (ignore && ignore(dir)) {
    return [];
  }
  const entries = await readdir(dir);
  const files = [];
  await Promise.all(
    entries.map(async (entry) => {
      const entryPath = resolve$1(dir, entry.name);
      if (entry.isDirectory()) {
        if (maxDepth === void 0 || maxDepth > 0) {
          const dirFiles = await readdirRecursive(
            entryPath,
            ignore,
            maxDepth === void 0 ? void 0 : maxDepth - 1
          );
          files.push(...dirFiles.map((f) => entry.name + "/" + f));
        }
      } else {
        if (!(ignore && ignore(entry.name))) {
          files.push(entry.name);
        }
      }
    })
  );
  return files;
}
async function rmRecursive(dir) {
  const entries = await readdir(dir);
  await Promise.all(
    entries.map((entry) => {
      const entryPath = resolve$1(dir, entry.name);
      if (entry.isDirectory()) {
        return rmRecursive(entryPath).then(() => promises.rmdir(entryPath));
      } else {
        return promises.unlink(entryPath);
      }
    })
  );
}

const PATH_TRAVERSE_RE = /\.\.:|\.\.$/;
const DRIVER_NAME = "fs-lite";
const unstorage_47drivers_47fs_45lite = defineDriver((opts = {}) => {
  if (!opts.base) {
    throw createRequiredError(DRIVER_NAME, "base");
  }
  opts.base = resolve$1(opts.base);
  const r = (key) => {
    if (PATH_TRAVERSE_RE.test(key)) {
      throw createError(
        DRIVER_NAME,
        `Invalid key: ${JSON.stringify(key)}. It should not contain .. segments`
      );
    }
    const resolved = join(opts.base, key.replace(/:/g, "/"));
    return resolved;
  };
  return {
    name: DRIVER_NAME,
    options: opts,
    flags: {
      maxDepth: true
    },
    hasItem(key) {
      return existsSync(r(key));
    },
    getItem(key) {
      return readFile(r(key), "utf8");
    },
    getItemRaw(key) {
      return readFile(r(key));
    },
    async getMeta(key) {
      const { atime, mtime, size, birthtime, ctime } = await promises.stat(r(key)).catch(() => ({}));
      return { atime, mtime, size, birthtime, ctime };
    },
    setItem(key, value) {
      if (opts.readOnly) {
        return;
      }
      return writeFile(r(key), value, "utf8");
    },
    setItemRaw(key, value) {
      if (opts.readOnly) {
        return;
      }
      return writeFile(r(key), value);
    },
    removeItem(key) {
      if (opts.readOnly) {
        return;
      }
      return unlink(r(key));
    },
    getKeys(_base, topts) {
      return readdirRecursive(r("."), opts.ignore, topts?.maxDepth);
    },
    async clear() {
      if (opts.readOnly || opts.noClear) {
        return;
      }
      await rmRecursive(r("."));
    }
  };
});

const storage = createStorage({});

storage.mount('/assets', assets$1);

storage.mount('data', unstorage_47drivers_47fs_45lite({"driver":"fsLite","base":"./.data/kv"}));

function useStorage(base = "") {
  return base ? prefixStorage(storage, base) : storage;
}

function serialize$1(o){return typeof o=="string"?`'${o}'`:new c$1().serialize(o)}const c$1=/*@__PURE__*/function(){class o{#t=new Map;compare(t,r){const e=typeof t,n=typeof r;return e==="string"&&n==="string"?t.localeCompare(r):e==="number"&&n==="number"?t-r:String.prototype.localeCompare.call(this.serialize(t,true),this.serialize(r,true))}serialize(t,r){if(t===null)return "null";switch(typeof t){case "string":return r?t:`'${t}'`;case "bigint":return `${t}n`;case "object":return this.$object(t);case "function":return this.$function(t)}return String(t)}serializeObject(t){const r=Object.prototype.toString.call(t);if(r!=="[object Object]")return this.serializeBuiltInType(r.length<10?`unknown:${r}`:r.slice(8,-1),t);const e=t.constructor,n=e===Object||e===void 0?"":e.name;if(n!==""&&globalThis[n]===e)return this.serializeBuiltInType(n,t);if(typeof t.toJSON=="function"){const i=t.toJSON();return n+(i!==null&&typeof i=="object"?this.$object(i):`(${this.serialize(i)})`)}return this.serializeObjectEntries(n,Object.entries(t))}serializeBuiltInType(t,r){const e=this["$"+t];if(e)return e.call(this,r);if(typeof r?.entries=="function")return this.serializeObjectEntries(t,r.entries());throw new Error(`Cannot serialize ${t}`)}serializeObjectEntries(t,r){const e=Array.from(r).sort((i,a)=>this.compare(i[0],a[0]));let n=`${t}{`;for(let i=0;i<e.length;i++){const[a,l]=e[i];n+=`${this.serialize(a,true)}:${this.serialize(l)}`,i<e.length-1&&(n+=",");}return n+"}"}$object(t){let r=this.#t.get(t);return r===void 0&&(this.#t.set(t,`#${this.#t.size}`),r=this.serializeObject(t),this.#t.set(t,r)),r}$function(t){const r=Function.prototype.toString.call(t);return r.slice(-15)==="[native code] }"?`${t.name||""}()[native]`:`${t.name}(${t.length})${r.replace(/\s*\n\s*/g,"")}`}$Array(t){let r="[";for(let e=0;e<t.length;e++)r+=this.serialize(t[e]),e<t.length-1&&(r+=",");return r+"]"}$Date(t){try{return `Date(${t.toISOString()})`}catch{return "Date(null)"}}$ArrayBuffer(t){return `ArrayBuffer[${new Uint8Array(t).join(",")}]`}$Set(t){return `Set${this.$Array(Array.from(t).sort((r,e)=>this.compare(r,e)))}`}$Map(t){return this.serializeObjectEntries("Map",t.entries())}}for(const s of ["Error","RegExp","URL"])o.prototype["$"+s]=function(t){return `${s}(${t})`};for(const s of ["Int8Array","Uint8Array","Uint8ClampedArray","Int16Array","Uint16Array","Int32Array","Uint32Array","Float32Array","Float64Array"])o.prototype["$"+s]=function(t){return `${s}[${t.join(",")}]`};for(const s of ["BigInt64Array","BigUint64Array"])o.prototype["$"+s]=function(t){return `${s}[${t.join("n,")}${t.length>0?"n":""}]`};return o}();

const e=globalThis.process?.getBuiltinModule?.("crypto")?.hash,r$1="sha256",s="base64url";function digest(t){if(e)return e(r$1,t,s);const o=createHash(r$1).update(t);return globalThis.process?.versions?.webcontainer?o.digest().toString(s):o.digest(s)}

function hash$2(input) {
  return digest(serialize$1(input));
}

const Hasher$1 = /* @__PURE__ */ (() => {
  class Hasher2 {
    buff = "";
    #context = /* @__PURE__ */ new Map();
    write(str) {
      this.buff += str;
    }
    dispatch(value) {
      const type = value === null ? "null" : typeof value;
      return this[type](value);
    }
    object(object) {
      if (object && typeof object.toJSON === "function") {
        return this.object(object.toJSON());
      }
      const objString = Object.prototype.toString.call(object);
      let objType = "";
      const objectLength = objString.length;
      objType = objectLength < 10 ? "unknown:[" + objString + "]" : objString.slice(8, objectLength - 1);
      objType = objType.toLowerCase();
      let objectNumber = null;
      if ((objectNumber = this.#context.get(object)) === void 0) {
        this.#context.set(object, this.#context.size);
      } else {
        return this.dispatch("[CIRCULAR:" + objectNumber + "]");
      }
      if (typeof Buffer !== "undefined" && Buffer.isBuffer && Buffer.isBuffer(object)) {
        this.write("buffer:");
        return this.write(object.toString("utf8"));
      }
      if (objType !== "object" && objType !== "function" && objType !== "asyncfunction") {
        if (this[objType]) {
          this[objType](object);
        } else {
          this.unknown(object, objType);
        }
      } else {
        const keys = Object.keys(object).sort();
        const extraKeys = [];
        this.write("object:" + (keys.length + extraKeys.length) + ":");
        const dispatchForKey = (key) => {
          this.dispatch(key);
          this.write(":");
          this.dispatch(object[key]);
          this.write(",");
        };
        for (const key of keys) {
          dispatchForKey(key);
        }
        for (const key of extraKeys) {
          dispatchForKey(key);
        }
      }
    }
    array(arr, unordered) {
      unordered = unordered === void 0 ? false : unordered;
      this.write("array:" + arr.length + ":");
      if (!unordered || arr.length <= 1) {
        for (const entry of arr) {
          this.dispatch(entry);
        }
        return;
      }
      const contextAdditions = /* @__PURE__ */ new Map();
      const entries = arr.map((entry) => {
        const hasher = new Hasher2();
        hasher.dispatch(entry);
        for (const [key, value] of hasher.#context) {
          contextAdditions.set(key, value);
        }
        return hasher.toString();
      });
      this.#context = contextAdditions;
      entries.sort();
      return this.array(entries, false);
    }
    date(date) {
      return this.write("date:" + date.toJSON());
    }
    symbol(sym) {
      return this.write("symbol:" + sym.toString());
    }
    unknown(value, type) {
      this.write(type);
      if (!value) {
        return;
      }
      this.write(":");
      if (value && typeof value.entries === "function") {
        return this.array(
          [...value.entries()],
          true
          /* ordered */
        );
      }
    }
    error(err) {
      return this.write("error:" + err.toString());
    }
    boolean(bool) {
      return this.write("bool:" + bool);
    }
    string(string) {
      this.write("string:" + string.length + ":");
      this.write(string);
    }
    function(fn) {
      this.write("fn:");
      if (isNativeFunction(fn)) {
        this.dispatch("[native]");
      } else {
        this.dispatch(fn.toString());
      }
    }
    number(number) {
      return this.write("number:" + number);
    }
    null() {
      return this.write("Null");
    }
    undefined() {
      return this.write("Undefined");
    }
    regexp(regex) {
      return this.write("regex:" + regex.toString());
    }
    arraybuffer(arr) {
      this.write("arraybuffer:");
      return this.dispatch(new Uint8Array(arr));
    }
    url(url) {
      return this.write("url:" + url.toString());
    }
    map(map) {
      this.write("map:");
      const arr = [...map];
      return this.array(arr, false);
    }
    set(set) {
      this.write("set:");
      const arr = [...set];
      return this.array(arr, false);
    }
    bigint(number) {
      return this.write("bigint:" + number.toString());
    }
  }
  for (const type of [
    "uint8array",
    "uint8clampedarray",
    "unt8array",
    "uint16array",
    "unt16array",
    "uint32array",
    "unt32array",
    "float32array",
    "float64array"
  ]) {
    Hasher2.prototype[type] = function(arr) {
      this.write(type + ":");
      return this.array([...arr], false);
    };
  }
  function isNativeFunction(f) {
    if (typeof f !== "function") {
      return false;
    }
    return Function.prototype.toString.call(f).slice(
      -15
      /* "[native code] }".length */
    ) === "[native code] }";
  }
  return Hasher2;
})();
function serialize(object) {
  const hasher = new Hasher$1();
  hasher.dispatch(object);
  return hasher.buff;
}
function hash$1(value) {
  return digest(typeof value === "string" ? value : serialize(value)).replace(/[-_]/g, "").slice(0, 10);
}

function defaultCacheOptions() {
  return {
    name: "_",
    base: "/cache",
    swr: true,
    maxAge: 1
  };
}
function defineCachedFunction(fn, opts = {}) {
  opts = { ...defaultCacheOptions(), ...opts };
  const pending = {};
  const group = opts.group || "nitro/functions";
  const name = opts.name || fn.name || "_";
  const integrity = opts.integrity || hash$1([fn, opts]);
  const validate = opts.validate || ((entry) => entry.value !== void 0);
  async function get(key, resolver, shouldInvalidateCache, event) {
    const cacheKey = [opts.base, group, name, key + ".json"].filter(Boolean).join(":").replace(/:\/$/, ":index");
    let entry = await useStorage().getItem(cacheKey).catch((error) => {
      console.error(`[cache] Cache read error.`, error);
      useNitroApp().captureError(error, { event, tags: ["cache"] });
    }) || {};
    if (typeof entry !== "object") {
      entry = {};
      const error = new Error("Malformed data read from cache.");
      console.error("[cache]", error);
      useNitroApp().captureError(error, { event, tags: ["cache"] });
    }
    const ttl = (opts.maxAge ?? 0) * 1e3;
    if (ttl) {
      entry.expires = Date.now() + ttl;
    }
    const expired = shouldInvalidateCache || entry.integrity !== integrity || ttl && Date.now() - (entry.mtime || 0) > ttl || validate(entry) === false;
    const _resolve = async () => {
      const isPending = pending[key];
      if (!isPending) {
        if (entry.value !== void 0 && (opts.staleMaxAge || 0) >= 0 && opts.swr === false) {
          entry.value = void 0;
          entry.integrity = void 0;
          entry.mtime = void 0;
          entry.expires = void 0;
        }
        pending[key] = Promise.resolve(resolver());
      }
      try {
        entry.value = await pending[key];
      } catch (error) {
        if (!isPending) {
          delete pending[key];
        }
        throw error;
      }
      if (!isPending) {
        entry.mtime = Date.now();
        entry.integrity = integrity;
        delete pending[key];
        if (validate(entry) !== false) {
          let setOpts;
          if (opts.maxAge && !opts.swr) {
            setOpts = { ttl: opts.maxAge };
          }
          const promise = useStorage().setItem(cacheKey, entry, setOpts).catch((error) => {
            console.error(`[cache] Cache write error.`, error);
            useNitroApp().captureError(error, { event, tags: ["cache"] });
          });
          if (event?.waitUntil) {
            event.waitUntil(promise);
          }
        }
      }
    };
    const _resolvePromise = expired ? _resolve() : Promise.resolve();
    if (entry.value === void 0) {
      await _resolvePromise;
    } else if (expired && event && event.waitUntil) {
      event.waitUntil(_resolvePromise);
    }
    if (opts.swr && validate(entry) !== false) {
      _resolvePromise.catch((error) => {
        console.error(`[cache] SWR handler error.`, error);
        useNitroApp().captureError(error, { event, tags: ["cache"] });
      });
      return entry;
    }
    return _resolvePromise.then(() => entry);
  }
  return async (...args) => {
    const shouldBypassCache = await opts.shouldBypassCache?.(...args);
    if (shouldBypassCache) {
      return fn(...args);
    }
    const key = await (opts.getKey || getKey)(...args);
    const shouldInvalidateCache = await opts.shouldInvalidateCache?.(...args);
    const entry = await get(
      key,
      () => fn(...args),
      shouldInvalidateCache,
      args[0] && isEvent(args[0]) ? args[0] : void 0
    );
    let value = entry.value;
    if (opts.transform) {
      value = await opts.transform(entry, ...args) || value;
    }
    return value;
  };
}
function cachedFunction(fn, opts = {}) {
  return defineCachedFunction(fn, opts);
}
function getKey(...args) {
  return args.length > 0 ? hash$1(args) : "";
}
function escapeKey(key) {
  return String(key).replace(/\W/g, "");
}
function defineCachedEventHandler(handler, opts = defaultCacheOptions()) {
  const variableHeaderNames = (opts.varies || []).filter(Boolean).map((h) => h.toLowerCase()).sort();
  const _opts = {
    ...opts,
    getKey: async (event) => {
      const customKey = await opts.getKey?.(event);
      if (customKey) {
        return escapeKey(customKey);
      }
      const _path = event.node.req.originalUrl || event.node.req.url || event.path;
      let _pathname;
      try {
        _pathname = escapeKey(decodeURI(parseURL(_path).pathname)).slice(0, 16) || "index";
      } catch {
        _pathname = "-";
      }
      const _hashedPath = `${_pathname}.${hash$1(_path)}`;
      const _headers = variableHeaderNames.map((header) => [header, event.node.req.headers[header]]).map(([name, value]) => `${escapeKey(name)}.${hash$1(value)}`);
      return [_hashedPath, ..._headers].join(":");
    },
    validate: (entry) => {
      if (!entry.value) {
        return false;
      }
      if (entry.value.code >= 400) {
        return false;
      }
      if (entry.value.body === void 0) {
        return false;
      }
      if (entry.value.headers.etag === "undefined" || entry.value.headers["last-modified"] === "undefined") {
        return false;
      }
      return true;
    },
    group: opts.group || "nitro/handlers",
    integrity: opts.integrity || hash$1([handler, opts])
  };
  const _cachedHandler = cachedFunction(
    async (incomingEvent) => {
      const variableHeaders = {};
      for (const header of variableHeaderNames) {
        const value = incomingEvent.node.req.headers[header];
        if (value !== void 0) {
          variableHeaders[header] = value;
        }
      }
      const reqProxy = cloneWithProxy(incomingEvent.node.req, {
        headers: variableHeaders
      });
      const resHeaders = {};
      let _resSendBody;
      const resProxy = cloneWithProxy(incomingEvent.node.res, {
        statusCode: 200,
        writableEnded: false,
        writableFinished: false,
        headersSent: false,
        closed: false,
        getHeader(name) {
          return resHeaders[name];
        },
        setHeader(name, value) {
          resHeaders[name] = value;
          return this;
        },
        getHeaderNames() {
          return Object.keys(resHeaders);
        },
        hasHeader(name) {
          return name in resHeaders;
        },
        removeHeader(name) {
          delete resHeaders[name];
        },
        getHeaders() {
          return resHeaders;
        },
        end(chunk, arg2, arg3) {
          if (typeof chunk === "string") {
            _resSendBody = chunk;
          }
          if (typeof arg2 === "function") {
            arg2();
          }
          if (typeof arg3 === "function") {
            arg3();
          }
          return this;
        },
        write(chunk, arg2, arg3) {
          if (typeof chunk === "string") {
            _resSendBody = chunk;
          }
          if (typeof arg2 === "function") {
            arg2(void 0);
          }
          if (typeof arg3 === "function") {
            arg3();
          }
          return true;
        },
        writeHead(statusCode, headers2) {
          this.statusCode = statusCode;
          if (headers2) {
            if (Array.isArray(headers2) || typeof headers2 === "string") {
              throw new TypeError("Raw headers  is not supported.");
            }
            for (const header in headers2) {
              const value = headers2[header];
              if (value !== void 0) {
                this.setHeader(
                  header,
                  value
                );
              }
            }
          }
          return this;
        }
      });
      const event = createEvent(reqProxy, resProxy);
      event.fetch = (url, fetchOptions) => fetchWithEvent(event, url, fetchOptions, {
        fetch: useNitroApp().localFetch
      });
      event.$fetch = (url, fetchOptions) => fetchWithEvent(event, url, fetchOptions, {
        fetch: globalThis.$fetch
      });
      event.waitUntil = incomingEvent.waitUntil;
      event.context = incomingEvent.context;
      event.context.cache = {
        options: _opts
      };
      const body = await handler(event) || _resSendBody;
      const headers = event.node.res.getHeaders();
      headers.etag = String(
        headers.Etag || headers.etag || `W/"${hash$1(body)}"`
      );
      headers["last-modified"] = String(
        headers["Last-Modified"] || headers["last-modified"] || (/* @__PURE__ */ new Date()).toUTCString()
      );
      const cacheControl = [];
      if (opts.swr) {
        if (opts.maxAge) {
          cacheControl.push(`s-maxage=${opts.maxAge}`);
        }
        if (opts.staleMaxAge) {
          cacheControl.push(`stale-while-revalidate=${opts.staleMaxAge}`);
        } else {
          cacheControl.push("stale-while-revalidate");
        }
      } else if (opts.maxAge) {
        cacheControl.push(`max-age=${opts.maxAge}`);
      }
      if (cacheControl.length > 0) {
        headers["cache-control"] = cacheControl.join(", ");
      }
      const cacheEntry = {
        code: event.node.res.statusCode,
        headers,
        body
      };
      return cacheEntry;
    },
    _opts
  );
  return defineEventHandler(async (event) => {
    if (opts.headersOnly) {
      if (handleCacheHeaders(event, { maxAge: opts.maxAge })) {
        return;
      }
      return handler(event);
    }
    const response = await _cachedHandler(
      event
    );
    if (event.node.res.headersSent || event.node.res.writableEnded) {
      return response.body;
    }
    if (handleCacheHeaders(event, {
      modifiedTime: new Date(response.headers["last-modified"]),
      etag: response.headers.etag,
      maxAge: opts.maxAge
    })) {
      return;
    }
    event.node.res.statusCode = response.code;
    for (const name in response.headers) {
      const value = response.headers[name];
      if (name === "set-cookie") {
        event.node.res.appendHeader(
          name,
          splitCookiesString(value)
        );
      } else {
        if (value !== void 0) {
          event.node.res.setHeader(name, value);
        }
      }
    }
    return response.body;
  });
}
function cloneWithProxy(obj, overrides) {
  return new Proxy(obj, {
    get(target, property, receiver) {
      if (property in overrides) {
        return overrides[property];
      }
      return Reflect.get(target, property, receiver);
    },
    set(target, property, value, receiver) {
      if (property in overrides) {
        overrides[property] = value;
        return true;
      }
      return Reflect.set(target, property, value, receiver);
    }
  });
}
const cachedEventHandler = defineCachedEventHandler;

function klona(x) {
	if (typeof x !== 'object') return x;

	var k, tmp, str=Object.prototype.toString.call(x);

	if (str === '[object Object]') {
		if (x.constructor !== Object && typeof x.constructor === 'function') {
			tmp = new x.constructor();
			for (k in x) {
				if (x.hasOwnProperty(k) && tmp[k] !== x[k]) {
					tmp[k] = klona(x[k]);
				}
			}
		} else {
			tmp = {}; // null
			for (k in x) {
				if (k === '__proto__') {
					Object.defineProperty(tmp, k, {
						value: klona(x[k]),
						configurable: true,
						enumerable: true,
						writable: true,
					});
				} else {
					tmp[k] = klona(x[k]);
				}
			}
		}
		return tmp;
	}

	if (str === '[object Array]') {
		k = x.length;
		for (tmp=Array(k); k--;) {
			tmp[k] = klona(x[k]);
		}
		return tmp;
	}

	if (str === '[object Set]') {
		tmp = new Set;
		x.forEach(function (val) {
			tmp.add(klona(val));
		});
		return tmp;
	}

	if (str === '[object Map]') {
		tmp = new Map;
		x.forEach(function (val, key) {
			tmp.set(klona(key), klona(val));
		});
		return tmp;
	}

	if (str === '[object Date]') {
		return new Date(+x);
	}

	if (str === '[object RegExp]') {
		tmp = new RegExp(x.source, x.flags);
		tmp.lastIndex = x.lastIndex;
		return tmp;
	}

	if (str === '[object DataView]') {
		return new x.constructor( klona(x.buffer) );
	}

	if (str === '[object ArrayBuffer]') {
		return x.slice(0);
	}

	// ArrayBuffer.isView(x)
	// ~> `new` bcuz `Buffer.slice` => ref
	if (str.slice(-6) === 'Array]') {
		return new x.constructor(x);
	}

	return x;
}

const inlineAppConfig = {
  "nuxt": {}
};



const appConfig = defuFn(inlineAppConfig);

const NUMBER_CHAR_RE$1 = /\d/;
const STR_SPLITTERS$1 = ["-", "_", "/", "."];
function isUppercase$1(char = "") {
  if (NUMBER_CHAR_RE$1.test(char)) {
    return void 0;
  }
  return char !== char.toLowerCase();
}
function splitByCase$1(str, separators) {
  const splitters = STR_SPLITTERS$1;
  const parts = [];
  if (!str || typeof str !== "string") {
    return parts;
  }
  let buff = "";
  let previousUpper;
  let previousSplitter;
  for (const char of str) {
    const isSplitter = splitters.includes(char);
    if (isSplitter === true) {
      parts.push(buff);
      buff = "";
      previousUpper = void 0;
      continue;
    }
    const isUpper = isUppercase$1(char);
    if (previousSplitter === false) {
      if (previousUpper === false && isUpper === true) {
        parts.push(buff);
        buff = char;
        previousUpper = isUpper;
        continue;
      }
      if (previousUpper === true && isUpper === false && buff.length > 1) {
        const lastChar = buff.at(-1);
        parts.push(buff.slice(0, Math.max(0, buff.length - 1)));
        buff = lastChar + char;
        previousUpper = isUpper;
        continue;
      }
    }
    buff += char;
    previousUpper = isUpper;
    previousSplitter = isSplitter;
  }
  parts.push(buff);
  return parts;
}
function kebabCase$2(str, joiner) {
  return str ? (Array.isArray(str) ? str : splitByCase$1(str)).map((p) => p.toLowerCase()).join(joiner ?? "-") : "";
}
function snakeCase$2(str) {
  return kebabCase$2(str || "", "_");
}

function getEnv(key, opts) {
  const envKey = snakeCase$2(key).toUpperCase();
  return destr(
    process.env[opts.prefix + envKey] ?? process.env[opts.altPrefix + envKey]
  );
}
function _isObject(input) {
  return typeof input === "object" && !Array.isArray(input);
}
function applyEnv(obj, opts, parentKey = "") {
  for (const key in obj) {
    const subKey = parentKey ? `${parentKey}_${key}` : key;
    const envValue = getEnv(subKey, opts);
    if (_isObject(obj[key])) {
      if (_isObject(envValue)) {
        obj[key] = { ...obj[key], ...envValue };
        applyEnv(obj[key], opts, subKey);
      } else if (envValue === void 0) {
        applyEnv(obj[key], opts, subKey);
      } else {
        obj[key] = envValue ?? obj[key];
      }
    } else {
      obj[key] = envValue ?? obj[key];
    }
    if (opts.envExpansion && typeof obj[key] === "string") {
      obj[key] = _expandFromEnv(obj[key]);
    }
  }
  return obj;
}
const envExpandRx = /\{\{([^{}]*)\}\}/g;
function _expandFromEnv(value) {
  return value.replace(envExpandRx, (match, key) => {
    return process.env[key] || match;
  });
}

const _inlineRuntimeConfig = {
  "app": {
    "baseURL": "/",
    "buildId": "6fd54ada-d1d8-4336-a74b-b32dc8bbb284",
    "buildAssetsDir": "/_nuxt/",
    "cdnURL": ""
  },
  "nitro": {
    "envPrefix": "NUXT_",
    "routeRules": {
      "/__nuxt_error": {
        "cache": false
      },
      "/dashboard/**": {
        "ssr": false
      },
      "/_nuxt/builds/meta/**": {
        "headers": {
          "cache-control": "public, max-age=31536000, immutable"
        }
      },
      "/_nuxt/builds/**": {
        "headers": {
          "cache-control": "public, max-age=1, immutable"
        }
      },
      "/_nuxt/**": {
        "headers": {
          "cache-control": "public, max-age=31536000, immutable"
        }
      }
    }
  },
  "public": {
    "pruvious": {
      "api": {
        "prefix": "api",
        "routes": {
          "clear-cache.post": "clear-cache",
          "collections": "collections",
          "dashboard.get": "dashboard",
          "install.post": "install",
          "installed.get": "installed",
          "login.post": "login",
          "logout.post": "logout",
          "logout-all.post": "logout-all",
          "logout-others.post": "logout-others",
          "pages.get": "pages",
          "previews.get": "previews",
          "process-job.post": "process-job",
          "profile.get": "profile",
          "profile.patch": "profile",
          "renew-token.post": "renew-token",
          "robots.txt.get": "robots.txt",
          "sitemap.xml.get": "sitemap.xml",
          "translatable-strings.get": "translatable-strings",
          "*": true
        }
      },
      "dashboardPrefix": "dashboard",
      "dashboardRemoveSiteStyles": true,
      "jwtRenewInterval": 30,
      "jwtLocalStorageKey": "token",
      "language": {
        "supported": [
          {
            "code": "en",
            "name": "English"
          },
          {
            "code": "ru",
            "name": "Русский"
          },
          {
            "code": "ky",
            "name": "Кыргызча"
          }
        ],
        "primary": "ru",
        "localStorageKey": "language"
      },
      "uploadLimit": 52428800,
      "uploadsBase": "/uploads/"
    },
    "bootstrapVueNext": {
      "directives": [
        "vBColorMode",
        "vBModal",
        "vBPopover",
        "vBScrollspy",
        "vBToggle",
        "vBTooltip"
      ],
      "plugin": {}
    }
  },
  "isBehindProxy": false,
  "pruvious": {
    "catchAllPages": true,
    "customCapabilities": [],
    "dashboard": {
      "baseComponents": {
        "collections/overview": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/dashboard/CollectionsOverview.vue",
        "collections/record": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/dashboard/CollectionsRecord.vue",
        "head": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/dashboard/Head.vue",
        "header/logo": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/dashboard/HeaderLogo.vue",
        "install": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/dashboard/Install.vue",
        "login": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/dashboard/Login.vue",
        "login/logo": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/dashboard/LoginLogo.vue",
        "logout": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/dashboard/Logout.vue",
        "media": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/dashboard/Media.vue",
        "misc": {
          "AddBlockPopup": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/AddBlockPopup.vue",
          "Base": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/Base.vue",
          "BlockTreeItem": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/BlockTreeItem.vue",
          "BooleanFieldPreview": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/BooleanFieldPreview.vue",
          "CollectionsContentRecord": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/CollectionsContentRecord.vue",
          "CollectionsSimpleRecord": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/CollectionsSimpleRecord.vue",
          "CollectionTranslations": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/CollectionTranslations.vue",
          "DateFormatField": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/DateFormatField.vue",
          "DateTimeFormatField": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/DateTimeFormatField.vue",
          "Dialog": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/Dialog.vue",
          "DragImage": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/DragImage.vue",
          "FieldLayout": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/FieldLayout.vue",
          "FieldLayoutTabs": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/FieldLayoutTabs.vue",
          "FilterPopup": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/FilterPopup.vue",
          "FilterRule": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/FilterRule.vue",
          "Globals": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/Globals.vue",
          "HistoryButtons": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/HistoryButtons.vue",
          "ImagePreview": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/ImagePreview.vue",
          "InputError": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/InputError.vue",
          "LegalLinks": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/LegalLinks.vue",
          "LoadingIndicator": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/LoadingIndicator.vue",
          "Logo": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/Logo.vue",
          "LogoFull": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/LogoFull.vue",
          "MediaBreadcrumbs": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/MediaBreadcrumbs.vue",
          "MediaDirectoryPopup": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/MediaDirectoryPopup.vue",
          "MediaFileInput": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/MediaFileInput.vue",
          "MediaItemDirectory": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/MediaItemDirectory.vue",
          "MediaItemUpload": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/MediaItemUpload.vue",
          "MediaLibrary": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/MediaLibrary.vue",
          "MediaLibraryPopup": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/MediaLibraryPopup.vue",
          "MediaMovePopup": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/MediaMovePopup.vue",
          "MediaMovePopupItem": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/MediaMovePopupItem.vue",
          "MediaUploadPopup": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/MediaUploadPopup.vue",
          "MoreBlockOptionsPopup": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/MoreBlockOptionsPopup.vue",
          "MultiCollectionsOverview": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/MultiCollectionsOverview.vue",
          "Popup": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/Popup.vue",
          "QuickActions": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/QuickActions.vue",
          "SearchMedia": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/SearchMedia.vue",
          "SearchRecords": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/SearchRecords.vue",
          "SingleCollectionsOverview": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/SingleCollectionsOverview.vue",
          "StringFieldPreview": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/StringFieldPreview.vue",
          "TableColumnsPopup": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/TableColumnsPopup.vue",
          "TablePagination": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/TablePagination.vue",
          "TableSorter": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/TableSorter.vue",
          "Toaster": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/Toaster.vue",
          "TranslationsFieldPreview": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/TranslationsFieldPreview.vue",
          "UnsavedChanges": "./node_modules/.pnpm/pruvious@https+++codeload.github.com+Fitch24+pruvious+tar.gz+e3a51397d055c8dcee5deb6c86_22234c01e3e4204fac66907637481e49/node_modules/pruvious/dist/runtime/components/misc/UnsavedChanges.vue"
        }
      },
      "enabled": true,
      "legalLinks": [],
      "prefix": "dashboard",
      "removeSiteStyles": true
    },
    "database": "sqlite:./app.db",
    "jwt": {
      "expiration": "4 hours",
      "expirationLong": "7 days",
      "renewInterval": 30,
      "secretKey": "qSB8f7RLdCXrw47mm5I32FvMo47IgosK",
      "localStorageKey": "token"
    },
    "jobs": {
      "searchInterval": 60
    },
    "migration": true,
    "pageCache": {
      "type": "local",
      "path": "./.cache/pages"
    },
    "redis": false,
    "singleCollectionsTable": "single_collections",
    "standardCollections": {
      "pages": false,
      "presets": true,
      "previews": true,
      "redirects": true,
      "roles": true,
      "seo": true,
      "uploads": true,
      "users": true
    },
    "standardFields": {
      "block": true,
      "button-group": true,
      "checkbox": true,
      "checkboxes": true,
      "chips": true,
      "date": true,
      "date-range": true,
      "date-time": true,
      "date-time-range": true,
      "editor": true,
      "file": true,
      "icon": true,
      "image": true,
      "link": true,
      "number": true,
      "range": true,
      "record": true,
      "records": true,
      "repeater": true,
      "select": true,
      "size": true,
      "slider": true,
      "slider-range": true,
      "switch": true,
      "text": true,
      "text-area": true,
      "time": true,
      "time-range": true
    },
    "standardHooks": {
      "redirects": true
    },
    "standardJobs": {
      "clean-expired-previews": true,
      "clean-expired-tokens": true,
      "publish-pages": true
    },
    "standardMiddleware": {
      "client": {
        "auth": true
      },
      "server": {
        "auth": true,
        "config": true,
        "language": true
      }
    },
    "standardTranslatableStrings": {
      "dashboard": true,
      "server": true
    },
    "uploads": {
      "drive": {
        "type": "local",
        "path": "./.uploads",
        "urlPrefix": "uploads"
      },
      "maxFileSize": 52428800
    },
    "uploadsDir": ".uploads"
  }
};
const envOptions = {
  prefix: "NITRO_",
  altPrefix: _inlineRuntimeConfig.nitro.envPrefix ?? process.env.NITRO_ENV_PREFIX ?? "_",
  envExpansion: _inlineRuntimeConfig.nitro.envExpansion ?? process.env.NITRO_ENV_EXPANSION ?? false
};
const _sharedRuntimeConfig = _deepFreeze(
  applyEnv(klona(_inlineRuntimeConfig), envOptions)
);
function useRuntimeConfig(event) {
  if (!event) {
    return _sharedRuntimeConfig;
  }
  if (event.context.nitro.runtimeConfig) {
    return event.context.nitro.runtimeConfig;
  }
  const runtimeConfig = klona(_inlineRuntimeConfig);
  applyEnv(runtimeConfig, envOptions);
  event.context.nitro.runtimeConfig = runtimeConfig;
  return runtimeConfig;
}
_deepFreeze(klona(appConfig));
function _deepFreeze(object) {
  const propNames = Object.getOwnPropertyNames(object);
  for (const name of propNames) {
    const value = object[name];
    if (value && typeof value === "object") {
      _deepFreeze(value);
    }
  }
  return Object.freeze(object);
}
new Proxy(/* @__PURE__ */ Object.create(null), {
  get: (_, prop) => {
    console.warn(
      "Please use `useRuntimeConfig()` instead of accessing config directly."
    );
    const runtimeConfig = useRuntimeConfig();
    if (prop in runtimeConfig) {
      return runtimeConfig[prop];
    }
    return void 0;
  }
});

function createContext(opts = {}) {
  let currentInstance;
  let isSingleton = false;
  const checkConflict = (instance) => {
    if (currentInstance && currentInstance !== instance) {
      throw new Error("Context conflict");
    }
  };
  let als;
  if (opts.asyncContext) {
    const _AsyncLocalStorage = opts.AsyncLocalStorage || globalThis.AsyncLocalStorage;
    if (_AsyncLocalStorage) {
      als = new _AsyncLocalStorage();
    } else {
      console.warn("[unctx] `AsyncLocalStorage` is not provided.");
    }
  }
  const _getCurrentInstance = () => {
    if (als) {
      const instance = als.getStore();
      if (instance !== void 0) {
        return instance;
      }
    }
    return currentInstance;
  };
  return {
    use: () => {
      const _instance = _getCurrentInstance();
      if (_instance === void 0) {
        throw new Error("Context is not available");
      }
      return _instance;
    },
    tryUse: () => {
      return _getCurrentInstance();
    },
    set: (instance, replace) => {
      if (!replace) {
        checkConflict(instance);
      }
      currentInstance = instance;
      isSingleton = true;
    },
    unset: () => {
      currentInstance = void 0;
      isSingleton = false;
    },
    call: (instance, callback) => {
      checkConflict(instance);
      currentInstance = instance;
      try {
        return als ? als.run(instance, callback) : callback();
      } finally {
        if (!isSingleton) {
          currentInstance = void 0;
        }
      }
    },
    async callAsync(instance, callback) {
      currentInstance = instance;
      const onRestore = () => {
        currentInstance = instance;
      };
      const onLeave = () => currentInstance === instance ? onRestore : void 0;
      asyncHandlers.add(onLeave);
      try {
        const r = als ? als.run(instance, callback) : callback();
        if (!isSingleton) {
          currentInstance = void 0;
        }
        return await r;
      } finally {
        asyncHandlers.delete(onLeave);
      }
    }
  };
}
function createNamespace(defaultOpts = {}) {
  const contexts = {};
  return {
    get(key, opts = {}) {
      if (!contexts[key]) {
        contexts[key] = createContext({ ...defaultOpts, ...opts });
      }
      return contexts[key];
    }
  };
}
const _globalThis = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof global !== "undefined" ? global : {};
const globalKey = "__unctx__";
const defaultNamespace = _globalThis[globalKey] || (_globalThis[globalKey] = createNamespace());
const getContext = (key, opts = {}) => defaultNamespace.get(key, opts);
const asyncHandlersKey = "__unctx_async_handlers__";
const asyncHandlers = _globalThis[asyncHandlersKey] || (_globalThis[asyncHandlersKey] = /* @__PURE__ */ new Set());
function executeAsync(function_) {
  const restores = [];
  for (const leaveHandler of asyncHandlers) {
    const restore2 = leaveHandler();
    if (restore2) {
      restores.push(restore2);
    }
  }
  const restore = () => {
    for (const restore2 of restores) {
      restore2();
    }
  };
  let awaitable = function_();
  if (awaitable && typeof awaitable === "object" && "catch" in awaitable) {
    awaitable = awaitable.catch((error) => {
      restore();
      throw error;
    });
  }
  return [awaitable, restore];
}

getContext("nitro-app", {
  asyncContext: false,
  AsyncLocalStorage: void 0
});

const config = useRuntimeConfig();
const _routeRulesMatcher = toRouteMatcher(
  createRouter$1({ routes: config.nitro.routeRules })
);
function createRouteRulesHandler(ctx) {
  return eventHandler((event) => {
    const routeRules = getRouteRules(event);
    if (routeRules.headers) {
      setHeaders(event, routeRules.headers);
    }
    if (routeRules.redirect) {
      let target = routeRules.redirect.to;
      if (target.endsWith("/**")) {
        let targetPath = event.path;
        const strpBase = routeRules.redirect._redirectStripBase;
        if (strpBase) {
          targetPath = withoutBase(targetPath, strpBase);
        }
        target = joinURL(target.slice(0, -3), targetPath);
      } else if (event.path.includes("?")) {
        const query = getQuery$1(event.path);
        target = withQuery(target, query);
      }
      return sendRedirect(event, target, routeRules.redirect.statusCode);
    }
    if (routeRules.proxy) {
      let target = routeRules.proxy.to;
      if (target.endsWith("/**")) {
        let targetPath = event.path;
        const strpBase = routeRules.proxy._proxyStripBase;
        if (strpBase) {
          targetPath = withoutBase(targetPath, strpBase);
        }
        target = joinURL(target.slice(0, -3), targetPath);
      } else if (event.path.includes("?")) {
        const query = getQuery$1(event.path);
        target = withQuery(target, query);
      }
      return proxyRequest(event, target, {
        fetch: ctx.localFetch,
        ...routeRules.proxy
      });
    }
  });
}
function getRouteRules(event) {
  event.context._nitro = event.context._nitro || {};
  if (!event.context._nitro.routeRules) {
    event.context._nitro.routeRules = getRouteRulesForPath(
      withoutBase(event.path.split("?")[0], useRuntimeConfig().app.baseURL)
    );
  }
  return event.context._nitro.routeRules;
}
function getRouteRulesForPath(path) {
  return defu({}, ..._routeRulesMatcher.matchAll(path).reverse());
}

function _captureError(error, type) {
  console.error(`[${type}]`, error);
  useNitroApp().captureError(error, { tags: [type] });
}
function trapUnhandledNodeErrors() {
  process.on(
    "unhandledRejection",
    (error) => _captureError(error, "unhandledRejection")
  );
  process.on(
    "uncaughtException",
    (error) => _captureError(error, "uncaughtException")
  );
}
function joinHeaders(value) {
  return Array.isArray(value) ? value.join(", ") : String(value);
}
function normalizeFetchResponse(response) {
  if (!response.headers.has("set-cookie")) {
    return response;
  }
  return new Response(response.body, {
    status: response.status,
    statusText: response.statusText,
    headers: normalizeCookieHeaders(response.headers)
  });
}
function normalizeCookieHeader(header = "") {
  return splitCookiesString(joinHeaders(header));
}
function normalizeCookieHeaders(headers) {
  const outgoingHeaders = new Headers();
  for (const [name, header] of headers) {
    if (name === "set-cookie") {
      for (const cookie of normalizeCookieHeader(header)) {
        outgoingHeaders.append("set-cookie", cookie);
      }
    } else {
      outgoingHeaders.set(name, joinHeaders(header));
    }
  }
  return outgoingHeaders;
}

function isJsonRequest(event) {
  if (hasReqHeader(event, "accept", "text/html")) {
    return false;
  }
  return hasReqHeader(event, "accept", "application/json") || hasReqHeader(event, "user-agent", "curl/") || hasReqHeader(event, "user-agent", "httpie/") || hasReqHeader(event, "sec-fetch-mode", "cors") || event.path.startsWith("/api/") || event.path.endsWith(".json");
}
function hasReqHeader(event, name, includes) {
  const value = getRequestHeader(event, name);
  return value && typeof value === "string" && value.toLowerCase().includes(includes);
}

const errorHandler$0 = (async function errorhandler(error, event, { defaultHandler }) {
  if (event.handled || isJsonRequest(event)) {
    return;
  }
  const defaultRes = await defaultHandler(error, event, { json: true });
  const statusCode = error.statusCode || 500;
  if (statusCode === 404 && defaultRes.status === 302) {
    setResponseHeaders(event, defaultRes.headers);
    setResponseStatus(event, defaultRes.status, defaultRes.statusText);
    return send(event, JSON.stringify(defaultRes.body, null, 2));
  }
  const errorObject = defaultRes.body;
  const url = new URL(errorObject.url);
  errorObject.url = withoutBase(url.pathname, useRuntimeConfig(event).app.baseURL) + url.search + url.hash;
  errorObject.message ||= "Server Error";
  errorObject.data ||= error.data;
  errorObject.statusMessage ||= error.statusMessage;
  delete defaultRes.headers["content-type"];
  delete defaultRes.headers["content-security-policy"];
  setResponseHeaders(event, defaultRes.headers);
  const reqHeaders = getRequestHeaders(event);
  const isRenderingError = event.path.startsWith("/__nuxt_error") || !!reqHeaders["x-nuxt-error"];
  const res = isRenderingError ? null : await useNitroApp().localFetch(
    withQuery(joinURL(useRuntimeConfig(event).app.baseURL, "/__nuxt_error"), errorObject),
    {
      headers: { ...reqHeaders, "x-nuxt-error": "true" },
      redirect: "manual"
    }
  ).catch(() => null);
  if (event.handled) {
    return;
  }
  if (!res) {
    const { template } = await import('../_/error-500.mjs');
    setResponseHeader(event, "Content-Type", "text/html;charset=UTF-8");
    return send(event, template(errorObject));
  }
  const html = await res.text();
  for (const [header, value] of res.headers.entries()) {
    if (header === "set-cookie") {
      appendResponseHeader(event, header, value);
      continue;
    }
    setResponseHeader(event, header, value);
  }
  setResponseStatus(event, res.status && res.status !== 200 ? res.status : defaultRes.status, res.statusText || defaultRes.statusText);
  return send(event, html);
});

function defineNitroErrorHandler(handler) {
  return handler;
}

const errorHandler$1 = defineNitroErrorHandler(
  function defaultNitroErrorHandler(error, event) {
    const res = defaultHandler(error, event);
    setResponseHeaders(event, res.headers);
    setResponseStatus(event, res.status, res.statusText);
    return send(event, JSON.stringify(res.body, null, 2));
  }
);
function defaultHandler(error, event, opts) {
  const isSensitive = error.unhandled || error.fatal;
  const statusCode = error.statusCode || 500;
  const statusMessage = error.statusMessage || "Server Error";
  const url = getRequestURL(event, { xForwardedHost: true, xForwardedProto: true });
  if (statusCode === 404) {
    const baseURL = "/";
    if (/^\/[^/]/.test(baseURL) && !url.pathname.startsWith(baseURL)) {
      const redirectTo = `${baseURL}${url.pathname.slice(1)}${url.search}`;
      return {
        status: 302,
        statusText: "Found",
        headers: { location: redirectTo },
        body: `Redirecting...`
      };
    }
  }
  if (isSensitive && !opts?.silent) {
    const tags = [error.unhandled && "[unhandled]", error.fatal && "[fatal]"].filter(Boolean).join(" ");
    console.error(`[request error] ${tags} [${event.method}] ${url}
`, error);
  }
  const headers = {
    "content-type": "application/json",
    // Prevent browser from guessing the MIME types of resources.
    "x-content-type-options": "nosniff",
    // Prevent error page from being embedded in an iframe
    "x-frame-options": "DENY",
    // Prevent browsers from sending the Referer header
    "referrer-policy": "no-referrer",
    // Disable the execution of any js
    "content-security-policy": "script-src 'none'; frame-ancestors 'none';"
  };
  setResponseStatus(event, statusCode, statusMessage);
  if (statusCode === 404 || !getResponseHeader(event, "cache-control")) {
    headers["cache-control"] = "no-cache";
  }
  const body = {
    error: true,
    url: url.href,
    statusCode,
    statusMessage,
    message: isSensitive ? "Server Error" : error.message,
    data: isSensitive ? void 0 : error.data
  };
  return {
    status: statusCode,
    statusText: statusMessage,
    headers,
    body
  };
}

const errorHandlers = [errorHandler$0, errorHandler$1];

async function errorHandler(error, event) {
  for (const handler of errorHandlers) {
    try {
      await handler(error, event, { defaultHandler });
      if (event.handled) {
        return; // Response handled
      }
    } catch(error) {
      // Handler itself thrown, log and continue
      console.error(error);
    }
  }
  // H3 will handle fallback
}

function defineNitroPlugin(def) {
  return def;
}

function defineRenderHandler(render) {
  const runtimeConfig = useRuntimeConfig();
  return eventHandler(async (event) => {
    const nitroApp = useNitroApp();
    const ctx = { event, render, response: void 0 };
    await nitroApp.hooks.callHook("render:before", ctx);
    if (!ctx.response) {
      if (event.path === `${runtimeConfig.app.baseURL}favicon.ico`) {
        setResponseHeader(event, "Content-Type", "image/x-icon");
        return send(
          event,
          "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7"
        );
      }
      ctx.response = await ctx.render(event);
      if (!ctx.response) {
        const _currentStatus = getResponseStatus(event);
        setResponseStatus(event, _currentStatus === 200 ? 500 : _currentStatus);
        return send(
          event,
          "No response returned from render handler: " + event.path
        );
      }
    }
    await nitroApp.hooks.callHook("render:response", ctx.response, ctx);
    if (ctx.response.headers) {
      setResponseHeaders(event, ctx.response.headers);
    }
    if (ctx.response.statusCode || ctx.response.statusMessage) {
      setResponseStatus(
        event,
        ctx.response.statusCode,
        ctx.response.statusMessage
      );
    }
    return ctx.response.body;
  });
}

const r=Object.create(null),i=e=>globalThis.process?.env||globalThis._importMeta_.env||globalThis.Deno?.env.toObject()||globalThis.__env__||(e?r:globalThis),o=new Proxy(r,{get(e,s){return i()[s]??r[s]},has(e,s){const E=i();return s in E||s in r},set(e,s,E){const B=i(true);return B[s]=E,true},deleteProperty(e,s){if(!s)return  false;const E=i(true);return delete E[s],true},ownKeys(){const e=i(true);return Object.keys(e)}}),t=typeof process<"u"&&process.env&&"production"||"",f=[["APPVEYOR"],["AWS_AMPLIFY","AWS_APP_ID",{ci:true}],["AZURE_PIPELINES","SYSTEM_TEAMFOUNDATIONCOLLECTIONURI"],["AZURE_STATIC","INPUT_AZURE_STATIC_WEB_APPS_API_TOKEN"],["APPCIRCLE","AC_APPCIRCLE"],["BAMBOO","bamboo_planKey"],["BITBUCKET","BITBUCKET_COMMIT"],["BITRISE","BITRISE_IO"],["BUDDY","BUDDY_WORKSPACE_ID"],["BUILDKITE"],["CIRCLE","CIRCLECI"],["CIRRUS","CIRRUS_CI"],["CLOUDFLARE_PAGES","CF_PAGES",{ci:true}],["CLOUDFLARE_WORKERS","WORKERS_CI",{ci:true}],["CODEBUILD","CODEBUILD_BUILD_ARN"],["CODEFRESH","CF_BUILD_ID"],["DRONE"],["DRONE","DRONE_BUILD_EVENT"],["DSARI"],["GITHUB_ACTIONS"],["GITLAB","GITLAB_CI"],["GITLAB","CI_MERGE_REQUEST_ID"],["GOCD","GO_PIPELINE_LABEL"],["LAYERCI"],["HUDSON","HUDSON_URL"],["JENKINS","JENKINS_URL"],["MAGNUM"],["NETLIFY"],["NETLIFY","NETLIFY_LOCAL",{ci:false}],["NEVERCODE"],["RENDER"],["SAIL","SAILCI"],["SEMAPHORE"],["SCREWDRIVER"],["SHIPPABLE"],["SOLANO","TDDIUM"],["STRIDER"],["TEAMCITY","TEAMCITY_VERSION"],["TRAVIS"],["VERCEL","NOW_BUILDER"],["VERCEL","VERCEL",{ci:false}],["VERCEL","VERCEL_ENV",{ci:false}],["APPCENTER","APPCENTER_BUILD_ID"],["CODESANDBOX","CODESANDBOX_SSE",{ci:false}],["CODESANDBOX","CODESANDBOX_HOST",{ci:false}],["STACKBLITZ"],["STORMKIT"],["CLEAVR"],["ZEABUR"],["CODESPHERE","CODESPHERE_APP_ID",{ci:true}],["RAILWAY","RAILWAY_PROJECT_ID"],["RAILWAY","RAILWAY_SERVICE_ID"],["DENO-DEPLOY","DENO_DEPLOYMENT_ID"],["FIREBASE_APP_HOSTING","FIREBASE_APP_HOSTING",{ci:true}]];function b(){if(globalThis.process?.env)for(const e of f){const s=e[1]||e[0];if(globalThis.process?.env[s])return {name:e[0].toLowerCase(),...e[2]}}return globalThis.process?.env?.SHELL==="/bin/jsh"&&globalThis.process?.versions?.webcontainer?{name:"stackblitz",ci:false}:{name:"",ci:false}}const l=b();l.name;function n(e){return e?e!=="false":false}const I=globalThis.process?.platform||"",T=n(o.CI)||l.ci!==false,R=n(globalThis.process?.stdout&&globalThis.process?.stdout.isTTY);n(o.DEBUG);const a=t==="test"||n(o.TEST),g=t==="production",h=t==="dev"||t==="development";n(o.MINIMAL)||T||a||!R;const A=/^win/i.test(I);!n(o.NO_COLOR)&&(n(o.FORCE_COLOR)||(R||A)&&o.TERM!=="dumb"||T);const C=(globalThis.process?.versions?.node||"").replace(/^v/,"")||null;Number(C?.split(".")[0])||null;const W$1=globalThis.process||Object.create(null),_$1={versions:{}};new Proxy(W$1,{get(e,s){if(s==="env")return o;if(s in e)return e[s];if(s in _$1)return _$1[s]}});const O=globalThis.process?.release?.name==="node",c=!!globalThis.Bun||!!globalThis.process?.versions?.bun,D=!!globalThis.Deno,L=!!globalThis.fastly,S=!!globalThis.Netlify,u=!!globalThis.EdgeRuntime,N=globalThis.navigator?.userAgent==="Cloudflare-Workers",F=[[S,"netlify"],[u,"edge-light"],[N,"workerd"],[L,"fastly"],[D,"deno"],[c,"bun"],[O,"node"]];function G(){const e=F.find(s=>s[0]);if(e)return {name:e[1]}}const P=G();P?.name||"";

function buildAssetsDir() {
  return useRuntimeConfig().app.buildAssetsDir;
}
function buildAssetsURL(...path) {
  return joinRelativeURL(publicAssetsURL(), buildAssetsDir(), ...path);
}
function publicAssetsURL(...path) {
  const app = useRuntimeConfig().app;
  const publicBase = app.cdnURL || app.baseURL;
  return path.length ? joinRelativeURL(publicBase, ...path) : publicBase;
}

const query2string = (value) => {
  if (!value) {
    return void 0;
  }
  if (Array.isArray(value)) {
    return value.at(0) || void 0;
  }
  return value || void 0;
};

async function catchFirstErrorMessage(groups) {
  const results = {};
  for (const [name, callbacks] of Object.entries(groups)) {
    for (const callback of callbacks) {
      try {
        await callback();
      } catch (e) {
        results[name] = e.message;
        break;
      }
    }
  }
  return results;
}
const isFunction = isFunction$1;
async function sleep(milliseconds) {
  return new Promise((resolve) => setTimeout(resolve, milliseconds));
}

/*!
 * bytes
 * Copyright(c) 2012-2014 TJ Holowaychuk
 * Copyright(c) 2015 Jed Watson
 * MIT Licensed
 */
const formatThousandsRegExp = /\B(?=(\d{3})+(?!\d))/g;
const formatDecimalsRegExp = /(?:\.0*|(\.[^0]+)0+)$/;
const map = {
  b: 1,
  kb: 1 << 10,
  mb: 1 << 20,
  gb: 1 << 30,
  tb: Math.pow(1024, 4),
  pb: Math.pow(1024, 5)
};
const parseRegExp = /^((-|\+)?(\d+(?:\.\d+)?)) *(kb|mb|gb|tb|pb)$/i;
function format(value, options) {
  if (!Number.isFinite(value)) {
    return null;
  }
  var mag = Math.abs(value);
  var thousandsSeparator = options && options.thousandsSeparator || "";
  var unitSeparator = options && options.unitSeparator || "";
  var decimalPlaces = options && options.decimalPlaces !== void 0 ? options.decimalPlaces : 2;
  var fixedDecimals = Boolean(options && options.fixedDecimals);
  var unit = options && options.unit || "";
  if (!unit || !map[unit.toLowerCase()]) {
    if (mag >= map.pb) {
      unit = "PB";
    } else if (mag >= map.tb) {
      unit = "TB";
    } else if (mag >= map.gb) {
      unit = "GB";
    } else if (mag >= map.mb) {
      unit = "MB";
    } else if (mag >= map.kb) {
      unit = "KB";
    } else {
      unit = "B";
    }
  }
  var val = value / map[unit.toLowerCase()];
  var str = val.toFixed(decimalPlaces);
  if (!fixedDecimals) {
    str = str.replace(formatDecimalsRegExp, "$1");
  }
  if (thousandsSeparator) {
    str = str.split(".").map(function(s, i) {
      return i === 0 ? s.replace(formatThousandsRegExp, thousandsSeparator) : s;
    }).join(".");
  }
  return str + unitSeparator + unit;
}
function parse(val) {
  if (typeof val === "number" && !isNaN(val)) {
    return val;
  }
  if (typeof val !== "string") {
    return null;
  }
  var results = parseRegExp.exec(val);
  var floatValue;
  var unit = "b";
  if (!results) {
    floatValue = parseInt(val, 10);
    unit = "b";
  } else {
    floatValue = parseFloat(results[1]);
    unit = results[4].toLowerCase();
  }
  if (isNaN(floatValue)) {
    return null;
  }
  return Math.floor(map[unit] * floatValue);
}

function countDecimals(value) {
  return value.toString().split(".")[1]?.length || 0;
}
function isInteger(value) {
  return isRealNumber(value) && Number.isInteger(value);
}
const isNumber = isNumber$1;
function isPositiveInteger(value) {
  return isRealNumber(value) && isInteger(value) && value > 0;
}
function isRealNumber(value) {
  return typeof value === "number" && Number.isFinite(value);
}

const NUMBER_CHAR_RE = /\d/;
const STR_SPLITTERS = ["-", "_", "/", "."];
function isUppercase(char = "") {
  if (NUMBER_CHAR_RE.test(char)) {
    return void 0;
  }
  return char.toUpperCase() === char;
}
function splitByCase(str, separators) {
  const splitters = STR_SPLITTERS;
  const parts = [];
  if (!str || typeof str !== "string") {
    return parts;
  }
  let buff = "";
  let previousUpper;
  let previousSplitter;
  for (const char of str) {
    const isSplitter = splitters.includes(char);
    if (isSplitter === true) {
      parts.push(buff);
      buff = "";
      previousUpper = void 0;
      continue;
    }
    const isUpper = isUppercase(char);
    if (previousSplitter === false) {
      if (previousUpper === false && isUpper === true) {
        parts.push(buff);
        buff = char;
        previousUpper = isUpper;
        continue;
      }
      if (previousUpper === true && isUpper === false && buff.length > 1) {
        const lastChar = buff.at(-1);
        parts.push(buff.slice(0, Math.max(0, buff.length - 1)));
        buff = lastChar + char;
        previousUpper = isUpper;
        continue;
      }
    }
    buff += char;
    previousUpper = isUpper;
    previousSplitter = isSplitter;
  }
  parts.push(buff);
  return parts;
}
function upperFirst(str) {
  return str ? str[0].toUpperCase() + str.slice(1) : "";
}
function lowerFirst(str) {
  return str ? str[0].toLowerCase() + str.slice(1) : "";
}
function pascalCase(str, opts) {
  return str ? (Array.isArray(str) ? str : splitByCase(str)).map((p) => upperFirst(p)).join("") : "";
}
function camelCase$1(str, opts) {
  return lowerFirst(pascalCase(str || ""));
}
function kebabCase$1(str, joiner) {
  return str ? (Array.isArray(str) ? str : splitByCase(str)).map((p) => p.toLowerCase()).join(joiner ?? "-") : "";
}
function snakeCase$1(str) {
  return kebabCase$1(str || "", "_");
}

const isBoolean = isBoolean$1;
const isDefined = isDef;
const isNull = isNull$1;
const isFile = (value) => value instanceof File;
const isUndefined = isUndefined$1;

function camelCase(value) {
  return camelCase$1(value);
}
function capitalize(value, lowercaseRest = true) {
  return (value[0]?.toUpperCase() ?? "") + (lowercaseRest ? value.slice(1)?.toLowerCase() ?? "" : value.slice(1));
}
function extractKeywords(value) {
  return value.toLowerCase().split(" ").map((keyword) => keyword.trim()).filter(Boolean);
}
function isAlphanumeric(character) {
  const code = character.charCodeAt(0);
  return code >= 65 && code <= 90 || // A-Z
  code >= 97 && code <= 122 || // a-z
  code >= 48 && code <= 57;
}
const isString = isString$1;
function isUrl(value) {
  try {
    return new URL(value).href.replace(/\/$/, "") === value.replace(/\/$/, "");
  } catch {
    return false;
  }
}
function isUrlPath(value, allowRelative = false) {
  try {
    const url = new URL(value, "http://__pruvious");
    return !value.includes("//") && (url.pathname === value || allowRelative && url.pathname.slice(1) === value);
  } catch {
    return false;
  }
}
function joinRouteParts(...parts) {
  const parsedParts = parts.filter(Boolean).map((part) => part.replaceAll("\\", "/"));
  if (parsedParts[0]?.includes(":")) {
    parsedParts[0] = parsedParts[0].replace(/^[a-z]:[\\\/]/i, "");
  }
  return withoutTrailingSlash(cleanDoubleSlashes(joinURL("/", ...parsedParts)));
}
function kebabCase(value) {
  return kebabCase$1(value);
}
function resolveCollectionPathPrefix(collection, language, primaryLanguage) {
  const pp = collection.publicPages;
  return isString(pp.pathPrefix) ? pp.pathPrefix : isObject(pp.pathPrefix) ? pp.pathPrefix[language] ?? pp.pathPrefix[primaryLanguage] ?? "" : "";
}
function getTranslationPrefix(path, supportedLanguages) {
  const parts = path.split("/").filter(Boolean);
  if (supportedLanguages.includes(parts[0])) {
    return parts[0];
  }
  return null;
}
function removeAccents(value) {
  return value.normalize("NFD").replace(/[\u0300-\u036f]/g, "").replaceAll("\xDF", "ss");
}
function snakeCase(value) {
  return snakeCase$1(value);
}
function titleCase(value, capitalizeAll = true) {
  if (!isString(value)) {
    return "";
  }
  return kebabCase(value).split("-").map((word) => word.trim()).filter(Boolean).map((word, i) => i === 0 || capitalizeAll ? capitalize(word) : word).join(" ");
}

const collator = new Intl.Collator("en", { numeric: true, sensitivity: "base" });
function clearArray(array) {
  return clearObject(array);
}
function isArray(array) {
  return Array.isArray(array);
}
function sortNaturalByProp(array, prop) {
  return array.sort((a, b) => collator.compare(a[prop] ?? "", b[prop] ?? ""));
}
const toArray = toArray$1;
const uniqueArray = uniq;

function clearObject(object) {
  if (isArray(object)) {
    object.splice(0, object.length);
  } else if (object && typeof object === "object") {
    for (const property of Object.getOwnPropertyNames(object)) {
      delete object[property];
    }
  }
  return object;
}
function deepClone(object) {
  if (object === null || typeof object !== "object") {
    return object;
  }
  if (isArray(object)) {
    return object.map((item) => deepClone(item));
  }
  const clone = {};
  for (const key of Object.getOwnPropertyNames(object)) {
    clone[key] = deepClone(object[key]);
  }
  for (const symbol of Object.getOwnPropertySymbols(object)) {
    clone[symbol] = deepClone(object[symbol]);
  }
  return clone;
}
const deepMerge = deepMerge$1;
function deleteProperty(object, path) {
  const prop = path.replace(/\.([0-9]+)(\.|$)/gm, "[$1]$2");
  if (prop.endsWith("]")) {
    const index = +prop.slice(prop.lastIndexOf("[") + 1, -1);
    const array = getProperty$1(object, prop.slice(0, prop.lastIndexOf("[")));
    if (isArray(array)) {
      array.splice(index, 1);
      return true;
    }
    return false;
  }
  return deleteProperty$1(object, prop);
}
function getProperty(object, path) {
  return getProperty$1(object, path.replace(/\.([0-9]+)(\.|$)/gm, "[$1]$2"));
}
function isKeyOf(object, key) {
  return isKeyOf$1(object, key);
}
const isObject = isObject$1;
const mergeDefaults = createDefu((object, key, value) => {
  if (isArray(object[key])) {
    object[key] = value;
    return true;
  }
});
function objectOmit(object, keys) {
  const newObject = {};
  for (const key of Object.keys(object)) {
    if (!keys.includes(key)) {
      newObject[key] = object[key];
    }
  }
  return newObject;
}
const objectPick = objectPick$1;
function setProperty(object, path, value) {
  return setProperty$1(object, path.replace(/\.([0-9]+)(\.|$)/gm, "[$1]$2"), value);
}
function snakeCasePropNames(object) {
  for (const { key, value, parent } of walkObject(object)) {
    if (isString(key)) {
      const snakeKey = snakeCase(key);
      if (snakeKey !== key) {
        parent[snakeKey] = value;
        delete parent[key];
      }
    }
  }
  return object;
}
function stringifySymbols(object) {
  if (object === null || typeof object !== "object") {
    return object;
  }
  if (isArray(object)) {
    return object.map((item) => stringifySymbols(item));
  }
  const clone = {};
  for (const key of Object.getOwnPropertyNames(object)) {
    clone[key] = stringifySymbols(object[key]);
  }
  for (const symbol of Object.getOwnPropertySymbols(object)) {
    clone[symbol.toString()] = stringifySymbols(object[symbol]);
  }
  return clone;
}
function* walkObject(object) {
  if (object !== null && typeof object === "object") {
    if (isArray(object)) {
      for (const [key, value] of object.entries()) {
        yield { key, value, parent: object };
        yield* walkObject(value);
      }
    } else {
      for (const key of Object.getOwnPropertyNames(object)) {
        yield { key, value: object[key], parent: object };
        yield* walkObject(object[key]);
      }
      for (const symbol of Object.getOwnPropertySymbols(object)) {
        yield { key: symbol, value: object[symbol], parent: object };
        yield* walkObject(object[symbol]);
      }
    }
  }
}

const special = [
  "baseComponents",
  "baseUrl",
  "customCapabilities",
  "expirationLong",
  "legalLinks",
  "localStorageKey",
  "localStorageKey",
  "maxFileSize",
  "renewInterval",
  "searchInterval",
  "secretKey",
  "singleCollectionsTable",
  "standardCollections",
  "standardFields",
  "standardHooks",
  "standardJobs",
  "standardMiddleware",
  "standardTranslatableStrings",
  "urlPrefix"
].map((key) => snakeCase(key).toUpperCase());
function patchModuleOptions(runtimeConfig) {
  for (const [key, value] of Object.entries(process.env)) {
    for (const [prefix, object] of [
      ["NUXT_PRUVIOUS_", runtimeConfig.pruvious],
      ["NUXT_PUBLIC_PRUVIOUS_", runtimeConfig.public.pruvious]
    ]) {
      if (key.startsWith(prefix)) {
        let path = key.slice(prefix.length);
        for (const word of special) {
          path = path.replace(word, kebabCase(word));
        }
        path = path.replaceAll("_", ".").split(".").map((part) => camelCase(part.toLowerCase())).join(".");
        setProperty(object, path, value);
      }
    }
  }
  if (runtimeConfig.public.pruvious.language && !runtimeConfig.public.pruvious.language.supported?.length) {
    runtimeConfig.public.pruvious.language.supported.push({ name: "English", code: "en" });
  }
  if (runtimeConfig.pruvious.uploads?.drive?.type === "s3") {
    runtimeConfig.pruvious.uploads.drive.baseUrl = runtimeConfig.pruvious.uploads.drive.baseUrl.replace(/\/*$/, "/");
  }
  runtimeConfig.public.pruvious.uploadsBase = runtimeConfig.pruvious.uploads?.drive?.type === "s3" ? runtimeConfig.pruvious.uploads.drive.baseUrl : joinRouteParts(runtimeConfig.app.baseURL, runtimeConfig.pruvious.uploads.drive.urlPrefix ?? "uploads") + "/";
  if (isString(runtimeConfig.pruvious.uploads?.maxFileSize)) {
    runtimeConfig.pruvious.uploads.maxFileSize = parse(runtimeConfig.pruvious.uploads.maxFileSize);
  } else if (runtimeConfig.pruvious.uploads && !isNumber(runtimeConfig.pruvious.uploads?.maxFileSize)) {
    runtimeConfig.pruvious.uploads.maxFileSize = parse("16 MB");
  }
}

const intervals = [];
let optionsInitialized = false;
const moduleOptions = {
  api: "",
  baseUrl: "",
  catchAllPages: true,
  customCapabilities: [],
  dashboard: {},
  database: "",
  jobs: {},
  jwt: {},
  language: {},
  layers: [],
  migration: {},
  pageCache: true,
  redis: false,
  singleCollectionsTable: "",
  standardCollections: {},
  standardFields: {},
  standardHooks: {},
  standardJobs: {},
  standardMiddleware: {},
  standardTranslatableStrings: {},
  uploads: {},
  uploadsDir: ""
};
function cacheModuleOptions(runtimeConfig) {
  if (!optionsInitialized) {
    const config = deepClone(runtimeConfig);
    patchModuleOptions(config);
    deepMerge(moduleOptions, {
      api: config.public.pruvious.api,
      baseUrl: runtimeConfig.app.baseURL,
      catchAllPages: config.pruvious.catchAllPages,
      customCapabilities: config.pruvious.customCapabilities,
      dashboard: config.pruvious.dashboard,
      database: config.pruvious.database,
      jobs: config.pruvious.jobs,
      jwt: config.pruvious.jwt,
      language: config.public.pruvious.language,
      migration: config.pruvious.migration,
      pageCache: config.pageCache,
      redis: config.pruvious.redis,
      singleCollectionsTable: config.pruvious.singleCollectionsTable,
      standardCollections: config.pruvious.standardCollections,
      standardFields: config.pruvious.standardFields,
      standardHooks: config.pruvious.standardHooks,
      standardJobs: config.pruvious.standardJobs,
      standardMiddleware: config.pruvious.standardMiddleware,
      standardTranslatableStrings: config.pruvious.standardTranslatableStrings,
      uploads: config.pruvious.uploads,
      uploadsDir: config.pruvious.uploadsDir
    });
    optionsInitialized = true;
  }
}
function getModuleOption(option) {
  return moduleOptions[option];
}

const state = /*#__PURE__*/Object.freeze(/*#__PURE__*/Object.defineProperty({
  __proto__: null,
  cacheModuleOptions: cacheModuleOptions,
  getModuleOption: getModuleOption,
  intervals: intervals
}, Symbol.toStringTag, { value: 'Module' }));

let client$1;
let status$1 = "initial";
async function cache(force = false) {
  if (status$1 === "initial" || !client$1 && force) {
    const url = getModuleOption("redis");
    if (url) {
      client$1 = createClient({ url });
      status$1 = "connecting";
      try {
        await client$1.connect();
        await client$1.flushDb();
      } catch {
      }
    }
    status$1 = "ready";
  }
  while (status$1 === "connecting") {
    sleep(50);
  }
  return client$1 ?? null;
}

const cache$1 = /*#__PURE__*/Object.freeze(/*#__PURE__*/Object.defineProperty({
  __proto__: null,
  cache: cache
}, Symbol.toStringTag, { value: 'Module' }));

const defaults = Object.freeze({
  ignoreUnknown: false,
  respectType: false,
  respectFunctionNames: false,
  respectFunctionProperties: false,
  unorderedObjects: true,
  unorderedArrays: false,
  unorderedSets: false,
  excludeKeys: void 0,
  excludeValues: void 0,
  replacer: void 0
});
function objectHash(object, options) {
  if (options) {
    options = { ...defaults, ...options };
  } else {
    options = defaults;
  }
  const hasher = createHasher(options);
  hasher.dispatch(object);
  return hasher.toString();
}
const defaultPrototypesKeys = Object.freeze([
  "prototype",
  "__proto__",
  "constructor"
]);
function createHasher(options) {
  let buff = "";
  let context = /* @__PURE__ */ new Map();
  const write = (str) => {
    buff += str;
  };
  return {
    toString() {
      return buff;
    },
    getContext() {
      return context;
    },
    dispatch(value) {
      if (options.replacer) {
        value = options.replacer(value);
      }
      const type = value === null ? "null" : typeof value;
      return this[type](value);
    },
    object(object) {
      if (object && typeof object.toJSON === "function") {
        return this.object(object.toJSON());
      }
      const objString = Object.prototype.toString.call(object);
      let objType = "";
      const objectLength = objString.length;
      if (objectLength < 10) {
        objType = "unknown:[" + objString + "]";
      } else {
        objType = objString.slice(8, objectLength - 1);
      }
      objType = objType.toLowerCase();
      let objectNumber = null;
      if ((objectNumber = context.get(object)) === void 0) {
        context.set(object, context.size);
      } else {
        return this.dispatch("[CIRCULAR:" + objectNumber + "]");
      }
      if (typeof Buffer !== "undefined" && Buffer.isBuffer && Buffer.isBuffer(object)) {
        write("buffer:");
        return write(object.toString("utf8"));
      }
      if (objType !== "object" && objType !== "function" && objType !== "asyncfunction") {
        if (this[objType]) {
          this[objType](object);
        } else if (!options.ignoreUnknown) {
          this.unkown(object, objType);
        }
      } else {
        let keys = Object.keys(object);
        if (options.unorderedObjects) {
          keys = keys.sort();
        }
        let extraKeys = [];
        if (options.respectType !== false && !isNativeFunction(object)) {
          extraKeys = defaultPrototypesKeys;
        }
        if (options.excludeKeys) {
          keys = keys.filter((key) => {
            return !options.excludeKeys(key);
          });
          extraKeys = extraKeys.filter((key) => {
            return !options.excludeKeys(key);
          });
        }
        write("object:" + (keys.length + extraKeys.length) + ":");
        const dispatchForKey = (key) => {
          this.dispatch(key);
          write(":");
          if (!options.excludeValues) {
            this.dispatch(object[key]);
          }
          write(",");
        };
        for (const key of keys) {
          dispatchForKey(key);
        }
        for (const key of extraKeys) {
          dispatchForKey(key);
        }
      }
    },
    array(arr, unordered) {
      unordered = unordered === void 0 ? options.unorderedArrays !== false : unordered;
      write("array:" + arr.length + ":");
      if (!unordered || arr.length <= 1) {
        for (const entry of arr) {
          this.dispatch(entry);
        }
        return;
      }
      const contextAdditions = /* @__PURE__ */ new Map();
      const entries = arr.map((entry) => {
        const hasher = createHasher(options);
        hasher.dispatch(entry);
        for (const [key, value] of hasher.getContext()) {
          contextAdditions.set(key, value);
        }
        return hasher.toString();
      });
      context = contextAdditions;
      entries.sort();
      return this.array(entries, false);
    },
    date(date) {
      return write("date:" + date.toJSON());
    },
    symbol(sym) {
      return write("symbol:" + sym.toString());
    },
    unkown(value, type) {
      write(type);
      if (!value) {
        return;
      }
      write(":");
      if (value && typeof value.entries === "function") {
        return this.array(
          Array.from(value.entries()),
          true
          /* ordered */
        );
      }
    },
    error(err) {
      return write("error:" + err.toString());
    },
    boolean(bool) {
      return write("bool:" + bool);
    },
    string(string) {
      write("string:" + string.length + ":");
      write(string);
    },
    function(fn) {
      write("fn:");
      if (isNativeFunction(fn)) {
        this.dispatch("[native]");
      } else {
        this.dispatch(fn.toString());
      }
      if (options.respectFunctionNames !== false) {
        this.dispatch("function-name:" + String(fn.name));
      }
      if (options.respectFunctionProperties) {
        this.object(fn);
      }
    },
    number(number) {
      return write("number:" + number);
    },
    xml(xml) {
      return write("xml:" + xml.toString());
    },
    null() {
      return write("Null");
    },
    undefined() {
      return write("Undefined");
    },
    regexp(regex) {
      return write("regex:" + regex.toString());
    },
    uint8array(arr) {
      write("uint8array:");
      return this.dispatch(Array.prototype.slice.call(arr));
    },
    uint8clampedarray(arr) {
      write("uint8clampedarray:");
      return this.dispatch(Array.prototype.slice.call(arr));
    },
    int8array(arr) {
      write("int8array:");
      return this.dispatch(Array.prototype.slice.call(arr));
    },
    uint16array(arr) {
      write("uint16array:");
      return this.dispatch(Array.prototype.slice.call(arr));
    },
    int16array(arr) {
      write("int16array:");
      return this.dispatch(Array.prototype.slice.call(arr));
    },
    uint32array(arr) {
      write("uint32array:");
      return this.dispatch(Array.prototype.slice.call(arr));
    },
    int32array(arr) {
      write("int32array:");
      return this.dispatch(Array.prototype.slice.call(arr));
    },
    float32array(arr) {
      write("float32array:");
      return this.dispatch(Array.prototype.slice.call(arr));
    },
    float64array(arr) {
      write("float64array:");
      return this.dispatch(Array.prototype.slice.call(arr));
    },
    arraybuffer(arr) {
      write("arraybuffer:");
      return this.dispatch(new Uint8Array(arr));
    },
    url(url) {
      return write("url:" + url.toString());
    },
    map(map) {
      write("map:");
      const arr = [...map];
      return this.array(arr, options.unorderedSets !== false);
    },
    set(set) {
      write("set:");
      const arr = [...set];
      return this.array(arr, options.unorderedSets !== false);
    },
    file(file) {
      write("file:");
      return this.dispatch([file.name, file.size, file.type, file.lastModfied]);
    },
    blob() {
      if (options.ignoreUnknown) {
        return write("[blob]");
      }
      throw new Error(
        'Hashing Blob objects is currently not supported\nUse "options.replacer" or "options.ignoreUnknown"\n'
      );
    },
    domwindow() {
      return write("domwindow");
    },
    bigint(number) {
      return write("bigint:" + number.toString());
    },
    /* Node.js standard native objects */
    process() {
      return write("process");
    },
    timer() {
      return write("timer");
    },
    pipe() {
      return write("pipe");
    },
    tcp() {
      return write("tcp");
    },
    udp() {
      return write("udp");
    },
    tty() {
      return write("tty");
    },
    statwatcher() {
      return write("statwatcher");
    },
    securecontext() {
      return write("securecontext");
    },
    connection() {
      return write("connection");
    },
    zlib() {
      return write("zlib");
    },
    context() {
      return write("context");
    },
    nodescript() {
      return write("nodescript");
    },
    httpparser() {
      return write("httpparser");
    },
    dataview() {
      return write("dataview");
    },
    signal() {
      return write("signal");
    },
    fsevent() {
      return write("fsevent");
    },
    tlswrap() {
      return write("tlswrap");
    }
  };
}
const nativeFunc = "[native code] }";
const nativeFuncLength = nativeFunc.length;
function isNativeFunction(f) {
  if (typeof f !== "function") {
    return false;
  }
  return Function.prototype.toString.call(f).slice(-nativeFuncLength) === nativeFunc;
}

class WordArray {
  words;
  sigBytes;
  constructor(words, sigBytes) {
    words = this.words = words || [];
    this.sigBytes = sigBytes === void 0 ? words.length * 4 : sigBytes;
  }
  toString(encoder) {
    return (encoder || Hex).stringify(this);
  }
  concat(wordArray) {
    this.clamp();
    if (this.sigBytes % 4) {
      for (let i = 0; i < wordArray.sigBytes; i++) {
        const thatByte = wordArray.words[i >>> 2] >>> 24 - i % 4 * 8 & 255;
        this.words[this.sigBytes + i >>> 2] |= thatByte << 24 - (this.sigBytes + i) % 4 * 8;
      }
    } else {
      for (let j = 0; j < wordArray.sigBytes; j += 4) {
        this.words[this.sigBytes + j >>> 2] = wordArray.words[j >>> 2];
      }
    }
    this.sigBytes += wordArray.sigBytes;
    return this;
  }
  clamp() {
    this.words[this.sigBytes >>> 2] &= 4294967295 << 32 - this.sigBytes % 4 * 8;
    this.words.length = Math.ceil(this.sigBytes / 4);
  }
  clone() {
    return new WordArray([...this.words]);
  }
}
const Hex = {
  stringify(wordArray) {
    const hexChars = [];
    for (let i = 0; i < wordArray.sigBytes; i++) {
      const bite = wordArray.words[i >>> 2] >>> 24 - i % 4 * 8 & 255;
      hexChars.push((bite >>> 4).toString(16), (bite & 15).toString(16));
    }
    return hexChars.join("");
  }
};
const Base64 = {
  stringify(wordArray) {
    const keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    const base64Chars = [];
    for (let i = 0; i < wordArray.sigBytes; i += 3) {
      const byte1 = wordArray.words[i >>> 2] >>> 24 - i % 4 * 8 & 255;
      const byte2 = wordArray.words[i + 1 >>> 2] >>> 24 - (i + 1) % 4 * 8 & 255;
      const byte3 = wordArray.words[i + 2 >>> 2] >>> 24 - (i + 2) % 4 * 8 & 255;
      const triplet = byte1 << 16 | byte2 << 8 | byte3;
      for (let j = 0; j < 4 && i * 8 + j * 6 < wordArray.sigBytes * 8; j++) {
        base64Chars.push(keyStr.charAt(triplet >>> 6 * (3 - j) & 63));
      }
    }
    return base64Chars.join("");
  }
};
const Latin1 = {
  parse(latin1Str) {
    const latin1StrLength = latin1Str.length;
    const words = [];
    for (let i = 0; i < latin1StrLength; i++) {
      words[i >>> 2] |= (latin1Str.charCodeAt(i) & 255) << 24 - i % 4 * 8;
    }
    return new WordArray(words, latin1StrLength);
  }
};
const Utf8 = {
  parse(utf8Str) {
    return Latin1.parse(unescape(encodeURIComponent(utf8Str)));
  }
};
class BufferedBlockAlgorithm {
  _data = new WordArray();
  _nDataBytes = 0;
  _minBufferSize = 0;
  blockSize = 512 / 32;
  reset() {
    this._data = new WordArray();
    this._nDataBytes = 0;
  }
  _append(data) {
    if (typeof data === "string") {
      data = Utf8.parse(data);
    }
    this._data.concat(data);
    this._nDataBytes += data.sigBytes;
  }
  _doProcessBlock(_dataWords, _offset) {
  }
  _process(doFlush) {
    let processedWords;
    let nBlocksReady = this._data.sigBytes / (this.blockSize * 4);
    if (doFlush) {
      nBlocksReady = Math.ceil(nBlocksReady);
    } else {
      nBlocksReady = Math.max((nBlocksReady | 0) - this._minBufferSize, 0);
    }
    const nWordsReady = nBlocksReady * this.blockSize;
    const nBytesReady = Math.min(nWordsReady * 4, this._data.sigBytes);
    if (nWordsReady) {
      for (let offset = 0; offset < nWordsReady; offset += this.blockSize) {
        this._doProcessBlock(this._data.words, offset);
      }
      processedWords = this._data.words.splice(0, nWordsReady);
      this._data.sigBytes -= nBytesReady;
    }
    return new WordArray(processedWords, nBytesReady);
  }
}
class Hasher extends BufferedBlockAlgorithm {
  update(messageUpdate) {
    this._append(messageUpdate);
    this._process();
    return this;
  }
  finalize(messageUpdate) {
    if (messageUpdate) {
      this._append(messageUpdate);
    }
  }
}

const H = [
  1779033703,
  -1150833019,
  1013904242,
  -1521486534,
  1359893119,
  -1694144372,
  528734635,
  1541459225
];
const K = [
  1116352408,
  1899447441,
  -1245643825,
  -373957723,
  961987163,
  1508970993,
  -1841331548,
  -1424204075,
  -670586216,
  310598401,
  607225278,
  1426881987,
  1925078388,
  -2132889090,
  -1680079193,
  -1046744716,
  -459576895,
  -272742522,
  264347078,
  604807628,
  770255983,
  1249150122,
  1555081692,
  1996064986,
  -1740746414,
  -1473132947,
  -1341970488,
  -1084653625,
  -958395405,
  -710438585,
  113926993,
  338241895,
  666307205,
  773529912,
  1294757372,
  1396182291,
  1695183700,
  1986661051,
  -2117940946,
  -1838011259,
  -1564481375,
  -1474664885,
  -1035236496,
  -949202525,
  -778901479,
  -694614492,
  -200395387,
  275423344,
  430227734,
  506948616,
  659060556,
  883997877,
  958139571,
  1322822218,
  1537002063,
  1747873779,
  1955562222,
  2024104815,
  -2067236844,
  -1933114872,
  -1866530822,
  -1538233109,
  -1090935817,
  -965641998
];
const W = [];
class SHA256 extends Hasher {
  _hash = new WordArray([...H]);
  /**
   * Resets the internal state of the hash object to initial values.
   */
  reset() {
    super.reset();
    this._hash = new WordArray([...H]);
  }
  _doProcessBlock(M, offset) {
    const H2 = this._hash.words;
    let a = H2[0];
    let b = H2[1];
    let c = H2[2];
    let d = H2[3];
    let e = H2[4];
    let f = H2[5];
    let g = H2[6];
    let h = H2[7];
    for (let i = 0; i < 64; i++) {
      if (i < 16) {
        W[i] = M[offset + i] | 0;
      } else {
        const gamma0x = W[i - 15];
        const gamma0 = (gamma0x << 25 | gamma0x >>> 7) ^ (gamma0x << 14 | gamma0x >>> 18) ^ gamma0x >>> 3;
        const gamma1x = W[i - 2];
        const gamma1 = (gamma1x << 15 | gamma1x >>> 17) ^ (gamma1x << 13 | gamma1x >>> 19) ^ gamma1x >>> 10;
        W[i] = gamma0 + W[i - 7] + gamma1 + W[i - 16];
      }
      const ch = e & f ^ ~e & g;
      const maj = a & b ^ a & c ^ b & c;
      const sigma0 = (a << 30 | a >>> 2) ^ (a << 19 | a >>> 13) ^ (a << 10 | a >>> 22);
      const sigma1 = (e << 26 | e >>> 6) ^ (e << 21 | e >>> 11) ^ (e << 7 | e >>> 25);
      const t1 = h + sigma1 + ch + K[i] + W[i];
      const t2 = sigma0 + maj;
      h = g;
      g = f;
      f = e;
      e = d + t1 | 0;
      d = c;
      c = b;
      b = a;
      a = t1 + t2 | 0;
    }
    H2[0] = H2[0] + a | 0;
    H2[1] = H2[1] + b | 0;
    H2[2] = H2[2] + c | 0;
    H2[3] = H2[3] + d | 0;
    H2[4] = H2[4] + e | 0;
    H2[5] = H2[5] + f | 0;
    H2[6] = H2[6] + g | 0;
    H2[7] = H2[7] + h | 0;
  }
  /**
   * Finishes the hash calculation and returns the hash as a WordArray.
   *
   * @param {string} messageUpdate - Additional message content to include in the hash.
   * @returns {WordArray} The finalised hash as a WordArray.
   */
  finalize(messageUpdate) {
    super.finalize(messageUpdate);
    const nBitsTotal = this._nDataBytes * 8;
    const nBitsLeft = this._data.sigBytes * 8;
    this._data.words[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32;
    this._data.words[(nBitsLeft + 64 >>> 9 << 4) + 14] = Math.floor(
      nBitsTotal / 4294967296
    );
    this._data.words[(nBitsLeft + 64 >>> 9 << 4) + 15] = nBitsTotal;
    this._data.sigBytes = this._data.words.length * 4;
    this._process();
    return this._hash;
  }
}
function sha256base64(message) {
  return new SHA256().finalize(message).toString(Base64);
}

function hash(object, options = {}) {
  const hashed = typeof object === "string" ? object : objectHash(object, options);
  return sha256base64(hashed).slice(0, 10);
}

function murmurHash(key, seed = 0) {
  if (typeof key === "string") {
    key = createBuffer(key);
  }
  let i = 0;
  let h1 = seed;
  let k1;
  let h1b;
  const remainder = key.length & 3;
  const bytes = key.length - remainder;
  const c1 = 3432918353;
  const c2 = 461845907;
  while (i < bytes) {
    k1 = key[i] & 255 | (key[++i] & 255) << 8 | (key[++i] & 255) << 16 | (key[++i] & 255) << 24;
    ++i;
    k1 = (k1 & 65535) * c1 + (((k1 >>> 16) * c1 & 65535) << 16) & 4294967295;
    k1 = k1 << 15 | k1 >>> 17;
    k1 = (k1 & 65535) * c2 + (((k1 >>> 16) * c2 & 65535) << 16) & 4294967295;
    h1 ^= k1;
    h1 = h1 << 13 | h1 >>> 19;
    h1b = (h1 & 65535) * 5 + (((h1 >>> 16) * 5 & 65535) << 16) & 4294967295;
    h1 = (h1b & 65535) + 27492 + (((h1b >>> 16) + 58964 & 65535) << 16);
  }
  k1 = 0;
  switch (remainder) {
    case 3: {
      k1 ^= (key[i + 2] & 255) << 16;
    }
    case 2: {
      k1 ^= (key[i + 1] & 255) << 8;
    }
    case 1: {
      k1 ^= key[i] & 255;
      k1 = (k1 & 65535) * c1 + (((k1 >>> 16) * c1 & 65535) << 16) & 4294967295;
      k1 = k1 << 15 | k1 >>> 17;
      k1 = (k1 & 65535) * c2 + (((k1 >>> 16) * c2 & 65535) << 16) & 4294967295;
      h1 ^= k1;
    }
  }
  h1 ^= key.length;
  h1 ^= h1 >>> 16;
  h1 = (h1 & 65535) * 2246822507 + (((h1 >>> 16) * 2246822507 & 65535) << 16) & 4294967295;
  h1 ^= h1 >>> 13;
  h1 = (h1 & 65535) * 3266489909 + (((h1 >>> 16) * 3266489909 & 65535) << 16) & 4294967295;
  h1 ^= h1 >>> 16;
  return h1 >>> 0;
}
function createBuffer(val) {
  return new TextEncoder().encode(val);
}

function getDatabaseDialect() {
  return getModuleOption("database").startsWith("postgresql:") ? "postgres" : "sqlite";
}
function getDatabaseInfo() {
  const database = getModuleOption("database");
  const dialect = getDatabaseDialect();
  if (dialect === "postgres") {
    const config = pgConnectionString.parse(database);
    return {
      dialect,
      database: config.database || "",
      host: config.host || "",
      port: config.port ? +config.port : 5432,
      username: config.user,
      password: config.password,
      ssl: isString(config.ssl) ? config.ssl === "true" : !!config.ssl
    };
  } else {
    return { dialect, storage: database.slice(7) };
  }
}
function indexName(table, columns, unique = false) {
  const prefix = isArray(columns) && columns.length > 1 ? unique ? "uc" : "cx" : unique ? "ux" : "ix";
  const name = `${prefix}_${table}_${toArray(columns).join("_")}`;
  if (name.length > 63) {
    const suffix = "_" + murmurHash(name).toString(36);
    return name.slice(0, 63 - suffix.length) + suffix;
  }
  return name;
}
function foreignKeyConstraintName(table, column) {
  const name = `fk_${table}_${column}`;
  if (name.length > 63) {
    const suffix = "_" + murmurHash(name).toString(36);
    return name.slice(0, 63 - suffix.length) + suffix;
  }
  return name;
}

function isDebugActive(subject) {
  if (typeof process.env.NODE_DEBUG !== "string") {
    return false;
  }
  return process.env.NODE_DEBUG.split(",").map((e) => e.trim()).some((e) => e === "*" || e === "pruvious" || e === "pruvious:*" || e === `pruvious:${subject}`);
}

const logger = consola.create({}).withTag("pruvious");
function error(message, ...args) {
  logger.error(applyFormats(message, ...args));
}
function success(message, ...args) {
  logger.success(applyFormats(message, ...args));
}
function applyFormats(message, ...args) {
  return [message, ...args].map(
    (text) => text?.toString().replace(/\$(c|g|r|u|y){{(.+?)}}/g, (_, f, value) => {
      const trimmed = value.trim();
      return f === "c" ? cyan(trimmed) : f === "g" ? green(trimmed) : f === "r" ? red(trimmed) : f === "u" ? underline(trimmed) : yellow(trimmed);
    })
  ).join(" ");
}

let rootDir = "";
function resolveAppPath(...path) {
  return resolve$2(rootDir, ...path);
}

const opMap = {
  "=": Op.eq,
  "!=": Op.ne,
  ">": Op.gt,
  ">=": Op.gte,
  "<": Op.lt,
  "<=": Op.lte,
  "between": Op.between,
  "notBetween": Op.notBetween,
  "in": Op.in,
  "notIn": Op.notIn,
  "like": Op.like,
  "notLike": Op.notLike,
  "iLike": Op.iLike,
  "notILike": Op.notILike
};
const opMapSqlite = {
  ...opMap,
  iLike: Op.like,
  notILike: Op.notLike
};
let instance;
let status = "initial";
async function db() {
  if (status === "initial") {
    const { fields, collections } = await Promise.resolve().then(function () { return server$1; });
    if (status === "initial") {
      instance = await rebuildDatabase(fields, collections, false);
    }
  }
  while (status === "rebuilding") {
    await sleep(50);
  }
  return instance;
}
async function rebuildDatabase(fields, collections, log = true) {
  while (status === "rebuilding") {
    await sleep(50);
  }
  status = "rebuilding";
  const start = performance.now();
  const dbInfo = getDatabaseInfo();
  const migration = getModuleOption("migration");
  const options = {
    ...dbInfo,
    dialectOptions: {
      decimalNumbers: true,
      ssl: dbInfo.dialect === "postgres" && dbInfo.ssl ? { require: true, rejectUnauthorized: false } : void 0
    },
    dialectModule: dbInfo.dialect === "postgres" ? pg : void 0,
    logging: isDebugActive("database") ? consola.create({}).withTag("sequelize").log : false
  };
  const singleColletionsTable = getModuleOption("singleCollectionsTable");
  const multiCollections = Object.values(collections).filter(({ mode }) => mode === "multi");
  const standardCollections = getModuleOption("standardCollections");
  instance = new Sequelize(options);
  for (const collection of multiCollections) {
    const tableName = snakeCase(collection.name);
    const attributes = {};
    const indexes = [];
    for (const [fieldName, { type, additional }] of Object.entries(collection.fields)) {
      const columnName = snakeCase(fieldName);
      const field = fields[type];
      attributes[columnName] = columnName === "id" ? { type: DataTypes.BIGINT, primaryKey: true, autoIncrement: true } : { type: field.type.db, allowNull: additional?.nullable !== false };
      if (additional?.index) {
        indexes.push({
          fields: [columnName],
          name: indexName(tableName, columnName)
        });
      }
      if (additional?.unique) {
        indexes.push({
          fields: additional.unique === "perLanguage" ? [columnName, "language"] : [columnName],
          unique: dbInfo.dialect === "postgres",
          // https://github.com/sequelize/sequelize/pull/13647
          name: indexName(tableName, columnName, true)
        });
      }
    }
    if (collection.search) {
      for (const structure of Object.keys(collection.search)) {
        const columnName = `_search_${snakeCase(structure)}`;
        attributes[columnName] = { type: DataTypes.TEXT };
      }
    }
    for (const index of collection.compositeIndexes) {
      const attributes2 = index.map((fieldName) => snakeCase(fieldName));
      indexes.push({
        fields: attributes2,
        name: indexName(tableName, attributes2)
      });
    }
    for (const index of collection.uniqueCompositeIndexes) {
      const attributes2 = index.map((fieldName) => snakeCase(fieldName));
      indexes.push({
        fields: attributes2,
        unique: dbInfo.dialect === "postgres",
        name: indexName(tableName, attributes2, true)
      });
    }
    instance.define(tableName, attributes, {
      indexes,
      freezeTableName: true,
      createdAt: false,
      updatedAt: false
    });
  }
  instance.define(
    "_jobs",
    {
      id: { type: DataTypes.BIGINT, primaryKey: true, autoIncrement: true },
      name: { type: DataTypes.TEXT, allowNull: false },
      args: { type: DataTypes.TEXT, allowNull: false },
      jti: { type: DataTypes.TEXT, allowNull: false },
      priority: { type: DataTypes.INTEGER, allowNull: false },
      created_at: { type: DataTypes.BIGINT, allowNull: false }
    },
    {
      indexes: [
        { fields: ["jti"], name: "ix__jobs_jti" },
        { fields: ["priority", "created_at"], name: "cx__jobs_priority_created_at" }
      ],
      createdAt: false,
      updatedAt: false
    }
  );
  instance.define(
    "_tokens",
    {
      id: { type: DataTypes.BIGINT, primaryKey: true, autoIncrement: true },
      token: { type: DataTypes.TEXT, allowNull: false },
      user_id: { type: DataTypes.BIGINT, allowNull: false },
      iat: { type: DataTypes.INTEGER, allowNull: false },
      exp: { type: DataTypes.INTEGER, allowNull: false }
    },
    {
      indexes: [
        { fields: ["token"], name: "ix__tokens_token" },
        { fields: ["exp"], name: "ix__tokens_exp" }
      ],
      createdAt: false,
      updatedAt: false
    }
  );
  if (standardCollections.uploads) {
    instance.define(
      "_optimized_images",
      {
        id: { type: DataTypes.BIGINT, primaryKey: true, autoIncrement: true },
        upload_id: { type: DataTypes.BIGINT, allowNull: false },
        hash: { type: DataTypes.TEXT, allowNull: false },
        format: { type: DataTypes.TEXT, allowNull: false },
        width: { type: DataTypes.BIGINT },
        height: { type: DataTypes.BIGINT },
        resize: { type: DataTypes.TEXT, allowNull: false },
        without_enlargement: { type: DataTypes.BOOLEAN },
        without_reduction: { type: DataTypes.BOOLEAN },
        position: { type: DataTypes.TEXT, allowNull: false },
        interpolation: { type: DataTypes.TEXT, allowNull: false },
        quality: { type: DataTypes.INTEGER },
        alpha_quality: { type: DataTypes.INTEGER },
        lossless: { type: DataTypes.BOOLEAN },
        near_lossless: { type: DataTypes.BOOLEAN },
        smart_subsample: { type: DataTypes.BOOLEAN }
      },
      {
        indexes: [
          {
            fields: ["upload_id", "hash"],
            unique: dbInfo.dialect === "postgres",
            name: "ux__optimized_images_upload_id_hash"
          }
        ],
        createdAt: false,
        updatedAt: false
      }
    );
  }
  instance.define(
    singleColletionsTable,
    {
      id: { type: DataTypes.BIGINT, primaryKey: true, autoIncrement: true },
      name: { type: DataTypes.TEXT, allowNull: false },
      language: { type: DataTypes.TEXT, allowNull: false },
      data: { type: DataTypes.TEXT, allowNull: false }
    },
    {
      indexes: [
        {
          fields: ["name", "language"],
          unique: dbInfo.dialect === "postgres",
          name: indexName(singleColletionsTable, ["name", "language"], true)
        }
      ],
      createdAt: false,
      updatedAt: false
    }
  );
  try {
    await instance.authenticate();
    if (migration) {
      const tokensTableInitialized = await instance.getQueryInterface().tableExists("_tokens");
      await instance.sync({ alter: true });
      for (const collection of multiCollections) {
        const tableName = snakeCase(collection.name);
        for (const index of await instance.getQueryInterface().showIndex(collection.name)) {
          if (index.name.startsWith("cx_") && !collection.compositeIndexes.some(
            (compositeIndex) => index.fields.map(({ attribute }) => camelCase(attribute)).every((fieldName) => compositeIndex.includes(fieldName))
          )) {
            await instance.getQueryInterface().removeIndex(tableName, index.name);
          } else if (index.name.startsWith("uc_") && !collection.uniqueCompositeIndexes.some(
            (compositeIndex) => index.fields.map(({ attribute }) => camelCase(attribute)).every((fieldName) => compositeIndex.includes(fieldName))
          )) {
            await instance.getQueryInterface().removeIndex(tableName, index.name);
          } else if (index.name.startsWith("ix_") && !collection.fields[camelCase(index.fields[0].attribute)]?.additional?.index && (!collection.search || collection.search[index.fields[0].attribute])) {
            await instance.getQueryInterface().removeIndex(tableName, index.name);
          } else if (index.name.startsWith("ux_") && !collection.fields[camelCase(index.fields[0].attribute)]?.additional?.unique) {
            await instance.getQueryInterface().removeIndex(tableName, index.name);
          }
        }
      }
      const pragma = dbInfo.dialect === "sqlite" ? "PRAGMA foreign_keys = ON; " : "";
      for (const collection of multiCollections) {
        const tableName = snakeCase(collection.name);
        for (const [fieldName, { additional }] of Object.entries(collection.fields)) {
          const columnName = snakeCase(fieldName);
          const constraintName = foreignKeyConstraintName(tableName, columnName);
          await instance.query(`${pragma}ALTER TABLE "${tableName}" DROP CONSTRAINT IF EXISTS "${constraintName}"`);
          if (additional?.foreignKey) {
            await instance.query(
              `${pragma}ALTER TABLE "${tableName}" ADD CONSTRAINT "${constraintName}" FOREIGN KEY ("${columnName}") REFERENCES ${additional.foreignKey.table}(${additional.foreignKey.column ?? "id"}) ${(additional.foreignKey.action ?? ["ON UPDATE RESTRICT", "ON DELETE SET NULL"]).join(" ")}`
            );
          }
        }
      }
      if (!tokensTableInitialized) {
        await instance.query(
          `${pragma}ALTER TABLE _tokens ADD CONSTRAINT fk__tokens_user_id FOREIGN KEY (user_id) REFERENCES users(id) ON UPDATE CASCADE ON DELETE CASCADE`
        );
      }
    }
    if (log) {
      success(`Database synced in ${Math.round(performance.now() - start)} ms`);
    }
  } catch (e) {
    if (h && e.name === "SequelizeUniqueConstraintError" && isArray(e.fields) && e.fields[0] === "id") {
      const match = e.original.toString().match(/([a-z0-9_]+_backup)\.id/);
      if (match && await instance.getQueryInterface().tableExists(match[1])) {
        await instance.getQueryInterface().dropTable(match[1]);
        status = "initial";
        return rebuildDatabase(fields, collections, log);
      }
    } else {
      error(e);
    }
  }
  const autoloadSql = resolveAppPath("./.autoload.sql");
  if (h && dbInfo.dialect === "sqlite" && fs.existsSync(autoloadSql)) {
    const transaction = await instance.transaction({ autocommit: false });
    const buffer = [];
    for (const line of fs.readFileSync(autoloadSql, "utf8").split("\n")) {
      if (line.startsWith("INSERT INTO ") && buffer.length) {
        await instance.query(buffer.join("\n"), { transaction });
        clearArray(buffer);
      }
      buffer.push(line);
    }
    if (buffer.length) {
      await instance.query(buffer.join("\n"), { transaction });
    }
    await transaction.commit();
    fs.removeSync(autoloadSql);
  }
  status = "ready";
  return instance;
}

let client;
function s3Client() {
  if (!client) {
    const options = getModuleOption("uploads");
    if (options.drive.type !== "s3") {
      throw new Error("The S3 client is only available when using the S3 drive");
    }
    client = new S3Client({
      credentials: {
        accessKeyId: options.drive.key,
        secretAccessKey: options.drive.secret
      },
      endpoint: options.drive.endpoint,
      forcePathStyle: !!options.drive.forcePathStyle,
      region: options.drive.region
    });
  }
  return client;
}
async function s3PutObject(key, body, contentType) {
  await s3Client().send(
    new PutObjectCommand({
      Bucket: getModuleOption("uploads").drive.bucket,
      Key: key.replace(/^\//, ""),
      Body: body,
      ContentType: contentType,
      ACL: "public-read"
    })
  );
}
async function s3GetObject(key) {
  const response = await s3Client().send(
    new GetObjectCommand({
      Bucket: getModuleOption("uploads").drive.bucket,
      Key: key.replace(/^\//, "")
    })
  );
  return response.Body?.transformToByteArray();
}
async function s3MoveObject(from, to) {
  const response = await s3Client().send(
    new CopyObjectCommand({
      Bucket: getModuleOption("uploads").drive.bucket,
      CopySource: `${getModuleOption("uploads").drive.bucket}/${from}`,
      Key: to.replace(/^\//, ""),
      ACL: "public-read"
    })
  );
  if (response.$metadata.httpStatusCode === 200) {
    await s3DeleteObject(from.replace(/^\//, ""));
  }
}
async function s3DeleteObject(key) {
  await s3Client().send(
    new DeleteObjectCommand({
      Bucket: getModuleOption("uploads").drive.bucket,
      Key: key.replace(/^\//, "")
    })
  );
}

function matchesConditionalLogic(input, fieldPath, conditionalLogic) {
  for (const [key, condition] of Object.entries(conditionalLogic)) {
    if (key === "$every") {
      if (!condition.every((rule) => matchesConditionalLogic(input, fieldPath, rule))) {
        return false;
      }
    } else if (key === "$some") {
      if (!condition.some((rule) => matchesConditionalLogic(input, fieldPath, rule))) {
        return false;
      }
    } else {
      const dependencyPath = new URL(
        key.replace(/(?<!^|\.)\./gim, "/"),
        `http://_/${fieldPath.replaceAll(".", "/")}`
      ).pathname.slice(1).replaceAll("/", ".").replace(/\.$/, "");
      const dependencyValue = getProperty(input, dependencyPath);
      if (isUndefined(dependencyValue)) {
        throw new Error(`The field '${dependencyPath}' is required in the input`);
      }
      if (isObject(condition)) {
        for (const [operator, value] of Object.entries(condition)) {
          let preparedValue = dependencyValue;
          if (operator === "gt" || operator === "gte" || operator === "lt" || operator === "lte") {
            if (isArray(dependencyValue)) {
              preparedValue = dependencyValue.length;
            } else if (typeof dependencyValue !== typeof value) {
              return false;
            }
          } else if (operator === "regexp" && !isString(dependencyValue)) {
            return false;
          }
          if (operator === "eq" && preparedValue !== value || operator === "ne" && preparedValue === value || operator === "gt" && preparedValue <= value || operator === "gte" && preparedValue < value || operator === "lt" && preparedValue >= value || operator === "lte" && preparedValue > value || operator === "regexp" && !new RegExp(value.toString()).test(preparedValue)) {
            return false;
          }
        }
      } else if (dependencyValue !== condition) {
        return false;
      }
    }
  }
  return true;
}

function parseQSArray(value) {
  if (isString(value)) {
    return uniqueArray(
      value.split(",").map((v) => v.trim()).filter(Boolean)
    );
  } else if (isArray(value)) {
    return uniqueArray(value.map((v) => isString(v) ? v.trim() : "").filter(Boolean));
  }
  return null;
}
function parseWhereTokens(tokens) {
  const result = [];
  let token;
  while (token = tokens.shift()) {
    if (token === "]") {
      return result;
    }
    result.push(token === "[" ? parseWhereTokens(tokens) : token);
  }
  return result;
}
function* tokenize(characters) {
  let token = "";
  let c = "";
  let escape = false;
  while (c = characters.shift()) {
    if ((c === "[" || c === "]") && !escape) {
      if (token) {
        yield token;
        token = "";
      }
      yield c;
    } else if (c === "\\" && !escape) {
      escape = true;
    } else {
      token += c;
      escape = false;
    }
  }
  if (token) {
    yield token;
  }
}

function slugify(string) {
  const charMap = JSON.parse(
    `{"$":"dollar","%":"percent","&":"and","<":"less",">":"greater","|":"or","\xA2":"cent","\xA3":"pound","\xA4":"currency","\xA5":"yen","\xA9":"(c)","\xAA":"a","\xAE":"(r)","\xBA":"o","\xC0":"A","\xC1":"A","\xC2":"A","\xC3":"A","\xC4":"A","\xC5":"A","\xC6":"AE","\xC7":"C","\xC8":"E","\xC9":"E","\xCA":"E","\xCB":"E","\xCC":"I","\xCD":"I","\xCE":"I","\xCF":"I","\xD0":"D","\xD1":"N","\xD2":"O","\xD3":"O","\xD4":"O","\xD5":"O","\xD6":"O","\xD8":"O","\xD9":"U","\xDA":"U","\xDB":"U","\xDC":"U","\xDD":"Y","\xDE":"TH","\xDF":"ss","\xE0":"a","\xE1":"a","\xE2":"a","\xE3":"a","\xE4":"a","\xE5":"a","\xE6":"ae","\xE7":"c","\xE8":"e","\xE9":"e","\xEA":"e","\xEB":"e","\xEC":"i","\xED":"i","\xEE":"i","\xEF":"i","\xF0":"d","\xF1":"n","\xF2":"o","\xF3":"o","\xF4":"o","\xF5":"o","\xF6":"o","\xF8":"o","\xF9":"u","\xFA":"u","\xFB":"u","\xFC":"u","\xFD":"y","\xFE":"th","\xFF":"y","\u0100":"A","\u0101":"a","\u0102":"A","\u0103":"a","\u0104":"A","\u0105":"a","\u0106":"C","\u0107":"c","\u010C":"C","\u010D":"c","\u010E":"D","\u010F":"d","\u0110":"DJ","\u0111":"dj","\u0112":"E","\u0113":"e","\u0116":"E","\u0117":"e","\u0118":"e","\u0119":"e","\u011A":"E","\u011B":"e","\u011E":"G","\u011F":"g","\u0122":"G","\u0123":"g","\u0128":"I","\u0129":"i","\u012A":"i","\u012B":"i","\u012E":"I","\u012F":"i","\u0130":"I","\u0131":"i","\u0136":"k","\u0137":"k","\u013B":"L","\u013C":"l","\u013D":"L","\u013E":"l","\u0141":"L","\u0142":"l","\u0143":"N","\u0144":"n","\u0145":"N","\u0146":"n","\u0147":"N","\u0148":"n","\u014C":"O","\u014D":"o","\u0150":"O","\u0151":"o","\u0152":"OE","\u0153":"oe","\u0154":"R","\u0155":"r","\u0158":"R","\u0159":"r","\u015A":"S","\u015B":"s","\u015E":"S","\u015F":"s","\u0160":"S","\u0161":"s","\u0162":"T","\u0163":"t","\u0164":"T","\u0165":"t","\u0168":"U","\u0169":"u","\u016A":"u","\u016B":"u","\u016E":"U","\u016F":"u","\u0170":"U","\u0171":"u","\u0172":"U","\u0173":"u","\u0174":"W","\u0175":"w","\u0176":"Y","\u0177":"y","\u0178":"Y","\u0179":"Z","\u017A":"z","\u017B":"Z","\u017C":"z","\u017D":"Z","\u017E":"z","\u018F":"E","\u0192":"f","\u01A0":"O","\u01A1":"o","\u01AF":"U","\u01B0":"u","\u01C8":"LJ","\u01C9":"lj","\u01CB":"NJ","\u01CC":"nj","\u0218":"S","\u0219":"s","\u021A":"T","\u021B":"t","\u0259":"e","\u02DA":"o","\u0386":"A","\u0388":"E","\u0389":"H","\u038A":"I","\u038C":"O","\u038E":"Y","\u038F":"W","\u0390":"i","\u0391":"A","\u0392":"B","\u0393":"G","\u0394":"D","\u0395":"E","\u0396":"Z","\u0397":"H","\u0398":"8","\u0399":"I","\u039A":"K","\u039B":"L","\u039C":"M","\u039D":"N","\u039E":"3","\u039F":"O","\u03A0":"P","\u03A1":"R","\u03A3":"S","\u03A4":"T","\u03A5":"Y","\u03A6":"F","\u03A7":"X","\u03A8":"PS","\u03A9":"W","\u03AA":"I","\u03AB":"Y","\u03AC":"a","\u03AD":"e","\u03AE":"h","\u03AF":"i","\u03B0":"y","\u03B1":"a","\u03B2":"b","\u03B3":"g","\u03B4":"d","\u03B5":"e","\u03B6":"z","\u03B7":"h","\u03B8":"8","\u03B9":"i","\u03BA":"k","\u03BB":"l","\u03BC":"m","\u03BD":"n","\u03BE":"3","\u03BF":"o","\u03C0":"p","\u03C1":"r","\u03C2":"s","\u03C3":"s","\u03C4":"t","\u03C5":"y","\u03C6":"f","\u03C7":"x","\u03C8":"ps","\u03C9":"w","\u03CA":"i","\u03CB":"y","\u03CC":"o","\u03CD":"y","\u03CE":"w","\u0401":"Yo","\u0402":"DJ","\u0404":"Ye","\u0406":"I","\u0407":"Yi","\u0408":"J","\u0409":"LJ","\u040A":"NJ","\u040B":"C","\u040F":"DZ","\u0410":"A","\u0411":"B","\u0412":"V","\u0413":"G","\u0414":"D","\u0415":"E","\u0416":"Zh","\u0417":"Z","\u0418":"I","\u0419":"J","\u041A":"K","\u041B":"L","\u041C":"M","\u041D":"N","\u041E":"O","\u041F":"P","\u0420":"R","\u0421":"S","\u0422":"T","\u0423":"U","\u0424":"F","\u0425":"H","\u0426":"C","\u0427":"Ch","\u0428":"Sh","\u0429":"Sh","\u042A":"U","\u042B":"Y","\u042C":"","\u042D":"E","\u042E":"Yu","\u042F":"Ya","\u0430":"a","\u0431":"b","\u0432":"v","\u0433":"g","\u0434":"d","\u0435":"e","\u0436":"zh","\u0437":"z","\u0438":"i","\u0439":"j","\u043A":"k","\u043B":"l","\u043C":"m","\u043D":"n","\u043E":"o","\u043F":"p","\u0440":"r","\u0441":"s","\u0442":"t","\u0443":"u","\u0444":"f","\u0445":"h","\u0446":"c","\u0447":"ch","\u0448":"sh","\u0449":"sh","\u044A":"u","\u044B":"y","\u044C":"","\u044D":"e","\u044E":"yu","\u044F":"ya","\u0451":"yo","\u0452":"dj","\u0454":"ye","\u0456":"i","\u0457":"yi","\u0458":"j","\u0459":"lj","\u045A":"nj","\u045B":"c","\u045D":"u","\u045F":"dz","\u0490":"G","\u0491":"g","\u0492":"GH","\u0493":"gh","\u049A":"KH","\u049B":"kh","\u04A2":"NG","\u04A3":"ng","\u04AE":"UE","\u04AF":"ue","\u04B0":"U","\u04B1":"u","\u04BA":"H","\u04BB":"h","\u04D8":"AE","\u04D9":"ae","\u04E8":"OE","\u04E9":"oe","\u0531":"A","\u0532":"B","\u0533":"G","\u0534":"D","\u0535":"E","\u0536":"Z","\u0537":"E'","\u0538":"Y'","\u0539":"T'","\u053A":"JH","\u053B":"I","\u053C":"L","\u053D":"X","\u053E":"C'","\u053F":"K","\u0540":"H","\u0541":"D'","\u0542":"GH","\u0543":"TW","\u0544":"M","\u0545":"Y","\u0546":"N","\u0547":"SH","\u0549":"CH","\u054A":"P","\u054B":"J","\u054C":"R'","\u054D":"S","\u054E":"V","\u054F":"T","\u0550":"R","\u0551":"C","\u0553":"P'","\u0554":"Q'","\u0555":"O''","\u0556":"F","\u0587":"EV","\u0621":"a","\u0622":"aa","\u0623":"a","\u0624":"u","\u0625":"i","\u0626":"e","\u0627":"a","\u0628":"b","\u0629":"h","\u062A":"t","\u062B":"th","\u062C":"j","\u062D":"h","\u062E":"kh","\u062F":"d","\u0630":"th","\u0631":"r","\u0632":"z","\u0633":"s","\u0634":"sh","\u0635":"s","\u0636":"dh","\u0637":"t","\u0638":"z","\u0639":"a","\u063A":"gh","\u0641":"f","\u0642":"q","\u0643":"k","\u0644":"l","\u0645":"m","\u0646":"n","\u0647":"h","\u0648":"w","\u0649":"a","\u064A":"y","\u064B":"an","\u064C":"on","\u064D":"en","\u064E":"a","\u064F":"u","\u0650":"e","\u0652":"","\u0660":"0","\u0661":"1","\u0662":"2","\u0663":"3","\u0664":"4","\u0665":"5","\u0666":"6","\u0667":"7","\u0668":"8","\u0669":"9","\u067E":"p","\u0686":"ch","\u0698":"zh","\u06A9":"k","\u06AF":"g","\u06CC":"y","\u06F0":"0","\u06F1":"1","\u06F2":"2","\u06F3":"3","\u06F4":"4","\u06F5":"5","\u06F6":"6","\u06F7":"7","\u06F8":"8","\u06F9":"9","\u0E3F":"baht","\u10D0":"a","\u10D1":"b","\u10D2":"g","\u10D3":"d","\u10D4":"e","\u10D5":"v","\u10D6":"z","\u10D7":"t","\u10D8":"i","\u10D9":"k","\u10DA":"l","\u10DB":"m","\u10DC":"n","\u10DD":"o","\u10DE":"p","\u10DF":"zh","\u10E0":"r","\u10E1":"s","\u10E2":"t","\u10E3":"u","\u10E4":"f","\u10E5":"k","\u10E6":"gh","\u10E7":"q","\u10E8":"sh","\u10E9":"ch","\u10EA":"ts","\u10EB":"dz","\u10EC":"ts","\u10ED":"ch","\u10EE":"kh","\u10EF":"j","\u10F0":"h","\u1E62":"S","\u1E63":"s","\u1E80":"W","\u1E81":"w","\u1E82":"W","\u1E83":"w","\u1E84":"W","\u1E85":"w","\u1E9E":"SS","\u1EA0":"A","\u1EA1":"a","\u1EA2":"A","\u1EA3":"a","\u1EA4":"A","\u1EA5":"a","\u1EA6":"A","\u1EA7":"a","\u1EA8":"A","\u1EA9":"a","\u1EAA":"A","\u1EAB":"a","\u1EAC":"A","\u1EAD":"a","\u1EAE":"A","\u1EAF":"a","\u1EB0":"A","\u1EB1":"a","\u1EB2":"A","\u1EB3":"a","\u1EB4":"A","\u1EB5":"a","\u1EB6":"A","\u1EB7":"a","\u1EB8":"E","\u1EB9":"e","\u1EBA":"E","\u1EBB":"e","\u1EBC":"E","\u1EBD":"e","\u1EBE":"E","\u1EBF":"e","\u1EC0":"E","\u1EC1":"e","\u1EC2":"E","\u1EC3":"e","\u1EC4":"E","\u1EC5":"e","\u1EC6":"E","\u1EC7":"e","\u1EC8":"I","\u1EC9":"i","\u1ECA":"I","\u1ECB":"i","\u1ECC":"O","\u1ECD":"o","\u1ECE":"O","\u1ECF":"o","\u1ED0":"O","\u1ED1":"o","\u1ED2":"O","\u1ED3":"o","\u1ED4":"O","\u1ED5":"o","\u1ED6":"O","\u1ED7":"o","\u1ED8":"O","\u1ED9":"o","\u1EDA":"O","\u1EDB":"o","\u1EDC":"O","\u1EDD":"o","\u1EDE":"O","\u1EDF":"o","\u1EE0":"O","\u1EE1":"o","\u1EE2":"O","\u1EE3":"o","\u1EE4":"U","\u1EE5":"u","\u1EE6":"U","\u1EE7":"u","\u1EE8":"U","\u1EE9":"u","\u1EEA":"U","\u1EEB":"u","\u1EEC":"U","\u1EED":"u","\u1EEE":"U","\u1EEF":"u","\u1EF0":"U","\u1EF1":"u","\u1EF2":"Y","\u1EF3":"y","\u1EF4":"Y","\u1EF5":"y","\u1EF6":"Y","\u1EF7":"y","\u1EF8":"Y","\u1EF9":"y","\u2013":"-","\u2018":"'","\u2019":"'","\u201C":"\\"","\u201D":"\\"","\u201E":"\\"","\u2020":"+","\u2022":"*","\u2026":"...","\u20A0":"ecu","\u20A2":"cruzeiro","\u20A3":"french franc","\u20A4":"lira","\u20A5":"mill","\u20A6":"naira","\u20A7":"peseta","\u20A8":"rupee","\u20A9":"won","\u20AA":"new shequel","\u20AB":"dong","\u20AC":"euro","\u20AD":"kip","\u20AE":"tugrik","\u20AF":"drachma","\u20B0":"penny","\u20B1":"peso","\u20B2":"guarani","\u20B3":"austral","\u20B4":"hryvnia","\u20B5":"cedi","\u20B8":"kazakhstani tenge","\u20B9":"indian rupee","\u20BA":"turkish lira","\u20BD":"russian ruble","\u20BF":"bitcoin","\u2120":"sm","\u2122":"tm","\u2202":"d","\u2206":"delta","\u2211":"sum","\u221E":"infinity","\u2665":"love","\u5143":"yuan","\u5186":"yen","\uFDFC":"rial","\uFEF5":"laa","\uFEF7":"laa","\uFEF9":"lai","\uFEFB":"la"}`
  );
  let slug = string.normalize().split("").reduce(function(result, ch) {
    let appendChar = charMap[ch] ?? ch;
    if (appendChar === "-") {
      appendChar = " ";
    }
    return result + appendChar.replace(/[^\w\s$*_+~.()'"!\-:@]+/g, "");
  }, "");
  return slug.trim().replace(/\s+/g, "-").toLowerCase();
}

function replacePlaceholders(text, strings, input = {}) {
  const string = strings[String(text)];
  if (isString(string)) {
    return string;
  } else if (string) {
    const tokens = tokenizePlaceholders(string.pattern);
    for (const token of tokens) {
      if (token.type === "placeholder") {
        const replacements = string.replacements?.[token.value];
        if (isString(replacements)) {
          token.value = replacements;
        } else if (replacements) {
          token.value = "";
          for (const replacement of replacements) {
            if (isString(replacement)) {
              token.value = replacement;
              break;
            } else {
              let pass = true;
              for (const conditionObject of replacement.conditions) {
                if (!pass) break;
                for (const [inputKey, condition] of Object.entries(conditionObject)) {
                  if (!pass) break;
                  const inputValue = input[inputKey] ?? (string.input?.[inputKey] === "boolean" ? false : string.input?.[inputKey] === "number" ? 0 : "");
                  if (isObject(condition)) {
                    for (const [operator, value] of Object.entries(condition)) {
                      if (operator === "eq" && inputValue !== value || operator === "ne" && inputValue === value || operator === "gt" && inputValue <= value || operator === "gte" && inputValue < value || operator === "lt" && inputValue >= value || operator === "lte" && inputValue > value || operator === "regexp" && !new RegExp(value.toString()).test(inputValue.toString())) {
                        pass = false;
                        break;
                      }
                    }
                  } else if (inputValue !== condition) {
                    pass = false;
                    break;
                  }
                }
              }
              if (pass) {
                token.value = replacement.output;
                break;
              }
            }
          }
        } else if (isDefined(input[token.value])) {
          token.value = input[token.value].toString();
        } else {
          token.value = "";
        }
      }
    }
    return tokens.map(({ value }) => value).join("");
  }
  return "";
}
function tokenizePlaceholders(pattern) {
  const tokens = [];
  let i = 0;
  let literal = "";
  while (i < pattern.length) {
    if (pattern[i] === "$") {
      i++;
      if (pattern[i] !== "$") {
        let placeholder = "";
        while (i < pattern.length && isAlphanumeric(pattern[i])) {
          placeholder += pattern[i];
          i++;
        }
        if (placeholder) {
          if (literal) {
            tokens.push({ value: literal, type: "literal" });
            literal = "";
          }
          tokens.push({ value: placeholder, type: "placeholder" });
        }
      } else {
        literal += "$";
        i++;
      }
    } else {
      literal += pattern[i];
      i++;
    }
  }
  if (literal) {
    tokens.push({ value: literal, type: "literal" });
  }
  return tokens;
}

function unifyLiteralStrings(...values) {
  return values.length ? values.sort().map((v) => `'${v.replaceAll("'", "\\'")}'`).join(" | ") : "never";
}

const imageTypes = [
  "image/jpeg",
  "image/png",
  "image/svg+xml",
  "image/webp",
  "image/gif",
  "image/apng",
  "image/avif",
  "image/bmp",
  "image/heic",
  "image/tiff",
  "image/x-icon"
];
function parseMediaDirectoryName(value) {
  let directory = joinRouteParts(value).toLowerCase().slice(1) + "/";
  return directory === "/" ? "" : directory;
}

function getCapabilities(user) {
  return user ? Object.fromEntries(
    [...user.capabilities, ...user.role?.capabilities ?? []].map((capability) => [capability, true])
  ) : {};
}
function hasCapability(user, capability, ...capabilities) {
  const userCapabilities = getCapabilities(user);
  return [capability, ...capabilities].every((c) => userCapabilities[c]);
}

function defineTranslatableStrings(definition) {
  return {
    domain: definition.domain,
    language: definition.language,
    strings: definition.strings,
    api: definition.api ?? true,
    guards: definition.guards ?? []
  };
}

function dbToJsType(type) {
  return type ? type === "TEXT" ? "string" : type === "BOOLEAN" ? "boolean" : "number" : "unknown";
}
function resolveFieldPopulation(population) {
  return population ? {
    type: isString(population.type) ? { js: population.type, ts: population.type } : {
      js: population.type.js,
      ts: population.type.ts || population.type.js
    },
    populator: population.populator
  } : false;
}
function defineField(definition) {
  return {
    name: definition.name,
    type: isString(definition.type) ? {
      js: definition.type,
      ts: definition.type,
      db: definition.type === "boolean" ? "BOOLEAN" : definition.type === "number" ? "DECIMAL" : "TEXT"
    } : {
      js: definition.type.js,
      ts: definition.type.ts || definition.type.js,
      db: definition.type.db || (definition.type.js === "boolean" ? "BOOLEAN" : definition.type.js === "number" ? "DECIMAL" : "TEXT")
    },
    default: definition.default || (() => null),
    vueComponent: definition.vueComponent,
    vuePreviewComponent: definition.vuePreviewComponent ?? "",
    options: definition.options,
    sanitizers: definition.sanitizers || [],
    conditionalLogicMatcher: definition.conditionalLogicMatcher || (({ conditionalLogic, definition: definition2, input, name, options }) => {
      if (!matchesConditionalLogic(input, name, conditionalLogic)) {
        setProperty(input, name, definition2.default({ definition: definition2, name, options }));
        return false;
      }
      return true;
    }),
    validators: definition.validators || [],
    population: resolveFieldPopulation(definition.population),
    extractKeywords: definition.extractKeywords || (({ value }) => isObject(value) ? JSON.stringify(value) : isNull(value) ? "" : String(value)),
    serialize: definition.serialize ?? null,
    deserialize: definition.deserialize ?? null,
    inputMeta: {
      type: definition.inputMeta?.type || ((context) => isString(context.definition.type) ? context.definition.type : (isString(context.definition.type.ts) ? context.definition.type.ts : context.definition.type.ts(context)) || context.definition.type.js),
      required: definition.inputMeta?.required || (() => false),
      codeComment: definition.inputMeta?.codeComment || (() => "")
    }
  };
}

const resolvedCollectionFieldOptions = {};
function resolveCollectionFieldOptions(cacheKey, field, name, options, fields) {
  if (!resolvedCollectionFieldOptions[cacheKey]) {
    resolvedCollectionFieldOptions[cacheKey] = {};
  }
  if (!resolvedCollectionFieldOptions[cacheKey][name]) {
    resolvedCollectionFieldOptions[cacheKey][name] = resolveFieldOptions(field, name, options, fields);
  }
  return resolvedCollectionFieldOptions[cacheKey][name];
}
function resolveFieldOptions(field, name, options, fields) {
  const resolvedOptions = {};
  for (const [optionName, optionDefinition] of Object.entries(fields[field].options)) {
    resolvedOptions[optionName] = options[optionName] ?? (optionDefinition.default ? optionDefinition.default({ definition: fields[field], options, name }) : void 0);
  }
  if (field === "repeater") {
    resolvedOptions.subfields = {};
    for (const [subfieldName, subfieldDefinition] of Object.entries(options.subfields)) {
      resolvedOptions.subfields[subfieldName] = {
        ...subfieldDefinition,
        options: resolveFieldOptions(subfieldDefinition.type, subfieldName, subfieldDefinition.options, fields)
      };
    }
  }
  return resolvedOptions;
}

function defaultSanitizer(context) {
  return isUndefined(context.value) ? context.definition.default(context) : context.value;
}

function requiredValidator(context, customErrorMessage) {
  if (isNull(context.value) || isUndefined(context.value) || isArray(context.value) && !context.value.length || typeof context.value === "boolean" && context.value !== true || typeof context.value === "number" && !isRealNumber(context.value) || typeof context.value === "string" && !context.value) {
    throw new Error(customErrorMessage ?? context.__(context.language, "pruvious-server", "This field is required"));
  }
}

const blockFieldDefinition = defineField({
  name: "block",
  type: { js: "object", ts: "CastedBlockData" },
  default: ({ options }) => options.default ?? null,
  vueComponent: void 0,
  options: {
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'contentBlocks' => 'Content blocks'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "CastedBlockData",
      description: ["The default field value.", "", "@default null"]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    async ({ fields, input, name, operation, query, value }) => {
      if (isObject(value) && isString(value.name) && isObject(value.fields)) {
        const { blocks } = await Promise.resolve().then(function () { return index; });
        const blockDefinition = blocks[value.name];
        if (blockDefinition) {
          for (const fieldName of Object.keys(blockDefinition.fields)) {
            const declaration = blockDefinition.fields[fieldName];
            const definition = declaration ? fields[declaration.type] : void 0;
            if (definition) {
              for (const sanitizer of [...definition.sanitizers, ...declaration.additional?.sanitizers ?? []]) {
                try {
                  if (isFunction(sanitizer) || operation === "create" && sanitizer.onCreate || operation === "update" && sanitizer.onUpdate) {
                    ;
                    value.fields[fieldName] = await (isFunction(sanitizer) ? sanitizer : sanitizer.sanitizer)(
                      {
                        name: `${name}.fields.${fieldName}`,
                        value: value.fields[fieldName],
                        definition,
                        input,
                        options: resolveCollectionFieldOptions(
                          `block:${name}.fields.${fieldName}.${JSON.stringify(declaration.options)}`,
                          declaration.type,
                          fieldName,
                          declaration.options,
                          fields
                        ),
                        fields,
                        operation,
                        query
                      }
                    );
                  }
                } catch {
                }
              }
            }
          }
          for (const slotName of Object.keys(isObject(value.slots) ? value.slots : {})) {
            for (const sanitizer of fields.repeater.sanitizers) {
              try {
                if (isFunction(sanitizer) || operation === "create" && sanitizer.onCreate || operation === "update" && sanitizer.onUpdate) {
                  ;
                  value.slots[slotName] = await (isFunction(sanitizer) ? sanitizer : sanitizer.sanitizer)({
                    name: `${name}.slots.${slotName}`,
                    value: value.slots[slotName],
                    definition: fields.repeater,
                    input,
                    options: resolveCollectionFieldOptions(
                      `block:${name}.slots.${slotName}`,
                      "repeater",
                      slotName,
                      { subfields: { block: { type: "block", options: {} } } },
                      fields
                    ),
                    fields,
                    operation,
                    query
                  });
                }
              } catch {
              }
            }
          }
        }
      }
      return value;
    }
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: requiredValidator
    },
    ({ __, input, language, name, value }) => {
      if (!isObject(value) || Object.keys(value).some((v) => !["name", "fields", "slots"].includes(v)) || !isString(value.name) || !isObject(value.fields) || isDefined(value.slots) && !isObject(value.slots)) {
        setProperty(input, name.split(".").slice(0, -1).join("."), null);
        throw new Error(__(language, "pruvious-server", "Invalid input type"));
      }
    },
    async ({
      _,
      __,
      allInputs,
      collection,
      collections,
      currentQuery,
      errors,
      fields,
      input,
      language,
      name,
      operation,
      query,
      value
    }) => {
      const { blocks } = await Promise.resolve().then(function () { return index; });
      const blockDefinition = blocks[value.name];
      if (blockDefinition) {
        for (const fieldName of Object.keys(value.fields)) {
          const declaration = blockDefinition.fields[fieldName];
          const definition = declaration ? fields[declaration.type] : void 0;
          if (!declaration) {
            errors[`${name}.fields.${fieldName}`] = __(language, "pruvious-server", "Unrecognized field name");
            delete value.fields[fieldName];
            continue;
          }
          if (!definition) {
            errors[`${name}.fields.${fieldName}`] = __(language, "pruvious-server", "Invalid input type");
            delete value.fields[fieldName];
            continue;
          }
        }
        for (const [fieldName, declaration] of Object.entries(blockDefinition.fields)) {
          const definition = fields[declaration.type];
          if (definition) {
            if (declaration.additional?.conditionalLogic) {
              try {
                if (!definition.conditionalLogicMatcher({
                  conditionalLogic: declaration.additional.conditionalLogic,
                  definition,
                  errors,
                  input,
                  name: `${name}.fields.${fieldName}`,
                  options: resolveCollectionFieldOptions(
                    `block:${name}.fields.${fieldName}.${JSON.stringify(declaration.options)}`,
                    declaration.type,
                    fieldName,
                    declaration.options,
                    fields
                  ),
                  value: value.fields[fieldName],
                  fields
                })) {
                  continue;
                }
              } catch (e) {
                errors[`${name}.fields.${fieldName}`] = e.message;
                continue;
              }
            }
            for (const validator of [...definition.validators, ...declaration.additional?.validators ?? []]) {
              try {
                if (isFunction(validator) || operation === "create" && validator.onCreate || operation === "read" && validator.onRead || operation === "update" && validator.onUpdate) {
                  await (isFunction(validator) ? validator : validator.validator)({
                    _,
                    __,
                    allInputs,
                    collection,
                    collections,
                    definition,
                    input,
                    language,
                    name: `${name}.fields.${fieldName}`,
                    operation,
                    options: resolveCollectionFieldOptions(
                      `block:${name}.fields.${fieldName}.${JSON.stringify(declaration.options)}`,
                      declaration.type,
                      fieldName,
                      declaration.options,
                      fields
                    ),
                    value: value.fields[fieldName],
                    currentQuery,
                    query,
                    errors,
                    fields
                  });
                }
              } catch (e) {
                errors[`${name}.fields.${fieldName}`] = e.message;
                setProperty(
                  input,
                  `${name}.fields.${fieldName}`,
                  definition.default({
                    definition,
                    name: `${name}.fields.${fieldName}`,
                    options: resolveCollectionFieldOptions(
                      `block:${name}.fields.${fieldName}.${JSON.stringify(declaration.options)}`,
                      declaration.type,
                      `${name}.fields.${fieldName}`,
                      declaration.options,
                      fields
                    )
                  })
                );
                break;
              }
              if (declaration.type === "repeater") {
                for (const repeaterSubfieldName of Object.keys(errors).filter(
                  (key) => key.startsWith(`${name}.fields.${fieldName}.`) && key.replace(`${name}.fields.${fieldName}.`, "").split(".")[0].match(/^[0-9]+$/)
                )) {
                  const repeaterSubfieldDeclarationPath = repeaterSubfieldName.replace(`${name}.fields.${fieldName}`, "").replace(/\.([0-9]+)\./g, ".options.subfields.").slice(1);
                  const repeaterSubfieldDeclaration = getProperty(declaration, repeaterSubfieldDeclarationPath);
                  if (repeaterSubfieldDeclaration) {
                    const repeaterSubfieldDefinition = fields[repeaterSubfieldDeclaration.type];
                    if (repeaterSubfieldDefinition) {
                      setProperty(
                        input,
                        repeaterSubfieldName,
                        repeaterSubfieldDefinition.default({
                          definition: repeaterSubfieldDefinition,
                          name: repeaterSubfieldName,
                          options: resolveCollectionFieldOptions(
                            `block:${repeaterSubfieldName}.${JSON.stringify(repeaterSubfieldDeclaration.options)}`,
                            repeaterSubfieldDeclaration.type,
                            repeaterSubfieldName,
                            repeaterSubfieldDeclaration.options,
                            fields
                          )
                        })
                      );
                    }
                  }
                }
              }
            }
          }
        }
        value.slots ||= {};
        for (const slotName of Object.keys(value.slots)) {
          if (!blockDefinition.slots[slotName]) {
            errors[`${name}.slots.${slotName}`] = __(language, "pruvious-server", "Unrecognized slot name");
            delete value.slots[slotName];
            continue;
          }
        }
        for (const [slotName, { allowedChildBlocks, label }] of Object.entries(blockDefinition.slots)) {
          if (isDefined(value.slots[slotName])) {
            if (isArray(value.slots[slotName])) {
              const disallowedChildBlocks = [];
              for (const [i, innerBlockValue] of value.slots[slotName].entries()) {
                if (allowedChildBlocks && allowedChildBlocks !== "*" && isObject(innerBlockValue) && isObject(innerBlockValue.block) && isString(innerBlockValue.block.name) && blocks[innerBlockValue.block.name] && !allowedChildBlocks.includes(innerBlockValue.block.name)) {
                  errors[`${name}.slots.${slotName}.${i}`] = __(
                    language,
                    "pruvious-server",
                    "This block is not allowed in the slot '$slot'",
                    { slot: label || titleCase(slotName, false) }
                  );
                  disallowedChildBlocks.push(i);
                }
              }
              for (const validator of fields.repeater.validators) {
                try {
                  if (isFunction(validator) || operation === "create" && validator.onCreate || operation === "read" && validator.onRead || operation === "update" && validator.onUpdate) {
                    await (isFunction(validator) ? validator : validator.validator)({
                      _,
                      __,
                      allInputs,
                      collection,
                      collections,
                      definition: fields.repeater,
                      input,
                      language,
                      name: `${name}.slots.${slotName}`,
                      operation,
                      options: resolveCollectionFieldOptions(
                        `block:${name}.slots.${slotName}`,
                        "repeater",
                        slotName,
                        { subfields: { block: { type: "block", options: {} } } },
                        fields
                      ),
                      value: value.slots[slotName],
                      currentQuery,
                      query,
                      errors,
                      fields
                    });
                  }
                } catch (e) {
                  errors[`${name}.slots.${slotName}`] = e.message;
                  value.slots[slotName] = [];
                  break;
                }
              }
              for (const i of disallowedChildBlocks.reverse()) {
                setProperty(input, `${name}.slots.${slotName}.${i}`, null);
              }
            } else {
              errors[`${name}.slots.${slotName}`] = __(language, "pruvious-server", "Invalid input type");
              value.slots[slotName] = [];
              continue;
            }
          } else {
            value.slots[slotName] = [];
          }
        }
      } else {
        const parentPath = name.split(".").slice(0, -1).join(".");
        if (getProperty(input, parentPath)) {
          errors[parentPath] = __(language, "pruvious-server", "Invalid input type");
          setProperty(input, parentPath, null);
        }
        errors[`${name}.name`] = __(language, "pruvious-server", "Unrecognized block name");
      }
    }
  ],
  population: {
    type: { js: "object", ts: "PopulatedBlockData" },
    populator: async ({ currentQuery, fields, name, query, value }) => {
      if (isObject(value) && isString(value.name) && isObject(value.fields)) {
        const { blocks } = await Promise.resolve().then(function () { return index; });
        const blockDefinition = blocks[value.name];
        if (blockDefinition) {
          currentQuery.maxPopulationDepth ||= {};
          currentQuery.maxPopulationDepth[name] ??= 30;
          currentQuery.maxPopulationDepth[name]--;
          if (currentQuery.maxPopulationDepth[name] <= 0) {
            return null;
          }
          for (const [fieldName, fieldValue] of Object.entries(value.fields)) {
            const declaration = blockDefinition.fields[fieldName];
            const definition = declaration ? fields[declaration.type] : void 0;
            if (definition) {
              const population = declaration.additional?.population ?? definition?.population;
              if (population) {
                value.fields[fieldName] = await population.populator({
                  currentQuery,
                  definition,
                  fields,
                  name: `${name}.fields.${fieldName}`,
                  options: resolveCollectionFieldOptions(
                    `block:${name}.fields.${fieldName}.${JSON.stringify(declaration.options)}`,
                    declaration.type,
                    fieldName,
                    declaration.options,
                    fields
                  ),
                  query,
                  value: fieldValue
                });
              }
            }
          }
          for (const slotName of Object.keys(value.slots ?? {})) {
            value.slots[slotName] = await fields.repeater.population.populator({
              currentQuery,
              definition: fields.repeater,
              fields,
              name: `${name}.slots.${slotName}`,
              options: resolveCollectionFieldOptions(
                `block:${name}.slots.${slotName}`,
                "repeater",
                slotName,
                { subfields: { block: { type: "block", options: {} } } },
                fields
              ),
              query,
              value: value.slots[slotName]
            });
          }
        }
      }
      return value;
    }
  },
  extractKeywords: async ({ collection, collections, fields, fieldValueType, record, value }) => {
    if (isObject(value) && isString(value.name) && isObject(value.fields)) {
      const { blocks } = await Promise.resolve().then(function () { return index; });
      const blockDefinition = blocks[value.name];
      const keywords = [];
      if (blockDefinition) {
        for (const [fieldName, declaration] of Object.entries(blockDefinition.fields)) {
          const definition = fields[declaration.type];
          keywords.push(
            (await definition.extractKeywords({
              collection,
              collections,
              definition,
              fields,
              fieldValueType,
              options: resolveCollectionFieldOptions(
                `block:${fieldName}.fields.${fieldName}.${JSON.stringify(declaration.options)}`,
                declaration.type,
                fieldName,
                declaration.options,
                fields
              ),
              record,
              value: value.fields[fieldName]
            })).trim()
          );
        }
        for (const slotName of Object.keys(blockDefinition.slots)) {
          keywords.push(
            (await fields.repeater.extractKeywords({
              collection,
              collections,
              definition: fields.repeater,
              fields,
              fieldValueType,
              options: resolveCollectionFieldOptions(
                `block:${slotName}.slots.${slotName}`,
                "repeater",
                slotName,
                { subfields: { block: { type: "block", options: {} } } },
                fields
              ),
              record,
              value: value.slots[slotName]
            })).trim()
          );
        }
        return keywords.filter(Boolean).join(" ");
      }
    }
    return "";
  },
  inputMeta: {
    type: "BlockInputData",
    required: () => true,
    codeComment: ({ options }) => options.description || ""
  }
});

function stringSanitizer(context) {
  return isRealNumber(context.value) ? context.value.toString() : context.value;
}

function emailValidator(context, customErrorMessage) {
  if (!isString(context.value) || !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(context.value)) {
    if (context.__ && context.language) {
      throw new Error(
        context.__(context.language, "pruvious-server", customErrorMessage ?? "Invalid email address")
      );
    } else {
      throw new Error(customErrorMessage ?? "Invalid email address");
    }
  }
}
function lowercaseValidator(context, customErrorMessage) {
  if (!isString(context.value) || context.value.toLowerCase() !== context.value) {
    if (context.__ && context.language) {
      throw new Error(
        context.__(
          context.language,
          "pruvious-server",
          customErrorMessage ?? "The value must be a lowercase string"
        )
      );
    } else {
      throw new Error(
        customErrorMessage ?? context.__(context.language, "pruvious-server", "The value must be a lowercase string")
      );
    }
  }
}
function stringValidator(context, customErrorMessage) {
  if (!isString(context.value)) {
    if (context.__ && context.language) {
      throw new Error(
        context.__(context.language, "pruvious-server", customErrorMessage ?? "Invalid input type")
      );
    } else {
      throw new Error(customErrorMessage ?? "Invalid input type");
    }
  }
}
function stringOrNullValidator(context, customErrorMessage) {
  if (!isString(context.value) && !isNull(context.value)) {
    if (context.__ && context.language) {
      throw new Error(
        context.__(context.language, "pruvious-server", customErrorMessage ?? "Invalid input type")
      );
    } else {
      throw new Error(customErrorMessage ?? "Invalid input type");
    }
  }
}

const buttonGroupFieldDefinition = defineField({
  name: "button-group",
  type: {
    js: "string",
    ts: ({ options }) => {
      if (options.overrideType) {
        return options.overrideType;
      }
      const choiceValues = options.choices ? Object.keys(options.choices) : [];
      return unifyLiteralStrings(...choiceValues) + " | null";
    }
  },
  default: ({ options }) => options.default ?? null,
  vueComponent: void 0,
  options: {
    choices: {
      type: "Record<string, string>",
      description: "A key-value object containing permissible choices, where the key represents the choice value, and the value represents the corresponding label.",
      required: true
    },
    required: {
      type: "boolean",
      description: ["Specifies that the field input is mandatory during creation.", "", "@default false"],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'iconSize' => 'Icon size'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "string | null",
      description: ["The default field value.", "", "@default null"]
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input control.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    overrideType: {
      type: "string",
      description: [
        "A **stringified** TypeScript type used for overriding the automatically generated field value type.",
        "This is particularly handy when field types are unavailable during the initial field declaration.",
        "",
        "Note: This feature is only applicable when declaring the field in a collection."
      ]
    }
  },
  sanitizers: [(context) => context.options.required ? context.value : defaultSanitizer(context), stringSanitizer],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    stringOrNullValidator,
    ({ __, language, options, value }) => {
      if (!isNull(value) && !isKeyOf(options.choices, value)) {
        throw new Error(__(language, "pruvious-server", "Invalid value: '$value'", { value: value.toString() }));
      }
    }
  ],
  extractKeywords: ({ options, value }) => value ? isKeyOf(options.choices, value) ? options.choices[value] === value ? value : `${options.choices[value]} ${value.toString()}` : value : "",
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

function uniqueArraySanitizer(context) {
  return isArray(context.value) ? uniqueArray(context.value) : context.value;
}

function arrayValidator(context, customErrorMessage) {
  if (!isArray(context.value)) {
    if (context.__ && context.language) {
      throw new Error(
        context.__(context.language, "pruvious-server", customErrorMessage ?? "Invalid input type")
      );
    } else {
      throw new Error(customErrorMessage ?? "Invalid input type");
    }
  }
}

const checkboxesFieldDefinition = defineField({
  name: "checkboxes",
  type: {
    js: "object",
    ts: ({ options }) => {
      if (options.overrideType) {
        return options.overrideType;
      }
      const choiceValues = options.choices ? Object.keys(options.choices) : [];
      return choiceValues.length ? "(" + unifyLiteralStrings(...choiceValues) + ")[]" : "never";
    }
  },
  default: ({ options }) => options.default ?? [],
  vueComponent: void 0,
  options: {
    choices: {
      type: "Record<string, string>",
      description: "A key-value object containing permissible choices, where the key represents the choice value, and the value represents the corresponding checkbox label.",
      required: true
    },
    required: {
      type: "boolean",
      description: [
        "Indicates whether the field input is mandatory, meaning it must be present during creation, and at least one value must be selected.",
        "",
        "@default false"
      ],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'availableSizes' => 'Available sizes'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "string[]",
      description: ["The default field value.", "", "@default []"]
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input controls.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    sortable: {
      type: "boolean",
      description: ["Indicates whether the checkboxes are sortable.", "", "@default false"],
      default: () => false
    },
    overrideType: {
      type: "string",
      description: [
        "A **stringified** TypeScript type used for overriding the automatically generated field value type.",
        "This is particularly handy when field types are unavailable during the initial field declaration.",
        "",
        "Note: This feature is only applicable when declaring the field in a collection."
      ]
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    uniqueArraySanitizer,
    ({ value }) => value.map((v) => isNumber(v) ? v.toString() : v)
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    arrayValidator,
    ({ __, language, options, value }) => {
      for (const v of value) {
        if (!isString(v)) {
          throw new Error(__(language, "pruvious-server", "Selected values must be strings"));
        } else if (!isKeyOf(options.choices, v)) {
          throw new Error(__(language, "pruvious-server", "Invalid value: '$value'", { value: v }));
        }
      }
    }
  ],
  extractKeywords: ({ options, value }) => isArray(value) ? value.map((v) => {
    const l = options.choices[v]?.trim();
    return l === v ? l : l ? `${l} ${v}` : v;
  }).filter(Boolean).sort().join(" ") : "",
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const chipsFieldDefinition = defineField({
  name: "chips",
  type: {
    js: "object",
    ts: ({ options }) => {
      if (options.overrideType) {
        return options.overrideType;
      } else if (options.allowCustomValues) {
        return "string[]";
      }
      const choiceValues = options.choices ? Object.keys(options.choices) : [];
      return choiceValues.length ? "(" + unifyLiteralStrings(...choiceValues) + ")[]" : "never";
    }
  },
  default: ({ options }) => options.default ?? [],
  vueComponent: void 0,
  options: {
    choices: {
      type: "Record<string, string>",
      description: "A key-value object containing permissible choices, where the key represents the choice value, and the value represents the corresponding chip label.",
      required: true
    },
    required: {
      type: "boolean",
      description: [
        "Indicates whether the field input is mandatory, meaning it must be present during creation, and at least one value must be selected.",
        "",
        "@default false"
      ],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'postTags' => 'Post tags'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "string[]",
      description: ["The default field value.", "", "@default []"]
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input control.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    placeholder: {
      type: "string",
      description: ["Text that appears in the search input when there is no value."]
    },
    sortable: {
      type: "boolean",
      description: ["Indicates whether the chips are sortable.", "", "@default false"],
      default: () => false
    },
    tooltips: {
      type: "boolean",
      description: ["Indicates whether to show chip values as tooltips.", "", "@default false"],
      default: () => false
    },
    allowCustomValues: {
      type: "boolean",
      description: [
        "Indicates whether to allow adding custom values dynamically.",
        "",
        "This will also set the field type to `string[]`.",
        "",
        "@default false"
      ],
      default: () => false
    },
    clearInputOnPick: {
      type: "boolean",
      description: ["Indicates whether to clear the search input after selecting a value.", "", "@default false"],
      default: () => false
    },
    visibleSuggestions: {
      type: "number",
      description: ["The number of visible suggestion choices in the dropdown list (must be less than 30)."],
      default: () => 6
    },
    overrideType: {
      type: "string",
      description: [
        "A **stringified** TypeScript type used for overriding the automatically generated field value type.",
        "This is particularly handy when field types are unavailable during the initial field declaration.",
        "",
        "Note: This feature is only applicable when declaring the field in a collection."
      ]
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    uniqueArraySanitizer,
    ({ value }) => value.map((v) => isNumber(v) ? v.toString() : v)
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    arrayValidator,
    ({ __, language, options, value }) => {
      for (const v of value) {
        if (!isString(v)) {
          throw new Error(__(language, "pruvious-server", "Selected values must be strings"));
        } else if (!options.allowCustomValues && !isKeyOf(options.choices, v)) {
          throw new Error(__(language, "pruvious-server", "Invalid value: '$value'", { value: v }));
        }
      }
    }
  ],
  extractKeywords: ({ options, value }) => isArray(value) ? value.map((v) => {
    const l = options.choices[v]?.trim();
    return l === v ? l : l ? `${l} ${v}` : v;
  }).filter(Boolean).sort().join(" ") : "",
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

function numericSanitizer(context) {
  const casted = isString(context.value) ? +context.value : null;
  return isRealNumber(casted) ? casted : context.value;
}

function numberValidator(context, customErrorMessage) {
  if (!isRealNumber(context.value)) {
    if (context.__ && context.language) {
      throw new Error(
        context.__(context.language, "pruvious-server", customErrorMessage ?? "Invalid input type")
      );
    } else {
      throw new Error(customErrorMessage ?? "Invalid input type");
    }
  }
}
function integerOrNullValidator(context, customErrorMessage) {
  if (!isInteger(context.value) && !isNull(context.value)) {
    if (context.__ && context.language) {
      throw new Error(
        context.__(context.language, "pruvious-server", customErrorMessage ?? "Invalid input type")
      );
    } else {
      throw new Error(customErrorMessage ?? "Invalid input type");
    }
  }
}
function positiveIntegerOrNullValidator(context, customErrorMessage) {
  if (!isPositiveInteger(context.value) && !isNull(context.value)) {
    if (context.__ && context.language) {
      throw new Error(
        context.__(context.language, "pruvious-server", customErrorMessage ?? "Invalid input type")
      );
    } else {
      throw new Error(customErrorMessage ?? "Invalid input type");
    }
  }
}

const fileFieldDefinition = defineField({
  name: "file",
  type: { js: "number", ts: "number | null", db: "BIGINT" },
  default: ({ options }) => options.default ?? null,
  vueComponent: void 0,
  options: {
    fields: {
      type: "Record<string, true> | string[]",
      description: [
        "The fields of the 'uploads' collection to be returned when this field's value is populated.",
        "",
        "@default { directory: true, filename: true }"
      ],
      default: () => ({ directory: true, filename: true })
    },
    populate: {
      type: "boolean",
      description: [
        "Specifies whether to populate the fields of the 'uploads' collection.",
        "The 'uploads' collection does not have fields that can be populated by default.",
        "",
        "@default false"
      ],
      default: () => false
    },
    required: {
      type: "boolean",
      description: ["Specifies whether the field input is required during creation.", "", "@default false"],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'productVideo' => 'Product video'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "number | null",
      description: ["The default field value.", "", "@default null"]
    },
    maxSize: {
      type: "number | string",
      description: [
        "The maximum allowed file size in bytes.",
        "You can provide this limit as a string (e.g., '32 MB') or as an integer, reflecting byte count.",
        "String sizes are parsed using the `bytes` npm package.",
        "",
        "By default there is no limit."
      ]
    },
    allowedTypes: {
      type: "string[]",
      description: [
        "An array of allowed file types or extensions.",
        "",
        "If not specified, all file types are allowed.",
        "",
        "@example",
        "```typescript",
        "['video/quicktime', '.mp4', 'AVI']",
        "```"
      ]
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input control.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    }
  },
  population: {
    type: {
      js: "object",
      ts: ({ options }) => {
        const fields = options.fields ? isObject(options.fields) ? Object.keys(options.fields) : options.fields : ["directory", "filename"];
        return (options.populate ? `Pick<PopulatedFieldType['uploads'], ${unifyLiteralStrings(...fields)}>` : `Pick<CastedFieldType['uploads'], ${unifyLiteralStrings(...fields)}>`) + " | null";
      }
    },
    populator: async ({ currentQuery, name, options, query, value }) => {
      const q = query("uploads");
      q.maxPopulationDepth = currentQuery.maxPopulationDepth ?? {};
      q.maxPopulationDepth[name] ??= 30;
      q.maxPopulationDepth[name]--;
      if (options.populate && q.maxPopulationDepth[name] <= 0) {
        return null;
      }
      try {
        return isPositiveInteger(value) ? await q.select(options.fields).where("id", value).setFieldValueType(options.populate ? "populated" : "casted").first() : null;
      } catch {
        return null;
      }
    }
  },
  sanitizers: [(context) => context.options.required ? context.value : defaultSanitizer(context), numericSanitizer],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    positiveIntegerOrNullValidator,
    async ({ __, language, collections, options, value, query }) => {
      if (value) {
        const upload = await query("uploads").where("id", value).first();
        if (!upload) {
          throw new Error(
            __(language, "pruvious-server", "The $item does not exist", {
              item: __(language, "pruvious-server", collections["uploads"].label.collection.singular)
            })
          );
        }
        if (isDefined(options.maxSize)) {
          const maxSize = isNumber(options.maxSize) ? options.maxSize : parse(options.maxSize);
          if (upload.size > maxSize) {
            throw new Error(
              __(language, "pruvious-server", "The maximum allowable file size is $size", {
                size: format(maxSize, {
                  unitSeparator: " "
                }) ?? "unknown"
              })
            );
          }
        }
        if (isDefined(options.allowedTypes)) {
          const extension = upload.filename.split(".").pop() ?? "";
          const allowedTypes = options.allowedTypes.map((type) => type.toLowerCase());
          if (!allowedTypes.some(
            (type) => type.includes("/") ? type === upload.type : type.replace(/^\./, "") === extension
          )) {
            throw new Error(
              __(language, "pruvious-server", "The file type must be one of the following: $types", {
                types: allowedTypes.map((type) => type.startsWith(".") ? type.slice(1) : type).sort().join(", ")
              })
            );
          }
        }
      }
    }
  ],
  extractKeywords: async ({ collections, fields, fieldValueType, options, record, value }) => {
    if (fieldValueType === "populated") {
      try {
        const collection = collections.uploads;
        const keywords = [];
        const fieldNames = isObject(options.fields) ? Object.keys(options.fields) : options.fields;
        for (const fieldName of fieldNames) {
          const declaration = collection.fields[fieldName];
          const definition = fields[declaration.type];
          keywords.push(
            (await definition.extractKeywords({
              collection,
              collections,
              definition,
              fields,
              fieldValueType,
              options: resolveCollectionFieldOptions(
                `record:${collection.name}.${fieldName}.${JSON.stringify(declaration)}`,
                declaration.type,
                fieldName,
                declaration.options,
                fields
              ),
              record,
              value: value[fieldName]
            })).trim()
          );
        }
        return keywords.join(" ");
      } catch {
      }
    }
    return isObject(value) ? JSON.stringify(value) : isNull(value) ? "" : String(value);
  },
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const recordFieldDefinition = defineField({
  name: "record",
  type: { js: "number", ts: "number | null", db: "BIGINT" },
  default: ({ options }) => options.default ?? null,
  vueComponent: void 0,
  options: {
    collection: {
      type: "MultiCollectionName",
      description: "The name of the multi-entry collection from which to retrieve a record.",
      required: true
    },
    fields: {
      type: "Record<string, true> | string[]",
      description: [
        "The fields of the selected collection to be returned when this field's value is populated.",
        "",
        "@default { id: true }"
      ],
      default: () => ({ id: true })
    },
    populate: {
      type: "boolean",
      description: [
        "Specifies whether to populate the fields of the selected collection.",
        "Exercise **caution** when using this option, as it may trigger infinite loops during population if the related collection fields depend on additional population loops.",
        "",
        "@default false"
      ],
      default: () => false
    },
    required: {
      type: "boolean",
      description: ["Specifies whether the field input is required during creation.", "", "@default false"],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'parentPage' => 'Parent page'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "number | null",
      description: ["The default field value.", "", "@default null"]
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input control.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    placeholder: {
      type: "string",
      description: ["Text that appears in the input element when it has no value set."]
    },
    clearable: {
      type: "boolean",
      description: [
        "A boolean indicating whether to display a clear button that removes the current input value.",
        "",
        "@default true"
      ],
      default: () => true
    },
    visibleChoices: {
      type: "number",
      description: ["The number of visible choices in the dropdown list (must be less than 30)."],
      default: () => 6
    },
    recordLabel: {
      type: "string | [string, string]",
      description: [
        "The collection field or fields used as the record label.",
        "When using multiple fields, the first field is used as the main label, and the second field is displayed only in search results.",
        "",
        "By default, the fields from the `dashboard.primaryField` and `dashboard.overviewTable.searchLabel` options of the selected collection are used."
      ]
    },
    details: {
      type: "string[]",
      description: [
        "An array of field names from the selected collection to display below the select input for the selected record.",
        "",
        "@default []"
      ],
      default: () => []
    }
  },
  population: {
    type: {
      js: "object",
      ts: ({ options }) => {
        const fields = options.fields ? isObject(options.fields) ? Object.keys(options.fields) : options.fields : ["id"];
        return (options.populate ? `Pick<PopulatedFieldType['${options.collection}'], ${unifyLiteralStrings(...fields)}>` : `Pick<CastedFieldType['${options.collection}'], ${unifyLiteralStrings(...fields)}>`) + " | null";
      }
    },
    populator: async ({ currentQuery, name, options, query, value }) => {
      const q = query(options.collection);
      q.maxPopulationDepth = currentQuery.maxPopulationDepth ?? {};
      q.maxPopulationDepth[name] ??= 30;
      q.maxPopulationDepth[name]--;
      if (options.populate && q.maxPopulationDepth[name] <= 0) {
        return null;
      }
      try {
        return isPositiveInteger(value) ? await q.select(options.fields).where("id", value).setFieldValueType(options.populate ? "populated" : "casted").first() : null;
      } catch {
        return null;
      }
    }
  },
  sanitizers: [(context) => context.options.required ? context.value : defaultSanitizer(context), numericSanitizer],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    positiveIntegerOrNullValidator,
    async ({ __, collections, language, value, options, query }) => {
      if (value && await query(options.collection).where("id", value).notExists()) {
        throw new Error(
          __(language, "pruvious-server", "The $item does not exist", {
            item: __(
              language,
              "pruvious-server",
              collections[options.collection].label.collection.singular
            )
          })
        );
      }
    }
  ],
  extractKeywords: async ({ collections, fields, fieldValueType, options, record, value }) => {
    if (fieldValueType === "populated") {
      try {
        const collection = collections[options.collection];
        const keywords = [];
        const fieldNames = isObject(options.fields) ? Object.keys(options.fields) : options.fields;
        for (const fieldName of fieldNames) {
          const declaration = collection.fields[fieldName];
          const definition = fields[declaration.type];
          keywords.push(
            (await definition.extractKeywords({
              collection,
              collections,
              definition,
              fields,
              fieldValueType,
              options: resolveCollectionFieldOptions(
                `record:${collection.name}.${fieldName}.${JSON.stringify(declaration)}`,
                declaration.type,
                fieldName,
                declaration.options,
                fields
              ),
              record,
              value: value[fieldName]
            })).trim()
          );
        }
        return keywords.join(" ");
      } catch {
      }
    }
    return isObject(value) ? JSON.stringify(value) : isNull(value) ? "" : String(value);
  },
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const recordsFieldDefinition = defineField({
  name: "records",
  type: { js: "object", ts: "number[]" },
  default: ({ options }) => options.default ?? [],
  vueComponent: void 0,
  options: {
    collection: {
      type: "MultiCollectionName",
      description: "The name of the multi-entry collection from which to retrieve the records.",
      required: true
    },
    fields: {
      type: "Record<string, true> | string[]",
      description: [
        "The fields of the selected collection to be returned when this field's values are populated.",
        "",
        "@default { id: true }"
      ],
      default: () => ({ id: true })
    },
    populate: {
      type: "boolean",
      description: [
        "Specifies whether to populate the fields of the selected collection.",
        "Exercise **caution** when using this option, as it may trigger infinite loops during population if the related collection fields depend on additional population loops.",
        "",
        "@default false"
      ],
      default: () => false
    },
    required: {
      type: "boolean",
      description: [
        "Indicates whether the field input is mandatory, meaning it must be present during creation, and at least one record must be selected.",
        "",
        "@default false"
      ],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'categories' => 'Categories'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "number[]",
      description: ["The default field value.", "", "@default []"],
      default: () => []
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input control.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    placeholder: {
      type: "string",
      description: ["Text that appears in the search input when there is no value."]
    },
    sortable: {
      type: "boolean",
      description: ["Indicates whether the records are sortable.", "", "@default false"],
      default: () => false
    },
    visibleChoices: {
      type: "number",
      description: ["The number of visible choices in the dropdown list (must be less than 30)."],
      default: () => 6
    },
    recordLabel: {
      type: "string | [string, string]",
      description: [
        "The collection field or fields used as the record label.",
        "When using multiple fields, the first field is used as the main label, and the second field is displayed only in search results.",
        "",
        "By default, the fields from the `dashboard.primaryField` and `dashboard.overviewTable.searchLabel` options of the selected collection are used."
      ]
    },
    details: {
      type: "string[]",
      description: ["An array of field names from the selected collection to display in tooltips.", "", "@default []"],
      default: () => []
    }
  },
  population: {
    type: {
      js: "object",
      ts: ({ options }) => {
        const fields = options.fields ? isObject(options.fields) ? Object.keys(options.fields) : options.fields : ["id"];
        return (options.populate ? `Pick<PopulatedFieldType['${options.collection}'], ${unifyLiteralStrings(...fields)}>` : `Pick<CastedFieldType['${options.collection}'], ${unifyLiteralStrings(...fields)}>`) + "[]";
      }
    },
    populator: async ({ currentQuery, name, options, query, value }) => {
      const populated = [];
      for (const v of value) {
        const q = query(options.collection);
        q.maxPopulationDepth = currentQuery.maxPopulationDepth ?? {};
        q.maxPopulationDepth[name] ??= 30;
        q.maxPopulationDepth[name]--;
        if (options.populate && q.maxPopulationDepth[name] <= 0) {
          continue;
        }
        try {
          const record = isPositiveInteger(v) ? await q.select(options.fields).where("id", v).setFieldValueType(options.populate ? "populated" : "casted").first() : null;
          if (record) {
            populated.push(record);
          }
        } catch {
        }
      }
      return populated;
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    ({ value }) => isArray(value) ? value.map((v) => numericSanitizer({ value: v })) : value,
    uniqueArraySanitizer
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    arrayValidator,
    ({ __, language, value }) => {
      if (!value.every(isPositiveInteger)) {
        throw new Error(__(language, "pruvious-server", "Invalid input type"));
      }
    },
    async ({ __, collections, errors, language, name, value, options, query }) => {
      for (const [i, v] of value.entries()) {
        if (await query(options.collection).where("id", v).notExists()) {
          errors[`${name}.${i}`] = __(language, "pruvious-server", "The $item does not exist", {
            item: __(
              language,
              "pruvious-server",
              collections[options.collection].label.collection.singular
            )
          });
        }
      }
    }
  ],
  extractKeywords: async ({ collections, fields, fieldValueType, options, record, value }) => {
    if (fieldValueType === "populated") {
      try {
        const collection = collections[options.collection];
        const keywords = [];
        const fieldNames = isObject(options.fields) ? Object.keys(options.fields) : options.fields;
        for (const v of value) {
          for (const fieldName of fieldNames) {
            const declaration = collection.fields[fieldName];
            const definition = fields[declaration.type];
            keywords.push(
              (await definition.extractKeywords({
                collection,
                collections,
                definition,
                fields,
                fieldValueType,
                options: resolveCollectionFieldOptions(
                  `records:${collection.name}.${fieldName}.${JSON.stringify(declaration)}`,
                  declaration.type,
                  fieldName,
                  declaration.options,
                  fields
                ),
                record,
                value: v[fieldName]
              })).trim()
            );
          }
        }
        return keywords.join(" ");
      } catch {
      }
    }
    return isObject(value) ? JSON.stringify(value) : isNull(value) ? "" : String(value);
  },
  serialize: (value) => JSON.stringify(isArray(value) ? value.map(String) : []),
  deserialize: (value) => JSON.parse(value).map(Number),
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const repeaterFieldDefinition = defineField({
  name: "repeater",
  type: {
    js: "object",
    ts: ({ fields, options }) => {
      if (options.overrideType) {
        return options.overrideType;
      }
      const result = ["{"];
      for (const [subfieldName, subfieldDeclaration] of Object.entries(
        options.subfields
      )) {
        const definition = fields[subfieldDeclaration.type];
        const options2 = resolveCollectionFieldOptions(
          `repeater:${JSON.stringify(subfieldDeclaration.options)}`,
          subfieldDeclaration.type,
          subfieldName,
          subfieldDeclaration.options,
          fields
        );
        const type = isString(definition.type.ts) ? definition.type.ts : definition.type.ts({ definition, fields, name: subfieldName, options: options2 });
        const codeComment = definition.inputMeta.codeComment({ definition, name: subfieldName, options: options2 });
        if (codeComment && toArray(codeComment).length) {
          result.push("/**");
          for (const line of toArray(codeComment)) {
            result.push(` * ${line}`);
          }
          result.push(" */");
        }
        result.push(`${subfieldName}: ${type}`);
      }
      result.push("}[]", "");
      return result.join("\n");
    }
  },
  default: ({ options }) => options.default ?? [],
  vueComponent: void 0,
  options: {
    subfields: {
      type: `Record<string, Field & { additional?: FieldAdditional }>`,
      description: [
        "An object of subfields that define the structure of each repeater entry.",
        "",
        "@example",
        "```typescript",
        "{",
        "  name: { type: 'text' },",
        "  age: { type: 'number', required: true },",
        "}",
        "```"
      ],
      required: true
    },
    required: {
      type: "boolean",
      description: [
        "Specifies that the field input is mandatory during creation, requiring at least one entry.",
        "",
        "@default false"
      ],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'productVariations' => 'Product variations'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "Record<string, any>[]",
      description: ["The default field value.", "", "@default []"]
    },
    fieldLayout: {
      type: "FieldLayout[] | undefined",
      description: [
        "Defines the field layout in the repeater.",
        "",
        "The layout array accepts the following values:",
        "",
        "- **`string`** - The subfield name.",
        "- **`string[]`** - An array of subfield names that will be displayed in a row.",
        "- **`Record<string, FieldLayout[]>`** - A tabbed layout.",
        "- **`'<./components/CustomComponent.vue>'`**- A Vue component path relative to the project root.",
        "",
        "If not specified, all displayable subfields will be shown vertically one after another.",
        "",
        "Custom components can be used to display additional information about the collection.",
        "They receive the following props:",
        "",
        "- **`record`** - The current record.",
        "- **`errors`** - A key-value object with field names (in dot-notation) as keys and error messages as values.",
        "- **`disabled`** - A boolean indicating whether the user has permission to create or edit the record.",
        "- **`compact`** - A boolean indicating whether the component is displayed in a compact mode.",
        "",
        "@example",
        "```typescript",
        "[",
        "  'name',                   // Single field",
        "  ['email', 'phone | 40%'], // Two fields in a row",
        "  {",
        "    'Tab 1': ['street', 'city', 'zip'],       // Three fields in a row",
        "    'Tab 2': ['<./component/CustomMap.vue>'], // Vue component path relative to the project root",
        "  }",
        "]",
        "```"
      ]
    },
    min: {
      type: "number",
      description: ["The minimum allowed number of repeater entries.", "", "@default 0"],
      default: () => 0
    },
    max: {
      type: "number",
      description: ["The maximum allowed number of repeater entries.", "", "@default Number.MAX_SAFE_INTEGER"],
      default: () => Number.MAX_SAFE_INTEGER
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    addLabel: {
      type: "string",
      description: ["The text label displayed on the button used to add a new repeater item."],
      default: () => "Add item"
    },
    overrideType: {
      type: "string",
      description: [
        "A **stringified** TypeScript type used for overriding the automatically generated field value type.",
        "This is particularly handy when field types are unavailable during the initial field declaration.",
        "",
        "Note: This feature is only applicable when declaring the field in a collection."
      ]
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    async ({ fields, input, name, operation, options, query, value }) => {
      if (isArray(value)) {
        for (const [i, entry] of value.entries()) {
          if (isObject(entry)) {
            for (const [subfieldName, declaration] of Object.entries(
              options.subfields
            )) {
              const definition = declaration ? fields[declaration.type] : void 0;
              if (definition) {
                for (const sanitizer of [...definition.sanitizers, ...declaration.additional?.sanitizers ?? []]) {
                  try {
                    if (isFunction(sanitizer) || operation === "create" && sanitizer.onCreate || operation === "update" && sanitizer.onUpdate) {
                      ;
                      entry[subfieldName] = await (isFunction(sanitizer) ? sanitizer : sanitizer.sanitizer)({
                        name: `${name}.${i}.${subfieldName}`,
                        value: entry[subfieldName],
                        definition,
                        input,
                        options: resolveCollectionFieldOptions(
                          `repeater:${JSON.stringify(declaration.options)}`,
                          declaration.type,
                          subfieldName,
                          declaration.options,
                          fields
                        ),
                        fields,
                        operation,
                        query
                      });
                    }
                  } catch {
                  }
                }
              }
            }
          }
        }
      }
      return value;
    }
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    arrayValidator,
    ({ __, language, value, options }) => {
      if (isDefined(options.min) && value.length < options.min) {
        throw new Error(
          __(language, "pruvious-server", "The repeater must have at least $count $entries", { count: options.min })
        );
      }
    },
    ({ __, language, value, options }) => {
      if (isDefined(options.max) && value.length > options.max) {
        throw new Error(
          __(language, "pruvious-server", "The repeater must not exceed $count $entries", { count: options.max })
        );
      }
    },
    async ({
      _,
      __,
      allInputs,
      collection,
      collections,
      currentQuery,
      errors,
      fields,
      input,
      language,
      name,
      operation,
      options,
      query,
      value
    }) => {
      for (const [i, entry] of value.entries()) {
        if (isObject(entry)) {
          for (const subfieldName of Object.keys(entry)) {
            const declaration = options.subfields[subfieldName];
            const definition = declaration ? fields[declaration.type] : void 0;
            if (!declaration) {
              errors[`${name}.${i}.${subfieldName}`] = __(language, "pruvious-server", "Unrecognized field name");
              delete entry[subfieldName];
              continue;
            }
            if (!definition) {
              errors[`${name}.${i}.${subfieldName}`] = __(language, "pruvious-server", "Invalid input type");
              delete entry[subfieldName];
              continue;
            }
          }
          for (const [subfieldName, declaration] of Object.entries(
            options.subfields
          )) {
            const definition = declaration ? fields[declaration.type] : void 0;
            if (definition) {
              for (const validator of [...definition.validators, ...declaration.additional?.validators ?? []]) {
                if (declaration.additional?.conditionalLogic) {
                  try {
                    if (!definition.conditionalLogicMatcher({
                      conditionalLogic: declaration.additional.conditionalLogic,
                      definition,
                      errors,
                      input,
                      name: `${name}.${i}.${subfieldName}`,
                      options: resolveCollectionFieldOptions(
                        `repeater:${JSON.stringify(declaration.options)}`,
                        declaration.type,
                        subfieldName,
                        declaration.options,
                        fields
                      ),
                      value: entry[subfieldName],
                      fields
                    })) {
                      continue;
                    }
                  } catch (e) {
                    errors[`${name}.${i}.${subfieldName}`] = e.message;
                    continue;
                  }
                }
                try {
                  if (isFunction(validator) || operation === "create" && validator.onCreate || operation === "read" && validator.onRead || operation === "update" && validator.onUpdate) {
                    await (isFunction(validator) ? validator : validator.validator)({
                      _,
                      __,
                      allInputs,
                      collection,
                      collections,
                      definition,
                      input,
                      language,
                      name: `${name}.${i}.${subfieldName}`,
                      operation,
                      options: resolveCollectionFieldOptions(
                        `repeater:${JSON.stringify(declaration.options)}`,
                        declaration.type,
                        subfieldName,
                        declaration.options,
                        fields
                      ),
                      value: entry[subfieldName],
                      currentQuery,
                      query,
                      errors,
                      fields
                    });
                  }
                } catch (e) {
                  errors[`${name}.${i}.${subfieldName}`] = e.message;
                  break;
                }
              }
            }
          }
        } else {
          errors[`${name}.${i}`] = __(language, "pruvious-server", "Invalid input type");
          value[i] = null;
        }
      }
    }
  ],
  population: {
    type: {
      js: "object",
      ts: ({ fields, options }) => {
        if (options.overrideType) {
          return options.overrideType;
        }
        const result = ["{"];
        for (const [subfieldName, subfieldDeclaration] of Object.entries(
          options.subfields
        )) {
          const definition = fields[subfieldDeclaration.type];
          const options2 = resolveCollectionFieldOptions(
            `repeater:${JSON.stringify(subfieldDeclaration.options)}`,
            subfieldDeclaration.type,
            subfieldName,
            subfieldDeclaration.options,
            fields
          );
          const population = subfieldDeclaration.additional?.population ? resolveFieldPopulation(subfieldDeclaration.additional.population) : definition.population;
          const codeComment = definition.inputMeta.codeComment({ definition, name: subfieldName, options: options2 });
          if (codeComment && toArray(codeComment).length) {
            result.push("/**");
            for (const line of toArray(codeComment)) {
              result.push(` * ${line}`);
            }
            result.push(" */");
          }
          const type = population ? isString(population.type.ts) ? population.type.ts : population.type.ts({ definition, fields, name: subfieldName, options: options2 }) : isString(definition.type.ts) ? definition.type.ts : definition.type.ts({ definition, fields, name: subfieldName, options: options2 });
          result.push(`${subfieldName}: ${type}`);
        }
        result.push("}[]", "");
        return result.join("\n");
      }
    },
    populator: async ({ currentQuery, fields, name, options, query, value }) => {
      if (isArray(value)) {
        currentQuery.maxPopulationDepth ||= {};
        currentQuery.maxPopulationDepth[name] ??= 30;
        currentQuery.maxPopulationDepth[name]--;
        if (currentQuery.maxPopulationDepth[name] <= 0) {
          return [];
        }
        for (const [i, entry] of value.entries()) {
          if (isObject(entry)) {
            for (const [subfieldName, subfieldDeclaration] of Object.entries(
              options.subfields
            )) {
              const definition = fields[subfieldDeclaration.type];
              const population = subfieldDeclaration.additional?.population ?? definition?.population;
              if (population) {
                entry[subfieldName] = await population.populator({
                  currentQuery,
                  definition,
                  fields,
                  name: `${name}.${i}.${subfieldName}`,
                  options: resolveCollectionFieldOptions(
                    `repeater:${JSON.stringify(subfieldDeclaration.options)}`,
                    subfieldDeclaration.type,
                    subfieldName,
                    subfieldDeclaration.options,
                    fields
                  ),
                  query,
                  value: entry[subfieldName]
                });
              }
            }
          }
        }
      }
      return value;
    }
  },
  extractKeywords: async ({ collection, collections, fields, fieldValueType, options, record, value }) => {
    if (isArray(value)) {
      const keywords = [];
      for (const entry of value.values()) {
        if (isObject(entry)) {
          for (const [subfieldName, subfieldDeclaration] of Object.entries(
            options.subfields
          )) {
            const definition = fields[subfieldDeclaration.type];
            keywords.push(
              (await definition.extractKeywords({
                collection,
                collections,
                definition,
                fields,
                fieldValueType,
                options: resolveCollectionFieldOptions(
                  `repeater:${JSON.stringify(subfieldDeclaration.options)}`,
                  subfieldDeclaration.type,
                  subfieldName,
                  subfieldDeclaration.options,
                  fields
                ),
                record,
                value: entry[subfieldName]
              })).trim()
            );
          }
        }
      }
      return keywords.filter(Boolean).join(" ");
    }
    return "";
  },
  inputMeta: {
    type({ fields, options }) {
      const result = ["{"];
      for (const [subfieldName, subfieldDeclaration] of Object.entries(
        options.subfields
      )) {
        const definition = fields[subfieldDeclaration.type];
        const options2 = resolveCollectionFieldOptions(
          `repeater:${JSON.stringify(subfieldDeclaration.options)}`,
          subfieldDeclaration.type,
          subfieldName,
          subfieldDeclaration.options,
          fields
        );
        const codeComment = definition.inputMeta.codeComment({ definition, name: subfieldName, options: options2 });
        if (codeComment && toArray(codeComment).length) {
          result.push("/**");
          for (const line of toArray(codeComment)) {
            result.push(` * ${line}`);
          }
          result.push(" */");
        }
        if (definition.inputMeta.type) {
          const type = isString(definition.inputMeta.type) ? definition.inputMeta.type : definition.inputMeta.type({ definition, fields, name: subfieldName, options: options2 });
          result.push(`${subfieldName}: ${type}`);
        } else {
          const type = isString(definition.type.ts) ? definition.type.ts : definition.type.ts({ definition, fields, name: subfieldName, options: options2 });
          result.push(`${subfieldName}: ${type}`);
        }
      }
      result.push("}[]", "");
      return result.join("\n");
    },
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const selectFieldDefinition = defineField({
  name: "select",
  type: {
    js: "string",
    ts: ({ options }) => {
      if (options.overrideType) {
        return options.overrideType;
      }
      const choiceValues = options.choices ? Object.keys(options.choices) : [];
      return unifyLiteralStrings(...choiceValues) + " | null";
    }
  },
  default: ({ options }) => options.default ?? null,
  vueComponent: void 0,
  options: {
    choices: {
      type: "Record<string, string>",
      description: "A key-value object containing permissible choices, where the key represents the choice value, and the value represents the corresponding label.",
      required: true
    },
    required: {
      type: "boolean",
      description: ["Specifies that the field input is mandatory during creation.", "", "@default false"],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'iconSize' => 'Icon size'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "string | null",
      description: ["The default field value.", "", "@default null"]
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input control.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    placeholder: {
      type: "string",
      description: ["Text that appears in the input element when it has no value set."]
    },
    clearable: {
      type: "boolean",
      description: [
        "A boolean indicating whether to display a clear button that sets the input value to `null`.",
        "",
        "@default false"
      ],
      default: () => false
    },
    visibleChoices: {
      type: "number",
      description: ["The number of visible choices in the dropdown list (must be less than 30)."],
      default: () => 6
    },
    overrideType: {
      type: "string",
      description: [
        "A **stringified** TypeScript type used for overriding the automatically generated field value type.",
        "This is particularly handy when field types are unavailable during the initial field declaration.",
        "",
        "Note: This feature is only applicable when declaring the field in a collection."
      ]
    }
  },
  sanitizers: [(context) => context.options.required ? context.value : defaultSanitizer(context), stringSanitizer],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    stringOrNullValidator,
    ({ __, language, options, value }) => {
      if (!isNull(value) && !isKeyOf(options.choices, value)) {
        throw new Error(__(language, "pruvious-server", "Invalid value: '$value'", { value: value.toString() }));
      }
    }
  ],
  extractKeywords: ({ options, value }) => value ? isKeyOf(options.choices, value) ? options.choices[value] === value ? value : `${options.choices[value]} ${value.toString()}` : value : "",
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const sizeFieldDefinition = defineField({
  name: "size",
  type: {
    js: "object",
    ts: ({ options }) => {
      const inputs = options.inputs ?? { width: {}, height: {} };
      return `{ ${Object.entries(inputs).map(
        ([key, input]) => `${key}: { value: number` + (isArray(input.units) ? `; unit: ${unifyLiteralStrings(...input.units)}` : "") + ` }`
      ).join(", ")} }`;
    }
  },
  default: ({ options }) => options.default ?? "",
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: ["Specifies that the field input is mandatory during creation.", "", "@default false"],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'imageSize' => 'Image size'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    inputs: {
      type: "Record<string, SizeInput>",
      description: [
        "A record of subfields that make up the field.",
        "The keys of the record are used as the subfield names.",
        "",
        "@default { width: {}, height: {} }"
      ],
      default: () => ({ width: {}, height: {} })
    },
    default: {
      type: "Record<string, { value: number; unit?: string }>",
      description: [
        "The default field value.",
        "",
        "By default, all defined size `inputs` are set to their `min` value and first unit in the a `units` array."
      ],
      default: ({ options }) => {
        const inputs = options.inputs ?? { width: {}, height: {} };
        return Object.keys(inputs).reduce((acc, key) => {
          acc[key] = inputs[key].default ?? { value: inputs[key].min ?? 0, unit: inputs[key].units?.[0] };
          return acc;
        }, {});
      }
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the base `name` for the input controls.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    syncable: {
      type: "boolean",
      description: ["Whether the size values can be synchronized in the field UI.", "", "@default false"],
      default: () => false
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    ({ options, value }) => {
      const inputs = options.inputs ?? { width: {}, height: {} };
      if (isString(value) || isNumber(value)) {
        const numeric = numericSanitizer({ value });
        if (isRealNumber(numeric)) {
          return Object.keys(inputs).reduce((acc, key) => {
            acc[key] = { value: numeric };
            return acc;
          }, {});
        }
      } else if (isObject(value)) {
        return Object.keys(value).reduce((acc, key) => {
          const numeric = numericSanitizer({ value: value[key] });
          acc[key] = isRealNumber(numeric) ? { value: numeric } : value[key];
          return acc;
        }, {});
      }
      return value;
    }
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    ({ __, language, options, value }) => {
      const inputs = options.inputs ?? { width: {}, height: {} };
      if (!isNull(value) && (!isObject(value) || JSON.stringify(Object.keys(value).sort()) !== JSON.stringify(Object.keys(inputs).sort()) || Object.values(value).some(
        (input) => !isObject(input) || Object.keys(input).some((key) => key !== "value" && key !== "unit")
      ))) {
        throw new Error(__(language, "pruvious-server", "Invalid input type"));
      }
    },
    ({ __, language, options, value }) => {
      const inputs = options.inputs ?? { width: {}, height: {} };
      for (const [key, input] of Object.entries(value)) {
        const def = inputs[key];
        if (!isRealNumber(input.value)) {
          throw new Error(
            __(language, "pruvious-server", "The '$name' value must be numeric", {
              name: __(language, "pruvious-dashboard", inputs[key].label ?? titleCase(key))
            })
          );
        } else if (input.value < (def.min ?? 0)) {
          throw new Error(
            __(language, "pruvious-server", "The '$name' value must be greater than or equal to $min", {
              name: __(language, "pruvious-dashboard", inputs[key].label ?? titleCase(key)),
              min: def.min ?? 0
            })
          );
        } else if (input.value > (def.max ?? Number.MAX_SAFE_INTEGER)) {
          throw new Error(
            __(language, "pruvious-server", "The '$name' value must be less than or equal to $max", {
              name: __(language, "pruvious-dashboard", inputs[key].label ?? titleCase(key)),
              max: def.max ?? Number.MAX_SAFE_INTEGER
            })
          );
        } else if (def.units?.length && (!input.unit || !def.units.includes(input.unit))) {
          throw new Error(
            __(language, "pruvious-server", "Invalid '$name' unit", {
              name: __(language, "pruvious-dashboard", inputs[key].label ?? titleCase(key))
            })
          );
        }
      }
    }
  ],
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const textFieldDefinition = defineField({
  name: "text",
  type: { js: "string", ts: ({ options }) => options.overrideType ?? "string" },
  default: ({ options }) => options.default ?? "",
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: [
        "Specifies that the input field is mandatory during creation and cannot have an empty string value.",
        "",
        "@default false"
      ],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'firstName' => 'First name'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "string",
      description: ["The default field value.", "", "@default ''"],
      default: () => ""
    },
    trim: {
      type: "boolean",
      description: ["Specifies whether to remove whitespace from both ends of the input string.", "", "@default true"],
      default: () => true
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input control, influencing autocomplete behavior in some browsers.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    type: {
      type: "string",
      description: ["Input `type` of the control.", "", "@default 'text'"],
      default: () => "text"
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    placeholder: {
      type: "string",
      description: ["Text that appears in the input element when it has no value set."]
    },
    autocomplete: {
      type: "string",
      description: [
        "A string specifying autocomplete behavior for the input element.",
        "",
        "@default 'off'",
        "",
        "@see https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/autocomplete"
      ],
      default: () => "off"
    },
    spellcheck: {
      type: "boolean | 'true' | 'false'",
      description: [
        "A booleanish value indicating whether spellchecking is enabled for the input element.",
        "",
        "@default 'false'"
      ],
      default: () => "false"
    },
    prefix: {
      type: "string",
      description: ["A short text to be prepended before the input element."]
    },
    suffix: {
      type: "string",
      description: ["A short text to be appended after the input element."]
    },
    clearable: {
      type: "boolean",
      description: [
        "A boolean indicating whether to display a clear button that removes the current input text.",
        "",
        "@default false"
      ],
      default: () => false
    },
    overrideType: {
      type: "string",
      description: [
        "A **stringified** TypeScript type used for overriding the automatically generated field value type.",
        "This is particularly handy when field types are unavailable during the initial field declaration.",
        "",
        "Note: This feature is only applicable when declaring the field in a collection."
      ]
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    ({ value, options }) => options.trim && isString(value) ? value.trim() : value,
    stringSanitizer
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    stringValidator
  ],
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

async function uniqueValidator(context, customErrorMessage) {
  if (context.operation === "read") {
    return;
  }
  const query = context.currentQuery;
  const errorMessage = customErrorMessage ?? context.__(context.language, "pruvious-server", "This field must be unique");
  const unique = getProperty(
    context.collection?.fields ?? {},
    context.name.replace(/\.([0-9]+)\./g, ".options.subfields.")
  )?.additional?.unique ?? "perLanguage";
  if (unique === "allLanguages") {
    if (context.allInputs?.some((input) => input !== context.input && input[context.name] === context.value)) {
      throw new Error(errorMessage);
    }
    if (context.operation === "create" && await query.clone().reset().where(context.name, context.value).exists()) {
      throw new Error(errorMessage);
    }
    if (context.operation === "update") {
      const subjects = await query.clone().clearGroup().clearOffset().clearLimit().select({ id: true }).all();
      if (subjects.length > 1) {
        throw new Error(errorMessage);
      } else if (subjects.length === 1 && await query.clone().reset().where(context.name, context.value).whereNe("id", subjects[0].id).exists()) {
        throw new Error(errorMessage);
      }
    }
  } else {
    const primaryLanguage = getModuleOption("language").primary;
    if (context.allInputs?.some(
      (input) => input !== context.input && input[context.name] === context.value && (input.language ?? primaryLanguage) === (context.input.language ?? primaryLanguage)
    )) {
      throw new Error(errorMessage);
    }
    if (context.operation === "create" && await query.clone().reset().where(context.name, context.value).where("language", context.input.language ?? primaryLanguage).exists()) {
      throw new Error(errorMessage);
    }
    if (context.operation === "update") {
      const subjects = await query.clone().clearGroup().clearOffset().clearLimit().select({ id: true, language: true }).all();
      if (subjects.length > 1) {
        throw new Error(errorMessage);
      } else if (subjects.length === 1 && await query.clone().reset().where(context.name, context.value).where("language", subjects[0].language).whereNe("id", subjects[0].id).exists()) {
        throw new Error(errorMessage);
      }
    }
  }
}

function defineCollection(definition) {
  const d = definition;
  const translatable = d.translatable ?? false;
  const createdAtField = d.createdAtField ?? "createdAt";
  const updatedAtField = d.updatedAtField ?? "updatedAt";
  const timestamps = {};
  const defaultLabel = isString(d.label) ? d.label : titleCase(d.name, false).toLowerCase();
  const label = {
    collection: isObject(d.label) && isObject(d.label.collection) ? d.label.collection : isObject(d.label) && isString(d.label.collection) ? { singular: pluralize.singular(d.label.collection), plural: d.label.collection } : { singular: pluralize.singular(defaultLabel), plural: defaultLabel },
    record: isObject(d.label) && isObject(d.label.record) ? d.label.record : isObject(d.label) && isString(d.label.record) ? { singular: pluralize.singular(d.label.record), plural: d.label.record } : { singular: pluralize.singular(defaultLabel), plural: defaultLabel }
  };
  if (createdAtField) {
    timestamps[createdAtField] = {
      type: "date-time",
      options: {
        label: "Created at",
        description: `The timestamp indicating when the ${label.record.singular} was created.`
      },
      additional: {
        index: true,
        immutable: true,
        validators: [
          {
            onCreate: true,
            validator: ({ __, language }) => {
              throw new Error(__(language, "pruvious-server", "This field is read-only"));
            }
          }
        ]
      }
    };
  }
  if (updatedAtField) {
    timestamps[updatedAtField] = {
      type: "date-time",
      options: {
        label: "Updated at",
        description: `The timestamp indicating when the ${label.record.singular} was last updated.`
      },
      additional: {
        index: true,
        immutable: true,
        validators: [
          {
            onCreate: true,
            validator: ({ __, language }) => {
              throw new Error(__(language, "pruvious-server", "This field is read-only"));
            }
          }
        ]
      }
    };
  }
  const baseFields = {
    id: {
      type: "number",
      options: {
        label: "ID",
        description: `The unique identifier of the ${label.record.singular}.`
      },
      additional: {
        immutable: true,
        validators: [
          {
            onCreate: true,
            validator: ({ __, language }) => {
              throw new Error(__(language, "pruvious-server", "This field is read-only"));
            }
          }
        ]
      }
    },
    language: {
      type: "select",
      options: {
        description: [
          "The language code associated with this collection record.",
          "",
          "If not provided, the code of the primary language will be used."
        ],
        default: primaryLanguage,
        choices: Object.fromEntries(languageLabels.map(({ code, name }) => [code, name]))
      },
      additional: {
        index: translatable,
        immutable: true,
        nullable: false,
        validators: [
          ({ __, language, value }) => {
            if (!translatable && value !== primaryLanguage) {
              throw new Error(__(language, "pruvious-server", "This collection does not support translations"));
            }
          }
        ]
      }
    }
  };
  if (d.mode === "multi") {
    baseFields.translations = {
      type: "text",
      options: {
        description: d.mode === "multi" ? [
          "Represents a unique identifier that groups records as translations of each other.",
          "When populated, this field resolves to a key-value object.",
          "The key represents he language code, and the value is the corresponding record's ID or `null` if no record in this language exists.",
          "",
          "If the collection is not translatable, the populated value is `null`.",
          "",
          "Defaults to an automatically generated unique string."
        ] : [
          "Represents a unique identifier that groups records as translations of each other.",
          "",
          "Defaults to an automatically generated unique string."
        ]
      },
      additional: {
        unique: "perLanguage",
        immutable: true,
        nullable: false,
        sanitizers: [({ value }) => value || nanoid()],
        validators: [
          async (context) => uniqueValidator(context, context.__(context.language, "pruvious-server", "The translation already exists"))
        ],
        population: {
          type: { js: "object", ts: "Record<SupportedLanguage, number | null> | null" },
          populator: async ({ value, currentQuery }) => {
            if (d.translatable && isString(value)) {
              const translations = Object.fromEntries(
                supportedLanguages.map((language) => [language, null])
              );
              for (const { id, language } of await currentQuery.clone().reset().select({ id: true, language: true }).where("translations", value).all()) {
                if (isKeyOf(translations, language)) {
                  translations[language] = id;
                }
              }
              return translations;
            }
            return null;
          }
        }
      }
    };
  }
  const customFields = objectOmit(d.fields, ["id", "language", "translations"]);
  const fields = { ...baseFields, ...customFields, ...timestamps };
  const dashboard = {
    visible: d.dashboard?.visible ?? true,
    icon: d.dashboard?.icon ?? (d.mode === "multi" ? "Pin" : "Settings"),
    primaryField: d.dashboard?.primaryField,
    fieldLayout: d.dashboard?.fieldLayout ?? [
      ...Object.entries(fields).filter(
        ([fieldName, field]) => !field.additional?.protected && (!d.contentBuilder || fieldName !== d.contentBuilder.blocksField) && fieldName !== "id" && fieldName !== "language" && fieldName !== "translations" && fieldName !== createdAtField && fieldName !== updatedAtField
      ).map(([fieldName]) => fieldName),
      ...d.contentBuilder ? ["translations"] : []
    ],
    overviewTable: {
      columns: d.dashboard?.overviewTable?.columns?.map((item) => isString(item) ? { field: item } : item) ?? [
        ...Object.keys(customFields).length ? Object.entries(customFields).filter(([_, field]) => !field.additional?.protected).slice(0, 6 - Object.keys(timestamps).length).map(([fieldName], i) => ({ field: fieldName, width: i === 0 ? 30 : void 0 })) : [{ field: "id" }],
        ...Object.keys(timestamps).map((field) => ({ field, width: 13 }))
      ],
      sort: d.dashboard?.overviewTable?.sort ?? {
        field: createdAtField || updatedAtField || Object.keys(customFields)[0] || "id",
        direction: "desc"
      },
      perPage: d.dashboard?.overviewTable?.perPage ?? 50,
      searchLabel: d.dashboard?.overviewTable?.searchLabel ? isString(d.dashboard?.overviewTable.searchLabel) ? [d.dashboard?.overviewTable.searchLabel, null] : d.dashboard?.overviewTable.searchLabel : [Object.keys(customFields)[0] ?? "id", null],
      additionalTableRowOptionsVueComponent: d.dashboard?.overviewTable?.additionalTableRowOptionsVueComponent
    },
    additionalRecordOptionsVueComponent: d.dashboard?.additionalRecordOptionsVueComponent
  };
  return {
    name: d.name,
    label,
    mode: d.mode,
    fields,
    translatable,
    apiRoutes: {
      create: d.apiRoutes === false ? false : isDefined(d.apiRoutes?.create) ? d.apiRoutes.create : "private",
      createMany: d.apiRoutes === false ? false : isDefined(d.apiRoutes?.createMany) ? d.apiRoutes.createMany : "private",
      read: d.apiRoutes === false ? false : isDefined(d.apiRoutes?.read) ? d.apiRoutes.read : "private",
      readMany: d.apiRoutes === false ? false : isDefined(d.apiRoutes?.readMany) ? d.apiRoutes.readMany : "private",
      update: d.apiRoutes === false ? false : isDefined(d.apiRoutes?.update) ? d.apiRoutes.update : "private",
      updateMany: d.apiRoutes === false ? false : isDefined(d.apiRoutes?.updateMany) ? d.apiRoutes.updateMany : "private",
      delete: d.apiRoutes === false ? false : isDefined(d.apiRoutes?.delete) ? d.apiRoutes.delete : "private",
      deleteMany: d.apiRoutes === false ? false : isDefined(d.apiRoutes?.deleteMany) ? d.apiRoutes.deleteMany : "private"
    },
    guards: d.guards ?? [],
    publicPages: d.publicPages ? {
      pathField: d.publicPages.pathField ?? "path",
      pathPrefix: isString(d.publicPages.pathPrefix) ? joinRouteParts(d.publicPages.pathPrefix).slice(1) : isObject(d.publicPages.pathPrefix) ? Object.fromEntries(
        Object.entries(d.publicPages.pathPrefix).map(([language, prefix]) => [
          language,
          joinRouteParts(prefix).slice(1)
        ])
      ) : "",
      publicField: d.publicPages.publicField ?? false,
      draftTokenField: d.publicPages.draftTokenField ?? false,
      publishDateField: d.publicPages.publishDateField ?? false,
      layoutField: d.publicPages.layoutField ?? false,
      additionalFields: d.publicPages.additionalFields ?? [],
      seo: d.publicPages.seo
    } : false,
    contentBuilder: d.contentBuilder ? { allowedBlocks: "*", rootBlocks: "*", ...d.contentBuilder } : false,
    dashboard,
    createdAtField,
    updatedAtField,
    cacheQueries: d.cacheQueries ?? 10,
    clearCacheRules: d.clearCacheRules ?? { onCreate: true, onUpdate: true, onDelete: true },
    nonCachedFields: d.nonCachedFields ?? [],
    search: d.search ?? false,
    compositeIndexes: d.compositeIndexes ?? [],
    uniqueCompositeIndexes: d.uniqueCompositeIndexes ?? [],
    duplicate: d.duplicate ?? false,
    mirrorTranslation: d.mirrorTranslation ?? (({ from, language }) => ({ ...from, language }))
  };
}

function defineHook(collection, action, callback) {
  return { collection, action, callback };
}

function defineJob(definition) {
  return {
    name: definition.name,
    callback: definition.callback,
    priority: definition.priority ?? 10,
    interval: definition.interval ?? false,
    beforeProcess: definition.beforeProcess,
    afterProcess: definition.afterProcess
  };
}

const supportedLanguages = ["en", "ru", "ky"];
const primaryLanguage = "ru";
const languageLabels = [{ name: "English", code: "en" }, { name: "\u0420\u0443\u0441\u0441\u043A\u0438\u0439", code: "ru" }, { name: "\u041A\u044B\u0440\u0433\u044B\u0437\u0447\u0430", code: "ky" }];
function recordFieldTrap(options, additional) {
  return { type: "record", options: options || {}, additional, __fromDefineProps: true };
}
const icons = [];
const collectionCapabilities = ["collection-presets-create", "collection-presets-create-many", "collection-presets-read", "collection-presets-read-many", "collection-presets-update", "collection-presets-update-many", "collection-presets-delete", "collection-presets-delete-many", "collection-previews-create", "collection-previews-create-many", "collection-previews-read", "collection-previews-read-many", "collection-previews-update", "collection-previews-update-many", "collection-previews-delete", "collection-previews-delete-many", "collection-redirects-read", "collection-redirects-update", "collection-roles-create", "collection-roles-create-many", "collection-roles-read", "collection-roles-read-many", "collection-roles-update", "collection-roles-update-many", "collection-roles-delete", "collection-roles-delete-many", "collection-seo-read", "collection-seo-update", "collection-uploads-create", "collection-uploads-create-many", "collection-uploads-read", "collection-uploads-read-many", "collection-uploads-update", "collection-uploads-update-many", "collection-uploads-delete", "collection-uploads-delete-many", "collection-users-create", "collection-users-create-many", "collection-users-read", "collection-users-read-many", "collection-users-update", "collection-users-update-many", "collection-users-delete", "collection-users-delete-many", "collection-form-submissions-create", "collection-form-submissions-create-many", "collection-form-submissions-read", "collection-form-submissions-read-many", "collection-form-submissions-update", "collection-form-submissions-update-many", "collection-form-submissions-delete", "collection-form-submissions-delete-many", "collection-forms-create", "collection-forms-create-many", "collection-forms-read", "collection-forms-read-many", "collection-forms-update", "collection-forms-update-many", "collection-forms-delete", "collection-forms-delete-many", "collection-news-create", "collection-news-create-many", "collection-news-read", "collection-news-read-many", "collection-news-update", "collection-news-update-many", "collection-news-delete", "collection-news-delete-many", "collection-pages-create", "collection-pages-create-many", "collection-pages-read", "collection-pages-read-many", "collection-pages-update", "collection-pages-update-many", "collection-pages-delete", "collection-pages-delete-many", "collection-server-read", "collection-server-update", "collection-settings-read", "collection-settings-update"];
const userCapabilities = ["access-dashboard", "clear-cache", "update-profile", ...collectionCapabilities];
const layouts = [{ name: "default", label: "Default" }];

const index$1 = /*#__PURE__*/Object.freeze(/*#__PURE__*/Object.defineProperty({
  __proto__: null,
  camelCase: camelCase,
  capitalize: capitalize,
  catchFirstErrorMessage: catchFirstErrorMessage,
  clearArray: clearArray,
  clearObject: clearObject,
  collator: collator,
  collectionCapabilities: collectionCapabilities,
  countDecimals: countDecimals,
  deepClone: deepClone,
  deepMerge: deepMerge,
  defineCollection: defineCollection,
  defineField: defineField,
  defineHook: defineHook,
  defineJob: defineJob,
  defineTranslatableStrings: defineTranslatableStrings,
  deleteProperty: deleteProperty,
  extractKeywords: extractKeywords,
  getCapabilities: getCapabilities,
  getProperty: getProperty,
  getTranslationPrefix: getTranslationPrefix,
  hasCapability: hasCapability,
  icons: icons,
  imageTypes: imageTypes,
  isAlphanumeric: isAlphanumeric,
  isArray: isArray,
  isBoolean: isBoolean,
  isDefined: isDefined,
  isFile: isFile,
  isFunction: isFunction,
  isInteger: isInteger,
  isKeyOf: isKeyOf,
  isNull: isNull,
  isNumber: isNumber,
  isObject: isObject,
  isPositiveInteger: isPositiveInteger,
  isRealNumber: isRealNumber,
  isString: isString,
  isUndefined: isUndefined,
  isUrl: isUrl,
  isUrlPath: isUrlPath,
  joinRouteParts: joinRouteParts,
  kebabCase: kebabCase,
  languageLabels: languageLabels,
  layouts: layouts,
  matchesConditionalLogic: matchesConditionalLogic,
  mergeDefaults: mergeDefaults,
  objectOmit: objectOmit,
  objectPick: objectPick,
  parseMediaDirectoryName: parseMediaDirectoryName,
  parseQSArray: parseQSArray,
  parseWhereTokens: parseWhereTokens,
  primaryLanguage: primaryLanguage,
  recordFieldTrap: recordFieldTrap,
  removeAccents: removeAccents,
  replacePlaceholders: replacePlaceholders,
  resolveCollectionPathPrefix: resolveCollectionPathPrefix,
  setProperty: setProperty,
  sleep: sleep,
  slugify: slugify,
  snakeCase: snakeCase,
  snakeCasePropNames: snakeCasePropNames,
  sortNaturalByProp: sortNaturalByProp,
  stringifySymbols: stringifySymbols,
  supportedLanguages: supportedLanguages,
  titleCase: titleCase,
  toArray: toArray,
  tokenize: tokenize,
  tokenizePlaceholders: tokenizePlaceholders,
  unifyLiteralStrings: unifyLiteralStrings,
  uniqueArray: uniqueArray,
  userCapabilities: userCapabilities,
  walkObject: walkObject
}, Symbol.toStringTag, { value: 'Module' }));

function __(eventOrLanguage, domain, text, input) {
  const options = getModuleOption("language");
  const primaryLanguage = options.primary;
  const language = isString(eventOrLanguage) ? eventOrLanguage : eventOrLanguage.context.language;
  const ts = translatableStrings[domain];
  if (ts?.[language] && ts[language].strings[text]) {
    return replacePlaceholders(text, ts[language].strings, input);
  } else if (ts?.[primaryLanguage] && ts[primaryLanguage].strings[text]) {
    return replacePlaceholders(text, ts[primaryLanguage].strings, input);
  }
  return text;
}
function _(eventOrLanguage, text, input) {
  return __(eventOrLanguage, "default", text, input);
}

class QueryBuilder {
  constructor(collection, contextLanguage = primaryLanguage) {
    this.collection = collection;
    this.contextLanguageOption = contextLanguage;
    this.dialect = getDatabaseDialect();
    this.table = snakeCase(collection);
    this.selectAll();
  }
  dialect;
  table;
  selectedFields = [];
  whereOptions = { [Op.and]: [] };
  searchOptions = {};
  orderOptions = [];
  groupOptions = [];
  offsetOption;
  limitOption;
  populateOption = false;
  fallbackOption = true;
  contextLanguageOption;
  /**
   * Apply query string parameters to the current query.
   *
   * @example
   * ```typescript
   * export default defineEventHandler((event) => {
   *   const qs = getQueryStringParams(event, 'products')
   *
   *   if (qs.errors.length) {
   *     setResponseStatus(event, 400)
   *     return qs.errors.join('\n')
   *   }
   *
   *   return query('products').applyQueryStringParams(qs.params).all()
   * })
   * ```
   */
  applyQueryStringParams(params) {
    if (isKeyOf(params, "select")) this.selectedFields = uniqueArray(params.select);
    if (isKeyOf(params, "where")) this.whereOptions = params.where;
    if (isKeyOf(params, "search")) this.searchOptions = params.search;
    if (isKeyOf(params, "group")) this.groupOptions = params.group;
    if (isKeyOf(params, "offset")) this.offsetOption = params.offset;
    if (isKeyOf(params, "limit")) this.limitOption = params.limit;
    if (isKeyOf(params, "order")) this.orderOptions = params.order;
    if (isKeyOf(params, "populate")) this.populateOption = params.populate;
    return this;
  }
  /**
   * Specify the `fields` to be selected and returned from the query.
   *
   * @example
   * ```typescript
   * // Selects the 'name' and 'price' fields from the 'products' collection
   * await query('products').select({ name: true, price: true }).first()
   * // Output: { name: '...', price: '...' }
   * ```
   */
  select(fields2) {
    clearArray(this.selectedFields).push(...isArray(fields2) ? uniqueArray(fields2) : Object.keys(fields2));
    return this;
  }
  /**
   * Select all fields from the queried collection.
   *
   * @example
   * ```typescript
   * // Select all fields from the 'products' collection
   * await query('products').selectAll().first()
   * // Output: { field1: '...', field2: '...', ... }
   * ```
   */
  selectAll() {
    const collection = collections[this.collection];
    clearArray(this.selectedFields).push(...Object.keys(collection.fields));
    return this;
  }
  /**
   * Exclude specified `fields` from the query result.
   *
   * @example
   * ```typescript
   * // Don't return the 'secret' field from the 'products' collection
   * const product = await query('products').deselect({ secret: true }).first()
   * console.log(product.secret)
   * // Output: undefined
   * ```
   */
  deselect(fields2) {
    const fieldsObj = isArray(fields2) ? Object.fromEntries(fields2.map((field) => [field, true])) : fields2;
    this.selectedFields = this.selectedFields.filter((fieldName) => !fieldsObj[fieldName]);
    return this;
  }
  /**
   * Specify a filtering condition for a specific `field` in the database query.
   */
  where(field, operatorOrValue, value) {
    const op = isUndefined(value) ? Op.eq : (this.dialect === "postgres" ? opMap : opMapSqlite)[operatorOrValue];
    if (op) {
      this.addFilter({ [field]: { [op]: isDefined(value) ? value : operatorOrValue } });
    }
    return this;
  }
  /**
   * Specify a filtering condition for a specific field in the database query.
   *
   * @example
   * ```typescript
   * // Apply a filtering condition: status = 'active'
   * query('products').whereEq('status', 'active')
   *
   * // Alternatives:
   * query('products').where('status', 'active')
   * query('products').where('status', '=', 'active')
   * ```
   */
  whereEq(field, value) {
    return this.where(field, value);
  }
  /**
   * Specify a filtering condition for a specific field in the database query.
   *
   * @example
   * ```typescript
   * // Apply a filtering condition: discount != null
   * query('products').whereNe('discount', null)
   *
   * // Alternative:
   * query('products').where('discount', '!=', null)
   * ```
   */
  whereNe(field, value) {
    return this.where(field, "!=", value);
  }
  /**
   * Specify a filtering condition for a specific field in the database query.
   *
   * @example
   * ```typescript
   * // Apply a filtering condition: price > 100
   * query('products').whereGt('price', 100)
   *
   * // Alternative:
   * query('products').where('price', '>', 100)
   * ```
   */
  whereGt(field, value) {
    return this.where(field, ">", value);
  }
  /**
   * Specify a filtering condition for a specific field in the database query.
   *
   * @example
   * ```typescript
   * // Apply a filtering condition: price >= 100
   * query('products').whereGte('price', 100)
   *
   * // Alternative:
   * query('products').where('price', '>=', 100)
   * ```
   */
  whereGte(field, value) {
    return this.where(field, ">=", value);
  }
  /**
   * Specify a filtering condition for a specific field in the database query.
   *
   * @example
   * ```typescript
   * // Apply a filtering condition: price < 100
   * query('products').whereLt('price', 100)
   *
   * // Alternative:
   * query('products').where('price', '<', 100)
   * ```
   */
  whereLt(field, value) {
    return this.where(field, "<", value);
  }
  /**
   * Specify a filtering condition for a specific field in the database query.
   *
   * @example
   * ```typescript
   * // Apply a filtering condition: price <= 100
   * query('products').whereLte('price', 100)
   *
   * // Alternative:
   * query('products').where('price', '<=', 100)
   * ```
   */
  whereLte(field, value) {
    return this.where(field, "<=", value);
  }
  /**
   * Specify a filtering condition for a specific field in the database query.
   *
   * @example
   * ```typescript
   * // Apply a filtering condition: price >= 20 and price <= 50
   * query('products').whereBetween('price', [20, 50])
   *
   * // Alternative:
   * query('products').where('price', 'between', [20, 50])
   * ```
   */
  whereBetween(field, values) {
    return this.where(field, "between", values);
  }
  /**
   * Specify a filtering condition for a specific field in the database query.
   *
   * @example
   * ```typescript
   * // Apply a filtering condition: price < 20 or price > 50
   * query('products').whereNotBetween('price', [20, 50])
   *
   * // Alternative:
   * query('products').where('price', 'notBetween', [20, 50])
   * ```
   */
  whereNotBetween(field, values) {
    return this.where(field, "notBetween", values);
  }
  /**
   * Specify a filtering condition for a specific field in the database query.
   *
   * @example
   * ```typescript
   * // Apply a filtering condition: id = 1 or id = 3 or id = 5
   * query('products').whereIn('id', [1, 3, 5])
   *
   * // Alternative:
   * query('products').where('id', 'in', [1, 3, 5])
   * ```
   */
  whereIn(field, values) {
    return this.where(field, "in", values);
  }
  /**
   * Specify a filtering condition for a specific field in the database query.
   *
   * @example
   * ```typescript
   * // Apply a filtering condition: id != 1 and id != 3 and id != 5
   * query('products').whereNotIn('id', [1, 3, 5])
   *
   * // Alternative:
   * query('products').where('id', 'notIn', [1, 3, 5])
   * ```
   */
  whereNotIn(field, values) {
    return this.where(field, "notIn", values);
  }
  whereRecordsIn(field, ids, logic = "some") {
    const subQueries = [];
    for (const id of toArray(ids)) {
      subQueries.push((subQuery) => subQuery.where(field, "like", `%"${id}"%`));
    }
    return subQueries.length ? this[logic](subQueries[0], ...subQueries.slice(1)) : this;
  }
  whereRecordsNotIn(field, ids, logic = "some") {
    const subQueries = [];
    for (const id of toArray(ids)) {
      subQueries.push((subQuery) => subQuery.where(field, "notLike", `%"${id}"%`));
    }
    return subQueries.length ? this[logic](subQueries[0], ...subQueries.slice(1)) : this;
  }
  /**
   * Specify a filtering condition for a specific field in the database query.
   *
   * @example
   * ```typescript
   * // Apply a filtering condition: name starts with 'P' (case sensitive in PostgreSQL)
   * query('products').whereLike('name', 'P%')
   *
   * // Alternative:
   * query('products').where('name', 'like', 'P%')
   * ```
   */
  whereLike(field, value) {
    return this.where(field, "like", value);
  }
  /**
   * Specify a filtering condition for a specific field in the database query.
   *
   * @example
   * ```typescript
   * // Apply a filtering condition: name does not start with 'P' (case sensitive in PostgreSQL)
   * query('products').whereNotLike('name', 'P%')
   *
   * // Alternative:
   * query('products').where('name', 'notLike', 'P%')
   * ```
   */
  whereNotLike(field, value) {
    return this.where(field, "notLike", value);
  }
  /**
   * Specify a filtering condition for a specific field in the database query.
   *
   * @example
   * ```typescript
   * // Apply a filtering condition: name contains 'phone' (case insensitive)
   * query('products').whereILike('name', '%phone%')
   *
   * // Alternative:
   * query('products').where('name', 'iLike', '%phone%')
   * ```
   */
  whereILike(field, value) {
    return this.where(field, "iLike", value);
  }
  /**
   * Specify a filtering condition for a specific field in the database query.
   *
   * @example
   * ```typescript
   * // Apply a filtering condition: name does not contain 'phone' (case insensitive)
   * query('products').whereNotILike('name', '%phone%')
   *
   * // Alternative:
   * query('products').where('name', 'notILike', '%phone%')
   * ```
   */
  whereNotILike(field, value) {
    return this.where(field, "notILike", value);
  }
  /**
   * Apply a logical OR to a set of filtering conditions on the query.
   * At least one of the conditions must be satisfied for a record to be included in the result.
   *
   * @example
   * ```typescript
   * // Apply logical OR: (price < 100) OR (discount >= 0.5)
   * query('products').some(
   *   (products) => products.where('price', '<', 100),
   *   (products) => products.where('discount', '>=', 0.5),
   * )
   * ```
   */
  some(...filters) {
    const original = this.whereOptions;
    const or = { [Op.or]: [] };
    for (const filter of filters) {
      this.whereOptions = { [Op.and]: [] };
      filter(this);
      this.addFilter(this.whereOptions, or);
    }
    this.addFilter(or, original);
    this.whereOptions = original;
    return this;
  }
  /**
   * Apply a logical AND to a set of filtering conditions on the query.
   * All the conditions must be satisfied for a record to be included in the result.
   *
   * Note: This method is redundant since all chained filter operations are implicitly combined using logical AND.
   *
   * @example
   * ```typescript
   * // Apply logical AND: (price > 100) AND (discount >= 0.1)
   * query('products').every(
   *   (products) => products.where('price', '>', 100),
   *   (products) => products.where('status', '>=', 0.1),
   * )
   * ```
   */
  every(...filters) {
    filters.forEach((filter) => filter(this));
    return this;
  }
  /**
   * Perform a search in the queried collection based on the specified `keywords` and search `structure`.
   *
   * Note: The `keywords` are case insensitive.
   *
   * @example
   * ```typescript
   * // Find 'products' by a specific keyword.
   * // The `search` structures are defined in the collection definition.
   * await query('products').search('NVMe SSD').first()
   * // Output: { field1: '...', field2: '...', ... }
   * ```
   */
  search(keywords, structure = "default") {
    const search = collections[this.collection].search;
    if (search && search[structure]) {
      const extracted = extractKeywords(keywords);
      if (extracted.length) {
        this.searchOptions[structure] = extracted;
      }
    }
    return this;
  }
  /**
   * Set the sorting order for query results based on search relevance within a specific search `structure`.
   * By default, the sorting is in ascending order (`asc`), showing the most relevant results first.
   *
   * You can chain multiple `order` calls to apply multiple sorting criteria.
   * The sorting will be applied in the order they are called.
   *
   * @example
   * ```typescript
   * // Search products in the 'products' collection, sorted by relevance and price (ascending)
   * await query('products').search('NVMe SSD').orderBySearchRelevance().order('price').all()
   *
   * // Alternative:
   * await query('products').search('NVMe SSD').order(':default').order('price').all()
   * ```
   */
  orderBySearchRelevance(structure = "default", direction = "asc") {
    return this.order(`:${structure}`, direction);
  }
  /**
   * Set a sorting order for the query results based on a specific collection field.
   * By default, the sorting is done in ascending order (`asc`).
   *
   * You can chain multiple `order` calls to apply multiple sorting criteria.
   * The sorting will be applied in the order they are called.
   *
   * If the `field` argument starts with a colon (`:`), it is considered a search structure key.
   * For example, `order(':default')` is equivalent to calling the `orderBySearchRelevance()` method.
   *
   * @example
   * ```typescript
   * // Fetch all products from the 'products' collection, sorted by their price in ascending order
   * await query('products').order('price').all()
   *
   * // Fetch the most expensive products first, sorted by their price in descending order
   * await query('products').order('price', 'desc').all()
   * ```
   */
  order(field, direction = "asc") {
    this.orderOptions.push([field, direction === "asc" ? "ASC NULLS LAST" : "DESC NULLS LAST"]);
    return this;
  }
  /**
   * Group the query results based on a specific collection field.
   *
   * You can chain multiple `group` calls to apply multiple grouping criteria.
   * The grouping will be applied in the order they are called.
   *
   * @example
   * ```typescript
   * // Fetch all products from the 'products' collection, grouped by their category
   * await query('products').select({ category: true }).group('category').all()
   * ```
   */
  group(field) {
    this.groupOptions.push(field);
    return this;
  }
  /**
   * Set the offset (starting position) for the query results.
   *
   * @example
   * ```typescript
   * // Fetch the second page of products with 10 products per page from the 'products' collection
   * const records = await query('products').limit(10).offset(10).all()
   *
   * // Alternative:
   * const { records } = await query('products').paginate(2, 10)
   * ```
   */
  offset(offset) {
    this.offsetOption = offset;
    return this;
  }
  /**
   * Set the maximum number of records to be returned by the query.
   *
   * @example
   * ```typescript
   * // Fetch the first 10 products from the 'products' collection
   * const records = await query('products').limit(10).all()
   *
   * // Alternative:
   * const { records } = await query('products').paginate(1, 10)
   * ```
   */
  limit(limit) {
    this.limitOption = limit;
    return this;
  }
  /**
   * Enable field population to retrieve populated field values in the query results.
   *
   * By default, the query builder returns the casted field values without populating related data.
   *
   * @example
   * ```typescript
   * // Without population:
   * await query('products').select({ category: true }).first()
   * // Output: { category: 1 }
   *
   * // With population:
   * await query('products').select({ category: true }).populate().first()
   * // Output: { category: { id: 1, name: 'Electronics' } }
   * ```
   */
  populate() {
    this.populateOption = true;
    return this;
  }
  /**
   * Disable field population to retrieve casted values in the query results.
   *
   * By default, the query builder returns the casted field values without populating related data.
   *
   * @example
   * ```typescript
   * // Without population:
   * await populatedProductsQuery.select({ category: true }).unpopulate().first()
   * // Output: { category: 1 }
   *
   * // With population:
   * await populatedProductsQuery.select({ category: true }).first()
   * // Output: { category: { id: 1, name: 'Electronics' } }
   * ```
   */
  unpopulate() {
    this.populateOption = false;
    return this;
  }
  /**
   * Check whether the query results will be returned with casted or populated field values.
   *
   * @example
   * ```typescript
   * query('products').getFieldValueType() // 'casted'
   * query('products').populate().getFieldValueType() // 'populated'
   * ```
   */
  getFieldValueType() {
    return this.populateOption ? "populated" : "casted";
  }
  setFieldValueType(type) {
    this.populateOption = type === "populated";
    return this;
  }
  /**
   * Revalidate fields after fetching from the database and set their values to default if validation fails.
   * This prevents returning invalid existing data in case field or collection definitions are updated.
   *
   * By default, fallback validation is enabled.
   */
  fallback() {
    this.fallbackOption = true;
    return this;
  }
  /**
   * Disable field validation after fetching, potentially speeding up database queries.
   * Beware that this may result in invalid data if field or collection definitions change.
   *
   * By default, fallback validation is enabled.
   */
  noFallback() {
    this.fallbackOption = false;
    return this;
  }
  /**
   * Set the language for the validation messages returned by the query builder.
   *
   * By default, the language is set to the language code defined in the module option `language.primary`.
   */
  contextLanguage(language) {
    this.contextLanguageOption = language;
    return this;
  }
  /**
   * Get a copy of the current query builder options.
   */
  getOptions() {
    return deepClone({
      table: this.table,
      selectedFields: this.selectedFields,
      whereOptions: this.whereOptions,
      searchOptions: this.searchOptions,
      orderOptions: this.orderOptions,
      groupOptions: this.groupOptions,
      offsetOption: this.offsetOption,
      limitOption: this.limitOption,
      populateOption: this.populateOption,
      fallbackOption: this.fallbackOption,
      contextLanguageOption: this.contextLanguageOption
    });
  }
  /**
   * Create a new query builder with the same state as this one.
   */
  clone() {
    const query = new QueryBuilder(this.collection);
    for (const [key, value] of Object.entries(this.getOptions())) {
      query[key] = value;
    }
    return query;
  }
  /**
   * Reset the current `WHERE` clause options of the query.
   */
  clearWhere() {
    this.whereOptions = { [Op.and]: [] };
    return this;
  }
  /**
   * Reset the current search options of the query.
   */
  clearSearch() {
    this.searchOptions = {};
    return this;
  }
  /**
   * Reset the current `ORDER BY` clause options of the query.
   */
  clearOrder() {
    this.orderOptions = [];
    return this;
  }
  /**
   * Reset the current `GROUP BY` clause options of the query.
   */
  clearGroup() {
    this.groupOptions = [];
    return this;
  }
  /**
   * Reset the current `OFFSET` clause option of the query.
   */
  clearOffset() {
    this.offsetOption = void 0;
    return this;
  }
  /**
   * Reset the current `LIMIT` clause option of the query.
   */
  clearLimit() {
    this.limitOption = void 0;
    return this;
  }
  /**
   * Reset all query builder options to their default values.
   */
  reset() {
    return this.selectAll().clearWhere().clearSearch().clearOrder().clearGroup().clearOffset().clearLimit().unpopulate().fallback().contextLanguage(primaryLanguage);
  }
  /**
   * Retrieve the number of records in the queried collection.
   *
   * @example
   * ```typescript
   * // Get the number of records in the 'products' collection
   * await query('products').count()
   * // Output: 1337
   * ```
   */
  async count() {
    const result = await (await db()).model(this.table).count(await this.applySequelizeOptions(["group", "where"]));
    return this.groupOptions.length ? result.length : result[0]?.count ?? 0;
  }
  /**
   * Check whether there is at least one record that matches the current query.
   *
   * @example
   * ```typescript
   * // Check if there are products with prices greater than 100
   * await query('products').whereGt('price', 100).exists()
   * // Output: true
   * ```
   */
  async exists() {
    return await this.count() > 0;
  }
  /**
   * Check whether there are no records that match the current query.
   *
   * @example
   * ```typescript
   * // Check if there are no products with zero prices
   * await query('products').where('price', 0).notExists()
   * // Output: true
   * ```
   */
  async notExists() {
    return await this.count() === 0;
  }
  /**
   * Fetch all records from the queried collection.
   *
   * @example
   * ```typescript
   * // Fetch all records from the 'products' collection
   * await query('products').all()
   * // Output: [{ field1: '...', field2: '...', ... }, { field1: '...', field2: '...', ... }, ...]
   * ```
   */
  async all() {
    const start = performance.now();
    const key = this.generateCacheKey("all");
    const cached = await this.readFromCache(key);
    if (cached) {
      return cached;
    }
    const records = await (await db()).model(this.table).findAll({ ...await this.applySequelizeOptions(), raw: true });
    for (const record of records) {
      this.castRecord(record);
    }
    for (const record of records) {
      await this.validateAndFallbackRecordsAfterFetch(record, records);
    }
    if (this.populateOption) {
      for (const record of records) {
        await this.populateRecord(record);
      }
    }
    if (!this.hasNonCachedFieldInSelectOrderOrGroup() && !this.hasNonCachedFieldInWhere()) {
      await this.storeInCache(key, records, start);
    }
    return records;
  }
  /**
   * Retrieve all records from the queried collection along with the total count of records.
   *
   * @example
   * ```typescript
   * // Fetch the first 2 records from the 'products' collection with count
   * await query('products').limit(2).allWithCount()
   * // Output: { count: 1337, records: [{ field1: '...', field2: '...', ... }, { field1: '...', field2: '...', ... }] }
   * ```
   */
  async allWithCount() {
    const start = performance.now();
    const key = this.generateCacheKey("allWithCount");
    const cached = await this.readFromCache(key);
    if (cached) {
      return cached;
    }
    const count = await this.count();
    const records = await (await db()).model(this.table).findAll({ ...await this.applySequelizeOptions(), raw: true });
    for (const record of records) {
      this.castRecord(record);
    }
    for (const record of records) {
      await this.validateAndFallbackRecordsAfterFetch(record, records);
    }
    if (this.populateOption) {
      for (const record of records) {
        await this.populateRecord(record);
      }
    }
    const result = { count, records };
    if (!this.hasNonCachedFieldInSelectOrderOrGroup() && !this.hasNonCachedFieldInWhere()) {
      await this.storeInCache(key, result, start);
    }
    return result;
  }
  /**
   * Retrieve a specific page of records along with pagination-related information.
   *
   * @example
   * ```typescript
   * // Fetch the first page with 10 records per page from the 'products' collection
   * await query('products').paginate(1, 10)
   * // Output: { currentPage: 1, lastPage: 134, perPage: 10, records: [...], total: 1337 }
   * ```
   */
  async paginate(page, perPage) {
    const start = performance.now();
    const key = this.generateCacheKey("paginate");
    const cached = await this.readFromCache(key);
    if (cached) {
      return cached;
    }
    const offset = (page - 1) * perPage;
    const { count, records } = await this.limit(perPage).offset(offset).allWithCount();
    const lastPage = perPage ? Math.max(1, Math.ceil(count / perPage)) : 1;
    const result = { currentPage: page, lastPage, perPage, records, total: count };
    if (!this.hasNonCachedFieldInSelectOrderOrGroup() && !this.hasNonCachedFieldInWhere()) {
      await this.storeInCache(key, result, start);
    }
    return result;
  }
  /**
   * Fetch the first record from the queried collection.
   *
   * @example
   * ```typescript
   * // Fetch the first record from the 'products' collection
   * await query('products').first()
   * // Output: { field1: '...', field2: '...', ... }
   * ```
   */
  async first() {
    const start = performance.now();
    const key = this.generateCacheKey("first");
    const cached = await this.readFromCache(key);
    if (cached) {
      return cached;
    }
    const record = await (await db()).model(this.table).findOne({ ...await this.applySequelizeOptions(), raw: true });
    if (record) {
      this.castRecord(record);
      await this.validateAndFallbackRecordsAfterFetch(record);
      if (this.populateOption) {
        await this.populateRecord(record);
      }
    }
    if (!this.hasNonCachedFieldInSelectOrderOrGroup() && !this.hasNonCachedFieldInWhere()) {
      await this.storeInCache(key, record, start);
    }
    return record;
  }
  /**
   * Retrieve the minimum value of a specific field in the queried collection.
   *
   * @example
   * ```typescript
   * // Find the minimum price among products
   * await query('products').min('price')
   * // Output: 0.36
   * ```
   */
  async min(field) {
    const start = performance.now();
    const key = this.generateCacheKey("min");
    const cached = await this.readFromCache(key);
    if (cached) {
      return cached;
    }
    const min = await (await db()).model(this.table).min(field, await this.applySequelizeOptions(["where"]));
    if (!this.hasNonCachedFieldInWhere()) {
      await this.storeInCache(key, min, start);
    }
    return min;
  }
  /**
   * Retrieve the maximum value of a specific field in the queried collection.
   *
   * @example
   * ```typescript
   * // Find the maximum price among products
   * await query('products').max('price')
   * // Output: 9001
   * ```
   */
  async max(field) {
    const start = performance.now();
    const key = this.generateCacheKey("max");
    const cached = await this.readFromCache(key);
    if (cached) {
      return cached;
    }
    const max = await (await db()).model(this.table).max(field, await this.applySequelizeOptions(["where"]));
    if (!this.hasNonCachedFieldInWhere()) {
      await this.storeInCache(key, max, start);
    }
    return max;
  }
  /**
   * Retrieve the sum of a specific numeric field in the queried collection.
   *
   * @example
   * ```typescript
   * // Calculate the total quantity of all products
   * await query('products').sum('quantity')
   * // Output: 5417
   * ```
   */
  async sum(field) {
    const start = performance.now();
    const key = this.generateCacheKey("sum");
    const cached = await this.readFromCache(key);
    if (cached) {
      return cached;
    }
    const sum = await (await db()).model(this.table).sum(field, await this.applySequelizeOptions(["where"]));
    if (!this.hasNonCachedFieldInWhere()) {
      await this.storeInCache(key, sum, start);
    }
    return sum ?? 0;
  }
  /**
   * Validate the `input` data of a record.
   *
   * @returns A Promise that resolves to an object containing validation errors for fields with failed validation.
   */
  async validate(input, operation, allInputs, skipFields) {
    const errors = {};
    for (const fieldName of this.getOperableFields(input, operation)) {
      if (skipFields?.includes(fieldName)) {
        continue;
      }
      const declaration = collections[this.collection].fields[fieldName];
      if (declaration) {
        const definition = fields[declaration.type];
        if (definition) {
          for (const validator of [...definition.validators, ...declaration.additional?.validators ?? []]) {
            try {
              if (isFunction(validator) || operation === "create" && validator.onCreate || operation === "read" && validator.onRead || operation === "update" && validator.onUpdate) {
                await (isFunction(validator) ? validator : validator.validator)({
                  _,
                  __,
                  allInputs,
                  collection: collections[this.collection],
                  collections,
                  definition,
                  input,
                  language: this.contextLanguageOption,
                  name: fieldName,
                  operation,
                  options: resolveCollectionFieldOptions(
                    this.collection,
                    declaration.type,
                    fieldName,
                    declaration.options,
                    fields
                  ),
                  value: input[fieldName],
                  currentQuery: this,
                  query: query,
                  errors,
                  fields
                });
              }
            } catch (e) {
              errors[fieldName] = e.message;
              break;
            }
          }
        }
      }
    }
    return errors;
  }
  /**
   * Create a new record in the queried collection with the provided `input` data.
   *
   * @returns A Promise that resolves to a `CreateResult` object.
   *          If the creation is successful, the `record` property will contain the created record.
   *          If there are any field validation errors, they will be available in the `errors` property.
   *          The `message` property may contain an optional error message if there are issues during the database query.
   *
   * @example
   * ```typescript
   * const result = await query('products').create({
   *   name: 'Magical Wand',
   *   price: 19.99,
   *   category: 2,
   *   description: 'A powerful wand for all your wizarding needs!',
   * })
   *
   * if (result.success) {
   *   console.log('Product created successfully:', result.record)
   * } else {
   *   console.error('Product creation failed:', result.errors)
   * }
   * ```
   */
  async create(input) {
    input = input ?? {};
    if (!isObject(input)) {
      return { success: false, errors: {}, message: __(this.contextLanguageOption, "pruvious-server", "Invalid input") };
    }
    if (collections[this.collection].translatable && isString(input.translations)) {
      await this.fillNonTranslatableFields(input, input.translations);
    }
    const prepared = this.prepareInput(input, "create");
    const sanitized = await this.sanitize(prepared, "create");
    const conditionalLogicResults = this.applyConditionalLogic(sanitized);
    if (Object.keys(conditionalLogicResults.errors).length) {
      return { success: false, errors: conditionalLogicResults.errors };
    }
    const validationErrors = await this.validate(sanitized, "create", void 0, conditionalLogicResults.failed);
    if (Object.keys(validationErrors).length) {
      return { success: false, errors: validationErrors };
    }
    const now = Date.now();
    if (collections[this.collection].createdAtField) {
      sanitized[collections[this.collection].createdAtField] = now;
    }
    if (collections[this.collection].updatedAtField) {
      sanitized[collections[this.collection].updatedAtField] = now;
    }
    try {
      const record = (await (await db()).model(this.table).create(this.serializeInput(sanitized))).dataValues;
      this.castRecord(record);
      const recordId = record.id;
      for (const fieldName of Object.keys(record).filter((key) => !this.selectedFields.includes(key))) {
        delete record[fieldName];
      }
      await this.validateAndFallbackRecordsAfterCreate(record);
      if (this.populateOption) {
        await this.populateRecord(record);
      }
      if (collections[this.collection].search) {
        await cache();
        setTimeout(() => this.buildSearchKeywords(recordId).then(() => this.clearCache("onCreate")));
      }
      await this.clearCache("onCreate");
      return { success: true, record };
    } catch (e) {
      return { success: false, errors: {}, message: e.message };
    }
  }
  /**
   * Create multiple records in the collection based on the provided `input` array.
   * Each `input` element corresponds to a record to be created.
   *
   * @returns A Promise that resolves to a `CreateManyResult` object.
   *          If successful, the created records will be available in the `records` property.
   *          If any input has validation errors, the `errors` property will contain an array of error objects at the corresponding index.
   *          If there are no errors for a particular input, the value at that index will be `null`.
   *          The `message` property may contain an optional error message for any database query issues.
   *
   * Note: If any input fails validation, no records will be created.
   *
   * @example
   * ```typescript
   * const result = await query('products').createMany([
   *   { name: 'Product 1', price: 10 },
   *   { name: 'Product 2', price: 20 },
   *   { name: 'Product 3', price: 'Invalid Price' }, // <- Error
   * ])
   *
   * if (result.success) {
   *   console.log('Records created:', result.records)
   * } else {
   *   console.log('Errors:', result.errors) // [null, null, { price: 'Invalid input type' }]
   * }
   * ```
   */
  async createMany(input) {
    input = input ?? [];
    if (!isArray(input) || !input.every(isObject)) {
      return { success: false, errors: [], message: __(this.contextLanguageOption, "pruvious-server", "Invalid input") };
    }
    const sanitized = [];
    const errors = [];
    for (const entry of input) {
      if (collections[this.collection].translatable && isString(entry.translations)) {
        await this.fillNonTranslatableFields(entry, entry.translations);
      }
      const preparedEntry = this.prepareInput(entry, "create");
      const sanitizedEntry = await this.sanitize(preparedEntry, "create");
      sanitized.push(sanitizedEntry);
    }
    for (const sanitizedEntry of sanitized) {
      const conditionalLogicResults = this.applyConditionalLogic(sanitizedEntry);
      if (Object.keys(conditionalLogicResults.errors).length) {
        errors.push(conditionalLogicResults.errors);
      } else {
        const validationErrors = await this.validate(
          sanitizedEntry,
          "create",
          sanitized,
          conditionalLogicResults.failed
        );
        errors.push(Object.keys(validationErrors).length ? validationErrors : null);
      }
    }
    if (errors.some(Boolean)) {
      return { success: false, errors };
    }
    const now = Date.now();
    if (collections[this.collection].createdAtField) {
      for (const sanitizedEntry of sanitized) {
        sanitizedEntry[collections[this.collection].createdAtField] = now;
      }
    }
    if (collections[this.collection].updatedAtField) {
      for (const sanitizedEntry of sanitized) {
        sanitizedEntry[collections[this.collection].updatedAtField] = now;
      }
    }
    try {
      const results = await (await db()).model(this.table).bulkCreate(sanitized.map((input2) => this.serializeInput(input2)));
      const records = results.map(({ dataValues }) => dataValues);
      const buildSearchKeywords = [];
      for (const record of records) {
        this.castRecord(record);
        const recordId = record.id;
        for (const fieldName of Object.keys(record).filter((key) => !this.selectedFields.includes(key))) {
          delete record[fieldName];
        }
        await this.validateAndFallbackRecordsAfterCreate(record, records);
        if (this.populateOption) {
          await this.populateRecord(record);
        }
        if (collections[this.collection].search) {
          buildSearchKeywords.push(new Promise((resolve) => this.buildSearchKeywords(recordId).then(resolve)));
        }
      }
      if (buildSearchKeywords.length) {
        await cache();
        setTimeout(() => Promise.all(buildSearchKeywords).then(() => this.clearCache("onCreate")));
      }
      if (records.length) {
        await this.clearCache("onCreate");
      }
      return { success: true, records };
    } catch (e) {
      return { success: false, errors: Array(input.length).fill(null), message: e.message };
    }
  }
  /**
   * Update existing records in the queried collection based on the specified conditions.
   *
   * @returns A Promise that resolves to an `UpdateResult` object.
   *          If successful, the updated records will be available in the `records` property.
   *          If there are any field validation errors, they will be available in the `errors` property.
   *          The `message` property may contain an optional error message if there are issues during the database query.
   *
   * @example
   * ```typescript
   * const result = await query('products').where('id', 47).update({
   *   name: 'Updated Product',
   *   price: 15,
   *   category: 3,
   *   description: 'This product has been updated!',
   * })
   *
   * if (result.success) {
   *   console.log('Records updated:', result.records)
   * } else {
   *   console.error('Update failed:', result.errors)
   * }
   * ```
   */
  async update(input) {
    input = input ?? {};
    if (!isObject(input)) {
      return { success: false, errors: {}, message: __(this.contextLanguageOption, "pruvious-server", "Invalid input") };
    }
    const prepared = this.prepareInput(input, "update");
    const sanitized = await this.sanitize(prepared, "update");
    const conditionalLogicResults = this.applyConditionalLogic(sanitized);
    if (Object.keys(conditionalLogicResults.errors).length) {
      return { success: false, errors: conditionalLogicResults.errors };
    }
    const validationErrors = await this.validate(sanitized, "update", void 0, conditionalLogicResults.failed);
    if (Object.keys(validationErrors).length) {
      return { success: false, errors: validationErrors };
    }
    if (collections[this.collection].updatedAtField) {
      sanitized[collections[this.collection].updatedAtField] = Date.now();
    }
    try {
      return {
        success: true,
        records: await this.updateOrDelete("update", async (buildSearchKeywordsRecordIds) => {
          await (await db()).model(this.table).update(this.serializeInput(sanitized), await this.applySequelizeOptions(["where"]));
          if (collections[this.collection].translatable) {
            buildSearchKeywordsRecordIds.push(...await this.syncNonTranslatableFields(sanitized));
          }
        })
      };
    } catch (e) {
      return { success: false, errors: {}, message: e.message };
    }
  }
  /**
   * Delete records from the queried collection based on the specified conditions.
   *
   * @returns A Promise that resolves to an array containing the deleted records.
   *
   * @example
   * ```typescript
   * await query('products').select({ id: true }).where('category', 5).delete()
   * // Output: [{ id: 30 }, { id: 144 }, { id: 145 }]
   * ```
   */
  async delete() {
    return this.updateOrDelete(
      "delete",
      async () => await (await db()).model(this.table).destroy(await this.applySequelizeOptions(["where"]))
    );
  }
  async applySequelizeOptions(pick = [
    "attributes",
    "group",
    "limit",
    "offset",
    "order",
    "where"
  ]) {
    const options = {};
    for (const option of pick) {
      if (option === "attributes") {
        options.attributes = this.selectedFields.map(snakeCase);
      } else if (option === "limit") {
        options.limit = this.limitOption;
      } else if (option === "offset") {
        options.offset = this.offsetOption;
      } else if (option === "group") {
        options.group = this.groupOptions.filter((fieldName) => collections[this.collection].fields[fieldName]).map(snakeCase);
      } else if (option === "order") {
        options.order = [];
        for (const [fieldName, direction] of this.orderOptions) {
          if (fieldName[0] === ":") {
            const search = collections[this.collection].search;
            const structure = fieldName.slice(1);
            const keywords = this.searchOptions[structure];
            if (search && search[structure] && keywords) {
              const snakeStructure = snakeCase(structure);
              options.attributes ||= [];
              for (const [i, keyword] of keywords.entries()) {
                const _keyword = (await db()).escape(keyword);
                const alias = Sequelize.literal(
                  this.dialect === "postgres" ? `POSITION(${_keyword} in "_search_${snakeStructure}") AS "__match_${snakeStructure}_${i}"` : `INSTR("_search_${snakeStructure}", ${_keyword}) AS "__match_${snakeStructure}_${i}"`
                );
                if (!options.attributes.includes(alias)) {
                  options.attributes.push(alias);
                }
                options.order.push(Sequelize.literal(`__match_${snakeStructure}_${i} ${direction}`));
              }
            }
          } else if (collections[this.collection].fields[fieldName]) {
            options.order.push([snakeCase(fieldName), direction]);
          }
        }
      } else if (option === "where") {
        options.where = snakeCasePropNames(deepClone(this.whereOptions));
        for (const [structure, keywords] of Object.entries(this.searchOptions)) {
          const snakeStructure = snakeCase(structure);
          const op = Object.getOwnPropertySymbols(options.where)[0];
          for (const keyword of keywords) {
            const _keyword = (await db()).escape(keyword);
            options.where[op].push(
              Sequelize.literal(
                this.dialect === "postgres" ? `POSITION(${_keyword} in "_search_${snakeStructure}") > 0` : `INSTR("_search_${snakeStructure}", ${_keyword}) > 0`
              )
            );
          }
        }
      }
    }
    return options;
  }
  addFilter(filter, to) {
    const target = to || this.whereOptions;
    const op = Object.getOwnPropertySymbols(target)[0];
    target[op].push(filter);
  }
  serializeInput(input) {
    const serialized = {};
    for (const [fieldName, value] of Object.entries(input)) {
      const declaration = collections[this.collection].fields[fieldName];
      const definition = declaration ? fields[declaration.type] : null;
      if (definition?.serialize) {
        serialized[snakeCase(fieldName)] = definition.serialize(value);
      } else {
        serialized[snakeCase(fieldName)] = value && typeof value === "object" ? JSON.stringify(value) : value;
      }
    }
    return serialized;
  }
  async buildSearchKeywords(id) {
    const collectionSearch = collections[this.collection].search;
    if (collectionSearch) {
      const castedRecord = await this.clone().reset().where("id", id).first();
      if (!castedRecord) {
        return;
      }
      let populatedRecord = null;
      const attributes = {};
      for (const [structure, search] of Object.entries(collectionSearch)) {
        const keywords = [];
        for (const entry of search) {
          let extracted = "";
          if (isString(entry)) {
            extracted = (await fields[collections[this.collection].fields[entry].type].extractKeywords({
              collection: collections[this.collection],
              collections,
              definition: fields[collections[this.collection].fields[entry].type],
              fieldValueType: "casted",
              fields,
              options: resolveCollectionFieldOptions(
                this.collection,
                collections[this.collection].fields[entry].type,
                entry,
                collections[this.collection].fields[entry].options,
                fields
              ),
              record: castedRecord,
              value: castedRecord[entry]
            })).trim();
          } else {
            if (entry.fieldValueType === "populated" && !populatedRecord) {
              populatedRecord = { ...castedRecord };
              await this.populateRecord(populatedRecord);
            }
            const record = entry.fieldValueType === "populated" ? populatedRecord : castedRecord;
            const context = {
              collection: collections[this.collection],
              collections,
              definition: fields[collections[this.collection].fields[entry.field].type],
              fieldValueType: entry.fieldValueType ?? "casted",
              fields,
              options: resolveCollectionFieldOptions(
                this.collection,
                collections[this.collection].fields[entry.field].type,
                entry.field,
                collections[this.collection].fields[entry.field].options,
                fields
              ),
              record,
              value: record[entry.field]
            };
            if (entry.extractKeywords) {
              extracted = (await entry.extractKeywords(context)).trim();
            } else {
              extracted = (await fields[collections[this.collection].fields[entry.field].type].extractKeywords(context)).trim();
            }
            if (entry.reserve) {
              extracted = extracted.padEnd(entry.reserve, " ");
            }
          }
          keywords.push(extracted);
        }
        attributes[`_search_${snakeCase(structure)}`] = keywords.filter(Boolean).join(" ").toLowerCase();
      }
      await (await db()).model(this.table).update(attributes, { where: { id } });
    }
  }
  castRecord(record) {
    for (const [fieldName, value] of Object.entries(record)) {
      if (fieldName.includes("_")) {
        if (fieldName[0] !== "_") {
          record[camelCase(fieldName)] = value;
        }
        delete record[fieldName];
      }
    }
    for (const fieldName of this.selectedFields) {
      const declaration = collections[this.collection].fields[fieldName];
      const definition = declaration ? fields[declaration.type] : null;
      if (definition) {
        if (definition.deserialize) {
          try {
            record[fieldName] = definition.deserialize(record[fieldName]);
          } catch {
            record[fieldName] = null;
          }
        } else if (definition.type.js === "boolean" && (record[fieldName] === 0 || record[fieldName] === 1)) {
          record[fieldName] = !!record[fieldName];
        } else if (definition.type.js === "number" && isString(record[fieldName])) {
          record[fieldName] = +record[fieldName];
        } else if (definition.type.js === "object" && isString(record[fieldName])) {
          try {
            record[fieldName] = JSON.parse(record[fieldName]);
          } catch {
            record[fieldName] = null;
          }
        }
      }
    }
  }
  async validateAndFallbackRecordsAfterCreate(record, allRecords) {
    if (this.fallbackOption) {
      for (const fieldName in record) {
        const declaration = collections[this.collection].fields[fieldName];
        const definition = fields[declaration.type];
        for (const validator of [...definition.validators, ...declaration.additional?.validators ?? []]) {
          if (!isFunction(validator) && !validator.onCreate && validator.onRead) {
            const options = resolveCollectionFieldOptions(
              this.collection,
              declaration.type,
              fieldName,
              declaration.options,
              fields
            );
            try {
              await validator.validator({
                _,
                __,
                allInputs: allRecords,
                collection: collections[this.collection],
                collections,
                definition,
                input: record,
                language: this.contextLanguageOption,
                name: fieldName,
                operation: "read",
                options,
                currentQuery: this,
                query: query,
                value: record[fieldName],
                errors: {},
                fields
              });
            } catch (e) {
              record[fieldName] = definition.default({ definition, name: fieldName, options });
              break;
            }
          }
        }
      }
    }
  }
  async validateAndFallbackRecordsAfterFetch(record, allRecords) {
    if (this.fallbackOption) {
      const errors = await this.validate(record, "read", allRecords);
      const filterArrays = {};
      for (const fieldPath of Object.keys(errors)) {
        const declaration = getProperty(
          collections[this.collection].fields,
          fieldPath.replace(/\.([0-9]+)\./g, ".options.subfields.")
        );
        if (isObject(declaration) && declaration.type) {
          const definition = fields[declaration.type];
          if (definition && declaration.type !== "block") {
            setProperty(
              record,
              fieldPath,
              definition.default({
                definition,
                name: fieldPath,
                options: resolveCollectionFieldOptions(
                  this.collection,
                  declaration.type,
                  fieldPath,
                  declaration.options,
                  fields
                )
              })
            );
          } else if (/\.[0-9]+$/.test(fieldPath)) {
            const parentPath = fieldPath.split(".").slice(0, -1).join(".");
            const value = getProperty(record, parentPath);
            if (isArray(value)) {
              filterArrays[parentPath] = value;
            }
          } else if (!/\.[a-z_$][a-z0-9_$]*\.fields\./i.test) {
            deleteProperty(record, fieldPath);
          }
        } else if (/\.[0-9]+$/.test(fieldPath)) {
          const parentPath = fieldPath.split(".").slice(0, -1).join(".");
          const value = getProperty(record, parentPath);
          if (isArray(value)) {
            filterArrays[parentPath] = value;
          }
        } else if (!/\.[a-z_$][a-z0-9_$]*\.fields\./i.test) {
          deleteProperty(record, fieldPath);
        }
      }
      for (const [fieldPath, value] of sortNaturalByProp(Object.entries(filterArrays), "0").reverse()) {
        setProperty(
          record,
          fieldPath,
          value.filter((v) => !isNull(v))
        );
      }
    }
  }
  async populateRecord(record) {
    for (const fieldName of this.selectedFields) {
      const declaration = collections[this.collection].fields[fieldName];
      const definition = declaration ? fields[declaration.type] : null;
      const population = declaration.additional?.population ?? definition?.population;
      if (definition && population) {
        record[fieldName] = await population.populator({
          value: record[fieldName],
          definition,
          name: fieldName,
          options: resolveCollectionFieldOptions(
            this.collection,
            declaration.type,
            fieldName,
            declaration.options,
            fields
          ),
          currentQuery: this,
          query: query,
          fields
        });
      }
    }
  }
  async fillNonTranslatableFields(input, translations) {
    let relatedRecord = null;
    for (const fieldName of Object.keys(collections[this.collection].fields)) {
      if (collections[this.collection].fields[fieldName]?.additional?.translatable === false) {
        if (!relatedRecord) {
          relatedRecord = await (await db()).model(this.table).findOne({ where: { translations }, raw: true });
          if (relatedRecord) {
            this.castRecord(relatedRecord);
            await this.validateAndFallbackRecordsAfterFetch(relatedRecord);
          } else {
            return;
          }
        }
        input[fieldName] = relatedRecord[fieldName];
      }
    }
  }
  async syncNonTranslatableFields(sanitized) {
    const input = {};
    for (const [fieldName, fieldValue] of Object.entries(sanitized)) {
      if (collections[this.collection].fields[fieldName]?.additional?.translatable === false) {
        input[fieldName] = fieldValue;
      }
    }
    if (Object.keys(input).length) {
      const relatedRecords = await (await db()).model(this.table).findAll({
        attributes: ["id", "translations"],
        ...await this.applySequelizeOptions(["where"]),
        raw: true
      });
      if (relatedRecords.length) {
        await (await db()).model(this.table).update(this.serializeInput(input), {
          where: { translations: { [Op.in]: uniqueArray(relatedRecords.map(({ translations }) => translations)) } }
        });
        return relatedRecords.map(({ id }) => id);
      }
    }
    return [];
  }
  prepareInput(input, operation) {
    return objectOmit(
      objectPick(input, Object.keys(collections[this.collection].fields)),
      operation === "update" ? this.getImmutableFields() : []
    );
  }
  getImmutableFields() {
    return Object.keys(collections[this.collection].fields).filter(
      (fieldName) => collections[this.collection].fields[fieldName].additional?.immutable
    );
  }
  getOperableFields(input, operation) {
    return (operation === "create" ? Object.keys(collections[this.collection].fields) : Object.keys(input)).filter(
      (fieldName) => fieldName !== "id" && collections[this.collection].fields[fieldName] && fieldName !== collections[this.collection].createdAtField && fieldName !== collections[this.collection].updatedAtField
    );
  }
  async sanitize(input, operation) {
    const sanitized = {};
    for (const fieldName of this.getOperableFields(input, operation)) {
      const declaration = collections[this.collection].fields[fieldName];
      if (declaration) {
        const definition = fields[declaration.type];
        if (definition) {
          sanitized[fieldName] = input[fieldName];
          for (const sanitizer of [...definition.sanitizers, ...declaration.additional?.sanitizers ?? []]) {
            try {
              if (isFunction(sanitizer) || operation === "create" && sanitizer.onCreate || operation === "update" && sanitizer.onUpdate) {
                sanitized[fieldName] = await (isFunction(sanitizer) ? sanitizer : sanitizer.sanitizer)({
                  name: fieldName,
                  value: sanitized[fieldName],
                  definition,
                  input,
                  options: resolveCollectionFieldOptions(
                    this.collection,
                    declaration.type,
                    fieldName,
                    declaration.options,
                    fields
                  ),
                  fields,
                  operation,
                  query: query
                });
              }
            } catch {
            }
          }
        }
      }
    }
    return sanitized;
  }
  applyConditionalLogic(sanitized) {
    const errors = {};
    const failed = [];
    for (const [name, value] of Object.entries(sanitized)) {
      const declaration = collections[this.collection].fields[name];
      const definition = declaration ? fields[declaration.type] : null;
      if (declaration?.additional?.conditionalLogic && definition) {
        try {
          if (!definition.conditionalLogicMatcher({
            conditionalLogic: declaration.additional.conditionalLogic,
            definition,
            errors,
            input: sanitized,
            name,
            options: declaration.options,
            value,
            fields
          })) {
            failed.push(name);
          }
        } catch (e) {
          errors[name] = e.message;
        }
      }
    }
    return { errors, failed };
  }
  async updateOrDelete(operation, callback, buildSearchKeywordsRecordIds = []) {
    const sequelizeOptions = { ...await this.applySequelizeOptions(["attributes", "order", "where"]), raw: true };
    const buildSearchKeywords = [];
    if (!sequelizeOptions.attributes.includes("id")) {
      sequelizeOptions.attributes.push("id");
    }
    let records = await (await db()).model(this.table).findAll(sequelizeOptions);
    if (operation === "update") {
      await callback(buildSearchKeywordsRecordIds);
      records = await (await db()).model(this.table).findAll({ ...sequelizeOptions, where: { id: { [Op.in]: records.map(({ id }) => id) } } });
    }
    for (const record of records) {
      this.castRecord(record);
    }
    if (operation === "update") {
      for (const record of records) {
        await this.validateAndFallbackRecordsAfterFetch(record, records);
      }
    }
    for (const record of records) {
      if (this.populateOption) {
        await this.populateRecord(record);
      }
      if (operation === "update" && collections[this.collection].search) {
        if (!buildSearchKeywordsRecordIds.includes(record.id)) {
          buildSearchKeywordsRecordIds.push(record.id);
          buildSearchKeywords.push(new Promise((resolve) => this.buildSearchKeywords(record.id).then(resolve)));
        }
      }
      if (!this.selectedFields.includes("id")) {
        delete record.id;
      }
    }
    for (const id of buildSearchKeywordsRecordIds) {
      if (!buildSearchKeywordsRecordIds.includes(id)) {
        buildSearchKeywordsRecordIds.push(id);
        buildSearchKeywords.push(new Promise((resolve) => this.buildSearchKeywords(id).then(resolve)));
      }
    }
    if (buildSearchKeywords.length) {
      await cache();
      setTimeout(
        () => Promise.all(buildSearchKeywords).then(() => this.clearCache(operation === "update" ? "onUpdate" : "onDelete"))
      );
    }
    if (operation === "delete") {
      await callback(buildSearchKeywordsRecordIds);
    }
    if (records.length) {
      await this.clearCache(operation === "update" ? "onUpdate" : "onDelete");
    }
    return records;
  }
  hasNonCachedFieldInSelectOrderOrGroup() {
    if (collections[this.collection].cacheQueries !== false) {
      return this.selectedFields.some((fieldName) => collections[this.collection].nonCachedFields.includes(fieldName)) || this.orderOptions.some(([fieldName, _2]) => collections[this.collection].nonCachedFields.includes(fieldName)) || this.groupOptions.some((fieldName) => collections[this.collection].nonCachedFields.includes(fieldName));
    }
    return false;
  }
  hasNonCachedFieldInWhere() {
    if (collections[this.collection].cacheQueries !== false) {
      for (const { key } of walkObject(this.whereOptions)) {
        if (isString(key) && collections[this.collection].nonCachedFields.includes(key)) {
          return true;
        }
      }
    }
    return false;
  }
  generateCacheKey(method) {
    if (collections[this.collection].cacheQueries !== false) {
      let key = `pruvious:query:${this.collection}:${method}:select:${this.selectedFields.join(",")}`;
      if (method === "all" || method === "allWithCount" || method === "paginate" || method === "first") {
        key += `:where:${JSON.stringify(stringifySymbols(this.whereOptions))}`;
      }
      key += `:order:${JSON.stringify(this.orderOptions)}`;
      key += `:group:${JSON.stringify(this.groupOptions)}`;
      key += `:offset:${this.offsetOption}`;
      key += `:limit:${this.limitOption}`;
      key += `:populate:${this.populateOption}`;
      key += `:fallback:${this.fallbackOption}`;
      return key;
    }
    return "";
  }
  async storeInCache(key, value, start) {
    const cacheQueries = collections[this.collection].cacheQueries;
    if (cacheQueries !== false && performance.now() - start > cacheQueries) {
      await (await cache())?.set(key, JSON.stringify(value));
    }
  }
  async readFromCache(key) {
    if (collections[this.collection].cacheQueries !== false) {
      const value = await (await cache())?.get(key);
      return value ? JSON.parse(value) : null;
    }
    return null;
  }
  async clearCache(operation) {
    const collection = collections[this.collection];
    if (collection.clearCacheRules && collection.clearCacheRules[operation] !== false) {
      await (await cache())?.flushDb();
      await clearPageCache();
    }
  }
}

class SingleQueryBuilder {
  constructor(collection, contextLanguage = primaryLanguage) {
    this.collection = collection;
    this.contextLanguageOption = contextLanguage;
    this.table = getModuleOption("singleCollectionsTable");
    this.selectAll();
  }
  table;
  selectedFields = [];
  languageOption = primaryLanguage;
  populateOption = false;
  fallbackOption = true;
  contextLanguageOption;
  /**
   * Apply query string parameters to the current query.
   *
   * @example
   * ```typescript
   * export default defineEventHandler((event) => {
   *   const qs = getQueryStringParams(event, 'settings')
   *
   *   if (qs.errors.length) {
   *     setResponseStatus(event, 400)
   *     return qs.errors.join('\n')
   *   }
   *
   *   return query('settings').applyQueryStringParams(qs.params).read()
   * })
   * ```
   */
  applyQueryStringParams(params) {
    if (isKeyOf(params, "select")) this.selectedFields = uniqueArray(params.select);
    if (isKeyOf(params, "language")) this.languageOption = params.language;
    if (isKeyOf(params, "populate")) this.populateOption = params.populate;
    return this;
  }
  /**
   * Specify the `fields` to be selected and returned from the query.
   *
   * @example
   * ```typescript
   * // Selects the 'logo' and 'copyright' fields from the 'settings' collection
   * await query('settings').select({ logo: true, copyright: true }).read()
   * // Output: { logo: ..., copyright: '...' }
   * ```
   */
  select(fields2) {
    clearArray(this.selectedFields).push(...isArray(fields2) ? uniqueArray(fields2) : Object.keys(fields2));
    return this;
  }
  /**
   * Select all fields from the queried collection.
   *
   * @example
   * ```typescript
   * // Select all fields from the 'settings' collection
   * await query('settings').selectAll().read()
   * // Output: { field1: '...', field2: '...', ... }
   * ```
   */
  selectAll() {
    const collection = collections[this.collection];
    clearArray(this.selectedFields).push(...Object.keys(collection.fields));
    return this;
  }
  /**
   * Exclude specified `fields` from the query result.
   *
   * @example
   * ```typescript
   * // Don't return the 'secret' field from the 'settings' collection
   * const product = await query('settings').deselect({ secret: true }).read()
   * console.log(product.secret)
   * // Output: undefined
   * ```
   */
  deselect(fields2) {
    const fieldsObj = isArray(fields2) ? Object.fromEntries(fields2.map((field) => [field, true])) : fields2;
    this.selectedFields = this.selectedFields.filter((fieldName) => !fieldsObj[fieldName]);
    return this;
  }
  /**
   * Set the language code for the query result.
   * If no language is specified or the code is invalid, the primary language is used.
   * Non-translatable collections always return results in the primary language.
   *
   * @example
   * ```typescript
   * // Select the German version of the 'settings' collection
   * await query('settings').language('de').read()
   * ```
   */
  language(code) {
    if (collections[this.collection].translatable && supportedLanguages.includes(code)) {
      this.languageOption = code;
    }
    return this;
  }
  /**
   * Retrieve the currently queried language code.
   *
   * @example
   * ```typescript
   * query('settings').getLanguage() // 'en'
   * ```
   */
  getLanguage() {
    return this.languageOption;
  }
  /**
   * Enable field population to retrieve populated field values in the query results.
   *
   * By default, the query builder returns the casted field values without populating related data.
   *
   * @example
   * ```typescript
   * // Without population:
   * await query('settings').select({ blogLandingPage: true }).read()
   * // Output: { blogLandingPage: 1 }
   *
   * // With population:
   * await query('settings').select({ blogLandingPage: true }).populate().read()
   * // Output: { blogLandingPage: { id: 1, path: '/blog' } }
   * ```
   */
  populate() {
    this.populateOption = true;
    return this;
  }
  /**
   * Disable field population to retrieve casted values in the query results.
   *
   * By default, the query builder returns the casted field values without populating related data.
   *
   * @example
   * ```typescript
   * // Without population:
   * await populatedsettingsQuery.select({ blogLandingPage: true }).unpopulate().read()
   * // Output: { blogLandingPage: 1 }
   *
   * // With population:
   * await populatedsettingsQuery.select({ blogLandingPage: true }).read()
   * // Output: { blogLandingPage: { id: 1, path: '/blog' } }
   * ```
   */
  unpopulate() {
    this.populateOption = false;
    return this;
  }
  /**
   * Check whether the query results will be returned with casted or populated field values.
   *
   * @example
   * ```typescript
   * query('settings').getFieldValueType() // 'casted'
   * query('settings').populate().getFieldValueType() // 'populated'
   * ```
   */
  getFieldValueType() {
    return this.populateOption ? "populated" : "casted";
  }
  setFieldValueType(type) {
    this.populateOption = type === "populated";
    return this;
  }
  /**
   * Revalidate fields after fetching from the database and set their values to default if validation fails.
   * This prevents returning invalid existing data in case field or collection definitions are updated.
   *
   * By default, fallback validation is enabled.
   */
  fallback() {
    this.fallbackOption = true;
    return this;
  }
  /**
   * Disable field validation after fetching, potentially speeding up database queries.
   * Beware that this may result in invalid data if field or collection definitions change.
   *
   * By default, fallback validation is enabled.
   */
  noFallback() {
    this.fallbackOption = false;
    return this;
  }
  /**
   * Set the language for the validation messages returned by the query builder.
   *
   * By default, the language is set to the language code defined in the module option `language.primary`.
   */
  contextLanguage(language) {
    this.contextLanguageOption = language;
    return this;
  }
  /**
   * Get a copy of the current query builder options.
   */
  getOptions() {
    return deepClone({
      table: this.table,
      selectedFields: this.selectedFields,
      languageOption: this.languageOption,
      populateOption: this.populateOption,
      fallbackOption: this.fallbackOption,
      contextLanguageOption: this.contextLanguageOption
    });
  }
  /**
   * Create a new query builder with the same state as this one.
   */
  clone() {
    const query = new SingleQueryBuilder(this.collection);
    for (const [key, value] of Object.entries(this.getOptions())) {
      query[key] = value;
    }
    return query;
  }
  /**
   * Reset all query builder options to their default values.
   */
  reset() {
    return this.selectAll().language(primaryLanguage).unpopulate().fallback().contextLanguage(primaryLanguage);
  }
  /**
   * Retrieve collection data that corresponds to the current query parameters.
   *
   * @example
   * ```typescript
   * // Read the 'settings' collection
   * await query('settings').read()
   * // Output: { field1: '...', field2: '...', ... }
   * ```
   */
  async read() {
    const start = performance.now();
    const key = this.generateCacheKey();
    const cached = await this.readFromCache(key);
    if (cached) {
      return cached;
    }
    const record = await (await db()).model(this.table).findOne({ ...await this.applySequelizeWhere(), raw: true }) || await this.ensureRecord();
    const data = {
      ...Object.fromEntries(
        Object.keys(collections[this.collection].fields).map((fieldName) => [fieldName, void 0])
      ),
      id: +record.id,
      language: record.language,
      ...JSON.parse(record.data)
    };
    await this.validateAndFallbackDataAfterFetch(data);
    for (const fieldName in data) {
      if (!this.selectedFields.includes(fieldName)) {
        delete data[fieldName];
      }
    }
    if (this.populateOption) {
      await this.populateRecord(data);
    }
    if (!this.hasNonCachedFieldInSelect()) {
      await this.storeInCache(key, data, start);
    }
    return data;
  }
  /**
   * Validate the `input` data.
   *
   * @returns A Promise that resolves to an object containing validation errors for fields with failed validation.
   */
  async validate(input, operation, skipFields) {
    const errors = {};
    for (const fieldName of this.getOperableFields(input)) {
      if (skipFields?.includes(fieldName)) {
        continue;
      }
      const declaration = collections[this.collection].fields[fieldName];
      const definition = fields[declaration.type];
      if (definition) {
        for (const validator of [...definition.validators, ...declaration.additional?.validators ?? []]) {
          try {
            if (isFunction(validator) || operation === "read" && validator.onRead || operation === "update" && validator.onUpdate) {
              await (isFunction(validator) ? validator : validator.validator)({
                _,
                __,
                allInputs: void 0,
                collection: collections[this.collection],
                collections,
                definition,
                input,
                language: this.contextLanguageOption,
                name: fieldName,
                operation,
                options: resolveCollectionFieldOptions(
                  this.collection,
                  declaration.type,
                  fieldName,
                  declaration.options,
                  fields
                ),
                value: input[fieldName],
                currentQuery: this,
                query: query,
                errors,
                fields
              });
            }
          } catch (e) {
            errors[fieldName] = e.message;
            break;
          }
        }
      }
    }
    return errors;
  }
  /**
   * Update fields of a single-entry collection.
   *
   * @returns A Promise that resolves to an `UpdateResult` object.
   *          If successful, the updated fields will be available in the `record` property.
   *          If there are any field validation errors, they will be available in the `errors` property.
   *          The `message` property may contain an optional error message if there are issues during the database query.
   *
   * @example
   * ```typescript
   * const result = await query('settings').update({
   *   logo: 2,
   *   blogLandingPage: 15,
   *   copyright: '2077',
   * })
   *
   * if (result.success) {
   *   console.log('Updated record:', result.record)
   * } else {
   *   console.error('Update failed:', result.errors)
   * }
   * ```
   */
  async update(input) {
    input = input ?? {};
    if (!isObject(input)) {
      return { success: false, errors: {}, message: __(this.contextLanguageOption, "pruvious-server", "Invalid input") };
    }
    const existing = await (await db()).model(this.table).findOne({ ...await this.applySequelizeWhere(), raw: true }) || await this.ensureRecord();
    const prepared = this.prepareInput(input);
    const sanitized = await this.sanitize(prepared);
    const conditionalLogicResults = this.applyConditionalLogic(sanitized);
    if (Object.keys(conditionalLogicResults.errors).length) {
      return { success: false, errors: conditionalLogicResults.errors };
    }
    const validationErrors = await this.validate(sanitized, "update", conditionalLogicResults.failed);
    if (Object.keys(validationErrors).length) {
      return { success: false, errors: validationErrors };
    }
    const data = { ...JSON.parse(existing.data), ...sanitized };
    if (collections[this.collection].updatedAtField) {
      data[collections[this.collection].updatedAtField] = Date.now();
    }
    try {
      await (await db()).model(this.table).update({ data: JSON.stringify(data) }, await this.applySequelizeWhere());
      const updated = await (await db()).model(this.table).findOne({ ...await this.applySequelizeWhere(), raw: true });
      const updatedData = { id: +updated.id, language: updated.language, ...JSON.parse(updated.data) };
      for (const fieldName of Object.keys(updatedData)) {
        if (!collections[this.collection].fields[fieldName]) {
          delete updatedData[fieldName];
        }
      }
      if (collections[this.collection].translatable) {
        const syncedData = {};
        for (const fieldName of Object.keys(updatedData)) {
          if (collections[this.collection].fields[fieldName].additional?.translatable === false) {
            syncedData[fieldName] = updatedData[fieldName];
          }
        }
        if (Object.keys(syncedData).length) {
          for (const language of supportedLanguages.filter((language2) => language2 !== this.languageOption)) {
            const relatedRecord = await this.clone().reset().language(language).read();
            await (await db()).model(this.table).update(
              { data: JSON.stringify({ ...relatedRecord, ...syncedData }) },
              { where: { name: this.collection, language } }
            );
          }
        }
      }
      await this.validateAndFallbackDataAfterFetch(updatedData);
      for (const fieldName in updatedData) {
        if (!this.selectedFields.includes(fieldName)) {
          delete updatedData[fieldName];
        }
      }
      if (this.populateOption) {
        await this.populateRecord(updatedData);
      }
      await this.clearCache();
      return {
        success: true,
        record: updatedData
      };
    } catch (e) {
      return { success: false, errors: {}, message: e.message };
    }
  }
  async applySequelizeWhere() {
    return {
      where: {
        name: this.collection,
        language: this.languageOption
      }
    };
  }
  async validateAndFallbackDataAfterFetch(data) {
    if (this.fallbackOption) {
      const errors = await this.validate(data, "read");
      const filterArrays = {};
      for (const fieldPath of Object.keys(errors)) {
        const declaration = getProperty(
          collections[this.collection].fields,
          fieldPath.replace(/\.([0-9]+)\./g, ".options.subfields.")
        );
        if (isObject(declaration) && declaration.type) {
          const definition = fields[declaration.type];
          if (definition && declaration.type !== "block") {
            setProperty(
              data,
              fieldPath,
              definition.default({
                definition,
                name: fieldPath,
                options: resolveCollectionFieldOptions(
                  this.collection,
                  declaration.type,
                  fieldPath,
                  declaration.options,
                  fields
                )
              })
            );
          } else if (/\.[0-9]+$/.test(fieldPath)) {
            const parentPath = fieldPath.split(".").slice(0, -1).join(".");
            getProperty(data, parentPath);
            for (const [fieldPath2, value2] of sortNaturalByProp(Object.entries(filterArrays), "0").reverse()) {
              filterArrays[parentPath] = value2;
            }
          } else if (!/\.[a-z_$][a-z0-9_$]*\.fields\./i.test) {
            deleteProperty(data, fieldPath);
          }
        } else if (/\.[0-9]+$/.test(fieldPath)) {
          const parentPath = fieldPath.split(".").slice(0, -1).join(".");
          const value = getProperty(data, parentPath);
          if (isArray(value)) {
            filterArrays[parentPath] = value;
          }
        } else if (!/\.[a-z_$][a-z0-9_$]*\.fields\./i.test) {
          deleteProperty(data, fieldPath);
        }
      }
      for (const [fieldPath, value] of Object.entries(filterArrays)) {
        setProperty(
          data,
          fieldPath,
          value.filter((v) => !isNull(v))
        );
      }
    }
  }
  async populateRecord(record) {
    for (const fieldName of this.selectedFields) {
      const declaration = collections[this.collection].fields[fieldName];
      const definition = fields[declaration.type];
      const population = declaration.additional?.population ?? definition.population;
      if (population) {
        record[fieldName] = await population.populator({
          value: record[fieldName],
          definition,
          name: fieldName,
          options: resolveCollectionFieldOptions(
            this.collection,
            declaration.type,
            fieldName,
            declaration.options,
            fields
          ),
          currentQuery: this,
          query: query,
          fields
        });
      }
    }
  }
  prepareInput(input) {
    return objectOmit(
      objectPick(input, Object.keys(collections[this.collection].fields)),
      this.getImmutableFields()
    );
  }
  getImmutableFields() {
    return Object.keys(collections[this.collection].fields).filter(
      (fieldName) => collections[this.collection].fields[fieldName].additional?.immutable
    );
  }
  getOperableFields(input) {
    return Object.keys(input).filter(
      (fieldName) => fieldName !== "id" && fieldName !== "language" && collections[this.collection].fields[fieldName] && fieldName !== collections[this.collection].createdAtField && fieldName !== collections[this.collection].updatedAtField
    );
  }
  async sanitize(input) {
    const sanitized = {};
    for (const fieldName of this.getOperableFields(input)) {
      const declaration = collections[this.collection].fields[fieldName];
      if (declaration) {
        const definition = fields[declaration.type];
        if (definition) {
          sanitized[fieldName] = input[fieldName];
          for (const sanitizer of [...definition.sanitizers, ...declaration.additional?.sanitizers ?? []]) {
            try {
              if (isFunction(sanitizer) || sanitizer.onUpdate) {
                sanitized[fieldName] = await (isFunction(sanitizer) ? sanitizer : sanitizer.sanitizer)({
                  name: fieldName,
                  value: sanitized[fieldName],
                  definition,
                  input,
                  options: resolveCollectionFieldOptions(
                    this.collection,
                    declaration.type,
                    fieldName,
                    declaration.options,
                    fields
                  ),
                  fields,
                  operation: "update",
                  query: query
                });
              }
            } catch {
            }
          }
        }
      }
    }
    return sanitized;
  }
  applyConditionalLogic(sanitized) {
    const errors = {};
    const failed = [];
    for (const [name, value] of Object.entries(sanitized)) {
      const declaration = collections[this.collection].fields[name];
      const definition = fields[declaration.type];
      if (declaration.additional?.conditionalLogic) {
        try {
          if (!definition.conditionalLogicMatcher({
            conditionalLogic: declaration.additional.conditionalLogic,
            definition,
            errors,
            input: sanitized,
            name,
            options: declaration.options,
            value,
            fields
          })) {
            failed.push(name);
          }
        } catch (e) {
          errors[name] = e.message;
        }
      }
    }
    return { errors, failed };
  }
  hasNonCachedFieldInSelect() {
    if (collections[this.collection].cacheQueries !== false) {
      return this.selectedFields.some((fieldName) => collections[this.collection].nonCachedFields.includes(fieldName));
    }
    return false;
  }
  generateCacheKey() {
    if (collections[this.collection].cacheQueries !== false) {
      let key = `pruvious:query:${this.collection}:select:${this.selectedFields.join(",")}`;
      key += `:language:${JSON.stringify(this.languageOption)}`;
      key += `:populate:${this.populateOption}`;
      key += `:fallback:${this.fallbackOption}`;
      return key;
    }
    return "";
  }
  async storeInCache(key, value, start) {
    const cacheQueries = collections[this.collection].cacheQueries;
    if (cacheQueries !== false && performance.now() - start > cacheQueries) {
      await (await cache())?.set(key, JSON.stringify(value));
    }
  }
  async readFromCache(key) {
    if (collections[this.collection].cacheQueries !== false) {
      const value = await (await cache())?.get(key);
      return value ? JSON.parse(value) : null;
    }
    return null;
  }
  async clearCache() {
    const collection = collections[this.collection];
    if (collection.clearCacheRules && collection.clearCacheRules.onUpdate !== false) {
      await (await cache())?.flushDb();
      await clearPageCache();
    }
  }
  async ensureRecord() {
    const now = Date.now();
    const input = {
      language: this.languageOption,
      name: this.collection,
      data: {}
    };
    for (const fieldName in collections[this.collection].fields) {
      if (fieldName !== "id" && fieldName !== "language") {
        const definition = fields[collections[this.collection].fields[fieldName].type];
        if (definition) {
          input.data[fieldName] = definition.default({
            definition,
            name: fieldName,
            options: collections[this.collection].fields[fieldName].options
          });
        }
      }
    }
    if (collections[this.collection].createdAtField) {
      input.data[collections[this.collection].createdAtField] = now;
    }
    if (collections[this.collection].updatedAtField) {
      input.data[collections[this.collection].updatedAtField] = now;
    }
    input.data = JSON.stringify(input.data);
    await (await db()).model(this.table).create(input);
    return (await db()).model(this.table).findOne({ ...await this.applySequelizeWhere(), raw: true });
  }
}

async function getOptimizedImage(upload, options, contextLanguage) {
  if (!imageTypes.includes(upload.type)) {
    return {
      success: false,
      error: __(contextLanguage ?? primaryLanguage, "pruvious-server", "The upload is not an image")
    };
  }
  const resolvedOptions = options.format === "jpeg" ? { quality: options.quality ?? 80 } : options.format === "webp" ? {
    quality: options.quality ?? 80,
    alphaQuality: options.alphaQuality ?? 100,
    lossless: options.lossless ?? false,
    nearLossless: options.nearLossless ?? false,
    smartSubsample: options.smartSubsample ?? false
  } : {};
  resolvedOptions.format = options.format;
  resolvedOptions.width = options.width ?? null;
  resolvedOptions.height = options.height ?? null;
  resolvedOptions.resize = options.resize ?? "cover";
  resolvedOptions.withoutEnlargement = options.withoutEnlargement ?? false;
  resolvedOptions.withoutReduction = options.withoutReduction ?? false;
  resolvedOptions.position = options.position ?? "center";
  resolvedOptions.interpolation = options.interpolation ?? "lanczos3";
  const uploadsOptions = getModuleOption("uploads");
  const hash$1 = hash(resolvedOptions);
  const image = await (await db()).model("_optimized_images").findOne({ where: { upload_id: upload.id, hash: hash$1 } });
  const paths = generateImagePaths(upload.directory, upload.filename, hash$1, options.format);
  let width = image?.width ?? resolvedOptions.width;
  let height = image?.height ?? resolvedOptions.height;
  if (!image) {
    try {
      const uploadsDir = path$1.resolve(getModuleOption("uploadsDir"));
      const original = uploadsOptions.drive.type === "local" ? fs.readFileSync(path$1.resolve(joinRouteParts(uploadsDir, upload.directory, upload.filename))) : await s3GetObject(joinRouteParts(upload.directory, upload.filename));
      const sharpImage = sharp(original);
      if (resolvedOptions.format === "png") {
        sharpImage.png();
      } else if (resolvedOptions.format === "webp") {
        sharpImage.webp(
          objectPick(resolvedOptions, ["quality", "alphaQuality", "lossless", "nearLossless", "smartSubsample"])
        );
      } else {
        sharpImage.jpeg(objectPick(resolvedOptions, ["quality"]));
      }
      sharpImage.resize({
        width: resolvedOptions.width ?? void 0,
        height: resolvedOptions.height ?? void 0,
        fit: resolvedOptions.resize,
        withoutEnlargement: resolvedOptions.withoutEnlargement,
        withoutReduction: resolvedOptions.withoutReduction,
        position: resolvedOptions.position === "center" ? "centre" : resolvedOptions.position === "topRight" ? "right top" : resolvedOptions.position === "bottomRight" ? "right bottom" : resolvedOptions.position === "bottomLeft" ? "left bottom" : resolvedOptions.position === "topLeft" ? "left top" : resolvedOptions.position,
        kernel: resolvedOptions.interpolation
      });
      const imageBuffer = await sharpImage.toBuffer({ resolveWithObject: true });
      width = imageBuffer.info.width;
      height = imageBuffer.info.height;
      if (uploadsOptions.drive.type === "local") {
        fs.writeFileSync(path$1.resolve(paths.drive), imageBuffer.data);
      } else {
        await s3PutObject(
          paths.drive,
          imageBuffer.data,
          resolvedOptions.format === "jpeg" ? "image/jpeg" : resolvedOptions.format === "webp" ? "image/webp" : "image/png"
        );
      }
      await (await db()).model("_optimized_images").create({ upload_id: upload.id, hash: hash$1, ...resolvedOptions, width, height });
    } catch (e) {
      return { success: false, error: e.message };
    }
  }
  return { success: true, src: paths.public, width, height };
}
function generateImagePaths(directory, filename, hash, format) {
  const options = getModuleOption("uploads");
  const uploadsDir = path$1.resolve(getModuleOption("uploadsDir"));
  const basename = filename.includes(".") ? filename.split(".").slice(0, -1).join(".") : filename;
  const extension = format === "jpeg" ? "jpg" : format === "webp" ? "webp" : "png";
  const imageFilename = `${basename}_${hash}.${extension}`;
  return options.drive.type === "local" ? {
    filename: imageFilename,
    drive: joinRouteParts(uploadsDir, directory, imageFilename),
    public: joinRouteParts(
      getModuleOption("baseUrl"),
      options.drive.urlPrefix ?? "uploads",
      directory,
      imageFilename
    )
  } : {
    filename: imageFilename,
    drive: joinRouteParts(directory, imageFilename),
    public: options.drive.baseUrl + directory + imageFilename
  };
}

const images = /*#__PURE__*/Object.freeze(/*#__PURE__*/Object.defineProperty({
  __proto__: null,
  generateImagePaths: generateImagePaths,
  getOptimizedImage: getOptimizedImage
}, Symbol.toStringTag, { value: 'Module' }));

class UploadsQueryBuilder extends QueryBuilder {
  /**
   * Create a new 'uploads' collection record using the provided `input` data.
   * The `input` must include a special `$file` field which should be an instance of a `File` object.
   *
   * @returns A Promise that resolves to a `CreateResult` object.
   *          If the creation is successful, the `record` property will contain the created upload.
   *          If there are any field validation errors, they will be available in the `errors` property.
   *          The `message` property may contain an optional error message if there are issues during the database query.
   *
   * @example
   * ```typescript
   * const result = await query('uploads').create({
   *   directory: 'notes/',
   *   $file: new File(['foo'], 'foo.txt', { type: 'text/plain' }),
   * })
   *
   * if (result.success) {
   *   console.log('Upload was successful:', result.record)
   * } else {
   *   console.error('Upload failed:', result.errors)
   * }
   * ```
   */
  // @ts-ignore
  async create(input) {
    const selection = this.prepareSelection();
    const result = await super.create(input);
    this.revertSelection(selection);
    if (result.success) {
      const options = getModuleOption("uploads");
      const uploadsDir = path$1.resolve(getModuleOption("uploadsDir"));
      try {
        if (options.drive.type === "local") {
          fs.ensureDirSync(path$1.resolve(joinRouteParts(uploadsDir, result.record.directory)));
          fs.writeFileSync(
            path$1.resolve(joinRouteParts(uploadsDir, result.record.directory, result.record.filename)),
            new DataView(await input.$file.arrayBuffer())
          );
        } else {
          await s3PutObject(
            joinRouteParts(result.record.directory, result.record.filename),
            Buffer.from(await input.$file.arrayBuffer()),
            input.$file.type
          );
        }
        await this.createThumbnail(result.record);
      } catch (e) {
        return { success: false, errors: {}, message: e.message };
      }
      for (const [field, selected] of Object.entries(selection)) {
        if (!selected) {
          delete result.record[field];
        }
      }
    }
    return result;
  }
  /**
   * Create multiple records in the 'uploads' collection using the data provided in the `input` array.
   * Each element of `input` represents a record to be created and must include a `$file` field which
   * must be an instance of a `File` object.
   *
   * @returns A Promise that resolves to a `CreateManyResult` object.
   *          If successful, the created uploads will be available in the `records` property.
   *          If any input has validation errors, the `errors` property will contain an array of error objects at the corresponding index.
   *          If there are no errors for a particular input, the value at that index will be `null`.
   *          The `message` property may contain an optional error message for any database query issues.
   *
   * Note: If any input fails validation, no records will be created.
   *
   * @example
   * ```typescript
   * const result = await query('uploads').createMany([
   *   { $file: new File(['foo'], 'foo-1.txt', { type: 'text/plain' }) },
   *   { $file: new File(['foo'], 'foo-2.txt', { type: 'text/plain' }) },
   *   { $file: ['foo'] },
   * ])
   *
   * if (result.success) {
   *   console.log('Uploads created:', result.records)
   * } else {
   *   console.log('Errors:', result.errors) // [null, null, { $file: 'Invalid input type' }]
   * }
   * ```
   */
  // @ts-ignore
  async createMany(input) {
    const selection = this.prepareSelection();
    const result = await super.createMany(input);
    this.revertSelection(selection);
    if (result.success) {
      const options = getModuleOption("uploads");
      const uploadsDir = path$1.resolve(getModuleOption("uploadsDir"));
      for (const [i, record] of result.records.entries()) {
        try {
          if (options.drive.type === "local") {
            fs.ensureDirSync(path$1.resolve(joinRouteParts(uploadsDir, record.directory)));
            fs.writeFileSync(
              path$1.resolve(joinRouteParts(uploadsDir, record.directory, record.filename)),
              new DataView(await input[i].$file.arrayBuffer())
            );
          } else {
            await s3PutObject(
              joinRouteParts(record.directory, record.filename),
              Buffer.from(await input[i].$file.arrayBuffer()),
              input[i].$file.type
            );
          }
          await this.createThumbnail(record);
        } catch (e) {
          return { success: false, errors: {}, message: e.message };
        }
        for (const [field, selected] of Object.entries(selection)) {
          if (!selected) {
            delete record[field];
          }
        }
      }
    }
    return result;
  }
  /**
   * Update the existing records in the 'uploads' collection based on the defined conditions.
   *
   * @returns A Promise that resolves to an `UpdateResult` object.
   *          If successful, the updated uploads will be available in the `records` property.
   *          If there are any field validation errors, they will be available in the `errors` property.
   *          The `message` property may contain an optional error message if there are issues during the database query.
   *
   * @example
   * ```typescript
   * // Move all uploads in the 'notes/' directory to the 'archived-notes/' directory
   * const result = await query('uploads').whereLike('directory', 'notes/%').update({
   *   directory: 'archived-notes/',
   * })
   *
   * if (result.success) {
   *   console.log('Records updated:', result.records)
   * } else {
   *   console.error('Update failed:', result.errors)
   * }
   * ```
   */
  // @ts-ignore
  async update(input) {
    const options = getModuleOption("uploads");
    const uploadsDir = path$1.resolve(getModuleOption("uploadsDir"));
    const original = await (await db()).model(this.table).findAll({ ...await this.applySequelizeOptions(["where"]), raw: true });
    const selection = this.prepareSelection();
    const result = await super.update(input);
    this.revertSelection(selection);
    if (result.success) {
      const recordIds = result.records.map((record) => record.id);
      const images = await (await db()).model("_optimized_images").findAll({ where: { upload_id: { [Op.in]: recordIds } }, raw: true });
      for (const record of result.records) {
        const originalRecord = original.find((r) => +r.id === record.id);
        if (originalRecord) {
          try {
            const from = joinRouteParts(originalRecord.directory, originalRecord.filename);
            const to = joinRouteParts(record.directory, record.filename);
            if (from !== to) {
              if (options.drive.type === "local") {
                fs.ensureDirSync(path$1.resolve(joinRouteParts(uploadsDir, record.directory)));
                fs.moveSync(
                  path$1.resolve(joinRouteParts(uploadsDir, from)),
                  path$1.resolve(joinRouteParts(uploadsDir, to)),
                  { overwrite: true }
                );
              } else {
                await s3MoveObject(from, to);
              }
              for (const image of images.filter((image2) => +image2.upload_id === record.id)) {
                const from2 = generateImagePaths(
                  originalRecord.directory,
                  originalRecord.filename,
                  image.hash,
                  image.format
                ).drive;
                const to2 = generateImagePaths(record.directory, record.filename, image.hash, image.format).drive;
                const promises = [];
                if (options.drive.type === "local") {
                  fs.moveSync(path$1.resolve(from2), path$1.resolve(to2), { overwrite: true });
                } else {
                  promises.push(s3MoveObject(from2, to2));
                }
                await Promise.all(promises);
              }
            }
          } catch (e) {
            return { success: false, errors: {}, message: e.message };
          }
        }
        for (const [field, selected] of Object.entries(selection)) {
          if (!selected) {
            delete record[field];
          }
        }
      }
    }
    return result;
  }
  /**
   * Delete records from the 'uploads' collection based on the specified conditions.
   *
   * @returns A Promise that resolves to an array containing the deleted uploads.
   *
   * @example
   * ```typescript
   * // Delete all uploads in the 'archived-notes/' directory
   * await query('uploads').select({ id: true }).whereLike('directory', 'archived-notes/%').delete()
   * // Output: [{ id: 30 }, { id: 144 }, { id: 145 }]
   * ```
   */
  // @ts-ignore
  async delete() {
    const options = getModuleOption("uploads");
    const uploadsDir = path$1.resolve(getModuleOption("uploadsDir"));
    const selection = this.prepareSelection();
    const records = await super.delete();
    const recordIds = records.map((record) => record.id);
    const images = await (await db()).model("_optimized_images").findAll({ where: { upload_id: { [Op.in]: recordIds } }, raw: true });
    this.revertSelection(selection);
    for (const record of records) {
      try {
        if (options.drive.type === "local") {
          fs.removeSync(path$1.resolve(joinRouteParts(uploadsDir, record.directory, record.filename)));
          for (const image of images.filter((image2) => +image2.upload_id === record.id)) {
            fs.removeSync(
              path$1.resolve(generateImagePaths(record.directory, record.filename, image.hash, image.format).drive)
            );
          }
        } else {
          await s3DeleteObject(joinRouteParts(record.directory, record.filename));
          const promises = [];
          for (const image of images.filter((image2) => +image2.upload_id === record.id)) {
            promises.push(
              s3DeleteObject(generateImagePaths(record.directory, record.filename, image.hash, image.format).drive)
            );
          }
          await Promise.all(promises);
        }
      } catch {
      }
      for (const [field, selected] of Object.entries(selection)) {
        if (!selected) {
          delete record[field];
        }
      }
    }
    await (await db()).model("_optimized_images").destroy({ where: { upload_id: { [Op.in]: recordIds } } });
    return records;
  }
  async validate(input, operation, allInputs, skipFields) {
    const errors = await super.validate(input, operation, allInputs, skipFields);
    if (operation === "create") {
      if (!input.$file) {
        errors.$file = __(this.contextLanguageOption, "pruvious-server", "This field is required");
      } else {
        if (!(input.$file instanceof File)) {
          errors.$file = __(this.contextLanguageOption, "pruvious-server", "Invalid input type");
        } else if (!input.$file.name || !input.$file.type) {
          errors.$file = __(this.contextLanguageOption, "pruvious-server", "This field is required");
        } else if (input.$file.size > getModuleOption("uploads").maxFileSize) {
          errors.$file = __(this.contextLanguageOption, "pruvious-server", "The maximum allowable file size is $size", {
            size: format(getModuleOption("uploads").maxFileSize, { unitSeparator: " " }) ?? "unknown"
          });
        }
      }
    }
    return errors;
  }
  serializeInput(input) {
    const serialized = super.serializeInput(input);
    serialized.language = "";
    return serialized;
  }
  prepareInput(input, operation) {
    return objectOmit(
      objectPick(input, [...Object.keys(collections["uploads"].fields), "$file"]),
      operation === "update" ? this.getImmutableFields() : []
    );
  }
  getOperableFields(input, operation) {
    const fields = super.getOperableFields(input, operation);
    if (operation === "create") {
      fields.push("$file");
    }
    return fields;
  }
  async sanitize(input, operation) {
    const sanitized = await super.sanitize(input, operation);
    if (operation === "create") {
      sanitized.$file = input.$file;
    }
    return sanitized;
  }
  prepareSelection() {
    const selection = {
      id: this.selectedFields.includes("id"),
      directory: this.selectedFields.includes("directory"),
      filename: this.selectedFields.includes("filename"),
      type: this.selectedFields.includes("type")
    };
    for (const [field, selected] of Object.entries(selection)) {
      if (!selected) {
        this.selectedFields.push(field);
      }
    }
    return selection;
  }
  revertSelection(selection) {
    for (const [field, selected] of Object.entries(selection)) {
      if (!selected) {
        this.deselect({ [field]: true });
      }
    }
  }
  async createThumbnail(upload) {
    if (imageTypes.includes(upload.type) && upload.type !== "image/svg+xml") {
      await getOptimizedImage(upload, { width: 320, height: 320, format: "webp" });
    }
  }
}

function query(collection, contextLanguage = primaryLanguage) {
  if (!collections[collection]) {
    throw new Error(__(contextLanguage, "pruvious-server", "Unknown collection name: '$collection'", { collection }));
  }
  if (collections[collection].mode === "single") {
    return new SingleQueryBuilder(collection, contextLanguage);
  }
  if (getModuleOption("uploads") && collection === "uploads") {
    return new UploadsQueryBuilder("uploads", contextLanguage);
  }
  return new QueryBuilder(collection, contextLanguage);
}

async function cleanExpiredTokens() {
  return await (await db()).model("_tokens").destroy({ where: { exp: { [Op.lt]: Date.now() / 1e3 } } });
}
async function fetchToken(token) {
  try {
    const tokenData = jwt.decode(token);
    const cacheKey = `pruvious:token:${tokenData.userId}:${token}`;
    if (!isValidTokenData(tokenData)) {
      return null;
    }
    if (await (await cache())?.exists(cacheKey)) {
      return { token, ...tokenData };
    }
    if (await (await db()).model("_tokens").count({ where: { token } })) {
      await (await cache())?.set(cacheKey, tokenData.exp, { PX: tokenData.exp * 1e3 - Date.now() });
      return { token, ...tokenData };
    }
  } catch {
  }
  return null;
}
function getBearerToken(event) {
  return getHeader(event, "Authorization")?.slice(7) ?? "";
}
function generateToken(userId, expiresIn) {
  return jwt.sign({ userId, jti: nanoid() }, getModuleOption("jwt").secretKey, { expiresIn });
}
async function removeToken(token) {
  try {
    const tokenData = jwt.decode(token);
    if (!isValidTokenData(tokenData)) {
      return false;
    }
    const deleted = await (await db()).model("_tokens").destroy({ where: { token } });
    await (await cache())?.del(`pruvious:token:${tokenData.userId}:${token}`);
    return !!deleted;
  } catch {
  }
  return false;
}
async function removeUserTokens(userId, except) {
  const where = { user_id: userId };
  if (except) {
    where.token = { [Op.ne]: except };
  }
  const rows = await (await db()).model("_tokens").findAll({ attributes: ["token"], where, raw: true });
  const deleted = await (await db()).model("_tokens").destroy({ where });
  for (const { token } of rows) {
    await (await cache())?.del(`pruvious:token:${userId}:${token}`);
  }
  return deleted;
}
async function storeToken(token) {
  const { userId, iat, exp } = jwt.decode(token);
  await (await db()).model("_tokens").create({ token, user_id: userId, iat, exp });
  await (await cache())?.set(`pruvious:token:${userId}:${token}`, exp, { PX: exp * 1e3 - Date.now() });
}
async function verifyToken(token) {
  try {
    const tokenData = jwt.verify(token, getModuleOption("jwt").secretKey);
    if (isValidTokenData(tokenData)) {
      const stored = await fetchToken(token);
      if (stored?.userId === tokenData.userId && stored.iat === tokenData.iat && stored.exp === tokenData.exp) {
        const user = await query("users").deselect({ password: true }).where("id", tokenData.userId).populate().first();
        if (user && user.isActive) {
          return { isValid: true, user, tokenData };
        }
      }
    }
  } catch {
  }
  return { isValid: false, user: null, tokenData: null };
}
function isValidTokenData(tokenData) {
  return isPositiveInteger(tokenData?.userId) && isPositiveInteger(tokenData.exp) && tokenData.exp >= Date.now() / 1e3;
}

const auth = /*#__PURE__*/Object.freeze(/*#__PURE__*/Object.defineProperty({
  __proto__: null,
  cleanExpiredTokens: cleanExpiredTokens,
  fetchToken: fetchToken,
  generateToken: generateToken,
  getBearerToken: getBearerToken,
  removeToken: removeToken,
  removeUserTokens: removeUserTokens,
  storeToken: storeToken,
  verifyToken: verifyToken
}, Symbol.toStringTag, { value: 'Module' }));

function booleanishSanitizer(context) {
  const v = isString(context.value) ? context.value.toLowerCase() : context.value;
  const t = [true, 1, "1", "true", "t", "yes", "y"];
  const f = [false, 0, "0", "false", "f", "no", "n"];
  return t.includes(v) ? true : f.includes(v) ? false : context.value;
}

function booleanValidator(context, customErrorMessage) {
  if (!isBoolean(context.value)) {
    if (context.__ && context.language) {
      throw new Error(
        context.__(context.language, "pruvious-server", customErrorMessage ?? "Invalid input type")
      );
    } else {
      throw new Error(customErrorMessage ?? "Invalid input type");
    }
  }
}

const presetsCollectionDefinition = defineCollection({
  name: "presets",
  mode: "multi",
  search: {
    default: [
      { field: "name", reserve: 160 },
      { field: "blocks", fieldValueType: "populated" }
    ]
  },
  translatable: true,
  contentBuilder: {
    blocksField: "blocks"
  },
  dashboard: {
    icon: "Transform",
    primaryField: "name",
    overviewTable: {
      columns: [{ field: "name", width: 72.9 }, "createdAt", "updatedAt"]
    }
  },
  fields: {
    /*
    |--------------------------------------------------------------------------
    | name
    |--------------------------------------------------------------------------
    |
    */
    name: {
      type: "text",
      options: {
        label: "Name",
        required: true
      },
      additional: {
        unique: "perLanguage",
        validators: [
          (context) => uniqueValidator(
            context,
            context.__(context.language, "pruvious-server", "A preset with this name already exists")
          )
        ]
      }
    },
    /*
    |--------------------------------------------------------------------------
    | blocks
    |--------------------------------------------------------------------------
    |
    */
    blocks: {
      type: "repeater",
      options: {
        label: "Blocks",
        description: "The blocks that make up the preset content.",
        subfields: {
          block: {
            type: "block",
            options: {
              label: "Block"
            }
          }
        },
        addLabel: "Add block"
      }
    }
  }
});

const previewsCollectionDefinition = defineCollection({
  name: "previews",
  mode: "multi",
  dashboard: { visible: false },
  clearCacheRules: false,
  fields: {
    token: {
      type: "text",
      options: {
        label: "Preview token",
        required: true
      },
      additional: {
        unique: "allLanguages",
        immutable: true,
        sanitizers: [{ onCreate: true, sanitizer: () => nanoid() }],
        validators: [
          ({ __, language, value }) => {
            if (!/^[a-z0-9_-]+$/i.test(value)) {
              throw new Error(__(language, "pruvious-server", "The preview token must be a URL-safe string"));
            }
          },
          (context) => uniqueValidator(
            context,
            context.__(context.language, "pruvious-server", "A preview with this token already exists")
          )
        ]
      }
    },
    collection: {
      type: "text",
      options: {
        label: "Collection",
        description: "The name of the previewed collection.",
        required: true
      },
      additional: {
        validators: [
          ({ __, collections, language, value }) => {
            if (value === "presets") {
              return;
            } else if (!collections[value]) {
              throw new Error(__(language, "pruvious-server", "Invalid collection"));
            } else if (collections[value].mode !== "multi" || !collections[value].publicPages) {
              throw new Error(__(language, "pruvious-server", "This collection cannot be previewed"));
            }
          }
        ]
      }
    },
    data: {
      type: "text",
      options: {
        label: "Data",
        description: "The stringified JSON data used to render the page preview.",
        required: true
      },
      additional: {
        validators: [
          ({ __, language, value }) => {
            try {
              JSON.parse(value);
            } catch {
              throw new Error(__(language, "pruvious-server", "Invalid JSON"));
            }
          }
        ]
      }
    }
  }
});

const redirectsCollectionDefinition = defineCollection({
  name: "redirects",
  mode: "single",
  label: { collection: { plural: "Redirection", singular: "Redirection" } },
  dashboard: {
    icon: "ArrowBounce",
    fieldLayout: [
      {
        Rules: ["rules"],
        Test: ["<~runtime/components/misc/RedirectsTest.vue>"]
      }
    ]
  },
  cacheQueries: 0,
  fields: {
    /*
    |--------------------------------------------------------------------------
    | rules
    |--------------------------------------------------------------------------
    |
    */
    rules: {
      type: "repeater",
      options: {
        label: "Redirection rules",
        description: "Redirects are applied in the specified order.",
        subfields: {
          isRegExp: {
            type: "switch",
            options: {
              label: "RegExp match",
              description: "Whether to use JavaScript regular expressions to match the path."
            }
          },
          code: {
            type: "button-group",
            options: {
              label: "Status code",
              description: "Whether the redirection is intended to be permanent (301) or temporary (302). Search engine robots, RSS readers, and other web crawlers will update their links to the target URL.",
              choices: {
                "301": "301",
                "302": "302"
              },
              default: "302",
              required: true
            }
          },
          forwardQueryParams: {
            type: "switch",
            options: {
              label: "Forward query parameters",
              description: "Whether to forward query parameters to the target URL."
            }
          },
          from: {
            type: "text",
            options: {
              label: "Match",
              description: "The path to match.",
              placeholder: "e.g., /news",
              required: true
            },
            additional: {
              conditionalLogic: { isRegExp: false },
              validators: [
                ({ __, language, value }) => {
                  if (!value.startsWith("/")) {
                    throw new Error(__(language, "pruvious-server", "The path must start with a slash ('/')"));
                  }
                }
              ]
            }
          },
          fromRegExp: {
            type: "text",
            options: {
              label: "Match (RegExp)",
              description: "The JavaScript regular expression to match. You can use indexed capture groups in **$n** format to replace parts of the target URL.",
              placeholder: "e.g., ^/news/(.*)$",
              required: true
            },
            additional: {
              conditionalLogic: { isRegExp: true },
              validators: [
                ({ __, language, value }) => {
                  try {
                    new RegExp(value);
                  } catch (e) {
                    throw new Error(__(language, "pruvious-server", e.message));
                  }
                }
              ]
            }
          },
          to: {
            type: "text",
            options: {
              label: "Redirect to",
              description: "The target path or URL.",
              placeholder: "e.g., /blog",
              required: true
            },
            additional: {
              conditionalLogic: { isRegExp: false },
              validators: [
                ({ __, language, value }) => {
                  if (!value.startsWith("/") && !value.startsWith("http")) {
                    throw new Error(
                      __(
                        language,
                        "pruvious-server",
                        "The target must be a path starting with a slash ('/') or a URL starting with 'http'"
                      )
                    );
                  }
                }
              ]
            }
          },
          toRegExp: {
            type: "text",
            options: {
              label: "Redirect to (RegExp)",
              description: "The target JavaScript regular expression. You can use indexed capture groups in **$n** format to replace parts of the target URL.",
              placeholder: "e.g., /blog/$1",
              required: true
            },
            additional: {
              conditionalLogic: { isRegExp: true },
              validators: [
                ({ __, language, value }) => {
                  if (!value.startsWith("/") && !value.startsWith("http")) {
                    throw new Error(
                      __(
                        language,
                        "pruvious-server",
                        "The target must be a path starting with a slash ('/') or a URL starting with 'http'"
                      )
                    );
                  }
                }
              ]
            }
          }
        },
        fieldLayout: [
          ["isRegExp | 10rem", "code | 10rem", "from", "fromRegExp"],
          ["forwardQueryParams | 20rem", "to", "toRegExp"]
        ]
      }
    }
  }
});

const rolesCollectionDefinition = defineCollection({
  name: "roles",
  mode: "multi",
  search: { default: [{ field: "name", reserve: 60 }, "capabilities"] },
  dashboard: {
    icon: "Shield",
    primaryField: "name"
  },
  fields: {
    name: {
      type: "text",
      options: {
        label: "Role name",
        description: "A unique role name.",
        required: true
      },
      additional: {
        unique: "perLanguage",
        validators: [uniqueValidator]
      }
    },
    capabilities: {
      type: "chips",
      options: {
        label: "Role capabilities",
        description: "List of capabilities assigned to this role. Users with this role inherit these capabilities.",
        placeholder: "Add capability",
        choices: Object.fromEntries(
          userCapabilities.map((capability) => [
            capability,
            capability.startsWith("collection-") ? titleCase(
              capability.replace(
                /^collection-([a-z0-9-]+)-(create-many|read-many|update-many|delete-many|create|read|update|delete)$/i,
                "$2-$1"
              ),
              false
            ) : titleCase(capability, false)
          ])
        ),
        overrideType: "UserCapability[]",
        tooltips: true,
        sortable: true
      }
    }
  }
});

const seoCollectionDefinition = defineCollection({
  name: "seo",
  mode: "single",
  label: { collection: { plural: "SEO", singular: "SEO" } },
  translatable: true,
  dashboard: {
    icon: "InputSearch",
    fieldLayout: [
      {
        General: ["baseUrl", ["baseTitle", "titleSeparator | 10rem", "baseTitlePosition | 10rem"], "visible"],
        Images: ["sharingImage", "logo", "favicon"],
        Meta: ["socialMediaMeta", "metaTags"],
        Scripts: ["scripts"]
      }
    ]
  },
  fields: {
    /*
    |--------------------------------------------------------------------------
    | baseUrl
    |--------------------------------------------------------------------------
    |
    */
    baseUrl: {
      type: "text",
      options: {
        label: "Base URL",
        description: "The base URL of the website.",
        placeholder: "e.g., https://example.com"
      },
      additional: {
        translatable: false,
        sanitizers: [({ value }) => isString(value) ? value.replace(/\/+$/, "") : value],
        validators: [
          ({ __, language, value }) => {
            if (value && !isUrl(value)) {
              throw new Error(__(language, "pruvious-server", "Invalid URL"));
            }
          }
        ]
      }
    },
    /*
    |--------------------------------------------------------------------------
    | baseTitle
    |--------------------------------------------------------------------------
    |
    */
    baseTitle: {
      type: "text",
      options: {
        label: "Base title",
        description: "Text displayed in browsers before or after the regular page title (e.g., Page Title | Base Title).",
        default: "My Pruvious Site"
      }
    },
    /*
    |--------------------------------------------------------------------------
    | titleSeparator
    |--------------------------------------------------------------------------
    |
    */
    titleSeparator: {
      type: "text",
      options: {
        label: "Title separator",
        description: "Characters used to separate the page title and base title.",
        default: " | ",
        trim: false
      }
    },
    /*
    |--------------------------------------------------------------------------
    | baseTitlePosition
    |--------------------------------------------------------------------------
    |
    */
    baseTitlePosition: {
      type: "button-group",
      options: {
        label: "Base title position",
        description: "The position of the base title relative to the page title.",
        choices: { before: "Before", after: "After" },
        default: "after"
      }
    },
    /*
    |--------------------------------------------------------------------------
    | visible
    |--------------------------------------------------------------------------
    |
    */
    visible: {
      type: "switch",
      options: {
        label: "Search engine visibility",
        description: "Discourage search engines from indexing this site. It is up to search engines to honor this request.",
        falseLabel: "Hidden",
        trueLabel: "Visible",
        default: true
      }
    },
    /*
    |--------------------------------------------------------------------------
    | sharingImage
    |--------------------------------------------------------------------------
    |
    */
    sharingImage: {
      type: "image",
      options: {
        label: "Default sharing image",
        sources: [{ format: "jpeg", width: 1200, height: 630, quality: 90 }],
        minWidth: 1200,
        minHeight: 630,
        transformSvgs: true,
        description: "An image that appears when someone shares a page link on a social network. The optimal image size is 1200 \xD7 630 pixels."
      }
    },
    /*
    |--------------------------------------------------------------------------
    | logo
    |--------------------------------------------------------------------------
    |
    */
    logo: {
      type: "image",
      options: {
        label: "Organization logo",
        allowedTypes: ["bmp", "gif", "jpeg", "png", "webp", "svg"],
        minWidth: 112,
        minHeight: 112,
        description: "Specify the image Google uses for your organization's logo in search results and in the Google knowledge panel."
      }
    },
    /*
    |--------------------------------------------------------------------------
    | favicon
    |--------------------------------------------------------------------------
    |
    */
    favicon: {
      type: "image",
      options: {
        label: "Favicon",
        allowedTypes: ["svg"],
        transformSvgs: true,
        sources: [{ format: "png", width: 48, height: 48, resize: "contain" }],
        minWidth: 112,
        minHeight: 112,
        description: "A small square image that appears next to the URL in a browser's address bar."
      }
    },
    /*
    |--------------------------------------------------------------------------
    | socialMediaMeta
    |--------------------------------------------------------------------------
    |
    */
    socialMediaMeta: {
      type: "switch",
      options: {
        label: "Social media",
        description: "Whether to auto-generate **og** and **twitter** meta tags based on the current page title, description, and URL.",
        falseLabel: "Manual",
        trueLabel: "Auto",
        default: true
      }
    },
    /*
    |--------------------------------------------------------------------------
    | metaTags
    |--------------------------------------------------------------------------
    |
    */
    metaTags: {
      type: "repeater",
      options: {
        label: "Default meta tags",
        description: "The **<meta>** tags for this site. Values entered here will override other automatically generated meta tags.",
        addLabel: "Add meta tag",
        fieldLayout: [["name | 20rem", "content"]],
        subfields: {
          name: {
            type: "text",
            options: {
              label: "Name",
              description: "The name of the meta tag.",
              required: true,
              placeholder: "e.g., author"
            }
          },
          content: {
            type: "text",
            options: {
              label: "Content",
              description: "The content of the meta tag.",
              required: true,
              placeholder: "e.g., John Doe"
            }
          }
        }
      }
    },
    /*
    |--------------------------------------------------------------------------
    | scripts
    |--------------------------------------------------------------------------
    |
    */
    scripts: {
      type: "repeater",
      options: {
        label: "Scripts",
        description: "List of external scripts or inline JS code that can be placed in different positions on all pages of the website.",
        addLabel: "Add script",
        fieldLayout: [["kind | 10rem", "position | 16rem", "url", "js"]],
        subfields: {
          kind: {
            type: "button-group",
            options: {
              label: "Kind",
              choices: { external: "External", inline: "Inline" },
              required: true,
              default: "external"
            }
          },
          url: {
            type: "text",
            options: {
              label: "URL",
              required: true
            },
            additional: {
              conditionalLogic: { kind: "external" }
            }
          },
          js: {
            type: "text-area",
            // @todo code field
            options: {
              label: "JavaScript",
              required: true
            },
            additional: {
              conditionalLogic: { kind: "inline" }
            }
          },
          position: {
            type: "select",
            options: {
              label: "Position",
              choices: { head: "Head", bodyOpen: "Body (after opening tag)", bodyClose: "Body (before closing tag)" },
              required: true,
              default: "bodyClose"
            }
          }
        }
      }
    }
  }
});

const uploadsCollectionDefinition = defineCollection({
  name: "uploads",
  mode: "multi",
  search: {
    default: [
      { field: "filename", reserve: 64 },
      { field: "directory", reserve: 256 },
      { field: "type", reserve: 32 },
      "description"
    ]
  },
  uniqueCompositeIndexes: [["directory", "filename"]],
  dashboard: {
    icon: "Photo",
    overviewTable: {
      searchLabel: ["filename", "directory"]
    }
  },
  fields: {
    /*
    |--------------------------------------------------------------------------
    | directory
    |--------------------------------------------------------------------------
    |
    */
    directory: {
      type: "text",
      options: {
        description: [
          "The directory path.",
          "Use a forward slash (`/`) to separate directory names.",
          "Use an empty string (`''`) to indicate the root directory."
        ]
      },
      additional: {
        index: true,
        sanitizers: [
          ({ value }) => {
            if (isString(value)) {
              const sanitized = joinRouteParts(value.toLowerCase()).slice(1) + "/";
              return sanitized === "/" ? "" : sanitized;
            }
            return value;
          }
        ],
        validators: [
          lowercaseValidator,
          ({ __: __2, language, value }) => {
            if (value !== "" && !isUrlPath(value, true)) {
              throw new Error(__2(language, "pruvious-server", "The directory must be a URL-safe string"));
            }
          },
          {
            onCreate: true,
            onUpdate: true,
            validator: ({ errors, input, language }) => {
              if (isUndefined(input.filename)) {
                errors.filename = __(language, "pruvious-server", "This field is required");
              }
            }
          }
        ]
      }
    },
    /*
    |--------------------------------------------------------------------------
    | filename
    |--------------------------------------------------------------------------
    |
    */
    filename: {
      type: "text",
      options: {
        label: "Name",
        description: "The name of the file."
      },
      additional: {
        index: true,
        sanitizers: [
          {
            onCreate: true,
            sanitizer: async ({ input, name, query, value }) => {
              if (isUndefined(input[name]) && isFile(input.$file)) {
                const filename = slugify(input.$file.name);
                if (filename && await query("uploads").where("directory", isString(input.directory) ? parseMediaDirectoryName(input.directory) : "").where("filename", filename).exists()) {
                  const basename = filename.includes(".") ? filename.split(".").slice(0, -1).join(".") : filename;
                  const extension = filename.split(".").pop() ?? "";
                  const existing = await query("uploads").select({ filename: true }).where("directory", isString(input.directory) ? parseMediaDirectoryName(input.directory) : "").whereLike("filename", `${basename}%`).all();
                  let i = 1;
                  while (existing.some(
                    ({ filename: filename2 }) => filename2 === (extension ? `${basename}-${i}.${extension}` : `${basename}-${i}`)
                  )) {
                    i++;
                  }
                  return extension ? `${basename}-${i}.${extension}` : `${basename}-${i}`;
                }
                return filename;
              }
              return value;
            }
          },
          ({ value }) => isString(value) ? value.toLowerCase() : value
        ],
        validators: [
          requiredValidator,
          lowercaseValidator,
          ({ __: __2, language, value }) => {
            if (!isUrlPath(value, true)) {
              throw new Error(__2(language, "pruvious-server", "The filename must be a URL-safe string"));
            } else if (value.endsWith(".")) {
              throw new Error(__2(language, "pruvious-server", "The filename must not end with a period"));
            }
          },
          {
            onCreate: true,
            onUpdate: true,
            validator: ({ errors, input, language }) => {
              if (isUndefined(input.directory)) {
                errors.directory = __(language, "pruvious-server", "This field is required");
              }
            }
          },
          async ({ __: __2, allInputs, currentQuery, input, language, operation, value }) => {
            if (operation === "read") {
              return;
            }
            const query = currentQuery;
            const directory = input.directory;
            const filename = value;
            const uniqueErrorMessage = __2(language, "pruvious-server", "The file path must be unique");
            if (allInputs?.some(
              (_input) => _input !== input && _input.directory === directory && _input.filename === filename
            )) {
              throw new Error(uniqueErrorMessage);
            }
            if (operation === "create" && await query.clone().reset().where("directory", directory).where("filename", filename).exists()) {
              throw new Error(uniqueErrorMessage);
            }
            if (operation === "update") {
              const subjects = await query.clone().clearGroup().clearOffset().clearLimit().select({ id: true, filename: true }).all();
              if (subjects.length > 1) {
                throw new Error(uniqueErrorMessage);
              } else if (subjects.length === 1) {
                const prevExtension = subjects[0].filename.split(".").pop() ?? "";
                const currentExtension = filename.split(".").pop() ?? "";
                if (prevExtension !== currentExtension) {
                  throw new Error(__2(language, "pruvious-server", "The file extension cannot be changed"));
                }
                if (await query.clone().reset().where("directory", directory).where("filename", filename).whereNe("id", subjects[0].id).exists()) {
                  throw new Error(uniqueErrorMessage);
                }
              }
            }
          }
        ]
      }
    },
    /*
    |--------------------------------------------------------------------------
    | type
    |--------------------------------------------------------------------------
    |
    */
    type: {
      type: "text",
      options: {
        description: "The MIME type of the file."
      },
      additional: {
        index: true,
        immutable: true,
        sanitizers: [
          {
            onCreate: true,
            sanitizer: ({ input }) => isFile(input.$file) && isString(input.$file.type) ? input.$file.type.toLowerCase() : ""
          }
        ]
      }
    },
    /*
    |--------------------------------------------------------------------------
    | size
    |--------------------------------------------------------------------------
    |
    */
    size: {
      type: "number",
      options: {
        description: "The file size in bytes."
      },
      additional: {
        index: true,
        immutable: true,
        sanitizers: [
          {
            onCreate: true,
            sanitizer: ({ input }) => isFile(input.$file) && isNumber(input.$file.size) ? input.$file.size : 0
          }
        ]
      }
    },
    /*
    |--------------------------------------------------------------------------
    | width
    |--------------------------------------------------------------------------
    |
    */
    width: {
      type: "number",
      options: {
        description: "The image width in pixels. This field is only applicable to images."
      },
      additional: {
        immutable: true,
        sanitizers: [
          {
            onCreate: true,
            sanitizer: async ({ input }) => {
              if (isFile(input.$file) && imageTypes.includes(input.$file.type.toLowerCase())) {
                try {
                  const sharp = (await import('sharp')).default;
                  const metadata = await sharp(await input.$file.arrayBuffer()).metadata();
                  return metadata.width ?? 0;
                } catch {
                }
              }
              return 0;
            }
          }
        ]
      }
    },
    /*
    |--------------------------------------------------------------------------
    | height
    |--------------------------------------------------------------------------
    |
    */
    height: {
      type: "number",
      options: {
        description: "The image height in pixels. This field is only applicable to images."
      },
      additional: {
        immutable: true,
        sanitizers: [
          {
            onCreate: true,
            sanitizer: async ({ input }) => {
              if (isFile(input.$file) && imageTypes.includes(input.$file.type.toLowerCase())) {
                try {
                  const sharp = (await import('sharp')).default;
                  const metadata = await sharp(await input.$file.arrayBuffer()).metadata();
                  return metadata.height ?? 0;
                } catch {
                }
              }
              return 0;
            }
          }
        ]
      }
    },
    /*
    |--------------------------------------------------------------------------
    | description
    |--------------------------------------------------------------------------
    |
    */
    description: {
      type: "text",
      options: {
        description: [
          "A brief description of the file.",
          "The description is used as the default **alt** attribute for images."
        ],
        spellcheck: true
      }
    }
  }
});

async function fetchSubsetRecords(query, operation, cache) {
  if (cache?.data[cache.key]) {
    return cache.data[cache.key];
  }
  const clone = query.clone().selectAll().clearGroup().unpopulate();
  if (operation === "create") {
    clone.clearWhere();
  }
  if (operation !== "read") {
    clone.clearOffset().clearLimit();
  }
  const records = await clone.all();
  if (cache) {
    cache.data[cache.key] = records;
  }
  return records;
}

const usersCollectionDefinition = defineCollection({
  name: "users",
  mode: "multi",
  search: {
    default: [
      { field: "firstName", reserve: 60 },
      { field: "lastName", reserve: 60 },
      { field: "email", reserve: 60 },
      { field: "isActive", extractKeywords: ({ value }) => value ? "active" : "", reserve: 6 },
      { field: "isAdmin", extractKeywords: ({ value }) => value ? "administrator" : "", reserve: 13 },
      {
        field: "capabilities",
        extractKeywords: async ({ value, record }) => uniqueArray([...value, ...record.role?.capabilities ?? []]).sort().join(", "),
        fieldValueType: "populated"
      }
    ]
  },
  nonCachedFields: ["password"],
  guards: [
    {
      onDelete: true,
      guard: async ({ cache, currentQuery, language, user }) => {
        const records = await fetchSubsetRecords(currentQuery, "delete", {
          data: cache,
          key: "records"
        });
        for (const { id, isAdmin } of records) {
          if (id === user?.id) {
            throw new Error(__(language, "pruvious-server", "You cannot delete your own user account"));
          } else if (isAdmin) {
            throw new Error(__(language, "pruvious-server", "You are not authorized to delete admin users"));
          }
        }
      }
    }
  ],
  dashboard: {
    icon: "Users",
    primaryField: "email",
    overviewTable: {
      columns: [{ field: "email", width: 30 }, "firstName", "lastName", "role", "isAdmin", "createdAt"],
      searchLabel: ["firstName", "email"]
    },
    fieldLayout: [
      ["firstName", "lastName"],
      ["email", "isActive", "isAdmin"],
      "<~runtime/components/misc/UserPasswordField.vue>",
      "role",
      "capabilities",
      ["<~runtime/components/misc/DateFormatField.vue>", "<~runtime/components/misc/TimeFormatField.vue>"]
    ],
    additionalRecordOptionsVueComponent: "~runtime/components/misc/LogoutUserFromAllSessions.vue"
  },
  fields: {
    /*
    |--------------------------------------------------------------------------
    | isActive
    |--------------------------------------------------------------------------
    |
    */
    isActive: {
      type: "switch",
      options: {
        label: "Status",
        description: "Determines the user's login access to the CMS.",
        trueLabel: "Active",
        falseLabel: "Inactive"
      },
      additional: {
        guards: [
          {
            onUpdate: true,
            guard: async ({ cache, operation, currentQuery, language, value }) => {
              if (!value) {
                const records = await fetchSubsetRecords(currentQuery, operation, {
                  data: cache,
                  key: "records"
                });
                if (records.some(({ isAdmin }) => isAdmin)) {
                  throw new Error(__(language, "pruvious-server", "You are not authorized to deactivate admin users"));
                }
              }
            }
          }
        ]
      }
    },
    /*
    |--------------------------------------------------------------------------
    | isAdmin
    |--------------------------------------------------------------------------
    |
    */
    isAdmin: {
      type: "switch",
      options: {
        label: "Administrator",
        description: "Administrators have all privileges within the CMS, regardless of their role and capabilities."
      },
      additional: {
        guards: [
          async ({ cache, currentQuery, language, operation, value }) => {
            if (operation === "create") {
              if (value) {
                throw new Error(__(language, "pruvious-server", "You are not authorized to create admin users"));
              }
            } else if (operation === "update") {
              const records = await fetchSubsetRecords(currentQuery, "update", {
                data: cache,
                key: "records"
              });
              if (value && records.some(({ isAdmin }) => !isAdmin)) {
                throw new Error(
                  __(language, "pruvious-server", "You are not authorized to promote users to admin status")
                );
              } else if (!value && records.some(({ isAdmin }) => isAdmin)) {
                throw new Error(__(language, "pruvious-server", "You are not authorized to demote admin users"));
              }
            }
          }
        ]
      }
    },
    /*
    |--------------------------------------------------------------------------
    | firstName
    |--------------------------------------------------------------------------
    |
    */
    firstName: {
      type: "text",
      options: {
        label: "First name",
        autocomplete: "given-name"
      }
    },
    /*
    |--------------------------------------------------------------------------
    | lastName
    |--------------------------------------------------------------------------
    |
    */
    lastName: {
      type: "text",
      options: {
        label: "Last name",
        autocomplete: "family-name"
      }
    },
    /*
    |--------------------------------------------------------------------------
    | email
    |--------------------------------------------------------------------------
    |
    */
    email: {
      type: "text",
      options: {
        label: "Email address",
        required: true,
        type: "email",
        autocomplete: "email"
      },
      additional: {
        index: true,
        unique: "perLanguage",
        guards: [
          {
            onCreate: false,
            onUpdate: true,
            guard: async ({ value, cache, currentQuery, language }) => {
              const records = await fetchSubsetRecords(currentQuery, "update", {
                data: cache,
                key: "records"
              });
              if (records.some(({ isAdmin, email }) => isAdmin && email !== value)) {
                throw new Error(
                  __(
                    language,
                    "pruvious-server",
                    "You are not authorized to modify the email addresses of admin users"
                  )
                );
              }
            }
          }
        ],
        validators: [emailValidator, uniqueValidator]
      }
    },
    /*
    |--------------------------------------------------------------------------
    | password
    |--------------------------------------------------------------------------
    |
    */
    password: {
      type: "text",
      options: {
        label: "Password",
        required: true,
        trim: false,
        type: "password",
        autocomplete: "new-password"
      },
      additional: {
        protected: true,
        guards: [
          {
            onCreate: false,
            onUpdate: true,
            guard: async ({ cache, currentQuery, language }) => {
              const records = await fetchSubsetRecords(currentQuery, "update", {
                data: cache,
                key: "records"
              });
              if (records.some(({ isAdmin }) => isAdmin)) {
                throw new Error(
                  __(language, "pruvious-server", "You are not authorized to change passwords for admin users")
                );
              }
            }
          }
        ],
        sanitizers: [
          async ({ value }) => {
            return isString(value) && value.length >= 8 ? await argon2.hash(value) : value;
          }
        ],
        validators: [
          ({ language, value }) => {
            if (value.length < 8) {
              throw new Error(__(language, "pruvious-server", "The password must be at least 8 characters long"));
            }
          }
        ]
      }
    },
    /*
    |--------------------------------------------------------------------------
    | role
    |--------------------------------------------------------------------------
    |
    */
    role: {
      type: "record",
      options: {
        label: "Role",
        description: "The user role defines the user's base capabilities within the CMS.",
        collection: "roles",
        fields: { id: true, name: true, capabilities: true },
        populate: true
      },
      additional: {
        foreignKey: { table: "roles" }
      }
    },
    /*
    |--------------------------------------------------------------------------
    | capabilities
    |--------------------------------------------------------------------------
    |
    */
    capabilities: {
      type: "chips",
      options: {
        label: "User capabilities",
        description: "List of capabilities granted to the user in addition to their role capabilities.",
        placeholder: "Add capability",
        choices: Object.fromEntries(
          userCapabilities.map((capability) => [
            capability,
            capability.startsWith("collection-") ? titleCase(
              capability.replace(
                /^collection-([a-z0-9-]+)-(create-many|read-many|update-many|delete-many|create|read|update|delete)$/i,
                "$2-$1"
              ),
              false
            ) : titleCase(capability, false)
          ])
        ),
        overrideType: "UserCapability[]",
        tooltips: true,
        sortable: true
      }
    },
    /*
    |--------------------------------------------------------------------------
    | dashboardLanguage
    |--------------------------------------------------------------------------
    |
    */
    dashboardLanguage: {
      type: "select",
      options: {
        label: "Dashboard language",
        description: "The preferred language for the dashboard interface.",
        required: true,
        default: "en",
        choices: { en: "English" }
      },
      additional: {
        sanitizers: [{ onCreate: true, sanitizer: (context) => context.value || defaultSanitizer(context) }]
      }
    },
    /*
    |--------------------------------------------------------------------------
    | dateFormat
    |--------------------------------------------------------------------------
    |
    */
    dateFormat: {
      type: "text",
      options: {
        label: "Date format",
        required: true,
        description: [
          `**YY** - Two-digit year (e.g. 23)`,
          `**YYYY** - Four-digit year (e.g. 2023)`,
          `**M** - The month, beginning at 1 (e.g. 1-12)`,
          `**MM** - The month, 2-digits (e.g. 01-12)`,
          `**MMM** - The abbreviated month name (e.g. Jan-Dec)`,
          `**MMMM** - The full month name (e.g. January-December)`,
          `**D** - The day of the month (e.g. 1-31)`,
          `**DD** - The day of the month, 2-digits (e.g. 01-31)`,
          `**d** - The day of the week, with Sunday as 0 (e.g. 0-6)`,
          `**dd** - The min name of the day of the week (e.g. Su-Sa)`,
          `**ddd** - The short name of the day of the week (e.g. Sun-Sat)`,
          `**dddd** - The name of the day of the week (e.g. Sunday-Saturday)`,
          `**Q** - Quarter (e.g. 1-4)`,
          `**Do** - Day of Month with ordinal (e.g. 1st 2nd ... 31st)`,
          `**w** - Week of year (e.g. 1 2 ... 52 53)`,
          `**ww** - Week of year, 2-digits (e.g. 01 02 ... 52 53)`,
          `**W** - ISO Week of year (e.g. 1 2 ... 52 53)`,
          `**WW** - ISO Week of year, 2-digits (e.g. 01 02 ... 52 53)`,
          `**wo** - Week of year with ordinal (e.g. 1st 2nd ... 52nd 53rd)`,
          `**[...]** - Escaped characters (e.g. [Year])`
        ],
        default: "YYYY-MM-DD"
      },
      additional: {
        sanitizers: [{ onCreate: true, sanitizer: (context) => context.value || defaultSanitizer(context) }]
      }
    },
    /*
    |--------------------------------------------------------------------------
    | timeFormat
    |--------------------------------------------------------------------------
    |
    */
    timeFormat: {
      type: "text",
      options: {
        label: "Time format",
        required: true,
        description: [
          `**H** - The hour (e.g. 0-23)`,
          `**HH** - The hour, 2-digits (e.g. 00-23)`,
          `**h** - The hour, 12-hour clock (e.g. 1-12)`,
          `**hh** - The hour, 12-hour clock, 2-digits (e.g. 01-12)`,
          `**m** - The minute (e.g. 0-59)`,
          `**mm** - The minute, 2-digits (e.g. 00-59)`,
          `**s** - The second (e.g. 0-59)`,
          `**ss** - The second, 2-digits (e.g. 00-59)`,
          `**SSS** - The millisecond, 3-digits (e.g. 000-999)`,
          `**Z** - The offset from UTC, \xB1HH:mm (e.g. +05:00)`,
          `**ZZ** - The offset from UTC, \xB1HHmm (e.g. +0500)`,
          `**A** - AM PM`,
          `**a** - am pm`,
          `**k** - The hour, beginning at 1 (e.g. 1-24)`,
          `**kk** - The hour, 2-digits, beginning at 1 (e.g. 01-24)`,
          `**z** - Abbreviated named offset (e.g. GMT+1)`,
          `**zzz** - Unabbreviated named offset (e.g. Central European Standard Time)`,
          `**[...]** - Escaped characters (e.g. [Hours])`
        ],
        default: "HH:mm:ss"
      },
      additional: {
        sanitizers: [{ onCreate: true, sanitizer: (context) => context.value || defaultSanitizer(context) }]
      }
    }
  }
});

const formSubmissionsCollectionDefinition = defineCollection({
  name: "form-submissions",
  mode: "multi",
  label: "\u041E\u0442\u0432\u0435\u0442\u044B \u0424\u043E\u0440\u043C",
  apiRoutes: {
    read: "public",
    create: "public"
    // Unsure if this is necessary
  },
  fields: {
    form: {
      type: "record",
      options: {
        label: "\u0424\u043E\u0440\u043C\u0430",
        description: "\u0424\u043E\u0440\u043C\u0430, \u0434\u0430\u043D\u043D\u044B\u0435 \u043D\u0430 \u043A\u043E\u0442\u043E\u0440\u0443\u044E \u0431\u044B\u043B\u0438 \u043E\u0442\u043F\u0440\u0430\u0432\u043B\u0435\u043D\u044B",
        collection: "forms"
      }
    },
    ip: {
      type: "text",
      options: {
        label: "IP",
        description: "IP \u0430\u0434\u0440\u0435\u0441 \u043A\u043B\u0438\u0435\u043D\u0442\u0430",
        required: false
      }
    },
    json: {
      // data is stored in plain JSON, because a formatted version is sent via email
      type: "text-area",
      options: {
        label: "JSON",
        description: "JSON \u0441 \u0434\u0430\u043D\u043D\u044B\u043C\u0438 \u0444\u043E\u0440\u043C\u044B"
      }
    }
  }
});

const patternValidator = (pattern, errorMessage) => ({ value, operation }) => {
  if (operation === "read") {
    return;
  }
  if (typeof value !== "string" || !pattern.test(value)) {
    throw new Error(errorMessage );
  }
};
const formsCollectionDefinition = defineCollection({
  name: "forms",
  mode: "multi",
  label: "\u0424\u043E\u0440\u043C\u044B",
  dashboard: {
    fieldLayout: [{ \u0424\u043E\u0440\u043C\u0430: [["title"], ["description"]], \u041F\u043E\u043B\u044F: ["fields"] }],
    primaryField: "title"
  },
  apiRoutes: {
    read: "public"
  },
  fields: {
    title: {
      type: "text",
      options: {
        required: true,
        label: "\u041D\u0430\u0437\u0432\u0430\u043D\u0438\u0435",
        placeholder: "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043D\u0430\u0437\u0432\u0430\u043D\u0438\u0435 \u0444\u043E\u0440\u043C\u044B"
      }
    },
    description: {
      type: "text-area",
      options: {
        required: false,
        label: "\u041E\u043F\u0438\u0441\u0430\u043D\u0438\u0435",
        placeholder: "\u0414\u043E\u043F\u043E\u043B\u043D\u0438\u0442\u0435\u043B\u044C\u043D\u0430\u044F \u0438\u043D\u0444\u043E\u0440\u043C\u0430\u0446\u0438\u044F \u043E \u0444\u043E\u0440\u043C\u0435"
      }
    },
    fields: {
      type: "repeater",
      options: {
        label: "\u041F\u043E\u043B\u044F",
        description: "\u041F\u043E\u043B\u044F \u0444\u043E\u0440\u043C\u044B",
        min: 1,
        required: true,
        subfields: {
          name: {
            type: "text",
            options: {
              required: true,
              label: "\u0418\u043C\u044F",
              description: "\u0418\u043C\u044F \u043F\u043E\u043B\u044F \u0432 \u0444\u043E\u0440\u043C\u0435",
              placeholder: "field-name-in-kebab-case"
            },
            additional: {
              validators: [
                patternValidator(
                  /^[a-z0-9]+(?:-[a-z0-9]+)*$/i,
                  "\u0418\u043C\u044F \u043F\u043E\u043B\u044F \u0434\u043E\u043B\u0436\u043D\u043E \u0441\u043E\u0441\u0442\u043E\u044F\u0442\u044C \u0442\u043E\u043B\u044C\u043A\u043E \u0438\u0437 \u0441\u0438\u043C\u0432\u043E\u043B\u043E\u0432 a-z, 0-9 \u0438 \u0434\u0435\u0444\u0438\u0441\u0430."
                )
              ],
              sanitizers: [
                ({ value }) => {
                  if (typeof value === "string") {
                    value = value.toLowerCase().trim();
                  }
                  return value;
                }
              ]
            }
          },
          label: {
            type: "text",
            options: {
              required: false,
              label: "\u0417\u0430\u0433\u043E\u043B\u043E\u0432\u043E\u043A",
              description: "\u0422\u0435\u043A\u0441\u0442, \u043E\u0442\u043E\u0431\u0440\u0430\u0436\u0430\u0435\u043C\u044B\u0439 \u043D\u0430\u0434 \u043F\u043E\u043B\u0435\u043C \u0432\u0432\u043E\u0434\u0430",
              placeholder: "\u0417\u0430\u0433\u043E\u043B\u043E\u0432\u043E\u043A \u043F\u043E\u043B\u044F \u0432 \u0444\u043E\u0440\u043C\u0435"
            }
          },
          labelClass: {
            type: "text",
            options: {
              required: false,
              label: "\u041A\u043B\u0430\u0441\u0441 \u0437\u0430\u0433\u043E\u043B\u043E\u0432\u043A\u0430",
              description: "\u041A\u043B\u0430\u0441\u0441 \u0437\u0430\u0433\u043E\u043B\u043E\u0432\u043A\u0430 \u043F\u043E\u043B\u044F",
              placeholder: "text-bold"
            }
          },
          labelStyle: {
            type: "text-area",
            options: {
              required: false,
              label: "\u0421\u0442\u0438\u043B\u044C \u0437\u0430\u0433\u043E\u043B\u043E\u0432\u043A\u0430",
              description: "\u0421\u0442\u0438\u043B\u044C \u0437\u0430\u0433\u043E\u043B\u043E\u0432\u043A\u0430 \u043F\u043E\u043B\u044F",
              placeholder: "color: red;"
            }
          },
          description: {
            type: "text",
            options: {
              required: false,
              label: "\u041E\u043F\u0438\u0441\u0430\u043D\u0438\u0435",
              placeholder: "\u0414\u043E\u043F\u043E\u043B\u043D\u0438\u0442\u0435\u043B\u044C\u043D\u0430\u044F \u0438\u043D\u0444\u043E\u0440\u043C\u0430\u0446\u0438\u044F \u043E \u043F\u043E\u043B\u0435"
            }
          },
          type: {
            type: "select",
            options: {
              label: "\u0422\u0438\u043F",
              description: "\u0422\u0438\u043F \u043F\u043E\u043B\u044F \u0432 \u0444\u043E\u0440\u043C\u0435",
              choices: {
                // button: 'Кнопка',
                checkbox: "\u0424\u043B\u0430\u0436\u043E\u043A",
                // 'color': 'Цвет', // partial Android-Firefox support
                date: "\u0414\u0430\u0442\u0430 (\u0431\u0435\u0437 \u0432\u0440\u0435\u043C\u0435\u043D\u0438)",
                // 'datetime-local': 'Дата и время (без часового пояса)', //  Firefox/Safari only displays a date picker and does not display a time picker
                email: "\u042D\u043B\u0435\u043A\u0442\u0440\u043E\u043D\u043D\u0430\u044F \u043F\u043E\u0447\u0442\u0430",
                // file: 'Файл', // ?
                // hidden: 'Скрытое поле',
                // 'image': 'Изображение',
                // month: 'Месяц и год', Firefox/Safari - No support
                number: "\u0427\u0438\u0441\u043B\u043E",
                password: "\u041F\u0430\u0440\u043E\u043B\u044C",
                radio: "\u0420\u0430\u0434\u0438\u043E\u043A\u043D\u043E\u043F\u043A\u0430",
                range: "\u0414\u0438\u0430\u043F\u0430\u0437\u043E\u043D",
                tel: "\u0422\u0435\u043B\u0435\u0444\u043E\u043D",
                text: "\u0422\u0435\u043A\u0441\u0442",
                time: "\u0412\u0440\u0435\u043C\u044F",
                url: "URL",
                // week: 'Week', // Firefox/Safari - No support
                textarea: "\u0422\u0435\u043A\u0441\u0442 (\u043C\u043D\u043E\u0433\u043E\u0441\u0442\u0440\u043E\u0447\u043D\u044B\u0439)",
                select: "\u041F\u043E\u043B\u0435 \u0432\u044B\u0431\u043E\u0440\u0430"
              },
              required: true,
              default: "text"
            }
          },
          required: {
            type: "switch",
            options: {
              label: "\u041E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E\u0435",
              description: "\u0423\u043A\u0430\u0437\u044B\u0432\u0430\u0435\u0442, \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E \u043B\u0438 \u0437\u0430\u043F\u043E\u043B\u043D\u044F\u0442\u044C \u043F\u043E\u043B\u0435 \u0434\u043B\u044F \u043E\u0442\u043F\u0440\u0430\u0432\u043A\u0438 \u0444\u043E\u0440\u043C\u044B",
              default: false,
              falseLabel: "\u041D\u0435\u0442",
              trueLabel: "\u0414\u0430"
            }
          },
          placeholder: {
            type: "text",
            options: {
              label: "\u0417\u0430\u043F\u043E\u043B\u043D\u0438\u0442\u0435\u043B\u044C",
              description: "\u0422\u0435\u043A\u0441\u0442, \u043E\u0442\u043E\u0431\u0440\u0430\u0436\u0430\u0435\u043C\u044B\u0439 \u0432 \u043F\u043E\u043B\u0435 \u0434\u043E \u0432\u0432\u043E\u0434\u0430 \u0434\u0430\u043D\u043D\u044B\u0445",
              required: false
            },
            additional: {
              conditionalLogic: {
                $every: [
                  { type: { ne: "checkbox" } },
                  { type: { ne: "radio" } }
                ]
              }
            }
          },
          min: {
            type: "number",
            options: {
              label: "\u041C\u0438\u043D\u0438\u043C\u0430\u043B\u044C\u043D\u043E\u0435 \u0437\u043D\u0430\u0447\u0435\u043D\u0438\u0435",
              description: "\u041C\u0438\u043D\u0438\u043C\u0430\u043B\u044C\u043D\u043E\u0435 \u0437\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u043F\u043E\u043B\u044F",
              required: false,
              default: Number.MIN_SAFE_INTEGER
            },
            additional: {
              conditionalLogic: {
                $some: [{ type: "range" }, { type: "number" }]
              }
            }
          },
          max: {
            type: "number",
            options: {
              label: "\u041C\u0430\u043A\u0441\u0438\u043C\u0430\u043B\u044C\u043D\u043E\u0435 \u0437\u043D\u0430\u0447\u0435\u043D\u0438\u0435",
              description: "\u041C\u0430\u043A\u0441\u0438\u043C\u0430\u043B\u044C\u043D\u043E\u0435 \u0437\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u043F\u043E\u043B\u044F",
              required: false,
              default: Number.MAX_SAFE_INTEGER
            },
            additional: {
              conditionalLogic: {
                $some: [{ type: "range" }, { type: "number" }]
              }
            }
          },
          minLength: {
            type: "number",
            options: {
              label: "\u041C\u0438\u043D\u0438\u043C\u0430\u043B\u044C\u043D\u0430\u044F \u0434\u043B\u0438\u043D\u0430",
              required: false,
              min: 0,
              decimals: 0,
              description: "'0' - \u043D\u0435 \u043E\u0433\u0440\u0430\u043D\u0438\u0447\u0435\u043D\u043E"
            },
            additional: {
              conditionalLogic: {
                $some: [
                  { type: "text" },
                  { type: "textarea" },
                  { type: "password" },
                  { type: "tel" }
                ]
              }
            }
          },
          maxLength: {
            type: "number",
            options: {
              label: "\u041C\u0430\u043A\u0441\u0438\u043C\u0430\u043B\u044C\u043D\u0430\u044F \u0434\u043B\u0438\u043D\u0430",
              required: false,
              min: 0,
              decimals: 0,
              description: "'0' - \u043D\u0435 \u043E\u0433\u0440\u0430\u043D\u0438\u0447\u0435\u043D\u043E"
            },
            additional: {
              conditionalLogic: {
                $some: [
                  { type: "text" },
                  { type: "textarea" },
                  { type: "password" },
                  { type: "tel" }
                ]
              }
            }
          },
          items: {
            type: "repeater",
            additional: {
              conditionalLogic: {
                $some: [{ type: "radio" }, { type: "select" }]
              }
            },
            options: {
              label: "\u0412\u0430\u0440\u0438\u0430\u043D\u0442\u044B \u0437\u043D\u0430\u0447\u0435\u043D\u0438\u0439",
              subfields: {
                value: {
                  type: "text",
                  options: {
                    label: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435",
                    description: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435, \u043F\u0435\u0440\u0435\u0434\u0430\u0432\u0430\u0435\u043C\u043E\u0435 \u043D\u0430 \u0441\u0435\u0440\u0432\u0435\u0440",
                    required: true
                  },
                  additional: {
                    validators: [
                      ({ value }) => (
                        // TODO: Replace to 'patternValidator'
                        typeof value === "string" && /^[a-z0-9]+(?:-[a-z0-9]+)*$/i.test(value) || "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u0434\u043E\u043B\u0436\u043D\u043E \u0441\u043E\u0441\u0442\u043E\u044F\u0442\u044C \u0442\u043E\u043B\u044C\u043A\u043E \u0438\u0437 \u0441\u0438\u043C\u0432\u043E\u043B\u043E\u0432 a-z, 0-9 \u0438 \u0434\u0435\u0444\u0438\u0441\u0430."
                      )
                    ],
                    sanitizers: [
                      ({ value }) => {
                        if (typeof value === "string") {
                          value = value.toLowerCase().trim();
                        }
                        return value;
                      }
                    ]
                  }
                },
                label: {
                  type: "text",
                  options: {
                    label: "\u041D\u0430\u0438\u043C\u0435\u043D\u043E\u0432\u0430\u043D\u0438\u0435",
                    description: "\u0422\u0435\u043A\u0441\u0442, \u043E\u0442\u043E\u0431\u0440\u0430\u0436\u0430\u0435\u043C\u044B\u0439 \u043F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u0442\u0435\u043B\u044E \u0432\u043C\u0435\u0441\u0442\u043E \u0437\u043D\u0430\u0447\u0435\u043D\u0438\u044F",
                    required: false
                  }
                }
              },
              fieldLayout: [["value", "label"]],
              addLabel: "\u0414\u043E\u0431\u0430\u0432\u0438\u0442\u044C \u0437\u043D\u0430\u0447\u0435\u043D\u0438\u0435"
            }
          },
          defaultString: {
            type: "text",
            options: {
              label: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u043F\u043E \u0443\u043C\u043E\u043B\u0447\u0430\u043D\u0438\u044E",
              description: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u043F\u043E\u043B\u044F \u043F\u0440\u0438 \u0438\u043D\u0438\u0446\u0438\u0430\u043B\u0438\u0437\u0430\u0446\u0438\u0438 \u0444\u043E\u0440\u043C\u044B",
              required: false
            },
            additional: {
              conditionalLogic: {
                $some: [
                  { type: "text" },
                  { type: "textarea" },
                  { type: "email" },
                  { type: "url" },
                  { type: "password" },
                  { type: "tel" },
                  { type: "select" },
                  { type: "radio" }
                ]
              }
            }
          },
          defaultNumber: {
            type: "number",
            options: {
              label: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u043F\u043E \u0443\u043C\u043E\u043B\u0447\u0430\u043D\u0438\u044E",
              description: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u043F\u043E\u043B\u044F \u043F\u0440\u0438 \u0438\u043D\u0438\u0446\u0438\u0430\u043B\u0438\u0437\u0430\u0446\u0438\u0438 \u0444\u043E\u0440\u043C\u044B",
              required: false
            },
            additional: {
              conditionalLogic: {
                $some: [{ type: "range" }, { type: "number" }]
              }
            }
          },
          defaultBoolean: {
            type: "switch",
            options: {
              label: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u043F\u043E \u0443\u043C\u043E\u043B\u0447\u0430\u043D\u0438\u044E",
              description: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u043F\u043E\u043B\u044F \u043F\u0440\u0438 \u0438\u043D\u0438\u0446\u0438\u0430\u043B\u0438\u0437\u0430\u0446\u0438\u0438 \u0444\u043E\u0440\u043C\u044B",
              required: false
            },
            additional: {
              conditionalLogic: {
                type: "checkbox"
              }
            }
          },
          defaultDate: {
            type: "date",
            options: {
              label: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u043F\u043E \u0443\u043C\u043E\u043B\u0447\u0430\u043D\u0438\u044E",
              description: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u043F\u043E\u043B\u044F \u043F\u0440\u0438 \u0438\u043D\u0438\u0446\u0438\u0430\u043B\u0438\u0437\u0430\u0446\u0438\u0438 \u0444\u043E\u0440\u043C\u044B",
              required: false
            },
            additional: {
              conditionalLogic: {
                type: "date"
              }
            }
          },
          defaultTime: {
            type: "time",
            options: {
              label: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u043F\u043E \u0443\u043C\u043E\u043B\u0447\u0430\u043D\u0438\u044E",
              description: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u043F\u043E\u043B\u044F \u043F\u0440\u0438 \u0438\u043D\u0438\u0446\u0438\u0430\u043B\u0438\u0437\u0430\u0446\u0438\u0438 \u0444\u043E\u0440\u043C\u044B",
              required: false
            },
            additional: {
              conditionalLogic: {
                type: "time"
              }
            }
          },
          colsXs: {
            type: "number",
            options: {
              label: "\u0421\u0442\u043E\u043B\u0431\u0446\u044B xs+",
              min: 0,
              max: 12,
              decimals: 0,
              default: 12
            }
          },
          colsSm: {
            type: "number",
            options: {
              label: "\u0421\u0442\u043E\u043B\u0431\u0446\u044B sm+",
              min: 0,
              max: 12,
              decimals: 0,
              default: 6
            }
          },
          colsMd: {
            type: "number",
            options: {
              label: "\u0421\u0442\u043E\u043B\u0431\u0446\u044B md+",
              min: 0,
              max: 12,
              decimals: 0,
              default: 0
            }
          },
          colsLg: {
            type: "number",
            options: {
              label: "\u0421\u0442\u043E\u043B\u0431\u0446\u044B lg+",
              min: 0,
              max: 12,
              decimals: 0,
              default: 0
            }
          },
          colsXl: {
            type: "number",
            options: {
              label: "\u0421\u0442\u043E\u043B\u0431\u0446\u044B xl+",
              min: 0,
              max: 12,
              decimals: 0,
              default: 0
            }
          },
          colsXxl: {
            type: "number",
            options: {
              label: "\u0421\u0442\u043E\u043B\u0431\u0446\u044B xxl+",
              min: 0,
              max: 12,
              decimals: 0,
              default: 6
            }
          }
        },
        addLabel: "\u0414\u043E\u0431\u0430\u0432\u0438\u0442\u044C \u043F\u043E\u043B\u0435",
        fieldLayout: [
          ["name", "label", "type", "required"],
          ["labelClass", "labelStyle"],
          [
            "description",
            "placeholder",
            "defaultString",
            "defaultNumber",
            "defaultBoolean",
            "defaultDate",
            "defaultTime"
          ],
          ["min", "max", "minLength", "maxLength"],
          ["items"],
          ["colsXs", "colsSm", "colsMd", "colsLg", "colsXl", "colsXxl"]
        ]
      }
    }
  }
});

const pruviousDashboard_en_translatableStringsDefinition = defineTranslatableStrings({
  domain: "pruvious-dashboard",
  language: "en",
  strings: {
    "(current)": "(current)",
    "**301** - Moved permanently": "**301** - Moved permanently",
    "**302** - Temporarily moved": "**302** - Temporarily moved",
    "$add after": { pattern: "$add after", input: { add: "string" } },
    "$add before": { pattern: "$add before", input: { add: "string" } },
    "$count $errors found": {
      pattern: "$count $errors found",
      input: { count: "number" },
      replacements: { errors: [{ conditions: [{ count: 1 }], output: "error" }, "errors"] }
    },
    "$item created": { pattern: "$item created", input: { item: "string" } },
    "$item deleted": { pattern: "$item deleted", input: { item: "string" } },
    "$item duplicated": { pattern: "$item duplicated", input: { item: "string" } },
    "$item link": { pattern: "$item link", input: { item: "string" } },
    "$item updated": { pattern: "$item updated", input: { item: "string" } },
    "$timezone time": { pattern: "$timezone time", input: { timezone: "string" } },
    "A file with the name !!$name!! already exists in the destination folder": {
      pattern: "A file with the name !!$name!! already exists in the destination folder",
      input: { name: "string" }
    },
    "A folder with this name already exists": "A folder with this name already exists",
    "A string to append to the URL or path (e.g. **#anchor** or **?query**).": "A string to append to the URL or path (e.g. **#anchor** or **?query**).",
    "Active": "Active",
    "Add": "Add",
    "Add $item": { pattern: "Add $item", input: { item: "string" } },
    "Add block": "Add block",
    "Add block before": "Add block before",
    "Add block after": "Add block after",
    "Add filter": "Add filter",
    "Add inner block": "Add inner block",
    "Add link": "Add link",
    "Add new folder": "Add new folder",
    "All fields have been reset to their default values": "All fields have been reset to their default values",
    "Alt text": "Alt text",
    "**Allowed types:** $types": { pattern: "**Allowed types:** $types", input: { types: "string" } },
    "and": "and",
    "Append": "Append",
    "Apply": "Apply",
    "At least one column must be selected": "At least one column must be selected",
    "Block": "Block",
    "Block formats": "Block formats",
    "Blocks": "Blocks",
    "Cache cleared successfully": "Cache cleared successfully",
    "Changes that you made may not be saved.": "Changes that you made may not be saved.",
    "Choose $item": { pattern: "Choose $item", input: { item: "string" } },
    "Cancel": "Cancel",
    "Clear": "Clear",
    "Clear cache": "Clear cache",
    "Clear filters": "Clear filters",
    "Clear selection": "Clear selection",
    "Click to dismiss": "Click to dismiss",
    "Close": "Close",
    "Confirm to !!delete!!": "Confirm to !!delete!!",
    "Confirm to **move** the selected $selection to **$directory**": {
      pattern: "Confirm to **move** the selected $selection to **$directory**",
      input: { selection: "string", directory: "string" }
    },
    "Contains (case-insensitive)": "Contains (case-insensitive)",
    "Content copied": "Content copied",
    "Continue": "Continue",
    "Convert block to preset": "Convert block to preset",
    "Convert to preset": "Convert to preset",
    "Copied": "Copied",
    "Copy": "Copy",
    "Copy link to clipboard": "Copy link to clipboard",
    "Create": "Create",
    "Create account": "Create account",
    "Create new $item": { pattern: "Create new $item", input: { item: "string" } },
    "Create translation": "Create translation",
    "Custom target": "Custom target",
    "Cut": "Cut",
    "Dashboard": "Dashboard",
    "Description": "Description",
    "Desynchronize values": "Desynchronize values",
    "Do you want to select all $count $items?": {
      pattern: "Do you want to select all $count $items?",
      input: { count: "number", items: "string" }
    },
    "Does not contain (case-insensitive)": "Does not contain (case-insensitive)",
    "Draft URL": "Draft URL",
    "Drop files here to upload": "Drop files here to upload",
    "Duplicate": "Duplicate",
    "Edit $item": { pattern: "Edit $item", input: { item: "string" } },
    "Edit alt text": "Edit alt text",
    "Edit link": "Edit link",
    "Element": "Element",
    "Folder created": "Folder created",
    "Folder deleted": "Folder deleted",
    "Folder renamed": "Folder renamed",
    "Delete": "Delete",
    "Delete $count $items": { pattern: "Delete $count $items", input: { count: "number", items: "string" } },
    "Deleted $count $items": {
      pattern: "Deleted $count $items",
      input: { count: "number", items: "string" }
    },
    "Deselect": "Deselect",
    "Deselect $item": { pattern: "Deselect $item", input: { item: "string" } },
    "Detach preset": "Detach preset",
    "Determines the user's login access to the CMS.": "Determines the user's login access to the CMS.",
    "Disable selection": "Disable selection",
    "Edit": "Edit",
    "Edit columns": "Edit columns",
    "Edit file": "Edit file",
    "Edit filters": "Edit filters",
    "Edit translation": "Edit translation",
    "Email": "Email",
    "Enable selection": "Enable selection",
    "Ends with (case-insensitive)": "Ends with (case-insensitive)",
    "Enter alt text...": "Enter alt text...",
    "Enter full screen": "Enter full screen",
    "Equal to": "Equal to",
    "Equal to (case-insensitive)": "Equal to (case-insensitive)",
    "Exit full screen": "Exit full screen",
    "false": "false",
    "file": "file",
    "File deleted": "File deleted",
    "File updated": "File updated",
    "files": "files",
    "Files": "Files",
    "Filter $items": { pattern: "Filter $items", input: { items: "string" } },
    "Filtered results": "Filtered results",
    "First name": "First name",
    "folder": "folder",
    "Folder is empty": "Folder is empty",
    "folders": "folders",
    "Folders": "Folders",
    "Go to dashboard": "Go to dashboard",
    "Go to page $page": { pattern: "Go to page $page", input: { page: "number" } },
    "Go to start page": "Go to start page",
    "Greater than": "Greater than",
    "Greater than or equal to": "Greater than or equal to",
    "Hide password": "Hide password",
    "Hyperlink": "Hyperlink",
    "Inactive": "Inactive",
    "installWelcomeMessage": "Welcome to Pruvious! Enter your details to create your primary administrator account.",
    "Inline formats": "Inline formats",
    "Invalid link": "Invalid link",
    "Invalid URL": "Invalid URL",
    "Invalid URL path": "Invalid URL path",
    "item": "item",
    "items": "items",
    "Keyboard shortcuts for blocks are active": "Keyboard shortcuts for blocks are active",
    "Language": "Language",
    "Last name": "Last name",
    "Leave": "Leave",
    "Less than": "Less than",
    "Less than or equal to": "Less than or equal to",
    "Library": "Library",
    "Library is empty": "Library is empty",
    "Load more": "Load more",
    "Log out": "Log out",
    "Log out user from all active sessions": "Log out user from all active sessions",
    "Log out from all other sessions": "Log out from all other sessions",
    "Media": "Media",
    "Media library": "Media library",
    "**Minimum height:** $height": { pattern: "**Minimum height:** $height", input: { height: "number" } },
    "**Minimum width:** $width": { pattern: "**Minimum width:** $width", input: { width: "number" } },
    "Mirror content to this translation": "Mirror content to this translation",
    "More options": "More options",
    "Move": "Move",
    "Move $count $items": { pattern: "Move $count $items", input: { count: "number", items: "string" } },
    "Move $count $items to": { pattern: "Move $count $items to", input: { count: "number", items: "string" } },
    "Moved $count $items": {
      pattern: "Moved $count $items",
      input: { count: "number", items: "string" }
    },
    "Move down": "Move down",
    "Move up": "Move up",
    "Name": "Name",
    "New name": "New name",
    "Next page": "Next page",
    "No": "No",
    "No $items found": { pattern: "No $items found", input: { items: "string" } },
    "No $items matching the current filter were found": {
      pattern: "No $items matching the current filter were found",
      input: { items: "string" }
    },
    "No blocks found": "No blocks found",
    "No fields to display": "No fields to display",
    "No icons found": "No icons found",
    "Not equal to": "Not equal to",
    "My profile": "My profile",
    "Open": "Open",
    "Open $item": { pattern: "Open $item", input: { item: "string" } },
    "Open $item in new tab": { pattern: "Open $item in new tab", input: { item: "string" } },
    "Open in new tab": "Open in new tab",
    "Open preview in new tab": "Open preview in new tab",
    "Open root folder": "Open root folder",
    "or": "or",
    "Password": "Password",
    "Paste": "Paste",
    "Paste after": "Paste after",
    "Paste block from clipboard": "Paste block from clipboard",
    "Relationship (rel)": "Relationship (rel)",
    "Reload preview": "Reload preview",
    "Remember me": "Remember me",
    "Replace": "Replace",
    "Please ensure all block fields are valid before converting the block to a preset": "Please ensure all block fields are valid before converting the block to a preset",
    "Preset detached": "Preset detached",
    "Preview": "Preview",
    "Previous page": "Previous page",
    "Profile updated": "Profile updated",
    "Public URL": "Public URL",
    "Publish": "Publish",
    "Redirects to": "Redirects to",
    "Redo (($count))": { pattern: "Redo (($count))", input: { count: "number" } },
    "Remove": "Remove",
    "Rename": "Rename",
    "Rename folder": "Rename folder",
    "Required": "Required",
    "Restore defaults": "Restore defaults",
    "Root folder": "Root folder",
    "Save": "Save",
    "Save draft": "Save draft",
    "Search $items...": { pattern: "Search $items...", input: { items: "string" } },
    "Search blocks...": "Search blocks...",
    "Search icons...": "Search icons...",
    "Search media...": "Search media...",
    "Search results for:": "Search results for:",
    "Select": "Select",
    "Select $item": { pattern: "Select $item", input: { item: "string" } },
    "Select icon": "Select icon",
    "Select from media library": "Select from media library",
    "Sign in": "Sign in",
    "Show all $items": { pattern: "Show all $items", input: { items: "string" } },
    "Show password": "Show password",
    "Showing $from to $to of $total $items": {
      pattern: "Showing $from to $to of $total $items",
      input: { from: "number", to: "number", total: "number", items: "string" }
    },
    "Some filters are not displayed and are omitted from the user interface": "Some filters are not displayed and are omitted from the user interface",
    "Sort in ascending order": "Sort in ascending order",
    "Sort in descending order": "Sort in descending order",
    "Starts with (case-insensitive)": "Starts with (case-insensitive)",
    "Status": "Status",
    "Synchronize values": "Synchronize values",
    "Target": "Target",
    "Test path or URL": "Test path or URL",
    "The $item does not exist": { pattern: "The $item does not exist", input: { item: "string" } },
    "The **$language** translation of this $item does not exist. Do you want to create it?": {
      pattern: "The **$language** translation of this $item does not exist. Do you want to create it?",
      input: { language: "string", item: "string" }
    },
    "The block **$block** cannot be pasted here": {
      pattern: "The block **$block** cannot be pasted here",
      input: { block: "string" }
    },
    "The block has been converted into a preset": "The block has been converted into a preset",
    "The default **alt** attribute value for the image": "The default **alt** attribute value for the image",
    "The filter in the query string cannot be displayed in the user interface.": "The filter in the query string cannot be displayed in the user interface.",
    "The folder name must be lowercase and URL-friendly": "The folder name must be lowercase and URL-friendly",
    "The file **$file** exceeds the upload limit of $limit": {
      pattern: "The file **$file** exceeds the upload limit of $limit",
      input: { file: "string", limit: "string" }
    },
    "The file does not meet the requirements": "The file does not meet the requirements",
    "The filename without the extension": "The filename without the extension",
    "The image does not meet the requirements": "The image does not meet the requirements",
    "The page you're looking for doesn't exist.": "The page you're looking for doesn't exist.",
    "The **rel** attribute specifies the relationship between the current document and the linked document.": "The **rel** attribute specifies the relationship between the current document and the linked document.",
    "The user has been logged out from all active sessions": "The user has been logged out from all active sessions",
    "There are no compatible blocks that can be added to the selected slot": "There are no compatible blocks that can be added to the selected slot",
    "There are no folders where the selected $selection can be moved to": {
      pattern: "There are no folders where the selected $selection can be moved to",
      input: { selection: "string" }
    },
    "This action will overwrite the content in the **$language** translation.": {
      pattern: "This action will overwrite the content in the **$language** translation.",
      input: { language: "string" }
    },
    "This field cannot be displayed in the UI": "This field cannot be displayed in the UI",
    "This field is required": "This field is required",
    "Translation created": "Translation created",
    "true": "true",
    "Undo (($count))": { pattern: "Undo (($count))", input: { count: "number" } },
    "Change": "Change",
    "Change icon": "Change icon",
    "Coordinated Universal Time (UTC)": "Coordinated Universal Time (UTC)",
    "Untitled": "Untitled",
    "Update": "Update",
    "Update alt text": "Update alt text",
    "Upload": "Upload",
    "Upload file(s)": "Upload file(s)",
    "Upload limit is $limit": { pattern: "Upload limit is $limit", input: { limit: "string" } },
    "Uploaded $count $files": {
      pattern: "Uploaded $count $files",
      input: { count: "number" },
      replacements: { files: [{ conditions: [{ count: 1 }], output: "file" }, "files"] }
    },
    "View": "View",
    "View $item": { pattern: "View $item", input: { item: "string" } },
    "View file": "View file",
    "View translation": "View translation",
    "Yes": "Yes",
    "You don't have permission to access this page.": "You don't have permission to access this page.",
    "You have been logged out from all other sessions": "You have been logged out from all other sessions",
    "You must first allow the app access to the clipboard": "You must first allow the app access to the clipboard"
  }
});

const pruviousServer_en_translatableStringsDefinition = defineTranslatableStrings({
  domain: "pruvious-server",
  language: "en",
  api: false,
  strings: {
    "$item #$id does not exist and cannot be linked": {
      pattern: "$item #$id does not exist and cannot be linked",
      input: { item: "string", id: "number" }
    },
    "A page with this path already exists": "A page with this path already exists",
    "A preset with this name already exists": "A preset with this name already exists",
    "A preview with this token already exists": "A preview with this token already exists",
    "At least one field must be included in the 'select' parameter": "At least one field must be included in the 'select' parameter",
    "Cannot use operator '$operator' on field $field": {
      pattern: "Cannot use operator '$operator' on field $field",
      input: { operator: "string", field: "string" }
    },
    "Cannot use value '$value' for operation '$operation' on field '$field'": {
      pattern: "Cannot use value '$value' for operation '$operation' on field '$field'",
      input: { value: "string", operation: "string", field: "string" }
    },
    "create": "create",
    "delete": "delete",
    "DRAFT": "DRAFT",
    "Forbidden due to insufficient permissions": "Forbidden due to insufficient permissions",
    "Incorrect credentials": "Incorrect credentials",
    "Invalid collection": "Invalid collection",
    "Invalid email address": "Invalid email address",
    "Invalid JSON": "Invalid JSON",
    "Invalid input": "Invalid input",
    "Invalid input name": "Invalid input name",
    "Invalid input type": "Invalid input type",
    "Invalid '$name' unit": { pattern: "Invalid '$name' unit", input: { name: "string" } },
    "Invalid token": "Invalid token",
    "Invalid URL": "Invalid URL",
    "Invalid URL path": "Invalid URL path",
    "Invalid user ID": "Invalid user ID",
    "Invalid value": "Invalid value",
    "Invalid value: '$value'": { pattern: "Invalid value: '$value'", input: { value: "string" } },
    "manage": "manage",
    "Missing 'from' language parameter": "Missing 'from' language parameter",
    "Missing 'to' language parameter": "Missing 'to' language parameter",
    "Missing 'to' parameter": "Missing 'to' parameter",
    "PREVIEW": "PREVIEW",
    "Page not found": "Page not found",
    "Pruvious is already installed": "Pruvious is already installed",
    "read": "read",
    "Resource not found": "Resource not found",
    "Selected values must be strings": "Selected values must be strings",
    "Source and target language cannot be the same": "Source and target language cannot be the same",
    "The $item does not exist": { pattern: "The $item does not exist", input: { item: "string" } },
    "The block '$block' is not allowed as a root block in the layout '$layout'": {
      pattern: "The block '$block' is not allowed as a root block in the layout '$layout'",
      input: { block: "string", layout: "string" }
    },
    "The block '$block' is not allowed in the layout '$layout'": {
      pattern: "The block '$block' is not allowed in the layout '$layout'",
      input: { block: "string", layout: "string" }
    },
    "The directory must be a URL-safe string": "The directory must be a URL-safe string",
    "The field '$field' cannot be queried": {
      pattern: "The field '$field' cannot be queried",
      input: { field: "string" }
    },
    "The field '$field' does not exist": {
      pattern: "The field '$field' does not exist",
      input: { field: "string" }
    },
    "The file extension cannot be changed": "The file extension cannot be changed",
    "The file path must be unique": "The file path must be unique",
    "The file type must be one of the following: $types": {
      pattern: "The file type must be one of the following: $types",
      input: { types: "string" }
    },
    "The filename must be a URL-safe string": "The filename must be a URL-safe string",
    "The filename must not end with a period": "The filename must not end with a period",
    "The icon does not exist": "The icon does not exist",
    "The icon is not allowed for this field": "The icon is not allowed for this field",
    "The image type must be one of the following: $types": {
      pattern: "The image type must be one of the following: $types",
      input: { types: "string" }
    },
    "The '$name' value must be greater than or equal to $min": {
      pattern: "The '$name' value must be greater than or equal to $min",
      input: { name: "string", min: "number" }
    },
    "The '$name' value must be less than or equal to $max": {
      pattern: "The '$name' value must be less than or equal to $max",
      input: { name: "string", max: "number" }
    },
    "The input cannot have more than $count $decimals": {
      pattern: "The input cannot have more than $count $decimals",
      input: { count: "number" },
      replacements: { decimals: [{ conditions: [{ count: 1 }], output: "decimal" }, "decimals"] }
    },
    "The input must be a multiple of $interval between $min and $max": {
      pattern: "The input must be a multiple of $interval between $min and $max",
      input: { interval: "number", min: "number", max: "number" }
    },
    "The input must be an integer": "The input must be an integer",
    "The input must be greater than or equal to $min": {
      pattern: "The input must be greater than or equal to $min",
      input: { min: "number" }
    },
    "The input must be less than or equal to $max": {
      pattern: "The input must be less than or equal to $max",
      input: { max: "number" }
    },
    "The inputs cannot have more than $count $decimals": {
      pattern: "The inputs cannot have more than $count $decimals",
      input: { count: "number" },
      replacements: { decimals: [{ conditions: [{ count: 1 }], output: "decimal" }, "decimals"] }
    },
    "The inputs must be a multiple of $interval between $min and $max": {
      pattern: "The inputs must be a multiple of $interval between $min and $max",
      input: { interval: "number", min: "number", max: "number" }
    },
    "The inputs must be greater than or equal to $min": {
      pattern: "The inputs must be greater than or equal to $min",
      input: { min: "number" }
    },
    "The inputs must be integers": "The inputs must be integers",
    "The inputs must be less than or equal to $max": {
      pattern: "The inputs must be less than or equal to $max",
      input: { max: "number" }
    },
    "The language code '$language' is not supported": {
      pattern: "The language code '$language' is not supported",
      input: { language: "string" }
    },
    "The 'limit' parameter must be a non-negative integer": "The 'limit' parameter must be a non-negative integer",
    "The minimum allowed image height is $min pixels": {
      pattern: "The minimum image allowed height is $min pixels",
      input: { min: "number" }
    },
    "The minimum allowed image width is $min pixels": {
      pattern: "The minimum allowed image width is $min pixels",
      input: { min: "number" }
    },
    "The minimum range between the inputs is $minRange": {
      pattern: "The minimum range between the inputs is $minRange",
      input: { minRange: "number" }
    },
    "The maximum allowable file size is $size": {
      pattern: "The maximum allowable file size is $size",
      input: { size: "string" }
    },
    "The maximum range between the inputs is $maxRange": {
      pattern: "The maximum range between the inputs is $maxRange",
      input: { maxRange: "number" }
    },
    "The 'offset' parameter must be a non-negative integer": "The 'offset' parameter must be a non-negative integer",
    "The operator '$operator' is not valid": {
      pattern: "The operator '$operator' is not valid",
      input: { operator: "string" }
    },
    "The order direction '$direction' is not valid": {
      pattern: "The order direction '$direction' is not valid",
      input: { direction: "string" }
    },
    "The job is not defined": "The job is not defined",
    "The 'page' parameter must be a positive integer": "The 'page' parameter must be a positive integer",
    "The 'page' parameter requires either 'perPage' or 'limit' to be present": "The 'page' parameter requires either 'perPage' or 'limit' to be present",
    "The page path must be a URL-safe string": "The page path must be a URL-safe string",
    "The password must be at least 8 characters long": "The password must be at least 8 characters long",
    "The path must start with a slash ('/')": "The path must start with a slash ('/')",
    "The 'perPage' parameter must be a positive integer": "The 'perPage' parameter must be a positive integer",
    "The 'populate' parameter must be a booleanish value": "The 'populate' parameter must be a booleanish value",
    "The preview token must be a URL-safe string": "The preview token must be a URL-safe string",
    "The request body must be an object with key-value pairs": "The request body must be an object with key-value pairs",
    "The repeater must have at least $count $entries": {
      pattern: "The repeater must have at least $count $entries",
      input: { count: "number" },
      replacements: { entries: [{ conditions: [{ count: 1 }], output: "entry" }, "entries"] }
    },
    "The repeater must not exceed $count $entries": {
      pattern: "The repeater must not exceed $count $entries",
      input: { count: "number" },
      replacements: { entries: [{ conditions: [{ count: 1 }], output: "entry" }, "entries"] }
    },
    "The request body must be either an object with key-value pairs or an array containing key-value objects": "The request body must be either an object with key-value pairs or an array containing key-value objects",
    "The requested job does not exist": "The requested job does not exist",
    "The requested job no longer exists": "The requested job no longer exists",
    "The search structure '$structure' does not exist": {
      pattern: "The search structure '$structure' does not exist",
      input: { structure: "string" }
    },
    "The second value cannot be less than the first value": "The second value cannot be less than the first value",
    "The target must be a path starting with a slash ('/') or a URL starting with 'http'": "The target must be a path starting with a slash ('/') or a URL starting with 'http'",
    "The translation already exists": "The translation already exists",
    "The upload is not an image": "The upload is not an image",
    "The value must be a lowercase string": "The value must be a lowercase string",
    "The '$name' value must be numeric": { pattern: "The '$name' value must be numeric", input: { name: "string" } },
    "The 'where' parameter is not valid": "The 'where' parameter is not valid",
    "This block is not allowed in the slot '$slot'": {
      pattern: "This block is not allowed in the slot '$slot'",
      input: { slot: "string" }
    },
    "This collection cannot be previewed": "This collection cannot be previewed",
    "This collection does not support translations": "This collection does not support translations",
    "This collection is not searchable": "This collection is not searchable",
    "This field is read-only": "This field is read-only",
    "This field is required": "This field is required",
    "This field must be present": "This field must be present",
    "This field must be unique": "This field must be unique",
    "This method is not supported": "This method is not supported",
    "Unable to determine the request operation": "Unable to determine the request operation",
    "Unauthorized": "Unauthorized",
    "Unauthorized due to either invalid credentials or missing authentication": "Unauthorized due to either invalid credentials or missing authentication",
    "Unknown collection name: '$collection'": {
      pattern: "Unknown collection name: '$collection'",
      input: { collection: "string" }
    },
    "Unrecognized block name": "Unrecognized block name",
    "Unrecognized field name": "Unrecognized field name",
    "Unrecognized slot name": "Unrecognized slot name",
    "update": "update",
    "Using both 'page' and 'offset' parameters simultaneously is not permitted": "Using both 'page' and 'offset' parameters simultaneously is not permitted",
    "Using both 'perPage' and 'limit' parameters simultaneously is not permitted": "Using both 'perPage' and 'limit' parameters simultaneously is not permitted",
    "validate": "validate",
    "You are not authorized to change passwords for admin users": "You are not authorized to change passwords for admin users",
    "You are not authorized to create admin users": "You are not authorized to create admin users",
    "You are not authorized to deactivate admin users": "You are not authorized to deactivate admin users",
    "You are not authorized to delete admin users": "You are not authorized to delete admin users",
    "You are not authorized to demote admin users": "You are not authorized to demote admin users",
    "You are not authorized to modify the email addresses of admin users": "You are not authorized to modify the email addresses of admin users",
    "You are not authorized to promote users to admin status": "You are not authorized to promote users to admin status",
    "You cannot delete your own user account": "You cannot delete your own user account",
    "You don't have the necessary permissions to $operate $record": {
      pattern: "You don't have the necessary permissions to $operate $record",
      input: { operate: "string", record: "string" }
    }
  }
});

const checkboxFieldDefinition = defineField({
  name: "checkbox",
  type: "boolean",
  default: ({ options }) => options.default ?? false,
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: [
        "Indicates whether the field input is mandatory, requiring its presence during creation, with the value set to `true`.",
        "",
        "@default false"
      ],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "Text to display on the right side of the input control.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'darkMode' => 'Dark mode'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "boolean",
      description: ["The default field value.", "", "@default false"]
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input control.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in the tooltip when hovering over the field label.",
        "",
        "Use an array to handle line breaks."
      ]
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    booleanishSanitizer
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    booleanValidator
  ],
  inputMeta: {
    type: "Booleanish",
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const dateRangeFieldDefinition = defineField({
  name: "date-range",
  type: { js: "object", ts: "[number | null, number | null]" },
  default: ({ options }) => isDefined(options.default) ? options.default : [null, null],
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: ["Specifies that the field input is mandatory during creation.", "", "@default false"],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'travelDate' => 'Travel date'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "[number | null, number | null]",
      description: ["The default field value.", "", "@default [null, null]"],
      default: () => [null, null]
    },
    min: {
      type: "number",
      description: ["The earliest possible date (as timestamp in milliseconds).", "", "@default -8639999949600000"],
      default: () => -86399999496e5
    },
    max: {
      type: "number",
      description: ["The latest possible date (as timestamp in milliseconds).", "", "@default 8639999949600000"],
      default: () => 86399999496e5
    },
    name: {
      type: "string | [string, string]",
      description: [
        "A string that specifies the `name` for the input controls.",
        "You can specify the name as a tuple of strings.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    placeholder: {
      type: "string | [string, string]",
      description: [
        "Text that appears in the input elements when they have no value set.",
        "You can specify the placeholder as a tuple of strings."
      ]
    },
    clearable: {
      type: "boolean | [boolean, boolean]",
      description: [
        "A boolean indicating whether to display a clear button that removes the current value.",
        "You can specify the clearable option as a tuple of booleans.",
        "",
        "@default true"
      ],
      default: () => true
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    ({ value }) => isArray(value) && value.length === 2 ? [numericSanitizer({ value: value[0] }), numericSanitizer({ value: value[1] })] : value,
    ({ value }) => {
      if (isArray(value) && value.length === 2) {
        return value.map((v) => {
          if (isInteger(v)) {
            try {
              const date = new Date(v);
              date.setUTCHours(0, 0, 0, 0);
              return date.getTime();
            } catch {
            }
          }
          return v;
        });
      }
      return value;
    }
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => {
        if (context.options.required && (isUndefined(context.value) || isNull(context.value) || isArray(context.value) && (isNull(context.value[0]) || isUndefined(context.value[0]) || isNull(context.value[1]) || isUndefined(context.value[1])))) {
          throw new Error(context.__(context.language, "pruvious-server", "This field is required"));
        }
      }
    },
    ({ __, language, value }) => {
      if (isDefined(value) && (!isArray(value) || value.length !== 2 || !value.every((v) => isInteger(v) || isNull(v)))) {
        throw new Error(__(language, "pruvious-server", "Invalid input type"));
      }
    },
    ({ __, language, options, value }) => {
      if (isInteger(options.min)) {
        if (isInteger(value[0]) && value[0] < options.min || isInteger(value[1]) && value[1] < options.min) {
          throw new Error(
            __(language, "pruvious-server", "The inputs must be greater than or equal to $min", { min: options.min })
          );
        }
      }
    },
    ({ __, language, options, value }) => {
      if (isInteger(options.max)) {
        if (isInteger(value[0]) && value[0] > options.max || isInteger(value[1]) && value[1] > options.max) {
          throw new Error(
            __(language, "pruvious-server", "The inputs must be less than or equal to $max", { max: options.max })
          );
        }
      }
    },
    ({ __, language, value }) => {
      if (isInteger(value[0]) && isInteger(value[1]) && value[1] < value[0]) {
        throw new Error(__(language, "pruvious-server", "The second value cannot be less than the first value"));
      }
    }
  ],
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const dateTimeRangeFieldDefinition = defineField({
  name: "date-time-range",
  type: { js: "object", ts: "[number | null, number | null]" },
  default: ({ options }) => isDefined(options.default) ? options.default : [null, null],
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: ["Specifies that the field input is mandatory during creation.", "", "@default false"],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'travelDate' => 'Travel date'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "[number | null, number | null]",
      description: ["The default field value.", "", "@default [null, null]"],
      default: () => [null, null]
    },
    min: {
      type: "number",
      description: [
        "The earliest possible date and time (as timestamp in milliseconds).",
        "",
        "@default -8639999949600000"
      ],
      default: () => -86399999496e5
    },
    max: {
      type: "number",
      description: [
        "The latest possible date and time (as timestamp in milliseconds).",
        "",
        "@default 8639999949600000"
      ],
      default: () => 86399999496e5
    },
    utc: {
      type: "boolean",
      description: [
        "A boolean flag indicating whether to use UTC time in the date-time pickers.",
        "The stored values are always in UTC.",
        "",
        "@default false"
      ],
      default: () => false
    },
    name: {
      type: "string | [string, string]",
      description: [
        "A string that specifies the `name` for the input controls.",
        "You can specify the name as a tuple of strings.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    placeholder: {
      type: "string | [string, string]",
      description: [
        "Text that appears in the input elements when they have no value set.",
        "You can specify the placeholder as a tuple of strings."
      ]
    },
    clearable: {
      type: "boolean | [boolean, boolean]",
      description: [
        "A boolean indicating whether to display a clear button that removes the current value.",
        "You can specify the clearable option as a tuple of booleans.",
        "",
        "@default true"
      ],
      default: () => true
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    ({ value }) => isArray(value) && value.length === 2 ? [numericSanitizer({ value: value[0] }), numericSanitizer({ value: value[1] })] : value
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => {
        if (context.options.required && (isUndefined(context.value) || isNull(context.value) || isArray(context.value) && (isNull(context.value[0]) || isUndefined(context.value[0]) || isNull(context.value[1]) || isUndefined(context.value[1])))) {
          throw new Error(context.__(context.language, "pruvious-server", "This field is required"));
        }
      }
    },
    ({ __, language, value }) => {
      if (isDefined(value) && (!isArray(value) || value.length !== 2 || !value.every((v) => isInteger(v) || isNull(v)))) {
        throw new Error(__(language, "pruvious-server", "Invalid input type"));
      }
    },
    ({ __, language, options, value }) => {
      if (isInteger(options.min)) {
        if (isInteger(value[0]) && value[0] < options.min || isInteger(value[1]) && value[1] < options.min) {
          throw new Error(
            __(language, "pruvious-server", "The inputs must be greater than or equal to $min", { min: options.min })
          );
        }
      }
    },
    ({ __, language, options, value }) => {
      if (isInteger(options.max)) {
        if (isInteger(value[0]) && value[0] > options.max || isInteger(value[1]) && value[1] > options.max) {
          throw new Error(
            __(language, "pruvious-server", "The inputs must be less than or equal to $max", { max: options.max })
          );
        }
      }
    },
    ({ __, language, value }) => {
      if (isInteger(value[0]) && isInteger(value[1]) && value[1] < value[0]) {
        throw new Error(__(language, "pruvious-server", "The second value cannot be less than the first value"));
      }
    }
  ],
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const dateTimeFieldDefinition = defineField({
  name: "date-time",
  type: { js: "number", ts: "number | null", db: "BIGINT" },
  default: ({ options }) => isDefined(options.default) ? options.default : null,
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: ["Specifies that the field input is mandatory during creation.", "", "@default false"],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'eventDate' => 'Event date'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "number | null",
      description: ["The default field value.", "", "@default null"]
    },
    min: {
      type: "number",
      description: [
        "The earliest possible date and time (as timestamp in milliseconds).",
        "",
        "@default -8639999949600000"
      ],
      default: () => -86399999496e5
    },
    max: {
      type: "number",
      description: [
        "The latest possible date and time (as timestamp in milliseconds).",
        "",
        "@default 8639999949600000"
      ],
      default: () => 86399999496e5
    },
    utc: {
      type: "boolean",
      description: [
        "A boolean flag indicating whether to use UTC time in the date-time picker.",
        "The stored value is always in UTC.",
        "",
        "@default false"
      ],
      default: () => false
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input control.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    placeholder: {
      type: "string",
      description: ["Text that appears in the input element when it has no value set."]
    },
    clearable: {
      type: "boolean",
      description: [
        "A boolean indicating whether to display a clear button that removes the current value.",
        "",
        "@default true"
      ],
      default: () => true
    }
  },
  sanitizers: [(context) => context.options.required ? context.value : defaultSanitizer(context), numericSanitizer],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    integerOrNullValidator,
    ({ __, language, options, value }) => {
      if (isDefined(options.min) && value < options.min) {
        throw new Error(
          __(language, "pruvious-server", "The input must be greater than or equal to $min", { min: options.min })
        );
      }
    },
    ({ __, language, options, value }) => {
      if (isDefined(options.max) && value > options.max) {
        throw new Error(
          __(language, "pruvious-server", "The input must be less than or equal to $max", { max: options.max })
        );
      }
    }
  ],
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const dateFieldDefinition = defineField({
  name: "date",
  type: { js: "number", ts: "number | null", db: "BIGINT" },
  default: ({ options }) => isDefined(options.default) ? options.default : null,
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: ["Specifies that the field input is mandatory during creation.", "", "@default false"],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'eventDate' => 'Event date'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "number | null",
      description: ["The default field value.", "", "@default null"]
    },
    min: {
      type: "number",
      description: ["The earliest possible date (as timestamp in milliseconds).", "", "@default -8639999949600000"],
      default: () => -86399999496e5
    },
    max: {
      type: "number",
      description: ["The latest possible date (as timestamp in milliseconds).", "", "@default 8639999949600000"],
      default: () => 86399999496e5
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input control.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    placeholder: {
      type: "string",
      description: ["Text that appears in the input element when it has no value set."]
    },
    clearable: {
      type: "boolean",
      description: [
        "A boolean indicating whether to display a clear button that removes the current value.",
        "",
        "@default true"
      ],
      default: () => true
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    numericSanitizer,
    ({ value }) => {
      if (isInteger(value)) {
        try {
          const date = new Date(value);
          date.setUTCHours(0, 0, 0, 0);
          return date.getTime();
        } catch {
        }
      }
      return value;
    }
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    integerOrNullValidator,
    ({ __, language, options, value }) => {
      if (isDefined(options.min) && value < options.min) {
        throw new Error(
          __(language, "pruvious-server", "The input must be greater than or equal to $min", { min: options.min })
        );
      }
    },
    ({ __, language, options, value }) => {
      if (isDefined(options.max) && value > options.max) {
        throw new Error(
          __(language, "pruvious-server", "The input must be less than or equal to $max", { max: options.max })
        );
      }
    }
  ],
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const editorFieldDefinition = defineField({
  name: "editor",
  type: "string",
  default: ({ options }) => options.default ?? "",
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: [
        "Specifies that the field input is mandatory during creation, and the field value cannot be empty.",
        "",
        "@default false"
      ],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'heroContent' => 'Hero content'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "string",
      description: ["The default field value.", "", "@default '<p></p>'"],
      default: () => "<p></p>"
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    placeholder: {
      type: "string",
      description: ["Text that appears in the input element when it has no value set."]
    },
    toolbar: {
      type: "('blockFormats' | 'blockquote' | 'bold' | 'bulletList' | 'center' | 'clear' | 'code' | 'codeBlock' | 'heading1' | 'heading2' | 'heading3' | 'heading4' | 'heading5' | 'heading6' | 'hardBreak' | 'highlight' | 'horizontalRule' | 'inlineFormats' | 'italic' | 'justify' | 'left' | 'link' | 'normalize' | 'orderedList' | 'paragraph' | 'redo' | 'right' | 'strike' | 'subscript' | 'superscript' | 'underline' | 'undo')[]",
      description: [
        "An array of strings that specifies the toolbar buttons to display.",
        "",
        "The available buttons are as follows:",
        "",
        "- `blockFormats`",
        "- `blockquote`",
        "- `bold`",
        "- `bulletList`",
        "- `center`",
        "- `clear`",
        "- `code`",
        "- `codeBlock`",
        "- `heading1`",
        "- `heading2`",
        "- `heading3`",
        "- `heading4`",
        "- `heading5`",
        "- `heading6`",
        "- `hardBreak`",
        "- `highlight`",
        "- `horizontalRule`",
        "- `inlineFormats`",
        "- `italic`",
        "- `justify`",
        "- `left`",
        "- `link`",
        "- `normalize`",
        "- `orderedList`",
        "- `paragraph`",
        "- `redo`",
        "- `right`",
        "- `strike`",
        "- `subscript`",
        "- `superscript`",
        "- `underline`",
        "- `undo`"
      ],
      default: () => ["bold", "italic", "underline"]
    },
    blockFormats: {
      type: "{ className: string; label?: string; tags?: string[] }[]",
      description: [
        "An array of objects that specifies the block formats to display in the toolbar.",
        "Block formats are used to specify CSS classes to be applied to the block element.",
        "They are displayed as a dropdown list in the toolbar.",
        "",
        "@example",
        "```typescript",
        "[{ className: 'p-6 border rounded', label: 'Boxed', tags: ['div'] }]",
        "```"
      ],
      default: () => []
    },
    inlineFormats: {
      type: "{ className: string; label?: string; }[]",
      description: [
        "An array of objects that specifies the inline formats to display in the toolbar.",
        "Inline formats are used to specify CSS classes to be applied to the inline element.",
        "They are displayed as a dropdown list in the toolbar.",
        "",
        "@example",
        "```typescript",
        "[{ className: 'text-red-500', label: 'Red' }]",
        "```"
      ],
      default: () => []
    },
    allowFullscreen: {
      type: "boolean",
      description: ["Specifies whether to allow the editor to enter fullscreen mode.", "", "@default true"],
      default: () => true
    }
  },
  sanitizers: [(context) => context.options.required ? context.value : defaultSanitizer(context), stringSanitizer],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: ({ __, language, options, value }) => {
        if (options.required && (!value || value === "<p></p>")) {
          throw new Error(__(language, "pruvious-server", "This field is required"));
        }
      }
    },
    stringValidator,
    {
      onCreate: true,
      onUpdate: true,
      validator: async ({ __, collections, language, query, value }) => {
        const regex = /href="([a-z0-9-]+):([1-9][0-9]*?)([#\?].*)?"/g;
        let matches = null;
        while (matches = regex.exec(value)) {
          const c = collections[matches[1]];
          if (c?.publicPages) {
            const record = await query(c.name).where("id", matches[2]).exists();
            if (!record) {
              throw new Error(
                __(language, "pruvious-server", "$item #$id does not exist and cannot be linked", {
                  item: capitalize(c.label.record.singular),
                  id: +matches[2]
                })
              );
            }
          }
        }
      }
    }
  ],
  population: {
    type: "string",
    populator: async ({ query, value }) => {
      if (!isString(value)) {
        return "";
      }
      const { collections } = await Promise.resolve().then(function () { return collections$1; });
      const regex = /href="([a-z0-9-]+):([1-9][0-9]*?)([#\?].*)?"/g;
      let matches = null;
      while (matches = regex.exec(value)) {
        const c = collections[matches[1]];
        if (c?.publicPages) {
          const pathField = c.publicPages.pathField ?? "path";
          const record = await query(c.name).select({ [pathField]: true, language: true }).where("id", matches[2]).first();
          if (record) {
            const path = joinRouteParts(
              record.language === primaryLanguage && true ? "" : record.language,
              resolveCollectionPathPrefix(c, record.language, primaryLanguage),
              record[pathField]
            );
            value = value.replaceAll(matches[0], `href="${path + (matches[3] ?? "")}"`);
          }
        }
      }
      return value.replaceAll("_fr--", "class");
    }
  },
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const iconFieldDefinition = defineField({
  name: "icon",
  type: { js: "string", ts: "Icon | null" },
  default: ({ options }) => options.default ?? null,
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: ["Specifies that the field input is mandatory during creation.", "", "@default false"],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'categoryIcon' => 'Category icon'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "Icon | null",
      description: ["The default field value.", "", "@default null"]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    allow: {
      type: "Icon[] | '*'",
      description: [
        "An array of icon filenames (without the extension) from the `icons` folder in the Pruvious project.",
        "If specified, only these icons can be selected.",
        "By default, all icons can be selected.",
        "",
        "@default '*'"
      ],
      default: () => "*"
    },
    exclude: {
      type: "Icon[]",
      description: [
        "An array of icon filenames (without the extension) from the `icons` folder in the Pruvious project.",
        "If specified, these icons cannot be selected.",
        "By default, no icons are excluded.",
        "",
        "@default []"
      ],
      default: () => []
    }
  },
  sanitizers: [(context) => context.options.required ? context.value : defaultSanitizer(context), stringSanitizer],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    stringOrNullValidator,
    {
      onCreate: true,
      onUpdate: true,
      validator: async ({ __, language, value }) => {
        if (value) {
          const { icons } = await Promise.resolve().then(function () { return index$1; });
          if (!icons.includes(value)) {
            throw new Error(__(language, "pruvious-server", "The icon does not exist"));
          }
        }
      }
    },
    {
      onCreate: true,
      onUpdate: true,
      validator: ({ __, language, options, value }) => {
        if (value) {
          if (isArray(options.allow) && !options.allow.includes(value)) {
            throw new Error(__(language, "pruvious-server", "The icon is not allowed for this field"));
          } else if (isArray(options.exclude) && options.exclude.includes(value)) {
            throw new Error(__(language, "pruvious-server", "The icon is not allowed for this field"));
          }
        }
      }
    }
  ],
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const imageFieldDefinition = defineField({
  name: "image",
  type: { js: "object", ts: "{ uploadId: number, alt: string } | null" },
  default: ({ options }) => options.default ?? null,
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: ["Specifies whether the field input is required during creation.", "", "@default false"],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'productImage' => 'Product image'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "{ uploadId: number, alt: string } | null",
      description: ["The default field value.", "", "@default null"]
    },
    transformSvgs: {
      type: "boolean",
      description: [
        "Specifies whether to transform SVG images.",
        "If `false`, the `sources` option is disregarded.",
        "",
        "@default false"
      ],
      default: () => false
    },
    sources: {
      type: "ImageSource[]",
      description: [
        "An array of optimized image sources.",
        "When this field is populated, the resulting object will include a `sources` property.",
        "This property is an array of objects, each with the following properties:",
        "",
        "- `srcset` - The URL or absolute path of the image source.",
        "- `width` - The width of the image source in pixels.",
        "- `height` - The height of the image source in pixels.",
        "- `type` - The MIME type of the image source.",
        "- `media` - The media query of the image source or `null` if not specified.",
        "",
        "@default []",
        "",
        "@example",
        "```typescript",
        "[",
        "  { media: '(max-width: 768px)', format: 'webp', width: 1024, height: 1024, resize: 'cover' },",
        "  { media: '(max-width: 768px)', format: 'jpeg', width: 1024, height: 1024, resize: 'cover' },",
        "  { format: 'webp', width: 1600, height: 1600, resize: 'cover' },",
        "  { format: 'jpeg', width: 1600, height: 1600, resize: 'cover' },",
        "]",
        "```"
      ],
      default: () => []
    },
    allowedTypes: {
      type: "string[]",
      description: [
        "An array of allowed image types or extensions.",
        "",
        "@default [",
        "  'image/jpeg',",
        "  'image/png',",
        "  'image/svg+xml',",
        "  'image/webp',",
        "  'image/gif',",
        "  'image/apng',",
        "  'image/avif',",
        "  'image/bmp',",
        "  'image/heic',",
        "  'image/tiff',",
        "  'image/x-icon',",
        "]",
        "",
        "@example",
        "```typescript",
        "['image/jpeg', '.png', 'SVG']",
        "```"
      ],
      default: () => imageTypes
    },
    minWidth: {
      type: "number",
      description: ["The minimum allowed image width in pixels.", "", "@default 0"],
      default: () => 0
    },
    minHeight: {
      type: "number",
      description: ["The minimum allowed image height in pixels.", "", "@default 0"],
      default: () => 0
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input control.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    }
  },
  population: {
    type: {
      js: "object",
      ts: "Image | null"
    },
    populator: async ({ options, query, value }) => {
      if (value) {
        const upload = await query("uploads").where("id", value.uploadId).setFieldValueType(options.populate ? "populated" : "casted").first();
        if (upload) {
          const { getModuleOption } = await Promise.resolve().then(function () { return state; });
          const uploadsOptions = getModuleOption("uploads");
          const sources = [];
          if (options.sources.length && (options.transformSvgs || upload.type !== "image/svg+xml")) {
            for (const source of options.sources) {
              const { getOptimizedImage } = await Promise.resolve().then(function () { return images; });
              const optimizedImage = await getOptimizedImage(upload, source);
              if (optimizedImage.success) {
                sources.push({
                  srcset: optimizedImage.src,
                  width: optimizedImage.width,
                  height: optimizedImage.height,
                  media: source.media ?? null,
                  type: source.format === "jpeg" ? "image/jpeg" : `image/${source.format}`
                });
              }
            }
          }
          return {
            src: uploadsOptions.drive.type === "local" ? joinRouteParts(
              getModuleOption("baseUrl"),
              uploadsOptions.drive.urlPrefix ?? "uploads",
              upload.directory,
              upload.filename
            ) : uploadsOptions.drive.baseUrl + upload.directory + upload.filename,
            alt: value.alt || upload.description,
            width: upload.width,
            height: upload.height,
            type: upload.type,
            sources
          };
        }
      }
      return null;
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    ({ value }) => {
      const sanitized = numericSanitizer({ value });
      return isPositiveInteger(sanitized) ? { uploadId: sanitized, alt: "" } : value;
    }
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    ({ __, language, value }) => {
      if (!isNull(value) && (!isObject(value) || Object.keys(value).length !== 2 || !isPositiveInteger(value.uploadId) || !isString(value.alt))) {
        throw new Error(__(language, "pruvious-server", "Invalid input type"));
      }
    },
    async ({ __, language, collections, options, value, query }) => {
      if (value) {
        const upload = await query("uploads").where("id", value.uploadId).first();
        if (!upload) {
          throw new Error(
            __(language, "pruvious-server", "The $item does not exist", {
              item: __(language, "pruvious-server", collections["uploads"].label.collection.singular)
            })
          );
        }
        if (isDefined(options.allowedTypes)) {
          const extension = upload.filename.split(".").pop() ?? "";
          const allowedTypes = options.allowedTypes.map((type) => type.toLowerCase());
          if (!allowedTypes.some(
            (type) => type.includes("/") ? type === upload.type : type.replace(/^\./, "") === extension
          )) {
            throw new Error(
              __(language, "pruvious-server", "The image type must be one of the following: $types", {
                types: allowedTypes.map((type) => type.startsWith(".") ? type.slice(1) : type).sort().join(", ")
              })
            );
          }
        }
        if (upload.type !== "image/svg+xml" && isDefined(options.minWidth)) {
          if (upload.width < options.minWidth) {
            throw new Error(
              __(language, "pruvious-server", "The minimum allowed image width is $min pixels", {
                min: options.minWidth
              })
            );
          }
        }
        if (upload.type !== "image/svg+xml" && isDefined(options.minHeight)) {
          if (upload.height < options.minHeight) {
            throw new Error(
              __(language, "pruvious-server", "The minimum allowed image height is $min pixels", {
                min: options.minHeight
              })
            );
          }
        }
      }
    }
  ],
  inputMeta: {
    type: "{ uploadId: number, alt: string } | number | null",
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const linkFieldDefinition = defineField({
  name: "link",
  type: "string",
  default: ({ options }) => options.default ?? "",
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: ["Specifies that the field input is mandatory during creation.", "", "@default false"],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'landingPage' => 'Landing page'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "string",
      description: ["The default field value.", "", "@default ''"]
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input control, influencing autocomplete behavior in some browsers.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    placeholder: {
      type: "string",
      description: ["Text that appears in the input element when it has no value set."]
    },
    visibleChoices: {
      type: "number",
      description: ["The number of visible link choices in the dropdown list (must be less than 30)."],
      default: () => 6
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    ({ value }) => isString(value) ? value.trim() : value,
    stringSanitizer
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    stringValidator,
    {
      onCreate: true,
      onUpdate: true,
      validator: ({ __, language, value }) => {
        const path = value.split("#")[0].split("?")[0];
        if (!isUrl(path) && !isUrlPath(path, true) && !path.startsWith("#")) {
          throw new Error(
            path.startsWith("http") ? __(language, "pruvious-server", "Invalid URL") : __(language, "pruvious-server", "Invalid URL path")
          );
        }
      }
    },
    {
      onCreate: true,
      onUpdate: true,
      validator: async ({ __, collections, language, query, value }) => {
        const match = value.match(/^([a-z0-9-]+):([1-9][0-9]*?)([#\?].*)?$/);
        if (match) {
          const c = collections[match[1]];
          if (c?.publicPages) {
            const record = await query(c.name).where("id", match[2]).exists();
            if (!record) {
              throw new Error(
                __(language, "pruvious-server", "$item #$id does not exist and cannot be linked", {
                  item: capitalize(c.label.record.singular),
                  id: +match[2]
                })
              );
            }
          }
        }
      }
    }
  ],
  population: {
    type: "string",
    populator: async ({ query, value }) => {
      const { collections } = await Promise.resolve().then(function () { return collections$1; });
      const match = value.match(/^([a-z0-9-]+):([1-9][0-9]*?)([#\?].*)?$/);
      if (match) {
        const c = collections[match[1]];
        if (c?.publicPages) {
          const pathField = c.publicPages.pathField ?? "path";
          const record = await query(c.name).select({ [pathField]: true, language: true }).where("id", match[2]).first();
          if (record) {
            return joinRouteParts(
              record.language === primaryLanguage && true ? "" : record.language,
              resolveCollectionPathPrefix(c, record.language, primaryLanguage),
              record[pathField]
            ) + (match[3] ?? "");
          }
        }
      }
      return value;
    }
  },
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const numberFieldDefinition = defineField({
  name: "number",
  type: "number",
  default: ({ options }) => options.default ?? clamp(0, options.min ?? Number.MIN_SAFE_INTEGER, options.max ?? Number.MAX_SAFE_INTEGER),
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: [
        "Specifies whether the field input is mandatory. The requirement check allows the value `0` to be considered as valid.",
        "",
        "@default false"
      ],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'numberOfGuests' => 'Number of guests'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "number",
      description: [
        "The default field value.",
        "",
        "By default, this is set to 0 if possible, otherwise it uses the `min` value."
      ]
    },
    decimals: {
      type: "number",
      description: [
        "Specifies the maximum number of allowed decimal places for the number.",
        "",
        "Set to 0 to allow integers only.",
        "",
        "**Caution:** Consider JavaScript Number limits (`MIN_SAFE_INTEGER` and `MAX_SAFE_INTEGER`).",
        "",
        "@default 0"
      ],
      default: () => 0
    },
    min: {
      type: "number",
      description: ["The minimum allowed number.", "", "@default Number.MIN_SAFE_INTEGER (-9007199254740991)"],
      default: () => Number.MIN_SAFE_INTEGER
    },
    max: {
      type: "number",
      description: ["The maximum allowed number.", "", "@default Number.MAX_SAFE_INTEGER (9007199254740991)"],
      default: () => Number.MAX_SAFE_INTEGER
    },
    step: {
      type: "number",
      description: [
        "The `step` attribute specifies the interval between legal numbers in an `<input>` element.",
        "",
        "@default 1"
      ],
      default: () => 1
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input control.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    placeholder: {
      type: "string",
      description: ["Text that appears in the input element when it has no value set."]
    },
    prefix: {
      type: "string",
      description: ["A short text to be prepended before the input element."]
    },
    suffix: {
      type: "string",
      description: ["A short text to be appended after the input element."]
    }
  },
  sanitizers: [(context) => context.options.required ? context.value : defaultSanitizer(context), numericSanitizer],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    numberValidator,
    ({ __, language, options, value }) => {
      if (isDefined(options.decimals) && countDecimals(value) > options.decimals) {
        if (options.decimals === 0) {
          throw new Error(__(language, "pruvious-server", "The input must be an integer"));
        } else {
          throw new Error(
            __(language, "pruvious-server", "The input cannot have more than $count $decimals", {
              count: options.decimals
            })
          );
        }
      }
    },
    ({ __, language, options, value }) => {
      if (isDefined(options.min) && value < options.min) {
        throw new Error(
          __(language, "pruvious-server", "The input must be greater than or equal to $min", { min: options.min })
        );
      }
    },
    ({ __, language, options, value }) => {
      if (isDefined(options.max) && value > options.max) {
        throw new Error(
          __(language, "pruvious-server", "The input must be less than or equal to $max", { max: options.max })
        );
      }
    }
  ],
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const rangeFieldDefinition = defineField({
  name: "range",
  type: { js: "object", ts: "[number, number]" },
  default: ({ options }) => options.default ?? [options.min ?? 0, options.max ?? 100],
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: [
        "Specifies whether the field input is mandatory. The requirement check allows the value `[0, 0]` to be considered as valid.",
        "",
        "@default false"
      ],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'temperatureRange' => 'Temperature range'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "[number, number]",
      description: ["The default field value.", "", "By default, this is set to the minimum and maximum values."]
    },
    decimals: {
      type: "number",
      description: [
        "Specifies the maximum number of allowed decimal places for the inputs.",
        "",
        "Set to 0 to allow integers only.",
        "",
        "**Caution:** Consider JavaScript Number limits (`MIN_SAFE_INTEGER` and `MAX_SAFE_INTEGER`).",
        "",
        "@default 0"
      ],
      default: () => 0
    },
    min: {
      type: "number",
      description: ["The minimum allowed number.", "", "@default 0"],
      default: () => 0
    },
    max: {
      type: "number",
      description: ["The maximum allowed number.", "", "@default 100"],
      default: () => 100
    },
    step: {
      type: "number",
      description: [
        "The `step` attribute specifies the interval between legal numbers in the `<input>` elements.",
        "",
        "@default 1"
      ],
      default: () => 1
    },
    minRange: {
      type: "number",
      description: ["The minimum range between the two inputs.", "", "@default 0"],
      default: () => 0
    },
    maxRange: {
      type: "number",
      description: [
        "Specifies the maximum range between the two inputs.",
        "",
        "By default, this is set to `max - min`."
      ],
      default: ({ options }) => options.max - options.min
    },
    name: {
      type: "string | [string | null, string | null]",
      description: [
        "A string that specifies the `name` for the input controls.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    placeholder: {
      type: "string | [string | null, string | null]",
      description: ["Text that appears in the input elements when they have no value set."]
    },
    prefix: {
      type: "string | [string | null, string | null]",
      description: ["A short text to be prepended before the input elements."]
    },
    suffix: {
      type: "string | [string | null, string | null]",
      description: ["A short text to be appended after the input elements."]
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    ({ value }) => isArray(value) && value.length === 2 ? [numericSanitizer({ value: value[0] }), numericSanitizer({ value: value[1] })] : value
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    ({ __, language, value }) => {
      if (!isArray(value) || value.length !== 2 || !value.every(isRealNumber)) {
        throw new Error(__(language, "pruvious-server", "Invalid input type"));
      }
    },
    ({ __, language, options, value }) => {
      if (isDefined(options.decimals) && (countDecimals(value[0]) > options.decimals || countDecimals(value[1]) > options.decimals)) {
        if (options.decimals === 0) {
          throw new Error(__(language, "pruvious-server", "The inputs must be integers"));
        } else {
          throw new Error(
            __(language, "pruvious-server", "The inputs cannot have more than $count $decimals", {
              count: options.decimals
            })
          );
        }
      }
    },
    ({ __, language, options, value }) => {
      if (isDefined(options.min) && value[0] < options.min || isDefined(options.min) && value[1] < options.min) {
        throw new Error(
          __(language, "pruvious-server", "The inputs must be greater than or equal to $min", { min: options.min })
        );
      }
    },
    ({ __, language, options, value }) => {
      if (isDefined(options.max) && value[0] > options.max || isDefined(options.max) && value[1] > options.max) {
        throw new Error(
          __(language, "pruvious-server", "The inputs must be less than or equal to $max", { max: options.max })
        );
      }
    },
    ({ __, language, options, value }) => {
      if (value[1] - value[0] < options.minRange) {
        throw new Error(
          __(language, "pruvious-server", "The minimum range between the inputs is $minRange", {
            minRange: options.minRange
          })
        );
      } else if (value[1] < value[0]) {
        throw new Error(__(language, "pruvious-server", "The second value cannot be less than the first value"));
      }
    },
    ({ __, language, options, value }) => {
      if (value[1] - value[0] > options.maxRange) {
        throw new Error(
          __(language, "pruvious-server", "The maximum range between the inputs is $maxRange", {
            maxRange: options.maxRange
          })
        );
      }
    }
  ],
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const sliderRangeFieldDefinition = defineField({
  name: "slider-range",
  type: { js: "object", ts: "[number, number]" },
  default: ({ options }) => options.default ?? [options.min ?? 0, options.max ?? 100],
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: [
        "Specifies whether the field input is mandatory. The requirement check allows the value `[0, 0]` to be considered as valid.",
        "",
        "@default false"
      ],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'temperatureRange' => 'Temperature range'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "[number, number]",
      description: ["The default field value.", "", "By default, this is set to the minimum and maximum values."]
    },
    min: {
      type: "number",
      description: ["The minimum allowed number.", "", "@default 0"],
      default: () => 0
    },
    max: {
      type: "number",
      description: ["The maximum allowed number.", "", "@default 100"],
      default: () => 100
    },
    step: {
      type: "number",
      description: ["Specifies the number intervals in the slider.", "", "@default 1"],
      default: () => 1
    },
    minRange: {
      type: "number",
      description: ["The minimum range between the two inputs.", "", "@default 0"],
      default: () => 0
    },
    maxRange: {
      type: "number",
      description: [
        "Specifies the maximum range between the two inputs.",
        "",
        "By default, this is set to `max - min`."
      ],
      default: ({ options }) => options.max - options.min
    },
    marks: {
      type: "boolean | number[]",
      description: [
        "Specifies whether to display the number intervals (steps) in the slider.",
        "Marks can be customized by passing an array of numbers.",
        "",
        "@default false"
      ],
      default: () => false
    },
    inputs: {
      type: "boolean",
      description: ["Specifies whether to display the input fields next to the slider.", "", "@default true"],
      default: () => true
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    ({ value }) => isArray(value) && value.length === 2 ? [numericSanitizer({ value: value[0] }), numericSanitizer({ value: value[1] })] : value
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    ({ __, language, value }) => {
      if (!isArray(value) || value.length !== 2 || !value.every(isRealNumber)) {
        throw new Error(__(language, "pruvious-server", "Invalid input type"));
      }
    },
    ({ __, language, options, value }) => {
      if (isDefined(options.min) && value[0] < options.min || isDefined(options.min) && value[1] < options.min) {
        throw new Error(
          __(language, "pruvious-server", "The inputs must be greater than or equal to $min", { min: options.min })
        );
      }
    },
    ({ __, language, options, value }) => {
      if (isDefined(options.max) && value[0] > options.max || isDefined(options.max) && value[1] > options.max) {
        throw new Error(
          __(language, "pruvious-server", "The inputs must be less than or equal to $max", { max: options.max })
        );
      }
    },
    ({ __, language, options, value }) => {
      if (options.step !== 0) {
        const remainder0 = (value[0] - options.min) % options.step;
        const remainder1 = (value[1] - options.min) % options.step;
        if (remainder0 !== 0 || remainder1 !== 0) {
          throw new Error(
            __(language, "pruvious-server", "The inputs must be a multiple of $interval between $min and $max", {
              interval: options.step,
              min: options.min,
              max: options.max
            })
          );
        }
      }
    },
    ({ __, language, options, value }) => {
      if (value[1] - value[0] < options.minRange) {
        throw new Error(
          __(language, "pruvious-server", "The minimum range between the inputs is $minRange", {
            minRange: options.minRange
          })
        );
      }
    },
    ({ __, language, options, value }) => {
      if (value[1] - value[0] > options.maxRange) {
        throw new Error(
          __(language, "pruvious-server", "The maximum range between the inputs is $maxRange", {
            maxRange: options.maxRange
          })
        );
      }
    }
  ],
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const sliderFieldDefinition = defineField({
  name: "slider",
  type: "number",
  default: ({ options }) => options.default ?? clamp(0, options.min, options.max),
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: [
        "Specifies whether the field input is mandatory. The requirement check allows the value `0` to be considered as valid.",
        "",
        "@default false"
      ],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'maxGuests' => 'Max guests'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "number",
      description: [
        "The default field value.",
        "",
        "By default, this is set to 0 if possible, otherwise it uses the `min` value."
      ]
    },
    min: {
      type: "number",
      description: ["The minimum allowed number.", "", "@default 0"],
      default: () => 0
    },
    max: {
      type: "number",
      description: ["The maximum allowed number.", "", "@default 100"],
      default: () => 100
    },
    step: {
      type: "number",
      description: ["Specifies the number intervals in the slider.", "", "@default 1"],
      default: () => 1
    },
    marks: {
      type: "boolean | number[]",
      description: [
        "Specifies whether to display the number intervals (steps) in the slider.",
        "Marks can be customized by passing an array of numbers.",
        "",
        "@default false"
      ],
      default: () => false
    },
    input: {
      type: "boolean",
      description: ["Specifies whether to display an input field next to the slider.", "", "@default true"],
      default: () => true
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    }
  },
  sanitizers: [(context) => context.options.required ? context.value : defaultSanitizer(context), numericSanitizer],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    numberValidator,
    ({ __, language, options, value }) => {
      if (isDefined(options.min) && value < options.min) {
        throw new Error(
          __(language, "pruvious-server", "The input must be greater than or equal to $min", { min: options.min })
        );
      }
    },
    ({ __, language, options, value }) => {
      if (isDefined(options.max) && value > options.max) {
        throw new Error(
          __(language, "pruvious-server", "The input must be less than or equal to $max", { max: options.max })
        );
      }
    },
    ({ __, language, options, value }) => {
      if (options.step !== 0) {
        const remainder = (value - options.min) % options.step;
        if (remainder !== 0) {
          throw new Error(
            __(language, "pruvious-server", "The input must be a multiple of $interval between $min and $max", {
              interval: options.step,
              min: options.min,
              max: options.max
            })
          );
        }
      }
    }
  ],
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const switchFieldDefinition = defineField({
  name: "switch",
  type: "boolean",
  default: ({ options }) => options.default ?? false,
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: [
        "Indicates whether the field input is mandatory, requiring its presence during creation, with the value set to `true`.",
        "",
        "@default false"
      ],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'showTitle' => 'Show title'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "boolean",
      description: ["The default field value.", "", "@default false"]
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input control.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    trueLabel: {
      type: "string",
      description: ["The label for the `true` value.", "", "@default 'Yes'"],
      default: () => "Yes"
    },
    falseLabel: {
      type: "string",
      description: ["The label for the `false` value.", "", "@default 'No'"],
      default: () => "No"
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in the tooltip when hovering over the field label.",
        "",
        "Use an array to handle line breaks."
      ]
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    booleanishSanitizer
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    booleanValidator
  ],
  inputMeta: {
    type: "Booleanish",
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const textAreaFieldDefinition = defineField({
  name: "text-area",
  type: "string",
  default: ({ options }) => options.default ?? "",
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: [
        "Specifies that the input field is mandatory during creation and cannot have an empty string value.",
        "",
        "@default false"
      ],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'description' => 'Description'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "string",
      description: ["The default field value.", "", "@default ''"],
      default: () => ""
    },
    trim: {
      type: "boolean",
      description: ["Specifies whether to remove whitespace from both ends of the input string.", "", "@default true"],
      default: () => true
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input control.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    wrap: {
      type: "boolean",
      description: [
        "Specifies whether the text in the field should be automatically wrapped.",
        "",
        "If `false`, the text will only wrap on enter or hard breaks."
      ],
      default: () => true
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    placeholder: {
      type: "string",
      description: ["Text that appears in the input element when it has no value set."]
    },
    spellcheck: {
      type: "boolean | 'true' | 'false'",
      description: [
        "A booleanish value indicating whether spellchecking is enabled for the input element.",
        "",
        "@default 'false'"
      ],
      default: () => "false"
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    ({ value, options }) => options.trim && isString(value) ? value.trim() : value,
    stringSanitizer
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    stringValidator
  ],
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const timeRangeFieldDefinition = defineField({
  name: "time-range",
  type: { js: "object", ts: "[number | null, number | null]" },
  default: ({ options }) => isDefined(options.default) ? options.default : [null, null],
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: ["Specifies that the field input is mandatory during creation.", "", "@default false"],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'eventTime' => 'Event time'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "[number | null, number | null]",
      description: ["The default field value.", "", "@default [null, null]"],
      default: () => [null, null]
    },
    min: {
      type: "number",
      description: ["The earliest possible time (as timestamp in milliseconds).", "", "@default 0"],
      default: () => 0
    },
    max: {
      type: "number",
      description: ["The latest possible time (as timestamp in milliseconds).", "", "@default 86399999"],
      default: () => 86399999
    },
    name: {
      type: "string | [string, string]",
      description: [
        "A string that specifies the `name` for the input controls.",
        "You can specify the name as a tuple of strings.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    placeholder: {
      type: "string | [string, string]",
      description: [
        "Text that appears in the input elements when they have no value set.",
        "You can specify the placeholder as a tuple of strings."
      ]
    },
    clearable: {
      type: "boolean | [boolean, boolean]",
      description: [
        "A boolean indicating whether to display a clear button that removes the current value.",
        "You can specify the clearable option as a tuple of booleans.",
        "",
        "@default true"
      ],
      default: () => true
    }
  },
  sanitizers: [
    (context) => context.options.required ? context.value : defaultSanitizer(context),
    ({ value }) => isArray(value) && value.length === 2 ? [numericSanitizer({ value: value[0] }), numericSanitizer({ value: value[1] })] : value
  ],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => {
        if (context.options.required && (isUndefined(context.value) || isNull(context.value) || isArray(context.value) && (isNull(context.value[0]) || isUndefined(context.value[0]) || isNull(context.value[1]) || isUndefined(context.value[1])))) {
          throw new Error(context.__(context.language, "pruvious-server", "This field is required"));
        }
      }
    },
    ({ __, language, value }) => {
      if (isDefined(value) && (!isArray(value) || value.length !== 2 || !value.every((v) => isInteger(v) || isNull(v)))) {
        throw new Error(__(language, "pruvious-server", "Invalid input type"));
      }
    },
    ({ __, language, options, value }) => {
      if (isInteger(options.min)) {
        if (isInteger(value[0]) && value[0] < options.min || isInteger(value[1]) && value[1] < options.min) {
          throw new Error(
            __(language, "pruvious-server", "The inputs must be greater than or equal to $min", { min: options.min })
          );
        }
      }
    },
    ({ __, language, options, value }) => {
      if (isInteger(options.max)) {
        if (isInteger(value[0]) && value[0] > options.max || isInteger(value[1]) && value[1] > options.max) {
          throw new Error(
            __(language, "pruvious-server", "The inputs must be less than or equal to $max", { max: options.max })
          );
        }
      }
    },
    ({ __, language, value }) => {
      if (isInteger(value[0]) && isInteger(value[1]) && value[1] < value[0]) {
        throw new Error(__(language, "pruvious-server", "The second value cannot be less than the first value"));
      }
    }
  ],
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

const timeFieldDefinition = defineField({
  name: "time",
  type: { js: "number", ts: "number | null", db: "INTEGER" },
  default: ({ options }) => isDefined(options.default) ? options.default : null,
  vueComponent: void 0,
  options: {
    required: {
      type: "boolean",
      description: ["Specifies that the field input is mandatory during creation.", "", "@default false"],
      default: () => false
    },
    label: {
      type: "string",
      description: [
        "The field label displayed in the UI.",
        "",
        "By default, it is automatically generated based on the property name assigned to the field.",
        "Example: 'eventTime' => 'Event time'"
      ],
      default: ({ name }) => titleCase(name, false)
    },
    default: {
      type: "number | null",
      description: ["The default field value.", "", "@default null"]
    },
    min: {
      type: "number",
      description: ["The earliest possible time (as timestamp in milliseconds).", "", "@default 0"],
      default: () => 0
    },
    max: {
      type: "number",
      description: ["The latest possible time (as timestamp in milliseconds).", "", "@default 86399999"],
      default: () => 86399999
    },
    name: {
      type: "string",
      description: [
        "A string that specifies the `name` for the input control.",
        "",
        "If not specified, the `name` attribute will be automatically generated."
      ]
    },
    description: {
      type: "string | string[]",
      description: [
        "A brief descriptive text displayed in code comments and in a tooltip at the upper right corner of the field.",
        "",
        "Use an array to handle line breaks."
      ]
    },
    placeholder: {
      type: "string",
      description: ["Text that appears in the input element when it has no value set."]
    },
    clearable: {
      type: "boolean",
      description: [
        "A boolean indicating whether to display a clear button that removes the current value.",
        "",
        "@default true"
      ],
      default: () => true
    }
  },
  sanitizers: [(context) => context.options.required ? context.value : defaultSanitizer(context), numericSanitizer],
  validators: [
    {
      onCreate: true,
      onUpdate: true,
      validator: (context) => context.options.required && requiredValidator(context)
    },
    integerOrNullValidator,
    ({ __, language, options, value }) => {
      if (isDefined(options.min) && value < options.min) {
        throw new Error(
          __(language, "pruvious-server", "The input must be greater than or equal to $min", { min: options.min })
        );
      }
    },
    ({ __, language, options, value }) => {
      if (isDefined(options.max) && value > options.max) {
        throw new Error(
          __(language, "pruvious-server", "The input must be less than or equal to $max", { max: options.max })
        );
      }
    }
  ],
  inputMeta: {
    required: ({ options }) => !!options.required,
    codeComment: ({ options }) => options.description || ""
  }
});

function pageLikeCollection(options) {
  const recordLabelPlural = options.recordLabel?.plural ?? titleCase(options.name, false).toLowerCase();
  const recordLabelSingular = options.recordLabel?.singular ?? pluralize.singular(recordLabelPlural);
  const filteredLayouts = layouts.filter(
    ({ name }) => !options.allowedLayouts || options.allowedLayouts === "*" || options.allowedLayouts.includes(name)
  );
  return {
    name: options.name,
    mode: "multi",
    label: { record: { singular: recordLabelSingular, plural: recordLabelPlural } },
    search: {
      default: [
        { field: "path", reserve: 160 },
        { field: "title", reserve: 160 },
        { field: "description", reserve: 160 },
        { field: "public", extractKeywords: ({ value }) => value ? "public" : "draft", reserve: 6 },
        { field: "visible", extractKeywords: ({ value }) => value ? "visible" : "hidden", reserve: 7 },
        { field: "blocks", fieldValueType: "populated" }
      ]
    },
    translatable: true,
    publicPages: {
      pathPrefix: options.pathPrefix ?? "",
      publicField: "public",
      draftTokenField: "draftToken",
      publishDateField: "publishDate",
      layoutField: "layout",
      additionalFields: options.additionalPublicPagesFields ?? [],
      seo: {
        titleField: "title",
        baseTitleField: "baseTitle",
        descriptionField: "description",
        visibleField: "visible",
        sharingImageField: "sharingImage",
        metaTagsField: "metaTags"
      }
    },
    contentBuilder: {
      blocksField: "blocks",
      allowedBlocks: options.allowedBlocks ?? "*",
      rootBlocks: options.rootBlocks ?? "*"
    },
    dashboard: {
      icon: options.icon ?? "Note",
      primaryField: "title",
      overviewTable: {
        columns: [{ field: "title", width: 30 }, { field: "path", width: 30 }, "public", "createdAt", "publishDate"],
        searchLabel: ["title", "path"]
      },
      fieldLayout: [
        `# ${capitalize(recordLabelSingular, false)}`,
        "public",
        "path",
        "<~runtime/components/misc/RecordUrlField.vue>",
        "publishDate",
        ...Object.keys(options.additionalFields ?? {}),
        "layout",
        "translations",
        "# SEO",
        "title",
        "baseTitle",
        "description",
        "visible",
        "sharingImage",
        "metaTags"
      ]
    },
    duplicate: async ({ record, query }) => {
      const duplicate = { ...record };
      let i = 0;
      while (true) {
        duplicate.path = `${duplicate.path.replace(/\-[1-9][0-9]*$/, "")}-${++i}`;
        if (await query(options.name).where("path", duplicate.path).where("language", record.language).notExists()) {
          break;
        }
      }
      duplicate.public = false;
      duplicate.title = (duplicate.title.replace(/^\([1-9][0-9]*\)$/, "").replace(/(.*?)( +\([1-9][0-9]*\))?$/, "$1") + ` (${i})`).trim();
      delete duplicate.translations;
      return duplicate;
    },
    mirrorTranslation: async ({ from, to, language, query }) => {
      const mirror = { ...from, id: to?.id, language };
      let i = 0;
      if (to) {
        mirror.path = to.path;
      } else {
        mirror.public = false;
        while (await query(options.name).where("path", mirror.path).where("language", mirror.language).exists()) {
          mirror.path = `${mirror.path.replace(/\-[1-9][0-9]*$/, "")}-${++i}`;
        }
      }
      return mirror;
    },
    fields: {
      /*
      |--------------------------------------------------------------------------
      | path
      |--------------------------------------------------------------------------
      |
      */
      path: {
        type: "text",
        options: {
          label: "URL path",
          description: [
            `The unique URL path of the ${recordLabelSingular}.`,
            "The path always begins with a slash ('/') and never ends with one (e.g., '/about')."
          ],
          required: true,
          default: "/"
        },
        additional: {
          unique: "perLanguage",
          sanitizers: [
            ({ value }) => isString(value) ? joinRouteParts(removeAccents(value).toLowerCase().replace(/ +/g, "-")) : value
          ],
          validators: [
            lowercaseValidator,
            ({ __, language, value }) => {
              if (!isUrlPath(value)) {
                throw new Error(
                  __(language, "pruvious-server", `The ${recordLabelSingular} path must be a URL-safe string`)
                );
              }
            },
            (context) => uniqueValidator(
              context,
              context.__(
                context.language,
                "pruvious-server",
                `A ${recordLabelSingular} with this path already exists`
              )
            )
          ]
        }
      },
      /*
      |--------------------------------------------------------------------------
      | public
      |--------------------------------------------------------------------------
      |
      */
      public: {
        type: "switch",
        options: {
          label: "Status",
          description: `Whether the ${recordLabelSingular} is publicly accessible.`,
          trueLabel: "Public",
          falseLabel: "Draft",
          default: true
        },
        additional: { index: true }
      },
      /*
      |--------------------------------------------------------------------------
      | draftToken
      |--------------------------------------------------------------------------
      |
      */
      draftToken: {
        type: "text",
        options: {
          label: "Draft token",
          description: `The token that allows to access the draft version of the ${recordLabelSingular}. It is generated automatically and cannot be changed.`
        },
        additional: {
          immutable: true,
          sanitizers: [() => nanoid()]
        }
      },
      /*
      |--------------------------------------------------------------------------
      | title
      |--------------------------------------------------------------------------
      |
      */
      title: {
        type: "text-area",
        options: {
          label: "Page title",
          description: "Defines the document's title that is shown in a browser's title bar or a page's tab. Search engines typically display about the first 55-60 characters of a page title. Text beyond that may be lost, so try not to have titles longer than that. If you must use a longer title, make sure the important parts come earlier and that nothing critical is in the part of the title that is likely to be dropped.",
          spellcheck: true
        },
        additional: {
          emptyLabel: "Untitled",
          sanitizers: [({ value }) => isString(value) ? value.replace(/\s+/g, " ") : value]
        }
      },
      /*
      |--------------------------------------------------------------------------
      | baseTitle
      |--------------------------------------------------------------------------
      |
      */
      baseTitle: {
        type: "switch",
        options: {
          label: "Base title",
          description: "Whether the base title defined in the SEO settings should be displayed together with the page title.",
          default: true,
          trueLabel: "Show",
          falseLabel: "Hide"
        }
      },
      /*
      |--------------------------------------------------------------------------
      | description
      |--------------------------------------------------------------------------
      |
      */
      description: {
        type: "text-area",
        options: {
          label: "Page description",
          description: "Specifying a description that includes keywords relating to the content of your page is useful as it has the potential to make your page appear higher in relevant searches performed in search engines.",
          spellcheck: true
        },
        additional: {
          sanitizers: [({ value }) => isString(value) ? value.replace(/\s+/g, " ") : value]
        }
      },
      /*
      |--------------------------------------------------------------------------
      | visible
      |--------------------------------------------------------------------------
      |
      */
      visible: {
        type: "switch",
        options: {
          label: "Search engine visibility",
          description: "Discourage search engines from indexing this page. It is up to search engines to honor this request.",
          trueLabel: "Visible",
          falseLabel: "Hidden",
          default: true
        },
        additional: { index: true }
      },
      /*
      |--------------------------------------------------------------------------
      | sharingImage
      |--------------------------------------------------------------------------
      |
      */
      sharingImage: {
        type: "image",
        options: {
          label: "Sharing image",
          sources: [{ format: "jpeg", width: 1200, height: 630, quality: 90 }],
          minWidth: 1200,
          minHeight: 630,
          transformSvgs: true,
          description: "An image that appears when someone shares this page link on a social network. The optimal image size is 1200 \xD7 630 pixels. If not specified, the default sharing image defined in the SEO settings will be used."
        }
      },
      /*
      |--------------------------------------------------------------------------
      | metaTags
      |--------------------------------------------------------------------------
      |
      */
      metaTags: {
        type: "repeater",
        options: {
          label: "Meta tags",
          description: "The **<meta>** tags for this page. Values entered here will override other automatically generated meta tags.",
          subfields: {
            name: {
              type: "text",
              options: {
                label: "Name",
                required: true,
                placeholder: "e.g., author"
              }
            },
            content: {
              type: "text",
              options: {
                label: "Content",
                required: true,
                placeholder: "e.g., John Doe"
              }
            }
          },
          addLabel: "Add meta tag"
        }
      },
      /*
      |--------------------------------------------------------------------------
      | layout
      |--------------------------------------------------------------------------
      |
      */
      layout: {
        type: "select",
        options: {
          label: "Layout",
          description: `The layout to use for this ${recordLabelSingular}.`,
          default: filteredLayouts.some(({ name }) => name === "default") ? "default" : filteredLayouts[0]?.name ?? null,
          choices: Object.fromEntries(filteredLayouts.map(({ name, label }) => [name, label]))
        }
      },
      /*
      |--------------------------------------------------------------------------
      | publishDate
      |--------------------------------------------------------------------------
      |
      */
      publishDate: {
        type: "date-time",
        options: {
          label: "Publish date",
          description: `The date and time when the ${recordLabelSingular} is published or scheduled for publication.`
        }
      },
      /*
      |--------------------------------------------------------------------------
      | blocks
      |--------------------------------------------------------------------------
      |
      */
      blocks: {
        type: "repeater",
        options: {
          label: "Blocks",
          description: `The blocks that make up the ${recordLabelSingular} content.`,
          subfields: {
            block: {
              type: "block",
              options: {
                label: "Block"
              }
            }
          },
          addLabel: "Add block"
        },
        additional: {
          validators: [
            {
              onCreate: true,
              onUpdate: true,
              validator: async ({ __, errors, input, language, value }) => {
                if (isUndefined(input.layout)) {
                  errors.layout = __(language, "pruvious-server", "This field is required");
                  return;
                }
                const { blocks } = await Promise.resolve().then(function () { return index; });
                const { walkBlocks } = await Promise.resolve().then(function () { return server$1; });
                const { layouts: layouts2 } = await import('../_/index.mjs');
                const layout = layouts2[input.layout];
                try {
                  if (layout?.allowedBlocks || layout?.allowedRootBlocks) {
                    for await (const { block, path, isNestedPresetBlock } of walkBlocks(value)) {
                      const blockLabel = blocks[block.name]?.label ?? block.name;
                      if (layout.allowedBlocks && layout.allowedBlocks !== "*" && !layout.allowedBlocks.includes(block.name)) {
                        errors[`blocks.${path}`] = __(
                          language,
                          "pruvious-server",
                          "The block '$block' is not allowed in the layout '$layout'",
                          { block: blockLabel, layout: layout.label }
                        );
                      } else if (layout.allowedRootBlocks && layout.allowedRootBlocks !== "*" && !isNestedPresetBlock && !path.includes(".") && !layout.allowedRootBlocks.includes(block.name)) {
                        errors[`blocks.${path}`] = __(
                          language,
                          "pruvious-server",
                          "The block '$block' is not allowed as a root block in the layout '$layout'",
                          { block: blockLabel, layout: layout.label }
                        );
                      }
                    }
                  }
                } catch {
                }
              }
            }
          ]
        }
      },
      ...options.additionalFields ?? {}
    }
  };
}

const newsCollectionDefinition = defineCollection(
  pageLikeCollection({
    name: "news",
    pathPrefix: "news",
    rootBlocks: ["PageElementBlock"],
    additionalFields: {
      previewImg: {
        type: "image",
        options: {
          label: "\u0418\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u0435",
          sources: [
            {
              format: "webp",
              resize: "cover"
            },
            {
              format: "jpeg",
              resize: "cover"
            },
            {
              format: "png",
              resize: "cover"
            },
            { format: "webp", resize: "cover" },
            { format: "jpeg", resize: "cover" },
            { format: "png", resize: "cover" }
          ]
        }
      },
      displayDate: {
        type: "date",
        options: {
          label: "\u0414\u0430\u0442\u0430",
          description: "\u0414\u0430\u0442\u0430 \u043D\u043E\u0432\u043E\u0441\u0442\u0438, \u043E\u0442\u043E\u0431\u0440\u0430\u0436\u0430\u0435\u043C\u0430\u044F \u043D\u0430 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0435 \u0438 \u0438\u0441\u043F\u043E\u043B\u044C\u0437\u0443\u0435\u043C\u0430\u044F \u0434\u043B\u044F \u0441\u043E\u0440\u0442\u0438\u0440\u043E\u0432\u043A\u0438",
          clearable: true
        },
        additional: {
          index: true,
          sanitizers: [
            (ctx) => {
              const publishDate = ctx.input.publishDate;
              if (!ctx.value && ctx.input.public) {
                return publishDate || (/* @__PURE__ */ new Date()).setHours(0, 0, 0, 0).valueOf();
              }
              return ctx.value || publishDate;
            }
          ]
        }
      }
    },
    additionalPublicPagesFields: ["previewImg", "displayDate"]
  })
);

const pagesCollectionDefinition = defineCollection(
  pageLikeCollection({
    name: "pages",
    recordLabel: {
      plural: "\u0421\u0442\u0440\u0430\u043D\u0438\u0446\u044B",
      singular: "\u0421\u0442\u0440\u0430\u043D\u0438\u0446\u0430"
    },
    rootBlocks: ["PageElementBlock"]
  })
);

const serverCollectionDefinition = defineCollection({
  name: "server",
  mode: "single",
  fields: {
    smtpEnabled: {
      type: "switch",
      options: {
        label: "\u0412\u043A\u043B\u044E\u0447\u0438\u0442\u044C SMTP",
        default: false,
        required: false,
        trueLabel: "\u0414\u0430",
        falseLabel: "\u041D\u0435\u0442"
      },
      additional: {
        validators: [
          async ({ operation, input }) => {
            if (operation === "read" || !input.smtpEnabled) {
              return;
            }
            const transport = createTransport({
              host: input.smtpHost,
              port: input.smtpPort,
              secure: input.smtpSecure,
              auth: {
                user: input.smtpUser,
                pass: input.smtpPassword
              }
            });
            await transport.verify().catch((e) => {
              throw new AggregateError(
                [e],
                `Failed to verify SMTP connection: ${e.message || String(e)}`
              );
            }).finally(() => {
              transport.close();
            });
          }
        ]
      }
    },
    smtpHost: {
      type: "text",
      options: {
        label: "SMTP \u0445\u043E\u0441\u0442",
        required: true
      },
      additional: {
        conditionalLogic: {
          smtpEnabled: true
        }
      }
    },
    smtpSecure: {
      type: "checkbox",
      options: {
        label: "SMTP Secure",
        required: false,
        default: true
      },
      additional: {
        conditionalLogic: {
          smtpEnabled: true
        }
      }
    },
    smtpPort: {
      type: "number",
      options: {
        label: "SMTP \u043F\u043E\u0440\u0442",
        required: true,
        min: 1,
        max: 65535,
        decimals: 0,
        default: 25
      },
      additional: {
        conditionalLogic: {
          smtpEnabled: true
        }
      }
    },
    smtpUser: {
      type: "text",
      options: {
        label: "SMTP \u043F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u0442\u0435\u043B\u044C",
        required: true
      },
      additional: {
        conditionalLogic: {
          smtpEnabled: true
        }
      }
    },
    smtpPassword: {
      type: "text",
      options: {
        label: "SMTP \u043F\u0430\u0440\u043E\u043B\u044C",
        required: true,
        type: "password"
      },
      additional: {
        conditionalLogic: {
          smtpEnabled: true
        }
      }
    },
    smtpSender: {
      type: "text",
      options: {
        label: "SMTP \u043E\u0442\u043F\u0440\u0430\u0432\u0438\u0442\u0435\u043B\u044C",
        required: true,
        placeholder: '"\u0410\u0434\u043C\u0438\u043D\u0438\u0441\u0442\u0440\u0430\u0442\u043E\u0440" <admin@example.com>'
      },
      additional: {
        conditionalLogic: {
          smtpEnabled: true
        }
      }
    },
    formNotificationsEnabled: {
      type: "switch",
      options: {
        default: false,
        label: "\u0423\u0432\u0435\u0434\u043E\u043C\u043B\u044F\u0442\u044C \u043E \u043D\u043E\u0432\u044B\u0445 \u043E\u0442\u0432\u0435\u0442\u0430\u0445 \u043D\u0430 \u0444\u043E\u0440\u043C\u044B",
        required: false
      }
    },
    formNotificationsReceivers: {
      type: "repeater",
      options: {
        label: "\u041F\u043E\u043B\u0443\u0447\u0430\u0442\u0435\u043B\u0438 \u0443\u0432\u0435\u0434\u043E\u043C\u043B\u0435\u043D\u0438\u0439",
        subfields: {
          email: {
            type: "text",
            options: {
              required: true,
              placeholder: "admin@example.com"
            }
          }
        }
      },
      additional: {
        conditionalLogic: {
          formNotificationsEnabled: true
        }
      }
    },
    formNotificationsSubject: {
      type: "text",
      options: {
        label: "\u0422\u0435\u043C\u0430 \u0443\u0432\u0435\u0434\u043E\u043C\u043B\u0435\u043D\u0438\u044F",
        required: true,
        default: '\u041F\u043E\u043B\u0443\u0447\u0435\u043D \u043E\u0442\u0432\u0435\u0442 \u043D\u0430 \u0444\u043E\u0440\u043C\u0443 "<%= form.title %>"'
      },
      additional: {
        conditionalLogic: {
          formNotificationsEnabled: true
        }
      }
    },
    formNotificationsTemplate: {
      type: "text-area",
      options: {
        label: "\u0428\u0430\u0431\u043B\u043E\u043D \u0443\u0432\u0435\u0434\u043E\u043C\u043B\u0435\u043D\u0438\u044F",
        required: true,
        default: `<!DOCTYPE html>
<html lang="ru">
  <head>
    <meta charset="UTF-8" />
    <title>\u041E\u0442\u0432\u0435\u0442 \u043D\u0430 \u0444\u043E\u0440\u043C\u0443: <%= form.title %></title>
    <!-- Preheader text (hidden) -->
    <style>
      .preheader {
        display: none !important;
        visibility: hidden;
        opacity: 0;
        color: transparent;
        height: 0;
        width: 0;
        overflow: hidden;
        mso-hide: all;
      }
    </style>
  </head>
  <body style="margin:0; padding:0; background-color:#f9f9f9;">
    <!-- Preview text -->
    <div class="preheader">
      \u041D\u043E\u0432\u0430\u044F \u043E\u0442\u043F\u0440\u0430\u0432\u043A\u0430 \u0444\u043E\u0440\u043C\u044B \xAB<%= form.title %>\xBB \u2014 <%= form.description || "" %>
    </div>

    <!-- Wrapper -->
    <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:#f9f9f9; padding:20px 0;">
      <tr>
        <td align="center">
          <!-- Main container -->
          <table width="600" cellpadding="0" cellspacing="0" border="0" style="background-color:#ffffff; border-radius:8px; overflow:hidden;">

            <!-- Header -->
            <tr>
              <td style="padding:20px; font-family:Arial, sans-serif; background-color:#eeeeee;">
                <h2 style="margin:0; font-size:20px; line-height:28px; color:#333333;">
                  \u041E\u0442\u0432\u0435\u0442 \u043D\u0430 \u0444\u043E\u0440\u043C\u0443:
                  <a href="https://your-domain.com/dashboard/forms/<%= form.id %>" style="color:#1a73e8; text-decoration:none;"><%= form.title %></a>
                </h2>
                <% if (form.description) { %>
                <p style="margin:8px 0 0; font-size:14px; line-height:20px; color:#666666;"><%= form.description %></p>
                <% } %>
              </td>
            </tr>

            <!-- Divider -->
            <tr>
              <td style="padding:0 20px;"><hr style="border:none; border-top:1px solid #dddddd; margin:0;" /></td>
            </tr>

            <!-- Form fields (table-like) -->
            <tr>
              <td style="padding:20px;">
                <table width="100%" cellpadding="10" cellspacing="0" border="1" style="border-collapse:collapse; font-family:Arial, sans-serif; color:#333333;">
                  <% fields.forEach((field, i) => { %>
                  <tr style="background-color:<%= i % 2 === 0 ? '#fafafa' : '#ffffff' %>;">
                    <td valign="top" width="30%" style="font-weight:bold; font-size:16px;">
                      <%= field.name %>
                    </td>
                    <td valign="top" style="font-size:16px; color:#555555;">
                      <%= String(field.value) %>
                    </td>
                  </tr>
                  <% }); %>
                </table>
              </td>
            </tr>

            <!-- Footer -->
            <tr>
              <td align="center" style="background-color:#f4f4f4; padding:12px; font-family:Arial, sans-serif; font-size:12px; color:#888888;">
                \u042D\u0442\u043E \u0430\u0432\u0442\u043E\u043C\u0430\u0442\u0438\u0447\u0435\u0441\u043A\u043E\u0435 \u0441\u043E\u043E\u0431\u0449\u0435\u043D\u0438\u0435. \u041F\u043E\u0436\u0430\u043B\u0443\u0439\u0441\u0442\u0430, \u043D\u0435 \u043E\u0442\u0432\u0435\u0447\u0430\u0439\u0442\u0435 \u043D\u0430 \u043D\u0435\u0433\u043E.
              </td>
            </tr>

          </table>
        </td>
      </tr>
    </table>
  </body>
</html>

`
      },
      additional: {
        conditionalLogic: {
          formNotificationsEnabled: true
        }
      }
    }
  }
});

const htmlLabelFields = (overrides) => defu(overrides != null ? overrides : {}, {
  allowHtml: {
    type: "switch",
    options: {
      label: "\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044C HTML",
      default: false,
      required: false,
      trueLabel: "\u0414\u0430",
      falseLabel: "\u041D\u0435\u0442"
    }
  },
  labelContent: {
    type: "text-area",
    options: {
      label: "\u0422\u0435\u043A\u0441\u0442/HTML",
      required: true,
      default: ""
    }
  },
  labelTag: {
    type: "text",
    options: {
      label: "\u0422\u0435\u0433",
      description: "\u0422\u0435\u0433 HTML \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430",
      required: true,
      default: "span"
    },
    additional: {
      conditionalLogic: {
        allowHtml: true
      }
    }
  },
  labelAttributes: {
    type: "repeater",
    options: {
      label: "\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044B",
      description: "\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044B HTML \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430",
      required: false,
      subfields: {
        name: {
          type: "text",
          options: {
            label: "\u0418\u043C\u044F \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430",
            description: "\u0418\u043C\u044F \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 HTML \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430",
            required: true,
            placeholder: "class"
          }
        },
        value: {
          type: "text",
          options: {
            label: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430",
            description: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 HTML \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430",
            required: false,
            placeholder: "text-center"
          }
        }
      }
    },
    additional: {
      conditionalLogic: {
        allowHtml: true
      }
    }
  }
});
const settingsCollectionDefinition = defineCollection({
  name: "settings",
  mode: "single",
  apiRoutes: {
    read: "public"
    // We want to be able to read the settings from the frontend
  },
  fields: {
    nbColorMode: {
      type: "select",
      options: {
        label: "Color mode",
        required: true,
        choices: {
          light: "Light",
          dark: "Dark"
        },
        default: "dark"
      }
    },
    nbVariant: {
      type: "select",
      options: {
        label: "Variant",
        required: true,
        choices: {
          primary: "Primary",
          secondary: "Secondary",
          success: "Success",
          danger: "Danger",
          warning: "Warning",
          info: "Info",
          light: "Light",
          dark: "Dark"
        },
        default: "dark"
      }
    },
    nbToggleable: {
      type: "select",
      options: {
        label: "\u0421\u0432\u043E\u0440\u0430\u0447\u0438\u0432\u0430\u0442\u044C \u043D\u0430\u0432\u0438\u0433\u0430\u0446\u0438\u043E\u043D\u043D\u0443\u044E \u043F\u0430\u043D\u0435\u043B\u044C",
        choices: {
          all: "\u041D\u0430 \u0432\u0441\u0435\u0445 \u044D\u043A\u0440\u0430\u043D\u0430\u0445",
          xl: "\u041D\u0430 xl (\u0438 \u043C\u0435\u043D\u044C\u0448\u0435) \u044D\u043A\u0440\u0430\u043D\u0430\u0445",
          lg: "\u041D\u0430 lg (\u0438 \u043C\u0435\u043D\u044C\u0448\u0435) \u044D\u043A\u0440\u0430\u043D\u0430\u0445",
          md: "\u041D\u0430 md (\u0438 \u043C\u0435\u043D\u044C\u0448\u0435) \u044D\u043A\u0440\u0430\u043D\u0430\u0445",
          sm: "\u041D\u0430 sm (\u0438 \u043C\u0435\u043D\u044C\u0448\u0435) \u044D\u043A\u0440\u0430\u043D\u0430\u0445",
          none: "\u041D\u0438\u043A\u043E\u0433\u0434\u0430 \u043D\u0435 \u0441\u0432\u043E\u0440\u0430\u0447\u0438\u0432\u0430\u0442\u044C"
        },
        required: true,
        default: "sm"
      }
    },
    logo: {
      type: "image",
      options: {
        label: "Logo",
        description: "\u041B\u043E\u0433\u043E \u0441\u0430\u0439\u0442\u0430. \u041E\u0442\u043E\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044F \u0432 \u043D\u0430\u0447\u0430\u043B\u0435 \u043D\u0430\u0432\u0438\u0433\u0430\u0446\u0438\u0438.",
        transformSvgs: true,
        required: false
      }
    },
    nbItems: {
      type: "repeater",
      options: {
        label: "\u042D\u043B\u0435\u043C\u0435\u043D\u0442\u044B \u043C\u0435\u043D\u044E",
        subfields: {
          type: {
            type: "select",
            options: {
              label: "\u0422\u0438\u043F",
              required: true,
              choices: {
                link: "\u0421\u0441\u044B\u043B\u043A\u0430",
                file: "\u0424\u0430\u0439\u043B",
                menu: "\u041C\u0435\u043D\u044E",
                spacer: "\u041F\u0440\u043E\u0431\u0435\u043B"
              },
              default: "link"
            }
          },
          file: {
            type: "file",
            options: {
              label: "\u0424\u0430\u0439\u043B",
              required: true,
              populate: true,
              default: null
            },
            additional: {
              conditionalLogic: {
                type: "file"
              }
            }
          },
          link: {
            type: "link",
            options: {
              label: "\u0421\u0441\u044B\u043B\u043A\u0430",
              required: true,
              default: ""
            },
            additional: {
              conditionalLogic: {
                type: "link"
              }
            }
          },
          class: {
            type: "text",
            options: {
              required: false
            },
            additional: {
              conditionalLogic: {
                type: { ne: "spacer" }
              }
            }
          },
          linkClass: {
            type: "text",
            options: {
              required: false
            },
            additional: {
              conditionalLogic: {
                type: { ne: "spacer" }
              }
            }
          },
          style: {
            type: "text-area",
            options: {
              required: false
            },
            additional: {
              conditionalLogic: {
                type: { ne: "spacer" }
              }
            }
          },
          linkStyle: {
            type: "text-area",
            options: {
              required: false
            },
            additional: {
              conditionalLogic: {
                type: { ne: "spacer" }
              }
            }
          },
          ...htmlLabelFields({
            allowHtml: {
              additional: {
                conditionalLogic: {
                  type: { ne: "spacer" }
                }
              }
            },
            labelAttributes: {
              additional: {
                conditionalLogic: {
                  type: { ne: "spacer" }
                }
              }
            },
            labelContent: {
              additional: {
                conditionalLogic: {
                  type: { ne: "spacer" }
                }
              }
            },
            labelTag: {
              additional: {
                conditionalLogic: {
                  type: { ne: "spacer" }
                }
              }
            }
          }),
          menuItems: {
            type: "repeater",
            options: {
              label: "\u042D\u043B\u0435\u043C\u0435\u043D\u0442\u044B \u043C\u0435\u043D\u044E",
              min: 1,
              subfields: {
                type: {
                  type: "select",
                  options: {
                    label: "\u0422\u0438\u043F",
                    required: true,
                    choices: {
                      link: "\u0421\u0441\u044B\u043B\u043A\u0430",
                      file: "\u0424\u0430\u0439\u043B"
                    },
                    default: "link"
                  }
                },
                file: {
                  type: "file",
                  options: {
                    label: "\u0424\u0430\u0439\u043B",
                    required: true,
                    populate: true,
                    default: null
                  },
                  additional: {
                    conditionalLogic: {
                      type: "file"
                    }
                  }
                },
                link: {
                  type: "link",
                  options: {
                    label: "\u0421\u0441\u044B\u043B\u043A\u0430",
                    required: true,
                    default: ""
                  },
                  additional: {
                    conditionalLogic: {
                      type: "link"
                    }
                  }
                },
                class: {
                  type: "text",
                  options: {
                    required: false
                  }
                },
                linkClass: {
                  type: "text",
                  options: {
                    required: false
                  }
                },
                style: {
                  type: "text-area",
                  options: {
                    required: false
                  }
                },
                linkStyle: {
                  type: "text-area",
                  options: {
                    required: false
                  }
                },
                ...htmlLabelFields()
              },
              addLabel: "\u0414\u043E\u0431\u0430\u0432\u0438\u0442\u044C \u044D\u043B\u0435\u043C\u0435\u043D\u0442",
              fieldLayout: [
                ["type", "allowHtml"],
                ["link", "file"],
                ["labelTag", "labelContent", "labelAttributes"],
                ["class", "linkClass"],
                ["style", "linkStyle"]
              ]
            },
            additional: {
              conditionalLogic: {
                type: "menu"
              }
            }
          }
        },
        addLabel: "\u0414\u043E\u0431\u0430\u0432\u0438\u0442\u044C \u044D\u043B\u0435\u043C\u0435\u043D\u0442",
        fieldLayout: [
          ["type", "allowHtml"],
          ["link", "file"],
          ["labelTag", "labelContent", "labelAttributes"],
          ["class", "linkClass"],
          ["style", "linkStyle"],
          ["menuItems"]
        ]
      }
    },
    nbContainer: {
      type: "select",
      options: {
        label: "\u041A\u043E\u043D\u0442\u0435\u0439\u043D\u0435\u0440",
        choices: {
          fluid: "fluid",
          on: "on",
          off: "none",
          sm: "sm",
          md: "md",
          lg: "lg",
          xl: "xl",
          xxl: "xxl"
        },
        required: true,
        default: "on"
      }
    },
    customStylesheets: {
      type: "repeater",
      options: {
        label: "\u041F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u0442\u0435\u043B\u044C\u0441\u043A\u0438\u0435 \u0441\u0442\u0438\u043B\u0438",
        fieldLayout: [
          ["type"],
          ["internalCss"],
          ["externalRel", "externalLink"],
          ["externalAttrs"]
        ],
        subfields: {
          type: {
            type: "select",
            options: {
              label: "\u0422\u0438\u043F",
              required: true,
              choices: {
                external: "\u0412\u043D\u0435\u0448\u043D\u0438\u0439",
                internal: "\u0412\u043D\u0443\u0442\u0440\u0435\u043D\u043D\u0438\u0439"
              },
              default: "internal"
            }
          },
          externalLink: {
            type: "text",
            options: {
              required: true,
              default: "",
              placeholder: "https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"
            },
            additional: {
              conditionalLogic: {
                type: "external"
              }
            }
          },
          externalRel: {
            type: "text",
            options: {
              required: true,
              default: "stylesheet"
            },
            additional: {
              conditionalLogic: {
                type: "external"
              }
            }
          },
          externalAttrs: {
            type: "repeater",
            options: {
              label: "\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044B",
              subfields: {
                name: {
                  type: "text",
                  options: {
                    label: "\u0410\u0442\u0440\u0438\u0431\u0443\u0442",
                    required: true
                  }
                },
                value: {
                  type: "text",
                  options: {
                    label: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435",
                    required: true
                  }
                }
              },
              fieldLayout: [["name", "value"]],
              addLabel: "\u0414\u043E\u0431\u0430\u0432\u0438\u0442\u044C"
            },
            additional: {
              conditionalLogic: {
                type: "external"
              }
            }
          },
          internalCss: {
            type: "text-area",
            options: {
              required: true,
              default: "",
              placeholder: ".color-red { color: red; }"
            },
            additional: {
              conditionalLogic: {
                type: "internal"
              }
            }
          }
        }
      }
    },
    ftrContainer: {
      type: "select",
      options: {
        label: "\u041A\u043E\u043D\u0442\u0435\u0439\u043D\u0435\u0440",
        description: "\u0428\u0438\u0440\u0438\u043D\u0430 \u044D\u043A\u0440\u0430\u043D\u0430, \u043F\u0440\u0438 \u043A\u043E\u0442\u043E\u0440\u043E\u0439 \u0444\u0443\u0442\u0435\u0440 \u043F\u043E\u043C\u0435\u0449\u0430\u0435\u0442\u0441\u044F \u0432 \u043A\u043E\u043D\u0442\u0435\u0439\u043D\u0435\u0440",
        choices: {
          fluid: "fluid",
          on: "on",
          off: "off",
          sm: "sm",
          md: "md",
          lg: "lg",
          xl: "xl",
          xxl: "xxl"
        },
        required: true,
        default: "on"
      }
    },
    ftrCols: {
      type: "repeater",
      options: {
        label: "\u0421\u0442\u043E\u043B\u0431\u0446\u044B \u0432 \u0444\u0443\u0442\u0435\u0440\u0435",
        addLabel: "\u0414\u043E\u0431\u0430\u0432\u0438\u0442\u044C \u0441\u0442\u043E\u043B\u0431\u0435\u0446",
        subfields: {
          withTitle: {
            type: "switch",
            options: {
              label: "\u0421 \u0437\u0430\u0433\u043E\u043B\u043E\u0432\u043A\u043E\u043C",
              default: false,
              description: "\u041E\u0442\u043E\u0431\u0440\u0430\u0436\u0430\u0435\u0442 \u0437\u0430\u0433\u043E\u043B\u043E\u0432\u043E\u043A \u0441\u0442\u043E\u043B\u0431\u0446\u0430 \u0432 \u0444\u0443\u0442\u0435\u0440\u0435",
              trueLabel: "\u0414\u0430",
              falseLabel: "\u041D\u0435\u0442"
            }
          },
          title: {
            type: "text",
            options: {
              label: "\u0417\u0430\u0433\u043E\u043B\u043E\u0432\u043E\u043A",
              description: "\u0417\u0430\u0433\u043E\u043B\u043E\u0432\u043E\u043A \u0441\u0442\u043E\u043B\u0431\u0446\u0430 \u0432 \u0444\u0443\u0442\u0435\u0440\u0435",
              required: false
            },
            additional: {
              conditionalLogic: {
                withTitle: true
              }
            }
          },
          titleClass: {
            type: "text",
            options: {
              label: "\u041A\u043B\u0430\u0441\u0441 \u0437\u0430\u0433\u043E\u043B\u043E\u0432\u043A\u0430",
              description: "\u041A\u043B\u0430\u0441\u0441 \u0437\u0430\u0433\u043E\u043B\u043E\u0432\u043A\u0430 \u0441\u0442\u043E\u043B\u0431\u0446\u0430 \u0432 \u0444\u0443\u0442\u0435\u0440\u0435",
              required: false,
              default: "h6 text-uppercase opacity-50 mb-3 fw-bold"
            },
            additional: {
              conditionalLogic: {
                withTitle: true
              }
            }
          },
          titleStyle: {
            type: "text-area",
            options: {
              label: "\u0421\u0442\u0438\u043B\u044C \u0437\u0430\u0433\u043E\u043B\u043E\u0432\u043A\u0430",
              description: "\u0421\u0442\u0438\u043B\u044C \u0437\u0430\u0433\u043E\u043B\u043E\u0432\u043A\u0430 \u0441\u0442\u043E\u043B\u0431\u0446\u0430 \u0432 \u0444\u0443\u0442\u0435\u0440\u0435",
              required: false
            },
            additional: {
              conditionalLogic: {
                withTitle: true
              }
            }
          },
          items: {
            type: "repeater",
            options: {
              label: "\u042D\u043B\u0435\u043C\u0435\u043D\u0442\u044B \u0441\u0442\u043E\u043B\u0431\u0446\u0430",
              addLabel: "\u0414\u043E\u0431\u0430\u0432\u0438\u0442\u044C \u044D\u043B\u0435\u043C\u0435\u043D\u0442",
              subfields: {
                type: {
                  type: "select",
                  options: {
                    label: "\u0422\u0438\u043F",
                    description: "\u0422\u0438\u043F \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430",
                    required: true,
                    choices: {
                      text: "\u0422\u0435\u043A\u0441\u0442",
                      html: "HTML",
                      link: "\u0421\u0441\u044B\u043B\u043A\u0430",
                      file: "\u0424\u0430\u0439\u043B"
                    },
                    default: "text"
                  }
                },
                link: {
                  type: "link",
                  options: {
                    required: true,
                    label: "\u0421\u0441\u044B\u043B\u043A\u0430",
                    description: "\u0421\u0441\u044B\u043B\u043A\u0430 \u043D\u0430 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0443",
                    placeholder: "https://example.com"
                  },
                  additional: {
                    conditionalLogic: {
                      type: "link"
                    }
                  }
                },
                file: {
                  type: "file",
                  options: {
                    required: true,
                    label: "\u0424\u0430\u0439\u043B",
                    description: "\u0424\u0430\u0439\u043B \u0434\u043B\u044F \u0437\u0430\u0433\u0440\u0443\u0437\u043A\u0438"
                  },
                  additional: {
                    conditionalLogic: {
                      type: "file"
                    }
                  }
                },
                isHTMLLabel: {
                  type: "switch",
                  options: {
                    label: "HTML?",
                    description: "\u0415\u0441\u043B\u0438 \u0432\u043A\u043B\u044E\u0447\u0435\u043D\u043E, \u0442\u0435\u043A\u0441\u0442 \u0431\u0443\u0434\u0435\u0442 \u043E\u0431\u0440\u0430\u0431\u0430\u0442\u044B\u0432\u0430\u0442\u044C\u0441\u044F \u043A\u0430\u043A HTML",
                    trueLabel: "\u0414\u0430",
                    falseLabel: "\u041D\u0435\u0442"
                  },
                  additional: {
                    conditionalLogic: {
                      $some: [{ type: "link" }, { type: "file" }]
                    }
                  }
                },
                htmlTag: {
                  type: "text",
                  options: {
                    label: "HTML \u0442\u0435\u0433",
                    description: "\u0422\u0435\u0433 HTML \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430",
                    default: "span",
                    required: true
                  },
                  additional: {
                    conditionalLogic: {
                      $some: [
                        {
                          $every: [
                            { isHTMLLabel: true },
                            { $some: [{ type: "link" }, { type: "file" }] }
                          ]
                        },
                        { type: "html" }
                      ]
                    }
                  }
                },
                content: {
                  type: "text-area",
                  options: {
                    label: "\u0422\u0435\u043A\u0441\u0442/HTML",
                    description: "\u041E\u0442\u043E\u0431\u0440\u0430\u0436\u0430\u0435\u043C\u043E\u0435 \u043D\u0430\u0438\u043C\u0435\u043D\u043E\u0432\u0430\u043D\u0438\u0435 \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430. \u0422\u0430\u043A\u0436\u0435 \u043C\u043E\u0436\u0435\u0442 \u0431\u044B\u0442\u044C \u0438\u0441\u043F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u043D HTML",
                    required: true
                  }
                },
                attributes: {
                  type: "repeater",
                  options: {
                    label: "\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044B",
                    description: "\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044B, \u043F\u0440\u0438\u043C\u0435\u043D\u044F\u0435\u043C\u044B\u0435 \u043A \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0443",
                    addLabel: "\u0414\u043E\u0431\u0430\u0432\u0438\u0442\u044C \u0430\u0442\u0440\u0438\u0431\u0443\u0442",
                    subfields: {
                      name: {
                        type: "text",
                        options: {
                          label: "\u0418\u043C\u044F \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430",
                          description: "\u0418\u043C\u044F \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 HTML \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430",
                          required: true,
                          placeholder: "class"
                        }
                      },
                      value: {
                        type: "text",
                        options: {
                          label: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430",
                          description: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 HTML \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430",
                          required: false,
                          placeholder: "text-center"
                        }
                      }
                    },
                    fieldLayout: [["name", "value"]]
                  }
                }
              },
              fieldLayout: [
                ["type"],
                ["link", "file"],
                ["isHTMLLabel", "htmlTag"],
                ["content"],
                ["attributes"]
              ]
            }
          },
          colsXs: {
            type: "number",
            options: {
              label: "\u0421\u0442\u043E\u043B\u0431\u0446\u044B xs+",
              min: 0,
              max: 12,
              decimals: 0,
              default: 12
            }
          },
          colsSm: {
            type: "number",
            options: {
              label: "\u0421\u0442\u043E\u043B\u0431\u0446\u044B sm+",
              min: 0,
              max: 12,
              decimals: 0,
              default: 6
            }
          },
          colsMd: {
            type: "number",
            options: {
              label: "\u0421\u0442\u043E\u043B\u0431\u0446\u044B md+",
              min: 0,
              max: 12,
              decimals: 0,
              default: 4
            }
          },
          colsLg: {
            type: "number",
            options: {
              label: "\u0421\u0442\u043E\u043B\u0431\u0446\u044B lg+",
              min: 0,
              max: 12,
              decimals: 0,
              default: 0
            }
          },
          colsXl: {
            type: "number",
            options: {
              label: "\u0421\u0442\u043E\u043B\u0431\u0446\u044B xl+",
              min: 0,
              max: 12,
              decimals: 0,
              default: 0
            }
          },
          colsXxl: {
            type: "number",
            options: {
              label: "\u0421\u0442\u043E\u043B\u0431\u0446\u044B xxl+",
              min: 0,
              max: 12,
              decimals: 0,
              default: 0
            }
          },
          colClass: {
            type: "text",
            options: {
              label: "\u041A\u043B\u0430\u0441\u0441 \u0441\u0442\u043E\u043B\u0431\u0446\u0430",
              description: "\u041A\u043B\u0430\u0441\u0441 \u0441\u0442\u043E\u043B\u0431\u0446\u0430 \u0432 \u0444\u0443\u0442\u0435\u0440\u0435",
              required: false
            }
          },
          colStyle: {
            type: "text",
            options: {
              label: "\u0421\u0442\u0438\u043B\u044C \u0441\u0442\u043E\u043B\u0431\u0446\u0430",
              description: "\u0421\u0442\u0438\u043B\u044C \u0441\u0442\u043E\u043B\u0431\u0446\u0430 \u0432 \u0444\u0443\u0442\u0435\u0440\u0435",
              required: false
            }
          }
        },
        fieldLayout: [
          ["withTitle", "title"],
          ["titleClass", "titleStyle"],
          ["items"],
          ["colsXs", "colsSm", "colsMd", "colsLg", "colsXl", "colsXxl"],
          ["colClass", "colStyle"]
        ]
      }
    },
    ftrClass: {
      type: "text",
      options: {
        label: "\u041A\u043B\u0430\u0441\u0441 \u0444\u0443\u0442\u0435\u0440\u0430",
        description: "\u041A\u043B\u0430\u0441\u0441 \u0444\u0443\u0442\u0435\u0440\u0430",
        default: "bg-light border-top py-5"
      }
    },
    ftrStyle: {
      type: "text",
      options: {
        label: "\u0421\u0442\u0438\u043B\u044C \u0444\u0443\u0442\u0435\u0440\u0430",
        description: "\u0421\u0442\u0438\u043B\u044C \u0444\u0443\u0442\u0435\u0440\u0430"
      }
    }
  },
  dashboard: {
    // Group fields in tabs
    fieldLayout: [
      {
        "Header": [
          ["nbColorMode"],
          ["nbVariant"],
          ["nbToggleable"],
          ["nbContainer"],
          ["nbItems"]
        ],
        "Footer": [["ftrContainer"], ["ftrClass", "ftrStyle"], ["ftrCols"]],
        "Custom CSS": ["customStylesheets"],
        "\u041E\u0440\u0433\u0430\u043D\u0438\u0437\u0430\u0446\u0438\u044F": ["logo"]
      }
    ]
  }
});

const collections = {
  "presets": presetsCollectionDefinition,
  "previews": previewsCollectionDefinition,
  "redirects": redirectsCollectionDefinition,
  "roles": rolesCollectionDefinition,
  "seo": seoCollectionDefinition,
  "uploads": uploadsCollectionDefinition,
  "users": usersCollectionDefinition,
  "form-submissions": formSubmissionsCollectionDefinition,
  "forms": formsCollectionDefinition,
  "news": newsCollectionDefinition,
  "pages": pagesCollectionDefinition,
  "server": serverCollectionDefinition,
  "settings": settingsCollectionDefinition
};

const collections$1 = /*#__PURE__*/Object.freeze(/*#__PURE__*/Object.defineProperty({
  __proto__: null,
  collections: collections,
  formSubmissionsCollectionDefinition: formSubmissionsCollectionDefinition,
  formsCollectionDefinition: formsCollectionDefinition,
  newsCollectionDefinition: newsCollectionDefinition,
  pagesCollectionDefinition: pagesCollectionDefinition,
  presetsCollectionDefinition: presetsCollectionDefinition,
  previewsCollectionDefinition: previewsCollectionDefinition,
  redirectsCollectionDefinition: redirectsCollectionDefinition,
  rolesCollectionDefinition: rolesCollectionDefinition,
  seoCollectionDefinition: seoCollectionDefinition,
  serverCollectionDefinition: serverCollectionDefinition,
  settingsCollectionDefinition: settingsCollectionDefinition,
  uploadsCollectionDefinition: uploadsCollectionDefinition,
  usersCollectionDefinition: usersCollectionDefinition
}, Symbol.toStringTag, { value: 'Module' }));

async function* walkBlocks(blocks, options = {}) {
  const resolvedOptions = mergeDefaults(options, {
    populatePresets: true,
    fullPresetPath: false,
    pathPrefix: "",
    freezePaths: false
  });
  for (const [i, { block }] of blocks.entries()) {
    if (block.name === "Preset") {
      if (resolvedOptions.populatePresets) {
        const preset = await query("presets").select({ blocks: true }).where("id", block.fields.preset).first();
        if (preset) {
          yield* walkBlocks(preset.blocks, {
            ...resolvedOptions,
            pathPrefix: resolvedOptions.freezePaths ? resolvedOptions.pathPrefix : resolvedOptions.pathPrefix ? `${resolvedOptions.pathPrefix}.${i}` : `${i}`,
            freezePaths: !resolvedOptions.fullPresetPath,
            isRootPresetBlock: true,
            isNestedPresetBlock: !!resolvedOptions.isRootPresetBlock
          });
        }
      }
    } else {
      for (const [slotName, slot] of Object.entries(block.slots ?? {})) {
        yield* walkBlocks(slot, {
          ...resolvedOptions,
          pathPrefix: resolvedOptions.freezePaths ? resolvedOptions.pathPrefix : resolvedOptions.pathPrefix ? `${resolvedOptions.pathPrefix}.${i}.slots.${slotName}` : `${i}.slots.${slotName}`,
          isNestedPresetBlock: !!resolvedOptions.isRootPresetBlock
        });
      }
      const path = resolvedOptions.freezePaths ? resolvedOptions.pathPrefix : resolvedOptions.pathPrefix ? `${resolvedOptions.pathPrefix}.${i}` : `${i}`;
      yield {
        block,
        path,
        isRootPresetBlock: !!resolvedOptions.isRootPresetBlock,
        isNestedPresetBlock: !!resolvedOptions.isNestedPresetBlock
      };
    }
  }
}

const defaultMultiQueryStringParams = Object.freeze({
  group: [],
  limit: void 0,
  offset: void 0,
  order: [],
  populate: false,
  select: [],
  where: { [Op.and]: [] },
  search: {}
});
const defaultSingleQueryStringParams = Object.freeze({
  language: primaryLanguage,
  populate: false,
  select: []
});
function getQueryStringParams(event, collection, options) {
  const qs = getQuery(event) ?? {};
  const collectionDef = isString(collection) ? collections[collection] : collection;
  const isMultiCollection = collectionDef.mode === "multi";
  const errors = [];
  const params = deepClone(
    isMultiCollection ? defaultMultiQueryStringParams : defaultSingleQueryStringParams
  );
  let operation = options?.operation;
  if (!operation) {
    switch (event.method) {
      case "POST":
        operation = "create";
        break;
      case "GET":
        operation = "read";
        break;
      case "PATCH":
        operation = "update";
        break;
      case "DELETE":
        operation = "delete";
        break;
      default:
        throw new Error(__(event, "pruvious-server", "Unable to determine the request operation"));
    }
  }
  if (isDefined(qs.group) && isMultiCollection && operation === "read") {
    params.group = parseQSArray(qs.group)?.filter((fieldName) => {
      if (collectionDef.fields[fieldName]) {
        if (collectionDef.fields[fieldName].additional?.protected) {
          errors.push(
            __(
              event,
              "pruvious-server",
              "The field '$field' cannot be queried",
              { field: fieldName }
            )
          );
          return false;
        } else {
          return true;
        }
      } else {
        errors.push(
          __(
            event,
            "pruvious-server",
            "The field '$field' does not exist",
            { field: fieldName }
          )
        );
        return false;
      }
    });
  }
  if (isDefined(qs.language) && !isMultiCollection && (operation === "read" || operation === "update")) {
    const language = qs.language && isString(qs.language) ? qs.language : null;
    if (language && supportedLanguages.includes(language)) {
      params.language = language;
    } else {
      errors.push(
        __(
          event,
          "pruvious-server",
          "The language code '$language' is not supported",
          { language }
        )
      );
    }
  }
  if (isDefined(qs.limit) && isMultiCollection && operation === "read") {
    const limit = qs.limit && isString(qs.limit) ? +qs.limit : null;
    if (isInteger(limit) && limit >= 0) {
      params.limit = limit;
    } else {
      errors.push(
        __(
          event,
          "pruvious-server",
          "The 'limit' parameter must be a non-negative integer"
        )
      );
    }
  }
  if (isDefined(qs.offset) && isMultiCollection && operation === "read") {
    const offset = qs.offset && isString(qs.offset) ? +qs.offset : null;
    if (isInteger(offset) && offset >= 0) {
      params.offset = offset;
    } else {
      errors.push(
        __(
          event,
          "pruvious-server",
          "The 'offset' parameter must be a non-negative integer"
        )
      );
    }
  }
  if (isDefined(qs.order) && isMultiCollection) {
    const order = parseQSArray(qs.order);
    if (order?.length) {
      params.order = order.map((value) => {
        if (value[0] === ":") {
          const splitted = value.slice(1).split(":");
          const structure = splitted[0];
          const direction = resolveOrderDirection(splitted[1] ?? "asc");
          const search = collectionDef.search;
          if (!search) {
            errors.push(
              __(
                event,
                "pruvious-server",
                "This collection is not searchable"
              )
            );
            return false;
          } else if (!search[structure]) {
            errors.push(
              __(
                event,
                "pruvious-server",
                `The search structure '$structure' does not exist`,
                { structure }
              )
            );
            return false;
          } else if (direction === false) {
            errors.push(
              __(
                event,
                "pruvious-server",
                `The order direction '$direction' is not valid`,
                { direction }
              )
            );
            return false;
          }
          return [`:${structure}`, direction === "asc" ? "ASC NULLS LAST" : "DESC NULLS LAST"];
        } else {
          const splitted = value.split(":");
          const fieldName = splitted[0];
          const direction = resolveOrderDirection(splitted[1] ?? "asc");
          if (!collectionDef.fields[fieldName]) {
            errors.push(
              __(
                event,
                "pruvious-server",
                `The field '$field' does not exist`,
                { field: fieldName }
              )
            );
            return false;
          } else if (direction === false) {
            errors.push(
              __(
                event,
                "pruvious-server",
                `The order direction '${direction}' is not valid`,
                { direction }
              )
            );
            return false;
          } else if (collectionDef.fields[fieldName].additional?.protected) {
            errors.push(
              __(
                event,
                "pruvious-server",
                `The field '$field' cannot be queried`,
                { field: fieldName }
              )
            );
            return false;
          }
          return [fieldName, direction === "asc" ? "ASC NULLS LAST" : "DESC NULLS LAST"];
        }
      }).filter(Boolean);
    } else {
      errors.push(
        __(
          event,
          "pruvious-server",
          "At least one field must be included in the 'select' parameter"
        )
      );
    }
  }
  if (isDefined(qs.perPage) && isMultiCollection && operation === "read") {
    const perPage = qs.perPage && isString(qs.perPage) ? +qs.perPage : null;
    if (isPositiveInteger(perPage)) {
      if (isDefined(qs.limit)) {
        errors.push(
          __(
            event,
            "pruvious-server",
            "Using both 'perPage' and 'limit' parameters simultaneously is not permitted"
          )
        );
      } else {
        params.limit = perPage;
      }
    } else {
      errors.push(
        __(
          event,
          "pruvious-server",
          "The 'perPage' parameter must be a positive integer"
        )
      );
    }
  }
  if (isDefined(qs.page) && isMultiCollection && operation === "read") {
    const page = qs.page && isString(qs.page) ? +qs.page : null;
    if (isPositiveInteger(page)) {
      if (isUndefined(qs.perPage) && isUndefined(qs.limit)) {
        errors.push(
          __(
            event,
            "pruvious-server",
            "The 'page' parameter requires either 'perPage' or 'limit' to be present"
          )
        );
      } else if (isDefined(qs.offset)) {
        errors.push(
          __(
            event,
            "pruvious-server",
            "Using both 'page' and 'offset' parameters simultaneously is not permitted"
          )
        );
      } else if (params.limit) {
        params.offset = (page - 1) * params.limit;
      }
    } else {
      errors.push(
        __(
          event,
          "pruvious-server",
          "The 'page' parameter must be a positive integer"
        )
      );
    }
  }
  if (isDefined(qs.populate)) {
    const populate = booleanishSanitizer({ value: qs.populate });
    if (isBoolean(populate)) {
      params.populate = populate;
    } else {
      errors.push(
        __(
          event,
          "pruvious-server",
          "The 'populate' parameter must be a booleanish value"
        )
      );
    }
  }
  if (isMultiCollection && operation === "read") {
    const search = Object.entries(qs).filter(([key]) => key === "search" || key.startsWith("search:")).map(([key, value]) => [key === "search" ? "default" : key.replace("search:", ""), value]);
    for (const [structure, value] of search) {
      const structures = collectionDef.search;
      if (structures) {
        if (structures[structure]) {
          const keywordsInput = isArray(value) ? value.join(" ") : isString(value) || isRealNumber(value) || isBoolean(value) ? value.toString() : "";
          params.search[structure] = extractKeywords(keywordsInput);
        } else {
          errors.push(
            __(
              event,
              "pruvious-server",
              "The search structure '$structure' does not exist",
              { structure }
            )
          );
        }
      } else {
        errors.push(
          __(
            event,
            "pruvious-server",
            "This collection is not searchable"
          )
        );
      }
    }
  }
  params.select = Object.keys(collectionDef.fields);
  if (isDefined(qs.select)) {
    const select = parseQSArray(qs.select);
    if (select?.length) {
      const filtered = select.filter((fieldName) => {
        if (fieldName === "*") {
          return true;
        } else if (collectionDef.fields[fieldName]) {
          if (collectionDef.fields[fieldName].additional?.protected) {
            errors.push(
              __(
                event,
                "pruvious-server",
                `The field '$field' cannot be queried`,
                { field: fieldName }
              )
            );
            return false;
          } else {
            return true;
          }
        } else {
          errors.push(
            __(
              event,
              "pruvious-server",
              `The field '$field' does not exist`,
              { field: fieldName }
            )
          );
          return false;
        }
      });
      if (!filtered.includes("*")) {
        params.select = filtered;
      }
    } else {
      errors.push(
        __(
          event,
          "pruvious-server",
          "At least one field must be included in the 'select' parameter"
        )
      );
    }
    if (!params.select.length) {
      params.select = ["id"];
    }
  }
  if (isDefined(qs.where) && isMultiCollection && operation !== "create") {
    if (qs.where && (isString(qs.where) || isArray(qs.where))) {
      params.where = parseWhere(qs.where, collectionDef, errors, options, event.context.language);
    } else {
      errors.push(
        __(
          event,
          "pruvious-server",
          "The 'where' parameter is not valid"
        )
      );
    }
  }
  return { params, errors: uniqueArray(errors) };
}
function resolveOrderDirection(value) {
  const v = value.toLowerCase();
  const a = ["a", "asc", "ascending", "u", "up"];
  const d = ["d", "desc", "descending", "down"];
  return a.includes(v) ? "asc" : d.includes(v) ? "desc" : false;
}
function parseWhere(value, collection, errors, options, contextLanguage) {
  const stringValue = isString(value) ? value : value.join(",");
  const tokens = parseWhereTokens([...tokenize(stringValue.split(""))]);
  const where = parseWhereFilters(tokens, collection, errors, options, contextLanguage);
  return { [Op.and]: where };
}
function parseWhereFilters(tokens, collection, errors, options, contextLanguage) {
  const filters = [];
  let token;
  let fieldName;
  let operator;
  let operatorString;
  let expectedValueType;
  let value;
  while (token = tokens.shift()) {
    let clear = false;
    if (isString(token) && token[0] === "," && !fieldName) {
      token = token.slice(1);
    }
    if (isArray(token) && !fieldName || token === "some:" || token === "every:") {
      const rel = token === "some:" ? Op.or : Op.and;
      if (isString(token)) {
        token = tokens.shift();
      }
      if (isArray(token)) {
        filters.push({ [rel]: parseWhereFilters(token, collection, errors, options, contextLanguage) });
      } else {
        errors.push(
          __(
            contextLanguage,
            "pruvious-server",
            "The 'where' parameter is not valid"
          )
        );
      }
    } else if (isString(token) && !fieldName && !operator && !value) {
      if (collection.fields[token]) {
        if (collection.fields[token].additional?.protected) {
          errors.push(
            __(
              contextLanguage,
              "pruvious-server",
              "The field '$field' cannot be queried",
              { field: token }
            )
          );
          tokens.splice(0, 2);
        } else {
          fieldName = token;
        }
      } else {
        errors.push(
          __(
            contextLanguage,
            "pruvious-server",
            `The field '$field' does not exist`,
            { field: token }
          )
        );
        tokens.splice(0, 2);
      }
    } else if (isArray(token) && fieldName && !operator && !value) {
      if (isString(token[0])) {
        operatorString = token[0];
        const o = operatorString.toLowerCase();
        const type = dbToJsType(fields[collection.fields[fieldName].type]?.type.db);
        let incompatible = false;
        if (o === "=" || o === "eq") {
          operator = Op.eq;
        } else if (o === "!=" || o === "ne") {
          operator = Op.ne;
        } else if (o === ">" || o === "gt") {
          if (type === "string" || type === "number") {
            operator = Op.gt;
            expectedValueType = "numberOrString";
          } else {
            incompatible = true;
          }
        } else if (o === ">=" || o === "gte") {
          if (type === "string" || type === "number") {
            operator = Op.gte;
            expectedValueType = "numberOrString";
          } else {
            incompatible = true;
          }
        } else if (o === "<" || o === "lt") {
          if (type === "string" || type === "number") {
            operator = Op.lt;
            expectedValueType = "numberOrString";
          } else {
            incompatible = true;
          }
        } else if (o === "<=" || o === "lte") {
          if (type === "string" || type === "number") {
            operator = Op.lte;
            expectedValueType = "numberOrString";
          } else {
            incompatible = true;
          }
        } else if (o === "between") {
          if (type === "string" || type === "number") {
            operator = Op.between;
            expectedValueType = "numberOrStringTuple";
          } else {
            incompatible = true;
          }
        } else if (o === "notbetween") {
          if (type === "string" || type === "number") {
            operator = Op.notBetween;
            expectedValueType = "numberOrStringTuple";
          } else {
            incompatible = true;
          }
        } else if (o === "in") {
          operator = Op.in;
          expectedValueType = "array";
        } else if (o === "notin") {
          operator = Op.notIn;
          expectedValueType = "array";
        } else if (o === "like") {
          operator = Op.like;
          expectedValueType = "string";
        } else if (o === "notlike") {
          operator = Op.notLike;
          expectedValueType = "string";
        } else if (o === "ilike") {
          operator = getDatabaseDialect() === "postgres" ? Op.iLike : Op.like;
          expectedValueType = "string";
        } else if (o === "notilike") {
          operator = getDatabaseDialect() === "postgres" ? Op.notILike : Op.notLike;
          expectedValueType = "string";
        } else {
          errors.push(
            __(
              contextLanguage,
              "pruvious-server",
              "The operator '$operator' is not valid",
              { operator: operatorString }
            )
          );
          tokens.splice(0, 1);
          clear = true;
        }
        if (incompatible) {
          errors.push(
            __(
              contextLanguage,
              "pruvious-server",
              "Cannot use operator '$operator' on field $field",
              { operator: operatorString, field: fieldName }
            )
          );
          tokens.splice(0, 1);
          clear = true;
        }
      } else {
        errors.push(
          __(
            contextLanguage,
            "pruvious-server",
            "The 'where' parameter is not valid"
          )
        );
        tokens.splice(0, 1);
        clear = true;
      }
    } else if (isArray(token) && fieldName && operator && !value) {
      const type = dbToJsType(fields[collection.fields[fieldName].type]?.type.db);
      const tokenValue = token[0] ?? "";
      let incompatible = !isString(tokenValue);
      if (!incompatible) {
        if (expectedValueType === "array") {
          const array = parseQSArray(tokenValue);
          if (array) {
            if (type === "boolean") {
              value = array.map((el) => {
                const casted = booleanishSanitizer({ value: el });
                if (!isBoolean(casted)) incompatible = true;
                return casted;
              });
            } else if (type === "number") {
              value = array.map((el) => {
                const casted = numericSanitizer({ value: el });
                if (!isRealNumber(casted)) incompatible = true;
                return casted;
              });
            } else {
              value = array;
            }
          } else {
            incompatible = true;
          }
        } else if (expectedValueType === "numberOrString") {
          if (type === "number") {
            value = numericSanitizer({ value: tokenValue });
            incompatible = !isRealNumber(value);
          } else {
            value = tokenValue;
          }
        } else if (expectedValueType === "numberOrStringTuple") {
          const array = parseQSArray(tokenValue);
          if (array?.length === 2) {
            if (type === "number") {
              value = array.map((el) => {
                const casted = numericSanitizer({ value: el });
                if (!isRealNumber(casted)) incompatible = true;
                return casted;
              });
            } else {
              value = array;
            }
          } else {
            incompatible = true;
          }
        } else if (expectedValueType === "string") {
          if (type === "string") {
            value = tokenValue;
          } else {
            incompatible = true;
          }
        } else if (tokenValue.toLowerCase() === "null") {
          value = null;
        } else if (type === "boolean") {
          value = booleanishSanitizer({ value: tokenValue });
          incompatible = !isBoolean(value);
        } else if (type === "number") {
          value = numericSanitizer({ value: tokenValue });
          incompatible = !isRealNumber(value);
        } else {
          value = tokenValue;
        }
      }
      if (incompatible) {
        errors.push(
          __(
            contextLanguage,
            "pruvious-server",
            "Cannot use value '$value' for operation '$operation' on field '$field'",
            { value: tokenValue, operation: operatorString, field: fieldName }
          )
        );
      } else {
        filters.push({ [fieldName]: { [operator]: value } });
      }
      clear = true;
    } else {
      errors.push(
        __(
          contextLanguage,
          "pruvious-server",
          "The 'where' parameter is not valid"
        )
      );
      clear = true;
    }
    if (clear) {
      fieldName = void 0;
      operator = void 0;
      operatorString = void 0;
      expectedValueType = void 0;
      value = void 0;
    }
  }
  if (fieldName) {
    errors.push(
      __(
        contextLanguage,
        "pruvious-server",
        "The 'where' parameter is not valid"
      )
    );
  }
  return filters;
}

async function readInputData(event, collection, options) {
  let operation = options?.operation;
  if (!operation) {
    switch (event.method) {
      case "POST":
        operation = "create";
        break;
      case "PATCH":
        operation = "update";
        break;
      default:
        throw new Error(__(event, "pruvious-server", "Unable to determine the request operation"));
    }
  }
  const body = options?.body ?? await pruviousReadBody(event);
  const data = isArray(body) ? [...body] : isObject(body) ? { ...body } : body;
  const errors = [];
  if (operation === "create") {
    if (isArray(data) && data.every(isObject) || isObject(data)) {
      for (const entry of toArray(data)) {
        for (const fieldName of Object.keys(entry)) {
          if (!collections[collection].fields[fieldName] && (fieldName !== "$file" || !getModuleOption("uploads") || collection !== "uploads")) {
            delete entry[fieldName];
            errors.push(
              __(
                event,
                "pruvious-server",
                "The field '$field' does not exist",
                { field: fieldName }
              )
            );
          }
        }
      }
    } else {
      errors.push(
        __(
          event,
          "pruvious-server",
          "The request body must be either an object with key-value pairs or an array containing key-value objects"
        )
      );
    }
  } else if (operation === "update") {
    if (isObject(data)) {
      for (const fieldName of Object.keys(data)) {
        if (!collections[collection].fields[fieldName]) {
          delete data[fieldName];
          errors.push(
            __(
              event,
              "pruvious-server",
              "The field '$field' does not exist",
              { field: fieldName }
            )
          );
        }
      }
    } else {
      errors.push(
        __(
          event,
          "pruvious-server",
          "The request body must be an object with key-value pairs"
        )
      );
    }
  }
  return { data, errors: uniqueArray(errors) };
}
async function pruviousReadBody(event) {
  const contentType = getHeader(event, "Content-Type") || "";
  if (contentType === "application/json" || contentType.startsWith("application/x-www-form-urlencoded") || contentType.startsWith("text/")) {
    const body = await readBody(event);
    return isObject(body) || isArray(body) ? body : {};
  }
  try {
    const formData = await readFormData(event);
    const body = {};
    formData.forEach((value, key) => {
      if (!Reflect.has(body, key)) {
        body[key] = value;
        return;
      }
      if (!Array.isArray(body[key])) {
        body[key] = [body[key]];
      }
      body[key].push(value);
    });
    return body;
  } catch {
  }
  return {};
}

async function seo(collection, page, event) {
  const qs = getQuery(event);
  const seo2 = await query("seo").language(page.language).populate().read();
  const pp = collection.publicPages;
  const pagePath = page[pp.pathField ?? "path"];
  const pagePublic = pp.publicField ? page[pp.publicField] : true;
  const pageDraftToken = pp.draftTokenField ? page[pp.draftTokenField] : "";
  const pageTitle = pp.seo?.titleField ? page[pp.seo.titleField] : "";
  const pageBaseTitle = pp.seo?.baseTitleField ? page[pp.seo.baseTitleField] : "";
  const pageDescription = pp.seo?.descriptionField ? page[pp.seo.descriptionField] : "";
  const pageVisible = pp.seo?.visibleField ? page[pp.seo.visibleField] : true;
  const pageSharingImage = pp.seo?.sharingImageField ? page[pp.seo.sharingImageField] : null;
  const pageMetaTags = pp.seo?.metaTagsField ? page[pp.seo.metaTagsField] : [];
  const prefixPrimaryLanguage = getModuleOption("language").prefixPrimary;
  const pathPrefix = Object.fromEntries(
    supportedLanguages.map((code) => [
      code,
      resolveCollectionPathPrefix(collection, code, primaryLanguage)
    ])
  );
  const htmlAttrs = {};
  const meta = [];
  const link = [];
  const script = [];
  let title = pageTitle || pagePath?.slice(1) || "";
  if (qs.__p) {
    title = pageTitle ? `(${__(event, "pruvious-server", "PREVIEW")}) ${pageTitle}` : __(event, "pruvious-server", "PREVIEW");
  } else if (!pagePublic && pageDraftToken) {
    title = pageTitle ? `(${__(event, "pruvious-server", "DRAFT")}) ${title}` : __(event, "pruvious-server", "DRAFT");
  }
  if (pageBaseTitle && seo2.baseTitle) {
    title = seo2.baseTitlePosition === "before" ? seo2.baseTitle + seo2.titleSeparator + title : title + seo2.titleSeparator + seo2.baseTitle;
  }
  if (!seo2.visible || !pagePublic || !pageVisible) {
    meta.push({ name: "robots", content: "noindex, nofollow" });
  }
  htmlAttrs.lang = page.language;
  if (page.translations && pagePath) {
    const translations = {};
    for (const [language, id] of Object.entries(page.translations ?? {}).filter(([_, id2]) => id2)) {
      const q = query(collection.name).where("id", id);
      if (pp.publicField) {
        q.where(pp.publicField, true);
      }
      const path = (await q.first())?.[pp.pathField ?? "path"];
      if (path) {
        translations[language] = seo2.baseUrl + joinRouteParts(
          language === primaryLanguage && !prefixPrimaryLanguage ? "" : language,
          pathPrefix[language],
          path
        );
      }
    }
    for (const language of supportedLanguages) {
      if (language === page.language) {
        link.push({
          rel: "alternate",
          hreflang: language,
          href: seo2.baseUrl + joinRouteParts(
            language === primaryLanguage && !prefixPrimaryLanguage ? "" : language,
            pathPrefix[language],
            pagePath
          )
        });
      } else if (translations[language]) {
        link.push({ rel: "alternate", hreflang: language, href: translations[language] });
      }
    }
    link.push({
      rel: "alternate",
      hreflang: "x-default",
      href: page.language === primaryLanguage ? seo2.baseUrl + joinRouteParts(prefixPrimaryLanguage ? primaryLanguage : "", pathPrefix[page.language], pagePath) : translations[primaryLanguage] ?? seo2.baseUrl + joinRouteParts(page.language, pathPrefix[page.language], pagePath)
    });
  }
  if (seo2.favicon) {
    link.push({
      rel: "icon",
      type: "image/svg+xml",
      href: seo2.favicon.src.startsWith("http") ? seo2.favicon.src : seo2.baseUrl + seo2.favicon.src
    });
    if (seo2.favicon.sources[0]) {
      link.push({
        rel: "icon",
        type: "image/png",
        href: seo2.favicon.sources[0].srcset.startsWith("http") ? seo2.favicon.sources[0].srcset : seo2.baseUrl + seo2.favicon.sources[0].srcset
      });
    }
  }
  let sharingImage = pageSharingImage || seo2.sharingImage;
  if (sharingImage?.sources[0]) {
    const content = sharingImage.sources[0].srcset.startsWith("http") ? sharingImage.sources[0].srcset : seo2.baseUrl + sharingImage.sources[0].srcset;
    meta.push({ property: "og:image", content });
    meta.push({ property: "twitter:image", content });
  }
  if (seo2.logo) {
    script.push({
      tagPosition: "head",
      type: "application/ld+json",
      innerHTML: `{"@context":"https://schema.org","@type":"Organization","url":"${seo2.baseUrl}/","logo":"${seo2.logo.src.startsWith("http") ? seo2.logo.src : seo2.baseUrl + seo2.logo.src}"}`
    });
  }
  if (seo2.socialMediaMeta) {
    if (seo2.baseTitle) {
      meta.push({ property: "og:site_name", content: seo2.baseTitle });
    }
    meta.push({ property: "og:locale", content: page.language });
    meta.push({ property: "og:title", content: title });
    if (pageDescription) {
      meta.push({ property: "og:description", content: pageDescription });
    }
    meta.push({ property: "og:url", content: seo2.baseUrl + pagePath });
    meta.push({ property: "twitter:title", content: title });
    if (pageDescription) {
      meta.push({ property: "twitter:description", content: pageDescription });
    }
    meta.push({ property: "og:type", content: "website" });
    meta.push({ property: "twitter:card", content: "summary_large_image" });
  }
  if (pageDescription) {
    meta.push({ name: "description", content: pageDescription });
  }
  for (const { name, content } of seo2.metaTags) {
    meta.push(name.startsWith("og:") || name.startsWith("twitter:") ? { property: name, content } : { name, content });
  }
  for (const { name, content } of pageMetaTags) {
    if (name.startsWith("og:") || name.startsWith("twitter:")) {
      if (!meta.some((tag) => tag.property === name)) {
        meta.push({ property: name, content });
      }
    } else {
      if (!meta.some((tag) => tag.name === name)) {
        meta.push({ name, content });
      }
    }
  }
  for (const { js, kind, position, url } of seo2.scripts) {
    const item = { tagPosition: position ?? void 0 };
    if (kind === "external") {
      item.src = url;
    } else {
      item.innerHTML = js;
    }
    script.push(item);
  }
  return {
    props: { title, description: pageDescription ?? "", htmlAttrs, meta, link, script },
    settings: seo2
  };
}

async function applyHooksBeforeCreate(collection, context) {
  await applyHooks(collection, "beforeCreate", context);
}
async function applyHooksAfterCreate(collection, context) {
  await applyHooks(collection, "afterCreate", context);
}
async function applyHooksBeforeRead(collection, context) {
  await applyHooks(collection, "beforeRead", context);
}
async function applyHooksAfterRead(collection, context) {
  await applyHooks(collection, "afterRead", context);
}
async function applyHooksBeforeUpdate(collection, context) {
  await applyHooks(collection, "beforeUpdate", context);
}
async function applyHooksAfterUpdate(collection, context) {
  await applyHooks(collection, "afterUpdate", context);
}
async function applyHooksBeforeDelete(collection, context) {
  await applyHooks(collection, "beforeDelete", context);
}
async function applyHooksAfterDelete(collection, context) {
  await applyHooks(collection, "afterDelete", context);
}
async function applyHooksBeforeReturnRecord(collection, context) {
  await applyHooks(collection, "beforeReturnRecord", context);
}
async function applyHooks(collection, action, context) {
  if (hooks[collection] && hooks[collection][action]) {
    for (const { callback } of hooks[collection][action]) {
      await callback(context);
    }
  }
}

const redirects = {};
function clearRedirects() {
  clearObject(redirects);
}

const hookDefinition1 = defineHook("redirects", "afterUpdate", () => {
  clearRedirects();
});

let jobQueueProcessingInitialized = false;
function initJobQueueProcessing(runtimeConfig) {
  if (!jobQueueProcessingInitialized) {
    if (runtimeConfig.pruvious.jobs) {
      processJobQueue();
      intervals.push(setInterval(() => processJobQueue(), runtimeConfig.pruvious.jobs.searchInterval * 1e3));
      for (const definition of Object.values(jobs)) {
        if (definition.interval !== false) {
          processJob(definition.name);
          intervals.push(setInterval(() => processJob(definition.name), definition.interval * 1e3));
        }
      }
    }
    jobQueueProcessingInitialized = true;
  }
}
async function processJob(name, ...args) {
  const apiOptions = getModuleOption("api");
  const job = await queueJob(name, ...args);
  if (apiOptions.routes["process-job.post"]) {
    const token = jwt.sign({ jti: job.jti }, getModuleOption("jwt").secretKey, { expiresIn: "1 minute" });
    return $fetch(joinRouteParts(apiOptions.prefix, apiOptions.routes["process-job.post"]), {
      method: "post",
      headers: { Authorization: `Bearer ${token}` }
    }).catch((error) => ({
      success: false,
      duration: 0,
      processedAt: Date.now(),
      error: isObject(error.data) && error.data.message ? error.data.message : error.data
    }));
  }
  return { success: false, duration: 0, processedAt: Date.now(), error: "Job processing route is disabled" };
}
async function processJobQueue() {
  const database = await db();
  const job = await database.model("_jobs").findOne({
    order: [
      ["priority", "DESC"],
      ["created_at", "ASC"]
    ]
  });
  if (job) {
    const apiOptions = getModuleOption("api");
    if (apiOptions.routes["process-job.post"]) {
      const jti = nanoid();
      const token = jwt.sign({ jti }, getModuleOption("jwt").secretKey, { expiresIn: "1 minute" });
      await database.model("_jobs").update({ jti }, { where: { id: job.id } });
      await $fetch(joinRouteParts(apiOptions.prefix, apiOptions.routes["process-job.post"]), {
        method: "post",
        headers: { Authorization: `Bearer ${token}` }
      }).catch((error) => {
        return {
          success: false,
          duration: 0,
          processedAt: Date.now(),
          error: isObject(error.data) && error.data.message ? error.data.message : error.data
        };
      });
    }
    await processJobQueue();
  }
}
async function queueJob(name, ...args) {
  const database = await db();
  const jti = nanoid();
  const createdAt = Date.now();
  const entry = await database.model("_jobs").create({ name, args: JSON.stringify(args), jti, priority: jobs[name].priority, created_at: createdAt });
  return { id: entry.id, name, args, jti, priority: jobs[name].priority, createdAt };
}

const cleanExpiredPreviewsJobDefinition = defineJob({
  name: "clean-expired-previews",
  callback: async () => {
    const { query } = await Promise.resolve().then(function () { return server$1; });
    await query("previews").whereLt("updatedAt", Date.now() - 1e3 * 60 * 60 * 24).delete();
  },
  interval: 1800
});

const cleanExpiredTokensJobDefinition = defineJob({
  name: "clean-expired-tokens",
  callback: async () => Promise.resolve().then(function () { return auth; }).then(({ cleanExpiredTokens }) => cleanExpiredTokens()),
  interval: 1800
});

const publishPagesJobDefinition = defineJob({
  name: "publish-pages",
  callback: async () => {
    const { query } = await Promise.resolve().then(function () { return server$1; });
    const { collections } = await Promise.resolve().then(function () { return collections$1; });
    for (const c of Object.values(collections)) {
      if (c.publicPages && c.publicPages.publishDateField && c.publicPages.publicField) {
        await query(c.name).where(c.publicPages.publicField, false).whereLte(c.publicPages.publishDateField, Date.now()).update({ [c.publicPages.publicField]: true });
      }
    }
  },
  interval: 60
});

const translatableStrings = {
  "pruvious-dashboard": {
    "en": pruviousDashboard_en_translatableStringsDefinition
  },
  "pruvious-server": {
    "en": pruviousServer_en_translatableStringsDefinition
  },
  "default": {}
};
const fields = {
  "block": blockFieldDefinition,
  "button-group": buttonGroupFieldDefinition,
  "checkbox": checkboxFieldDefinition,
  "checkboxes": checkboxesFieldDefinition,
  "chips": chipsFieldDefinition,
  "date-range": dateRangeFieldDefinition,
  "date-time-range": dateTimeRangeFieldDefinition,
  "date-time": dateTimeFieldDefinition,
  "date": dateFieldDefinition,
  "editor": editorFieldDefinition,
  "file": fileFieldDefinition,
  "icon": iconFieldDefinition,
  "image": imageFieldDefinition,
  "link": linkFieldDefinition,
  "number": numberFieldDefinition,
  "range": rangeFieldDefinition,
  "record": recordFieldDefinition,
  "records": recordsFieldDefinition,
  "repeater": repeaterFieldDefinition,
  "select": selectFieldDefinition,
  "size": sizeFieldDefinition,
  "slider-range": sliderRangeFieldDefinition,
  "slider": sliderFieldDefinition,
  "switch": switchFieldDefinition,
  "text-area": textAreaFieldDefinition,
  "text": textFieldDefinition,
  "time-range": timeRangeFieldDefinition,
  "time": timeFieldDefinition
};
const hooks = {
  "redirects": {
    afterUpdate: [hookDefinition1]
  }
};
const jobs = {
  "clean-expired-previews": cleanExpiredPreviewsJobDefinition,
  "clean-expired-tokens": cleanExpiredTokensJobDefinition,
  "publish-pages": publishPagesJobDefinition
};
const dashboardPages = {};

const server$1 = /*#__PURE__*/Object.freeze(/*#__PURE__*/Object.defineProperty({
  __proto__: null,
  _: _,
  __: __,
  applyHooksAfterCreate: applyHooksAfterCreate,
  applyHooksAfterDelete: applyHooksAfterDelete,
  applyHooksAfterRead: applyHooksAfterRead,
  applyHooksAfterUpdate: applyHooksAfterUpdate,
  applyHooksBeforeCreate: applyHooksBeforeCreate,
  applyHooksBeforeDelete: applyHooksBeforeDelete,
  applyHooksBeforeRead: applyHooksBeforeRead,
  applyHooksBeforeReturnRecord: applyHooksBeforeReturnRecord,
  applyHooksBeforeUpdate: applyHooksBeforeUpdate,
  arrayValidator: arrayValidator,
  blockFieldDefinition: blockFieldDefinition,
  booleanValidator: booleanValidator,
  booleanishSanitizer: booleanishSanitizer,
  buttonGroupFieldDefinition: buttonGroupFieldDefinition,
  cache: cache,
  cacheModuleOptions: cacheModuleOptions,
  checkboxFieldDefinition: checkboxFieldDefinition,
  checkboxesFieldDefinition: checkboxesFieldDefinition,
  chipsFieldDefinition: chipsFieldDefinition,
  cleanExpiredPreviewsJobDefinition: cleanExpiredPreviewsJobDefinition,
  cleanExpiredTokens: cleanExpiredTokens,
  cleanExpiredTokensJobDefinition: cleanExpiredTokensJobDefinition,
  clearPageCache: clearPageCache,
  collections: collections,
  dashboardPages: dashboardPages,
  dateFieldDefinition: dateFieldDefinition,
  dateRangeFieldDefinition: dateRangeFieldDefinition,
  dateTimeFieldDefinition: dateTimeFieldDefinition,
  dateTimeRangeFieldDefinition: dateTimeRangeFieldDefinition,
  db: db,
  defaultSanitizer: defaultSanitizer,
  defaultSingleQueryStringParams: defaultSingleQueryStringParams,
  editorFieldDefinition: editorFieldDefinition,
  emailValidator: emailValidator,
  fetchSubsetRecords: fetchSubsetRecords,
  fetchToken: fetchToken,
  fields: fields,
  fileFieldDefinition: fileFieldDefinition,
  formSubmissionsCollectionDefinition: formSubmissionsCollectionDefinition,
  formsCollectionDefinition: formsCollectionDefinition,
  generateToken: generateToken,
  getBearerToken: getBearerToken,
  getModuleOption: getModuleOption,
  getOptimizedImage: getOptimizedImage,
  getQueryStringParams: getQueryStringParams,
  hookDefinition1: hookDefinition1,
  hooks: hooks,
  iconFieldDefinition: iconFieldDefinition,
  imageFieldDefinition: imageFieldDefinition,
  integerOrNullValidator: integerOrNullValidator,
  jobs: jobs,
  linkFieldDefinition: linkFieldDefinition,
  lowercaseValidator: lowercaseValidator,
  newsCollectionDefinition: newsCollectionDefinition,
  numberFieldDefinition: numberFieldDefinition,
  numberValidator: numberValidator,
  numericSanitizer: numericSanitizer,
  pagesCollectionDefinition: pagesCollectionDefinition,
  positiveIntegerOrNullValidator: positiveIntegerOrNullValidator,
  presetsCollectionDefinition: presetsCollectionDefinition,
  previewsCollectionDefinition: previewsCollectionDefinition,
  processJob: processJob,
  processJobQueue: processJobQueue,
  pruviousDashboard_en_translatableStringsDefinition: pruviousDashboard_en_translatableStringsDefinition,
  pruviousReadBody: pruviousReadBody,
  pruviousServer_en_translatableStringsDefinition: pruviousServer_en_translatableStringsDefinition,
  publishPagesJobDefinition: publishPagesJobDefinition,
  query: query,
  queueJob: queueJob,
  rangeFieldDefinition: rangeFieldDefinition,
  readInputData: readInputData,
  recordFieldDefinition: recordFieldDefinition,
  recordsFieldDefinition: recordsFieldDefinition,
  redirectsCollectionDefinition: redirectsCollectionDefinition,
  removeToken: removeToken,
  removeUserTokens: removeUserTokens,
  repeaterFieldDefinition: repeaterFieldDefinition,
  requiredValidator: requiredValidator,
  resolveCollectionFieldOptions: resolveCollectionFieldOptions,
  resolveFieldOptions: resolveFieldOptions,
  rolesCollectionDefinition: rolesCollectionDefinition,
  s3Client: s3Client,
  s3DeleteObject: s3DeleteObject,
  s3GetObject: s3GetObject,
  s3MoveObject: s3MoveObject,
  s3PutObject: s3PutObject,
  selectFieldDefinition: selectFieldDefinition,
  seo: seo,
  seoCollectionDefinition: seoCollectionDefinition,
  serverCollectionDefinition: serverCollectionDefinition,
  settingsCollectionDefinition: settingsCollectionDefinition,
  sizeFieldDefinition: sizeFieldDefinition,
  sliderFieldDefinition: sliderFieldDefinition,
  sliderRangeFieldDefinition: sliderRangeFieldDefinition,
  storeToken: storeToken,
  stringOrNullValidator: stringOrNullValidator,
  stringSanitizer: stringSanitizer,
  stringValidator: stringValidator,
  switchFieldDefinition: switchFieldDefinition,
  textAreaFieldDefinition: textAreaFieldDefinition,
  textFieldDefinition: textFieldDefinition,
  timeFieldDefinition: timeFieldDefinition,
  timeRangeFieldDefinition: timeRangeFieldDefinition,
  translatableStrings: translatableStrings,
  uniqueArraySanitizer: uniqueArraySanitizer,
  uniqueValidator: uniqueValidator,
  uploadsCollectionDefinition: uploadsCollectionDefinition,
  usersCollectionDefinition: usersCollectionDefinition,
  verifyToken: verifyToken,
  walkBlocks: walkBlocks
}, Symbol.toStringTag, { value: 'Module' }));

const sendEmail = async (params) => {
  const config = await query("server").read();
  if (!config.smtpEnabled) {
    throw new Error("SMTP is not enabled");
  }
  const transporter = createTransport({
    host: config.smtpHost,
    port: config.smtpPort,
    secure: config.smtpSecure,
    auth: {
      user: config.smtpUser,
      pass: config.smtpPassword
    }
  });
  await transporter.sendMail({
    from: params.from || config.smtpSender,
    to: params.to,
    subject: params.subject,
    text: params.text,
    html: params.html
  });
  transporter.close();
};

const wrapZodError = (error) => {
  var _a;
  const issues = {};
  for (const issue of error.issues) {
    const path = issue.path.join(".");
    const messages = (_a = issues[path]) != null ? _a : issues[path] = [];
    messages.push(issue.message);
  }
  return createError$1({
    statusCode: 400,
    statusMessage: "ValidationError",
    message: z.prettifyError(error),
    data: issues
  });
};

const _uwkcliBEStL29nERKZjdMYk21ZoCG1G0WTHmqWe18SI = defineNitroPlugin((nitroApp) => {
  const runtimeConfig = useRuntimeConfig();
  if (g && runtimeConfig.pruvious.pageCache) {
    nitroApp.hooks.hook("request", async (event) => {
      const res = await getCachedResponse(event.path);
      if (res) {
        event.respondWith(
          new Response(res.body, {
            headers: res.headers,
            status: res.status,
            statusText: res.statusText
          })
        );
      }
    });
    nitroApp.hooks.hook("render:html", async (_, { event }) => {
      await prepareCachedResponse(event.path);
    });
    nitroApp.hooks.hook("render:response", async (response, { event }) => {
      if (await getCachedResponse(event.path) === true) {
        await cacheResponse(event.path, response);
      }
    });
  }
});
async function prepareCachedResponse(path) {
  const pageCache = useRuntimeConfig().pruvious.pageCache;
  const hash = require$$1.createHash("sha256").update(path).digest("hex");
  if (pageCache.type === "local") {
    fs.outputFileSync(resolveAppPath(pageCache.path, hash), "true");
  } else if (pageCache.type === "redis") {
    const { cache } = await Promise.resolve().then(function () { return cache$1; });
    await (await cache(true))?.set(`pruvious:page-cache:${hash}`, "true");
  }
}
async function cacheResponse(path, response) {
  const pageCache = useRuntimeConfig().pruvious.pageCache;
  const hash = require$$1.createHash("sha256").update(path).digest("hex");
  if (pageCache.type === "local") {
    fs.outputFileSync(resolveAppPath(pageCache.path, hash), JSON.stringify(response));
  } else if (pageCache.type === "redis") {
    const { cache } = await Promise.resolve().then(function () { return cache$1; });
    await (await cache(true))?.set(`pruvious:page-cache:${hash}`, JSON.stringify(response));
  }
}
async function getCachedResponse(path) {
  const pageCache = useRuntimeConfig().pruvious.pageCache;
  const hash = require$$1.createHash("sha256").update(path).digest("hex");
  if (pageCache.type === "local") {
    const filePath = resolveAppPath(pageCache.path, hash);
    if (fs.existsSync(filePath)) {
      return JSON.parse(fs.readFileSync(filePath, "utf8"));
    }
  } else if (pageCache.type === "redis") {
    const { cache } = await Promise.resolve().then(function () { return cache$1; });
    const value = await (await cache(true))?.get(`pruvious:page-cache:${hash}`);
    if (value) {
      return JSON.parse(value);
    }
  }
  return null;
}
async function clearPageCache() {
  const pageCache = useRuntimeConfig().pruvious.pageCache;
  if (!g || !pageCache) {
    return;
  } else if (pageCache.type === "local") {
    fs.emptyDirSync(resolveAppPath(pageCache.path));
  } else if (pageCache.type === "redis") {
    const { cache } = await Promise.resolve().then(function () { return cache$1; });
    await (await cache(true))?.flushDb();
  }
}

const plugins = [
  _uwkcliBEStL29nERKZjdMYk21ZoCG1G0WTHmqWe18SI
];

const assets = {
  "/favicon.ico": {
    "type": "image/vnd.microsoft.icon",
    "etag": "\"10be-n8egyE9tcb7sKGr/pYCaQ4uWqxI\"",
    "mtime": "2025-07-08T08:45:48.623Z",
    "size": 4286,
    "path": "../public/favicon.ico"
  },
  "/robots.txt": {
    "type": "text/plain; charset=utf-8",
    "etag": "\"1-rcg7GeeTSRscbqD9i0bNnzLlkvw\"",
    "mtime": "2025-07-08T08:45:48.623Z",
    "size": 1,
    "path": "../public/robots.txt"
  },
  "/images/404.jpg": {
    "type": "image/jpeg",
    "etag": "\"17e1-1sc0PDRYSyfa16xbTjoyXiLzaoY\"",
    "mtime": "2025-07-08T08:45:48.623Z",
    "size": 6113,
    "path": "../public/images/404.jpg"
  },
  "/images/error-bg.png": {
    "type": "image/png",
    "etag": "\"12fd4-zk0tUVq5JsH4QkIpWfnSfvyykcQ\"",
    "mtime": "2025-07-08T08:45:48.623Z",
    "size": 77780,
    "path": "../public/images/error-bg.png"
  },
  "/images/logo.svg": {
    "type": "image/svg+xml",
    "etag": "\"582-vRYuBadm6m//zZBE3jHOkGi2ZqI\"",
    "mtime": "2025-07-08T08:45:48.623Z",
    "size": 1410,
    "path": "../public/images/logo.svg"
  },
  "/_nuxt/0j812qV3.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"25a-CIme8WNnZ7ZS4XWu9RMq60E7ChA\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 602,
    "path": "../public/_nuxt/0j812qV3.js"
  },
  "/_nuxt/2u47ePnn.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"14b3-dk5k7vJ/pUVsNOF1AdptTO323iA\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 5299,
    "path": "../public/_nuxt/2u47ePnn.js"
  },
  "/_nuxt/404.Bonl4gVe.jpg": {
    "type": "image/jpeg",
    "etag": "\"17e1-1sc0PDRYSyfa16xbTjoyXiLzaoY\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 6113,
    "path": "../public/_nuxt/404.Bonl4gVe.jpg"
  },
  "/_nuxt/6lklSynB.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"3c6-5sbv/O1mmvr6p7WL+aVn6w9CK2o\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 966,
    "path": "../public/_nuxt/6lklSynB.js"
  },
  "/_nuxt/6s-gdDQI.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"8be-e8HGBionOS4hovf0QyawT9GbPfA\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 2238,
    "path": "../public/_nuxt/6s-gdDQI.js"
  },
  "/_nuxt/7EQrqa6V.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"120-Sls4HRAOL5aPuydvGhyu0zZ9TnY\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 288,
    "path": "../public/_nuxt/7EQrqa6V.js"
  },
  "/_nuxt/8sLieyHp.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"3d3-pEUqCrgzOW04g8hLWtZfF0c5zjs\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 979,
    "path": "../public/_nuxt/8sLieyHp.js"
  },
  "/_nuxt/AddBlockPopup.CJd1Eiim.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"5e-BdrvjhbnLZf/rtJev4K/Y3cMv3Y\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 94,
    "path": "../public/_nuxt/AddBlockPopup.CJd1Eiim.css"
  },
  "/_nuxt/B-Sa1dkR.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"39c-Rq8bkRmodVolsn+skdcKAabWJQo\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 924,
    "path": "../public/_nuxt/B-Sa1dkR.js"
  },
  "/_nuxt/B-pdF9F4.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"44d-0cMJV9Z73BCPdLJdIQB2Gpl6djQ\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 1101,
    "path": "../public/_nuxt/B-pdF9F4.js"
  },
  "/_nuxt/B07Lm0eO.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"15fe-1WvPcZNR7TgVmweJClPaGiF6kDE\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 5630,
    "path": "../public/_nuxt/B07Lm0eO.js"
  },
  "/_nuxt/B0Xn3SiV.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"134f-SiMZQuTAhLeYds/3XMlYoAgfMdw\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 4943,
    "path": "../public/_nuxt/B0Xn3SiV.js"
  },
  "/_nuxt/B0aSADwZ.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"fdb-8JTGMd7dHzWNhEd/2ZZpbNrvLXk\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 4059,
    "path": "../public/_nuxt/B0aSADwZ.js"
  },
  "/_nuxt/B1mbHm3Y.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"586-eJy5/hH44Am8V8l105xqjhwtg7I\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 1414,
    "path": "../public/_nuxt/B1mbHm3Y.js"
  },
  "/_nuxt/B2ONCMKF.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"52f-sStrrhLLGC73VaX2nFf3PhbUjyI\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 1327,
    "path": "../public/_nuxt/B2ONCMKF.js"
  },
  "/_nuxt/B4qObx7S.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"182-kfDKdIC/adFT8u/0/KCPbqZ0uuU\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 386,
    "path": "../public/_nuxt/B4qObx7S.js"
  },
  "/_nuxt/B5fSYQ8U.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"237-LriRmyf3zLfcqLl/4b8rSezumEU\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 567,
    "path": "../public/_nuxt/B5fSYQ8U.js"
  },
  "/_nuxt/B5mEZtru.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"28b-ZXsllKoZBumapVHyz8/eooM7DbY\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 651,
    "path": "../public/_nuxt/B5mEZtru.js"
  },
  "/_nuxt/B7ss0NYL.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"687-T8TZMR+bX5Ydu6vYV57tEXgPBLQ\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 1671,
    "path": "../public/_nuxt/B7ss0NYL.js"
  },
  "/_nuxt/B9AQ2_FD.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"f6-I/Gm+rIJ4owW0teE5MZ3LZ7ZAp4\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 246,
    "path": "../public/_nuxt/B9AQ2_FD.js"
  },
  "/_nuxt/BDCIGi62.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2f5-zyvUiuK6XR3x5GWmUXxJXpyBgZo\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 757,
    "path": "../public/_nuxt/BDCIGi62.js"
  },
  "/_nuxt/BE-EVdUl.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1337-nkE1zhe2HT6qgM2kjYT9PM6/yMw\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 4919,
    "path": "../public/_nuxt/BE-EVdUl.js"
  },
  "/_nuxt/BGCI71ez.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"911-y5vJpyqWhIn7wxdlfGdOKLYUE0s\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 2321,
    "path": "../public/_nuxt/BGCI71ez.js"
  },
  "/_nuxt/BHQMVSNg.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2d2-QXimVCbfbiTdBeDz0eSQ6OTg6mY\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 722,
    "path": "../public/_nuxt/BHQMVSNg.js"
  },
  "/_nuxt/BHyTO5qw.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"262-wGgG12gi/CqHP2kAzwK9GDnTuiQ\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 610,
    "path": "../public/_nuxt/BHyTO5qw.js"
  },
  "/_nuxt/BI8kpJyR.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"49f-ByWYQLuqKADL4nlih0G6oUmgWB8\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 1183,
    "path": "../public/_nuxt/BI8kpJyR.js"
  },
  "/_nuxt/BINyMT8y.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"3b4-1BFGBWr63ACUjnNkpI9JjxNS85E\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 948,
    "path": "../public/_nuxt/BINyMT8y.js"
  },
  "/_nuxt/BIu9pjBS.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1a4b-W6ybN5oHQzSVrpfH36+uYGamw8M\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 6731,
    "path": "../public/_nuxt/BIu9pjBS.js"
  },
  "/_nuxt/BMRkYWGs.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1dd4-37u3GplbC7ULvbeaZapeXSlU9AI\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 7636,
    "path": "../public/_nuxt/BMRkYWGs.js"
  },
  "/_nuxt/BNuftoDA.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2d-5i1FT09RN53250wpmHXwThGGxmQ\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 45,
    "path": "../public/_nuxt/BNuftoDA.js"
  },
  "/_nuxt/BO08bRQL.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"d62-LRI2XcLNhs0RQujiZY2CIudpJ0c\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 3426,
    "path": "../public/_nuxt/BO08bRQL.js"
  },
  "/_nuxt/BO8QmprA.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"16f-2BRxSuYJ1/WvVhU9y7AQs9h4wR0\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 367,
    "path": "../public/_nuxt/BO8QmprA.js"
  },
  "/_nuxt/BOXRx2Ft.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"5f6-gl3YBBkYRBUmfYojxfZ6uHvwxIs\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 1526,
    "path": "../public/_nuxt/BOXRx2Ft.js"
  },
  "/_nuxt/BOtxtbZU.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"e5-cVB7evFBL6J2SaR0ONUFWCkaoSQ\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 229,
    "path": "../public/_nuxt/BOtxtbZU.js"
  },
  "/_nuxt/BPiFl6xJ.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"3e2-t8QKZGc+eIfx/NUdJuuuTL0nYN8\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 994,
    "path": "../public/_nuxt/BPiFl6xJ.js"
  },
  "/_nuxt/BPrH4D0P.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1fb-o0P9pxbGbzkcm8qrj1oB8zewN28\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 507,
    "path": "../public/_nuxt/BPrH4D0P.js"
  },
  "/_nuxt/BQgLraSb.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"6ce-++9nZu8z98kfImhPWQo+E1bfyho\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 1742,
    "path": "../public/_nuxt/BQgLraSb.js"
  },
  "/_nuxt/BRbwqtkX.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1c78-ojjHG+qOtlEwXFnFpbiXFWNcppQ\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 7288,
    "path": "../public/_nuxt/BRbwqtkX.js"
  },
  "/_nuxt/BRiN-uka.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"5511a-dvGb4DTVPbDx/1JowPbz/TM3wQo\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 348442,
    "path": "../public/_nuxt/BRiN-uka.js"
  },
  "/_nuxt/BS1yJvJE.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1f0-mkO+Sq79Uhxk/wSyA50OiRYJLd0\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 496,
    "path": "../public/_nuxt/BS1yJvJE.js"
  },
  "/_nuxt/BSl-Tpsd.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2c3-uyjfkdkxXxDr3yBci+F8exfxkPQ\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 707,
    "path": "../public/_nuxt/BSl-Tpsd.js"
  },
  "/_nuxt/BTQNKhoI.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"423-Yb8a3Ym5c2NTL0Zn6SwzttrDeq8\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 1059,
    "path": "../public/_nuxt/BTQNKhoI.js"
  },
  "/_nuxt/BU5d-wEe.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"11de-IyWzNpwiOSZBD/2p6l4Abt0o/9U\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 4574,
    "path": "../public/_nuxt/BU5d-wEe.js"
  },
  "/_nuxt/BZ3yyO1p.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"946-ZRYdRQETxiaFOSkUhrFZ0wjQsDs\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 2374,
    "path": "../public/_nuxt/BZ3yyO1p.js"
  },
  "/_nuxt/Ba50m2wJ.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1f45d-GxYQP9FSTf0qDdNKki1ibvBxlK0\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 128093,
    "path": "../public/_nuxt/Ba50m2wJ.js"
  },
  "/_nuxt/Bb2L0WMN.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"86-fEl0jkkG5P3S68Ro1LID9xC3kAs\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 134,
    "path": "../public/_nuxt/Bb2L0WMN.js"
  },
  "/_nuxt/BbkYVraq.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"16a-0QmfkRjDZKnPb7Vkr22w8TJcHAs\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 362,
    "path": "../public/_nuxt/BbkYVraq.js"
  },
  "/_nuxt/Bbmw_l5d.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"ce47-2ONCVqRC80dm9bHpm+G1JSUghBo\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 52807,
    "path": "../public/_nuxt/Bbmw_l5d.js"
  },
  "/_nuxt/Bd4Xjmpq.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"11b-a9J89PjB23Iqv4MAkrwPlI6RXXM\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 283,
    "path": "../public/_nuxt/Bd4Xjmpq.js"
  },
  "/_nuxt/Bfl67iDz.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"7c8-VD22VTQeZ0cbwlIvhl9Y2g5wd3E\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 1992,
    "path": "../public/_nuxt/Bfl67iDz.js"
  },
  "/_nuxt/Bgixts8N.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2f6-OtDTw5EzvUIBm6qkMXiIcGY3tfA\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 758,
    "path": "../public/_nuxt/Bgixts8N.js"
  },
  "/_nuxt/Bi0fHTG9.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"7b9-Vj9NeJn0ioSw5wpBkYwzV6SPW2s\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 1977,
    "path": "../public/_nuxt/Bi0fHTG9.js"
  },
  "/_nuxt/BiAMC1oF.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1e9-HNVP5AekzV57lnmeU0kVLysZ7kM\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 489,
    "path": "../public/_nuxt/BiAMC1oF.js"
  },
  "/_nuxt/BkB8TeMQ.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"a60-G17SjqNBIvC0YrCRp0DU5ErMrFg\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 2656,
    "path": "../public/_nuxt/BkB8TeMQ.js"
  },
  "/_nuxt/BmFNV4c9.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1683-CzhuEyUz/5UJGmnwD7mLT3xXbaA\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 5763,
    "path": "../public/_nuxt/BmFNV4c9.js"
  },
  "/_nuxt/BnEn0BTt.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"b6e-t8wiz7Uju55MWHeW143T8Fvxs70\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 2926,
    "path": "../public/_nuxt/BnEn0BTt.js"
  },
  "/_nuxt/BqDtNmC9.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2a6-teNUpUgV1woNrknAxgLNqGcpRB0\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 678,
    "path": "../public/_nuxt/BqDtNmC9.js"
  },
  "/_nuxt/Buy72CXo.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"561-NKrZXzNmv1bzSXogo+vpau4pVLs\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 1377,
    "path": "../public/_nuxt/Buy72CXo.js"
  },
  "/_nuxt/Bv_FtETs.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"9ae-784aKNdp6avTGftqVHs2tmR3kZo\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 2478,
    "path": "../public/_nuxt/Bv_FtETs.js"
  },
  "/_nuxt/BwW2XYHX.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"35d7-0vDgO6ctlP4pQ6CmnWlpR6ibRSg\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 13783,
    "path": "../public/_nuxt/BwW2XYHX.js"
  },
  "/_nuxt/BxXXLvkm.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"f68-Av901E2tadD1LuK6F99Lphb5n+A\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 3944,
    "path": "../public/_nuxt/BxXXLvkm.js"
  },
  "/_nuxt/Bxj4U_sH.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"9b3-jFlwII3VGamXdbBOw67PIjJbSjg\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 2483,
    "path": "../public/_nuxt/Bxj4U_sH.js"
  },
  "/_nuxt/BzyHViX1.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"32a-5sNLI/fq+LLoXzuDk/wOKUyKljw\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 810,
    "path": "../public/_nuxt/BzyHViX1.js"
  },
  "/_nuxt/C1gQg3Bi.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"83f-XL6tzemuiII7ctQYBoMCHAL7SN0\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 2111,
    "path": "../public/_nuxt/C1gQg3Bi.js"
  },
  "/_nuxt/C2UZnXYP.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"798-s7Trq2YtPHI3MQTOU2uu/FzFxNw\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 1944,
    "path": "../public/_nuxt/C2UZnXYP.js"
  },
  "/_nuxt/C48nD7c5.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"4efc-HM2nIwFy7FCYMzNUc/9LT/XzyRU\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 20220,
    "path": "../public/_nuxt/C48nD7c5.js"
  },
  "/_nuxt/C5L4CIhd.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"253-k0rFKXVIxNw/vyuON0+zW4zYv7M\"",
    "mtime": "2025-07-08T08:45:48.599Z",
    "size": 595,
    "path": "../public/_nuxt/C5L4CIhd.js"
  },
  "/_nuxt/C6LYitOb.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"fd9-S9+DZtAQuXy7izWZ4Y/R2U+o5cY\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 4057,
    "path": "../public/_nuxt/C6LYitOb.js"
  },
  "/_nuxt/C6XZWXJ9.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"597-KsLQsMU9Wyies9U9N4J6X8OvcU0\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 1431,
    "path": "../public/_nuxt/C6XZWXJ9.js"
  },
  "/_nuxt/C8BWMs99.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"357-1imP8tI0gokcuQvI5idFg06e7Kg\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 855,
    "path": "../public/_nuxt/C8BWMs99.js"
  },
  "/_nuxt/C9xsX1Fm.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2037-uf2tiSej7bEXVf4yHBzjTSemVDU\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 8247,
    "path": "../public/_nuxt/C9xsX1Fm.js"
  },
  "/_nuxt/CAQINpJd.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2956-LKq/+SowZRZjeMdOD2lFuETSx2Q\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 10582,
    "path": "../public/_nuxt/CAQINpJd.js"
  },
  "/_nuxt/CDcaYtE4.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2de2-VsLWqRM8gs3vP0ZSSxTFGmSHHs0\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 11746,
    "path": "../public/_nuxt/CDcaYtE4.js"
  },
  "/_nuxt/CFv8cHpe.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"14e6-Wo134qUGvg7HtTa5jvTty+QpdM8\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 5350,
    "path": "../public/_nuxt/CFv8cHpe.js"
  },
  "/_nuxt/CLBdYQ6B.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"271-AkNB3diHVcCAS/BV4d1+e2+O/ec\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 625,
    "path": "../public/_nuxt/CLBdYQ6B.js"
  },
  "/_nuxt/CLMlP5vJ.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"a3b-q+EHu6SquDwZtvSmlJwiM8b2/nQ\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 2619,
    "path": "../public/_nuxt/CLMlP5vJ.js"
  },
  "/_nuxt/CLQ_oLGC.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"c639-2mfozR7K7HzAfW8mQZEKJ9IuOqY\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 50745,
    "path": "../public/_nuxt/CLQ_oLGC.js"
  },
  "/_nuxt/CLi1JpbQ.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"937-QVOSuYAKNT6+CSV8jQr9P97RyVo\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 2359,
    "path": "../public/_nuxt/CLi1JpbQ.js"
  },
  "/_nuxt/CMD2f4-h.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"23a-pTLYs348nTXqVbZQNXUGzQKN7Bc\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 570,
    "path": "../public/_nuxt/CMD2f4-h.js"
  },
  "/_nuxt/CNcWmhu9.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"b33-3OBYFLrRfkzU2Ssb00SptK88Kdc\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 2867,
    "path": "../public/_nuxt/CNcWmhu9.js"
  },
  "/_nuxt/CNvYJUlR.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"3e2-mCE5WDtCFBJcZgVKWcJjse2oZA0\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 994,
    "path": "../public/_nuxt/CNvYJUlR.js"
  },
  "/_nuxt/CO1Sol4J.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"21c3-pKEhwSE455RpU2nVWbQYTStTDOE\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 8643,
    "path": "../public/_nuxt/CO1Sol4J.js"
  },
  "/_nuxt/CQhS7mYi.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"10f5-u8kF1aSRLfJ0DeDVw6V5wl+Hf3E\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 4341,
    "path": "../public/_nuxt/CQhS7mYi.js"
  },
  "/_nuxt/CRPHw7Sb.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1e3a-Qn2vrhuGnidtfqkIOND0FHAepIk\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 7738,
    "path": "../public/_nuxt/CRPHw7Sb.js"
  },
  "/_nuxt/CSdUAvxd.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2d6-lcA2k1/dTIRUGt2mKhuqDNyvqV0\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 726,
    "path": "../public/_nuxt/CSdUAvxd.js"
  },
  "/_nuxt/CSz71Ysr.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1ff-M+DGhFNfAiO7fRKUGL1b68rd1jA\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 511,
    "path": "../public/_nuxt/CSz71Ysr.js"
  },
  "/_nuxt/CV-GwUpS.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"ee50-q/zQsi22HMtpqr5LVS8UOZUTK24\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 61008,
    "path": "../public/_nuxt/CV-GwUpS.js"
  },
  "/_nuxt/CVNEra_u.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"d5c-VS7hMfMqtUjkm0gvJv/M43Qpzrw\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 3420,
    "path": "../public/_nuxt/CVNEra_u.js"
  },
  "/_nuxt/CViirZgS.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2c3-CxiIwjSbagZFjhyAUJFiVXb3CgU\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 707,
    "path": "../public/_nuxt/CViirZgS.js"
  },
  "/_nuxt/CZY3blvM.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1ef3-CAgSckYbkEM+K83C8SsrlgnB5Wg\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 7923,
    "path": "../public/_nuxt/CZY3blvM.js"
  },
  "/_nuxt/CaFNA_HT.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"8d9f-EO+FQ147aDvsvA5qBo5+49NcLAg\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 36255,
    "path": "../public/_nuxt/CaFNA_HT.js"
  },
  "/_nuxt/CarouselBlock.IfL7WHD6.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"b6-usSG3Qe0z1nH/kvX0uBD45JBN68\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 182,
    "path": "../public/_nuxt/CarouselBlock.IfL7WHD6.css"
  },
  "/_nuxt/CcRtXUGT.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"3aa-o5Za1bl1auJSeSXZiBBVy2ooKlo\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 938,
    "path": "../public/_nuxt/CcRtXUGT.js"
  },
  "/_nuxt/CdTsbR2I.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"3d-U4mD79HjCndxaqgObz2keT7kRpY\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 61,
    "path": "../public/_nuxt/CdTsbR2I.js"
  },
  "/_nuxt/CdYb7Ctm.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"269-o0OjJWFycsB5ZCiCAftOzGd8bjE\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 617,
    "path": "../public/_nuxt/CdYb7Ctm.js"
  },
  "/_nuxt/CdanjYTt.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2e4-3Rz0haexmLWYMf1IxCuDBLxy86Q\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 740,
    "path": "../public/_nuxt/CdanjYTt.js"
  },
  "/_nuxt/CdbA9xK2.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"677d-QmRfGhuCdgM6l0RIYhmcPDCrGys\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 26493,
    "path": "../public/_nuxt/CdbA9xK2.js"
  },
  "/_nuxt/CfKCLPK5.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"25c0-jwW2LOjrEQl0ms81kdheM2Wi8Vk\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 9664,
    "path": "../public/_nuxt/CfKCLPK5.js"
  },
  "/_nuxt/ChTz5SSF.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2d1-obVGVY7ucwTXpSuuvGTl5Iii/4Y\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 721,
    "path": "../public/_nuxt/ChTz5SSF.js"
  },
  "/_nuxt/CheckboxField.BBeioenF.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"256-AIIPlbtgxx2/Cmgd11D9ApHzcD0\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 598,
    "path": "../public/_nuxt/CheckboxField.BBeioenF.css"
  },
  "/_nuxt/Ci1gU8v1.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"64-gRRSIR5ZIFQSADNuvQe4PCH1Gkg\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 100,
    "path": "../public/_nuxt/Ci1gU8v1.js"
  },
  "/_nuxt/Cjdwtl-P.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"11f2-x1+K8dNpZ07OWJiIPZ6VfqIxGys\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 4594,
    "path": "../public/_nuxt/Cjdwtl-P.js"
  },
  "/_nuxt/CncPp10z.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"636-JeuXntTBjwqq80erxPJ8m874fvU\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 1590,
    "path": "../public/_nuxt/CncPp10z.js"
  },
  "/_nuxt/CnodPudy.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"228-oyBmuQkeH8rTIJlwMQX+O3JFXOc\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 552,
    "path": "../public/_nuxt/CnodPudy.js"
  },
  "/_nuxt/Cp2ysxOb.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"232-ypGMHAr+kqShe72B3+7zA1skqvI\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 562,
    "path": "../public/_nuxt/Cp2ysxOb.js"
  },
  "/_nuxt/Cqnmgheq.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"26f-CWLpwTVtZ5DdhpfdpR4fVAo8e80\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 623,
    "path": "../public/_nuxt/Cqnmgheq.js"
  },
  "/_nuxt/CqtJ8ccR.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"3c6-IW6O96kTi+cnF5OPcH4zCuGk04s\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 966,
    "path": "../public/_nuxt/CqtJ8ccR.js"
  },
  "/_nuxt/CrXZx5SB.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"bb1-SE3iJ2r80mnjP522loV2RxlpROM\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 2993,
    "path": "../public/_nuxt/CrXZx5SB.js"
  },
  "/_nuxt/Cs2YmiIB.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"3e1-bv6Wl787nqIpumhXx+tg/Rpw2Mo\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 993,
    "path": "../public/_nuxt/Cs2YmiIB.js"
  },
  "/_nuxt/Csnhp8LY.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1f2-8D5PP6HtLe+qzUXtFt2PgzrVBBk\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 498,
    "path": "../public/_nuxt/Csnhp8LY.js"
  },
  "/_nuxt/Cu1wGusl.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"92f3-PpK3hyAt6vqiTVJKFyq8uEA7BQc\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 37619,
    "path": "../public/_nuxt/Cu1wGusl.js"
  },
  "/_nuxt/Cuug_i0o.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1002-wnrsY4EFRRYWla9FrZl4mWQUNLI\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 4098,
    "path": "../public/_nuxt/Cuug_i0o.js"
  },
  "/_nuxt/CvnljIL5.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"59f-/UKh+YnbNkHaskRWgtoU+5EFRfM\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 1439,
    "path": "../public/_nuxt/CvnljIL5.js"
  },
  "/_nuxt/CwUdo4Df.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"282-J3zZ0fdxAlvyEDe/h3iWyW4oe5s\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 642,
    "path": "../public/_nuxt/CwUdo4Df.js"
  },
  "/_nuxt/Cx5sYBAy.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2b97-wZKx9stxQlgrThHdyUsr5xv8z2s\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 11159,
    "path": "../public/_nuxt/Cx5sYBAy.js"
  },
  "/_nuxt/CySRKYGw.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"289-fu5C0oNxFB4hE9t+Da8J5syoHac\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 649,
    "path": "../public/_nuxt/CySRKYGw.js"
  },
  "/_nuxt/Cyr8a3I4.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"718-t3HAsPr+sQgveHEorbo0ozvJcEw\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 1816,
    "path": "../public/_nuxt/Cyr8a3I4.js"
  },
  "/_nuxt/D0gbaBiP.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"3c3-853CtDTLDdUUE4R/6dOhNPub75w\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 963,
    "path": "../public/_nuxt/D0gbaBiP.js"
  },
  "/_nuxt/D3WTzFDw.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"5d80-AzT/NzoDSo77/hkz+63sOVWd24o\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 23936,
    "path": "../public/_nuxt/D3WTzFDw.js"
  },
  "/_nuxt/D5eLilQw.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"c65-FWsQ4N5eRstMuFJYZ5sss5oSozM\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 3173,
    "path": "../public/_nuxt/D5eLilQw.js"
  },
  "/_nuxt/D6p5_j0T.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"d2-Z3rct5rinkNOSQPsoOds568K1To\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 210,
    "path": "../public/_nuxt/D6p5_j0T.js"
  },
  "/_nuxt/D7tuDTg5.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"5d2-AR/HEWGraUfmDuyPZ0dQGvSLZ4Y\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 1490,
    "path": "../public/_nuxt/D7tuDTg5.js"
  },
  "/_nuxt/D8ZCImUB.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1fc2-DFsBvMzQ2NzPcXaqaqSCDTRaFCI\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 8130,
    "path": "../public/_nuxt/D8ZCImUB.js"
  },
  "/_nuxt/D92Z9-iy.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"34ec-zGksA3jT2XhlUbcTJbu0cAxTvtE\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 13548,
    "path": "../public/_nuxt/D92Z9-iy.js"
  },
  "/_nuxt/DA0aJN-I.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"227-vUEdlObH7lwdZwD7jh2ErtSuKHI\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 551,
    "path": "../public/_nuxt/DA0aJN-I.js"
  },
  "/_nuxt/DAogsx8J.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"a23-KOxn52xw79tjQjcfn987g9IjWmQ\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 2595,
    "path": "../public/_nuxt/DAogsx8J.js"
  },
  "/_nuxt/DBl-tkfe.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"193-TF1jxfyDzXIaW3tMqTpSoThcHSk\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 403,
    "path": "../public/_nuxt/DBl-tkfe.js"
  },
  "/_nuxt/DCR6IVvy.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"23f-c2YeLBdy1PiyU+giXy2YR7jVWJ8\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 575,
    "path": "../public/_nuxt/DCR6IVvy.js"
  },
  "/_nuxt/DCs0dfl_.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"6740-USX+jnFGflcfdrPG+FrNREKw4I8\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 26432,
    "path": "../public/_nuxt/DCs0dfl_.js"
  },
  "/_nuxt/DFLEAEzU.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1ee-w4UcQybJvRe18oNWqqN6snzdKos\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 494,
    "path": "../public/_nuxt/DFLEAEzU.js"
  },
  "/_nuxt/DGYQWv9R.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"27b6-kNHy3r5/bN1Ml5UUYvfYj3OKsVA\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 10166,
    "path": "../public/_nuxt/DGYQWv9R.js"
  },
  "/_nuxt/DGioaGRV.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"60e-Qil+GdIjMerDKgBMVvvs3eONgZw\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 1550,
    "path": "../public/_nuxt/DGioaGRV.js"
  },
  "/_nuxt/DGn6j-jC.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"415-8QfrRKpe8TofiF0VnmqoPjwK1g8\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 1045,
    "path": "../public/_nuxt/DGn6j-jC.js"
  },
  "/_nuxt/DHNxGU9l.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"273-S2uNPPgKjbmVX0msOh6x/+IMViQ\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 627,
    "path": "../public/_nuxt/DHNxGU9l.js"
  },
  "/_nuxt/DI4EZ0nV.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"b48-7xth6ss2S7lUNR0zfS2Mo1yJpLA\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 2888,
    "path": "../public/_nuxt/DI4EZ0nV.js"
  },
  "/_nuxt/DIELbZi1.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1117-9XG4XxlvNgzQXL15HwZaswWlp2c\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 4375,
    "path": "../public/_nuxt/DIELbZi1.js"
  },
  "/_nuxt/DIF9SkLs.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"9d3-Q+Dj9cSpTU2gh5Xym90+d8qNga8\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 2515,
    "path": "../public/_nuxt/DIF9SkLs.js"
  },
  "/_nuxt/DIN0-E5F.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"c9a-M7g5sb3vmn3hbGb6mRuTQIVGYUs\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 3226,
    "path": "../public/_nuxt/DIN0-E5F.js"
  },
  "/_nuxt/DJ7vsoMd.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2d4-qgzA/O4Qhli0WVTEaJdoAvQoTKk\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 724,
    "path": "../public/_nuxt/DJ7vsoMd.js"
  },
  "/_nuxt/DJjsGmEH.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"132-esNx8v99bEg60T48NxfC1xmdwys\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 306,
    "path": "../public/_nuxt/DJjsGmEH.js"
  },
  "/_nuxt/DM2E4Wm9.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"34d-N0iuUtUUtH0+SFeecJAh70St9PI\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 845,
    "path": "../public/_nuxt/DM2E4Wm9.js"
  },
  "/_nuxt/DMjIuU0E.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"44a-BFiXZhPzLu52CF526bBUnJhRo5A\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 1098,
    "path": "../public/_nuxt/DMjIuU0E.js"
  },
  "/_nuxt/DMzOFXyM.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"13f-SIdaSM8B2HrYynSKfHEeNzW6+vo\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 319,
    "path": "../public/_nuxt/DMzOFXyM.js"
  },
  "/_nuxt/DPHZpQp0.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2d4-xxEi27BOBqTxgXKZDd+OMYk7lFE\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 724,
    "path": "../public/_nuxt/DPHZpQp0.js"
  },
  "/_nuxt/DPN4JA0d.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"e1d-Qd9bmgwLwdapMhV1ZXBiHXqq4aw\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 3613,
    "path": "../public/_nuxt/DPN4JA0d.js"
  },
  "/_nuxt/DQpql8-C.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"204-/U/iMOuipsPwApuULK2OObxIL1o\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 516,
    "path": "../public/_nuxt/DQpql8-C.js"
  },
  "/_nuxt/DRjgZOYi.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"11ca-GhWrjIf6jfJC0LqA7wgJOGoEYCM\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 4554,
    "path": "../public/_nuxt/DRjgZOYi.js"
  },
  "/_nuxt/DS83KpLo.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"7c2-t5AWFpnSxVVEMDQ2Hrk8LQL03jA\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 1986,
    "path": "../public/_nuxt/DS83KpLo.js"
  },
  "/_nuxt/DUVVgJ47.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"13e-fYrdO6UCU+ewQTvJU8YFekXqBmI\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 318,
    "path": "../public/_nuxt/DUVVgJ47.js"
  },
  "/_nuxt/DWCBBslP.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"10d-gFv9fR/Kfd7Gi8Sz8SGYdBmVqaQ\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 269,
    "path": "../public/_nuxt/DWCBBslP.js"
  },
  "/_nuxt/DWWY-CWQ.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"297-xS2w6iSZUuL9E2ozpC1r+NEm2uI\"",
    "mtime": "2025-07-08T08:45:48.603Z",
    "size": 663,
    "path": "../public/_nuxt/DWWY-CWQ.js"
  },
  "/_nuxt/DWfWaHig.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2e3-b/ZcYCJjMVT7VWj6mGs/j6ztqVY\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 739,
    "path": "../public/_nuxt/DWfWaHig.js"
  },
  "/_nuxt/DWsCkzSM.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"88-QYQg2IsCGJPt50BXL6Pe1tV74Nw\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 136,
    "path": "../public/_nuxt/DWsCkzSM.js"
  },
  "/_nuxt/DXZ0VgCU.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"a7c-0T0Q0+7GmVP+4umjr5I+bxOuGpE\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 2684,
    "path": "../public/_nuxt/DXZ0VgCU.js"
  },
  "/_nuxt/DXk8zDCP.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"3da-Vcl1m6h1aq3J2EnsD6XJPoTeqsQ\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 986,
    "path": "../public/_nuxt/DXk8zDCP.js"
  },
  "/_nuxt/DYSIeutf.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1928-2gWbOe43vGSGsvi+rjD8MfxsIcE\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 6440,
    "path": "../public/_nuxt/DYSIeutf.js"
  },
  "/_nuxt/DZnwFcuC.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"9dd-+7ojSZSbrEvIjZVrUvLgL4nIs3s\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 2525,
    "path": "../public/_nuxt/DZnwFcuC.js"
  },
  "/_nuxt/Dc2Jqg2b.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"5ea-9RbTqYIuyD1sqwdlLCK0BL8NvJk\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 1514,
    "path": "../public/_nuxt/Dc2Jqg2b.js"
  },
  "/_nuxt/DcAIB2mp.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"dcb-JRRKKqIvX1JzYV6UVTEfnB+6c6I\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 3531,
    "path": "../public/_nuxt/DcAIB2mp.js"
  },
  "/_nuxt/Dcr3WNG8.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"22f-jTCKq/YDne8woZnr0hdhBD6LEtE\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 559,
    "path": "../public/_nuxt/Dcr3WNG8.js"
  },
  "/_nuxt/DdkmsPny.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"fb-Jyaenko7jot62rQy+LwMp7Wxxy8\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 251,
    "path": "../public/_nuxt/DdkmsPny.js"
  },
  "/_nuxt/DeQWYOUx.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"24b-LqOj5nVnTe3k19WVcgetFo/pf0k\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 587,
    "path": "../public/_nuxt/DeQWYOUx.js"
  },
  "/_nuxt/DfcJ5PgP.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"569e-qseCxaYYVGMHggZE7Pb5ZeVnGZQ\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 22174,
    "path": "../public/_nuxt/DfcJ5PgP.js"
  },
  "/_nuxt/DgYfxJfa.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2e6-CWLFdCc2pdYRYMTeadyiYshjoTk\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 742,
    "path": "../public/_nuxt/DgYfxJfa.js"
  },
  "/_nuxt/DhxjbIKP.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2735-hXejkyPCXJ4fs7reN6eksUF6U4s\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 10037,
    "path": "../public/_nuxt/DhxjbIKP.js"
  },
  "/_nuxt/DicZZ_Mb.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2a3-PNh7MI6DC0a0TLuHJuu7R3I4yUQ\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 675,
    "path": "../public/_nuxt/DicZZ_Mb.js"
  },
  "/_nuxt/DkZihgzO.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"8c-CuMTPdcqbhcJw5gdrXiQ0e8y+G8\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 140,
    "path": "../public/_nuxt/DkZihgzO.js"
  },
  "/_nuxt/Dk_OCa34.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"d31-bat2OB98yHUw7P3iIEgl1cWibaY\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 3377,
    "path": "../public/_nuxt/Dk_OCa34.js"
  },
  "/_nuxt/Dke8oIBp.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"68b-HAuWwlJQKKb3Q+b6RkQHAxrkt/Y\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 1675,
    "path": "../public/_nuxt/Dke8oIBp.js"
  },
  "/_nuxt/DlqfK7hW.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1c10-Ov+ujsB9pchYfQWPm7fiCzYlrgs\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 7184,
    "path": "../public/_nuxt/DlqfK7hW.js"
  },
  "/_nuxt/Dn3FxXGz.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"251-kJ/M4NY1WNERAdNZpY0TL6mvusY\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 593,
    "path": "../public/_nuxt/Dn3FxXGz.js"
  },
  "/_nuxt/DnSfZw-h.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"4de-1b8e1Sfq1jrdNV1kzaFU8Zm1iDk\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 1246,
    "path": "../public/_nuxt/DnSfZw-h.js"
  },
  "/_nuxt/DoEReKht.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"39e-4KKYjPztV6/2JOCnQbQ92+plkes\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 926,
    "path": "../public/_nuxt/DoEReKht.js"
  },
  "/_nuxt/DoIm2MXR.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"3b4-vAVZIe9TrW9w2MsPC+TX+F2PmZQ\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 948,
    "path": "../public/_nuxt/DoIm2MXR.js"
  },
  "/_nuxt/Dojo4EZu.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"a4e-6tvh4xXJuGMSTikK1zxEGtYCwto\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 2638,
    "path": "../public/_nuxt/Dojo4EZu.js"
  },
  "/_nuxt/DpH6UM2k.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"26d-iGbEjgpFXFIXn+H2JBxhXRoFRPA\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 621,
    "path": "../public/_nuxt/DpH6UM2k.js"
  },
  "/_nuxt/Dpe0uI8q.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"110-2Pm77SR/gEUScMLlDWxYlUvl6Vo\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 272,
    "path": "../public/_nuxt/Dpe0uI8q.js"
  },
  "/_nuxt/DtE09Oqx.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"e8-8eEyNwYRiezllfUa6N9W3jLkCAo\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 232,
    "path": "../public/_nuxt/DtE09Oqx.js"
  },
  "/_nuxt/DtS47maZ.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1a49-rONfrsPT/vFRMiYxBNBRDDGjO34\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 6729,
    "path": "../public/_nuxt/DtS47maZ.js"
  },
  "/_nuxt/Dtmuuw4q.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"4a5-o2hyg9I4W3XT+1HqmvJ6mCClKig\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 1189,
    "path": "../public/_nuxt/Dtmuuw4q.js"
  },
  "/_nuxt/DuKXIbsM.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"165-V8820c6FFw5qzKHP+avgo98AWgI\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 357,
    "path": "../public/_nuxt/DuKXIbsM.js"
  },
  "/_nuxt/DuSrQxKP.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"16aa-ClhlpS1/sc5OgAc3mn73NjnsqmQ\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 5802,
    "path": "../public/_nuxt/DuSrQxKP.js"
  },
  "/_nuxt/DxcuA_Z4.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"3fe-XERjLPEZPOPMg6BPdyHjMdl/OsE\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 1022,
    "path": "../public/_nuxt/DxcuA_Z4.js"
  },
  "/_nuxt/Dye4TC1x.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1454-etTcBe8J1V1w+f7EsHzkVbPm6Ng\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 5204,
    "path": "../public/_nuxt/Dye4TC1x.js"
  },
  "/_nuxt/ERgq5X1B.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"4857f-SX/PHgLAG7PrYNM9cCa57plhNlY\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 296319,
    "path": "../public/_nuxt/ERgq5X1B.js"
  },
  "/_nuxt/EditLinkContent.DaIspNZe.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"36a-IBKKJcJDUCgcS2/FmaQ/AhBdrT0\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 874,
    "path": "../public/_nuxt/EditLinkContent.DaIspNZe.css"
  },
  "/_nuxt/GFtmLLTS.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1507-alm/jxWANzl+JgujMqBiQ3+dk0M\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 5383,
    "path": "../public/_nuxt/GFtmLLTS.js"
  },
  "/_nuxt/H3zBnU51.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"510-1hHlyzQWJEYDy2J+Y61r2tAIFPc\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 1296,
    "path": "../public/_nuxt/H3zBnU51.js"
  },
  "/_nuxt/HXIxGELc.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"5f1-Eyj39CyNc7tsogoMkIi8IwdveR0\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 1521,
    "path": "../public/_nuxt/HXIxGELc.js"
  },
  "/_nuxt/J-U9Dc1a.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"9051-49+/Q8AQzuYgy6ElXfjxkhR8xrQ\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 36945,
    "path": "../public/_nuxt/J-U9Dc1a.js"
  },
  "/_nuxt/JUEjeXMe.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"202d-MVpMnLVsZL5Rv0XMXGIsE13c54k\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 8237,
    "path": "../public/_nuxt/JUEjeXMe.js"
  },
  "/_nuxt/KFOjCnqEu92Fr1Mu51S7ACc6CsTYl4BO.C7zrxsOV.woff2": {
    "type": "font/woff2",
    "etag": "\"31bc-+/J+Dahb8A0+TVvbvnVfNjBTsog\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 12732,
    "path": "../public/_nuxt/KFOjCnqEu92Fr1Mu51S7ACc6CsTYl4BO.C7zrxsOV.woff2"
  },
  "/_nuxt/KFOkCnqEu92Fr1Mu51xIIzIXKMny.DbYcxUfu.woff2": {
    "type": "font/woff2",
    "etag": "\"318c-LpC2xkwcMSxahyzaoF5vwNOOp8s\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 12684,
    "path": "../public/_nuxt/KFOkCnqEu92Fr1Mu51xIIzIXKMny.DbYcxUfu.woff2"
  },
  "/_nuxt/KFOlCnqEu92Fr1MmEU9fBBc4AMP6lQ.BB5XrNxT.woff2": {
    "type": "font/woff2",
    "etag": "\"2b40-z1Ay7qM5mliHDooF5imwBqjHw8c\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 11072,
    "path": "../public/_nuxt/KFOlCnqEu92Fr1MmEU9fBBc4AMP6lQ.BB5XrNxT.woff2"
  },
  "/_nuxt/KFOmCnqEu92Fr1Mu4mxKKTU1Kg.063wu2A_.woff2": {
    "type": "font/woff2",
    "etag": "\"2b14-J58wDKLLvfn1A27y9Dhgf783fao\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 11028,
    "path": "../public/_nuxt/KFOmCnqEu92Fr1Mu4mxKKTU1Kg.063wu2A_.woff2"
  },
  "/_nuxt/KbAOhzQj.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"41c-S+3rfmtDX56jbEKe0IeqToWwHNM\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 1052,
    "path": "../public/_nuxt/KbAOhzQj.js"
  },
  "/_nuxt/LACEEWuN.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"225a-WBWogntWf0fjzX4/08LYzf9l5Ns\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 8794,
    "path": "../public/_nuxt/LACEEWuN.js"
  },
  "/_nuxt/LMOxeD9G.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1fa-bKtHyKZTQg3XkW5qIscwlk1yGcI\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 506,
    "path": "../public/_nuxt/LMOxeD9G.js"
  },
  "/_nuxt/MxgrcUy3.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2b0-GdwA28RzIkWHL5LWVS5gb2qXZUo\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 688,
    "path": "../public/_nuxt/MxgrcUy3.js"
  },
  "/_nuxt/N-erzmfT.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1be-fUGQCxdAvxaAS43lYEDrnJjQuNQ\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 446,
    "path": "../public/_nuxt/N-erzmfT.js"
  },
  "/_nuxt/NewsBlock.CZczrjl2.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"89-654Q4K0zPda+SxE+yYTEqzdc/f0\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 137,
    "path": "../public/_nuxt/NewsBlock.CZczrjl2.css"
  },
  "/_nuxt/P3FQhQEd.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1fd2-Oc+/kt6EN8ju8E00axdzyIGnVZw\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 8146,
    "path": "../public/_nuxt/P3FQhQEd.js"
  },
  "/_nuxt/Popup.mMVDf4HB.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"3d-GC9DgqR9OLVOyRtGjZ6268pV/Pw\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 61,
    "path": "../public/_nuxt/Popup.mMVDf4HB.css"
  },
  "/_nuxt/Preview.DJFty31h.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"204-jQz2IsNcxQvWgIUXdZ9vrxOx7OQ\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 516,
    "path": "../public/_nuxt/Preview.DJFty31h.css"
  },
  "/_nuxt/Q_-FMpAx.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"425-E4ZIiGzkV6Rfod79MhNWqm7lJ40\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 1061,
    "path": "../public/_nuxt/Q_-FMpAx.js"
  },
  "/_nuxt/RIFgB-OI.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"194-cyO9F3i2G5mA3A3L8vS3f+NOj4I\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 404,
    "path": "../public/_nuxt/RIFgB-OI.js"
  },
  "/_nuxt/Toaster.COee0qQm.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"48-aDxBOQEzu7hztnAM8W5iuaRndMI\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 72,
    "path": "../public/_nuxt/Toaster.COee0qQm.css"
  },
  "/_nuxt/UVLjpkX1.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1d2-NNTFvHMIBqp7sbIYrkqWqrw9YR4\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 466,
    "path": "../public/_nuxt/UVLjpkX1.js"
  },
  "/_nuxt/Vlqvjw17.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2d2-NO/zSyDq+qU+kWU/hjyRSeOXIJ0\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 722,
    "path": "../public/_nuxt/Vlqvjw17.js"
  },
  "/_nuxt/VspkUE7J.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"ca1-NqVNV28nMSkTTQ8a3NDXNdJNvxA\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 3233,
    "path": "../public/_nuxt/VspkUE7J.js"
  },
  "/_nuxt/X9yReEDr.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"8cd-5dqrLZT0mPtezpAZSeGXCTvPWoA\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 2253,
    "path": "../public/_nuxt/X9yReEDr.js"
  },
  "/_nuxt/XihsmyW-.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1767-9Kzp1a2em3dgDVEyWQU4gJJMOZs\"",
    "mtime": "2025-07-08T08:45:48.607Z",
    "size": 5991,
    "path": "../public/_nuxt/XihsmyW-.js"
  },
  "/_nuxt/ZQHl2_Bn.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"7d9-Ea30qOcmUgTBwbNezLyhOkfy2FE\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 2009,
    "path": "../public/_nuxt/ZQHl2_Bn.js"
  },
  "/_nuxt/antd.CKJ1iujJ.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"b4c-CtpEOQcw0KMIFqlrsMDWBm4RMpo\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 2892,
    "path": "../public/_nuxt/antd.CKJ1iujJ.css"
  },
  "/_nuxt/b3ZZRPid.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"f0e-U5bIWqBatpotpkb/cPJVlpuDO74\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 3854,
    "path": "../public/_nuxt/b3ZZRPid.js"
  },
  "/_nuxt/bQiYr8ly.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"223-Okb8kJGMf1rI5xgYCFlp6CYfEZE\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 547,
    "path": "../public/_nuxt/bQiYr8ly.js"
  },
  "/_nuxt/bootstrap-icons.BeopsB42.woff": {
    "type": "font/woff",
    "etag": "\"2c040-diAQx5tKBeETH8j7Oxrv8yTYAz8\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 180288,
    "path": "../public/_nuxt/bootstrap-icons.BeopsB42.woff"
  },
  "/_nuxt/bootstrap-icons.mSm7cUeB.woff2": {
    "type": "font/woff2",
    "etag": "\"20b9c-tEH8/5OeJPoJBqN7d4h4i5/du2g\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 134044,
    "path": "../public/_nuxt/bootstrap-icons.mSm7cUeB.woff2"
  },
  "/_nuxt/default.BQ7vIT_l.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"39b36-r43ksKwtIe4wNQoWX0iT/WZX+6Q\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 236342,
    "path": "../public/_nuxt/default.BQ7vIT_l.css"
  },
  "/_nuxt/dhZqlujF.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"5fa-lH5Yz0U0vpaJ8WuC6pB3rAf1FAw\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 1530,
    "path": "../public/_nuxt/dhZqlujF.js"
  },
  "/_nuxt/dmfu1puc.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"161-5NQ+j+9T7kU369fam/KGu5Z7PZo\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 353,
    "path": "../public/_nuxt/dmfu1puc.js"
  },
  "/_nuxt/ekGL9blH.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"159d-6ugRha/JzuTVptW49erSox/4Gts\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 5533,
    "path": "../public/_nuxt/ekGL9blH.js"
  },
  "/_nuxt/entry.BFRLACN3.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"5a-cpzurPlOlpiyo2z+rAI5t5YEIN0\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 90,
    "path": "../public/_nuxt/entry.BFRLACN3.css"
  },
  "/_nuxt/error-bg.B-WR4WFn.png": {
    "type": "image/png",
    "etag": "\"12fd4-zk0tUVq5JsH4QkIpWfnSfvyykcQ\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 77780,
    "path": "../public/_nuxt/error-bg.B-WR4WFn.png"
  },
  "/_nuxt/fCyJD2SE.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"74a-1b9wdu6OajUptR51fz3J2K8EoOE\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 1866,
    "path": "../public/_nuxt/fCyJD2SE.js"
  },
  "/_nuxt/forbidden.DW0K-nQ1.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"50d-owFSzoPVHV70FPB26JZDxJnZf7Q\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 1293,
    "path": "../public/_nuxt/forbidden.DW0K-nQ1.css"
  },
  "/_nuxt/gWqF56bx.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"27e-I60tpgaHSrFGyTOftaDJSR0oHYY\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 638,
    "path": "../public/_nuxt/gWqF56bx.js"
  },
  "/_nuxt/hqVwdxAW.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"3de-Wa9hZi2k5IkZrkNppEvwog4s7sw\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 990,
    "path": "../public/_nuxt/hqVwdxAW.js"
  },
  "/_nuxt/i71v0rfs.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1789-EgTmckpg+8LzDaFyoYVPFoppLK0\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 6025,
    "path": "../public/_nuxt/i71v0rfs.js"
  },
  "/_nuxt/jw4O8LgR.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1f-eU3PQDJjBfdO6ud4w1obwaUkRKo\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 31,
    "path": "../public/_nuxt/jw4O8LgR.js"
  },
  "/_nuxt/jwg6qo3x.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"14d1-BWYlXtX3A+OLLzE0V14PCCQiQq0\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 5329,
    "path": "../public/_nuxt/jwg6qo3x.js"
  },
  "/_nuxt/kB_n4DjS.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"4cc-kBnFhX+KO70npjSMCbtmm92VDoA\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 1228,
    "path": "../public/_nuxt/kB_n4DjS.js"
  },
  "/_nuxt/lGyKo7a9.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"29b-KkClCSywtlyttCxIQ5n9RRVvjwo\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 667,
    "path": "../public/_nuxt/lGyKo7a9.js"
  },
  "/_nuxt/mIYO-ebP.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1d51-GOrST4R/rJX6OjMLWeI0TyWyH8U\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 7505,
    "path": "../public/_nuxt/mIYO-ebP.js"
  },
  "/_nuxt/mwZWlxvM.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2cd-6MNpIsjqTIWT0+MCLxp9h5A/pWY\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 717,
    "path": "../public/_nuxt/mwZWlxvM.js"
  },
  "/_nuxt/pRP0GzHZ.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2c8-Ht2VQacbO7E4/CJQfIImkkXetb0\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 712,
    "path": "../public/_nuxt/pRP0GzHZ.js"
  },
  "/_nuxt/pjSNRiKA.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"28e-GOCf1FsPNpgWb9ge2ahgWY6NIIM\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 654,
    "path": "../public/_nuxt/pjSNRiKA.js"
  },
  "/_nuxt/sEnNb69q.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"868-PDKJ9H6e1w5mfjwjHCDcSSZiCd4\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 2152,
    "path": "../public/_nuxt/sEnNb69q.js"
  },
  "/_nuxt/sqYqsjnJ.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"122d-teCC1rXTLMtOB1V1m0qhDP4D334\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 4653,
    "path": "../public/_nuxt/sqYqsjnJ.js"
  },
  "/_nuxt/style.D5tOv7hW.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"ea35-XyQjgy58zSPA76aiQx4LoCZJT0Y\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 59957,
    "path": "../public/_nuxt/style.D5tOv7hW.css"
  },
  "/_nuxt/vDKS5a0T.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"4af4-wpXjf/t4mzpp7LN09uLZA942Q+I\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 19188,
    "path": "../public/_nuxt/vDKS5a0T.js"
  },
  "/_nuxt/vUxs6RGB.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"104c-8ATRHvJajP+kT/anRe0f6DFUOP4\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 4172,
    "path": "../public/_nuxt/vUxs6RGB.js"
  },
  "/_nuxt/vcSNLBTf.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"b8-FaJuNHgvJT6Ygtqxqt0p9fuKGNk\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 184,
    "path": "../public/_nuxt/vcSNLBTf.js"
  },
  "/_nuxt/vw484qxj.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"186-jfQB+/B5WgnyfNS5VuDQRetJADw\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 390,
    "path": "../public/_nuxt/vw484qxj.js"
  },
  "/_nuxt/yc_x7mqZ.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"2d6-P7C8HfqjL4PT/JjqCNKhXBS9K1A\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 726,
    "path": "../public/_nuxt/yc_x7mqZ.js"
  },
  "/_nuxt/ytxAUtvp.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"1190-lDCZuIp+Xg016fuRv0K/hNodbkk\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 4496,
    "path": "../public/_nuxt/ytxAUtvp.js"
  },
  "/_nuxt/zDOdZIGY.js": {
    "type": "text/javascript; charset=utf-8",
    "etag": "\"9e-UURkbeaVfY7eYi6H7AmWeBXJtQo\"",
    "mtime": "2025-07-08T08:45:48.611Z",
    "size": 158,
    "path": "../public/_nuxt/zDOdZIGY.js"
  },
  "/_nuxt/builds/latest.json": {
    "type": "application/json",
    "etag": "\"47-km7TB1pR8zkkOqu4kt3Eksh9JbA\"",
    "mtime": "2025-07-08T08:45:48.475Z",
    "size": 71,
    "path": "../public/_nuxt/builds/latest.json"
  },
  "/_nuxt/builds/meta/6fd54ada-d1d8-4336-a74b-b32dc8bbb284.json": {
    "type": "application/json",
    "etag": "\"8b-kvBpgCaMMl4kqDL2ZVEgoAKrB9Y\"",
    "mtime": "2025-07-08T08:45:48.471Z",
    "size": 139,
    "path": "../public/_nuxt/builds/meta/6fd54ada-d1d8-4336-a74b-b32dc8bbb284.json"
  }
};

const _DRIVE_LETTER_START_RE = /^[A-Za-z]:\//;
function normalizeWindowsPath(input = "") {
  if (!input) {
    return input;
  }
  return input.replace(/\\/g, "/").replace(_DRIVE_LETTER_START_RE, (r) => r.toUpperCase());
}
const _IS_ABSOLUTE_RE = /^[/\\](?![/\\])|^[/\\]{2}(?!\.)|^[A-Za-z]:[/\\]/;
const _DRIVE_LETTER_RE = /^[A-Za-z]:$/;
function cwd() {
  if (typeof process !== "undefined" && typeof process.cwd === "function") {
    return process.cwd().replace(/\\/g, "/");
  }
  return "/";
}
const resolve = function(...arguments_) {
  arguments_ = arguments_.map((argument) => normalizeWindowsPath(argument));
  let resolvedPath = "";
  let resolvedAbsolute = false;
  for (let index = arguments_.length - 1; index >= -1 && !resolvedAbsolute; index--) {
    const path = index >= 0 ? arguments_[index] : cwd();
    if (!path || path.length === 0) {
      continue;
    }
    resolvedPath = `${path}/${resolvedPath}`;
    resolvedAbsolute = isAbsolute(path);
  }
  resolvedPath = normalizeString(resolvedPath, !resolvedAbsolute);
  if (resolvedAbsolute && !isAbsolute(resolvedPath)) {
    return `/${resolvedPath}`;
  }
  return resolvedPath.length > 0 ? resolvedPath : ".";
};
function normalizeString(path, allowAboveRoot) {
  let res = "";
  let lastSegmentLength = 0;
  let lastSlash = -1;
  let dots = 0;
  let char = null;
  for (let index = 0; index <= path.length; ++index) {
    if (index < path.length) {
      char = path[index];
    } else if (char === "/") {
      break;
    } else {
      char = "/";
    }
    if (char === "/") {
      if (lastSlash === index - 1 || dots === 1) ; else if (dots === 2) {
        if (res.length < 2 || lastSegmentLength !== 2 || res[res.length - 1] !== "." || res[res.length - 2] !== ".") {
          if (res.length > 2) {
            const lastSlashIndex = res.lastIndexOf("/");
            if (lastSlashIndex === -1) {
              res = "";
              lastSegmentLength = 0;
            } else {
              res = res.slice(0, lastSlashIndex);
              lastSegmentLength = res.length - 1 - res.lastIndexOf("/");
            }
            lastSlash = index;
            dots = 0;
            continue;
          } else if (res.length > 0) {
            res = "";
            lastSegmentLength = 0;
            lastSlash = index;
            dots = 0;
            continue;
          }
        }
        if (allowAboveRoot) {
          res += res.length > 0 ? "/.." : "..";
          lastSegmentLength = 2;
        }
      } else {
        if (res.length > 0) {
          res += `/${path.slice(lastSlash + 1, index)}`;
        } else {
          res = path.slice(lastSlash + 1, index);
        }
        lastSegmentLength = index - lastSlash - 1;
      }
      lastSlash = index;
      dots = 0;
    } else if (char === "." && dots !== -1) {
      ++dots;
    } else {
      dots = -1;
    }
  }
  return res;
}
const isAbsolute = function(p) {
  return _IS_ABSOLUTE_RE.test(p);
};
const dirname = function(p) {
  const segments = normalizeWindowsPath(p).replace(/\/$/, "").split("/").slice(0, -1);
  if (segments.length === 1 && _DRIVE_LETTER_RE.test(segments[0])) {
    segments[0] += "/";
  }
  return segments.join("/") || (isAbsolute(p) ? "/" : ".");
};

function readAsset (id) {
  const serverDir = dirname(fileURLToPath(globalThis._importMeta_.url));
  return promises.readFile(resolve(serverDir, assets[id].path))
}

const publicAssetBases = {"/_nuxt/builds/meta/":{"maxAge":31536000},"/_nuxt/builds/":{"maxAge":1},"/_nuxt/":{"maxAge":31536000}};

function isPublicAssetURL(id = '') {
  if (assets[id]) {
    return true
  }
  for (const base in publicAssetBases) {
    if (id.startsWith(base)) { return true }
  }
  return false
}

function getAsset (id) {
  return assets[id]
}

const METHODS = /* @__PURE__ */ new Set(["HEAD", "GET"]);
const EncodingMap = { gzip: ".gz", br: ".br" };
const _TZEtVA = eventHandler((event) => {
  if (event.method && !METHODS.has(event.method)) {
    return;
  }
  let id = decodePath(
    withLeadingSlash(withoutTrailingSlash(parseURL(event.path).pathname))
  );
  let asset;
  const encodingHeader = String(
    getRequestHeader(event, "accept-encoding") || ""
  );
  const encodings = [
    ...encodingHeader.split(",").map((e) => EncodingMap[e.trim()]).filter(Boolean).sort(),
    ""
  ];
  if (encodings.length > 1) {
    appendResponseHeader(event, "Vary", "Accept-Encoding");
  }
  for (const encoding of encodings) {
    for (const _id of [id + encoding, joinURL(id, "index.html" + encoding)]) {
      const _asset = getAsset(_id);
      if (_asset) {
        asset = _asset;
        id = _id;
        break;
      }
    }
  }
  if (!asset) {
    if (isPublicAssetURL(id)) {
      removeResponseHeader(event, "Cache-Control");
      throw createError$1({ statusCode: 404 });
    }
    return;
  }
  const ifNotMatch = getRequestHeader(event, "if-none-match") === asset.etag;
  if (ifNotMatch) {
    setResponseStatus(event, 304, "Not Modified");
    return "";
  }
  const ifModifiedSinceH = getRequestHeader(event, "if-modified-since");
  const mtimeDate = new Date(asset.mtime);
  if (ifModifiedSinceH && asset.mtime && new Date(ifModifiedSinceH) >= mtimeDate) {
    setResponseStatus(event, 304, "Not Modified");
    return "";
  }
  if (asset.type && !getResponseHeader(event, "Content-Type")) {
    setResponseHeader(event, "Content-Type", asset.type);
  }
  if (asset.etag && !getResponseHeader(event, "ETag")) {
    setResponseHeader(event, "ETag", asset.etag);
  }
  if (asset.mtime && !getResponseHeader(event, "Last-Modified")) {
    setResponseHeader(event, "Last-Modified", mtimeDate.toUTCString());
  }
  if (asset.encoding && !getResponseHeader(event, "Content-Encoding")) {
    setResponseHeader(event, "Content-Encoding", asset.encoding);
  }
  if (asset.size > 0 && !getResponseHeader(event, "Content-Length")) {
    setResponseHeader(event, "Content-Length", asset.size);
  }
  return readAsset(id);
});

const _j9q2yJ = defineEventHandler(async (event) => {
  const {
    pruvious: { uploadsDir }
  } = useRuntimeConfig();
  const UPLOADS_DIR = resolve$2(join$1(process.cwd(), uploadsDir));
  const requestPath = getRouterParam(event, "path");
  if (!requestPath) {
    throw createError$1({
      statusCode: 404
    });
  }
  const filePath = resolve$2(UPLOADS_DIR, requestPath);
  if (!filePath.startsWith(UPLOADS_DIR)) {
    throw createError$1({
      statusCode: 404
    });
  }
  if (!existsSync$1(filePath) || !statSync(filePath).isFile()) {
    throw createError$1({ statusCode: 404 });
  }
  const contentType = mime.lookup(filePath) || "application/octet-stream";
  setResponseHeader(event, "Content-Type", contentType);
  return sendStream(event, createReadStream(filePath));
});

const _ifa2K7 = defineEventHandler(async () => {
  const runtimeConfig = useRuntimeConfig();
  cacheModuleOptions(runtimeConfig);
  initJobQueueProcessing(runtimeConfig);
});

const _Ak_QJn = defineEventHandler((event) => {
  const options = getModuleOption("language");
  const supported = options.supported.map(({ code }) => code);
  if (supported.length > 1) {
    const accept = getHeader(event, "Accept-Language") ?? "";
    const language = parser.pick(supported, accept, { loose: true });
    event.context.language = language || options.primary;
  } else {
    event.context.language = options.primary;
  }
});

const _nyTlLp = defineEventHandler(async (event) => {
  const token = getBearerToken(event);
  const { isValid, user } = await verifyToken(token);
  event.context.auth = { isLoggedIn: isValid, user };
});

const _Il07FM = defineEventHandler(async (event) => {
  const user = event.context.auth.user;
  const subPaths = getRouterParam(event, "_")?.split("/") ?? [];
  const collection = subPaths[0] ? collections[subPaths[0]]?.name : null;
  const id = subPaths[1] && collection && collections[collection]?.mode === "multi" && (+subPaths[1]).toString() === subPaths[1] ? +subPaths[1] : null;
  if (!collection || !collections[collection]) {
    setResponseStatus(event, 404);
    return __(event, "pruvious-server", "Resource not found");
  }
  const mode = collections[collection].mode;
  if (mode === "multi" && subPaths.length >= 2) {
    if (subPaths.length === 2 && subPaths[1] === "validate" && (event.method === "POST" || event.method === "PATCH")) {
      const capabilities = getCapabilities(user);
      if (!user) {
        setResponseStatus(event, 401);
        return __(event, "pruvious-server", "Unauthorized due to either invalid credentials or missing authentication");
      } else if (!user.isAdmin && !capabilities[`collection-${collection}-create`] && !capabilities[`collection-${collection}-update`]) {
        setResponseStatus(event, 403);
        return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
          operate: __(event, "pruvious-server", "validate"),
          record: __(event, "pruvious-server", collections[collection].label.collection.plural)
        });
      }
      const input = await readInputData(event, collection);
      if (input?.errors.length) {
        setResponseStatus(event, 400);
        return input.errors.join("\n");
      }
      const errors = await query(
        collection,
        event.context.language
      ).validate(input.data, event.method === "POST" ? "create" : "update");
      if (Object.keys(errors).length) {
        setResponseStatus(event, 422);
        return errors;
      }
      setResponseStatus(event, 204);
      return "";
    } else if (subPaths.length === 3 && subPaths[2] === "duplicate" && id && event.method === "POST" && collections[collection].duplicate) {
      const original = await query(collection, event.context.language).where("id", id).first();
      if (!original) {
        setResponseStatus(event, 404);
        return __(event, "pruvious-server", "Resource not found");
      }
      const duplicate = await collections[collection].duplicate({ record: original, query: query });
      const qs = getQueryStringParams(event, collection);
      if (qs.errors.length) {
        setResponseStatus(event, 400);
        return qs.errors.join("\n");
      }
      if (!user) {
        setResponseStatus(event, 401);
        return __(event, "pruvious-server", "Unauthorized due to either invalid credentials or missing authentication");
      } else if (!user.isAdmin && !hasCapability(user, `collection-${collection}-create`)) {
        setResponseStatus(event, 403);
        return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
          operate: __(event, "pruvious-server", "create"),
          record: __(event, "pruvious-server", collections[collection].label.record.plural)
        });
      }
      const params = objectPick(qs.params, ["select", "order", "populate"]);
      const idSelected = params.select.includes("id");
      if (!idSelected) {
        params.select.push("id");
      }
      const query$1 = query(
        collection,
        event.context.language
      ).applyQueryStringParams(params);
      if (!user.isAdmin) {
        const cache = {};
        const fieldGuardErrors = {};
        for (const guard of collections[collection].guards) {
          if (isFunction(guard) || guard.onCreate) {
            try {
              await (isFunction(guard) ? guard : guard.guard)({
                _,
                __,
                cache,
                definition: collections[collection],
                input: duplicate,
                language: event.context.language,
                operation: "create",
                currentQuery: query$1,
                query: query,
                user
              });
            } catch (e) {
              setResponseStatus(event, 403);
              return e.message;
            }
          }
        }
        for (const [fieldName, field] of Object.entries(collections[collection].fields)) {
          if (field.additional?.guards) {
            for (const guard of field.additional.guards) {
              if (isFunction(guard) || guard.onCreate) {
                try {
                  await (isFunction(guard) ? guard : guard.guard)({
                    _,
                    __,
                    cache,
                    definition: fields[field.type],
                    fields,
                    input: duplicate,
                    language: event.context.language,
                    name: fieldName,
                    operation: "create",
                    options: collections[collection].fields[fieldName].options,
                    currentQuery: query$1,
                    query: query,
                    user,
                    value: duplicate[fieldName]
                  });
                } catch (e) {
                  fieldGuardErrors[fieldName] = e.message;
                }
              }
            }
          }
        }
        if (Object.keys(fieldGuardErrors).length) {
          setResponseStatus(event, 403);
          return fieldGuardErrors;
        }
      }
      await applyHooksBeforeCreate(collection, {
        input: duplicate,
        currentQuery: query$1,
        query: query,
        user
      });
      const result = await query$1.create(duplicate);
      if (result.success) {
        removeProtectedFields(collection, result.record);
        await applyHooksAfterCreate(collection, {
          query: query,
          record: result.record,
          recordId: result.record.id,
          user
        });
        if (!idSelected) delete result.record.id;
        await applyHooksBeforeReturnRecord(collection, { query: query, record: result.record, user });
        return result.record;
      } else if (result.message) {
        setResponseStatus(event, 400);
        return result.message;
      } else {
        setResponseStatus(event, 422);
        return result.errors;
      }
    } else if (subPaths.length === 3 && subPaths[2] === "mirror" && id && event.method === "POST" && collections[collection].translatable) {
      if (!user) {
        setResponseStatus(event, 401);
        return __(event, "pruvious-server", "Unauthorized due to either invalid credentials or missing authentication");
      } else if (!user.isAdmin && !hasCapability(user, `collection-${collection}-read`)) {
        setResponseStatus(event, 403);
        return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
          operate: __(event, "pruvious-server", "read"),
          record: __(event, "pruvious-server", collections[collection].label.record.plural)
        });
      }
      const from = await query(collection, event.context.language).where("id", id).first();
      if (!from) {
        setResponseStatus(event, 404);
        return __(event, "pruvious-server", "Resource not found");
      }
      const qs = getQueryStringParams(event, collection);
      const _qs = getQuery(event);
      const language = _qs.to && isString(_qs.to) ? _qs.to : null;
      if (qs.errors.length) {
        setResponseStatus(event, 400);
        return qs.errors.join("\n");
      } else if (!language) {
        setResponseStatus(event, 400);
        return __(event, "pruvious-server", "Missing 'to' parameter");
      } else if (!supportedLanguages.includes(language)) {
        setResponseStatus(event, 400);
        return __(event, "pruvious-server", "The language code '$language' is not supported", { language });
      } else if (from.language === language) {
        setResponseStatus(event, 400);
        return __(event, "pruvious-server", "Source and target language cannot be the same");
      }
      const to = await query(collection, event.context.language).where("translations", from.translations).where("language", language).first();
      const translation = await collections[collection].mirrorTranslation({
        from,
        to,
        language,
        query: query
      });
      if (to) {
        if (!user.isAdmin && !hasCapability(user, `collection-${collection}-update`)) {
          setResponseStatus(event, 403);
          return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
            operate: __(event, "pruvious-server", "update"),
            record: __(event, "pruvious-server", collections[collection].label.record.plural)
          });
        }
        const params = objectPick(qs.params, ["select", "order", "populate"]);
        const idSelected = params.select.includes("id");
        if (!idSelected) {
          params.select.push("id");
        }
        const query$1 = query(collection, event.context.language).applyQueryStringParams(params).where("id", to.id);
        if (!user.isAdmin) {
          const cache = {};
          const fieldGuardErrors = {};
          for (const guard of collections[collection].guards) {
            if (isFunction(guard) || guard.onUpdate) {
              try {
                await (isFunction(guard) ? guard : guard.guard)({
                  _,
                  __,
                  cache,
                  definition: collections[collection],
                  input: translation,
                  language: event.context.language,
                  operation: "update",
                  currentQuery: query$1,
                  query: query,
                  user
                });
              } catch (e) {
                setResponseStatus(event, 403);
                return e.message;
              }
            }
          }
          for (const [fieldName, field] of Object.entries(collections[collection].fields)) {
            if (isDefined(translation[fieldName]) && field.additional?.guards) {
              for (const guard of field.additional.guards) {
                if (isFunction(guard) || guard.onUpdate) {
                  try {
                    await (isFunction(guard) ? guard : guard.guard)({
                      _,
                      __,
                      cache,
                      definition: fields[field.type],
                      fields,
                      input: translation,
                      language: event.context.language,
                      name: fieldName,
                      operation: "update",
                      options: collections[collection].fields[fieldName].options,
                      currentQuery: query$1,
                      query: query,
                      user,
                      value: translation[fieldName]
                    });
                  } catch (e) {
                    fieldGuardErrors[fieldName] = e.message;
                  }
                }
              }
            }
          }
          if (Object.keys(fieldGuardErrors).length) {
            setResponseStatus(event, 403);
            return fieldGuardErrors;
          }
        }
        await applyHooksBeforeUpdate(collection, {
          input: translation,
          currentQuery: query$1,
          query: query,
          user
        });
        const result = await query$1.update(translation);
        if (result.success && result.records.length) {
          removeProtectedFields(collection, result.records);
          await applyHooksAfterUpdate(collection, {
            query: query,
            record: result.records[0],
            recordId: result.records[0].id,
            user
          });
          if (!idSelected) delete result.records[0].id;
          await applyHooksBeforeReturnRecord(collection, { query: query, record: result.records[0], user });
          return result.records[0];
        } else if (result.success) {
          setResponseStatus(event, 404);
          return __(event, "pruvious-server", "Resource not found");
        } else if (result.message) {
          setResponseStatus(event, 400);
          return result.message;
        } else {
          setResponseStatus(event, 422);
          return result.errors;
        }
      } else {
        if (!user.isAdmin && !hasCapability(user, `collection-${collection}-create`)) {
          setResponseStatus(event, 403);
          return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
            operate: __(event, "pruvious-server", "create"),
            record: __(event, "pruvious-server", collections[collection].label.record.plural)
          });
        }
        const params = objectPick(qs.params, ["select", "order", "populate"]);
        const idSelected = params.select.includes("id");
        if (!idSelected) {
          params.select.push("id");
        }
        const query$1 = query(
          collection,
          event.context.language
        ).applyQueryStringParams(params);
        if (!user.isAdmin) {
          const cache = {};
          const fieldGuardErrors = {};
          for (const guard of collections[collection].guards) {
            if (isFunction(guard) || guard.onCreate) {
              try {
                await (isFunction(guard) ? guard : guard.guard)({
                  _,
                  __,
                  cache,
                  definition: collections[collection],
                  input: translation,
                  language: event.context.language,
                  operation: "create",
                  currentQuery: query$1,
                  query: query,
                  user
                });
              } catch (e) {
                setResponseStatus(event, 403);
                return e.message;
              }
            }
          }
          for (const [fieldName, field] of Object.entries(collections[collection].fields)) {
            if (field.additional?.guards) {
              for (const guard of field.additional.guards) {
                if (isFunction(guard) || guard.onCreate) {
                  try {
                    await (isFunction(guard) ? guard : guard.guard)({
                      _,
                      __,
                      cache,
                      definition: fields[field.type],
                      fields,
                      input: translation,
                      language: event.context.language,
                      name: fieldName,
                      operation: "create",
                      options: collections[collection].fields[fieldName].options,
                      currentQuery: query$1,
                      query: query,
                      user,
                      value: translation[fieldName]
                    });
                  } catch (e) {
                    fieldGuardErrors[fieldName] = e.message;
                  }
                }
              }
            }
          }
          if (Object.keys(fieldGuardErrors).length) {
            setResponseStatus(event, 403);
            return fieldGuardErrors;
          }
        }
        await applyHooksBeforeCreate(collection, {
          input: translation,
          currentQuery: query$1,
          query: query,
          user
        });
        const result = await query$1.create(translation);
        if (result.success) {
          removeProtectedFields(collection, result.record);
          await applyHooksAfterCreate(collection, {
            query: query,
            record: result.record,
            recordId: result.record.id,
            user
          });
          if (!idSelected) delete result.record.id;
          await applyHooksBeforeReturnRecord(collection, { query: query, record: result.record, user });
          return result.record;
        } else if (result.message) {
          setResponseStatus(event, 400);
          return result.message;
        } else {
          setResponseStatus(event, 422);
          return result.errors;
        }
      }
    }
  } else if (mode === "single" && subPaths.length > 1) {
    if (subPaths.length === 2 && subPaths[1] === "validate" && event.method === "PATCH") {
      if (!user) {
        setResponseStatus(event, 401);
        return __(event, "pruvious-server", "Unauthorized due to either invalid credentials or missing authentication");
      } else if (!user.isAdmin && !hasCapability(user, `collection-${collection}-update`)) {
        setResponseStatus(event, 403);
        return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
          operate: __(event, "pruvious-server", "validate"),
          record: __(event, "pruvious-server", collections[collection].label.collection.plural)
        });
      }
      const input = await readInputData(event, collection);
      if (input?.errors.length) {
        setResponseStatus(event, 400);
        return input.errors.join("\n");
      }
      const errors = await query(collection, event.context.language).validate(
        input.data,
        "update"
      );
      if (Object.keys(errors).length) {
        setResponseStatus(event, 422);
        return errors;
      }
      setResponseStatus(event, 204);
      return "";
    } else if (subPaths.length === 2 && subPaths[1] === "mirror" && event.method === "POST" && collections[collection].translatable) {
      if (!user) {
        setResponseStatus(event, 401);
        return __(event, "pruvious-server", "Unauthorized due to either invalid credentials or missing authentication");
      } else if (!user.isAdmin && !hasCapability(user, `collection-${collection}-read`)) {
        setResponseStatus(event, 403);
        return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
          operate: __(event, "pruvious-server", "read"),
          record: __(event, "pruvious-server", collections[collection].label.record.plural)
        });
      }
      const qs = getQueryStringParams(event, collection);
      const _qs = getQuery(event);
      const fromLanguage = _qs.from && isString(_qs.from) ? _qs.from : null;
      const toLanguage = _qs.to && isString(_qs.to) ? _qs.to : null;
      if (qs.errors.length) {
        setResponseStatus(event, 400);
        return qs.errors.join("\n");
      } else if (!fromLanguage) {
        setResponseStatus(event, 400);
        return __(event, "pruvious-server", "Missing 'from' language parameter");
      } else if (!toLanguage) {
        setResponseStatus(event, 400);
        return __(event, "pruvious-server", "Missing 'to' language parameter");
      } else if (!supportedLanguages.includes(fromLanguage)) {
        setResponseStatus(event, 400);
        return __(event, "pruvious-server", "The language code '$language' is not supported", {
          language: fromLanguage
        });
      } else if (!supportedLanguages.includes(toLanguage)) {
        setResponseStatus(event, 400);
        return __(event, "pruvious-server", `The language code '$language' is not supported`, {
          language: toLanguage
        });
      } else if (fromLanguage === toLanguage) {
        setResponseStatus(event, 400);
        return __(event, "pruvious-server", "Source and target language cannot be the same");
      }
      const from = await query(collection, event.context.language).language(fromLanguage).read();
      const to = await query(collection, event.context.language).language(toLanguage).read();
      if (!from) {
        setResponseStatus(event, 404);
        return __(event, "pruvious-server", "Resource not found");
      }
      if (!user.isAdmin && !hasCapability(user, `collection-${collection}-update`)) {
        setResponseStatus(event, 403);
        return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
          operate: __(event, "pruvious-server", "update"),
          record: __(event, "pruvious-server", collections[collection].label.record.plural)
        });
      }
      const translation = await collections[collection].mirrorTranslation({
        from,
        to,
        language: toLanguage,
        query: query
      });
      const params = { ...objectPick(qs.params, ["select", "populate"]), language: toLanguage };
      const idSelected = params.select.includes("id");
      if (!idSelected) {
        params.select.push("id");
      }
      const query$1 = query(collection, event.context.language).applyQueryStringParams(
        params
      );
      if (!user.isAdmin) {
        const cache = {};
        const fieldGuardErrors = {};
        for (const guard of collections[collection].guards) {
          if (isFunction(guard) || guard.onUpdate) {
            try {
              await (isFunction(guard) ? guard : guard.guard)({
                _,
                __,
                cache,
                definition: collections[collection],
                input: translation,
                language: event.context.language,
                operation: "update",
                currentQuery: query$1,
                query: query,
                user
              });
            } catch (e) {
              setResponseStatus(event, 403);
              return e.message;
            }
          }
        }
        for (const [fieldName, field] of Object.entries(collections[collection].fields)) {
          if (isDefined(translation[fieldName]) && field.additional?.guards) {
            for (const guard of field.additional.guards) {
              if (isFunction(guard) || guard.onUpdate) {
                try {
                  await (isFunction(guard) ? guard : guard.guard)({
                    _,
                    __,
                    cache,
                    definition: fields[field.type],
                    fields,
                    input: translation,
                    language: event.context.language,
                    name: fieldName,
                    operation: "update",
                    options: collections[collection].fields[fieldName].options,
                    currentQuery: query$1,
                    query: query,
                    user,
                    value: translation[fieldName]
                  });
                } catch (e) {
                  fieldGuardErrors[fieldName] = e.message;
                }
              }
            }
          }
        }
        if (Object.keys(fieldGuardErrors).length) {
          setResponseStatus(event, 403);
          return fieldGuardErrors;
        }
      }
      await applyHooksBeforeUpdate(collection, { input: translation, currentQuery: query$1, query: query, user });
      const result = await query$1.update(translation);
      if (result.success) {
        removeProtectedFields(collection, result.record);
        await applyHooksAfterUpdate(collection, {
          query: query,
          record: result.record,
          recordId: result.record.id,
          user
        });
        await applyHooksBeforeReturnRecord(collection, { query: query, record: result.record, user });
        if (!idSelected) delete result.record.id;
        return result.record;
      } else if (result.message) {
        setResponseStatus(event, 400);
        return result.message;
      } else {
        setResponseStatus(event, 422);
        return result.errors;
      }
    }
  }
  if (mode === "multi") {
    const idExists = !!(id ? await query(collection, event.context.language).where("id", id).count() : 0);
    if (id && !idExists || id && subPaths.length > 2 || !id && subPaths.length > 1) {
      setResponseStatus(event, 404);
      return __(event, "pruvious-server", "Resource not found");
    }
    const method = event.method;
    const input = method === "POST" || method === "PATCH" ? await readInputData(event, collection) : null;
    if (input?.errors.length) {
      setResponseStatus(event, 400);
      return input.errors.join("\n");
    }
    const operation = resolveOperation(method, id, input?.data);
    if (!operation) {
      setResponseStatus(event, 405);
      return __(event, "pruvious-server", "This method is not supported");
    }
    const qs = getQueryStringParams(event, collection);
    if (qs.errors.length) {
      setResponseStatus(event, 400);
      return qs.errors.join("\n");
    }
    if (operation === "create" && collections[collection].apiRoutes.create) {
      if (collections[collection].apiRoutes.create === "private") {
        if (!user) {
          setResponseStatus(event, 401);
          return __(
            event,
            "pruvious-server",
            "Unauthorized due to either invalid credentials or missing authentication"
          );
        } else if (!user.isAdmin && !hasCapability(user, `collection-${collection}-create`)) {
          setResponseStatus(event, 403);
          return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
            operate: __(event, "pruvious-server", "create"),
            record: __(event, "pruvious-server", collections[collection].label.record.plural)
          });
        }
      }
      const params = objectPick(qs.params, ["select", "order", "populate"]);
      const idSelected = params.select.includes("id");
      if (!idSelected) {
        params.select.push("id");
      }
      const query$1 = query(
        collection,
        event.context.language
      ).applyQueryStringParams(params);
      if (!user?.isAdmin) {
        const cache = {};
        const fieldGuardErrors = {};
        for (const guard of collections[collection].guards) {
          if (isFunction(guard) || guard.onCreate) {
            try {
              await (isFunction(guard) ? guard : guard.guard)({
                _,
                __,
                cache,
                definition: collections[collection],
                input: input.data,
                language: event.context.language,
                operation: "create",
                currentQuery: query$1,
                query: query,
                user
              });
            } catch (e) {
              setResponseStatus(event, 403);
              return e.message;
            }
          }
        }
        for (const [fieldName, field] of Object.entries(collections[collection].fields)) {
          if (field.additional?.guards) {
            for (const guard of field.additional.guards) {
              if (isFunction(guard) || guard.onCreate) {
                try {
                  await (isFunction(guard) ? guard : guard.guard)({
                    _,
                    __,
                    cache,
                    definition: fields[field.type],
                    fields,
                    input: input.data,
                    language: event.context.language,
                    name: fieldName,
                    operation: "create",
                    options: collections[collection].fields[fieldName].options,
                    currentQuery: query$1,
                    query: query,
                    user,
                    value: input.data[fieldName]
                  });
                } catch (e) {
                  fieldGuardErrors[fieldName] = e.message;
                }
              }
            }
          }
        }
        if (Object.keys(fieldGuardErrors).length) {
          setResponseStatus(event, 403);
          return fieldGuardErrors;
        }
      }
      await applyHooksBeforeCreate(collection, {
        input: input.data,
        currentQuery: query$1,
        query: query,
        user
      });
      const result = await query$1.create(input.data);
      if (result.success) {
        removeProtectedFields(collection, result.record);
        await applyHooksAfterCreate(collection, {
          query: query,
          record: result.record,
          recordId: result.record.id,
          user
        });
        if (!idSelected) delete result.record.id;
        await applyHooksBeforeReturnRecord(collection, { query: query, record: result.record, user });
        return result.record;
      } else if (result.message) {
        setResponseStatus(event, 400);
        return result.message;
      } else {
        setResponseStatus(event, 422);
        return result.errors;
      }
    }
    if (operation === "createMany" && collections[collection].apiRoutes.createMany) {
      if (collections[collection].apiRoutes.createMany === "private") {
        if (!user) {
          setResponseStatus(event, 401);
          return __(
            event,
            "pruvious-server",
            "Unauthorized due to either invalid credentials or missing authentication"
          );
        } else if (!user.isAdmin && !hasCapability(user, `collection-${collection}-create-many`)) {
          setResponseStatus(event, 403);
          return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
            operate: __(event, "pruvious-server", "create"),
            record: __(event, "pruvious-server", collections[collection].label.record.plural)
          });
        }
      }
      const params = objectPick(qs.params, ["select", "order", "populate"]);
      const idSelected = params.select.includes("id");
      if (!idSelected) {
        params.select.push("id");
      }
      const query$1 = query(
        collection,
        event.context.language
      ).applyQueryStringParams(params);
      if (!user?.isAdmin) {
        const cache = {};
        const fieldGuardErrors = [];
        for (const guard of collections[collection].guards) {
          if (isFunction(guard) || guard.onCreate) {
            try {
              await (isFunction(guard) ? guard : guard.guard)({
                _,
                __,
                cache,
                definition: collections[collection],
                allInputs: input.data,
                language: event.context.language,
                operation: "create",
                currentQuery: query$1,
                query: query,
                user
              });
            } catch (e) {
              setResponseStatus(event, 403);
              return e.message;
            }
          }
        }
        for (const entry of input.data) {
          const errors = {};
          for (const [fieldName, field] of Object.entries(collections[collection].fields)) {
            if (field.additional?.guards) {
              for (const guard of field.additional.guards) {
                if (isFunction(guard) || guard.onCreate) {
                  try {
                    await (isFunction(guard) ? guard : guard.guard)({
                      _,
                      __,
                      cache,
                      definition: fields[field.type],
                      fields,
                      input: entry,
                      allInputs: input.data,
                      language: event.context.language,
                      name: fieldName,
                      operation: "create",
                      options: collections[collection].fields[fieldName].options,
                      currentQuery: query$1,
                      query: query,
                      user,
                      value: entry[fieldName]
                    });
                  } catch (e) {
                    errors[fieldName] = e.message;
                  }
                }
              }
            }
          }
          fieldGuardErrors.push(Object.keys(errors).length ? errors : null);
        }
        if (fieldGuardErrors.some(Boolean)) {
          setResponseStatus(event, 403);
          return fieldGuardErrors;
        }
      }
      for (const entry of input.data) {
        await applyHooksBeforeCreate(collection, {
          input: entry,
          currentQuery: query$1,
          query: query,
          user
        });
      }
      const result = await query$1.createMany(input.data);
      if (result.success) {
        for (const record of result.records) {
          removeProtectedFields(collection, result.records);
          await applyHooksAfterCreate(collection, {
            query: query,
            record,
            recordId: record.id,
            user
          });
          if (!idSelected) delete record.id;
          await applyHooksBeforeReturnRecord(collection, { query: query, record, user });
        }
        return result.records;
      } else if (result.message) {
        setResponseStatus(event, 400);
        return result.message;
      } else {
        setResponseStatus(event, 422);
        return result.errors;
      }
    }
    if (operation === "read" && collections[collection].apiRoutes.read) {
      if (collections[collection].apiRoutes.read === "private") {
        if (!user) {
          setResponseStatus(event, 401);
          return __(
            event,
            "pruvious-server",
            "Unauthorized due to either invalid credentials or missing authentication"
          );
        } else if (!user.isAdmin && !hasCapability(user, `collection-${collection}-read`)) {
          setResponseStatus(event, 403);
          return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
            operate: __(event, "pruvious-server", "read"),
            record: __(event, "pruvious-server", collections[collection].label.record.plural)
          });
        }
      }
      const query$1 = query(collection, event.context.language).applyQueryStringParams(objectPick(qs.params, ["select", "populate"])).where("id", id);
      if (!user?.isAdmin) {
        const cache = {};
        for (const guard of collections[collection].guards) {
          if (isFunction(guard) || guard.onRead) {
            try {
              await (isFunction(guard) ? guard : guard.guard)({
                _,
                __,
                cache,
                definition: collections[collection],
                operation: "read",
                currentQuery: query$1,
                language: event.context.language,
                query: query,
                user
              });
            } catch (e) {
              setResponseStatus(event, 403);
              return e.message;
            }
          }
        }
      }
      await applyHooksBeforeRead(collection, { currentQuery: query$1, query: query, user });
      const record = await query$1.first();
      if (record) {
        removeProtectedFields(collection, record);
        await applyHooksAfterRead(collection, { query: query, record, recordId: id, user });
        await applyHooksBeforeReturnRecord(collection, { query: query, record, user });
        return record;
      } else {
        setResponseStatus(event, 404);
        return __(event, "pruvious-server", "Resource not found");
      }
    }
    if (operation === "readMany" && collections[collection].apiRoutes.readMany) {
      if (collections[collection].apiRoutes.readMany === "private") {
        if (!user) {
          setResponseStatus(event, 401);
          return __(
            event,
            "pruvious-server",
            "Unauthorized due to either invalid credentials or missing authentication"
          );
        } else if (!user.isAdmin && !hasCapability(user, `collection-${collection}-read-many`)) {
          setResponseStatus(event, 403);
          return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
            operate: __(event, "pruvious-server", "read"),
            record: __(event, "pruvious-server", collections[collection].label.record.plural)
          });
        }
      }
      const params = deepClone(qs.params);
      const idSelected = params.select.includes("id");
      if (!idSelected) {
        params.select.push("id");
      }
      const query$1 = query(
        collection,
        event.context.language
      ).applyQueryStringParams(qs.params);
      if (!user?.isAdmin) {
        const cache = {};
        for (const guard of collections[collection].guards) {
          if (isFunction(guard) || guard.onRead) {
            try {
              await (isFunction(guard) ? guard : guard.guard)({
                _,
                __,
                cache,
                definition: collections[collection],
                operation: "read",
                currentQuery: query$1,
                language: event.context.language,
                query: query,
                user
              });
            } catch (e) {
              setResponseStatus(event, 403);
              return e.message;
            }
          }
        }
      }
      await applyHooksBeforeRead(collection, { currentQuery: query$1, query: query, user });
      const { count, records } = await query$1.allWithCount();
      const offset = qs.params.offset ?? 0;
      const perPage = qs.params.limit ?? count;
      const page = perPage ? offset / perPage + 1 : 1;
      const lastPage = perPage ? Math.max(1, Math.ceil(count / perPage)) : 1;
      for (const record of records) {
        removeProtectedFields(collection, record);
        await applyHooksAfterRead(collection, { query: query, record, recordId: record.id, user });
        if (!idSelected) delete record.id;
        await applyHooksBeforeReturnRecord(collection, { query: query, record, user });
      }
      return { currentPage: isPositiveInteger(page) ? page : null, lastPage, perPage, records, total: count };
    }
    if (operation === "update" && collections[collection].apiRoutes.update) {
      if (collections[collection].apiRoutes.update === "private") {
        if (!user) {
          setResponseStatus(event, 401);
          return __(
            event,
            "pruvious-server",
            "Unauthorized due to either invalid credentials or missing authentication"
          );
        } else if (!user.isAdmin && !hasCapability(user, `collection-${collection}-update`)) {
          setResponseStatus(event, 403);
          return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
            operate: __(event, "pruvious-server", "update"),
            record: __(event, "pruvious-server", collections[collection].label.record.plural)
          });
        }
      }
      const query$1 = query(collection, event.context.language).applyQueryStringParams(objectPick(qs.params, ["select", "order", "populate"])).where("id", id);
      if (!user?.isAdmin) {
        const cache = {};
        const fieldGuardErrors = {};
        for (const guard of collections[collection].guards) {
          if (isFunction(guard) || guard.onUpdate) {
            try {
              await (isFunction(guard) ? guard : guard.guard)({
                _,
                __,
                cache,
                definition: collections[collection],
                input: input.data,
                language: event.context.language,
                operation: "update",
                currentQuery: query$1,
                query: query,
                user
              });
            } catch (e) {
              setResponseStatus(event, 403);
              return e.message;
            }
          }
        }
        for (const [fieldName, field] of Object.entries(collections[collection].fields)) {
          if (isDefined(input.data[fieldName]) && field.additional?.guards) {
            for (const guard of field.additional.guards) {
              if (isFunction(guard) || guard.onUpdate) {
                try {
                  await (isFunction(guard) ? guard : guard.guard)({
                    _,
                    __,
                    cache,
                    definition: fields[field.type],
                    fields,
                    input: input.data,
                    language: event.context.language,
                    name: fieldName,
                    operation: "update",
                    options: collections[collection].fields[fieldName].options,
                    currentQuery: query$1,
                    query: query,
                    user,
                    value: input.data[fieldName]
                  });
                } catch (e) {
                  fieldGuardErrors[fieldName] = e.message;
                }
              }
            }
          }
        }
        if (Object.keys(fieldGuardErrors).length) {
          setResponseStatus(event, 403);
          return fieldGuardErrors;
        }
      }
      await applyHooksBeforeUpdate(collection, { input: input.data, currentQuery: query$1, query: query, user });
      const result = await query$1.update(input.data);
      if (result.success && result.records.length) {
        removeProtectedFields(collection, result.records);
        await applyHooksAfterUpdate(collection, { query: query, record: result.records[0], recordId: id, user });
        await applyHooksBeforeReturnRecord(collection, { query: query, record: result.records[0], user });
        return result.records[0];
      } else if (result.success) {
        setResponseStatus(event, 404);
        return __(event, "pruvious-server", "Resource not found");
      } else if (result.message) {
        setResponseStatus(event, 400);
        return result.message;
      } else {
        setResponseStatus(event, 422);
        return result.errors;
      }
    }
    if (operation === "updateMany" && collections[collection].apiRoutes.updateMany) {
      if (collections[collection].apiRoutes.updateMany === "private") {
        if (!user) {
          setResponseStatus(event, 401);
          return __(
            event,
            "pruvious-server",
            "Unauthorized due to either invalid credentials or missing authentication"
          );
        } else if (!user.isAdmin && !hasCapability(user, `collection-${collection}-update-many`)) {
          setResponseStatus(event, 403);
          return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
            operate: __(event, "pruvious-server", "update"),
            record: __(event, "pruvious-server", collections[collection].label.record.plural)
          });
        }
      }
      const params = objectPick(qs.params, ["select", "order", "populate", "where"]);
      const idSelected = params.select.includes("id");
      if (!idSelected) {
        params.select.push("id");
      }
      const query$1 = query(
        collection,
        event.context.language
      ).applyQueryStringParams(params);
      if (!user?.isAdmin) {
        const cache = {};
        const fieldGuardErrors = {};
        for (const guard of collections[collection].guards) {
          if (isFunction(guard) || guard.onUpdate) {
            try {
              await (isFunction(guard) ? guard : guard.guard)({
                _,
                __,
                cache,
                definition: collections[collection],
                input: input.data,
                language: event.context.language,
                operation: "update",
                currentQuery: query$1,
                query: query,
                user
              });
            } catch (e) {
              setResponseStatus(event, 403);
              return e.message;
            }
          }
        }
        for (const [fieldName, field] of Object.entries(collections[collection].fields)) {
          if (isDefined(input.data[fieldName]) && field.additional?.guards) {
            for (const guard of field.additional.guards) {
              if (isFunction(guard) || guard.onUpdate) {
                try {
                  await (isFunction(guard) ? guard : guard.guard)({
                    _,
                    __,
                    cache,
                    definition: fields[field.type],
                    fields,
                    input: input.data,
                    language: event.context.language,
                    name: fieldName,
                    operation: "update",
                    options: collections[collection].fields[fieldName].options,
                    currentQuery: query$1,
                    query: query,
                    user,
                    value: input.data[fieldName]
                  });
                } catch (e) {
                  fieldGuardErrors[fieldName] = e.message;
                }
              }
            }
          }
        }
        if (Object.keys(fieldGuardErrors).length) {
          setResponseStatus(event, 403);
          return fieldGuardErrors;
        }
      }
      await applyHooksBeforeUpdate(collection, { input: input.data, currentQuery: query$1, query: query, user });
      const result = await query$1.update(input.data);
      if (result.success) {
        for (const record of result.records) {
          removeProtectedFields(collection, result.records);
          await applyHooksAfterUpdate(collection, { query: query, record, recordId: record.id, user });
          if (!idSelected) delete record.id;
          await applyHooksBeforeReturnRecord(collection, { query: query, record, user });
        }
        return result.records;
      } else if (result.message) {
        setResponseStatus(event, 400);
        return result.message;
      } else {
        setResponseStatus(event, 422);
        return result.errors;
      }
    }
    if (operation === "delete" && collections[collection].apiRoutes.delete) {
      if (collections[collection].apiRoutes.delete === "private") {
        if (!user) {
          setResponseStatus(event, 401);
          return __(
            event,
            "pruvious-server",
            "Unauthorized due to either invalid credentials or missing authentication"
          );
        } else if (!user.isAdmin && !hasCapability(user, `collection-${collection}-delete`)) {
          setResponseStatus(event, 403);
          return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
            operate: __(event, "pruvious-server", "delete"),
            record: __(event, "pruvious-server", collections[collection].label.record.plural)
          });
        }
      }
      const query$1 = query(collection, event.context.language).applyQueryStringParams(objectPick(qs.params, ["select", "order", "populate"])).where("id", id);
      if (!user?.isAdmin) {
        const cache = {};
        for (const guard of collections[collection].guards) {
          if (isFunction(guard) || guard.onDelete) {
            try {
              await (isFunction(guard) ? guard : guard.guard)({
                _,
                __,
                cache,
                definition: collections[collection],
                language: event.context.language,
                operation: "delete",
                currentQuery: query$1,
                query: query,
                user
              });
            } catch (e) {
              setResponseStatus(event, 403);
              return e.message;
            }
          }
        }
      }
      await applyHooksBeforeDelete(collection, {
        currentQuery: query$1,
        query: query,
        user
      });
      const records = await query$1.delete();
      if (records.length) {
        removeProtectedFields(collection, records);
        await applyHooksAfterDelete(collection, {
          query: query,
          record: records[0],
          recordId: id,
          user
        });
        await applyHooksBeforeReturnRecord(collection, { query: query, record: records[0], user });
        return records[0];
      } else {
        setResponseStatus(event, 404);
        return __(event, "pruvious-server", "Resource not found");
      }
    }
    if (operation === "deleteMany" && collections[collection].apiRoutes.deleteMany) {
      if (collections[collection].apiRoutes.deleteMany === "private") {
        if (!user) {
          setResponseStatus(event, 401);
          return __(
            event,
            "pruvious-server",
            "Unauthorized due to either invalid credentials or missing authentication"
          );
        } else if (!user.isAdmin && !hasCapability(user, `collection-${collection}-delete-many`)) {
          setResponseStatus(event, 403);
          return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
            operate: __(event, "pruvious-server", "delete"),
            record: __(event, "pruvious-server", collections[collection].label.record.plural)
          });
        }
      }
      const params = objectPick(qs.params, ["select", "order", "populate", "where"]);
      const idSelected = params.select.includes("id");
      if (!idSelected) {
        params.select.push("id");
      }
      const query$1 = query(
        collection,
        event.context.language
      ).applyQueryStringParams(params);
      if (!user?.isAdmin) {
        const cache = {};
        for (const guard of collections[collection].guards) {
          if (isFunction(guard) || guard.onDelete) {
            try {
              await (isFunction(guard) ? guard : guard.guard)({
                _,
                __,
                cache,
                definition: collections[collection],
                language: event.context.language,
                operation: "delete",
                currentQuery: query$1,
                query: query,
                user
              });
            } catch (e) {
              setResponseStatus(event, 403);
              return e.message;
            }
          }
        }
      }
      await applyHooksBeforeDelete(collection, {
        currentQuery: query$1,
        query: query,
        user
      });
      const records = await query$1.delete();
      for (const record of records) {
        removeProtectedFields(collection, record);
        await applyHooksAfterDelete(collection, {
          query: query,
          record,
          recordId: record.id,
          user
        });
        if (!idSelected) delete record.id;
        await applyHooksBeforeReturnRecord(collection, { query: query, record, user });
      }
      return records;
    }
  }
  if (mode === "single") {
    if (subPaths.length > 1) {
      setResponseStatus(event, 404);
      return __(event, "pruvious-server", "Resource not found");
    }
    const method = event.method;
    const operation = method === "GET" ? "read" : method === "PATCH" ? "update" : null;
    const input = operation === "update" ? await readInputData(event, collection) : null;
    if (input?.errors.length) {
      setResponseStatus(event, 400);
      return input.errors.join("\n");
    }
    if (!operation) {
      setResponseStatus(event, 405);
      return __(event, "pruvious-server", "This method is not supported");
    }
    const qs = getQueryStringParams(event, collection);
    if (qs.errors.length) {
      setResponseStatus(event, 400);
      return qs.errors.join("\n");
    }
    if (operation === "read" && collections[collection].apiRoutes.read) {
      if (collections[collection].apiRoutes.read === "private") {
        if (!user) {
          setResponseStatus(event, 401);
          return __(
            event,
            "pruvious-server",
            "Unauthorized due to either invalid credentials or missing authentication"
          );
        } else if (!user.isAdmin && !hasCapability(user, `collection-${collection}-read`)) {
          setResponseStatus(event, 403);
          return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
            operate: __(event, "pruvious-server", "read"),
            record: __(event, "pruvious-server", collections[collection].label.collection.plural)
          });
        }
      }
      const params = objectPick(qs.params, ["select", "language", "populate"]);
      const idSelected = params.select.includes("id");
      if (!idSelected) {
        params.select.push("id");
      }
      const query$1 = query(collection, event.context.language).applyQueryStringParams(
        params
      );
      if (!user?.isAdmin) {
        const cache = {};
        for (const guard of collections[collection].guards) {
          if (isFunction(guard) || guard.onRead) {
            try {
              await (isFunction(guard) ? guard : guard.guard)({
                _,
                __,
                cache,
                definition: collections[collection],
                language: event.context.language,
                operation: "read",
                currentQuery: query$1,
                query: query,
                user
              });
            } catch (e) {
              setResponseStatus(event, 403);
              return e.message;
            }
          }
        }
      }
      await applyHooksBeforeRead(collection, { currentQuery: query$1, query: query, user });
      const record = await query$1.read();
      if (record) {
        removeProtectedFields(collection, record);
        await applyHooksAfterRead(collection, { query: query, record, recordId: record.id, user });
        if (!idSelected) delete record.id;
        await applyHooksBeforeReturnRecord(collection, { query: query, record, user });
        return record;
      } else {
        setResponseStatus(event, 404);
        return __(event, "pruvious-server", "Resource not found");
      }
    }
    if (operation === "update" && collections[collection].apiRoutes.update) {
      if (collections[collection].apiRoutes.update === "private") {
        if (!user) {
          setResponseStatus(event, 401);
          return __(
            event,
            "pruvious-server",
            "Unauthorized due to either invalid credentials or missing authentication"
          );
        } else if (!user.isAdmin && !hasCapability(user, `collection-${collection}-update`)) {
          setResponseStatus(event, 403);
          return __(event, "pruvious-server", "You don't have the necessary permissions to $operate $record", {
            operate: __(event, "pruvious-server", "update"),
            record: __(event, "pruvious-server", collections[collection].label.collection.plural)
          });
        }
      }
      const params = objectPick(qs.params, ["select", "language", "populate"]);
      const idSelected = params.select.includes("id");
      if (!idSelected) {
        params.select.push("id");
      }
      const query$1 = query(collection, event.context.language).applyQueryStringParams(
        params
      );
      if (!user?.isAdmin) {
        const cache = {};
        const fieldGuardErrors = {};
        for (const guard of collections[collection].guards) {
          if (isFunction(guard) || guard.onUpdate) {
            try {
              await (isFunction(guard) ? guard : guard.guard)({
                _,
                __,
                cache,
                definition: collections[collection],
                language: event.context.language,
                input: input.data,
                operation: "update",
                currentQuery: query$1,
                query: query,
                user
              });
            } catch (e) {
              setResponseStatus(event, 403);
              return e.message;
            }
          }
        }
        for (const [fieldName, field] of Object.entries(collections[collection].fields)) {
          if (isDefined(input.data[fieldName]) && field.additional?.guards) {
            for (const guard of field.additional.guards) {
              if (isFunction(guard) || guard.onUpdate) {
                try {
                  await (isFunction(guard) ? guard : guard.guard)({
                    _,
                    __,
                    cache,
                    definition: fields[field.type],
                    fields,
                    input: input.data,
                    language: event.context.language,
                    name: fieldName,
                    operation: "update",
                    options: collections[collection].fields[fieldName].options,
                    currentQuery: query$1,
                    query: query,
                    user,
                    value: input.data[fieldName]
                  });
                } catch (e) {
                  fieldGuardErrors[fieldName] = e.message;
                }
              }
            }
          }
        }
        if (Object.keys(fieldGuardErrors).length) {
          setResponseStatus(event, 403);
          return fieldGuardErrors;
        }
      }
      await applyHooksBeforeUpdate(collection, { input: input.data, currentQuery: query$1, query: query, user });
      const result = await query$1.update(input.data);
      if (result.success) {
        removeProtectedFields(collection, result.record);
        await applyHooksAfterUpdate(collection, {
          query: query,
          record: result.record,
          recordId: result.record.id,
          user
        });
        if (!idSelected) delete result.record.id;
        await applyHooksBeforeReturnRecord(collection, { query: query, record: result.record, user });
        return result.record;
      } else if (result.message) {
        setResponseStatus(event, 400);
        return result.message;
      } else {
        setResponseStatus(event, 422);
        return result.errors;
      }
    }
  }
  setResponseStatus(event, 404);
  return __(event, "pruvious-server", "Resource not found");
});
function resolveOperation(method, id, input) {
  if (method === "POST" && isNull(id)) {
    return isArray(input) ? "createMany" : "create";
  } else if (method === "GET") {
    return id ? "read" : "readMany";
  } else if (method === "PATCH") {
    return id ? "update" : "updateMany";
  } else if (method === "DELETE") {
    return id ? "delete" : "deleteMany";
  }
}
function removeProtectedFields(collection, records) {
  for (const record of toArray(records)) {
    for (const fieldName of Object.keys(record)) {
      if (collections[collection].fields[fieldName].additional?.protected) {
        delete record[fieldName];
      }
    }
  }
}

const __Vkpt6 = defineEventHandler(async (event) => {
  if (!event.context.auth.isLoggedIn) {
    setResponseStatus(event, 401);
    return __(event, "pruvious-server", "Unauthorized due to either invalid credentials or missing authentication");
  }
  if (!event.context.auth.user.isAdmin && !getCapabilities(event.context.auth.user)["clear-cache"]) {
    setResponseStatus(event, 403);
    return __(event, "pruvious-server", "Forbidden due to insufficient permissions");
  }
  const redisCache = await cache();
  const runtimeConfig = useRuntimeConfig();
  if (redisCache || g && runtimeConfig.pruvious.pageCache) {
    redisCache?.flushDb();
    await clearPageCache();
    setResponseStatus(event, 204);
    return "";
  }
  setResponseStatus(event, 404);
  return __(event, "pruvious-server", "Resource not found");
});

const additionalFields = (...fields) => {
  if (fields.length === 0) {
    throw new Error("No additional fields provided");
  }
  const res = {};
  if (fields.includes("classes")) {
    Object.assign(res, {
      addCustomClasses: {
        type: "switch",
        options: {
          label: "\u041A\u0430\u0441\u0442\u043E\u043C\u043D\u044B\u0435 \u043A\u043B\u0430\u0441\u0441\u044B",
          description: "\u041F\u043E\u0437\u0432\u043E\u043B\u044F\u0435\u0442 \u0434\u043E\u0431\u0430\u0432\u043B\u044F\u0442\u044C \u043A\u0430\u0441\u0442\u043E\u043C\u043D\u044B\u0435 \u043A\u043B\u0430\u0441\u0441\u044B \u043A \u0431\u043B\u043E\u043A\u0443",
          default: false,
          trueLabel: "\u0412\u043A\u043B.",
          falseLabel: "\u0412\u044B\u043A\u043B."
        }
      },
      customClasses: {
        type: "text",
        options: {
          label: "\u041A\u043B\u0430\u0441\u0441\u044B",
          trim: true,
          required: false
        },
        additional: {
          conditionalLogic: {
            addCustomClasses: true
          }
        }
      }
    });
  }
  if (fields.includes("styles")) {
    Object.assign(res, {
      addCustomStyles: {
        type: "switch",
        options: {
          label: "\u041A\u0430\u0441\u0442\u043E\u043C\u043D\u044B\u0435 \u0441\u0442\u0438\u043B\u0438",
          description: "\u041F\u043E\u0437\u0432\u043E\u043B\u044F\u0435\u0442 \u0434\u043E\u0431\u0430\u0432\u043B\u044F\u0442\u044C \u043A\u0430\u0441\u0442\u043E\u043C\u043D\u044B\u0435 \u0441\u0442\u0438\u043B\u0438 \u043A \u0431\u043B\u043E\u043A\u0443",
          default: false,
          trueLabel: "\u0412\u043A\u043B.",
          falseLabel: "\u0412\u044B\u043A\u043B."
        }
      },
      customStyles: {
        type: "text",
        options: {
          trim: true,
          required: false,
          label: "\u0421\u0442\u0438\u043B\u0438"
        },
        additional: {
          conditionalLogic: {
            addCustomStyles: true
          }
        }
      }
    });
  }
  if (fields.includes("responsive_control")) {
    Object.assign(res, {
      isResponsive: {
        type: "switch",
        options: {
          label: "\u0410\u0434\u0430\u043F\u0442\u0438\u0432\u043D\u043E\u0441\u0442\u044C",
          description: "\u041F\u043E\u0437\u0432\u043E\u043B\u044F\u0435\u0442 \u0443\u043F\u0440\u0430\u0432\u043B\u044F\u0442\u044C \u0432\u0438\u0434\u0438\u043C\u043E\u0441\u0442\u044C\u044E \u0431\u043B\u043E\u043A\u0430 \u043D\u0430 \u0440\u0430\u0437\u043D\u044B\u0445 \u0443\u0441\u0442\u0440\u043E\u0439\u0441\u0442\u0432\u0430\u0445",
          required: false,
          default: false,
          trueLabel: "\u0412\u043A\u043B",
          falseLabel: "\u0412\u044B\u043A\u043B"
        }
      },
      bpMode: {
        type: "select",
        additional: {
          conditionalLogic: { isResponsive: true }
        },
        options: {
          label: "\u0420\u0435\u0436\u0438\u043C \u043E\u0442\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u044F",
          required: true,
          choices: {
            ["d-sm-none $D_VALUE" /* HIDDEN_ON_SM */]: "\u0421\u043A\u0440\u044B\u0442\u044C \u043D\u0430 sm+ | \u041F\u043E\u043A\u0430\u0437\u0430\u0442\u044C \u0442\u043E\u043B\u044C\u043A\u043E \u043D\u0430 xs",
            ["d-md-none $D_VALUE" /* HIDDEN_ON_MD */]: "\u0421\u043A\u0440\u044B\u0442\u044C \u043D\u0430 md+",
            ["d-lg-none $D_VALUE" /* HIDDEN_ON_LG */]: "\u0421\u043A\u0440\u044B\u0442\u044C \u043D\u0430 lg+",
            ["d-xl-none $D_VALUE" /* HIDDEN_ON_XL */]: "\u0421\u043A\u0440\u044B\u0442\u044C \u043D\u0430 xl+",
            ["d-none d-sm-$D_VALUE" /* HIDDEN_ONLY_ON_XS */]: "\u0421\u043A\u0440\u044B\u0442\u044C \u0442\u043E\u043B\u044C\u043A\u043E \u043D\u0430 xs | \u041F\u043E\u043A\u0430\u0437\u0430\u0442\u044C \u043D\u0430 sm+",
            ["d-sm-none d-md-$D_VALUE" /* HIDDEN_ONLY_ON_SM */]: "\u0421\u043A\u0440\u044B\u0442\u044C \u0442\u043E\u043B\u044C\u043A\u043E \u043D\u0430 sm",
            ["d-md-none d-lg-$D_VALUE" /* HIDDEN_ONLY_ON_MD */]: "\u0421\u043A\u0440\u044B\u0442\u044C \u0442\u043E\u043B\u044C\u043A\u043E \u043D\u0430 md",
            ["d-lg-none d-xl-$D_VALUE" /* HIDDEN_ONLY_ON_LG */]: "\u0421\u043A\u0440\u044B\u0442\u044C \u0442\u043E\u043B\u044C\u043A\u043E \u043D\u0430 lg",
            ["d-xl-none d-xxl-$D_VALUE" /* HIDDEN_ONLY_ON_XL */]: "\u0421\u043A\u0440\u044B\u0442\u044C \u0442\u043E\u043B\u044C\u043A\u043E \u043D\u0430 xl",
            ["d-xxl-none d-$D_VALUE" /* HIDDEN_ONLY_ON_XXL */]: "\u0421\u043A\u0440\u044B\u0442\u044C \u0442\u043E\u043B\u044C\u043A\u043E \u043D\u0430 xxl",
            ["d-none" /* HIDDEN_ON_ALL */]: "\u0421\u043A\u0440\u044B\u0442\u044C \u043D\u0430 \u0432\u0441\u0435\u0445",
            ["d-$D_VALUE" /* VISIBLE_ON_ALL */]: "\u041F\u043E\u043A\u0430\u0437\u0430\u0442\u044C \u043D\u0430 \u0432\u0441\u0435\u0445",
            ["d-none d-md-$D_VALUE" /* VISIBLE_ON_MD */]: "\u041F\u043E\u043A\u0430\u0437\u0430\u0442\u044C \u043D\u0430 md+",
            ["d-none d-lg-$D_VALUE" /* VISIBLE_ON_LG */]: "\u041F\u043E\u043A\u0430\u0437\u0430\u0442\u044C \u043D\u0430 lg+",
            ["d-none d-xl-$D_VALUE" /* VISIBLE_ON_XL */]: "\u041F\u043E\u043A\u0430\u0437\u0430\u0442\u044C \u043D\u0430 xl+",
            ["d-none d-sm-$D_VALUE d-md-none" /* VISIBLE_ONLY_ON_SM */]: "\u041F\u043E\u043A\u0430\u0437\u0430\u0442\u044C \u0442\u043E\u043B\u044C\u043A\u043E \u043D\u0430 sm",
            ["d-none d-md-$D_VALUE d-lg-none" /* VISIBLE_ONLY_ON_MD */]: "\u041F\u043E\u043A\u0430\u0437\u0430\u0442\u044C \u0442\u043E\u043B\u044C\u043A\u043E \u043D\u0430 md",
            ["d-none d-lg-$D_VALUE d-xl-none" /* VISIBLE_ONLY_ON_LG */]: "\u041F\u043E\u043A\u0430\u0437\u0430\u0442\u044C \u0442\u043E\u043B\u044C\u043A\u043E \u043D\u0430 lg",
            ["d-none d-xl-$D_VALUE d-xxl-none" /* VISIBLE_ONLY_ON_XL */]: "\u041F\u043E\u043A\u0430\u0437\u0430\u0442\u044C \u0442\u043E\u043B\u044C\u043A\u043E \u043D\u0430 xl",
            ["d-none d-xxl-$D_VALUE" /* VISIBLE_ONLY_ON_XXL */]: "\u041F\u043E\u043A\u0430\u0437\u0430\u0442\u044C \u0442\u043E\u043B\u044C\u043A\u043E \u043D\u0430 xxl"
          },
          default: "d-$D_VALUE" /* VISIBLE_ON_ALL */
        }
      },
      displayValue: {
        type: "select",
        additional: {
          conditionalLogic: {
            isResponsive: true,
            bpMode: { ne: "d-none" /* HIDDEN_ON_ALL */ }
          }
        },
        options: {
          label: "\u041E\u0442\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u0435",
          required: true,
          choices: {
            "inline": "inline",
            "inline-block": "inline-block",
            "block": "block",
            "grid": "grid",
            "table": "table",
            "table-cell": "table-cell",
            "table-row": "table-row",
            "flex": "flex",
            "inline-flex": "inline-flex"
          },
          default: "block"
        }
      }
    });
  }
  return res;
};
const gutterSelectField = (field) => ({
  ...field,
  type: "select",
  options: {
    required: false,
    clearable: true,
    default: void 0,
    ...field == null ? void 0 : field.options,
    choices: {
      "0": "0",
      "1": "1",
      "2": "2",
      "3": "3",
      "4": "4",
      "5": "5"
    }
  }
});
const colsNumbersSelectField = (field) => {
  var _a, _b;
  return {
    ...field,
    type: "select",
    options: {
      required: false,
      clearable: true,
      default: void 0,
      ...field == null ? void 0 : field.options,
      choices: {
        ...((_a = field == null ? void 0 : field.options) == null ? void 0 : _a.auto) ? { auto: "auto" } : void 0,
        ...((_b = field == null ? void 0 : field.options) == null ? void 0 : _b.boolean) ? { true: "true", false: "false" } : void 0,
        "1": "1",
        "2": "2",
        "3": "3",
        "4": "4",
        "5": "5",
        "6": "6",
        "7": "7",
        "8": "8",
        "9": "9",
        "10": "10",
        "11": "11",
        "12": "12"
      }
    }
  };
};
const alignmentContentSelectField = (field) => ({
  ...field,
  type: "select",
  options: {
    required: false,
    clearable: true,
    default: void 0,
    ...void 0 ,
    choices: {
      start: "start",
      center: "center",
      end: "end",
      around: "around",
      between: "between",
      fill: "fill",
      stretch: "stretch"
    }
  }
});
const alignmentJustifyContentSelectField = (field) => ({
  ...field,
  type: "select",
  options: {
    required: false,
    clearable: true,
    default: void 0,
    ...void 0 ,
    choices: {
      start: "start",
      center: "center",
      end: "end",
      around: "around",
      between: "between",
      evenly: "evenly"
    }
  }
});
const alignmentVerticalSelectField = (field) => {
  var _a;
  return {
    ...field,
    type: "select",
    options: {
      required: false,
      clearable: true,
      default: void 0,
      ...field == null ? void 0 : field.options,
      choices: {
        ...((_a = field == null ? void 0 : field.options) == null ? void 0 : _a.auto) ? { auto: "auto" } : void 0,
        start: "start",
        center: "center",
        end: "end",
        baseline: "baseline",
        fill: "fill",
        stretch: "stretch"
      }
    }
  };
};

var _a$k;
const __defineBlock$k = {
  label: "\u0410\u043A\u043A\u043E\u0440\u0434\u0438\u043E\u043D",
  description: "\u041A\u043E\u043D\u0442\u0435\u0439\u043D\u0435\u0440 \u0434\u043B\u044F \u0430\u043A\u043A\u043E\u0440\u0434\u0438\u043E\u043D\u0430",
  fields: {
    alwaysOpen: {
      type: "switch",
      options: {
        label: "\u0412\u0441\u0435\u0433\u0434\u0430 \u043E\u0442\u043A\u0440\u044B\u0442",
        description: "\u0415\u0441\u043B\u0438 \u0443\u0441\u0442\u0430\u043D\u043E\u0432\u043B\u0435\u043D\u043E, \u043D\u0435\u0441\u043A\u043E\u043B\u044C\u043A\u043E \u0441\u0435\u043A\u0446\u0438\u0439 \u043C\u043E\u0433\u0443\u0442 \u0431\u044B\u0442\u044C \u043E\u0442\u043A\u0440\u044B\u0442\u044B \u043E\u0434\u043D\u043E\u0432\u0440\u0435\u043C\u0435\u043D\u043D\u043E",
        default: false
      }
    },
    ...additionalFields("classes", "styles")
  },
  slots: {
    default: {
      label: "\u0421\u043E\u0434\u0435\u0440\u0436\u0438\u043C\u043E\u0435",
      allowedChildBlocks: ["AccordionItemBlock"]
    }
  }
};
const __defineProps$k = {};
const __defineBlockFields$k = __defineBlock$k["fields"] || {};
const __definePropsFields$k = Object.fromEntries(Object.entries(__defineProps$k).filter(([_, prop]) => prop.__fromDefineProps));
const __export$k = {
  name: "AccordionBlock",
  label: __defineBlock$k.label,
  fields: { ...__defineBlockFields$k, ...__definePropsFields$k },
  slots: (_a$k = __defineBlock$k.slots) != null ? _a$k : {},
  description: __defineBlock$k.description,
  icon: __defineBlock$k.icon || "Components"
};

var _a$j;
const __defineBlock$j = {
  label: "\u041A\u043E\u043C\u043F\u043E\u043D\u0435\u043D\u0442 \u0430\u043A\u043A\u043E\u0440\u0434\u0438\u043E\u043D\u0430",
  description: "\u041A\u043E\u043C\u043F\u043E\u043D\u0435\u043D\u0442 \u0430\u043A\u043A\u043E\u0440\u0434\u0438\u043E\u043D\u0430",
  fields: {
    ...additionalFields("classes", "styles")
  },
  slots: {
    default: {
      label: "\u0421\u043E\u0434\u0435\u0440\u0436\u0438\u043C\u043E\u0435",
      allowedChildBlocks: ["HTMLBlock", "RichTextBlock", "BadgeBlock", "ImageBlock", "ContainerBlock", "LinkBlock", "IconBlock", "AlertBlock"]
    },
    title: {
      label: "\u0417\u0430\u0433\u043E\u043B\u043E\u0432\u043E\u043A",
      allowedChildBlocks: ["HTMLBlock"]
    }
  }
};
const __defineProps$j = {};
const __defineBlockFields$j = __defineBlock$j["fields"] || {};
const __definePropsFields$j = Object.fromEntries(Object.entries(__defineProps$j).filter(([_, prop]) => prop.__fromDefineProps));
const __export$j = {
  name: "AccordionItemBlock",
  label: __defineBlock$j.label,
  fields: { ...__defineBlockFields$j, ...__definePropsFields$j },
  slots: (_a$j = __defineBlock$j.slots) != null ? _a$j : {},
  description: __defineBlock$j.description,
  icon: __defineBlock$j.icon || "Components"
};

var _a$i;
const __defineBlock$i = {
  label: "Alert",
  description: "\u041A\u043E\u043D\u0442\u0435\u0439\u043D\u0435\u0440 \u0434\u043B\u044F alert",
  fields: {
    variant: {
      type: "select",
      options: {
        label: "\u0421\u0442\u0438\u043B\u044C",
        description: "\u0421\u0442\u0438\u043B\u044C alert",
        required: true,
        choices: {
          primary: "primary",
          secondary: "secondary",
          success: "success",
          danger: "danger",
          warning: "warning",
          info: "info",
          light: "light",
          dark: "dark"
        }
      }
    },
    dismissible: {
      type: "switch",
      options: {
        label: "\u0417\u0430\u043A\u0440\u044B\u0432\u0430\u0435\u043C\u044B\u0439",
        description: "\u0415\u0441\u043B\u0438 \u0443\u0441\u0442\u0430\u043D\u043E\u0432\u043B\u0435\u043D\u043E, alert \u0431\u0443\u0434\u0435\u0442 \u0437\u0430\u043A\u0440\u044B\u0432\u0430\u0442\u044C\u0441\u044F \u043F\u043E \u043A\u043B\u0438\u043A\u0443",
        default: false
      }
    },
    ...additionalFields("classes", "styles")
  },
  slots: {
    default: {
      label: "\u0421\u043E\u0434\u0435\u0440\u0436\u0438\u043C\u043E\u0435",
      allowedChildBlocks: ["HTMLBlock", "RichTextBlock", "BadgeBlock", "IconBlock", "ImageBlock", "LinkBlock", "AccordionBlock"]
    }
  }
};
const __defineProps$i = {};
const __defineBlockFields$i = __defineBlock$i["fields"] || {};
const __definePropsFields$i = Object.fromEntries(Object.entries(__defineProps$i).filter(([_, prop]) => prop.__fromDefineProps));
const __export$i = {
  name: "AlertBlock",
  label: __defineBlock$i.label,
  fields: { ...__defineBlockFields$i, ...__definePropsFields$i },
  slots: (_a$i = __defineBlock$i.slots) != null ? _a$i : {},
  description: __defineBlock$i.description,
  icon: __defineBlock$i.icon || "Components"
};

var _a$h;
const __defineBlock$h = {
  label: "\u0417\u043D\u0430\u0447\u043E\u043A",
  description: "\u0417\u043D\u0430\u0447\u043E\u043A",
  fields: {
    type: {
      type: "select",
      options: {
        label: "\u0422\u0438\u043F",
        description: "\u0422\u0438\u043F \u0437\u043D\u0430\u0447\u043A\u0430",
        required: true,
        choices: {
          "default": "\u041E\u0431\u044B\u0447\u043D\u044B\u0439",
          "pill": "\u0422\u0430\u0431\u043B\u0435\u0442\u043A\u0430",
          "dot-indicator": "\u041A\u0440\u0443\u0436\u043E\u043A"
        }
      }
    },
    variant: {
      type: "select",
      options: {
        label: "\u0421\u0442\u0438\u043B\u044C",
        description: "\u0421\u0442\u0438\u043B\u044C \u0437\u043D\u0430\u0447\u043A\u0430",
        required: true,
        choices: {
          primary: "primary",
          secondary: "secondary",
          success: "success",
          danger: "danger",
          warning: "warning",
          info: "info",
          light: "light",
          dark: "dark"
        }
      }
    },
    ...additionalFields("classes", "styles")
  },
  slots: {
    default: {
      label: "\u0421\u043E\u0434\u0435\u0440\u0436\u0438\u043C\u043E\u0435"
    }
  }
};
const __defineProps$h = {};
const __defineBlockFields$h = __defineBlock$h["fields"] || {};
const __definePropsFields$h = Object.fromEntries(Object.entries(__defineProps$h).filter(([_, prop]) => prop.__fromDefineProps));
const __export$h = {
  name: "BadgeBlock",
  label: __defineBlock$h.label,
  fields: { ...__defineBlockFields$h, ...__definePropsFields$h },
  slots: (_a$h = __defineBlock$h.slots) != null ? _a$h : {},
  description: __defineBlock$h.description,
  icon: __defineBlock$h.icon || "Components"
};

var _a$g;
const __defineBlock$g = {
  label: "\u041A\u0430\u0440\u0443\u0441\u0435\u043B\u044C",
  slots: {
    default: {
      label: "\u0421\u043B\u0430\u0439\u0434\u044B",
      allowedChildBlocks: ["CarouselSlideBlock"]
    }
  },
  fields: {
    navigation: {
      type: "switch",
      options: {
        label: "\u041D\u0430\u0432\u0438\u0433\u0430\u0446\u0438\u044F",
        description: "\u0412\u043A\u043B\u044E\u0447\u0430\u0435\u0442 \u043D\u0430\u0432\u0438\u0433\u0430\u0446\u0438\u044E \u043F\u043E \u0441\u043B\u0430\u0439\u0434\u0430\u043C",
        default: true,
        trueLabel: "\u0412\u043A\u043B.",
        falseLabel: "\u0412\u044B\u043A\u043B."
      }
    },
    pagination: {
      type: "switch",
      options: {
        label: "\u041F\u0430\u0433\u0438\u043D\u0430\u0446\u0438\u044F",
        description: "\u0412\u043A\u043B\u044E\u0447\u0430\u0435\u0442 \u043F\u0430\u0433\u0438\u043D\u0430\u0446\u0438\u044E \u0441\u043B\u0430\u0439\u0434\u043E\u0432",
        default: true,
        trueLabel: "\u0412\u043A\u043B.",
        falseLabel: "\u0412\u044B\u043A\u043B."
      }
    },
    height: {
      type: "number",
      options: {
        label: "\u0412\u044B\u0441\u043E\u0442\u0430 \u041A\u0430\u0440\u0443\u0441\u0435\u043B\u0438",
        description: "\u0412\u044B\u0441\u043E\u0442\u0430 \u043A\u0430\u0440\u0443\u0441\u0435\u043B\u0438 \u0432 \u043F\u0438\u043A\u0441\u0435\u043B\u044F\u0445",
        default: 680,
        min: 100,
        required: true
      }
    },
    itemsToShow: {
      type: "number",
      options: {
        label: "\u041A\u043E\u043B\u0438\u0447\u0435\u0441\u0442\u0432\u043E \u0421\u043B\u0430\u0439\u0434\u043E\u0432",
        description: "\u041A\u043E\u043B\u0438\u0447\u0435\u0441\u0442\u0432\u043E \u0441\u043B\u0430\u0439\u0434\u043E\u0432, \u043E\u0442\u043E\u0431\u0440\u0430\u0436\u0430\u0435\u043C\u044B\u0445 \u043E\u0434\u043D\u043E\u0432\u0440\u0435\u043C\u0435\u043D\u043D\u043E",
        decimals: 0,
        default: 1,
        min: 1,
        step: 1,
        required: true
      }
    },
    itemsToScroll: {
      type: "number",
      options: {
        label: "\u041A\u043E\u043B\u0438\u0447\u0435\u0441\u0442\u0432\u043E \u0441\u043B\u0430\u0439\u0434\u043E\u0432 \u043F\u0440\u0438 \u043F\u0440\u043E\u043A\u0440\u0443\u0442\u043A\u0435",
        description: "\u041A\u043E\u043B\u0438\u0447\u0435\u0441\u0442\u0432\u043E \u0441\u043B\u0430\u0439\u0434\u043E\u0432, \u043F\u0440\u043E\u043A\u0440\u0443\u0447\u0438\u0432\u0430\u0435\u043C\u044B\u0445 \u043F\u0440\u0438 \u043A\u0430\u0436\u0434\u043E\u043C \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0438 \u043D\u0430\u0432\u0438\u0433\u0430\u0446\u0438\u0438",
        decimals: 0,
        default: 1,
        min: 1,
        step: 1
      },
      additional: {
        conditionalLogic: {
          itemsToShow: {
            gt: 1
          }
        }
        // only show if itemsToShow is > 1
      }
    },
    gap: {
      type: "number",
      options: {
        label: "\u041F\u0440\u043E\u043C\u0435\u0436\u0443\u0442\u043E\u043A \u043C\u0435\u0436\u0434\u0443 \u0421\u043B\u0430\u0439\u0434\u0430\u043C\u0438",
        description: "\u041F\u0440\u043E\u043C\u0435\u0436\u0443\u0442\u043E\u043A \u043C\u0435\u0436\u0434\u0443 \u0441\u043B\u0430\u0439\u0434\u0430\u043C\u0438 \u0432 \u043F\u0438\u043A\u0441\u0435\u043B\u044F\u0445",
        default: 5,
        min: 0,
        max: 100,
        step: 1
      },
      additional: {
        conditionalLogic: {
          itemsToShow: {
            gt: 1
          }
        }
        // only show if itemsToShow is > 1
      }
    },
    snapAlign: {
      type: "select",
      options: {
        label: "\u0412\u044B\u0440\u0430\u0432\u043D\u0438\u0432\u0430\u043D\u0438\u0435 \u0441\u043B\u0430\u0439\u0434\u043E\u0432",
        description: "\u041E\u043F\u0440\u0435\u0434\u0435\u043B\u044F\u0435\u0442, \u043A\u0430\u043A \u0441\u043B\u0430\u0439\u0434\u044B \u0432\u044B\u0440\u0430\u0432\u043D\u0438\u0432\u0430\u044E\u0442\u0441\u044F \u043E\u0442\u043D\u043E\u0441\u0438\u0442\u0435\u043B\u044C\u043D\u043E \u043A\u0430\u0440\u0443\u0441\u0435\u043B\u0438",
        choices: {
          "start": "\u041D\u0430\u0447\u0430\u043B\u043E",
          "center": "\u0426\u0435\u043D\u0442\u0440",
          "end": "\u041A\u043E\u043D\u0435\u0446",
          "center-odd": "\u0426\u0435\u043D\u0442\u0440 (\u043D\u0435\u0447\u0435\u0442\u043D\u044B\u0435)",
          "center-even": "\u0426\u0435\u043D\u0442\u0440 (\u0447\u0435\u0442\u043D\u044B\u0435)"
        },
        default: "center"
      },
      additional: {
        conditionalLogic: {
          itemsToShow: {
            gt: 1
          }
        }
        // only show if itemsToShow is > 1
      }
    },
    dir: {
      type: "select",
      options: {
        label: "\u041D\u0430\u043F\u0440\u0430\u0432\u043B\u0435\u043D\u0438\u0435",
        description: "\u041D\u0430\u043F\u0440\u0430\u0432\u043B\u0435\u043D\u0438\u0435 \u043F\u0440\u043E\u043A\u0440\u0443\u0442\u043A\u0438 \u0441\u043B\u0430\u0439\u0434\u043E\u0432",
        default: "ltr",
        choices: {
          ltr: "\u0421\u043B\u0435\u0432\u0430 \u043D\u0430\u043F\u0440\u0430\u0432\u043E",
          rtl: "\u0421\u043F\u0440\u0430\u0432\u0430 \u043D\u0430\u043B\u0435\u0432\u043E",
          ttb: "\u0421\u0432\u0435\u0440\u0445\u0443 \u0432\u043D\u0438\u0437",
          btt: "\u0421\u043D\u0438\u0437\u0443 \u0432\u0432\u0435\u0440\u0445"
        }
      }
    },
    autoplay: {
      type: "switch",
      options: {
        label: "\u0412\u043A\u043B\u044E\u0447\u0438\u0442\u044C \u0410\u0432\u0442\u043E\u043F\u0440\u043E\u043A\u0440\u0443\u0442\u043A\u0443",
        description: "\u0412\u043A\u043B\u044E\u0447\u0430\u0435\u0442 \u0430\u0432\u0442\u043E\u043C\u0430\u0442\u0438\u0447\u0435\u0441\u043A\u0443\u044E \u043F\u0440\u043E\u043A\u0440\u0443\u0442\u043A\u0443 \u0441\u043B\u0430\u0439\u0434\u043E\u0432",
        default: false,
        trueLabel: "\u0412\u043A\u043B.",
        falseLabel: "\u0412\u044B\u043A\u043B."
      }
    },
    autoplayDelay: {
      type: "number",
      options: {
        label: "\u0410\u0432\u0442\u043E\u043F\u0440\u043E\u043A\u0440\u0443\u0442\u043A\u0430",
        description: "\u0412\u0440\u0435\u043C\u044F \u0432 \u043C\u0438\u043B\u043B\u0438\u0441\u0435\u043A\u0443\u043D\u0434\u0430\u0445 \u043C\u0435\u0436\u0434\u0443 \u0441\u043C\u0435\u043D\u043E\u0439 \u0441\u043B\u0430\u0439\u0434\u043E\u0432",
        decimals: 0,
        default: 4e3,
        min: 500,
        step: 500
      },
      additional: {
        conditionalLogic: {
          autoplay: true
        }
      }
    },
    wrapAround: {
      type: "switch",
      options: {
        label: "\u0417\u0430\u0446\u0438\u043A\u043B\u0438\u0432\u0430\u043D\u0438\u0435",
        description: "\u0412\u043A\u043B\u044E\u0447\u0430\u0435\u0442 \u0437\u0430\u0446\u0438\u043A\u043B\u0438\u0432\u0430\u043D\u0438\u0435 \u043A\u0430\u0440\u0443\u0441\u0435\u043B\u0438",
        default: true,
        trueLabel: "\u0412\u043A\u043B.",
        falseLabel: "\u0412\u044B\u043A\u043B."
      },
      additional: {
        conditionalLogic: {
          autoplay: true
        }
      }
    },
    pauseAutoplayOnHover: {
      type: "switch",
      options: {
        label: "\u041F\u0430\u0443\u0437\u0430 \u043F\u0440\u0438 \u043D\u0430\u0432\u0435\u0434\u0435\u043D\u0438\u0438",
        description: "\u041E\u0441\u0442\u0430\u043D\u0430\u0432\u043B\u0438\u0432\u0430\u0435\u0442 \u0430\u0432\u0442\u043E\u043F\u0440\u043E\u043A\u0440\u0443\u0442\u043A\u0443 \u043F\u0440\u0438 \u043D\u0430\u0432\u0435\u0434\u0435\u043D\u0438\u0438 \u043D\u0430 \u043A\u0430\u0440\u0443\u0441\u0435\u043B\u044C",
        default: true,
        trueLabel: "\u0412\u043A\u043B.",
        falseLabel: "\u0412\u044B\u043A\u043B."
      },
      additional: {
        conditionalLogic: {
          autoplay: true
        }
      }
    },
    mouseWheel: {
      type: "switch",
      options: {
        label: "\u041F\u0440\u043E\u043A\u0440\u0443\u0442\u043A\u0430 \u043C\u044B\u0448\u044C\u044E",
        description: "\u0412\u043A\u043B\u044E\u0447\u0430\u0435\u0442 \u043F\u0440\u043E\u043A\u0440\u0443\u0442\u043A\u0443 \u043A\u0430\u0440\u0443\u0441\u0435\u043B\u0438 \u0441 \u043F\u043E\u043C\u043E\u0449\u044C\u044E \u043A\u043E\u043B\u0435\u0441\u0430 \u043C\u044B\u0448\u0438",
        default: false,
        trueLabel: "\u0412\u043A\u043B.",
        falseLabel: "\u0412\u044B\u043A\u043B."
      }
    },
    mouseDrag: {
      type: "switch",
      options: {
        label: "\u041F\u0435\u0440\u0435\u0442\u0430\u0441\u043A\u0438\u0432\u0430\u043D\u0438\u0435 \u043C\u044B\u0448\u044C\u044E",
        description: "\u0412\u043A\u043B\u044E\u0447\u0430\u0435\u0442 \u043F\u0435\u0440\u0435\u0442\u0430\u0441\u043A\u0438\u0432\u0430\u043D\u0438\u0435 \u0441\u043B\u0430\u0439\u0434\u043E\u0432 \u043C\u044B\u0448\u044C\u044E",
        default: true,
        trueLabel: "\u0412\u043A\u043B.",
        falseLabel: "\u0412\u044B\u043A\u043B."
      }
    },
    mouseDragThreshold: {
      type: "number",
      options: {
        label: "\u041F\u043E\u0440\u043E\u0433 \u043F\u0435\u0440\u0435\u0442\u0430\u0441\u043A\u0438\u0432\u0430\u043D\u0438\u044F \u043C\u044B\u0448\u044C\u044E",
        description: "\u041C\u0438\u043D\u0438\u043C\u0430\u043B\u044C\u043D\u043E\u0435 \u0440\u0430\u0441\u0441\u0442\u043E\u044F\u043D\u0438\u0435 \u0432 \u0434\u0435\u0441\u044F\u0442\u0438\u0447\u043D\u043E\u0439 \u0434\u0440\u043E\u0431\u0438 \u0434\u043B\u044F \u043D\u0430\u0447\u0430\u043B\u0430 \u043F\u0435\u0440\u0435\u0442\u0430\u0441\u043A\u0438\u0432\u0430\u043D\u0438\u044F \u043C\u044B\u0448\u044C\u044E",
        decimals: 2,
        default: 0.3,
        min: 0,
        max: 1,
        step: 0.1
      },
      additional: {
        conditionalLogic: {
          mouseDrag: true
        }
      }
    },
    touchDrag: {
      type: "switch",
      options: {
        label: "\u041F\u0435\u0440\u0435\u0442\u0430\u0441\u043A\u0438\u0432\u0430\u043D\u0438\u0435 \u043A\u0430\u0441\u0430\u043D\u0438\u0435\u043C",
        description: "\u0412\u043A\u043B\u044E\u0447\u0430\u0435\u0442 \u043F\u0435\u0440\u0435\u0442\u0430\u0441\u043A\u0438\u0432\u0430\u043D\u0438\u0435 \u0441\u043B\u0430\u0439\u0434\u043E\u0432 \u0441 \u043F\u043E\u043C\u043E\u0449\u044C\u044E \u043A\u0430\u0441\u0430\u043D\u0438\u044F",
        default: true,
        trueLabel: "\u0412\u043A\u043B.",
        falseLabel: "\u0412\u044B\u043A\u043B."
      }
    },
    touchDragThreshold: {
      type: "number",
      options: {
        label: "\u041F\u043E\u0440\u043E\u0433 \u043F\u0435\u0440\u0435\u0442\u0430\u0441\u043A\u0438\u0432\u0430\u043D\u0438\u044F \u043A\u0430\u0441\u0430\u043D\u0438\u0435\u043C",
        description: "\u041C\u0438\u043D\u0438\u043C\u0430\u043B\u044C\u043D\u043E\u0435 \u0440\u0430\u0441\u0441\u0442\u043E\u044F\u043D\u0438\u0435 \u0432 \u0434\u0435\u0441\u044F\u0442\u0438\u0447\u043D\u043E\u0439 \u0434\u0440\u043E\u0431\u0438 \u0434\u043B\u044F \u043D\u0430\u0447\u0430\u043B\u0430 \u043F\u0435\u0440\u0435\u0442\u0430\u0441\u043A\u0438\u0432\u0430\u043D\u0438\u044F \u043A\u0430\u0441\u0430\u043D\u0438\u0435\u043C",
        decimals: 2,
        default: 0.3,
        min: 0,
        max: 1,
        step: 0.1
      },
      additional: {
        conditionalLogic: {
          touchDrag: true
        }
      }
    },
    preventExcessiveDragging: {
      type: "switch",
      options: {
        label: "\u041F\u0440\u0435\u0434\u043E\u0442\u0432\u0440\u0430\u0449\u0435\u043D\u0438\u0435 \u0447\u0440\u0435\u0437\u043C\u0435\u0440\u043D\u043E\u0433\u043E \u043F\u0435\u0440\u0435\u0442\u0430\u0441\u043A\u0438\u0432\u0430\u043D\u0438\u044F",
        description: "\u0417\u0430\u043F\u0440\u0435\u0449\u0430\u0435\u0442 \u043F\u0435\u0440\u0435\u0442\u0430\u0441\u043A\u0438\u0432\u0430\u043D\u0438\u0435 \u0441\u043B\u0430\u0439\u0434\u043E\u0432 \u043F\u043E\u0431\u043B\u0438\u0437\u043E\u0441\u0442\u0438 \u043A \u043A\u0440\u0430\u044F\u043C \u043A\u0430\u0440\u0443\u0441\u0435\u043B\u0438",
        default: false,
        trueLabel: "\u0412\u043A\u043B.",
        falseLabel: "\u0412\u044B\u043A\u043B."
      }
    },
    slideEffect: {
      type: "select",
      options: {
        label: "\u042D\u0444\u0444\u0435\u043A\u0442 \u043F\u0435\u0440\u0435\u0445\u043E\u0434\u0430 \u043C\u0435\u0436\u0434\u0443 \u0441\u043B\u0430\u0439\u0434\u0430\u043C\u0438",
        choices: {
          slide: "\u0421\u0434\u0432\u0438\u0433",
          fade: "\u0417\u0430\u0442\u0443\u0445\u0430\u043D\u0438\u0435"
        },
        default: "slide"
      }
    },
    transition: {
      type: "number",
      options: {
        label: "\u041F\u043B\u0430\u0432\u043D\u043E\u0441\u0442\u044C \u043F\u0435\u0440\u0435\u0445\u043E\u0434\u0430",
        description: "\u0412\u0440\u0435\u043C\u044F \u0432 \u043C\u0438\u043B\u043B\u0438\u0441\u0435\u043A\u0443\u043D\u0434\u0430\u0445 \u0434\u043B\u044F \u043F\u043B\u0430\u0432\u043D\u043E\u0433\u043E \u043F\u0435\u0440\u0435\u0445\u043E\u0434\u0430 \u043C\u0435\u0436\u0434\u0443 \u0441\u043B\u0430\u0439\u0434\u0430\u043C\u0438",
        decimals: 0,
        default: 300,
        min: 100,
        step: 100
      }
    },
    ...additionalFields("classes", "styles", "responsive_control")
  }
};
const __defineProps$g = {};
const __defineBlockFields$g = __defineBlock$g["fields"] || {};
const __definePropsFields$g = Object.fromEntries(Object.entries(__defineProps$g).filter(([_, prop]) => prop.__fromDefineProps));
const __export$g = {
  name: "CarouselBlock",
  label: __defineBlock$g.label,
  fields: { ...__defineBlockFields$g, ...__definePropsFields$g },
  slots: (_a$g = __defineBlock$g.slots) != null ? _a$g : {},
  description: __defineBlock$g.description || "",
  icon: __defineBlock$g.icon || "Components"
};

var _a$f;
const __defineBlock$f = {
  label: "\u0421\u043B\u0430\u0439\u0434 \u041A\u0430\u0440\u0443\u0441\u0435\u043B\u0438",
  description: "\u0414\u043E\u0431\u0430\u0432\u043B\u0435\u043D\u0438\u0435 \u0441\u043B\u0430\u0439\u0434\u043E\u0432 \u0432 \u043A\u0430\u0440\u0443\u0441\u0435\u043B\u044C. \u041A\u0430\u0436\u0434\u044B\u0439 \u0441\u043B\u0430\u0439\u0434 \u0434\u043E\u043B\u0436\u0435\u043D \u0431\u044B\u0442\u044C \u043E\u043F\u0440\u0435\u0434\u0435\u043B\u0435\u043D \u0432 \u043E\u0442\u0434\u0435\u043B\u044C\u043D\u043E\u043C \u0431\u043B\u043E\u043A\u0435.",
  slots: {
    default: {
      allowedChildBlocks: ["CarouselSlideContentBlock"]
    }
  }
};
const __defineProps$f = {};
const __defineBlockFields$f = __defineBlock$f["fields"] || {};
const __definePropsFields$f = Object.fromEntries(Object.entries(__defineProps$f).filter(([_, prop]) => prop.__fromDefineProps));
const __export$f = {
  name: "CarouselSlideBlock",
  label: __defineBlock$f.label,
  fields: { ...__defineBlockFields$f, ...__definePropsFields$f },
  slots: (_a$f = __defineBlock$f.slots) != null ? _a$f : {},
  description: __defineBlock$f.description,
  icon: __defineBlock$f.icon || "Components"
};

var _a$e;
const __defineBlock$e = {
  label: "\u041A\u043E\u043D\u0442\u0435\u043D\u0442 \u0421\u043B\u0430\u0439\u0434\u0430",
  slots: {
    default: {
      allowedChildBlocks: ["ImageBlock", "RichTextBlock", "HTMLBlock", "AccordionBlock", "ContainerBlock", "IconBlock", "LinkBlock", "ListGroupBlock", "AlertBlock", "BadgeBlock", "Preset"]
    }
  },
  fields: {
    img: {
      type: "image",
      options: {
        label: "\u0418\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u0435",
        required: false,
        sources: [{
          format: "webp"
        }, {
          format: "png"
        }]
      }
    },
    imgSize: {
      type: "select",
      options: {
        label: "\u0420\u0430\u0437\u043C\u0435\u0440 \u0438\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u044F",
        choices: {
          cover: "cover",
          contain: "contain"
        },
        required: false,
        clearable: true
      },
      additional: {
        conditionalLogic: {
          img: {
            ne: null
          }
        }
      }
    },
    imgPosition: {
      type: "select",
      options: {
        label: "\u041F\u043E\u0437\u0438\u0446\u0438\u044F \u0438\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u044F",
        choices: {
          "top left": "top left",
          "top center": "top center",
          "top right": "top right",
          "center left": "center left",
          "center center": "center center",
          "center right": "center right",
          "bottom left": "bottom left",
          "bottom center": "bottom center",
          "bottom right": "bottom right"
        },
        required: false,
        default: "center center"
      },
      additional: {
        conditionalLogic: {
          img: {
            ne: null
          }
        }
      }
    },
    imgRepeat: {
      type: "select",
      options: {
        label: "\u041F\u043E\u0432\u0442\u043E\u0440 \u0438\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u044F",
        choices: {
          "no-repeat": "no-repeat",
          "repeat": "repeat",
          "repeat-x": "repeat-x",
          "repeat-y": "repeat-y"
        },
        required: false,
        default: "no-repeat"
      },
      additional: {
        conditionalLogic: {
          img: {
            ne: null
          }
        }
      }
    },
    ...additionalFields("responsive_control")
  }
};
const __defineProps$e = {};
const __defineBlockFields$e = __defineBlock$e["fields"] || {};
const __definePropsFields$e = Object.fromEntries(Object.entries(__defineProps$e).filter(([_, prop]) => prop.__fromDefineProps));
const __export$e = {
  name: "CarouselSlideContentBlock",
  label: __defineBlock$e.label,
  fields: { ...__defineBlockFields$e, ...__definePropsFields$e },
  slots: (_a$e = __defineBlock$e.slots) != null ? _a$e : {},
  description: __defineBlock$e.description || "",
  icon: __defineBlock$e.icon || "Components"
};

var _a$d;
const __defineBlock$d = {
  label: "\u041A\u043E\u043D\u0442\u0435\u0439\u043D\u0435\u0440",
  slots: {
    default: {
      label: "\u041A\u043E\u043D\u0442\u0435\u043D\u0442",
      allowedChildBlocks: ["ContainerRowBlock"]
    }
  },
  fields: {
    fluid: {
      type: "select",
      options: {
        label: "fluid",
        choices: {
          "*": "*",
          "sm": "sm",
          "md": "md",
          "lg": "lg",
          "xl": "xl",
          "xxl": "xxl"
        },
        required: false,
        clearable: true
      }
    },
    gutterX: gutterSelectField(),
    gutterY: gutterSelectField(),
    ...additionalFields("classes", "styles", "responsive_control")
  }
};
const __defineProps$d = {};
const __defineBlockFields$d = __defineBlock$d["fields"] || {};
const __definePropsFields$d = Object.fromEntries(Object.entries(__defineProps$d).filter(([_, prop]) => prop.__fromDefineProps));
const __export$d = {
  name: "ContainerBlock",
  label: __defineBlock$d.label,
  fields: { ...__defineBlockFields$d, ...__definePropsFields$d },
  slots: (_a$d = __defineBlock$d.slots) != null ? _a$d : {},
  description: __defineBlock$d.description || "",
  icon: __defineBlock$d.icon || "Components"
};

var _a$c;
const __defineBlock$c = {
  label: "\u0421\u0442\u0440\u043E\u043A\u0430",
  slots: {
    default: {
      label: "\u041A\u043E\u043D\u0442\u0435\u043D\u0442",
      allowedChildBlocks: ["RowColBlock"]
    }
  },
  fields: {
    noGutters: {
      type: "checkbox",
      options: {
        required: false,
        label: "no-gutters",
        description: "\u0423\u0431\u0438\u0440\u0430\u0435\u0442 \u0433\u043E\u0440\u0438\u0437\u043E\u043D\u0442\u0430\u043B\u044C\u043D\u044B\u0435 \u0438 \u0432\u0435\u0440\u0442\u0438\u043A\u0430\u043B\u044C\u043D\u044B\u0435 \u043E\u0442\u0441\u0442\u0443\u043F\u044B \u043C\u0435\u0436\u0434\u0443 \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430\u043C\u0438"
      }
    },
    gutterX: gutterSelectField({
      additional: {
        conditionalLogic: {
          noGutters: {
            ne: true
          }
        }
      }
    }),
    gutterY: gutterSelectField({
      additional: {
        conditionalLogic: {
          noGutters: {
            ne: true
          }
        }
      }
    }),
    cols: colsNumbersSelectField(),
    colsSm: colsNumbersSelectField(),
    colsMd: colsNumbersSelectField(),
    colsLg: colsNumbersSelectField(),
    colsXl: colsNumbersSelectField(),
    colsXxl: colsNumbersSelectField(),
    alignContent: alignmentContentSelectField(),
    alignH: alignmentJustifyContentSelectField(),
    alignV: alignmentVerticalSelectField(),
    ...additionalFields("classes", "styles", "responsive_control")
  }
};
const __defineProps$c = {};
const __defineBlockFields$c = __defineBlock$c["fields"] || {};
const __definePropsFields$c = Object.fromEntries(Object.entries(__defineProps$c).filter(([_, prop]) => prop.__fromDefineProps));
const __export$c = {
  name: "ContainerRowBlock",
  label: __defineBlock$c.label,
  fields: { ...__defineBlockFields$c, ...__definePropsFields$c },
  slots: (_a$c = __defineBlock$c.slots) != null ? _a$c : {},
  description: __defineBlock$c.description || "",
  icon: __defineBlock$c.icon || "Components"
};

var _a$b;
const __defineBlock$b = {
  label: "\u0424\u043E\u0440\u043C\u0430",
  fields: {
    form: {
      type: "record",
      options: {
        collection: "forms",
        fields: {
          id: true,
          title: true,
          description: true,
          fields: true
        },
        populate: true,
        label: "\u0412\u044B\u0431\u0440\u0430\u043D\u043D\u0430\u044F \u0444\u043E\u0440\u043C\u0430",
        description: "\u0412\u044B\u0431\u0440\u0430\u043D\u043D\u0430\u044F \u0444\u043E\u0440\u043C\u0430.",
        required: true
      }
    },
    showTitle: {
      type: "switch",
      options: {
        label: "\u041F\u043E\u043A\u0430\u0437\u044B\u0432\u0430\u0442\u044C \u0437\u0430\u0433\u043E\u043B\u043E\u0432\u043E\u043A \u0444\u043E\u0440\u043C\u044B",
        description: "",
        default: true,
        falseLabel: "\u041D\u0435\u0442",
        trueLabel: "\u0414\u0430"
      }
    },
    showDescription: {
      type: "switch",
      options: {
        label: "\u041F\u043E\u043A\u0430\u0437\u044B\u0432\u0430\u0442\u044C \u043E\u043F\u0438\u0441\u0430\u043D\u0438\u0435 \u0444\u043E\u0440\u043C\u044B",
        description: "",
        default: true,
        falseLabel: "\u041D\u0435\u0442",
        trueLabel: "\u0414\u0430"
      }
    },
    onSubmit: {
      type: "select",
      options: {
        label: "\u041F\u043E\u0441\u043B\u0435 \u043E\u0442\u043F\u0440\u0430\u0432\u043A\u0438",
        description: "\u0427\u0442\u043E \u0434\u0435\u043B\u0430\u0442\u044C \u043F\u043E\u0441\u043B\u0435 \u043E\u0442\u043F\u0440\u0430\u0432\u043A\u0438 \u0444\u043E\u0440\u043C\u044B",
        choices: {
          reset: "\u0421\u0431\u0440\u043E\u0441\u0438\u0442\u044C \u0444\u043E\u0440\u043C\u0443",
          redirect: "\u041F\u0435\u0440\u0435\u043D\u0430\u043F\u0440\u0430\u0432\u0438\u0442\u044C \u043D\u0430 \u0434\u0440\u0443\u0433\u0443\u044E \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0443",
          none: "\u041D\u0438\u0447\u0435\u0433\u043E \u043D\u0435 \u0434\u0435\u043B\u0430\u0442\u044C"
        },
        default: "reset"
      }
    },
    redirectTo: {
      type: "link",
      options: {
        label: "\u041F\u0435\u0440\u0435\u043D\u0430\u043F\u0440\u0430\u0432\u043B\u0435\u043D\u0438\u0435",
        description: "\u041F\u0435\u0440\u0435\u043D\u0430\u043F\u0440\u0430\u0432\u043B\u0435\u043D\u0438\u0435 \u043D\u0430 \u0434\u0440\u0443\u0433\u0443\u044E \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0443 \u043F\u043E\u0441\u043B\u0435 \u043E\u0442\u043F\u0440\u0430\u0432\u043A\u0438 \u0444\u043E\u0440\u043C\u044B",
        placeholder: "/index"
      },
      additional: {
        conditionalLogic: {
          onSubmit: "redirect"
        }
      }
    },
    btnLabel: {
      type: "text",
      options: {
        label: "\u0422\u0435\u043A\u0441\u0442 \u043A\u043D\u043E\u043F\u043A\u0438",
        default: "\u041E\u0442\u043F\u0440\u0430\u0432\u0438\u0442\u044C",
        required: true
      }
    },
    btnClass: {
      type: "text",
      options: {
        label: "\u041A\u043B\u0430\u0441\u0441 \u043A\u043D\u043E\u043F\u043A\u0438",
        default: "mt-4 btn-primary text-white",
        placeholder: "mt-4 btn-primary text-white"
      }
    },
    btnStyle: {
      type: "text",
      options: {
        label: "\u0421\u0442\u0438\u043B\u044C \u043A\u043D\u043E\u043F\u043A\u0438",
        placeholder: "color: red;"
      }
    },
    showAlert: {
      type: "switch",
      options: {
        label: "\u0421\u043E\u043E\u0431\u0449\u0435\u043D\u0438\u0435 \u043F\u0440\u0438 \u043E\u0442\u043F\u0440\u0430\u0432\u043A\u0435",
        default: false,
        description: "\u041F\u043E\u043A\u0430\u0437\u044B\u0432\u0430\u0442\u044C \u0441\u043E\u043E\u0431\u0449\u0435\u043D\u0438\u0435 \u043F\u0440\u0438 \u043E\u0442\u043F\u0440\u0430\u0432\u043A\u0435 \u0444\u043E\u0440\u043C\u044B",
        trueLabel: "\u0414\u0430",
        falseLabel: "\u041D\u0435\u0442"
      }
    },
    alertPreview: {
      type: "checkbox",
      options: {
        label: "\u041F\u0440\u0435\u0434\u043F\u0440\u043E\u0441\u043C\u043E\u0442\u0440",
        description: "\u041F\u043E\u043A\u0430\u0437\u0430\u0442\u044C \u0441\u043E\u043E\u0431\u0449\u0435\u043D\u0438\u0435 \u043F\u0440\u0438 \u043E\u0442\u043F\u0440\u0430\u0432\u043A\u0435 \u0444\u043E\u0440\u043C\u044B \u0432 \u0442\u0435\u0441\u0442\u0438\u0440\u043E\u0432\u043E\u0447\u043D\u044B\u0445 \u0446\u0435\u043B\u044F\u0445",
        default: true
      },
      additional: {
        conditionalLogic: {
          showAlert: true
        },
        sanitizers: [() => false]
      }
    },
    alertContent: {
      type: "text-area",
      options: {
        label: "\u0421\u043E\u0434\u0435\u0440\u0436\u0438\u043C\u043E\u0435 \u0441\u043E\u043E\u0431\u0449\u0435\u043D\u0438\u044F",
        description: "\u0421\u043E\u0434\u0435\u0440\u0436\u0438\u043C\u043E\u0435 \u0441\u043E\u043E\u0431\u0449\u0435\u043D\u0438\u044F \u043F\u0440\u0438 \u043E\u0442\u043F\u0440\u0430\u0432\u043A\u0435 \u0444\u043E\u0440\u043C\u044B. \u041C\u043E\u0436\u043D\u043E \u0438\u0441\u043F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u0442\u044C HTML",
        required: true,
        default: "<h5>\u2705 \u0412\u0430\u0448\u0435 \u0441\u043E\u043E\u0431\u0449\u0435\u043D\u0438\u0435 \u0443\u0441\u043F\u0435\u0448\u043D\u043E \u043E\u0442\u043F\u0440\u0430\u0432\u043B\u0435\u043D\u043E!</h5><p>\u0421\u043F\u0430\u0441\u0438\u0431\u043E \u0437\u0430 \u043E\u0431\u0440\u0430\u0449\u0435\u043D\u0438\u0435. \u041C\u044B \u0441\u0432\u044F\u0436\u0435\u043C\u0441\u044F \u0441 \u0432\u0430\u043C\u0438 \u0432 \u0431\u043B\u0438\u0436\u0430\u0439\u0448\u0435\u0435 \u0432\u0440\u0435\u043C\u044F.</p>"
      },
      additional: {
        conditionalLogic: {
          showAlert: true
        }
      }
    },
    alertClass: {
      type: "text",
      options: {
        label: "\u041A\u043B\u0430\u0441\u0441 \u0441\u043E\u043E\u0431\u0449\u0435\u043D\u0438\u044F",
        description: "\u041A\u043B\u0430\u0441\u0441 \u0441\u043E\u043E\u0431\u0449\u0435\u043D\u0438\u044F \u043F\u0440\u0438 \u043E\u0442\u043F\u0440\u0430\u0432\u043A\u0435 \u0444\u043E\u0440\u043C\u044B",
        default: "alert-success",
        placeholder: "alert-success"
      },
      additional: {
        conditionalLogic: {
          showAlert: true
        }
      }
    },
    alertStyle: {
      type: "text",
      options: {
        label: "\u0421\u0442\u0438\u043B\u044C \u0441\u043E\u043E\u0431\u0449\u0435\u043D\u0438\u044F",
        description: "\u0421\u0442\u0438\u043B\u044C \u0441\u043E\u043E\u0431\u0449\u0435\u043D\u0438\u044F \u043F\u0440\u0438 \u043E\u0442\u043F\u0440\u0430\u0432\u043A\u0435 \u0444\u043E\u0440\u043C\u044B",
        placeholder: "color: green;"
      },
      additional: {
        conditionalLogic: {
          showAlert: true
        }
      }
    },
    ...additionalFields("classes", "styles")
  }
};
const __defineProps$b = {};
const __defineBlockFields$b = __defineBlock$b["fields"] || {};
const __definePropsFields$b = Object.fromEntries(Object.entries(__defineProps$b).filter(([_, prop]) => prop.__fromDefineProps));
const __export$b = {
  name: "FormBlock",
  label: __defineBlock$b.label,
  fields: { ...__defineBlockFields$b, ...__definePropsFields$b },
  slots: (_a$b = __defineBlock$b.slots) != null ? _a$b : {},
  description: __defineBlock$b.description || "",
  icon: __defineBlock$b.icon || "Components"
};

var _a$a;
const __defineBlock$a = {
  label: "HTML",
  description: "\u0414\u043E\u0431\u0430\u0432\u043B\u044F\u0435\u0442 HTML \u043A\u043E\u0434 \u0432 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0443",
  fields: {
    tag: {
      type: "text",
      options: {
        label: "\u0422\u0435\u0433",
        description: "\u0422\u0435\u0433 HTML \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430",
        required: true,
        default: "span"
      }
    },
    html: {
      type: "text-area",
      options: {
        label: "HTML",
        description: "HTML \u043A\u043E\u0434 \u0432\u043D\u0443\u0442\u0440\u0438 \u0442\u0435\u0433\u0430"
      }
    },
    attributes: {
      type: "repeater",
      options: {
        label: "\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044B",
        description: "\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044B HTML \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430",
        required: false,
        subfields: {
          name: {
            type: "text",
            options: {
              label: "\u0418\u043C\u044F \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430",
              description: "\u0418\u043C\u044F \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 HTML \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430",
              required: true
            }
          },
          value: {
            type: "text",
            options: {
              label: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430",
              description: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 HTML \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430",
              required: false
            }
          }
        }
      }
    }
  }
};
const __defineProps$a = {};
const __defineBlockFields$a = __defineBlock$a["fields"] || {};
const __definePropsFields$a = Object.fromEntries(Object.entries(__defineProps$a).filter(([_, prop]) => prop.__fromDefineProps));
const __export$a = {
  name: "HTMLBlock",
  label: __defineBlock$a.label,
  fields: { ...__defineBlockFields$a, ...__definePropsFields$a },
  slots: (_a$a = __defineBlock$a.slots) != null ? _a$a : {},
  description: __defineBlock$a.description,
  icon: __defineBlock$a.icon || "Components"
};

var _a$9;
const __defineBlock$9 = {
  label: "\u0418\u043A\u043E\u043D\u043A\u0430",
  description: "\u041E\u0442\u043E\u0431\u0440\u0430\u0436\u0430\u0435\u0442 \u0438\u043A\u043E\u043D\u043A\u0443 \u0438\u0437 \u0431\u0438\u0431\u043B\u0438\u043E\u0442\u0435\u043A\u0438 bootstrap-icons.",
  fields: {
    name: {
      type: "text",
      options: {
        label: "\u0418\u043C\u044F \u0438\u043A\u043E\u043D\u043A\u0438",
        description: "\u0418\u043C\u044F \u0438\u043A\u043E\u043D\u043A\u0438 \u0438\u0437 \u0431\u0438\u0431\u043B\u0438\u043E\u0442\u0435\u043A\u0438 bootstrap-icons. \u0421\u043F\u0438\u0441\u043E\u043A \u0438\u043A\u043E\u043D\u043E\u043A \u043D\u0430 \u0441\u0430\u0439\u0442\u0435: https://icons.getbootstrap.com",
        placeholder: "telegram",
        trim: true,
        required: true
      },
      additional: {
        sanitizers: [(ctx) => {
          return ctx.value.toLowerCase().replace(/\s+/gm, "");
        }]
      }
    },
    ...additionalFields("classes", "styles")
  }
};
const __defineProps$9 = {};
const __defineBlockFields$9 = __defineBlock$9["fields"] || {};
const __definePropsFields$9 = Object.fromEntries(Object.entries(__defineProps$9).filter(([_, prop]) => prop.__fromDefineProps));
const __export$9 = {
  name: "IconBlock",
  label: __defineBlock$9.label,
  fields: { ...__defineBlockFields$9, ...__definePropsFields$9 },
  slots: (_a$9 = __defineBlock$9.slots) != null ? _a$9 : {},
  description: __defineBlock$9.description,
  icon: __defineBlock$9.icon || "Components"
};

var _a$8;
const __defineBlock$8 = {
  label: "\u0418\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u0435",
  description: "\u0418\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u0435, \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043C\u043E\u0435 \u0438\u0437 \u0431\u0438\u0431\u043B\u0438\u043E\u0442\u0435\u043A\u0438",
  fields: {
    image: {
      type: "image",
      options: {
        label: "\u0418\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u0435",
        required: true,
        sources: [{
          format: "webp"
        }, {
          format: "png"
        }]
      }
    },
    isLazy: {
      type: "switch",
      options: {
        label: "\u041B\u0435\u043D\u0438\u0432\u0430\u044F \u0437\u0430\u0433\u0440\u0443\u0437\u043A\u0430",
        description: "\u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0442\u044C \u0438\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u0435 \u0442\u043E\u043B\u044C\u043A\u043E \u043F\u0440\u0438 \u043F\u0440\u043E\u043A\u0440\u0443\u0442\u043A\u0435 \u043A \u043D\u0435\u043C\u0443",
        trueLabel: "\u0414\u0430",
        falseLabel: "\u041D\u0435\u0442",
        default: false
      }
    },
    imgAttrs: {
      type: "repeater",
      options: {
        label: "\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044B \u0438\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u044F",
        description: "\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044B, \u043F\u0435\u0440\u0435\u0434\u0430\u0432\u0430\u0435\u043C\u044B\u0435 \u043D\u0430\u043F\u0440\u044F\u043C\u0443\u044E \u043A \u0438\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u044E, \u0430 \u043D\u0435 \u043A \u043A\u043E\u043D\u0442\u0435\u0439\u043D\u0435\u0440\u0443",
        subfields: {
          name: {
            type: "text",
            options: {
              label: "\u0418\u043C\u044F \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430",
              description: "\u0418\u043C\u044F \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 HTML \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430",
              required: true,
              placeholder: "class"
            }
          },
          value: {
            type: "text",
            options: {
              label: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430",
              description: "\u0417\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 HTML \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430",
              required: false,
              placeholder: "rounded-circle"
            }
          }
        }
      }
    },
    ...additionalFields("classes", "styles")
  }
};
const __defineProps$8 = {};
const __defineBlockFields$8 = __defineBlock$8["fields"] || {};
const __definePropsFields$8 = Object.fromEntries(Object.entries(__defineProps$8).filter(([_, prop]) => prop.__fromDefineProps));
const __export$8 = {
  name: "ImageBlock",
  label: __defineBlock$8.label,
  fields: { ...__defineBlockFields$8, ...__definePropsFields$8 },
  slots: (_a$8 = __defineBlock$8.slots) != null ? _a$8 : {},
  description: __defineBlock$8.description,
  icon: __defineBlock$8.icon || "Components"
};

var _a$7;
const __defineBlock$7 = {
  label: "\u0421\u0441\u044B\u043B\u043A\u0430",
  description: "\u0414\u043E\u0431\u0430\u0432\u043B\u044F\u0435\u0442 \u043A \u0434\u043E\u0447\u0435\u0440\u043D\u0438\u043C \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430\u043C \u0441\u0441\u044B\u043B\u043A\u0443 \u043D\u0430 \u0434\u0440\u0443\u0433\u0443\u044E \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0443 \u0438\u043B\u0438 \u043D\u0430 \u0444\u0430\u0439\u043B",
  fields: {
    type: {
      type: "select",
      options: {
        label: "\u0422\u0438\u043F",
        description: "\u0422\u0438\u043F \u0441\u0441\u044B\u043B\u043A\u0438: \u0441\u0441\u044B\u043B\u043A\u0430 \u043D\u0430 \u0432\u043D\u0435\u0448\u043D\u044E\u044E \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0443 \u0438\u043B\u0438 \u043D\u0430 \u0444\u0430\u0439\u043B",
        choices: {
          link: "\u0421\u0441\u044B\u043B\u043A\u0430",
          file: "\u0424\u0430\u0439\u043B"
        },
        default: "link"
      }
    },
    link: {
      type: "link",
      options: {
        label: "\u0421\u0441\u044B\u043B\u043A\u0430",
        description: "\u0421\u0441\u044B\u043B\u043A\u0430 \u043D\u0430 \u0434\u0440\u0443\u0433\u0443\u044E \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0443",
        placeholder: "https://example.com",
        required: true
      },
      additional: {
        conditionalLogic: {
          type: "link"
        }
      }
    },
    file: {
      type: "file",
      options: {
        label: "\u0424\u0430\u0439\u043B",
        description: "\u0424\u0430\u0439\u043B \u0434\u043B\u044F \u0437\u0430\u0433\u0440\u0443\u0437\u043A\u0438",
        required: true
      },
      additional: {
        conditionalLogic: {
          type: "file"
        }
      }
    },
    target: {
      type: "select",
      options: {
        label: "\u041E\u0442\u043A\u0440\u044B\u0432\u0430\u0442\u044C \u0432 ...",
        description: "\u041E\u0442\u043A\u0440\u044B\u0432\u0430\u0442\u044C \u0441\u0441\u044B\u043B\u043A\u0443 \u0432 \u043D\u043E\u0432\u043E\u043C \u043E\u043A\u043D\u0435",
        choices: {
          _blank: "\u041D\u043E\u0432\u043E\u0435 \u043E\u043A\u043D\u043E",
          _self: "\u0422\u0435\u043A\u0443\u0449\u0435\u0435 \u043E\u043A\u043D\u043E"
        },
        default: "_self"
      }
    },
    isStretched: {
      type: "switch",
      options: {
        label: "\u0420\u0430\u0441\u0442\u044F\u043D\u0443\u0442\u0430\u044F \u0441\u0441\u044B\u043B\u043A\u0430",
        description: "\u041F\u0440\u0438\u043C\u0435\u043D\u044F\u0435\u0442 \u0441\u0441\u044B\u043B\u043A\u0443 \u043A \u043F\u0435\u0440\u0432\u043E\u043C\u0443 \u0440\u043E\u0434\u0438\u0442\u0435\u043B\u044C\u0441\u043A\u043E\u043C\u0443 \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0443 \u0441 \u043A\u043B\u0430\u0441\u0441\u043E\u043C position-relative, \u0432\u043C\u0435\u0441\u0442\u043E \u0434\u043E\u0447\u0435\u0440\u043D\u0438\u0445.",
        default: false,
        falseLabel: "\u041D\u0435\u0442",
        trueLabel: "\u0414\u0430"
      }
    },
    ...additionalFields("classes", "styles")
  },
  slots: {
    default: {
      label: "\u041A\u043E\u043D\u0442\u0435\u043D\u0442"
    }
  }
};
const __defineProps$7 = {};
const __defineBlockFields$7 = __defineBlock$7["fields"] || {};
const __definePropsFields$7 = Object.fromEntries(Object.entries(__defineProps$7).filter(([_, prop]) => prop.__fromDefineProps));
const __export$7 = {
  name: "LinkBlock",
  label: __defineBlock$7.label,
  fields: { ...__defineBlockFields$7, ...__definePropsFields$7 },
  slots: (_a$7 = __defineBlock$7.slots) != null ? _a$7 : {},
  description: __defineBlock$7.description,
  icon: __defineBlock$7.icon || "Components"
};

var _a$6;
const __defineBlock$6 = {
  label: "\u0421\u043F\u0438\u0441\u043E\u043A-\u0433\u0440\u0443\u043F\u043F\u0430",
  description: "\u041A\u043E\u043D\u0442\u0435\u0439\u043D\u0435\u0440 \u0434\u043B\u044F \u0421\u043F\u0438\u0441\u043A\u0430-\u0433\u0440\u0443\u043F\u043F\u044B",
  fields: {
    ...additionalFields("classes", "styles")
  },
  slots: {
    default: {
      label: "\u0421\u043E\u0434\u0435\u0440\u0436\u0438\u043C\u043E\u0435",
      allowedChildBlocks: ["ListGroupItemBlock"]
    }
  }
};
const __defineProps$6 = {};
const __defineBlockFields$6 = __defineBlock$6["fields"] || {};
const __definePropsFields$6 = Object.fromEntries(Object.entries(__defineProps$6).filter(([_, prop]) => prop.__fromDefineProps));
const __export$6 = {
  name: "ListGroupBlock",
  label: __defineBlock$6.label,
  fields: { ...__defineBlockFields$6, ...__definePropsFields$6 },
  slots: (_a$6 = __defineBlock$6.slots) != null ? _a$6 : {},
  description: __defineBlock$6.description,
  icon: __defineBlock$6.icon || "Components"
};

var _a$5;
const __defineBlock$5 = {
  label: "\u041A\u043E\u043C\u043F\u043E\u043D\u0435\u043D\u0442 \u0441\u043F\u0438\u0441\u043A\u0430",
  description: "\u041A\u043E\u043C\u043F\u043E\u043D\u0435\u043D\u0442 \u0441\u043F\u0438\u0441\u043A\u0430",
  fields: {
    variant: {
      type: "select",
      options: {
        label: "\u0421\u0442\u0438\u043B\u044C",
        description: "\u0421\u0442\u0438\u043B\u044C \u0441\u043F\u0438\u0441\u043A\u0430",
        required: true,
        choices: {
          default: "default",
          primary: "primary",
          secondary: "secondary",
          success: "success",
          danger: "danger",
          warning: "warning",
          info: "info",
          light: "light",
          dark: "dark"
        }
      }
    },
    ...additionalFields("classes", "styles")
  },
  slots: {
    default: {
      label: "\u0421\u043E\u0434\u0435\u0440\u0436\u0438\u043C\u043E\u0435",
      allowedChildBlocks: ["HTMLBlock", "RichTextBlock", "BadgeBlock", "IconBlock", "ImageBlock", "Button", "LinkBlock", "AlertBlock"]
    }
  }
};
const __defineProps$5 = {};
const __defineBlockFields$5 = __defineBlock$5["fields"] || {};
const __definePropsFields$5 = Object.fromEntries(Object.entries(__defineProps$5).filter(([_, prop]) => prop.__fromDefineProps));
const __export$5 = {
  name: "ListGroupItemBlock",
  label: __defineBlock$5.label,
  fields: { ...__defineBlockFields$5, ...__definePropsFields$5 },
  slots: (_a$5 = __defineBlock$5.slots) != null ? _a$5 : {},
  description: __defineBlock$5.description,
  icon: __defineBlock$5.icon || "Components"
};

var _a$4;
const __defineBlock$4 = {
  label: "\u041D\u043E\u0432\u043E\u0441\u0442\u043D\u043E\u0439 \u0431\u043B\u043E\u043A",
  fields: {
    itemsPerPage: {
      type: "number",
      options: {
        label: "\u041A\u043E\u043B\u0438\u0447\u0435\u0441\u0442\u0432\u043E \u043D\u043E\u0432\u043E\u0441\u0442\u0435\u0439 \u043D\u0430 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0435",
        min: 0,
        step: 1,
        decimals: 0,
        default: 3
      }
    },
    pagination: {
      type: "switch",
      options: {
        label: "\u0423\u043F\u0440\u0430\u0432\u043B\u0435\u043D\u0438\u0435 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0430\u043C\u0438",
        default: false,
        description: "\u0414\u043E\u0431\u0430\u0432\u043B\u044F\u0435\u0442 \u043D\u0430\u0432\u0438\u0433\u0430\u0446\u0438\u044E \u043F\u043E \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0430\u043C. \u0415\u0441\u043B\u0438 \u043E\u0442\u043A\u043B\u044E\u0447\u0435\u043D\u043E, \u0442\u043E \u0431\u0443\u0434\u0435\u0442 \u043E\u0442\u043E\u0431\u0440\u0430\u0436\u0430\u0442\u044C\u0441\u044F \u0442\u043E\u043B\u044C\u043A\u043E \u043F\u0435\u0440\u0432\u0430\u044F \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0430 \u0441 \u043F\u043E\u0441\u043B\u0435\u0434\u043D\u0438\u043C\u0438 \u043D\u043E\u0432\u043E\u0441\u0442\u044F\u043C\u0438"
      }
    },
    queryPageParam: {
      type: "text",
      options: {
        label: "\u0418\u043C\u044F \u043F\u0430\u0440\u0430\u043C\u0435\u0442\u0440\u0430 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u044B",
        description: '\u0418\u043C\u044F \u043F\u0430\u0440\u0430\u043C\u0435\u0442\u0440\u0430 \u0432 URL, \u043A\u043E\u0442\u043E\u0440\u044B\u0439 \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u0442\u044C\u0441\u044F \u0434\u043B\u044F \u0443\u043F\u0440\u0430\u0432\u043B\u0435\u043D\u0438\u044F \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0430\u043C\u0438. \u041F\u043E \u0443\u043C\u043E\u043B\u0447\u0430\u043D\u0438\u044E \u0438\u0441\u043F\u043E\u043B\u044C\u0437\u0443\u0435\u0442\u0441\u044F "page".',
        required: true,
        default: "page"
      }
    },
    lazy: {
      type: "switch",
      options: {
        label: "\u041B\u0435\u043D\u0438\u0432\u0430\u044F \u0437\u0430\u0433\u0440\u0443\u0437\u043A\u0430 \u043D\u043E\u0432\u043E\u0441\u0442\u0435\u0439",
        default: false,
        description: "\u0412\u043A\u043B\u044E\u0447\u0430\u0435\u0442 \u043B\u0435\u043D\u0438\u0432\u0443\u044E \u0437\u0430\u0433\u0440\u0443\u0437\u043A\u0443 \u043D\u043E\u0432\u043E\u0441\u0442\u0435\u0439. \u0415\u0441\u043B\u0438 \u0432\u043A\u043B\u044E\u0447\u0435\u043D\u043E, \u0431\u0443\u0434\u0435\u0442 \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0442\u044C \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u044B \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u044B \u043D\u0435 \u043E\u0436\u0438\u0434\u0430\u043D\u0438\u044F \u043F\u043E\u043B\u0443\u0447\u0435\u043D\u0438\u044F \u0434\u0430\u043D\u043D\u044B\u0445 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430. \u0418\u043D\u0430\u0447\u0435, \u0434\u0430\u043D\u043D\u044B\u0435 \u0431\u0443\u0434\u0443\u0442 \u0437\u0430\u0440\u0430\u043D\u0435\u0435 \u043A\u044D\u0448\u0438\u0440\u043E\u0432\u0430\u0442\u044C\u0441\u044F \u043D\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435, \u043D\u043E \u043F\u0440\u0438 \u0432\u044B\u0431\u043E\u0440\u0435 \u0434\u0440\u0443\u0433\u043E\u0439 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u044B \u043B\u0435\u043D\u0438\u0432\u043E\u0439 \u0437\u0430\u0433\u0440\u0443\u0437\u043A\u0438 \u043D\u0435 \u0431\u0443\u0434\u0435\u0442."
      }
    },
    ...additionalFields("classes", "styles", "responsive_control")
  }
};
const __defineProps$4 = {};
const __defineBlockFields$4 = __defineBlock$4["fields"] || {};
const __definePropsFields$4 = Object.fromEntries(Object.entries(__defineProps$4).filter(([_, prop]) => prop.__fromDefineProps));
const __export$4 = {
  name: "NewsBlock",
  label: __defineBlock$4.label,
  fields: { ...__defineBlockFields$4, ...__definePropsFields$4 },
  slots: (_a$4 = __defineBlock$4.slots) != null ? _a$4 : {},
  description: __defineBlock$4.description || "",
  icon: __defineBlock$4.icon || "Components"
};

var _a$3;
const __defineBlock$3 = {
  label: "\u042D\u043B\u0435\u043C\u0435\u043D\u0442 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u044B",
  slots: {
    default: {
      label: "\u0421\u043E\u0434\u0435\u0440\u0436\u0438\u043C\u043E\u0435",
      allowedChildBlocks: ["ContainerBlock", "CarouselBlock", "LinkBlock", "HTMLBlock", "FormBlock", "NewsBlock", "AccordionBlock", "ListGroupBlock", "ImageBlock", "Preset"]
    }
  }
};
const __defineProps$3 = {};
const __defineBlockFields$3 = __defineBlock$3["fields"] || {};
const __definePropsFields$3 = Object.fromEntries(Object.entries(__defineProps$3).filter(([_, prop]) => prop.__fromDefineProps));
const __export$3 = {
  name: "PageElementBlock",
  label: __defineBlock$3.label,
  fields: { ...__defineBlockFields$3, ...__definePropsFields$3 },
  slots: (_a$3 = __defineBlock$3.slots) != null ? _a$3 : {},
  description: __defineBlock$3.description || "",
  icon: __defineBlock$3.icon || "Components"
};

var _a$2;
const __defineBlock$2 = {
  label: "\u0421\u0442\u0438\u043B\u0438\u0437\u043E\u0432\u0430\u043D\u043D\u044B\u0439 \u0442\u0435\u043A\u0441\u0442",
  description: "\u0420\u0435\u0434\u0430\u043A\u0442\u0438\u0440\u0443\u0435\u043C\u044B\u0439 \u0442\u0435\u043A\u0441\u0442 \u0441 \u043F\u043E\u0434\u0434\u0435\u0440\u0436\u043A\u043E\u0439 \u0444\u043E\u0440\u043C\u0430\u0442\u0438\u0440\u043E\u0432\u0430\u043D\u0438\u044F",
  slots: {
    default: {
      label: "\u041A\u043E\u043D\u0442\u0435\u043D\u0442"
    }
  },
  fields: {
    html: {
      type: "editor",
      options: {
        label: "\u041A\u043E\u043D\u0442\u0435\u043D\u0442",
        placeholder: "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0442\u0435\u043A\u0441\u0442 ...",
        required: true,
        blockFormats: [],
        inlineFormats: [{
          className: "text-primary"
        }, {
          className: "text-secondary"
        }, {
          className: "text-dark"
        }, {
          className: "text-light"
        }, {
          className: "text-info"
        }, {
          className: "text-success"
        }, {
          className: "text-danger"
        }, {
          className: "text-warning"
        }, {
          className: "text-bg-primary"
        }, {
          className: "text-bg-secondary"
        }, {
          className: "text-bg-dark"
        }, {
          className: "text-bg-light"
        }, {
          className: "text-bg-info"
        }, {
          className: "text-bg-success"
        }, {
          className: "text-bg-danger"
        }, {
          className: "text-bg-warning"
        }, {
          className: "fs-6",
          label: "\u041C\u0435\u043B\u043A\u0438\u0439"
        }, {
          className: "fs-5",
          label: "\u041E\u0431\u044B\u0447\u043D\u044B\u0439"
        }, {
          className: "fs-4",
          label: "\u041A\u0440\u0443\u043F\u043D\u044B\u0439"
        }, {
          className: "fs-3",
          label: "\u041E\u0447\u0435\u043D\u044C \u043A\u0440\u0443\u043F\u043D\u044B\u0439"
        }, {
          className: "fs-2",
          label: "\u041F\u043E\u0434\u0437\u0430\u0433\u043E\u043B\u043E\u0432\u043E\u043A"
        }, {
          className: "fs-1",
          label: "\u0417\u0430\u0433\u043E\u043B\u043E\u0432\u043E\u043A"
        }],
        toolbar: ["blockFormats", "bold", "italic", "underline", "strike", "link", "heading1", "heading2", "heading3", "heading4", "heading5", "heading6", "bulletList", "orderedList", "highlight", "hardBreak", "subscript", "superscript", "left", "center", "right", "justify", "inlineFormats", "redo", "clear"]
      }
    },
    ...additionalFields("classes", "styles")
  }
};
const __defineProps$2 = {};
const __defineBlockFields$2 = __defineBlock$2["fields"] || {};
const __definePropsFields$2 = Object.fromEntries(Object.entries(__defineProps$2).filter(([_, prop]) => prop.__fromDefineProps));
const __export$2 = {
  name: "RichTextBlock",
  label: __defineBlock$2.label,
  fields: { ...__defineBlockFields$2, ...__definePropsFields$2 },
  slots: (_a$2 = __defineBlock$2.slots) != null ? _a$2 : {},
  description: __defineBlock$2.description,
  icon: __defineBlock$2.icon || "Components"
};

var _a$1;
const __defineBlock$1 = {
  label: "\u0421\u0442\u043E\u043B\u0431\u0435\u0446",
  slots: {
    default: {
      label: "\u041A\u043E\u043D\u0442\u0435\u043D\u0442"
    }
  },
  fields: {
    col: {
      type: "checkbox",
      options: {
        required: false
      }
    },
    cols: colsNumbersSelectField({
      options: {
        auto: true
      }
    }),
    sm: colsNumbersSelectField({
      options: {
        auto: true,
        boolean: true
      }
    }),
    md: colsNumbersSelectField({
      options: {
        auto: true,
        boolean: true
      }
    }),
    lg: colsNumbersSelectField({
      options: {
        auto: true,
        boolean: true
      }
    }),
    xl: colsNumbersSelectField({
      options: {
        auto: true,
        boolean: true
      }
    }),
    xxl: colsNumbersSelectField({
      options: {
        auto: true,
        boolean: true
      }
    }),
    alignSelf: alignmentVerticalSelectField({
      options: {
        auto: true
      }
    }),
    ...additionalFields("classes", "styles", "responsive_control")
  }
};
const __defineProps$1 = {};
const __defineBlockFields$1 = __defineBlock$1["fields"] || {};
const __definePropsFields$1 = Object.fromEntries(Object.entries(__defineProps$1).filter(([_, prop]) => prop.__fromDefineProps));
const __export$1 = {
  name: "RowColBlock",
  label: __defineBlock$1.label,
  fields: { ...__defineBlockFields$1, ...__definePropsFields$1 },
  slots: (_a$1 = __defineBlock$1.slots) != null ? _a$1 : {},
  description: __defineBlock$1.description || "",
  icon: __defineBlock$1.icon || "Components"
};

var _a;
const __defineBlock = {
  description: "This block is swapped with blocks from the selected preset."
};
const __defineProps = {
  preset: recordFieldTrap({
    collection: "presets",
    fields: {
      blocks: true
    },
    populate: true,
    required: true,
    label: "Preset",
    description: "This block is swapped with blocks from the selected preset.",
    placeholder: "Select a preset"
  })
};
const __defineBlockFields = __defineBlock["fields"] || {};
const __definePropsFields = Object.fromEntries(Object.entries(__defineProps).filter(([_, prop]) => prop.__fromDefineProps));
const __export = {
  name: "Preset",
  label: __defineBlock.label || "Preset",
  fields: { ...__defineBlockFields, ...__definePropsFields },
  slots: (_a = __defineBlock.slots) != null ? _a : {},
  description: __defineBlock.description,
  icon: __defineBlock.icon || "Components"
};

const blocks = {
  AccordionBlock: __export$k,
  AccordionItemBlock: __export$j,
  AlertBlock: __export$i,
  BadgeBlock: __export$h,
  CarouselBlock: __export$g,
  CarouselSlideBlock: __export$f,
  CarouselSlideContentBlock: __export$e,
  ContainerBlock: __export$d,
  ContainerRowBlock: __export$c,
  FormBlock: __export$b,
  HTMLBlock: __export$a,
  IconBlock: __export$9,
  ImageBlock: __export$8,
  LinkBlock: __export$7,
  ListGroupBlock: __export$6,
  ListGroupItemBlock: __export$5,
  NewsBlock: __export$4,
  PageElementBlock: __export$3,
  RichTextBlock: __export$2,
  RowColBlock: __export$1,
  Preset: __export
};

const index = /*#__PURE__*/Object.freeze(/*#__PURE__*/Object.defineProperty({
  __proto__: null,
  blocks: blocks
}, Symbol.toStringTag, { value: 'Module' }));

const dashboardIcons = {
  "360": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-360"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M16.996 15.328c2.414 -.718 4.004 -1.94 4.004 -3.328c0 -2.21 -4.03 -4 -9 -4s-9 1.79 -9 4s4.03 4 9 4" />
    <path d="M9 13l3 3l-3 3" />
  </svg>

`,
  "24Hours": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-24-hours"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M20 11a8.1 8.1 0 0 0 -15.5 -2m-.5 -4v4h4" />
    <path d="M4 13a8.094 8.094 0 0 0 3 5.24" />
    <path d="M11 15h2a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-1a1 1 0 0 0 -1 1v1a1 1 0 0 0 1 1h2" />
    <path d="M17 15v2a1 1 0 0 0 1 1h1" />
    <path d="M20 15v6" />
  </svg>

`,
  "2fa": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-2fa"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M7 16h-4l3.47 -4.66a2 2 0 1 0 -3.47 -1.54" />
    <path d="M10 16v-8h4" />
    <line x1="10" x2="13" y1="12" y2="12" />
    <path d="M17 16v-6a2 2 0 0 1 4 0v6" />
    <line x1="17" x2="21" y1="13" y2="13" />
  </svg>

`,
  "3dCubeSphere": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-3d-cube-sphere"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M6 17.6l-2 -1.1v-2.5" />
    <path d="M4 10v-2.5l2 -1.1" />
    <path d="M10 4.1l2 -1.1l2 1.1" />
    <path d="M18 6.4l2 1.1v2.5" />
    <path d="M20 14v2.5l-2 1.12" />
    <path d="M14 19.9l-2 1.1l-2 -1.1" />
    <line x1="12" x2="14" y1="12" y2="10.9" />
    <line x1="18" x2="20" y1="8.6" y2="7.5" />
    <line x1="12" x2="12" y1="12" y2="14.5" />
    <line x1="12" x2="12" y1="18.5" y2="21" />
    <path d="M12 12l-2 -1.12" />
    <line x1="6" x2="4" y1="8.6" y2="7.5" />
  </svg>

`,
  "AB": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-a-b"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M3 16v-5.5a2.5 2.5 0 0 1 5 0v5.5m0 -4h-5" />
    <line x1="12" x2="12" y1="6" y2="18" />
    <path d="M16 16v-8h3a2 2 0 0 1 0 4h-3m3 0a2 2 0 0 1 0 4h-3" />
  </svg>

`,
  "AB2": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-a-b-2"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M16 21h3c.81 0 1.48 -.67 1.48 -1.48l.02 -.02c0 -.82 -.69 -1.5 -1.5 -1.5h-3v3z" />
    <path d="M16 15h2.5c.84 -.01 1.5 .66 1.5 1.5s-.66 1.5 -1.5 1.5h-2.5v-3z" />
    <path d="M4 9v-4c0 -1.036 .895 -2 2 -2s2 .964 2 2v4" />
    <path d="M2.99 11.98a9 9 0 0 0 9 9m9 -9a9 9 0 0 0 -9 -9" />
    <path d="M8 7h-4" />
  </svg>

`,
  "Abacus": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-abacus"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M5 3v18" />
    <path d="M19 21v-18" />
    <path d="M5 7h14" />
    <path d="M5 15h14" />
    <path d="M8 13v4" />
    <path d="M11 13v4" />
    <path d="M16 13v4" />
    <path d="M14 5v4" />
    <path d="M11 5v4" />
    <path d="M8 5v4" />
    <path d="M3 21h18" />
  </svg>

`,
  "Abc": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-abc"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M3 16v-6a2 2 0 1 1 4 0v6" />
    <path d="M3 13h4" />
    <path d="M10 8v6a2 2 0 1 0 4 0v-1a2 2 0 1 0 -4 0v1" />
    <path d="M20.732 12a2 2 0 0 0 -3.732 1v1a2 2 0 0 0 3.726 1.01" />
  </svg>

`,
  "AccessPoint": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-access-point"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="12" x2="12" y1="12" y2="12.01" />
    <path d="M14.828 9.172a4 4 0 0 1 0 5.656" />
    <path d="M17.657 6.343a8 8 0 0 1 0 11.314" />
    <path d="M9.168 14.828a4 4 0 0 1 0 -5.656" />
    <path d="M6.337 17.657a8 8 0 0 1 0 -11.314" />
  </svg>

`,
  "Accessible": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-accessible"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="12" r="9" />
    <path d="M10 16.5l2 -3l2 3m-2 -3v-2l3 -1m-6 0l3 1" />
    <circle cx="12" cy="7.5" fill="currentColor" r=".5" />
  </svg>

`,
  "AddressBook": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-address-book"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M20 6v12a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2z" />
    <path d="M10 16h6" />
    <circle cx="13" cy="11" r="2" />
    <path d="M4 8h3" />
    <path d="M4 12h3" />
    <path d="M4 16h3" />
  </svg>

`,
  "Adjustments": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-adjustments"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="6" cy="10" r="2" />
    <line x1="6" x2="6" y1="4" y2="8" />
    <line x1="6" x2="6" y1="12" y2="20" />
    <circle cx="12" cy="16" r="2" />
    <line x1="12" x2="12" y1="4" y2="14" />
    <line x1="12" x2="12" y1="18" y2="20" />
    <circle cx="18" cy="7" r="2" />
    <line x1="18" x2="18" y1="4" y2="5" />
    <line x1="18" x2="18" y1="9" y2="20" />
  </svg>

`,
  "AdjustmentsHorizontal": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-adjustments-horizontal"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="14" cy="6" r="2" />
    <line x1="4" x2="12" y1="6" y2="6" />
    <line x1="16" x2="20" y1="6" y2="6" />
    <circle cx="8" cy="12" r="2" />
    <line x1="4" x2="6" y1="12" y2="12" />
    <line x1="10" x2="20" y1="12" y2="12" />
    <circle cx="17" cy="18" r="2" />
    <line x1="4" x2="15" y1="18" y2="18" />
    <line x1="19" x2="20" y1="18" y2="18" />
  </svg>

`,
  "AerialLift": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-aerial-lift"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M4 5l16 -2m-8 1v10m-5.106 -6h10.306c2.45 3 2.45 9 -.2 12h-10.106c-2.544 -3 -2.544 -9 0 -12zm-1.894 6h14" />
  </svg>

`,
  "Alarm": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-alarm"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="13" r="7" />
    <polyline points="12 10 12 13 14 13" />
    <line x1="7" x2="4.25" y1="4" y2="6" />
    <line x1="17" x2="19.75" y1="4" y2="6" />
  </svg>

`,
  "Album": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-album"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="16" rx="2" width="16" x="4" y="4" />
    <path d="M12 4v7l2 -2l2 2v-7" />
  </svg>

`,
  "AlertTriangle": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-alert-triangle"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M12 9v2m0 4v.01" />
    <path d="M5 19h14a2 2 0 0 0 1.84 -2.75l-7.1 -12.25a2 2 0 0 0 -3.5 0l-7.1 12.25a2 2 0 0 0 1.75 2.75" />
  </svg>

`,
  "AlignCenter": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-align-center"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="4" x2="20" y1="6" y2="6" />
    <line x1="8" x2="16" y1="12" y2="12" />
    <line x1="6" x2="18" y1="18" y2="18" />
  </svg>

`,
  "AlignJustified": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-align-justified"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="4" x2="20" y1="6" y2="6" />
    <line x1="4" x2="20" y1="12" y2="12" />
    <line x1="4" x2="16" y1="18" y2="18" />
  </svg>

`,
  "AlignLeft": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-align-left"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="4" x2="20" y1="6" y2="6" />
    <line x1="4" x2="14" y1="12" y2="12" />
    <line x1="4" x2="18" y1="18" y2="18" />
  </svg>

`,
  "AlignRight": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-align-right"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="4" x2="20" y1="6" y2="6" />
    <line x1="10" x2="20" y1="12" y2="12" />
    <line x1="6" x2="20" y1="18" y2="18" />
  </svg>

`,
  "Analyze": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-analyze"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M20 11a8.1 8.1 0 0 0 -6.986 -6.918a8.095 8.095 0 0 0 -8.019 3.918" />
    <path d="M4 13a8.1 8.1 0 0 0 15.001 2.998" />
    <circle cx="19" cy="16" r="1" />
    <circle cx="5" cy="8" r="1" />
    <circle cx="12" cy="12" r="3" />
  </svg>

`,
  "Anchor": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-anchor"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M12 9v12m-8 -8a8 8 0 0 0 16 0m1 0h-2m-14 0h-2" />
    <circle cx="12" cy="6" r="3" />
  </svg>

`,
  "Angle": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-angle"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M21 19h-18l9 -15" />
    <path d="M20.615 15.171h.015" />
    <path d="M19.515 11.771h.015" />
    <path d="M17.715 8.671h.015" />
    <path d="M15.415 5.971h.015" />
  </svg>

`,
  "Api": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-api"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M4 13h5" />
    <path d="M12 16v-8h3a2 2 0 0 1 2 2v1a2 2 0 0 1 -2 2h-3" />
    <path d="M20 8v8" />
    <path d="M9 16v-5.5a2.5 2.5 0 0 0 -5 0v5.5" />
  </svg>

`,
  "AppWindow": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-app-window"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="14" rx="2" width="18" x="3" y="5" />
    <path d="M6 8h.01" />
    <path d="M9 8h.01" />
  </svg>

`,
  "Apple": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-apple"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="14" r="7" />
    <path d="M12 11v-6a2 2 0 0 1 2 -2h2v1a2 2 0 0 1 -2 2h-2" />
    <path d="M10 10.5c1.333 .667 2.667 .667 4 0" />
  </svg>

`,
  "Apps": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-apps"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="6" rx="1" width="6" x="4" y="4" />
    <rect height="6" rx="1" width="6" x="4" y="14" />
    <rect height="6" rx="1" width="6" x="14" y="14" />
    <line x1="14" x2="20" y1="7" y2="7" />
    <line x1="17" x2="17" y1="4" y2="10" />
  </svg>

`,
  "Archive": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-archive"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="4" rx="2" width="18" x="3" y="4" />
    <path d="M5 8v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-10" />
    <line x1="10" x2="14" y1="12" y2="12" />
  </svg>

`,
  "ArrowBack": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-arrow-back"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M9 11l-4 4l4 4m-4 -4h11a4 4 0 0 0 0 -8h-1" />
  </svg>

`,
  "ArrowBackUp": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-arrow-back-up"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M9 13l-4 -4l4 -4m-4 4h11a4 4 0 0 1 0 8h-1" />
  </svg>

`,
  "ArrowBounce": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-arrow-bounce"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M10 18h4" />
    <path d="M3 8a9 9 0 0 1 9 9v1l1.428 -4.285a12 12 0 0 1 6.018 -6.938l.554 -.277" />
    <path d="M15 6h5v5" />
  </svg>

`,
  "ArrowDown": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-arrow-down"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="12" x2="12" y1="5" y2="19" />
    <line x1="18" x2="12" y1="13" y2="19" />
    <line x1="6" x2="12" y1="13" y2="19" />
  </svg>

`,
  "ArrowForwardUp": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-arrow-forward-up"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M15 13l4 -4l-4 -4m4 4h-11a4 4 0 0 0 0 8h1" />
  </svg>

`,
  "ArrowLeft": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-arrow-left"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="5" x2="19" y1="12" y2="12" />
    <line x1="5" x2="11" y1="12" y2="18" />
    <line x1="5" x2="11" y1="12" y2="6" />
  </svg>

`,
  "ArrowRight": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-arrow-right"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="5" x2="19" y1="12" y2="12" />
    <line x1="13" x2="19" y1="18" y2="12" />
    <line x1="13" x2="19" y1="6" y2="12" />
  </svg>

`,
  "ArrowUp": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-arrow-up"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="12" x2="12" y1="5" y2="19" />
    <line x1="18" x2="12" y1="11" y2="5" />
    <line x1="6" x2="12" y1="11" y2="5" />
  </svg>

`,
  "ArrowsHorizontal": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-arrows-horizontal"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M7 8l-4 4l4 4" />
    <path d="M17 8l4 4l-4 4" />
    <path d="M3 12l18 0" />
  </svg>

`,
  "ArrowsMaximize": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-arrows-maximize"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <polyline points="16 4 20 4 20 8" />
    <line x1="14" x2="20" y1="10" y2="4" />
    <polyline points="8 20 4 20 4 16" />
    <line x1="4" x2="10" y1="20" y2="14" />
    <polyline points="16 20 20 20 20 16" />
    <line x1="14" x2="20" y1="14" y2="20" />
    <polyline points="8 4 4 4 4 8" />
    <line x1="4" x2="10" y1="4" y2="10" />
  </svg>

`,
  "ArrowsSort": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-arrows-sort"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M3 9l4 -4l4 4m-4 -4v14" />
    <path d="M21 15l-4 4l-4 -4m4 4v-14" />
  </svg>

`,
  "Article": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-article"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="16" rx="2" width="18" x="3" y="4" />
    <path d="M7 8h10" />
    <path d="M7 12h10" />
    <path d="M7 16h10" />
  </svg>

`,
  "AspectRatio": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-aspect-ratio"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="14" rx="2" width="18" x="3" y="5" />
    <path d="M7 12v-3h3" />
    <path d="M17 12v3h-3" />
  </svg>

`,
  "Atom": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-atom"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M12 12v.01" />
    <path
      d="M19.071 4.929c-1.562 -1.562 -5.994 .337 -9.9 4.243c-3.905 3.905 -5.804 8.337 -4.242 9.9c1.562 1.561 5.994 -.338 9.9 -4.244c3.905 -3.905 5.804 -8.337 4.242 -9.9"
    />
    <path
      d="M4.929 4.929c-1.562 1.562 .337 5.994 4.243 9.9c3.905 3.905 8.337 5.804 9.9 4.242c1.561 -1.562 -.338 -5.994 -4.244 -9.9c-3.905 -3.905 -8.337 -5.804 -9.9 -4.242"
    />
  </svg>

`,
  "Award": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-award"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="9" r="6" />
    <path d="M12.002 15.003l3.4 5.89l1.598 -3.233l3.598 .232l-3.4 -5.889" />
    <path d="M6.802 12.003l-3.4 5.89l3.598 -.233l1.598 3.232l3.4 -5.889" />
  </svg>

`,
  "Axe": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-axe"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M13 9l7.383 7.418c.823 .82 .823 2.148 0 2.967a2.11 2.11 0 0 1 -2.976 0l-7.407 -7.385" />
    <path
      d="M6.66 15.66l-3.32 -3.32a1.25 1.25 0 0 1 .42 -2.044l3.24 -1.296l6 -6l3 3l-6 6l-1.296 3.24a1.25 1.25 0 0 1 -2.044 .42z"
    />
  </svg>

`,
  "Backpack": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-backpack"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M5 18v-6a6 6 0 0 1 6 -6h2a6 6 0 0 1 6 6v6a3 3 0 0 1 -3 3h-8a3 3 0 0 1 -3 -3z" />
    <path d="M10 6v-1a2 2 0 1 1 4 0v1" />
    <path d="M9 21v-4a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v4" />
    <path d="M11 10h2" />
  </svg>

`,
  "Badge3d": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-badge-3d"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="14" rx="2" width="18" x="3" y="5" />
    <path d="M7 9.5a0.5 .5 0 0 1 .5 -.5h1a1.5 1.5 0 0 1 0 3h-.5h.5a1.5 1.5 0 0 1 0 3h-1a0.5 .5 0 0 1 -.5 -.5" />
    <path d="M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z" />
  </svg>

`,
  "Badge4k": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-badge-4k"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="14" rx="2" width="18" x="3" y="5" />
    <path d="M7 9v2a1 1 0 0 0 1 1h1" />
    <path d="M10 9v6" />
    <path d="M14 9v6" />
    <path d="M17 9l-2 3l2 3" />
    <path d="M15 12h-1" />
  </svg>

`,
  "BadgeAd": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-badge-ad"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="14" rx="2" width="18" x="3" y="5" />
    <path d="M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z" />
    <path d="M7 15v-4.5a1.5 1.5 0 0 1 3 0v4.5" />
    <path d="M7 13h3" />
  </svg>

`,
  "BadgeHd": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-badge-hd"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="14" rx="2" width="18" x="3" y="5" />
    <path d="M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z" />
    <path d="M7 15v-6" />
    <path d="M10 15v-6" />
    <path d="M7 12h3" />
  </svg>

`,
  "Ballpen": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-ballpen"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M14 6l7 7l-4 4" />
    <path
      d="M5.828 18.172a2.828 2.828 0 0 0 4 0l10.586 -10.586a2 2 0 0 0 0 -2.829l-1.171 -1.171a2 2 0 0 0 -2.829 0l-10.586 10.586a2.828 2.828 0 0 0 0 4z"
    />
    <path d="M4 20l1.768 -1.768" />
  </svg>

`,
  "Ban": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-ban"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="12" r="9" />
    <line x1="5.7" x2="18.3" y1="5.7" y2="18.3" />
  </svg>

`,
  "Basket": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-basket"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <polyline points="7 10 12 4 17 10" />
    <path d="M21 10l-2 8a2 2.5 0 0 1 -2 2h-10a2 2.5 0 0 1 -2 -2l-2 -8z" />
    <circle cx="12" cy="15" r="2" />
  </svg>

`,
  "Bell": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-bell"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M10 5a2 2 0 0 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6" />
    <path d="M9 17v1a3 3 0 0 0 6 0v-1" />
  </svg>

`,
  "Bluetooth": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-bluetooth"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <polyline points="7 8 17 16 12 20 12 4 17 8 7 16" />
  </svg>

`,
  "Bold": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-bold"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M7 5h6a3.5 3.5 0 0 1 0 7h-6z" />
    <path d="M13 12h1a3.5 3.5 0 0 1 0 7h-7v-7" />
  </svg>

`,
  "Bolt": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-bolt"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <polyline points="13 3 13 10 19 10 11 21 11 14 5 14 13 3" />
  </svg>

`,
  "Book": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-book"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M3 19a9 9 0 0 1 9 0a9 9 0 0 1 9 0" />
    <path d="M3 6a9 9 0 0 1 9 0a9 9 0 0 1 9 0" />
    <line x1="3" x2="3" y1="6" y2="19" />
    <line x1="12" x2="12" y1="6" y2="19" />
    <line x1="21" x2="21" y1="6" y2="19" />
  </svg>

`,
  "Bookmark": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-bookmark"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M9 4h6a2 2 0 0 1 2 2v14l-5 -3l-5 3v-14a2 2 0 0 1 2 -2" />
  </svg>

`,
  "Box": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-box"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <polyline points="12 3 20 7.5 20 16.5 12 21 4 16.5 4 7.5 12 3" />
    <line x1="12" x2="20" y1="12" y2="7.5" />
    <line x1="12" x2="12" y1="12" y2="21" />
    <line x1="12" x2="4" y1="12" y2="7.5" />
  </svg>

`,
  "BoxMultiple": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-box-multiple"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="14" rx="2" width="14" x="7" y="3" />
    <path d="M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2" />
  </svg>

`,
  "Briefcase": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-briefcase"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="13" rx="2" width="18" x="3" y="7" />
    <path d="M8 7v-2a2 2 0 0 1 2 -2h4a2 2 0 0 1 2 2v2" />
    <line x1="12" x2="12" y1="12" y2="12.01" />
    <path d="M3 13a20 20 0 0 0 18 0" />
  </svg>

`,
  "Browser": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-browser"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="16" rx="1" width="16" x="4" y="4" />
    <line x1="4" x2="20" y1="8" y2="8" />
    <line x1="8" x2="8" y1="4" y2="8" />
  </svg>

`,
  "Brush": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-brush"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M3 21v-4a4 4 0 1 1 4 4h-4" />
    <path d="M21 3a16 16 0 0 0 -12.8 10.2" />
    <path d="M21 3a16 16 0 0 1 -10.2 12.8" />
    <path d="M10.6 9a9 9 0 0 1 4.4 4.4" />
  </svg>

`,
  "Bucket": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-bucket"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <ellipse cx="12" cy="7" rx="8" ry="4" />
    <path
      d="M4 7c0 .664 .088 1.324 .263 1.965l2.737 10.035c.5 1.5 2.239 2 5 2s4.5 -.5 5 -2c.333 -1 1.246 -4.345 2.737 -10.035a7.45 7.45 0 0 0 .263 -1.965"
    />
  </svg>

`,
  "Bug": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-bug"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M9 9v-1a3 3 0 0 1 6 0v1" />
    <path d="M8 9h8a6 6 0 0 1 1 3v3a5 5 0 0 1 -10 0v-3a6 6 0 0 1 1 -3" />
    <line x1="3" x2="7" y1="13" y2="13" />
    <line x1="17" x2="21" y1="13" y2="13" />
    <line x1="12" x2="12" y1="20" y2="14" />
    <line x1="4" x2="7.35" y1="19" y2="17" />
    <line x1="20" x2="16.65" y1="19" y2="17" />
    <line x1="4" x2="7.75" y1="7" y2="9.4" />
    <line x1="20" x2="16.25" y1="7" y2="9.4" />
  </svg>

`,
  "Building": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-building"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="3" x2="21" y1="21" y2="21" />
    <line x1="9" x2="10" y1="8" y2="8" />
    <line x1="9" x2="10" y1="12" y2="12" />
    <line x1="9" x2="10" y1="16" y2="16" />
    <line x1="14" x2="15" y1="8" y2="8" />
    <line x1="14" x2="15" y1="12" y2="12" />
    <line x1="14" x2="15" y1="16" y2="16" />
    <path d="M5 21v-16a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v16" />
  </svg>

`,
  "BuildingFactory": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-building-factory"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M4 21c1.147 -4.02 1.983 -8.027 2 -12h6c.017 3.973 .853 7.98 2 12" />
    <path d="M12.5 13h4.5c.025 2.612 .894 5.296 2 8" />
    <path
      d="M9 5a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1"
    />
    <line x1="3" x2="22" y1="21" y2="21" />
  </svg>

`,
  "BuildingStore": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-building-store"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="3" x2="21" y1="21" y2="21" />
    <path d="M3 7v1a3 3 0 0 0 6 0v-1m0 1a3 3 0 0 0 6 0v-1m0 1a3 3 0 0 0 6 0v-1h-18l2 -4h14l2 4" />
    <line x1="5" x2="5" y1="21" y2="10.85" />
    <line x1="19" x2="19" y1="21" y2="10.85" />
    <path d="M9 21v-4a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v4" />
  </svg>

`,
  "Bulb": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-bulb"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M3 12h1m8 -9v1m8 8h1m-15.4 -6.4l.7 .7m12.1 -.7l-.7 .7" />
    <path d="M9 16a5 5 0 1 1 6 0a3.5 3.5 0 0 0 -1 3a2 2 0 0 1 -4 0a3.5 3.5 0 0 0 -1 -3" />
    <line x1="9.7" x2="14.3" y1="17" y2="17" />
  </svg>

`,
  "Bus": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-bus"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="6" cy="17" r="2" />
    <circle cx="18" cy="17" r="2" />
    <path d="M4 17h-2v-11a1 1 0 0 1 1 -1h14a5 7 0 0 1 5 7v5h-2m-4 0h-8" />
    <polyline points="16 5 17.5 12 22 12" />
    <line x1="2" x2="17" y1="10" y2="10" />
    <line x1="7" x2="7" y1="5" y2="10" />
    <line x1="12" x2="12" y1="5" y2="10" />
  </svg>

`,
  "Cake": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-cake"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M3 20h18v-8a3 3 0 0 0 -3 -3h-12a3 3 0 0 0 -3 3v8z" />
    <path
      d="M2.996 14.803c.312 .135 .654 .204 1.004 .197a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1c.35 .007 .692 -.062 1.004 -.197"
    />
    <path d="M12 4l1.465 1.638a2 2 0 1 1 -3.015 .099l1.55 -1.737z" />
  </svg>

`,
  "Calculator": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-calculator"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="18" rx="2" width="16" x="4" y="3" />
    <rect height="3" rx="1" width="8" x="8" y="7" />
    <line x1="8" x2="8" y1="14" y2="14.01" />
    <line x1="12" x2="12" y1="14" y2="14.01" />
    <line x1="16" x2="16" y1="14" y2="14.01" />
    <line x1="8" x2="8" y1="17" y2="17.01" />
    <line x1="12" x2="12" y1="17" y2="17.01" />
    <line x1="16" x2="16" y1="17" y2="17.01" />
  </svg>

`,
  "Calendar": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-calendar"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="16" rx="2" width="16" x="4" y="5" />
    <line x1="16" x2="16" y1="3" y2="7" />
    <line x1="8" x2="8" y1="3" y2="7" />
    <line x1="4" x2="20" y1="11" y2="11" />
    <line x1="11" x2="12" y1="15" y2="15" />
    <line x1="12" x2="12" y1="15" y2="18" />
  </svg>

`,
  "CalendarEvent": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-calendar-event"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="16" rx="2" width="16" x="4" y="5" />
    <line x1="16" x2="16" y1="3" y2="7" />
    <line x1="8" x2="8" y1="3" y2="7" />
    <line x1="4" x2="20" y1="11" y2="11" />
    <rect height="2" width="2" x="8" y="15" />
  </svg>

`,
  "Camera": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-camera"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path
      d="M5 7h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v9a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2"
    />
    <circle cx="12" cy="13" r="3" />
  </svg>

`,
  "Capture": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-capture"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M4 8v-2a2 2 0 0 1 2 -2h2" />
    <path d="M4 16v2a2 2 0 0 0 2 2h2" />
    <path d="M16 4h2a2 2 0 0 1 2 2v2" />
    <path d="M16 20h2a2 2 0 0 0 2 -2v-2" />
    <circle cx="12" cy="12" r="3" />
  </svg>

`,
  "Car": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-car"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="7" cy="17" r="2" />
    <circle cx="17" cy="17" r="2" />
    <path d="M5 17h-2v-6l2 -5h9l4 5h1a2 2 0 0 1 2 2v4h-2m-4 0h-6m-6 -6h15m-6 0v-5" />
  </svg>

`,
  "Cards": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-cards"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path
      d="M3.604 7.197l7.138 -3.109a0.96 .96 0 0 1 1.27 .527l4.924 11.902a1.004 1.004 0 0 1 -.514 1.304l-7.137 3.109a0.96 .96 0 0 1 -1.271 -.527l-4.924 -11.903a1.005 1.005 0 0 1 .514 -1.304z"
    />
    <path d="M15 4h1a1 1 0 0 1 1 1v3.5" />
    <path d="M20 6c.264 .112 .52 .217 .768 .315a1 1 0 0 1 .53 1.311l-2.298 5.374" />
  </svg>

`,
  "Cash": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-cash"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="10" rx="2" width="14" x="7" y="9" />
    <circle cx="14" cy="14" r="2" />
    <path d="M17 9v-2a2 2 0 0 0 -2 -2h-10a2 2 0 0 0 -2 2v6a2 2 0 0 0 2 2h2" />
  </svg>

`,
  "Cast": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-cast"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="3" x2="3.01" y1="19" y2="19" />
    <path d="M7 19a4 4 0 0 0 -4 -4" />
    <path d="M11 19a8 8 0 0 0 -8 -8" />
    <path d="M15 19h3a3 3 0 0 0 3 -3v-8a3 3 0 0 0 -3 -3h-12a3 3 0 0 0 -2.8 2" />
  </svg>

`,
  "Cat": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-cat"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path
      d="M20 3v10a8 8 0 1 1 -16 0v-10l3.432 3.432a7.963 7.963 0 0 1 4.568 -1.432c1.769 0 3.403 .574 4.728 1.546l3.272 -3.546z"
    />
    <path d="M2 16h5l-4 4" />
    <path d="M22 16h-5l4 4" />
    <circle cx="12" cy="16" r="1" />
    <path d="M9 11v.01" />
    <path d="M15 11v.01" />
  </svg>

`,
  "Category": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-category"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M4 4h6v6h-6z" />
    <path d="M14 4h6v6h-6z" />
    <path d="M4 14h6v6h-6z" />
    <circle cx="17" cy="17" r="3" />
  </svg>

`,
  "Certificate": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-certificate"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="15" cy="15" r="3" />
    <path d="M13 17.5v4.5l2 -1.5l2 1.5v-4.5" />
    <path d="M10 19h-5a2 2 0 0 1 -2 -2v-10c0 -1.1 .9 -2 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -1 1.73" />
    <line x1="6" x2="18" y1="9" y2="9" />
    <line x1="6" x2="9" y1="12" y2="12" />
    <line x1="6" x2="8" y1="15" y2="15" />
  </svg>

`,
  "ChartBar": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-chart-bar"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="8" rx="1" width="6" x="3" y="12" />
    <rect height="12" rx="1" width="6" x="9" y="8" />
    <rect height="16" rx="1" width="6" x="15" y="4" />
    <line x1="4" x2="18" y1="20" y2="20" />
  </svg>

`,
  "ChartDots": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-chart-dots"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M3 3v18h18" />
    <circle cx="9" cy="9" r="2" />
    <circle cx="19" cy="7" r="2" />
    <circle cx="14" cy="15" r="2" />
    <line x1="10.16" x2="12.5" y1="10.62" y2="13.5" />
    <path d="M15.088 13.328l2.837 -4.586" />
  </svg>

`,
  "ChartPie": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-chart-pie"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M10 3.2a9 9 0 1 0 10.8 10.8a1 1 0 0 0 -1 -1h-6.8a2 2 0 0 1 -2 -2v-7a0.9 .9 0 0 0 -1 -.8" />
    <path d="M15 3.5a9 9 0 0 1 5.5 5.5h-4.5a1 1 0 0 1 -1 -1v-4.5" />
  </svg>

`,
  "Check": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-check"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M5 12l5 5l10 -10" />
  </svg>

`,
  "Checkbox": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-checkbox"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <polyline points="9 11 12 14 20 6" />
    <path d="M20 12v6a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h9" />
  </svg>

`,
  "Checklist": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-checklist"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M9.615 20h-2.615a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v8" />
    <path d="M14 19l2 2l4 -4" />
    <path d="M9 8h4" />
    <path d="M9 12h2" />
  </svg>

`,
  "ChefHat": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-chef-hat"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path
      d="M12 3c1.918 0 3.52 1.35 3.91 3.151a4 4 0 0 1 2.09 7.723l0 7.126h-12v-7.126a4.002 4.002 0 1 1 2.092 -7.723a3.999 3.999 0 0 1 3.908 -3.151z"
    />
    <path d="M6.161 17.009l11.839 -.009" />
  </svg>

`,
  "ChevronDown": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-chevron-down"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <polyline points="6 9 12 15 18 9" />
  </svg>

`,
  "ChevronLeft": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-chevron-left"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <polyline points="15 6 9 12 15 18" />
  </svg>

`,
  "ChevronRight": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-chevron-right"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <polyline points="9 6 15 12 9 18" />
  </svg>

`,
  "ChevronUp": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-chevron-up"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <polyline points="6 15 12 9 18 15" />
  </svg>

`,
  "CirclePlus": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-circle-plus"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="12" r="9" />
    <line x1="9" x2="15" y1="12" y2="12" />
    <line x1="12" x2="12" y1="9" y2="15" />
  </svg>

`,
  "Circles": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-circles"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="7" r="4" />
    <circle cx="6.5" cy="17" r="4" />
    <circle cx="17.5" cy="17" r="4" />
  </svg>

`,
  "ClearAll": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-clear-all"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M8 6h12" />
    <path d="M6 12h12" />
    <path d="M4 18h12" />
  </svg>

`,
  "ClearFormatting": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-clear-formatting"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M17 15l4 4m0 -4l-4 4" />
    <path d="M7 6v-1h11v1" />
    <line x1="7" x2="11" y1="19" y2="19" />
    <line x1="13" x2="9" y1="5" y2="19" />
  </svg>

`,
  "Click": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-click"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="3" x2="6" y1="12" y2="12" />
    <line x1="12" x2="12" y1="3" y2="6" />
    <line x1="7.8" x2="5.6" y1="7.8" y2="5.6" />
    <line x1="16.2" x2="18.4" y1="7.8" y2="5.6" />
    <line x1="7.8" x2="5.6" y1="16.2" y2="18.4" />
    <path d="M12 12l9 3l-4 2l-2 4l-3 -9" />
  </svg>

`,
  "Clipboard": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-clipboard"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2" />
    <rect height="4" rx="2" width="6" x="9" y="3" />
  </svg>

`,
  "ClipboardCopy": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-clipboard-copy"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h3m9 -9v-5a2 2 0 0 0 -2 -2h-2" />
    <path d="M13 17v-1a1 1 0 0 1 1 -1h1m3 0h1a1 1 0 0 1 1 1v1m0 3v1a1 1 0 0 1 -1 1h-1m-3 0h-1a1 1 0 0 1 -1 -1v-1" />
    <rect height="4" rx="2" width="6" x="9" y="3" />
  </svg>

`,
  "Clock": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-clock"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="12" r="9" />
    <polyline points="12 7 12 12 15 15" />
  </svg>

`,
  "Cloud": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-cloud"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path
      d="M6.657 18c-2.572 0 -4.657 -2.007 -4.657 -4.483c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 .996c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.913 0 3.464 1.56 3.464 3.486c0 1.927 -1.551 3.487 -3.465 3.487h-11.878"
    />
  </svg>

`,
  "CloudComputing": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-cloud-computing"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path
      d="M6.657 16c-2.572 0 -4.657 -2.007 -4.657 -4.483c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 .996c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.913 0 3.464 1.56 3.464 3.486c0 1.927 -1.551 3.487 -3.465 3.487h-11.878"
    />
    <path d="M12 16v5" />
    <path d="M16 16v4a1 1 0 0 0 1 1h4" />
    <path d="M8 16v4a1 1 0 0 1 -1 1h-4" />
  </svg>

`,
  "Code": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-code"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <polyline points="7 8 3 12 7 16" />
    <polyline points="17 8 21 12 17 16" />
    <line x1="14" x2="10" y1="4" y2="20" />
  </svg>

`,
  "CodeCircle": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-code-circle"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M10 14l-2 -2l2 -2" />
    <path d="M14 10l2 2l-2 2" />
    <circle cx="12" cy="12" r="9" />
  </svg>

`,
  "CodeDots": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-code-dots"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M15 12h.01" />
    <path d="M12 12h.01" />
    <path d="M9 12h.01" />
    <path d="M6 19a2 2 0 0 1 -2 -2v-4l-1 -1l1 -1v-4a2 2 0 0 1 2 -2" />
    <path d="M18 19a2 2 0 0 0 2 -2v-4l1 -1l-1 -1v-4a2 2 0 0 0 -2 -2" />
  </svg>

`,
  "CodePlus": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-code-plus"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M9 12h6" />
    <path d="M12 9v6" />
    <path d="M6 19a2 2 0 0 1 -2 -2v-4l-1 -1l1 -1v-4a2 2 0 0 1 2 -2" />
    <path d="M18 19a2 2 0 0 0 2 -2v-4l1 -1l-1 -1v-4a2 2 0 0 0 -2 -2" />
  </svg>

`,
  "Coffee": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-coffee"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path
      d="M3 14c.83 .642 2.077 1.017 3.5 1c1.423 .017 2.67 -.358 3.5 -1c.83 -.642 2.077 -1.017 3.5 -1c1.423 -.017 2.67 .358 3.5 1"
    />
    <path d="M8 3a2.4 2.4 0 0 0 -1 2a2.4 2.4 0 0 0 1 2" />
    <path d="M12 3a2.4 2.4 0 0 0 -1 2a2.4 2.4 0 0 0 1 2" />
    <path d="M3 10h14v5a6 6 0 0 1 -6 6h-2a6 6 0 0 1 -6 -6v-5z" />
    <path d="M16.746 16.726a3 3 0 1 0 .252 -5.555" />
  </svg>

`,
  "Coin": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-coin"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="12" r="9" />
    <path d="M14.8 9a2 2 0 0 0 -1.8 -1h-2a2 2 0 1 0 0 4h2a2 2 0 1 1 0 4h-2a2 2 0 0 1 -1.8 -1" />
    <path d="M12 7v10" />
  </svg>

`,
  "Coins": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-coins"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M9 14c0 1.657 2.686 3 6 3s6 -1.343 6 -3s-2.686 -3 -6 -3s-6 1.343 -6 3z" />
    <path d="M9 14v4c0 1.656 2.686 3 6 3s6 -1.344 6 -3v-4" />
    <path
      d="M3 6c0 1.072 1.144 2.062 3 2.598s4.144 .536 6 0c1.856 -.536 3 -1.526 3 -2.598c0 -1.072 -1.144 -2.062 -3 -2.598s-4.144 -.536 -6 0c-1.856 .536 -3 1.526 -3 2.598z"
    />
    <path d="M3 6v10c0 .888 .772 1.45 2 2" />
    <path d="M3 11c0 .888 .772 1.45 2 2" />
  </svg>

`,
  "Command": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-command"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M7 9a2 2 0 1 1 2 -2v10a2 2 0 1 1 -2 -2h10a2 2 0 1 1 -2 2v-10a2 2 0 1 1 2 2h-10" />
  </svg>

`,
  "Compass": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-compass"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <polyline points="8 16 10 10 16 8 14 14 8 16" />
    <circle cx="12" cy="12" r="9" />
    <line x1="12" x2="12" y1="3" y2="5" />
    <line x1="12" x2="12" y1="19" y2="21" />
    <line x1="3" x2="5" y1="12" y2="12" />
    <line x1="19" x2="21" y1="12" y2="12" />
  </svg>

`,
  "Components": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-components"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M3 12l3 3l3 -3l-3 -3z" />
    <path d="M15 12l3 3l3 -3l-3 -3z" />
    <path d="M9 6l3 3l3 -3l-3 -3z" />
    <path d="M9 18l3 3l3 -3l-3 -3z" />
  </svg>

`,
  "Contrast": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-contrast"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="12" r="9" />
    <path d="M12 17a5 5 0 0 0 0 -10v10" />
  </svg>

`,
  "Cookie": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-cookie"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M8 13v.01" />
    <path d="M12 17v.01" />
    <path d="M12 12v.01" />
    <path d="M16 14v.01" />
    <path d="M11 8v.01" />
    <path
      d="M13.148 3.476l2.667 1.104a4 4 0 0 0 4.656 6.14l.053 .132a3 3 0 0 1 0 2.296c-.497 .786 -.838 1.404 -1.024 1.852c-.189 .456 -.409 1.194 -.66 2.216a3 3 0 0 1 -1.624 1.623c-1.048 .263 -1.787 .483 -2.216 .661c-.475 .197 -1.092 .538 -1.852 1.024a3 3 0 0 1 -2.296 0c-.802 -.503 -1.419 -.844 -1.852 -1.024c-.471 -.195 -1.21 -.415 -2.216 -.66a3 3 0 0 1 -1.623 -1.624c-.265 -1.052 -.485 -1.79 -.661 -2.216c-.198 -.479 -.54 -1.096 -1.024 -1.852a3 3 0 0 1 0 -2.296c.48 -.744 .82 -1.361 1.024 -1.852c.171 -.413 .391 -1.152 .66 -2.216a3 3 0 0 1 1.624 -1.623c1.032 -.256 1.77 -.476 2.216 -.661c.458 -.19 1.075 -.531 1.852 -1.024a3 3 0 0 1 2.296 0z"
    />
  </svg>

`,
  "Copy": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-copy"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="12" rx="2" width="12" x="8" y="8" />
    <path d="M16 8v-2a2 2 0 0 0 -2 -2h-8a2 2 0 0 0 -2 2v8a2 2 0 0 0 2 2h2" />
  </svg>

`,
  "Copyright": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-copyright"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="12" r="9" />
    <path d="M14 9.75a3.016 3.016 0 0 0 -4.163 .173a2.993 2.993 0 0 0 0 4.154a3.016 3.016 0 0 0 4.163 .173" />
  </svg>

`,
  "Cpu": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-cpu"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="14" rx="1" width="14" x="5" y="5" />
    <path d="M9 9h6v6h-6z" />
    <path d="M3 10h2" />
    <path d="M3 14h2" />
    <path d="M10 3v2" />
    <path d="M14 3v2" />
    <path d="M21 10h-2" />
    <path d="M21 14h-2" />
    <path d="M14 21v-2" />
    <path d="M10 21v-2" />
  </svg>

`,
  "CreditCard": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-credit-card"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="14" rx="3" width="18" x="3" y="5" />
    <line x1="3" x2="21" y1="10" y2="10" />
    <line x1="7" x2="7.01" y1="15" y2="15" />
    <line x1="11" x2="13" y1="15" y2="15" />
  </svg>

`,
  "Crop": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-crop"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M8 5v10a1 1 0 0 0 1 1h10" />
    <path d="M5 8h10a1 1 0 0 1 1 1v10" />
  </svg>

`,
  "Cup": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-cup"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M5 11h14v-3h-14z" />
    <path d="M17.5 11l-1.5 10h-8l-1.5 -10" />
    <path d="M6 8v-1a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v1" />
    <path d="M15 5v-2" />
  </svg>

`,
  "CurrencyCent": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-currency-cent"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path
      d="M16.007 7.54a5.965 5.965 0 0 0 -4.008 -1.54a5.996 5.996 0 0 0 -5.992 6c0 3.314 2.682 6 5.992 6a5.965 5.965 0 0 0 4.004 -1.536"
    />
    <path d="M12 20v-2" />
    <path d="M12 6v-2" />
  </svg>

`,
  "CurrencyDollar": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-currency-dollar"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M16.7 8a3 3 0 0 0 -2.7 -2h-4a3 3 0 0 0 0 6h4a3 3 0 0 1 0 6h-4a3 3 0 0 1 -2.7 -2" />
    <path d="M12 3v3m0 12v3" />
  </svg>

`,
  "CurrencyEuro": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-currency-euro"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M17.2 7a6 7 0 1 0 0 10" />
    <path d="M13 10h-8m0 4h8" />
  </svg>

`,
  "CurrentLocation": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-current-location"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="12" r="3" />
    <circle cx="12" cy="12" r="8" />
    <line x1="12" x2="12" y1="2" y2="4" />
    <line x1="12" x2="12" y1="20" y2="22" />
    <line x1="20" x2="22" y1="12" y2="12" />
    <line x1="2" x2="4" y1="12" y2="12" />
  </svg>

`,
  "Cut": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-cut"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="7" cy="17" r="3" />
    <circle cx="17" cy="17" r="3" />
    <line x1="9.15" x2="18" y1="14.85" y2="4" />
    <line x1="6" x2="14.85" y1="4" y2="14.85" />
  </svg>

`,
  "Cylinder": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-cylinder"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <ellipse cx="12" cy="6" rx="5" ry="3" />
    <path d="M7 6v12c0 1.657 2.239 3 5 3s5 -1.343 5 -3v-12" />
  </svg>

`,
  "Database": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-database"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <ellipse cx="12" cy="6" rx="8" ry="3" />
    <path d="M4 6v6a8 3 0 0 0 16 0v-6" />
    <path d="M4 12v6a8 3 0 0 0 16 0v-6" />
  </svg>

`,
  "DatabaseExport": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-database-export"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <ellipse cx="12" cy="6" rx="8" ry="3" />
    <path d="M4 6v6c0 1.657 3.582 3 8 3a19.84 19.84 0 0 0 3.302 -.267m4.698 -2.733v-6" />
    <path d="M4 12v6c0 1.599 3.335 2.905 7.538 2.995m8.462 -6.995v-2m-6 7h7m-3 -3l3 3l-3 3" />
  </svg>

`,
  "DatabaseImport": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-database-import"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <ellipse cx="12" cy="6" rx="8" ry="3" />
    <path d="M4 6v8m5.009 .783c.924 .14 1.933 .217 2.991 .217c4.418 0 8 -1.343 8 -3v-6" />
    <path d="M11.252 20.987c.246 .009 .496 .013 .748 .013c4.418 0 8 -1.343 8 -3v-6m-18 7h7m-3 -3l3 3l-3 3" />
  </svg>

`,
  "Delta": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-delta"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M4 20h16l-8 -16z" />
  </svg>

`,
  "DeviceDesktop": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-device-desktop"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="12" rx="1" width="18" x="3" y="4" />
    <line x1="7" x2="17" y1="20" y2="20" />
    <line x1="9" x2="9" y1="16" y2="20" />
    <line x1="15" x2="15" y1="16" y2="20" />
  </svg>

`,
  "DeviceFloppy": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-device-floppy"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M6 4h10l4 4v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2" />
    <circle cx="12" cy="14" r="2" />
    <polyline points="14 4 14 8 8 8 8 4" />
  </svg>

`,
  "DeviceGamepad": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-device-gamepad"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="12" rx="2" width="20" x="2" y="6" />
    <path d="M6 12h4m-2 -2v4" />
    <line x1="15" x2="15" y1="11" y2="11.01" />
    <line x1="18" x2="18" y1="13" y2="13.01" />
  </svg>

`,
  "DeviceIpad": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-device-ipad"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M20 4v16a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-16a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2z" />
    <path d="M9 19h6" />
  </svg>

`,
  "DeviceMobile": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-device-mobile"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="18" rx="2" width="12" x="6" y="3" />
    <line x1="11" x2="13" y1="4" y2="4" />
    <line x1="12" x2="12" y1="17" y2="17.01" />
  </svg>

`,
  "DeviceNintendo": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-device-nintendo"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M10 20v-16h-3a4 4 0 0 0 -4 4v8a4 4 0 0 0 4 4h3z" />
    <path d="M14 20v-16h3a4 4 0 0 1 4 4v8a4 4 0 0 1 -4 4h-3z" />
    <circle cx="17.5" cy="15.5" fill="currentColor" r="1" />
    <circle cx="6.5" cy="8.5" fill="currentColor" r="1" />
  </svg>

`,
  "DeviceSdCard": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-device-sd-card"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path
      d="M7 21h10a2 2 0 0 0 2 -2v-14a2 2 0 0 0 -2 -2h-6.172a2 2 0 0 0 -1.414 .586l-3.828 3.828a2 2 0 0 0 -.586 1.414v10.172a2 2 0 0 0 2 2z"
    />
    <path d="M13 6v2" />
    <path d="M16 6v2" />
    <path d="M10 7v1" />
  </svg>

`,
  "DeviceTablet": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-device-tablet"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="18" rx="1" width="14" x="5" y="3" />
    <circle cx="12" cy="17" r="1" />
  </svg>

`,
  "DeviceTv": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-device-tv"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="13" rx="2" width="18" x="3" y="7" />
    <polyline points="16 3 12 7 8 3" />
  </svg>

`,
  "DeviceWatch": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-device-watch"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="12" rx="3" width="12" x="6" y="6" />
    <path d="M9 18v3h6v-3" />
    <path d="M9 6v-3h6v3" />
  </svg>

`,
  "Devices": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-devices"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="12" rx="1" width="8" x="13" y="8" />
    <path d="M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h9" />
    <line x1="16" x2="18" y1="9" y2="9" />
  </svg>

`,
  "Devices2": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-devices-2"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M10 15h-6a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h6" />
    <rect height="16" rx="1" width="8" x="13" y="4" />
    <line x1="7" x2="10" y1="19" y2="19" />
    <line x1="17" x2="17" y1="8" y2="8.01" />
    <circle cx="17" cy="16" r="1" />
    <line x1="9" x2="9" y1="15" y2="19" />
  </svg>

`,
  "Dialpad": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-dialpad"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M3 3h4v4h-4z" />
    <path d="M17 3h4v4h-4z" />
    <path d="M10 3h4v4h-4z" />
    <path d="M3 10h4v4h-4z" />
    <path d="M17 10h4v4h-4z" />
    <path d="M10 10h4v4h-4z" />
    <path d="M10 17h4v4h-4z" />
  </svg>

`,
  "Diamond": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-diamond"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M6 5h12l3 5l-8.5 9.5a0.7 .7 0 0 1 -1 0l-8.5 -9.5l3 -5" />
    <path d="M10 12l-2 -2.2l.6 -1" />
  </svg>

`,
  "Dice": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-dice"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="16" rx="2" width="16" x="4" y="4" />
    <circle cx="8.5" cy="8.5" fill="currentColor" r=".5" />
    <circle cx="15.5" cy="8.5" fill="currentColor" r=".5" />
    <circle cx="15.5" cy="15.5" fill="currentColor" r=".5" />
    <circle cx="8.5" cy="15.5" fill="currentColor" r=".5" />
  </svg>

`,
  "Disabled": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-disabled"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="11" cy="5" r="2" />
    <polyline points="11 7 11 15 15 15 19 20" />
    <line x1="11" x2="16" y1="11" y2="11" />
    <path d="M7 11.5a5 5 0 1 0 6 7.5" />
  </svg>

`,
  "Disc": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-disc"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="12" r="9" />
    <circle cx="12" cy="12" r="1" />
    <path d="M7 12a5 5 0 0 1 5 -5" />
    <path d="M12 17a5 5 0 0 0 5 -5" />
  </svg>

`,
  "Discount": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-discount"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="9" x2="15" y1="15" y2="9" />
    <circle cx="9.5" cy="9.5" fill="currentColor" r=".5" />
    <circle cx="14.5" cy="14.5" fill="currentColor" r=".5" />
    <circle cx="12" cy="12" r="9" />
  </svg>

`,
  "DiscountCheck": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-discount-check"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path
      d="M5 7.2a2.2 2.2 0 0 1 2.2 -2.2h1a2.2 2.2 0 0 0 1.55 -.64l.7 -.7a2.2 2.2 0 0 1 3.12 0l.7 .7c.412 .41 .97 .64 1.55 .64h1a2.2 2.2 0 0 1 2.2 2.2v1c0 .58 .23 1.138 .64 1.55l.7 .7a2.2 2.2 0 0 1 0 3.12l-.7 .7a2.2 2.2 0 0 0 -.64 1.55v1a2.2 2.2 0 0 1 -2.2 2.2h-1a2.2 2.2 0 0 0 -1.55 .64l-.7 .7a2.2 2.2 0 0 1 -3.12 0l-.7 -.7a2.2 2.2 0 0 0 -1.55 -.64h-1a2.2 2.2 0 0 1 -2.2 -2.2v-1a2.2 2.2 0 0 0 -.64 -1.55l-.7 -.7a2.2 2.2 0 0 1 0 -3.12l.7 -.7a2.2 2.2 0 0 0 .64 -1.55v-1"
    />
    <path d="M9 12l2 2l4 -4" />
  </svg>

`,
  "Dog": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-dog"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M11 5h2" />
    <path d="M19 12c-.667 5.333 -2.333 8 -5 8h-4c-2.667 0 -4.333 -2.667 -5 -8" />
    <path d="M11 16c0 .667 .333 1 1 1s1 -.333 1 -1h-2z" />
    <path d="M12 18v2" />
    <path d="M10 11v.01" />
    <path d="M14 11v.01" />
    <path d="M5 4l6 .97l-6.238 6.688a1.021 1.021 0 0 1 -1.41 .111a0.953 .953 0 0 1 -.327 -.954l1.975 -6.815z" />
    <path d="M19 4l-6 .97l6.238 6.688c.358 .408 .989 .458 1.41 .111a0.953 .953 0 0 0 .327 -.954l-1.975 -6.815z" />
  </svg>

`,
  "Door": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-door"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M14 12v.01" />
    <path d="M3 21h18" />
    <path d="M6 21v-16a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v16" />
  </svg>

`,
  "DotsVertical": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-dots-vertical"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="12" r="1" />
    <circle cx="12" cy="19" r="1" />
    <circle cx="12" cy="5" r="1" />
  </svg>

`,
  "Download": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-download"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M4 17v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2 -2v-2" />
    <polyline points="7 11 12 16 17 11" />
    <line x1="12" x2="12" y1="4" y2="16" />
  </svg>

`,
  "Droplet": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-droplet"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M6.8 11a6 6 0 1 0 10.396 0l-5.197 -8l-5.2 8z" />
  </svg>

`,
  "EPassport": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-e-passport"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <rect height="14" rx="1.999" width="20" x="2" y="5" />
    <circle cx="12" cy="12" r="3" />
    <path d="M9 12h-7" />
    <path d="M15 12h7" />
  </svg>

`,
  "Edit": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-edit"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1" />
    <path d="M20.385 6.585a2.1 2.1 0 0 0 -2.97 -2.97l-8.415 8.385v3h3l8.385 -8.415z" />
    <path d="M16 5l3 3" />
  </svg>

`,
  "Egg": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-egg"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path
      d="M19 14.083c0 4.154 -2.966 6.74 -7 6.917c-4.2 .006 -7 -2.763 -7 -6.917c0 -5.538 3.5 -11.09 7 -11.083c3.5 .007 7 5.545 7 11.083z"
    />
  </svg>

`,
  "Eraser": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-eraser"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M19 20h-10.5l-4.21 -4.3a1 1 0 0 1 0 -1.41l10 -10a1 1 0 0 1 1.41 0l5 5a1 1 0 0 1 0 1.41l-9.2 9.3" />
    <path d="M18 13.3l-6.3 -6.3" />
  </svg>

`,
  "ExclamationCircle": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-exclamation-circle"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="12" r="9" />
    <path d="M12 9v4" />
    <path d="M12 16v.01" />
  </svg>

`,
  "ExternalLink": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-external-link"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M11 7h-5a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-5" />
    <line x1="10" x2="20" y1="14" y2="4" />
    <polyline points="15 4 20 4 20 9" />
  </svg>

`,
  "Eye": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-eye"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="12" r="2" />
    <path d="M22 12c-2.667 4.667 -6 7 -10 7s-7.333 -2.333 -10 -7c2.667 -4.667 6 -7 10 -7s7.333 2.333 10 7" />
  </svg>

`,
  "EyeOff": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-eye-off"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="3" x2="21" y1="3" y2="21" />
    <path d="M10.584 10.587a2 2 0 0 0 2.828 2.83" />
    <path
      d="M9.363 5.365a9.466 9.466 0 0 1 2.637 -.365c4 0 7.333 2.333 10 7c-.778 1.361 -1.612 2.524 -2.503 3.488m-2.14 1.861c-1.631 1.1 -3.415 1.651 -5.357 1.651c-4 0 -7.333 -2.333 -10 -7c1.369 -2.395 2.913 -4.175 4.632 -5.341"
    />
  </svg>

`,
  "Eyeglass": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-eyeglass"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M8 4h-2l-3 10" />
    <path d="M16 4h2l3 10" />
    <line x1="10" x2="14" y1="16" y2="16" />
    <path d="M21 16.5a3.5 3.5 0 0 1 -7 0v-2.5h7v2.5" />
    <path d="M10 16.5a3.5 3.5 0 0 1 -7 0v-2.5h7v2.5" />
  </svg>

`,
  "File": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-file"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M14 3v4a1 1 0 0 0 1 1h4" />
    <path d="M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z" />
  </svg>

`,
  "FileCertificate": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-file-certificate"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M14 3v4a1 1 0 0 0 1 1h4" />
    <path d="M5 8v-3a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2h-5" />
    <circle cx="6" cy="14" r="3" />
    <path d="M4.5 17l-1.5 5l3 -1.5l3 1.5l-1.5 -5" />
  </svg>

`,
  "FilePlus": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-file-plus"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M14 3v4a1 1 0 0 0 1 1h4" />
    <path d="M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z" />
    <line x1="12" x2="12" y1="11" y2="17" />
    <line x1="9" x2="15" y1="14" y2="14" />
  </svg>

`,
  "FileSearch": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-file-search"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M14 3v4a1 1 0 0 0 1 1h4" />
    <path d="M12 21h-5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v4.5" />
    <circle cx="16.5" cy="17.5" r="2.5" />
    <line x1="18.5" x2="21" y1="19.5" y2="22" />
  </svg>

`,
  "FileSpreadsheet": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-file-spreadsheet"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M14 3v4a1 1 0 0 0 1 1h4" />
    <path d="M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z" />
    <path d="M8 11h8v7h-8z" />
    <path d="M8 15h8" />
    <path d="M11 11v7" />
  </svg>

`,
  "FileText": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-file-text"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M14 3v4a1 1 0 0 0 1 1h4" />
    <path d="M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z" />
    <line x1="9" x2="10" y1="9" y2="9" />
    <line x1="9" x2="15" y1="13" y2="13" />
    <line x1="9" x2="15" y1="17" y2="17" />
  </svg>

`,
  "FileZip": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-file-zip"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M6 20.735a2 2 0 0 1 -1 -1.735v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2h-1" />
    <path d="M11 17a2 2 0 0 1 2 2v2a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-2a2 2 0 0 1 2 -2z" />
    <line x1="11" x2="10" y1="5" y2="5" />
    <line x1="13" x2="12" y1="7" y2="7" />
    <line x1="11" x2="10" y1="9" y2="9" />
    <line x1="13" x2="12" y1="11" y2="11" />
    <line x1="11" x2="10" y1="13" y2="13" />
    <line x1="13" x2="12" y1="15" y2="15" />
  </svg>

`,
  "Files": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-files"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M15 3v4a1 1 0 0 0 1 1h4" />
    <path d="M18 17h-7a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h4l5 5v7a2 2 0 0 1 -2 2z" />
    <path d="M16 17v2a2 2 0 0 1 -2 2h-7a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2" />
  </svg>

`,
  "Filter": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-filter"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M5.5 5h13a1 1 0 0 1 .5 1.5l-5 5.5l0 7l-4 -3l0 -4l-5 -5.5a1 1 0 0 1 .5 -1.5" />
  </svg>

`,
  "FilterOff": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-filter-off"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="3" x2="21" y1="3" y2="21" />
    <path d="M9 5h9.5a1 1 0 0 1 .5 1.5l-4.049 4.454m-.951 3.046v5l-4 -3v-4l-5 -5.5a1 1 0 0 1 .18 -1.316" />
  </svg>

`,
  "Fingerprint": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-fingerprint"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M18.9 7a8 8 0 0 1 1.1 5v1a6 6 0 0 0 .8 3" />
    <path d="M8 11a4 4 0 0 1 8 0v1a10 10 0 0 0 2 6" />
    <path d="M12 11v2a14 14 0 0 0 2.5 8" />
    <path d="M8 15a18 18 0 0 0 1.8 6" />
    <path d="M4.9 19a22 22 0 0 1 -.9 -7v-1a8 8 0 0 1 12 -6.95" />
  </svg>

`,
  "Fish": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-fish"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M16.69 7.44a6.973 6.973 0 0 0 -1.69 4.56c0 1.747 .64 3.345 1.699 4.571" />
    <path d="M2 9.504c7.715 8.647 14.75 10.265 20 2.498c-5.25 -7.761 -12.285 -6.142 -20 2.504" />
    <path d="M18 11v.01" />
    <path d="M11.5 10.5c-.667 1 -.667 2 0 3" />
  </svg>

`,
  "Flag": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-flag"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="5" x2="5" y1="5" y2="21" />
    <line x1="19" x2="19" y1="5" y2="14" />
    <path d="M5 5a5 5 0 0 1 7 0a5 5 0 0 0 7 0" />
    <path d="M5 14a5 5 0 0 1 7 0a5 5 0 0 0 7 0" />
  </svg>

`,
  "Flare": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-flare"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M12 3l3 6l6 3l-6 3l-3 6l-3 -6l-6 -3l6 -3z" />
  </svg>

`,
  "Flask": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-flask"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <line x1="9" x2="15" y1="3" y2="3" />
    <line x1="10" x2="14" y1="9" y2="9" />
    <path d="M10 3v6l-4 11a0.7 .7 0 0 0 .5 1h11a0.7 .7 0 0 0 .5 -1l-4 -11v-6" />
  </svg>

`,
  "Focus": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-focus"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="12" fill="currentColor" r=".5" />
    <circle cx="12" cy="12" r="9" />
  </svg>

`,
  "FocusCentered": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-focus-centered"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <circle cx="12" cy="12" r="1" />
    <path d="M4 8v-2a2 2 0 0 1 2 -2h2" />
    <path d="M4 16v2a2 2 0 0 0 2 2h2" />
    <path d="M16 4h2a2 2 0 0 1 2 2v2" />
    <path d="M16 20h2a2 2 0 0 0 2 -2v-2" />
  </svg>

`,
  "Folder": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-folder"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M5 4h4l3 3h7a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2" />
  </svg>

`,
  "FolderPlus": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
    stroke-linecap="round"
    stroke-linejoin="round"
    stroke-width="2"
    viewBox="0 0 24 24"
    width="24"
    xmlns="http://www.w3.org/2000/svg"
    class="icon icon-tabler icon-tabler-folder-plus"
  >
    <path d="M0 0h24v24H0z" fill="none" stroke="none" />
    <path d="M5 4h4l3 3h7a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-11a2 2 0 0 1 2 -2" />
    <line x1="12" x2="12" y1="10" y2="16" />
    <line x1="9" x2="15" y1="13" y2="13" />
  </svg>

`,
  "Forms": `
  <svg
    fill="none"
    height="24"
    stroke="currentColor"
 