import { d as defineEventHandler, e as getQuery, f as query2string, c as createError, q as query, b as setResponseStatus } from '../../nitro/nitro.mjs';
import z from 'zod';
import 'nodemailer';
import 'zod/v4';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'crypto';
import 'fs-extra';
import 'path';
import 'node:url';
import 'fs';
import 'mime-types';
import '@antfu/utils';
import 'dot-prop';
import 'redis';
import 'consola';
import 'pg';
import 'sequelize';
import 'pg-connection-string';
import 'colorette';
import '@aws-sdk/client-s3';
import 'jsonwebtoken';
import 'nanoid';
import 'pluralize-esm';
import 'argon2';
import 'sharp';
import 'accept-language-parser';

const queryScema = z.object({
  page: z.coerce.number().int().nonnegative().nullish(),
  limit: z.coerce.number().int().nonnegative().nullish()
});
const news_get = defineEventHandler(async (event) => {
  const q = getQuery(event);
  const parse = queryScema.safeParse({
    page: query2string(q.page),
    limit: query2string(q.limit)
  });
  if (!parse.success) {
    throw createError({
      status: 400,
      data: parse.error
    });
  }
  const { page, limit } = parse.data;
  const pages = await query("news").where("public", true).select({
    title: true,
    path: true,
    previewImg: true,
    displayDate: true,
    sharingImage: true
  }).order("displayDate", "desc").populate().paginate(page || 1, Math.min(limit || 20, 100));
  setResponseStatus(event, 200);
  return pages;
});

export { news_get as default };
//# sourceMappingURL=news.get.mjs.map
