import { _ as _sfc_main$2 } from "./BButton.vue_vue_type_script_setup_true_lang-D-y5ASo-.mjs";
import { defineComponent, mergeModels, useSlots, useTemplateRef, useModel, computed, watchEffect, watch, createBlock, createCommentVNode, unref, openBlock, Transition, mergeProps, withCtx, withDirectives, createElementVNode, normalizeClass, createElementBlock, resolveDynamicComponent, renderSlot, normalizeProps, guardReactiveProps, toDisplayString, Fragment, withModifiers, createTextVNode, vShow } from "vue";
import { u as useBLinkHelper, _ as _sfc_main$1 } from "./BLink.vue_vue_type_script_setup_true_lang-Crq1j_mE.mjs";
import { _ as _sfc_main$3 } from "./BCloseButton.vue_vue_type_script_setup_true_lang-DCcXsu_x.mjs";
import { _ as _sfc_main$4 } from "./BProgress.vue_vue_type_script_setup_true_lang-BX1yVXH1.mjs";
import { u as useCountdown, a as useCountdownHover } from "./useCountdownHover-DbP9DMfh.mjs";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { u as useId } from "./useId-vZvGlR-1.mjs";
import { u as useShowHide } from "./useShowHide-CXGi2s6p.mjs";
const _hoisted_1 = ["id", "role", "aria-live", "aria-atomic"];
const _hoisted_2 = {
  key: 1,
  class: "d-flex gap-2"
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BAlert",
  props: /* @__PURE__ */ mergeModels({
    alertClass: { default: void 0 },
    body: { default: void 0 },
    bodyClass: { default: void 0 },
    closeClass: { default: void 0 },
    closeContent: { default: void 0 },
    closeLabel: { default: "Close" },
    closeVariant: { default: "secondary" },
    dismissible: { type: Boolean, default: false },
    headerClass: { default: void 0 },
    headerTag: { default: "div" },
    id: { default: void 0 },
    interval: { default: "requestAnimationFrame" },
    isStatus: { type: Boolean, default: false },
    noHoverPause: { type: Boolean, default: false },
    noResumeOnHoverLeave: { type: Boolean, default: false },
    progressProps: { default: void 0 },
    showOnPause: { type: Boolean, default: true },
    title: { default: void 0 },
    variant: { default: "info" },
    bgVariant: { default: null },
    textVariant: { default: null },
    active: { type: Boolean, default: void 0 },
    activeClass: { default: void 0 },
    disabled: { type: Boolean, default: void 0 },
    exactActiveClass: { default: void 0 },
    href: { default: void 0 },
    icon: { type: Boolean, default: void 0 },
    noRel: { type: Boolean, default: void 0 },
    opacity: { default: void 0 },
    opacityHover: { default: void 0 },
    prefetch: { type: Boolean },
    prefetchOn: {},
    noPrefetch: { type: Boolean },
    prefetchedClass: {},
    rel: { default: void 0 },
    replace: { type: Boolean, default: void 0 },
    routerComponentName: { default: void 0 },
    stretched: { type: Boolean, default: false },
    target: { default: void 0 },
    to: { default: void 0 },
    underlineOffset: { default: void 0 },
    underlineOffsetHover: { default: void 0 },
    underlineOpacity: { default: void 0 },
    underlineOpacityHover: { default: void 0 },
    underlineVariant: { default: void 0 },
    initialAnimation: { type: Boolean, default: false },
    noAnimation: { type: Boolean },
    noFade: { type: Boolean, default: false },
    lazy: { type: Boolean, default: false },
    unmountLazy: { type: Boolean, default: false },
    show: { type: Boolean, default: false },
    transProps: { default: void 0 },
    visible: { type: Boolean, default: false }
  }, {
    "modelValue": { type: [Boolean, Number], ...{ default: false } },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["close", "close-countdown", "hide", "hide-prevented", "hidden", "show", "show-prevented", "shown", "toggle", "toggle-prevented", "cancel", "ok"], ["update:modelValue"]),
  setup(__props, { expose: __expose, emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BAlert");
    const emit = __emit;
    const slots = useSlots();
    const element = useTemplateRef("_element");
    const modelValue = useModel(__props, "modelValue");
    const { computedLink, computedLinkProps } = useBLinkHelper(props);
    const computedId = useId(() => props.id, "alert");
    const {
      showRef,
      renderRef,
      hide,
      toggle,
      show,
      buildTriggerableEvent,
      computedNoAnimation,
      isVisible,
      transitionProps,
      contentShowing
    } = useShowHide(modelValue, props, emit, element, computedId);
    const countdownLength = computed(
      () => typeof modelValue.value === "boolean" ? 0 : modelValue.value
    );
    const {
      isActive,
      pause,
      restart,
      resume,
      stop,
      isPaused,
      value: remainingMs
    } = useCountdown(countdownLength, props.interval, {
      immediate: typeof modelValue.value === "number" && !!modelValue.value
    });
    useCountdownHover(
      element,
      {
        noHoverPause: () => props.noHoverPause || typeof modelValue.value !== "number",
        noResumeOnHoverLeave: () => props.noResumeOnHoverLeave || typeof modelValue.value !== "number",
        modelValueIgnoresHover: () => typeof modelValue.value === "boolean"
      },
      { pause, resume }
    );
    watchEffect(() => {
      emit("close-countdown", remainingMs.value);
    });
    const computedTag = computed(() => computedLink.value ? _sfc_main$1 : "div");
    const isAlertVisible = computed(
      () => showRef.value || isActive.value || props.showOnPause && isPaused.value
    );
    const computedClasses = computed(() => [
      // colorClasses.value,
      {
        [`alert-${props.variant}`]: props.variant !== null,
        "alert-dismissible": props.dismissible && !(slots.close || props.closeContent),
        "show": isVisible.value,
        "fade": !computedNoAnimation.value
      }
    ]);
    watch(modelValue, (newValue) => {
      if (typeof newValue === "number") {
        const event = buildTriggerableEvent("show", { cancelable: true, trigger: "model" });
        emit("show", event);
        if (event.defaultPrevented) {
          emit("show-prevented", buildTriggerableEvent("show-prevented"));
        } else {
          restart();
        }
      }
    });
    watch(isActive, (newValue) => {
      if (newValue === false && isPaused.value === false) {
        hide();
        modelValue.value = 0;
        stop();
      }
    });
    const sharedSlots = computed(() => ({
      toggle,
      show,
      hide,
      id: computedId.value,
      visible: showRef.value,
      active: isActive.value
    }));
    __expose({
      show,
      hide,
      toggle,
      pause,
      restart,
      resume,
      stop
    });
    return (_ctx, _cache) => {
      const _component_BButton = _sfc_main$2;
      return unref(renderRef) || unref(contentShowing) ? (openBlock(), createBlock(Transition, mergeProps({ key: 0 }, unref(transitionProps), {
        appear: !!modelValue.value || unref(props).visible
      }), {
        default: withCtx(() => [
          withDirectives(createElementVNode("div", {
            id: unref(props).id,
            ref: "_element",
            class: normalizeClass(["alert", [unref(props).alertClass, computedClasses.value]]),
            tabindex: "0",
            role: !isAlertVisible.value ? void 0 : unref(props).isStatus ? "status" : "alert",
            "aria-live": !isAlertVisible.value ? void 0 : unref(props).isStatus ? "polite" : "assertive",
            "aria-atomic": !isAlertVisible.value ? void 0 : true
          }, [
            unref(contentShowing) && (slots.title || unref(props).title) ? (openBlock(), createBlock(resolveDynamicComponent(unref(props).headerTag), {
              key: 0,
              class: normalizeClass(["alert-heading d-flex gap-2", unref(props).headerClass])
            }, {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, "title", normalizeProps(guardReactiveProps(sharedSlots.value)), () => [
                  createElementVNode("span", null, toDisplayString(unref(props).title), 1)
                ]),
                unref(props).dismissible ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                  slots.close || unref(props).closeContent ? (openBlock(), createBlock(_component_BButton, {
                    key: 0,
                    class: normalizeClass([[unref(props).closeClass], "ms-auto ps-1 btn-close-custom"]),
                    variant: unref(props).closeVariant,
                    onClick: _cache[0] || (_cache[0] = withModifiers(($event) => unref(hide)("close"), ["stop", "prevent"]))
                  }, {
                    default: withCtx(() => [
                      renderSlot(_ctx.$slots, "close", normalizeProps(guardReactiveProps(sharedSlots.value)), () => [
                        createTextVNode(toDisplayString(unref(props).closeContent), 1)
                      ])
                    ]),
                    _: 3
                  }, 8, ["class", "variant"])) : (openBlock(), createBlock(_sfc_main$3, {
                    key: 1,
                    "aria-label": unref(props).closeLabel,
                    class: normalizeClass([unref(props).closeClass]),
                    onClick: _cache[1] || (_cache[1] = withModifiers(($event) => unref(hide)("close"), ["stop", "prevent"]))
                  }, null, 8, ["aria-label", "class"]))
                ], 64)) : createCommentVNode("", true)
              ]),
              _: 3
            }, 8, ["class"])) : createCommentVNode("", true),
            unref(contentShowing) && (slots.default || unref(props).body) ? (openBlock(), createElementBlock("div", _hoisted_2, [
              (openBlock(), createBlock(resolveDynamicComponent(computedTag.value), mergeProps({
                class: ["alert-body", unref(props).bodyClass]
              }, unref(computedLinkProps), {
                onClick: _cache[2] || (_cache[2] = ($event) => unref(computedLink) && unref(props).dismissible ? unref(hide)() : () => {
                })
              }), {
                default: withCtx(() => [
                  renderSlot(_ctx.$slots, "default", normalizeProps(guardReactiveProps(sharedSlots.value)), () => [
                    createTextVNode(toDisplayString(unref(props).body), 1)
                  ])
                ]),
                _: 3
              }, 16, ["class"])),
              unref(props).dismissible && !(slots.title || unref(props).title) ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                slots.close || unref(props).closeContent ? (openBlock(), createBlock(_component_BButton, {
                  key: 0,
                  class: normalizeClass([[unref(props).closeClass], "ms-auto btn-close-custom"]),
                  variant: unref(props).closeVariant,
                  onClick: _cache[3] || (_cache[3] = withModifiers(($event) => unref(hide)("close"), ["stop", "prevent"]))
                }, {
                  default: withCtx(() => [
                    renderSlot(_ctx.$slots, "close", normalizeProps(guardReactiveProps(sharedSlots.value)), () => [
                      createTextVNode(toDisplayString(unref(props).closeContent), 1)
                    ])
                  ]),
                  _: 3
                }, 8, ["class", "variant"])) : (openBlock(), createBlock(_sfc_main$3, {
                  key: 1,
                  "aria-label": unref(props).closeLabel,
                  class: normalizeClass([unref(props).closeClass]),
                  onClick: _cache[4] || (_cache[4] = withModifiers(($event) => unref(hide)("close"), ["stop", "prevent"]))
                }, null, 8, ["aria-label", "class"]))
              ], 64)) : createCommentVNode("", true)
            ])) : createCommentVNode("", true),
            typeof modelValue.value === "number" && unref(props).progressProps !== void 0 ? (openBlock(), createBlock(_sfc_main$4, {
              key: 2,
              animated: unref(props).progressProps.animated,
              precision: unref(props).progressProps.precision,
              "show-progress": unref(props).progressProps.showProgress,
              "show-value": unref(props).progressProps.showValue,
              striped: unref(props).progressProps.striped,
              variant: unref(props).progressProps.variant,
              max: modelValue.value,
              value: unref(remainingMs),
              height: "4px"
            }, null, 8, ["animated", "precision", "show-progress", "show-value", "striped", "variant", "max", "value"])) : createCommentVNode("", true)
          ], 10, _hoisted_1), [
            [vShow, isAlertVisible.value]
          ])
        ]),
        _: 3
      }, 16, ["appear"])) : createCommentVNode("", true);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BAlert.vue_vue_type_script_setup_true_lang-CWJ2tlQa.mjs.map
