import { defineComponent, mergeModels, useModel, useTemplateRef, computed, readonly, provide, toRef, createElementBlock, openBlock, Fragment, renderSlot, createBlock, createCommentVNode, normalizeProps, guardReactiveProps, unref, Transition, mergeProps, withCtx, withDirectives, resolveDynamicComponent, vShow } from "vue";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { u as useId } from "./useId-vZvGlR-1.mjs";
import { c as collapseInjectionKey } from "./keys-CwytVEYF.mjs";
import { u as useShowHide } from "./useShowHide-CXGi2s6p.mjs";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BCollapse",
  props: /* @__PURE__ */ mergeModels({
    horizontal: { type: Boolean, default: false },
    id: { default: void 0 },
    isNav: { type: Boolean, default: false },
    tag: { default: "div" },
    initialAnimation: { type: Boolean, default: false },
    noAnimation: { type: Boolean, default: false },
    noFade: { type: Boolean },
    lazy: { type: Boolean, default: false },
    unmountLazy: { type: Boolean, default: false },
    show: { type: Boolean, default: false },
    transProps: {},
    visible: { type: Boolean, default: false }
  }, {
    "modelValue": { type: Boolean, ...{
      default: false
    } },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["hide", "hide-prevented", "hidden", "show", "show-prevented", "shown", "toggle", "toggle-prevented", "cancel", "ok"], ["update:modelValue"]),
  setup(__props, { expose: __expose, emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BCollapse");
    const emit = __emit;
    const modelValue = useModel(__props, "modelValue");
    const computedId = useId(() => props.id, "collapse");
    const element = useTemplateRef("_element");
    let inCollapse = false;
    const onEnter = (el) => {
      inCollapse = true;
      requestAnimationFrame(() => {
        if (props.horizontal) {
          el.style.width = `${el.scrollWidth}px`;
        } else {
          el.style.height = `${el.scrollHeight}px`;
        }
      });
    };
    const onBeforeLeave = (el) => {
      if (inCollapse) {
        return;
      }
      if (props.horizontal) {
        el.style.width = `${el.scrollWidth}px`;
      } else {
        el.style.height = `${el.scrollHeight}px`;
      }
      el.offsetHeight;
    };
    const onLeave = (el) => {
      requestAnimationFrame(() => {
        if (props.horizontal) {
          el.style.width = ``;
        } else {
          el.style.height = ``;
        }
      });
    };
    const onAfterEnter = (el) => {
      el.style.height = ``;
      el.style.width = ``;
      inCollapse = false;
    };
    const onAfterLeave = (el) => {
      el.style.height = ``;
      el.style.width = ``;
      inCollapse = false;
    };
    const {
      showRef,
      renderRef,
      hide,
      show,
      toggle,
      isActive,
      computedNoAnimation,
      contentShowing,
      transitionProps
    } = useShowHide(modelValue, props, emit, element, computedId, {
      // addShowClass: false,
      transitionProps: {
        onBeforeLeave,
        onEnter,
        onLeave,
        onAfterEnter,
        onAfterLeave,
        enterToClass: "",
        leaveToClass: "",
        enterFromClass: "",
        leaveFromClass: "",
        enterActiveClass: "",
        leaveActiveClass: ""
      }
    });
    const computedClasses = computed(() => ({
      "show": isActive.value,
      "navbar-collapse": props.isNav,
      "collapse-horizontal": props.horizontal
    }));
    const sharedSlots = computed(() => ({
      toggle,
      show,
      hide,
      id: computedId.value,
      visible: showRef.value,
      active: isActive.value
    }));
    __expose({
      hide,
      isNav: props.isNav,
      show,
      toggle,
      visible: readonly(showRef)
    });
    provide(collapseInjectionKey, {
      id: computedId,
      hide,
      show,
      toggle,
      visible: readonly(showRef),
      isNav: toRef(() => props.isNav)
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [
        renderSlot(_ctx.$slots, "header", normalizeProps(guardReactiveProps(sharedSlots.value))),
        unref(renderRef) || unref(contentShowing) ? (openBlock(), createBlock(Transition, mergeProps({ key: 0 }, unref(transitionProps), {
          "enter-active-class": unref(computedNoAnimation) ? "" : "collapsing",
          "leave-active-class": unref(computedNoAnimation) ? "" : "collapsing",
          appear: modelValue.value || unref(props).visible
        }), {
          default: withCtx(() => [
            withDirectives((openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), mergeProps({
              id: unref(computedId),
              ref: "_element",
              class: ["collapse", computedClasses.value],
              "is-nav": unref(props).isNav
            }, _ctx.$attrs), {
              default: withCtx(() => [
                unref(contentShowing) ? renderSlot(_ctx.$slots, "default", normalizeProps(mergeProps({ key: 0 }, sharedSlots.value))) : createCommentVNode("", true)
              ]),
              _: 3
            }, 16, ["id", "class", "is-nav"])), [
              [vShow, unref(showRef)]
            ])
          ]),
          _: 3
        }, 16, ["enter-active-class", "leave-active-class", "appear"])) : createCommentVNode("", true),
        renderSlot(_ctx.$slots, "footer", normalizeProps(guardReactiveProps(sharedSlots.value)))
      ], 64);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BCollapse.vue_vue_type_script_setup_true_lang-ByE-TAjy.mjs.map
