import { defineComponent, mergeModels, useModel, inject, computed, useTemplateRef, ref, toRef, watch, provide, createBlock, openBlock, unref, normalizeClass, withCtx, createVNode, createCommentVNode, renderSlot, createTextVNode, toDisplayString, createElementVNode, Transition, mergeProps, withDirectives, normalizeStyle, vShow, nextTick } from "vue";
import { i as isBoundary, a as isRootBoundary, o as offset, f as flip, s as shift, b as size, u as useFloating, r as resolveBootstrapCaret, c as autoUpdate } from "./floatingUi-BQpU1TSt.mjs";
import { o as onKeyStroke, a as onClickOutside } from "./index-Ddaqsxfw.mjs";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { u as useId } from "./useId-vZvGlR-1.mjs";
import { _ as _sfc_main$2 } from "./BButton.vue_vue_type_script_setup_true_lang-D-y5ASo-.mjs";
import { _ as _sfc_main$1 } from "./ConditionalWrapper.vue_vue_type_script_lang-BLT72l8w.mjs";
import { _ as _sfc_main$3 } from "./ConditionalTeleport.vue_vue_type_script_lang-BCI6afpC.mjs";
import { g as getElement } from "./getElement-WfnRgCbF.mjs";
import { i as inputGroupKey, b as buttonGroupKey, d as dropdownInjectionKey } from "./keys-CwytVEYF.mjs";
import { u as useShowHide } from "./useShowHide-CXGi2s6p.mjs";
import { u as useToNumber } from "./index-CYfoub2y.mjs";
const _hoisted_1 = { class: "visually-hidden" };
const _hoisted_2 = ["id", "aria-labelledby", "role"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BDropdown",
  props: /* @__PURE__ */ mergeModels({
    ariaLabel: { default: void 0 },
    autoClose: { type: [Boolean, String], default: true },
    boundary: { default: "clippingAncestors" },
    boundaryPadding: { default: void 0 },
    disabled: { type: Boolean, default: false },
    floatingMiddleware: { default: void 0 },
    icon: { type: Boolean, default: false },
    id: { default: void 0 },
    isNav: { type: Boolean, default: false },
    menuClass: { default: void 0 },
    noCaret: { type: Boolean, default: false },
    noFlip: { type: Boolean, default: false },
    noShift: { type: Boolean, default: false },
    noSize: { type: Boolean, default: false },
    offset: { default: 0 },
    role: { default: "menu" },
    size: { default: "md" },
    noWrapper: { type: Boolean, default: false },
    split: { type: Boolean, default: false },
    splitButtonType: { default: "button" },
    splitClass: { default: void 0 },
    splitDisabled: { type: Boolean, default: void 0 },
    splitHref: { default: void 0 },
    splitTo: { default: void 0 },
    splitVariant: { default: void 0 },
    strategy: { default: "absolute" },
    text: { default: void 0 },
    toggleClass: { default: void 0 },
    toggleText: { default: "Toggle dropdown" },
    variant: { default: "secondary" },
    wrapperClass: { default: void 0 },
    placement: { default: "bottom-start" },
    teleportDisabled: { type: Boolean, default: false },
    teleportTo: { default: void 0 },
    initialAnimation: { type: Boolean, default: false },
    noAnimation: { type: Boolean },
    noFade: { type: Boolean, default: false },
    lazy: { type: Boolean, default: false },
    unmountLazy: { type: Boolean, default: false },
    show: { type: Boolean, default: false },
    transProps: { default: void 0 },
    visible: { type: Boolean, default: false }
  }, {
    "modelValue": { type: Boolean, ...{ default: false } },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["split-click", "hide", "hide-prevented", "hidden", "show", "show-prevented", "shown", "toggle", "toggle-prevented", "cancel", "ok"], ["update:modelValue"]),
  setup(__props, { expose: __expose, emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BDropdown");
    const emit = __emit;
    const computedId = useId(() => props.id, "dropdown");
    const modelValue = useModel(__props, "modelValue");
    const inInputGroup = inject(inputGroupKey, false);
    const inButtonGroup = inject(buttonGroupKey, false);
    const computedOffset = computed(
      () => typeof props.offset === "string" || typeof props.offset === "number" ? props.offset : NaN
    );
    const offsetToNumber = useToNumber(computedOffset);
    const floatingElement = useTemplateRef("_floating");
    const button = useTemplateRef("_button");
    const splitButton = useTemplateRef("_splitButton");
    const boundary = computed(
      () => isBoundary(props.boundary) ? props.boundary : void 0
    );
    const rootBoundary = computed(
      () => isRootBoundary(props.boundary) ? props.boundary : void 0
    );
    const referenceElement = computed(() => !props.split ? splitButton.value : button.value);
    let cleanup;
    const {
      showRef,
      renderRef,
      hide,
      show,
      toggle,
      computedNoAnimation,
      transitionProps,
      contentShowing,
      isVisible
    } = useShowHide(modelValue, props, emit, referenceElement, computedId, {
      showFn: () => {
        update();
        nextTick(() => {
          cleanup = autoUpdate(
            referenceElement.value,
            floatingElement.value,
            update,
            {
              animationFrame: false
            }
          );
        });
      },
      hideFn: () => {
        if (cleanup) {
          cleanup();
          cleanup = void 0;
        }
      }
    });
    const computedMenuClasses = computed(() => [
      {
        show: isVisible.value,
        fade: !computedNoAnimation.value
      }
    ]);
    onKeyStroke(
      "Escape",
      () => {
        var _a;
        hide();
        (_a = getElement(referenceElement.value)) == null ? void 0 : _a.focus();
      },
      { target: referenceElement }
    );
    onKeyStroke(
      "Escape",
      () => {
        var _a;
        hide();
        (_a = getElement(referenceElement.value)) == null ? void 0 : _a.focus();
      },
      { target: floatingElement }
    );
    const keynav = (e, v) => {
      var _a, _b, _c, _d, _e, _f, _g;
      if ((_b = floatingElement.value) == null ? void 0 : _b.contains((_a = e.target) == null ? void 0 : _a.closest("form"))) return;
      if (/input|select|option|textarea|form/i.test((_c = e.target) == null ? void 0 : _c.tagName)) return;
      e.preventDefault();
      if (!showRef.value) {
        show();
        const loop = setInterval(() => {
          if (isVisible.value) {
            clearInterval(loop);
            nextTick(() => keynav(e, v));
          }
        }, 16);
        return;
      }
      const list = (_d = floatingElement.value) == null ? void 0 : _d.querySelectorAll(
        ".dropdown-item:not(.disabled):not(:disabled)"
      );
      if (!list) return;
      if ((_e = floatingElement.value) == null ? void 0 : _e.contains(document.activeElement)) {
        const active = floatingElement.value.querySelector(".dropdown-item:focus");
        const index = Array.prototype.indexOf.call(list, active) + v;
        if (index >= 0 && index < (list == null ? void 0 : list.length)) (_f = list[index]) == null ? void 0 : _f.focus();
      } else {
        (_g = list[v === -1 ? list.length - 1 : 0]) == null ? void 0 : _g.focus();
      }
    };
    onKeyStroke("ArrowUp", (e) => keynav(e, -1), { target: referenceElement });
    onKeyStroke("ArrowDown", (e) => keynav(e, 1), { target: referenceElement });
    onKeyStroke("ArrowUp", (e) => keynav(e, -1), { target: floatingElement });
    onKeyStroke("ArrowDown", (e) => keynav(e, 1), { target: floatingElement });
    const sizeStyles = ref({});
    const floatingMiddleware = computed(() => {
      if (props.floatingMiddleware !== void 0) {
        return props.floatingMiddleware;
      }
      const localOffset = typeof props.offset === "string" || typeof props.offset === "number" ? offsetToNumber.value : props.offset;
      const arr = [offset(localOffset)];
      if (props.noFlip === false) {
        arr.push(
          flip({
            boundary: boundary.value,
            rootBoundary: rootBoundary.value,
            padding: props.boundaryPadding
          })
        );
      }
      if (props.noShift === false) {
        arr.push(
          shift({
            boundary: boundary.value,
            rootBoundary: rootBoundary.value,
            padding: props.boundaryPadding
          })
        );
      }
      if (props.noSize === false) {
        arr.push(
          size({
            boundary: boundary.value,
            rootBoundary: rootBoundary.value,
            padding: props.boundaryPadding,
            apply({ availableWidth, availableHeight }) {
              var _a, _b;
              sizeStyles.value = {
                maxHeight: availableHeight >= (((_a = floatingElement.value) == null ? void 0 : _a.scrollHeight) ?? 0) ? void 0 : availableHeight ? `${Math.max(0, availableHeight)}px` : void 0,
                maxWidth: availableWidth >= (((_b = floatingElement.value) == null ? void 0 : _b.scrollWidth) ?? 0) ? void 0 : availableWidth ? `${Math.max(0, availableWidth)}px` : void 0
              };
            }
          })
        );
      }
      return arr;
    });
    const { update, floatingStyles } = useFloating(referenceElement, floatingElement, {
      placement: () => props.placement,
      middleware: floatingMiddleware,
      strategy: toRef(() => props.strategy)
    });
    const inButtonGroupAttributes = inButtonGroup ? {
      class: "btn-group",
      role: "group"
    } : void 0;
    const computedClasses = computed(() => [
      inButtonGroupAttributes == null ? void 0 : inButtonGroupAttributes.class,
      props.wrapperClass,
      {
        "btn-group": !props.wrapperClass && props.split,
        [`drop${resolveBootstrapCaret(props.placement)}`]: !props.wrapperClass,
        "position-static": props.boundary !== "clippingAncestors" && !props.isNav
      }
    ]);
    const buttonClasses = computed(() => [
      props.split ? props.splitClass : props.toggleClass,
      {
        "nav-link": props.isNav,
        "dropdown-toggle": !props.split,
        "dropdown-toggle-no-caret": props.noCaret && !props.split,
        "show": props.split ? void 0 : showRef.value
      }
    ]);
    const onButtonClick = () => {
      toggle();
    };
    const onSplitClick = (event) => {
      if (props.split) {
        emit("split-click", event);
        return;
      }
      onButtonClick();
    };
    onClickOutside(
      floatingElement,
      () => {
        if (showRef.value && (props.autoClose === true || props.autoClose === "outside")) {
          hide();
        }
      },
      { ignore: [button, splitButton] }
    );
    const onClickInside = () => {
      if (showRef.value && (props.autoClose === true || props.autoClose === "inside")) {
        hide();
      }
    };
    watch(isVisible, () => {
      update();
    });
    __expose({
      hide,
      show,
      toggle
    });
    provide(dropdownInjectionKey, {
      id: computedId,
      show,
      hide,
      toggle,
      visible: toRef(() => showRef.value),
      isNav: toRef(() => props.isNav)
    });
    return (_ctx, _cache) => {
      var _a;
      return openBlock(), createBlock(_sfc_main$1, {
        skip: unref(inInputGroup) || unref(props).noWrapper,
        class: normalizeClass(computedClasses.value),
        role: (_a = unref(inButtonGroupAttributes)) == null ? void 0 : _a.role
      }, {
        default: withCtx(() => [
          createVNode(_sfc_main$2, {
            id: unref(computedId),
            ref: "_splitButton",
            variant: unref(props).splitVariant || unref(props).variant,
            size: unref(props).size,
            class: normalizeClass(buttonClasses.value),
            disabled: unref(props).splitDisabled || unref(props).disabled,
            type: unref(props).splitButtonType,
            "aria-label": unref(props).ariaLabel,
            "aria-expanded": unref(props).split ? void 0 : unref(showRef),
            "aria-haspopup": unref(props).split ? void 0 : "menu",
            href: unref(props).split ? unref(props).splitHref : void 0,
            icon: unref(props).icon,
            to: unref(props).split && unref(props).splitTo ? unref(props).splitTo : void 0,
            onClick: onSplitClick
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "button-content", {}, () => [
                createTextVNode(toDisplayString(unref(props).text), 1)
              ])
            ]),
            _: 3
          }, 8, ["id", "variant", "size", "class", "disabled", "type", "aria-label", "aria-expanded", "aria-haspopup", "href", "icon", "to"]),
          unref(props).split ? (openBlock(), createBlock(_sfc_main$2, {
            key: 0,
            id: unref(computedId) + "-split",
            ref: "_button",
            variant: unref(props).variant,
            size: unref(props).size,
            disabled: unref(props).disabled,
            class: normalizeClass([[unref(props).toggleClass, { show: unref(showRef) }], "dropdown-toggle-split dropdown-toggle"]),
            "aria-expanded": unref(showRef),
            "aria-haspopup": "menu",
            onClick: onButtonClick
          }, {
            default: withCtx(() => [
              createElementVNode("span", _hoisted_1, [
                renderSlot(_ctx.$slots, "toggle-text", {}, () => [
                  createTextVNode(toDisplayString(unref(props).toggleText), 1)
                ])
              ])
            ]),
            _: 3
          }, 8, ["id", "variant", "size", "disabled", "class", "aria-expanded"])) : createCommentVNode("", true),
          createVNode(_sfc_main$3, {
            to: unref(props).teleportTo,
            disabled: !unref(props).teleportTo || unref(props).teleportDisabled
          }, {
            default: withCtx(() => [
              unref(renderRef) || unref(contentShowing) ? (openBlock(), createBlock(Transition, mergeProps({ key: 0 }, unref(transitionProps), {
                appear: modelValue.value || unref(props).visible
              }), {
                default: withCtx(() => [
                  withDirectives(createElementVNode("ul", {
                    id: unref(computedId) + "-menu",
                    ref: "_floating",
                    style: normalizeStyle([unref(floatingStyles), sizeStyles.value, { display: unref(showRef) ? "block" : "none" }]),
                    class: normalizeClass(["dropdown-menu overflow-auto", [unref(props).menuClass, computedMenuClasses.value]]),
                    "aria-labelledby": unref(computedId),
                    role: unref(props).role,
                    onClick: onClickInside
                  }, [
                    unref(contentShowing) ? renderSlot(_ctx.$slots, "default", {
                      key: 0,
                      hide: unref(hide),
                      show: unref(show),
                      visible: unref(showRef)
                    }) : createCommentVNode("", true)
                  ], 14, _hoisted_2), [
                    [vShow, unref(showRef)]
                  ])
                ]),
                _: 3
              }, 16, ["appear"])) : createCommentVNode("", true)
            ]),
            _: 3
          }, 8, ["to", "disabled"])
        ]),
        _: 3
      }, 8, ["skip", "class", "role"]);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BDropdown.vue_vue_type_script_setup_true_lang-BT4OzXGx.mjs.map
