import { defineComponent, useAttrs, computed, createElementBlock, openBlock, mergeProps, createBlock, resolveDynamicComponent, unref, createElementVNode, renderSlot, normalizeClass, withCtx, createTextVNode, toDisplayString, inject } from "vue";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { u as useColorVariantClasses } from "./useColorVariantClasses-ZDE19TZw.mjs";
import { u as useBLinkHelper, _ as _sfc_main$7 } from "./BLink.vue_vue_type_script_setup_true_lang-Crq1j_mE.mjs";
import { c as collapseInjectionKey, d as dropdownInjectionKey, x as navbarInjectionKey } from "./keys-CwytVEYF.mjs";
const _sfc_main$6 = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BDropdownDivider",
  props: {
    dividerClass: { default: void 0 },
    tag: { default: "hr" },
    variant: {},
    wrapperAttrs: { default: void 0 }
  },
  setup(__props) {
    const attrs = useAttrs();
    const processedAttrs = computed(() => {
      const { class: wrapperClass, ...dividerAttrs } = attrs;
      return { wrapperClass, dividerAttrs };
    });
    const _props = __props;
    const props = useDefaults(_props, "BDropdownDivider");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", mergeProps({
        role: "presentation",
        class: processedAttrs.value.wrapperClass
      }, _ctx.wrapperAttrs), [
        (openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), mergeProps({
          class: ["dropdown-divider", unref(props).dividerClass],
          role: "separator",
          "aria-orientation": "horizontal"
        }, processedAttrs.value.dividerAttrs), null, 16, ["class"]))
      ], 16);
    };
  }
});
const _hoisted_1$2 = ["novalidate"];
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BDropdownForm",
  props: {
    formClass: { default: void 0 },
    novalidate: { type: Boolean, default: void 0 },
    validated: { type: Boolean, default: void 0 },
    wrapperAttrs: { default: void 0 }
  },
  setup(__props) {
    const attrs = useAttrs();
    const processedAttrs = computed(() => {
      const { class: wrapperClass, ...formAttrs } = attrs;
      return { wrapperClass, formAttrs };
    });
    const _props = __props;
    const props = useDefaults(_props, "BDropdownForm");
    const computedClasses = computed(() => [
      props.formClass,
      {
        "was-validated": props.validated
      }
    ]);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", mergeProps({
        role: "presentation",
        class: processedAttrs.value.wrapperClass
      }, unref(props).wrapperAttrs), [
        createElementVNode("form", mergeProps({
          class: ["dropdown-item-text", computedClasses.value],
          novalidate: unref(props).novalidate
        }, processedAttrs.value.formAttrs), [
          renderSlot(_ctx.$slots, "default")
        ], 16, _hoisted_1$2)
      ], 16);
    };
  }
});
const _hoisted_1$1 = { role: "presentation" };
const _hoisted_2 = ["id", "aria-describedby"];
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BDropdownGroup",
  props: {
    ariaDescribedby: { default: void 0 },
    header: { default: void 0 },
    headerClass: { default: void 0 },
    headerTag: { default: "header" },
    headerVariant: { default: null },
    id: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BDropdownGroup");
    const headerId = computed(() => props.id ? `${props.id}_group_dd_header` : void 0);
    const headerRole = computed(() => props.headerTag === "header" ? void 0 : "heading");
    const colorClasses = useColorVariantClasses(
      computed(() => ({
        textVariant: props.headerVariant
      }))
    );
    const computedClasses = computed(() => [props.headerClass, colorClasses.value]);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", _hoisted_1$1, [
        (openBlock(), createBlock(resolveDynamicComponent(unref(props).headerTag), {
          id: headerId.value,
          class: normalizeClass(["dropdown-header", computedClasses.value]),
          role: headerRole.value
        }, {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "header", {}, () => [
              createTextVNode(toDisplayString(unref(props).header), 1)
            ])
          ]),
          _: 3
        }, 8, ["id", "class", "role"])),
        createElementVNode("ul", mergeProps({
          id: unref(props).id,
          role: "group",
          class: "list-unstyled"
        }, _ctx.$attrs, {
          "aria-describedby": unref(props).ariaDescribedby || headerId.value
        }), [
          renderSlot(_ctx.$slots, "default")
        ], 16, _hoisted_2)
      ]);
    };
  }
});
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BDropdownHeader",
  props: {
    headerClass: { default: void 0 },
    tag: { default: "h6" },
    text: { default: void 0 },
    variant: { default: null },
    wrapperAttrs: { default: void 0 }
  },
  setup(__props) {
    const attrs = useAttrs();
    const processedAttrs = computed(() => {
      const { class: wrapperClass, ...headerAttrs } = attrs;
      return { wrapperClass, headerAttrs };
    });
    const _props = __props;
    const props = useDefaults(_props, "BDropdownHeader");
    const colorClasses = useColorVariantClasses(
      computed(() => ({
        textVariant: props.variant
      }))
    );
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", mergeProps({
        role: "presentation",
        class: processedAttrs.value.wrapperClass
      }, _ctx.wrapperAttrs), [
        (openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), mergeProps({
          class: ["dropdown-header", [unref(colorClasses), unref(props).headerClass]]
        }, processedAttrs.value.headerAttrs), {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "default", {}, () => [
              createTextVNode(toDisplayString(unref(props).text), 1)
            ])
          ]),
          _: 3
        }, 16, ["class"]))
      ], 16);
    };
  }
});
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BDropdownItem",
  props: {
    linkClass: { default: void 0 },
    wrapperAttrs: { default: void 0 },
    active: { type: Boolean, default: void 0 },
    activeClass: { default: void 0 },
    disabled: { type: Boolean, default: void 0 },
    exactActiveClass: { default: void 0 },
    href: { default: void 0 },
    icon: { type: Boolean, default: void 0 },
    noRel: { type: Boolean },
    opacity: { default: void 0 },
    opacityHover: { default: void 0 },
    prefetch: { type: Boolean },
    prefetchOn: {},
    noPrefetch: { type: Boolean },
    prefetchedClass: {},
    rel: { default: void 0 },
    replace: { type: Boolean, default: void 0 },
    routerComponentName: { default: void 0 },
    stretched: { type: Boolean, default: false },
    target: { default: void 0 },
    to: { default: void 0 },
    underlineOffset: { default: void 0 },
    underlineOffsetHover: { default: void 0 },
    underlineOpacity: { default: void 0 },
    underlineOpacityHover: { default: void 0 },
    underlineVariant: { default: void 0 },
    variant: { default: null }
  },
  emits: ["click"],
  setup(__props, { emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BDropdownItem");
    const emit = __emit;
    const attrs = useAttrs();
    const processedAttrs = computed(() => {
      const { class: wrapperClass, ...dropdownItemAttrs } = attrs;
      return { wrapperClass, dropdownItemAttrs };
    });
    const { computedLink, computedLinkProps } = useBLinkHelper(props);
    const colorClasses = useColorVariantClasses(
      computed(() => ({
        textVariant: props.variant
      }))
    );
    const computedClasses = computed(() => [
      props.linkClass,
      colorClasses.value,
      {
        active: props.active,
        disabled: props.disabled
      }
    ]);
    const computedTag = computed(() => computedLink.value ? _sfc_main$7 : props.href ? "a" : "button");
    const collapseData = inject(collapseInjectionKey, null);
    const dropdownData = inject(dropdownInjectionKey, null);
    const navbarData = inject(navbarInjectionKey, null);
    const clicked = (e) => {
      var _a, _b, _c;
      emit("click", e);
      if (navbarData !== null && ((_a = navbarData == null ? void 0 : navbarData.autoClose) == null ? void 0 : _a.value) === true) {
        (_b = collapseData == null ? void 0 : collapseData.hide) == null ? void 0 : _b.call(collapseData);
      }
      (_c = dropdownData == null ? void 0 : dropdownData.hide) == null ? void 0 : _c.call(dropdownData);
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", mergeProps({
        role: "presentation",
        class: processedAttrs.value.wrapperClass
      }, unref(props).wrapperAttrs), [
        (openBlock(), createBlock(resolveDynamicComponent(computedTag.value), mergeProps({
          class: ["dropdown-item", computedClasses.value],
          disabled: unref(props).disabled,
          "aria-disabled": unref(props).disabled ? true : null,
          "aria-current": unref(props).active ? true : null,
          href: computedTag.value === "a" ? unref(props).href : null,
          rel: unref(props).rel,
          role: "menuitem",
          type: computedTag.value === "button" ? "button" : null,
          target: unref(props).target
        }, { ...unref(computedLinkProps), ...processedAttrs.value.dropdownItemAttrs }, { onClick: clicked }), {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "default")
          ]),
          _: 3
        }, 16, ["class", "disabled", "aria-disabled", "aria-current", "href", "rel", "type", "target"]))
      ], 16);
    };
  }
});
const _hoisted_1 = ["disabled"];
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BDropdownItemButton",
  props: {
    active: { type: Boolean, default: false },
    activeClass: { default: "active" },
    buttonClass: { default: void 0 },
    wrapperAttrs: { default: void 0 },
    disabled: { type: Boolean, default: false },
    variant: { default: null }
  },
  emits: ["click"],
  setup(__props, { emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BDropdownItemButton");
    const emit = __emit;
    const attrs = useAttrs();
    const processedAttrs = computed(() => {
      const { class: wrapperClass, ...buttonAttrs } = attrs;
      return { wrapperClass, buttonAttrs };
    });
    const colorClasses = useColorVariantClasses(
      computed(() => ({
        textVariant: props.variant
      }))
    );
    const computedClasses = computed(() => [
      props.buttonClass,
      colorClasses.value,
      {
        [props.activeClass]: props.active,
        disabled: props.disabled
      }
    ]);
    const clicked = (e) => {
      if (props.disabled) {
        e.preventDefault();
        e.stopPropagation();
        return;
      }
      emit("click", e);
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", mergeProps({
        role: "presentation",
        class: processedAttrs.value.wrapperClass
      }, unref(props).wrapperAttrs), [
        createElementVNode("button", mergeProps({
          role: "menu",
          type: "button",
          class: ["dropdown-item", computedClasses.value],
          disabled: unref(props).disabled
        }, processedAttrs.value.buttonAttrs, { onClick: clicked }), [
          renderSlot(_ctx.$slots, "default")
        ], 16, _hoisted_1)
      ], 16);
    };
  }
});
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BDropdownText",
  props: {
    textClass: { default: void 0 },
    tag: { default: "span" },
    text: { default: void 0 },
    variant: { default: null },
    wrapperAttrs: { default: void 0 }
  },
  setup(__props) {
    const attrs = useAttrs();
    const processedAttrs = computed(() => {
      const { class: wrapperClass, ...textAttrs } = attrs;
      return { wrapperClass, textAttrs };
    });
    const _props = __props;
    const props = useDefaults(_props, "BDropdownText");
    const colorClasses = useColorVariantClasses(
      computed(() => ({
        textVariant: props.variant
      }))
    );
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", mergeProps({
        role: "presentation",
        class: processedAttrs.value.wrapperClass
      }, _ctx.wrapperAttrs), [
        (openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), mergeProps({
          class: ["dropdown-item-text", [unref(colorClasses), unref(props).textClass]]
        }, processedAttrs.value.textAttrs), {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "default", {}, () => [
              createTextVNode(toDisplayString(unref(props).text), 1)
            ])
          ]),
          _: 3
        }, 16, ["class"]))
      ], 16);
    };
  }
});
export {
  _sfc_main$6 as _,
  _sfc_main$5 as a,
  _sfc_main$4 as b,
  _sfc_main$3 as c,
  _sfc_main$2 as d,
  _sfc_main$1 as e,
  _sfc_main as f
};
//# sourceMappingURL=BDropdownText.vue_vue_type_script_setup_true_lang-BNJdogga.mjs.map
