import { defineComponent, mergeModels, useAttrs, computed, useSlots, useModel, inject, useTemplateRef, createBlock, openBlock, mergeProps, unref, withCtx, withDirectives, createElementBlock, createCommentVNode, createElementVNode, vModelCheckbox, normalizeClass, renderSlot, provide, toRef, Fragment, renderList, createTextVNode, toDisplayString } from "vue";
import { u as useFocus } from "./index-Ddaqsxfw.mjs";
import { g as getClasses, a as getInputClasses, b as getLabelClasses, c as getGroupAttr, d as getGroupClasses } from "./useFormCheck-Bcx8Ea7M.mjs";
import { l as checkboxGroupKey } from "./keys-CwytVEYF.mjs";
import { _ as _sfc_main$2 } from "./ConditionalWrapper.vue_vue_type_script_lang-BLT72l8w.mjs";
import { i as isEmptySlot } from "./dom-BNfqkuY-.mjs";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { u as useId } from "./useId-vZvGlR-1.mjs";
const _hoisted_1$1 = ["id", "disabled", "required", "name", "form", "aria-label", "aria-labelledby", "aria-required", "value", "true-value", "false-value", "indeterminate"];
const _hoisted_2 = ["for"];
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BFormCheckbox",
  props: /* @__PURE__ */ mergeModels({
    ariaLabel: { default: void 0 },
    ariaLabelledby: { default: void 0 },
    autofocus: { type: Boolean, default: false },
    button: { type: Boolean, default: false },
    buttonGroup: { type: Boolean, default: false },
    buttonVariant: { default: null },
    disabled: { type: Boolean, default: false },
    form: { default: void 0 },
    id: { default: void 0 },
    inline: { type: Boolean, default: false },
    name: { default: void 0 },
    plain: { type: Boolean, default: false },
    required: { type: Boolean, default: void 0 },
    reverse: { type: Boolean, default: false },
    size: { default: void 0 },
    state: { type: [Boolean, null], default: null },
    switch: { type: Boolean, default: false },
    uncheckedValue: { type: [Array, Set, String, Boolean, Object, Number, null], default: false },
    wrapperAttrs: { default: void 0 },
    inputClass: { default: void 0 },
    value: { type: [String, Boolean, Array, Set, Object, Number, null], default: true }
  }, {
    "modelValue": { type: [Array, Set, String, Boolean, Object, Number, null], ...{
      default: void 0
    } },
    "modelModifiers": {},
    "indeterminate": { type: Boolean, ...{
      default: false
    } },
    "indeterminateModifiers": {}
  }),
  emits: ["update:modelValue", "update:indeterminate"],
  setup(__props, { expose: __expose }) {
    const attrs = useAttrs();
    const processedAttrs = computed(() => {
      const { class: wrapperClass, ...inputAttrs } = attrs;
      return { wrapperClass, inputAttrs };
    });
    const _props = __props;
    const props = useDefaults(_props, "BFormCheckbox");
    const slots = useSlots();
    const modelValue = useModel(__props, "modelValue");
    const indeterminate = useModel(
      __props,
      "indeterminate"
    );
    const computedId = useId(() => props.id, "form-check");
    const parentData = inject(checkboxGroupKey, null);
    const input = useTemplateRef("_input");
    const { focused } = useFocus(input, {
      initialValue: props.autofocus
    });
    const hasDefaultSlot = computed(() => !isEmptySlot(slots.default));
    const localValue = computed({
      get: () => parentData ? parentData.modelValue.value : modelValue.value,
      set: (newVal) => {
        if (newVal === void 0) return;
        indeterminate.value = false;
        if (parentData !== null && Array.isArray(newVal)) {
          parentData.modelValue.value = newVal;
          return;
        }
        modelValue.value = newVal;
      }
    });
    const computedRequired = computed(
      () => !!(props.name ?? (parentData == null ? void 0 : parentData.name.value)) && (props.required || (parentData == null ? void 0 : parentData.required.value))
    );
    const isButtonGroup = computed(() => props.buttonGroup || ((parentData == null ? void 0 : parentData.buttons.value) ?? false));
    const classesObject = computed(() => ({
      plain: props.plain || ((parentData == null ? void 0 : parentData.plain.value) ?? false),
      button: props.button || ((parentData == null ? void 0 : parentData.buttons.value) ?? false),
      inline: props.inline || ((parentData == null ? void 0 : parentData.inline.value) ?? false),
      reverse: props.reverse || ((parentData == null ? void 0 : parentData.reverse.value) ?? false),
      switch: props.switch || ((parentData == null ? void 0 : parentData.switch.value) ?? false),
      state: props.state === true || props.state === false ? props.state : (parentData == null ? void 0 : parentData.state.value) ?? null,
      size: props.size ?? (parentData == null ? void 0 : parentData.size.value) ?? "md",
      // This is where the true default is made
      buttonVariant: props.buttonVariant ?? (parentData == null ? void 0 : parentData.buttonVariant.value) ?? "secondary",
      // This is where the true default is made
      hasDefaultSlot: hasDefaultSlot.value
    }));
    const wrapperClasses = getClasses(classesObject);
    const computedWrapperClasses = computed(() => [
      wrapperClasses.value,
      processedAttrs.value.wrapperClass
    ]);
    const inputClasses = getInputClasses(classesObject);
    const computedInputClasses = computed(() => [inputClasses.value, props.inputClass]);
    const labelClasses = getLabelClasses(classesObject);
    __expose({
      blur: () => {
        focused.value = false;
      },
      element: input,
      focus: () => {
        focused.value = true;
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$2, mergeProps({ skip: isButtonGroup.value }, unref(props).wrapperAttrs, { class: computedWrapperClasses.value }), {
        default: withCtx(() => {
          var _a, _b, _c;
          return [
            withDirectives(createElementVNode("input", mergeProps({
              id: unref(computedId),
              ref: "_input",
              "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => localValue.value = $event),
              class: computedInputClasses.value,
              type: "checkbox",
              disabled: unref(props).disabled || ((_a = unref(parentData)) == null ? void 0 : _a.disabled.value),
              required: computedRequired.value || void 0,
              name: unref(props).name || ((_b = unref(parentData)) == null ? void 0 : _b.name.value),
              form: unref(props).form || ((_c = unref(parentData)) == null ? void 0 : _c.form.value),
              "aria-label": unref(props).ariaLabel,
              "aria-labelledby": unref(props).ariaLabelledby,
              "aria-required": computedRequired.value || void 0,
              value: unref(props).value,
              "true-value": unref(props).value,
              "false-value": unref(props).uncheckedValue,
              indeterminate: indeterminate.value || void 0
            }, processedAttrs.value.inputAttrs), null, 16, _hoisted_1$1), [
              [vModelCheckbox, localValue.value]
            ]),
            hasDefaultSlot.value || unref(props).plain === false ? (openBlock(), createElementBlock("label", {
              key: 0,
              for: unref(computedId),
              class: normalizeClass(unref(labelClasses))
            }, [
              renderSlot(_ctx.$slots, "default")
            ], 10, _hoisted_2)) : createCommentVNode("", true)
          ];
        }),
        _: 3
      }, 16, ["skip", "class"]);
    };
  }
});
const _hoisted_1 = ["id"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BFormCheckboxGroup",
  props: /* @__PURE__ */ mergeModels({
    ariaInvalid: { type: [Boolean, String], default: void 0 },
    autofocus: { type: Boolean, default: false },
    buttonVariant: { default: "secondary" },
    buttons: { type: Boolean, default: false },
    disabled: { type: Boolean, default: false },
    disabledField: { default: "disabled" },
    form: { default: void 0 },
    id: { default: void 0 },
    name: { default: void 0 },
    options: { default: () => [] },
    plain: { type: Boolean, default: false },
    required: { type: Boolean, default: false },
    reverse: { type: Boolean, default: false },
    size: { default: "md" },
    stacked: { type: Boolean, default: false },
    state: { type: [Boolean, null], default: null },
    switches: { type: Boolean, default: false },
    textField: { default: "text" },
    validated: { type: Boolean, default: false },
    valueField: { default: "value" }
  }, {
    "modelValue": {
      default: () => []
    },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props, { expose: __expose }) {
    const _props = __props;
    const props = useDefaults(_props, "BFormCheckboxGroup");
    const modelValue = useModel(__props, "modelValue");
    const computedId = useId(() => props.id, "checkbox");
    const computedName = useId(() => props.name, "checkbox");
    const element = useTemplateRef("_element");
    const { focused } = useFocus(element, {
      initialValue: props.autofocus
    });
    provide(checkboxGroupKey, {
      modelValue,
      switch: toRef(() => props.switches),
      buttonVariant: toRef(() => props.buttonVariant),
      form: toRef(() => props.form),
      name: computedName,
      state: toRef(() => props.state),
      plain: toRef(() => props.plain),
      size: toRef(() => props.size),
      inline: toRef(() => !props.stacked),
      reverse: toRef(() => props.reverse),
      required: toRef(() => props.required),
      buttons: toRef(() => props.buttons),
      disabled: toRef(() => props.disabled)
    });
    const normalizeOptions = computed(
      () => props.options.map(
        (el) => typeof el === "string" || typeof el === "number" ? {
          value: el,
          disabled: props.disabled,
          text: el.toString()
        } : {
          ...el,
          value: el[props.valueField],
          disabled: el[props.disabledField],
          text: el[props.textField]
        }
      )
    );
    const classesObject = computed(() => ({
      required: props.required,
      ariaInvalid: props.ariaInvalid,
      state: props.state,
      validated: props.validated,
      buttons: props.buttons,
      stacked: props.stacked,
      size: props.size
    }));
    const computedAttrs = getGroupAttr(classesObject);
    const computedClasses = getGroupClasses(classesObject);
    __expose({
      blur: () => {
        focused.value = false;
      },
      focus: () => {
        focused.value = true;
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", mergeProps(unref(computedAttrs), {
        id: unref(computedId),
        ref: "_element",
        role: "group",
        class: [unref(computedClasses), "bv-no-focus-ring"],
        tabindex: "-1"
      }), [
        renderSlot(_ctx.$slots, "first"),
        (openBlock(true), createElementBlock(Fragment, null, renderList(normalizeOptions.value, (item, index) => {
          return openBlock(), createBlock(_sfc_main$1, mergeProps({
            key: index,
            ref_for: true
          }, item), {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "option", mergeProps({ ref_for: true }, item), () => [
                createTextVNode(toDisplayString(item.text), 1)
              ])
            ]),
            _: 2
          }, 1040);
        }), 128)),
        renderSlot(_ctx.$slots, "default")
      ], 16, _hoisted_1);
    };
  }
});
export {
  _sfc_main$1 as _,
  _sfc_main as a
};
//# sourceMappingURL=BFormCheckboxGroup.vue_vue_type_script_setup_true_lang-BMu0rSTT.mjs.map
