import { defineComponent, computed, createElementBlock, openBlock, unref, renderSlot, Fragment, renderList, createBlock, mergeProps, withCtx, createTextVNode, toDisplayString, createElementVNode } from "vue";
import { u as useFormSelect, _ as _sfc_main$2 } from "./useFormSelect-D2FHF0O9.mjs";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { u as useId } from "./useId-vZvGlR-1.mjs";
const _hoisted_1$1 = ["id"];
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BFormDatalist",
  props: {
    disabledField: { default: "disabled" },
    id: { default: void 0 },
    options: { default: () => [] },
    textField: { default: "text" },
    valueField: { default: "value" }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BFormDatalist");
    const computedId = useId(() => props.id, "datalist");
    const { normalizedOptions, isComplex } = useFormSelect(
      () => props.options,
      computed(() => ({ ...props, optionsField: "options", labelField: "label" }))
    );
    const normalizedOptsWrapper = computed(
      () => (
        // Datalist doesn't support complex options
        normalizedOptions.value.filter((opt) => !isComplex(opt))
      )
    );
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("datalist", { id: unref(computedId) }, [
        renderSlot(_ctx.$slots, "first"),
        (openBlock(true), createElementBlock(Fragment, null, renderList(normalizedOptsWrapper.value, (option, index) => {
          return openBlock(), createBlock(_sfc_main$2, mergeProps({
            key: index,
            ref_for: true
          }, option), {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "option", mergeProps({ ref_for: true }, option), () => [
                createTextVNode(toDisplayString(option.text), 1)
              ])
            ]),
            _: 2
          }, 1040);
        }), 128)),
        renderSlot(_ctx.$slots, "default")
      ], 8, _hoisted_1$1);
    };
  }
});
const _hoisted_1 = { class: "form-floating" };
const _hoisted_2 = ["for"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BFormFloatingLabel",
  props: {
    label: { default: void 0 },
    labelFor: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BFormFloatingLabel");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1, [
        renderSlot(_ctx.$slots, "default"),
        createElementVNode("label", {
          for: unref(props).labelFor
        }, [
          renderSlot(_ctx.$slots, "label", {}, () => [
            createTextVNode(toDisplayString(unref(props).label), 1)
          ])
        ], 8, _hoisted_2)
      ]);
    };
  }
});
export {
  _sfc_main$1 as _,
  _sfc_main as a
};
//# sourceMappingURL=BFormFloatingLabel.vue_vue_type_script_setup_true_lang-B8Wb_FR9.mjs.map
