import { defineComponent, useSlots, toRef, ref, provide, computed, useTemplateRef, createBlock, openBlock, resolveDynamicComponent, normalizeClass, unref, withCtx, createVNode, createElementBlock, createCommentVNode, renderSlot, createTextVNode, toDisplayString, Fragment, normalizeProps, mergeProps } from "vue";
import { u as useAriaInvalid } from "./useAriaInvalid-BTUbGj3Y.mjs";
import { a as isVisible, b as attemptFocus } from "./dom-BNfqkuY-.mjs";
import { _ as _sfc_main$4 } from "./BCol.vue_vue_type_script_setup_true_lang-DrMYlpyB.mjs";
import { _ as _sfc_main$1, c as _sfc_main$2, b as _sfc_main$3, a as _sfc_main$5 } from "./BFormValidFeedback.vue_vue_type_script_setup_true_lang-Beu8RDb6.mjs";
import { u as upperFirst } from "./stringUtils-B4XdnJx5.mjs";
import { u as useStateClass } from "./useStateClass-BGbSLWFN.mjs";
import { u as useId } from "./useId-vZvGlR-1.mjs";
import { j as createReusableTemplate } from "./index-Ddaqsxfw.mjs";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { n as formGroupPluginKey } from "./keys-CwytVEYF.mjs";
const suffixPropName = (suffix, value) => value + (suffix ? upperFirst(suffix) : "");
const _hoisted_1 = {
  key: 0,
  ref: "_content",
  class: "form-floating"
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BFormGroup",
  props: {
    contentCols: { type: [Boolean, String, Number], default: void 0 },
    labelCols: { type: [Boolean, String, Number], default: void 0 },
    labelAlign: { default: void 0 },
    ariaInvalid: { type: [Boolean, String], default: void 0 },
    description: { default: void 0 },
    disabled: { type: Boolean, default: false },
    feedbackAriaLive: { default: "assertive" },
    floating: { type: Boolean, default: false },
    id: { default: void 0 },
    invalidFeedback: { default: void 0 },
    label: { default: void 0 },
    labelClass: { default: void 0 },
    labelFor: { default: void 0 },
    labelSize: { default: void 0 },
    labelVisuallyHidden: { type: Boolean, default: false },
    state: { type: [Boolean, null], default: null },
    tooltip: { type: Boolean, default: false },
    validFeedback: { default: void 0 },
    validated: { type: Boolean, default: false },
    contentColsSm: { type: [Boolean, String, Number], default: void 0 },
    contentColsMd: { type: [Boolean, String, Number], default: void 0 },
    contentColsLg: { type: [Boolean, String, Number], default: void 0 },
    contentColsXl: { type: [Boolean, String, Number], default: void 0 },
    labelColsSm: { type: [Boolean, String, Number], default: void 0 },
    labelColsMd: { type: [Boolean, String, Number], default: void 0 },
    labelColsLg: { type: [Boolean, String, Number], default: void 0 },
    labelColsXl: { type: [Boolean, String, Number], default: void 0 },
    labelAlignSm: { default: void 0 },
    labelAlignMd: { default: void 0 },
    labelAlignLg: { default: void 0 },
    labelAlignXl: { default: void 0 }
  },
  setup(__props) {
    const INPUTS = ["input", "select", "textarea"];
    const _props = __props;
    const props = useDefaults(_props, "BFormGroup");
    const slots = useSlots();
    const LabelContentTemplate = createReusableTemplate();
    const ContentTemplate = createReusableTemplate();
    const computedState = toRef(() => props.state);
    const childId = ref([]);
    provide(formGroupPluginKey, (id) => {
      childId.value = [id];
      return {
        state: computedState
      };
    });
    const computedLabelFor = computed(() => {
      if (props.labelFor !== void 0) return props.labelFor;
      if (childId.value[0] && childId.value[0].value) return childId.value[0].value;
      return null;
    });
    const breakPoints = ["xs", "sm", "md", "lg", "xl"];
    const getColProps = (props2, prefix) => (
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      breakPoints.reduce((result, breakpoint) => {
        const suffix = suffixPropName(breakpoint === "xs" ? "" : breakpoint, `${prefix}Cols`);
        let propValue = props2[suffix];
        propValue = propValue === "" ? true : propValue || false;
        if (!(typeof propValue === "boolean") && propValue !== "auto") {
          const val = Number.parseInt(propValue);
          propValue = Number.isNaN(val) ? 0 : val;
          propValue = propValue > 0 ? propValue : false;
        }
        if (propValue) {
          if (breakpoint === "xs") {
            result[typeof propValue === "boolean" ? "col" : "cols"] = propValue;
          } else {
            result[breakpoint || (typeof propValue === "boolean" ? "col" : "cols")] = propValue;
          }
        }
        return result;
      }, {})
    );
    const content = useTemplateRef("_content");
    const contentColProps = computed(() => getColProps(props, "content"));
    const labelAlignClasses = computed(
      () => ((props2, prefix) => breakPoints.reduce((result, breakpoint) => {
        const suffix = suffixPropName(
          breakpoint === "xs" ? "" : breakpoint,
          `${prefix}Align`
        );
        const propValue = props2[suffix] || null;
        if (propValue) {
          if (breakpoint === "xs") {
            result.push(`text-${propValue}`);
          } else {
            result.push(`text-${breakpoint}-${propValue}`);
          }
        }
        return result;
      }, []))(props, "label")
    );
    const labelColProps = computed(() => getColProps(props, "label"));
    const isHorizontal = computed(
      () => Object.keys(contentColProps.value).length > 0 || Object.keys(labelColProps.value).length > 0
    );
    const stateClass = useStateClass(computedState);
    const computedAriaInvalid = useAriaInvalid(() => props.ariaInvalid, computedState);
    const onLegendClick = (event) => {
      if (computedLabelFor.value || content.value === null) return;
      const { target } = event;
      const tagName = target ? target.tagName : "";
      if ([...INPUTS, "a", "button", "label"].indexOf(tagName) !== -1) return;
      const inputs = [
        ...content.value.querySelectorAll(INPUTS.map((v) => `${v}:not([disabled])`).join())
      ].filter(isVisible);
      const [inp] = inputs;
      if (inputs.length === 1 && inp instanceof HTMLElement) {
        attemptFocus(inp);
      }
    };
    const computedId = useId(() => props.id);
    const labelId = useId(void 0, "_BV_label_");
    const labelTag = computed(() => !computedLabelFor.value ? "legend" : "label");
    const labelClasses = computed(() => [
      isHorizontal.value ? "col-form-label" : "form-label",
      {
        "bv-no-focus-ring": !computedLabelFor.value,
        "col-form-label": isHorizontal.value || !computedLabelFor.value,
        "pt-0": !isHorizontal.value && !computedLabelFor.value,
        "d-block": !isHorizontal.value && computedLabelFor.value,
        [`col-form-label-${props.labelSize}`]: !!props.labelSize,
        "visually-hidden": props.labelVisuallyHidden
      },
      labelAlignClasses.value,
      props.labelClass
    ]);
    const invalidFeedbackId = useId(void 0, "_BV_feedback_invalid_");
    const validFeedbackId = useId(void 0, "_BV_feedback_valid_");
    const descriptionId = useId(void 0, "_BV_description_");
    const isFieldset = computed(() => !computedLabelFor.value);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(isFieldset.value ? "fieldset" : "div"), {
        id: unref(computedId),
        disabled: isFieldset.value ? unref(props).disabled : null,
        role: isFieldset.value ? null : "group",
        "aria-invalid": unref(computedAriaInvalid),
        "aria-labelledby": isFieldset.value && isHorizontal.value ? unref(labelId) : null,
        class: normalizeClass([[unref(stateClass), { "was-validated": unref(props).validated }], "b-form-group"])
      }, {
        default: withCtx(() => [
          createVNode(unref(ContentTemplate).define, null, {
            default: withCtx(() => [
              slots["invalid-feedback"] || unref(props).invalidFeedback ? (openBlock(), createBlock(_sfc_main$1, {
                key: 0,
                id: unref(invalidFeedbackId),
                "aria-live": unref(props).feedbackAriaLive,
                state: computedState.value,
                tooltip: unref(props).tooltip
              }, {
                default: withCtx(() => [
                  renderSlot(_ctx.$slots, "invalid-feedback", {}, () => [
                    createTextVNode(toDisplayString(unref(props).invalidFeedback), 1)
                  ])
                ]),
                _: 3
              }, 8, ["id", "aria-live", "state", "tooltip"])) : createCommentVNode("", true),
              slots["valid-feedback"] || unref(props).validFeedback ? (openBlock(), createBlock(_sfc_main$2, {
                key: 1,
                id: unref(validFeedbackId),
                "aria-live": unref(props).feedbackAriaLive,
                state: computedState.value,
                tooltip: unref(props).tooltip
              }, {
                default: withCtx(() => [
                  renderSlot(_ctx.$slots, "valid-feedback", {}, () => [
                    createTextVNode(toDisplayString(unref(props).validFeedback), 1)
                  ])
                ]),
                _: 3
              }, 8, ["id", "aria-live", "state", "tooltip"])) : createCommentVNode("", true),
              slots.description || unref(props).description ? (openBlock(), createBlock(_sfc_main$3, {
                key: 2,
                id: unref(descriptionId)
              }, {
                default: withCtx(() => [
                  renderSlot(_ctx.$slots, "description", {}, () => [
                    createTextVNode(toDisplayString(unref(props).description), 1)
                  ])
                ]),
                _: 3
              }, 8, ["id"])) : createCommentVNode("", true)
            ]),
            _: 3
          }),
          createVNode(unref(LabelContentTemplate).define, null, {
            default: withCtx(() => [
              slots.label || unref(props).label || isHorizontal.value ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                isHorizontal.value ? (openBlock(), createBlock(_sfc_main$4, normalizeProps(mergeProps({ key: 0 }, labelColProps.value)), {
                  default: withCtx(() => [
                    (openBlock(), createBlock(resolveDynamicComponent(labelTag.value), {
                      id: unref(labelId),
                      for: computedLabelFor.value || null,
                      tabindex: isFieldset.value ? "-1" : null,
                      class: normalizeClass(labelClasses.value),
                      onClick: _cache[0] || (_cache[0] = ($event) => isFieldset.value ? onLegendClick : null)
                    }, {
                      default: withCtx(() => [
                        renderSlot(_ctx.$slots, "label", {}, () => [
                          createTextVNode(toDisplayString(unref(props).label), 1)
                        ])
                      ]),
                      _: 3
                    }, 8, ["id", "for", "tabindex", "class"]))
                  ]),
                  _: 3
                }, 16)) : (openBlock(), createBlock(resolveDynamicComponent(labelTag.value), {
                  key: 1,
                  id: unref(labelId),
                  for: computedLabelFor.value || null,
                  tabindex: isFieldset.value ? "-1" : null,
                  class: normalizeClass(labelClasses.value),
                  onClick: _cache[1] || (_cache[1] = ($event) => isFieldset.value ? onLegendClick : null)
                }, {
                  default: withCtx(() => [
                    renderSlot(_ctx.$slots, "label", {}, () => [
                      createTextVNode(toDisplayString(unref(props).label), 1)
                    ])
                  ]),
                  _: 3
                }, 8, ["id", "for", "tabindex", "class"]))
              ], 64)) : createCommentVNode("", true)
            ]),
            _: 3
          }),
          isHorizontal.value ? (openBlock(), createBlock(_sfc_main$5, { key: 0 }, {
            default: withCtx(() => [
              createVNode(unref(LabelContentTemplate).reuse),
              createVNode(_sfc_main$4, mergeProps(contentColProps.value, { ref: "_content" }), {
                default: withCtx(() => [
                  renderSlot(_ctx.$slots, "default", {
                    id: unref(computedId),
                    ariaDescribedby: null,
                    descriptionId: unref(descriptionId),
                    labelId: unref(labelId)
                  }),
                  createVNode(unref(ContentTemplate).reuse)
                ]),
                _: 3
              }, 16)
            ]),
            _: 3
          })) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
            unref(props).floating && !isHorizontal.value ? (openBlock(), createElementBlock("div", _hoisted_1, [
              renderSlot(_ctx.$slots, "default", {
                id: unref(computedId),
                ariaDescribedby: null,
                descriptionId: unref(descriptionId),
                labelId: unref(labelId)
              }),
              createVNode(unref(LabelContentTemplate).reuse),
              createVNode(unref(ContentTemplate).reuse)
            ], 512)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
              createVNode(unref(LabelContentTemplate).reuse),
              renderSlot(_ctx.$slots, "default", {
                id: unref(computedId),
                ariaDescribedby: null,
                descriptionId: unref(descriptionId),
                labelId: unref(labelId)
              }),
              createVNode(unref(ContentTemplate).reuse)
            ], 64))
          ], 64))
        ]),
        _: 3
      }, 8, ["id", "disabled", "role", "aria-invalid", "aria-labelledby", "class"]);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BFormGroup.vue_vue_type_script_setup_true_lang-DLyoQAHF.mjs.map
