import { defineComponent, mergeModels, useModel, useTemplateRef, computed, createElementBlock, openBlock, unref, normalizeClass } from "vue";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { n as normalizeInput, u as useFormInput } from "./useFormInput-Dru3Y8-y.mjs";
const _hoisted_1 = ["id", "value", "name", "form", "type", "disabled", "placeholder", "required", "autocomplete", "readonly", "min", "max", "step", "list", "aria-required", "aria-invalid"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BFormInput",
  props: /* @__PURE__ */ mergeModels({
    max: { default: void 0 },
    min: { default: void 0 },
    step: { default: void 0 },
    type: { default: "text" },
    ariaInvalid: { type: [Boolean, String], default: void 0 },
    autocomplete: { default: void 0 },
    autofocus: { type: Boolean, default: false },
    disabled: { type: Boolean, default: false },
    form: { default: void 0 },
    formatter: { type: Function, default: void 0 },
    id: { default: void 0 },
    lazyFormatter: { type: Boolean, default: false },
    list: { default: void 0 },
    name: { default: void 0 },
    placeholder: { default: void 0 },
    plaintext: { type: Boolean, default: false },
    readonly: { type: Boolean, default: false },
    required: { type: Boolean, default: false },
    size: { default: void 0 },
    state: { type: [Boolean, null], default: void 0 },
    debounce: { default: 0 },
    debounceMaxWait: { default: NaN }
  }, {
    "modelValue": {
      default: ""
    },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props, { expose: __expose }) {
    const _props = __props;
    const props = useDefaults(_props, "BFormInput");
    const [modelValue, modelModifiers] = useModel(__props, "modelValue", {
      set: (v) => normalizeInput(v, modelModifiers)
    });
    const input = useTemplateRef("_input");
    const {
      computedId,
      computedAriaInvalid,
      onInput,
      onChange,
      onBlur,
      stateClass,
      focus,
      blur,
      forceUpdateKey
    } = useFormInput(props, input, modelValue, modelModifiers);
    const computedClasses = computed(() => {
      const isRange = props.type === "range";
      const isColor = props.type === "color";
      return [
        stateClass.value,
        {
          "form-range": isRange,
          "form-control": isColor || !props.plaintext && !isRange,
          "form-control-color": isColor,
          "form-control-plaintext": props.plaintext && !isRange && !isColor,
          [`form-control-${props.size}`]: !!props.size
        }
      ];
    });
    __expose({
      blur,
      element: input,
      focus
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("input", {
        id: unref(computedId),
        ref: "_input",
        key: unref(forceUpdateKey),
        value: unref(modelValue),
        class: normalizeClass(computedClasses.value),
        name: unref(props).name || void 0,
        form: unref(props).form || void 0,
        type: unref(props).type,
        disabled: unref(props).disabled,
        placeholder: unref(props).placeholder,
        required: unref(props).required || void 0,
        autocomplete: unref(props).autocomplete || void 0,
        readonly: unref(props).readonly || unref(props).plaintext,
        min: unref(props).min,
        max: unref(props).max,
        step: unref(props).step,
        list: unref(props).type !== "password" ? unref(props).list : void 0,
        "aria-required": unref(props).required || void 0,
        "aria-invalid": unref(computedAriaInvalid),
        onInput: _cache[0] || (_cache[0] = //@ts-ignore
        (...args) => unref(onInput) && unref(onInput)(...args)),
        onChange: _cache[1] || (_cache[1] = //@ts-ignore
        (...args) => unref(onChange) && unref(onChange)(...args)),
        onBlur: _cache[2] || (_cache[2] = //@ts-ignore
        (...args) => unref(onBlur) && unref(onBlur)(...args))
      }, null, 42, _hoisted_1);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BFormInput.vue_vue_type_script_setup_true_lang-C7CJb3fs.mjs.map
