import { computed, toValue, defineComponent, provide, toRef, createBlock, openBlock, resolveDynamicComponent, unref, normalizeClass, withCtx, createElementBlock, renderSlot, mergeProps, inject, createElementVNode } from "vue";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { x as navbarInjectionKey, g as globalShowHideStorageInjectionKey } from "./keys-CwytVEYF.mjs";
import { u as useColorVariantClasses } from "./useColorVariantClasses-ZDE19TZw.mjs";
import { u as useBLinkHelper, _ as _sfc_main$4 } from "./BLink.vue_vue_type_script_setup_true_lang-Crq1j_mE.mjs";
import { u as useAlignment } from "./useAlignment-Cw-9AVid.mjs";
const useContainerClasses = (value) => computed(() => {
  const resolvedValue = toValue(value);
  return {
    container: resolvedValue === true,
    [`container-${resolvedValue}`]: typeof resolvedValue === "string"
  };
});
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "BNavbar",
  props: {
    autoClose: { type: Boolean, default: true },
    container: { type: [Boolean, String], default: "fluid" },
    fixed: { default: void 0 },
    print: { type: Boolean, default: false },
    sticky: { default: void 0 },
    tag: { default: "nav" },
    toggleable: { type: [Boolean, String], default: false },
    variant: { default: null }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BNavbar");
    const computedRole = computed(() => props.tag === "nav" ? void 0 : "navigation");
    const containerClass = useContainerClasses(() => props.container);
    const colorClasses = useColorVariantClasses(
      computed(() => ({
        bgVariant: props.variant
      }))
    );
    const computedClasses = computed(() => [
      colorClasses.value,
      {
        "d-print": props.print,
        [`sticky-${props.sticky}`]: props.sticky !== void 0,
        [`fixed-${props.fixed}`]: props.fixed !== void 0,
        "navbar-expand": props.toggleable === false,
        [`navbar-expand-${props.toggleable}`]: typeof props.toggleable === "string"
      }
    ]);
    provide(navbarInjectionKey, {
      tag: toRef(() => props.tag),
      autoClose: toRef(() => props.autoClose)
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
        class: normalizeClass(["navbar", computedClasses.value]),
        role: computedRole.value
      }, {
        default: withCtx(() => [
          unref(props).container !== false ? (openBlock(), createElementBlock("div", {
            key: 0,
            class: normalizeClass(unref(containerClass))
          }, [
            renderSlot(_ctx.$slots, "default")
          ], 2)) : renderSlot(_ctx.$slots, "default", { key: 1 })
        ]),
        _: 3
      }, 8, ["class", "role"]);
    };
  }
});
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "BNavbarBrand",
  props: {
    tag: { default: "div" },
    active: { type: Boolean, default: void 0 },
    activeClass: { default: void 0 },
    disabled: { type: Boolean, default: void 0 },
    exactActiveClass: { default: void 0 },
    href: { default: void 0 },
    icon: { type: Boolean, default: void 0 },
    noRel: { type: Boolean },
    opacity: { default: void 0 },
    opacityHover: { default: void 0 },
    prefetch: { type: Boolean },
    prefetchOn: {},
    noPrefetch: { type: Boolean },
    prefetchedClass: {},
    rel: { default: void 0 },
    replace: { type: Boolean, default: void 0 },
    routerComponentName: { default: void 0 },
    stretched: { type: Boolean, default: false },
    target: { default: void 0 },
    to: { default: void 0 },
    underlineOffset: { default: void 0 },
    underlineOffsetHover: { default: void 0 },
    underlineOpacity: { default: void 0 },
    underlineOpacityHover: { default: void 0 },
    underlineVariant: { default: void 0 },
    variant: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BNavbarBrand");
    const { computedLink, computedLinkProps } = useBLinkHelper(props, [
      "active",
      "activeClass",
      "append",
      "disabled",
      "href",
      "rel",
      "replace",
      "routerComponentName",
      "target",
      "to",
      "variant",
      "opacity",
      "opacityHover",
      "underlineVariant",
      "underlineOffset",
      "underlineOffsetHover",
      "underlineOpacity",
      "underlineOpacityHover",
      "icon"
    ]);
    const computedTag = computed(() => computedLink.value ? _sfc_main$4 : props.tag);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(computedTag.value), mergeProps({ class: "navbar-brand" }, unref(computedLinkProps)), {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 16);
    };
  }
});
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BNavbarNav",
  props: {
    align: { default: void 0 },
    fill: { type: Boolean, default: false },
    justified: { type: Boolean, default: false },
    small: { type: Boolean, default: false },
    tag: { default: "ul" }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BNavbarNav");
    const alignment = useAlignment(() => props.align);
    const computedClasses = computed(() => ({
      "nav-fill": props.fill,
      "nav-justified": props.justified,
      [alignment.value]: props.align !== void 0,
      "small": props.small
    }));
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("ul", {
        class: normalizeClass(["navbar-nav", computedClasses.value])
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 2);
    };
  }
});
const _hoisted_1 = ["disabled", "aria-label"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BNavbarToggle",
  props: {
    disabled: { type: Boolean, default: false },
    label: { default: "Toggle navigation" },
    target: { default: void 0 }
  },
  emits: ["click"],
  setup(__props, { emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BNavbarToggle");
    const emit = __emit;
    const computedClasses = computed(() => ({
      disabled: props.disabled
    }));
    const showHideData = inject(globalShowHideStorageInjectionKey, void 0);
    const collapseExpanded = computed(() => {
      var _a;
      if (!props.target || !showHideData) return false;
      if (typeof props.target === "string")
        return toValue((_a = toValue(showHideData.values.value.get(props.target))) == null ? void 0 : _a.value) || false;
      return props.target.some((target) => {
        var _a2;
        return toValue((_a2 = showHideData.values.value.get(target)) == null ? void 0 : _a2.value);
      });
    });
    const toggleExpand = () => {
      var _a;
      if (!props.target || !showHideData) return;
      if (typeof props.target === "string") {
        (_a = toValue(showHideData.values.value.get(props.target))) == null ? void 0 : _a.toggle();
        return;
      }
      props.target.forEach((target) => {
        var _a2;
        return (_a2 = toValue(showHideData.values.value.get(target))) == null ? void 0 : _a2.toggle();
      });
    };
    const onClick = (e) => {
      if (!props.disabled) {
        emit("click", e);
        toggleExpand();
      }
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("button", {
        class: normalizeClass(["navbar-toggler", computedClasses.value]),
        type: "button",
        disabled: unref(props).disabled,
        "aria-label": unref(props).label,
        onClick
      }, [
        renderSlot(_ctx.$slots, "default", { expanded: collapseExpanded.value }, () => [
          _cache[0] || (_cache[0] = createElementVNode("span", { class: "navbar-toggler-icon" }, null, -1))
        ])
      ], 10, _hoisted_1);
    };
  }
});
export {
  _sfc_main$3 as _,
  _sfc_main$2 as a,
  _sfc_main$1 as b,
  _sfc_main as c
};
//# sourceMappingURL=BNavbarToggle.vue_vue_type_script_setup_true_lang-BKfzvgvU.mjs.map
