import { defineComponent, computed, createBlock, openBlock, resolveDynamicComponent, unref, normalizeClass, withCtx, renderSlot } from "vue";
import { g as getClasses } from "./getClasses-CsgNQabU.mjs";
import { u as useAlignment } from "./useAlignment-Cw-9AVid.mjs";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BRow",
  props: {
    tag: { default: "div" },
    gutterX: { default: void 0 },
    gutterY: { default: void 0 },
    noGutters: { type: Boolean, default: false },
    alignV: { default: void 0 },
    alignH: { default: void 0 },
    alignContent: { default: void 0 },
    cols: { default: void 0 },
    colsSm: { default: void 0 },
    colsMd: { default: void 0 },
    colsLg: { default: void 0 },
    colsXl: { default: void 0 },
    colsXxl: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BRow");
    const alignment = useAlignment(() => props.alignH);
    const rowColsClasses = computed(
      () => getClasses(
        {
          cols: props.cols,
          colsLg: props.colsLg,
          colsMd: props.colsMd,
          colsSm: props.colsSm,
          colsXl: props.colsXl,
          colsXxl: props.colsXxl
        },
        ["cols", "colsLg", "colsMd", "colsSm", "colsXl", "colsXxl"],
        "cols",
        "row-cols"
      )
    );
    const computedClasses = computed(() => [
      rowColsClasses.value,
      {
        [`gx-${props.gutterX}`]: props.gutterX !== void 0,
        [`gy-${props.gutterY}`]: props.gutterY !== void 0,
        "g-0": props.noGutters,
        [`align-items-${props.alignV}`]: props.alignV !== void 0,
        [alignment.value]: props.alignH !== void 0,
        [`align-content-${props.alignContent}`]: props.alignContent !== void 0
      }
    ]);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
        class: normalizeClass(["row", computedClasses.value])
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 8, ["class"]);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BRow.vue_vue_type_script_setup_true_lang-B2V7AEcP.mjs.map
