var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
class BvEvent {
  constructor(eventType, eventInit = {}) {
    __publicField(this, "cancelable", true);
    __publicField(this, "componentId", null);
    __publicField(this, "_defaultPrevented", false);
    __publicField(this, "eventType", "");
    __publicField(this, "nativeEvent", null);
    __publicField(this, "_preventDefault");
    __publicField(this, "relatedTarget", null);
    __publicField(this, "target", null);
    if (!eventType) {
      throw new TypeError(
        `Failed to construct '${this.constructor.name}'. 1 argument required, ${arguments.length} given.`
      );
    }
    Object.assign(this, BvEvent.Defaults, eventInit, { eventType });
    this._preventDefault = function _preventDefault() {
      if (this.cancelable) {
        this.defaultPrevented = true;
      }
    };
  }
  // Readable by everyone,
  // But only overwritten by inherrited constructors
  get defaultPrevented() {
    return this._defaultPrevented;
  }
  set defaultPrevented(prop) {
    this._defaultPrevented = prop;
  }
  // I think this is right
  // We want to be able to have it callable to everyone,
  // But only overwritten by inherrited constructors
  get preventDefault() {
    return this._preventDefault;
  }
  // This may not be correct, because it doesn't get correct type inferences in children
  // Ex overwrite this.preventDefault = () => true is valid. Could be a TS issue
  set preventDefault(setter) {
    this._preventDefault = setter;
  }
  static get Defaults() {
    return {
      cancelable: true,
      componentId: null,
      eventType: "",
      nativeEvent: null,
      relatedTarget: null,
      target: null
    };
  }
}
class BvTriggerableEvent extends BvEvent {
  constructor(eventType, eventInit = {}) {
    super(eventType, eventInit);
    __publicField(this, "trigger", null);
    __publicField(this, "ok");
    Object.assign(this, BvEvent.Defaults, eventInit, { eventType });
  }
  static get Defaults() {
    return {
      ...super.Defaults,
      trigger: null,
      ok: void 0
    };
  }
}
class BvCarouselEvent extends BvEvent {
  constructor(eventType, eventInit) {
    super(eventType, eventInit);
    __publicField(this, "from");
    __publicField(this, "to");
    __publicField(this, "direction");
    Object.assign(this, BvEvent.Defaults, eventInit, { eventType });
    const { from, direction, to } = eventInit;
    this.from = from;
    this.to = to;
    this.direction = direction;
  }
  static get Defaults() {
    return {
      ...super.Defaults
    };
  }
}
export {
  BvEvent as B,
  BvTriggerableEvent as a,
  BvCarouselEvent as b
};
//# sourceMappingURL=classes-B4vxmOuN.mjs.map
