import { R as RX_SPACE_SPLIT, d as RX_HASH_ID, e as RX_HASH } from "../../../constants-DameGf19.mjs";
import { toValue } from "vue";
import { f as findProvides } from "../../../utils-DPq73bs8.mjs";
import { g as globalShowHideStorageInjectionKey } from "../../../keys-CwytVEYF.mjs";
const getTargets = (binding, el) => {
  const { modifiers, arg, value } = binding;
  const targets = Object.keys(modifiers || {});
  const localValue = typeof value === "string" ? value.split(RX_SPACE_SPLIT) : value;
  if (el.tagName.toLowerCase() === "a") {
    const href = el.getAttribute("href") || "";
    if (RX_HASH_ID.test(href)) {
      targets.push(href.replace(RX_HASH, ""));
    }
  }
  Array.prototype.concat.apply([], [arg, localValue]).forEach((t) => typeof t === "string" && targets.push(t));
  return targets.filter((t, index, arr) => t && arr.indexOf(t) === index);
};
const handleUpdate = (el, binding, vnode) => {
  var _a;
  const targets = getTargets(binding, el);
  if (targets.length === 0) return;
  const provides = findProvides(binding, vnode);
  const showHideMap = (_a = provides[globalShowHideStorageInjectionKey]) == null ? void 0 : _a.values;
  if (el.dataset.bvtoggle) {
    const oldTargets = (el.dataset.bvtoggle || "").split(" ");
    if (oldTargets.length === 0) return;
    for (const targetId of oldTargets) {
      const showHide = showHideMap == null ? void 0 : showHideMap.value.get(targetId);
      if (!showHide) {
        continue;
      }
      if (!targets.includes(targetId)) {
        toValue(showHide).unregisterTrigger("click", el, false);
      }
    }
  }
  el.dataset.bvtoggle = targets.join(" ");
  targets.forEach(async (targetId) => {
    let count = 0;
    while (count < 5) {
      const showHide = showHideMap == null ? void 0 : showHideMap.value.get(targetId);
      if (!showHide) {
        count++;
        await new Promise((resolve) => setTimeout(resolve, 100));
        if (count < 4) continue;
        console.warn(`[v-b-toggle] Target with ID ${targetId} not found`);
        break;
      }
      toValue(showHide).unregisterTrigger("click", el, false);
      toValue(showHide).registerTrigger("click", el);
      break;
    }
  });
  el.setAttribute("aria-controls", targets.join(" "));
};
const handleUnmount = (el, binding, vnode) => {
  var _a;
  const targets = getTargets(binding, el);
  if (targets.length === 0) return;
  const provides = findProvides(binding, vnode);
  const showHideMap = (_a = provides[globalShowHideStorageInjectionKey]) == null ? void 0 : _a.values;
  targets.forEach((targetId) => {
    const showHide = showHideMap == null ? void 0 : showHideMap.value.get(targetId);
    if (!showHide) {
      return;
    }
    toValue(showHide).unregisterTrigger("click", el, false);
  });
  el.removeAttribute("aria-controls");
  el.removeAttribute("aria-expanded");
  el.classList.remove("collapsed");
  el.classList.remove("not-collapsed");
  delete el.dataset.bvtoggle;
};
const vBToggle = {
  mounted: handleUpdate,
  updated: handleUpdate,
  unmounted: handleUnmount
};
export {
  vBToggle
};
//# sourceMappingURL=index.mjs.map
