import { ref, toValue, isRef, markRaw, toRef, watch, isReadonly, onScopeDispose, nextTick } from "vue";
import { p as popoverPluginKey } from "../../../keys-CwytVEYF.mjs";
const popoverPlugin = {
  install(app) {
    const _isOrchestratorInstalled = ref(false);
    const popovers = ref(
      /* @__PURE__ */ new Map()
    );
    const buildPromise = (_id, store) => {
      let resolveFunc = () => {
      };
      const promise = new Promise((resolve) => {
        resolveFunc = resolve;
      });
      Object.assign(promise, {
        id: _id,
        ref: null,
        show() {
          if (!this.ref) return this.set({ modelValue: true });
          this.ref.show();
          return promise;
        },
        hide(trigger) {
          if (!this.ref) return this.set({ modelValue: false });
          this.ref.hide(trigger, true);
          return promise;
        },
        toggle() {
          var _a;
          if (!this.ref) return this.set({ modelValue: !((_a = this.get()) == null ? void 0 : _a.modelValue) });
          this.ref.toggle();
          return promise;
        },
        get() {
          return store.value.get(_id);
        },
        set(val) {
          var _a;
          const item = store.value.get(_id);
          if (item) {
            const v = { ...toValue(item), ...toValue(val) };
            if (item.modelValue !== v.modelValue) {
              (_a = item["onUpdate:modelValue"]) == null ? void 0 : _a.call(item, v.modelValue);
            }
            store.value.set(_id, {
              ...v,
              title: toValue(v.title),
              body: toValue(v.body),
              modelValue: toValue(v.modelValue)
            });
          }
          return promise;
        },
        async destroy() {
          var _a, _b;
          const item = store.value.get(_id);
          if (!item) return;
          (_b = (_a = item.promise).stop) == null ? void 0 : _b.call(_a);
          if (item.modelValue) {
            await new Promise((resolve) => {
              item.modelValue = false;
              const prev = item["onHidden"];
              item["onHidden"] = (e) => {
                prev == null ? void 0 : prev(e);
                resolve(e);
              };
              nextTick(() => {
                var _a2;
                (_a2 = item["onUpdate:modelValue"]) == null ? void 0 : _a2.call(item, false);
              });
            });
          }
          store.value.delete(_id);
        },
        async [Symbol.asyncDispose]() {
          await this.destroy();
        }
      });
      return {
        value: promise,
        resolve: resolveFunc
      };
    };
    const create = (obj, tooltip2) => {
      var _a;
      if (!_isOrchestratorInstalled.value) {
        throw new Error(
          "The BPopoverOrchestrator component must be mounted to use the popover controller"
        );
      }
      const { component, slots } = toValue(obj);
      if (component) {
        if (isRef(obj)) obj.value.component = markRaw(component);
        else if (typeof obj === "object") obj.component = markRaw(component);
      }
      if (slots) {
        if (isRef(obj)) obj.value.slots = markRaw(slots);
        else if (typeof obj === "object") obj.slots = markRaw(slots);
      }
      const resolvedProps = toRef(obj);
      const _self = ((_a = resolvedProps.value) == null ? void 0 : _a.id) || Symbol("Popover controller");
      const promise = buildPromise(_self, popovers);
      promise.stop = watch(
        resolvedProps,
        (_newValue) => {
          const newValue = { ...toValue(_newValue) };
          const previous = popovers.value.get(_self);
          const v = {
            ...previous || {}
          };
          for (const key in newValue) {
            if (key.startsWith("on")) {
              v[key] = newValue[key];
            } else {
              v[key] = toValue(
                newValue[key]
              );
            }
          }
          popovers.value.set(_self, {
            ...v,
            ...v.modelValue === void 0 && { modelValue: false },
            "onUpdate:modelValue": (val) => {
              var _a2;
              (_a2 = newValue["onUpdate:modelValue"]) == null ? void 0 : _a2.call(newValue, val);
              const { modelValue } = toValue(obj);
              if (isRef(obj) && !isRef(modelValue)) obj.value.modelValue = val;
              if (isRef(modelValue) && !isReadonly(modelValue)) {
                modelValue.value = val;
              }
              if (v.modelValue !== val) {
                const popover2 = popovers.value.get(_self);
                if (popover2) {
                  popover2.modelValue = val;
                }
              }
            },
            tooltip: tooltip2,
            promise
          });
        },
        {
          immediate: true,
          deep: true
        }
      );
      onScopeDispose(() => {
        var _a2, _b;
        const popover2 = popovers.value.get(_self);
        if (popover2) {
          (_b = (_a2 = popover2.promise.value).destroy) == null ? void 0 : _b.call(_a2);
        }
      }, true);
      return promise.value;
    };
    const tooltip = (obj) => create(obj, true);
    const popover = (obj) => create(obj, false);
    app.provide(popoverPluginKey, {
      _isOrchestratorInstalled,
      popovers,
      tooltip,
      popover
    });
  }
};
export {
  popoverPlugin
};
//# sourceMappingURL=index.mjs.map
