import { ref, readonly } from "vue";
import { g as globalShowHideStorageInjectionKey } from "../../../keys-CwytVEYF.mjs";
const showHidePlugin = {
  install(app) {
    const values = ref(/* @__PURE__ */ new Map());
    const register = ({
      id,
      component,
      value,
      toggle,
      show,
      hide,
      registerTrigger,
      unregisterTrigger
    }) => {
      values.value.set(id, {
        id,
        component,
        value: readonly(value),
        toggle,
        show,
        hide,
        registerTrigger,
        unregisterTrigger
      });
      return {
        unregister() {
          values.value.delete(id);
        },
        updateId(newId, oldId) {
          const existingValue = values.value.get(oldId);
          if (existingValue) {
            values.value.set(newId, { ...existingValue, id: newId });
            values.value.delete(oldId);
          }
        }
      };
    };
    app.provide(globalShowHideStorageInjectionKey, { register, values });
  }
};
export {
  showHidePlugin
};
//# sourceMappingURL=index.mjs.map
