import { ref, toValue, isRef, markRaw, toRef, watch, isReadonly, onScopeDispose, nextTick } from "vue";
import { t as toastPluginKey } from "../../../keys-CwytVEYF.mjs";
const posDefault = "top-end";
const toastPlugin = {
  install(app) {
    const toasts = ref([]);
    const _isAppend = ref(false);
    const buildPromise = (_id) => {
      let resolveFunc = () => {
      };
      const promise = new Promise((resolve) => {
        resolveFunc = resolve;
      });
      Object.assign(promise, {
        id: _id,
        ref: null,
        show() {
          if (!this.ref) return this.set({ modelValue: true });
          this.ref.show();
          return promise;
        },
        hide(trigger) {
          if (!this.ref) return this.set({ modelValue: false });
          this.ref.hide(trigger, true);
          return promise;
        },
        toggle() {
          var _a;
          if (!this.ref) return this.set({ modelValue: !((_a = this.get()) == null ? void 0 : _a.modelValue) });
          this.ref.toggle();
          return promise;
        },
        get() {
          return toasts.value.find((el) => el._self === _id);
        },
        set(val) {
          var _a;
          const toastIndex = toasts.value.findIndex((el) => el._self === _id);
          const toast = toasts.value[toastIndex];
          if (toast) {
            const v = { ...toValue(toast), ...toValue(val) };
            if (toast.modelValue !== v.modelValue) {
              (_a = toast["onUpdate:modelValue"]) == null ? void 0 : _a.call(toast, v.modelValue);
            }
            toasts.value.splice(toastIndex, 1, {
              ...v,
              title: toValue(v.title),
              body: toValue(v.body),
              modelValue: toValue(v.modelValue)
            });
          }
          return promise;
        },
        async destroy() {
          var _a, _b;
          const toast = toasts.value.find((el) => el._self === _id);
          if (!toast) return;
          (_b = (_a = toast.promise).stop) == null ? void 0 : _b.call(_a);
          if (toast.modelValue) {
            await new Promise((resolve) => {
              const prev = toast["onHidden"];
              toast["onHidden"] = (e) => {
                prev == null ? void 0 : prev(e);
                resolve(e);
              };
              nextTick(() => {
                this.hide("destroy");
              });
            });
          }
          toasts.value.splice(
            toasts.value.findIndex((el) => el._self === _id),
            1
          );
        },
        async [Symbol.asyncDispose]() {
          await this.destroy();
        }
      });
      return {
        value: promise,
        resolve: resolveFunc
      };
    };
    const create = (obj = {}, options = {}) => {
      var _a;
      const { component, slots } = toValue(obj);
      if (component) {
        if (isRef(obj)) obj.value.component = markRaw(component);
        else if (typeof obj === "object") obj.component = markRaw(component);
      }
      if (slots) {
        if (isRef(obj)) obj.value.slots = markRaw(slots);
        else if (typeof obj === "object") obj.slots = markRaw(slots);
      }
      const resolvedProps = toRef(obj);
      const _self = ((_a = resolvedProps.value) == null ? void 0 : _a.id) || Symbol("Toast controller");
      const promise = buildPromise(_self);
      promise.stop = watch(
        resolvedProps,
        (_newValue) => {
          var _a2;
          const newValue = { ...toValue(_newValue) };
          const previousIndex = toasts.value.findIndex((el) => el._self === _self);
          const previous = previousIndex === -1 ? {} : toasts.value[previousIndex];
          const v = {
            _self,
            ...previous || {},
            promise,
            options
          };
          if (newValue.props) {
            Object.assign(v, newValue.props);
            newValue.props = void 0;
          }
          if (newValue.pos) {
            v.position = newValue.pos;
            newValue.pos = void 0;
          }
          for (const key in newValue) {
            if (key.startsWith("on")) {
              v[key] = newValue[key];
            } else {
              v[key] = toValue(
                newValue[key]
              );
            }
          }
          v.position = v.position || posDefault;
          v.modelValue = v.modelValue ?? 5e3;
          v["onUpdate:modelValue"] = (val) => {
            var _a3;
            (_a3 = newValue["onUpdate:modelValue"]) == null ? void 0 : _a3.call(newValue, val);
            const { modelValue } = toValue(obj);
            if (isRef(obj) && !isRef(modelValue)) obj.value.modelValue = val;
            if (isRef(modelValue) && !isReadonly(modelValue)) {
              modelValue.value = val;
            }
            if (v.modelValue !== val) {
              const toast = toasts.value.find((el) => el._self === _self);
              if (toast) {
                toast.modelValue = val;
              }
            }
          };
          if (previousIndex === -1) {
            if (((_a2 = resolvedProps.value) == null ? void 0 : _a2.appendToast) !== void 0 ? resolvedProps.value.appendToast : _isAppend.value) {
              toasts.value.push(v);
            } else {
              toasts.value.unshift(v);
            }
          } else {
            toasts.value.splice(previousIndex, 1, v);
          }
        },
        {
          deep: true,
          immediate: true
        }
      );
      onScopeDispose(() => {
        var _a2, _b;
        const toast = toasts.value.find((el) => el._self === _self);
        if (toast) {
          (_b = (_a2 = toast.promise.value).destroy) == null ? void 0 : _b.call(_a2);
        }
      }, true);
      return promise.value;
    };
    const show = (obj = {}) => {
      console.warn(
        "[BootstrapVueNext] useToastController: The `show` method is deprecated. Use the `create` method instead."
      );
      return create(obj);
    };
    app.provide(toastPluginKey, {
      _isAppend,
      _isOrchestratorInstalled: ref(false),
      toasts,
      create,
      show
    });
  }
};
export {
  toastPlugin
};
//# sourceMappingURL=index.mjs.map
