import { computed, toValue } from "vue";
const useColorVariantClasses = (obj) => computed(() => {
  let props = toValue(obj);
  props = {
    variant: props.variant ?? null,
    bgVariant: props.bgVariant ?? null,
    textVariant: props.textVariant ?? null,
    borderVariant: props.borderVariant ?? null
  };
  return {
    [`text-bg-${props.variant}`]: props.variant !== null,
    [`text-${props.textVariant}`]: props.textVariant !== null,
    [`bg-${props.bgVariant}`]: props.bgVariant !== null,
    [`border-${props.borderVariant}`]: props.borderVariant !== null
  };
});
export {
  useColorVariantClasses as u
};
//# sourceMappingURL=useColorVariantClasses-ZDE19TZw.mjs.map
