import { computed, toValue } from "vue";
const useRadiusElementClasses = (obj) => {
  const resolveRadiusElement = (value, str) => {
    const strValue = str === null ? "" : `-${str}`;
    return value === "circle" ? `rounded${strValue}-circle` : value === "pill" ? `rounded${strValue}-pill` : typeof value === "number" || value === "0" || value === "1" || value === "2" || value === "3" || value === "4" || value === "5" ? `rounded${strValue}-${value}` : value === "none" ? `rounded${strValue}-0` : value === "sm" ? `rounded${strValue}-1` : value === "lg" ? `rounded${strValue}-5` : `rounded${strValue}`;
  };
  return computed(() => {
    const props = toValue(obj);
    return {
      [`${resolveRadiusElement(props.rounded, null)}`]: !!props.rounded,
      [`${resolveRadiusElement(props.roundedTop, "top")}`]: !!props.roundedTop,
      [`${resolveRadiusElement(props.roundedBottom, "bottom")}`]: !!props.roundedBottom,
      [`${resolveRadiusElement(props.roundedStart, "start")}`]: !!props.roundedStart,
      [`${resolveRadiusElement(props.roundedEnd, "end")}`]: !!props.roundedEnd
    };
  });
};
export {
  useRadiusElementClasses as u
};
//# sourceMappingURL=useRadiusElementClasses-DtKYQuWz.mjs.map
